/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.tizen.ssilib.SSIRule;
import org.tizen.ssilib.SSIRuleOp;

public class SSIFileSet {
    public String name;
    public String type;
    public String category;
    public List<FileEntry> fileEntrys = new ArrayList<FileEntry>();

    public SSIFileSet() {
    }

    public SSIFileSet(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void addFileEntry(FileEntry fileEntry) {
        this.fileEntrys.add(fileEntry);
    }

    public FileEntry addFileEntry(String[] type, String src, String des, String[] attrs) {
        FileEntry fileentry = new FileEntry(type, src, des, attrs);
        this.fileEntrys.add(fileentry);
        return fileentry;
    }

    public List<FileEntry> getFileEntrys() {
        return this.fileEntrys;
    }

    public Collection<FileEntry> getMatchFileEntrys(String ruleTarget, List<SSIRuleOp> ruleOps) {
        if (ruleOps == null) {
            return this.fileEntrys;
        }
        ArrayList<FileEntry> list = null;
        for (FileEntry entry : this.fileEntrys) {
            boolean match = false;
            for (SSIRuleOp ruleOp : ruleOps) {
                String lt = ruleOp.getLt();
                boolean m = false;
                if (lt.equals("type")) {
                    m = ruleOp.isMatch(entry.types);
                } else if (lt.equals("src")) {
                    m = ruleOp.isMatch(entry.src);
                } else if (lt.equals("des")) {
                    m = ruleOp.isMatch(entry.des);
                }
                if (ruleOp.baseOp == SSIRuleOp.OP_NONE) {
                    match = m;
                    continue;
                }
                if (ruleOp.baseOp == SSIRuleOp.OP_AND && !m) {
                    match = m;
                    break;
                }
                if (ruleOp.baseOp != SSIRuleOp.OP_OR || !m) continue;
                match = m;
            }
            if (!match) continue;
            if (list == null) {
                list = new ArrayList<FileEntry>();
            }
            list.add(entry);
        }
        return list;
    }

    public static Collection<SSIFileSet> getMatchFileSet(Map<String, SSIFileSet> filesetMap, String ruleTarget, List<SSIRuleOp> ruleOps) {
        if (ruleTarget == null && ruleOps == null) {
            return filesetMap.values();
        }
        Collection<SSIFileSet> filesets0 = null;
        if (ruleTarget == null || ruleTarget.equals("*")) {
            filesets0 = filesetMap.values();
        } else {
            SSIFileSet fileSet = filesetMap.get(ruleTarget);
            if (fileSet != null) {
                filesets0 = new ArrayList<SSIFileSet>();
                filesets0.add(fileSet);
            }
        }
        if (filesets0 == null) {
            return null;
        }
        Collection<SSIFileSet> filesets = null;
        if (ruleOps == null) {
            filesets = filesets0;
        } else {
            for (SSIFileSet fileset : filesets0) {
                boolean match = false;
                for (SSIRuleOp ruleOp : ruleOps) {
                    String lt = ruleOp.getLt();
                    boolean m = false;
                    if (lt.equals("type")) {
                        m = ruleOp.isMatch(fileset.type);
                    } else if (lt.equals("category")) {
                        m = ruleOp.isMatch(fileset.category);
                    }
                    if (ruleOp.baseOp == SSIRuleOp.OP_NONE) {
                        match = m;
                        continue;
                    }
                    if (ruleOp.baseOp == SSIRuleOp.OP_AND && !m) {
                        match = m;
                        break;
                    }
                    if (ruleOp.baseOp != SSIRuleOp.OP_OR || !m) continue;
                    match = m;
                }
                if (!match) continue;
                if (filesets == null) {
                    filesets = new ArrayList<SSIFileSet>();
                }
                filesets.add(fileset);
            }
        }
        return filesets;
    }

    public static Collection<FileEntry> getMatchFileFileEntrys(Map<String, SSIFileSet> filesets, SSIRule filesetRule) {
        Collection<SSIFileSet> filesetList = SSIFileSet.getMatchFileSet(filesets, filesetRule.getTarget(), filesetRule.getTargetRule());
        ArrayList<FileEntry> allEntryList = null;
        if (filesetList != null) {
            for (SSIFileSet fs : filesetList) {
                Collection<FileEntry> entryList = fs.getMatchFileEntrys(filesetRule.getEntry(), filesetRule.getEntryRule());
                if (entryList == null) continue;
                if (allEntryList == null) {
                    allEntryList = new ArrayList<FileEntry>();
                }
                allEntryList.addAll(entryList);
            }
        }
        return allEntryList;
    }

    public class FileEntry {
        public String[] types;
        public String src;
        public String des;
        public String[] attrs;
        public List<String> includeFilters = new ArrayList<String>();
        public List<String> excludeFilters = new ArrayList<String>();

        public FileEntry(String[] types, String src, String des, String[] attrs) {
            this.types = types;
            this.src = src;
            this.des = des;
            this.attrs = attrs;
        }

        public void addIncludeFilter(String[] filters) {
            for (String filter : filters) {
                this.addExcludeFilter(filter);
            }
        }

        public void addExcludeFilter(String[] filters) {
            for (String filter : filters) {
                this.addExcludeFilter(filter);
            }
        }

        public void addIncludeFilter(String filter) {
            filter = filter.replace(".", "\\.").replace("?", ".?").replace("*", ".*?");
            this.includeFilters.add(filter);
        }

        public void addExcludeFilter(String filter) {
            filter = filter.replace(".", "\\.").replace("?", ".?").replace("*", ".*?");
            this.excludeFilters.add(filter);
        }

        public boolean isContainType(String type) {
            for (String tp : this.types) {
                if (!tp.equals(type)) continue;
                return true;
            }
            return false;
        }

        public boolean isContainAttr(String attr) {
            for (String at : this.attrs) {
                if (!at.equals(attr)) continue;
                return true;
            }
            return false;
        }
    }
}

