/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.constants;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.lib.PathUtil;
import org.tizen.sbilib.lib.Platform;
import org.tizen.sbilib.lib.PropertyParser;

public class SDKConstants {
    public static final String BIN_DIR_NAME = "bin";
    public static final String TOOL_DIR_NAME = "tools";
    public static final String SHARED_DIR_NAME = "shared";
    public static final String PLATFORMS_DIR_NAME = "platforms";
    public static final String ONE_POINT_ZERO_DIR_NAME = "1.0";
    public static final String INFO_DIR_NAME = "info";
    public static final String TEMP_DIR_NAME = "tmp";
    public static final String USR_DIR_NAME = "usr";
    public static final String LIB_DIR_NAME = "lib";
    public static final String RESOURCE_DIR_NAME = "res";
    public static final String DIRECTORY_LOCALE_NAME = "locale";
    public static final String DEBUG_DIR_NAME = "debug";
    public static final String BUILD_DEBUG_DIR_NAME = "Debug";
    public static final String OPT_DIR_NAME = "opt";
    public static final String APPS_DIR_NAME = "apps";
    public static final String MANIFEST_FILE_NAME = "manifest.xml";
    public static final String CORE_MANIFEST_FILE_NAME = "tizen-manifest.xml";
    public static final String MULTI_MANIFEST_FILE_NAME = "manifest_multi.xml";
    private static final String SDK_INFO_FILE_NAME = "sdk.info";
    public static final String SUB_DIR_MK_FILE_NAME = "subdir.mk";
    public static final String EXTENSION_MK = "mk";
    public static final String EXE_EXTENSION = ".exe";
    private static final String ZIP_FILE_NAME_FOR_LINUX = "zip";
    private static final String ZIP_FILE_NAME_FOR_WINDOWS = "zip.exe";
    public static final String ZIP_FILE_NAME = SDKConstants.getZipFileName();
    private static final String SDK_CONFIGURATION_FILE_NAME = "tizensdkpath";
    private static final String SDK_INSTALLED_PATH_KEY = "TIZEN_SDK_INSTALLED_PATH";
    private static final String SDK_DATA_PATH_KEY = "TIZEN_SDK_DATA_PATH";
    private static final String INSTALL_MANAGER_CONFIG_DIR_NAME = ".installmanager";
    private static final String INSTALL_MANAGER_CONFIG_HOME_PATH = SDKConstants.getInstallManagerConfigHomePath();
    private static Properties SDK_CONFIGURATION = SDKConstants.getSDKConfiguration();
    public static final String SDK_INSTALLED_PATH = SDK_CONFIGURATION != null ? SDK_CONFIGURATION.getProperty("TIZEN_SDK_INSTALLED_PATH") : null;
    public static final String SDK_DATA_PATH = SDKConstants.getSDKDataPath();
    public static final String SDK_HOME_PATH = SDKConstants.getSDKHomePath();
    public static final String SDK_TOOL_MINGW_DIR_NAME = "mingw";
    public static final String SDK_TOOL_MSYS_DIR_NAME = "msys";
    public static final String SDK_TOOL_DIR_PATH = PathUtil.addPath(SDK_INSTALLED_PATH, "tools");
    public static final String SDK_TOOL_MINGW_DIR_PATH = PathUtil.addPath(SDK_TOOL_DIR_PATH, "mingw");
    public static final String SDK_TOOL_MINGW_BIN_PATH = PathUtil.addPath(SDK_TOOL_MINGW_DIR_PATH, "bin");
    public static final String SDK_PLATFORMS_PATH = PathUtil.addPath(SDK_INSTALLED_PATH, "platforms");
    public static final String SDK_TOOL_MSYS_DIR_PATH = PathUtil.addPath(SDK_TOOL_MINGW_DIR_PATH, "msys", "1.0");
    public static final String SDK_TOOL_MSYS_BIN_DIR_PATH = PathUtil.addPath(SDK_TOOL_MSYS_DIR_PATH, "bin");

    static Properties getSDKConfiguration() {
        String sdkInfoFilePath = SDKConstants.findSDKInfoFilePath();
        File configurationFile = new File(sdkInfoFilePath);
        if (!configurationFile.exists()) {
            return null;
        }
        try {
            return PropertyParser.parsing(configurationFile);
        }
        catch (FileNotFoundException e) {
            SBI.log.exception(e);
            return null;
        }
        catch (IOException e) {
            SBI.log.exception(e);
            return null;
        }
    }

    static String findSDKInfoFilePath() {
        String curDir = PathUtil.getCurrentPath();
        File curDirFile = new File(curDir);
        while (PathUtil.existParentDirectory(curDirFile)) {
            if (!PathUtil.existFileInPath(curDirFile = curDirFile.getParentFile(), SDK_INFO_FILE_NAME)) continue;
            return PathUtil.addPath(curDirFile.getAbsolutePath(), SDK_INFO_FILE_NAME);
        }
        return SDKConstants.getFixedInfoFile();
    }

    static String getFixedInfoFile() {
        return PathUtil.addPath(INSTALL_MANAGER_CONFIG_HOME_PATH, SDK_CONFIGURATION_FILE_NAME);
    }

    static String getZipFileName() {
        if (Platform.isWindows()) {
            return ZIP_FILE_NAME_FOR_WINDOWS;
        }
        return ZIP_FILE_NAME_FOR_LINUX;
    }

    static String getInstallManagerConfigHomePath() {
        String localAppDataPath = null;
        localAppDataPath = Platform.isWindows() ? PathUtil.getLocalAppData() : PathUtil.getHomePath();
        return PathUtil.addPath(localAppDataPath, INSTALL_MANAGER_CONFIG_DIR_NAME);
    }

    static String getSDKDataPath() {
        String sdkDataPath = PathUtil.addPath(SDK_INSTALLED_PATH, SDK_INFO_FILE_NAME);
        File sdkDataFile = new File(sdkDataPath);
        if (!sdkDataFile.exists()) {
            return null;
        }
        Properties props = null;
        try {
            props = PropertyParser.parsing(sdkDataFile);
        }
        catch (FileNotFoundException e) {
            SBI.log.exception(e);
            return null;
        }
        catch (IOException e) {
            SBI.log.exception(e);
            return null;
        }
        if (props == null) {
            SBI.log.warn("Cannot get sdk data path from " + sdkDataFile.getAbsolutePath());
            return null;
        }
        return props.getProperty(SDK_DATA_PATH_KEY);
    }

    static String getSDKHomePath() {
        if (Platform.isWindows()) {
            return PathUtil.getRootDrive(SDK_INSTALLED_PATH);
        }
        return PathUtil.getHomePath();
    }
}

