/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.util.Map;

public class MacroUtil {
    public static final String DEFAULT_START_LITER = "${";
    public static final String DEFAULT_END_LITER = "}";

    public static String runMacro(String source, String startLiter, String endLiter, Runner runner) {
        int idx2;
        if (source == null || source.isEmpty()) {
            return source;
        }
        if (source.indexOf(startLiter, 0) < 0) {
            return source;
        }
        int startLiterLen = startLiter.length();
        int endLiterLen = endLiter.length();
        StringBuilder str = new StringBuilder();
        int len = source.length();
        int idx = 0;
        while (idx < len && (idx2 = source.indexOf(startLiter, idx)) >= 0) {
            String label;
            String value;
            int idx3;
            if (idx < idx2) {
                str.append(source.substring(idx, idx2));
            }
            if ((idx3 = source.indexOf(endLiter, idx2)) < 0) break;
            if (runner != null && (value = runner.run(label = source.substring(idx2 + startLiterLen, idx3))) != null) {
                value = MacroUtil.runMacro(value, startLiter, endLiter, runner);
                str.append(value);
            }
            idx = idx3 + endLiterLen;
        }
        if (idx < len) {
            str.append(source.substring(idx));
        }
        return str.toString();
    }

    public static String processMacro(String source, Map<String, String> macros, String startLiter, String endLiter) {
        return MacroUtil.runMacro(source, startLiter, endLiter, new MacroRunner(macros));
    }

    public static String processMacro(String source, Map<String, String> macros) {
        return MacroUtil.processMacro(source, macros, DEFAULT_START_LITER, DEFAULT_END_LITER);
    }

    public static String processMacro(String source, String startLiter, String endLiter, Runner runner) {
        return MacroUtil.runMacro(source, startLiter, endLiter, runner);
    }

    public static String processMacro(String source, Runner runner) {
        return MacroUtil.processMacro(source, DEFAULT_START_LITER, DEFAULT_END_LITER, runner);
    }

    private static class MacroRunner
    implements Runner {
        private Map<String, String> macros;

        public MacroRunner(Map<String, String> macros) {
            this.macros = macros;
        }

        @Override
        public String run(String key) {
            return this.macros.get(key);
        }
    }

    public static interface Runner {
        public String run(String var1);
    }
}

