/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.ui.notifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.tizen.library.sdkmanager.ui.cache.ColorCache;
import org.tizen.library.sdkmanager.ui.cache.FontCache;
import org.tizen.library.sdkmanager.ui.notifier.NotificationImage;
import org.tizen.library.sdkmanager.ui.util.CacheUtil;
import org.tizen.library.sdkmanager.ui.util.PathUtil;
import org.tizen.library.sdkmanager.ui.util.PlatformUtil;
import org.tizen.library.sdkmanager.ui.util.UpdateManagerContents;

public class NotifierDialog {
    private static final int DISPLAY_TIME = 5000;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 8;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private static int DIALOG_WIDTH = 360;
    private static int DIALOG_HEIGHT = 66;
    private static int TEXT_FONT_SIZE = 12;
    private static int TEXT_SPACE_MARGIN = 13;
    private static int CLOSE_BOX_SPACE_MARGIN = 4;
    private static int START_LOCATION_MARGIN = 2;
    private static Color _titleFgColor = ColorCache.getColor(23, 51, 56);
    private static Color _fgColor = ColorCache.getColor(0, 127, 200);
    private static Color _bgFgGradient = ColorCache.getColor(255, 255, 255);
    private static Color _bgBgGradient = ColorCache.getColor(223, 246, 255);
    private static Color _borderColor = ColorCache.getColor(140, 140, 140);
    private static List<Shell> _activeShells = new ArrayList<Shell>();
    private static Image _oldImage;
    private static Shell _shell;
    private static LabelButtonListener _listner;
    private static int startX;
    private static int startY;

    public static void notify(Shell shell, String title, String message, NotificationImage type) {
        _shell = shell;
        NotifierDialog.notify_run(title, message, type, true);
    }

    public static void notify(String title, String message, NotificationImage type) {
        _shell = new Shell(Display.getDefault().getActiveShell(), 524296);
        NotifierDialog.notify_run(title, message, type, true);
    }

    public static void notify_run(String title, String message, NotificationImage type, boolean fade) {
        _shell.setLayout(new FillLayout());
        _shell.setForeground(_fgColor);
        _shell.setBackgroundMode(1);
        _shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.widget instanceof Shell) {
                    Shell shell = (Shell)event.widget;
                    _activeShells.remove(shell);
                }
            }
        });
        Composite inner = new Composite(_shell, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginTop = 0;
        gl.marginBottom = 0;
        inner.setLayout(gl);
        _shell.addListener(11, new Listener(){

            @Override
            public void handleEvent(Event e) {
                try {
                    Rectangle rect = _shell.getClientArea();
                    Image newImage = new Image((Device)CacheUtil.getDisplay(), Math.max(1, rect.width), rect.height);
                    GC gc = new GC(newImage);
                    gc.setForeground(_bgFgGradient);
                    gc.setBackground(_bgBgGradient);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    gc.setLineWidth(2);
                    gc.setForeground(_borderColor);
                    gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                    gc.dispose();
                    _shell.setBackgroundImage(newImage);
                    if (_oldImage != null) {
                        _oldImage.dispose();
                    }
                    _oldImage = newImage;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
        int pixelHeight = TEXT_FONT_SIZE;
        int pointHeight = pixelHeight * 72 / Display.getDefault().getDPI().y;
        Cursor fCursor = new Cursor(Display.getDefault(), 0);
        CLabel imgLabel = new CLabel(inner, 0);
        GridData data = new GridData(0x1000000, 0x1000000, true, true, 0, 0);
        data.verticalSpan = 2;
        imgLabel.setImage(type.getImage());
        imgLabel.setLayoutData(data);
        imgLabel.setMargins(0, 0, 0, 0);
        StyledText titleText = new StyledText(inner, 0);
        StyleRange titleStyle = new StyleRange();
        Font titleTextFont = titleText.getFont();
        FontData titleTextFontData = titleTextFont.getFontData()[0];
        titleTextFontData.setHeight(pointHeight);
        titleStyle.start = 0;
        titleStyle.length = title.length();
        titleStyle.foreground = _titleFgColor;
        GridData titleTextGridData = new GridData(16384, 0x1000000, true, true, 0, 0);
        titleText.setDoubleClickEnabled(false);
        titleText.setEditable(false);
        titleText.setBlockSelection(true);
        titleText.setCursor(fCursor);
        titleText.setText(title);
        titleText.setFont(FontCache.getFont(titleTextFontData));
        titleText.setLayoutData(titleTextGridData);
        titleText.setStyleRange(titleStyle);
        titleText.setTopMargin(TEXT_SPACE_MARGIN);
        CLabel button = new CLabel(inner, 0);
        data = new GridData(131072, 128, true, true, 0, 0);
        data.verticalSpan = 2;
        button.setMargins(0, CLOSE_BOX_SPACE_MARGIN, CLOSE_BOX_SPACE_MARGIN, 0);
        button.setLayoutData(data);
        button.setImage(NotificationImage.XBUTTON_NORMAL.getImage());
        NotifierDialog.addLabelButtonListner(button);
        final StyledText clickText = new StyledText(inner, 0);
        StyleRange clickTextStyle = new StyleRange();
        Font clickTextFont = clickText.getFont();
        FontData clickTextFontData = clickTextFont.getFontData()[0];
        clickTextFontData.setHeight(pointHeight);
        clickTextStyle.start = 0;
        clickTextStyle.length = message.length();
        clickTextStyle.underline = true;
        clickTextStyle.underlineStyle = 4;
        clickTextStyle.foreground = _fgColor;
        GridData clickTextGridData = new GridData(16384, 0x1000000, true, true, 0, 0);
        clickText.setDoubleClickEnabled(false);
        clickText.setEditable(false);
        clickText.setBlockSelection(true);
        clickText.setCursor(fCursor);
        clickText.setText(message);
        clickText.setFont(FontCache.getFont(clickTextFontData));
        clickText.setLayoutData(clickTextGridData);
        clickText.setStyleRange(clickTextStyle);
        clickText.setBottomMargin(TEXT_SPACE_MARGIN);
        clickText.addListener(4, new Listener(){

            @Override
            public void handleEvent(Event event) {
                try {
                    int offset = clickText.getOffsetAtLocation(new Point(event.x, event.y));
                    StyleRange style = clickText.getStyleRangeAtOffset(offset);
                    if (style != null && style.underline && style.underlineStyle == 4) {
                        this.runUpdateManager();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            private void runUpdateManager() {
                String binary = PathUtil.getPath(PathUtil.findSDKInstallPath(NotifierDialog.class), "update-manager", UpdateManagerContents.UPDATEMANAGER_BINARY_NAME);
                if (PlatformUtil.isWindows()) {
                    binary = "cmd /c " + binary;
                }
                try {
                    Runtime.getRuntime().exec(binary);
                    Shell shell = clickText.getParent().getShell();
                    shell.dispose();
                    _activeShells.remove(shell);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        _shell.setSize(DIALOG_WIDTH, DIALOG_HEIGHT);
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        if (PlatformUtil.isMacOS()) {
            startX = bounds.width - DIALOG_WIDTH - START_LOCATION_MARGIN;
            startY = START_LOCATION_MARGIN;
        } else {
            startX = bounds.width - DIALOG_WIDTH - START_LOCATION_MARGIN;
            startY = bounds.height - DIALOG_HEIGHT - START_LOCATION_MARGIN;
        }
        _shell.setLocation(startX, startY);
        _shell.setVisible(true);
        if (!_activeShells.isEmpty()) {
            ArrayList<Shell> modifiable = new ArrayList<Shell>(_activeShells);
            Collections.reverse(modifiable);
            for (Shell shell : modifiable) {
                Point curLoc = shell.getLocation();
                if (curLoc.y - 100 < 0 || curLoc.x != startX) {
                    _activeShells.remove(shell);
                    shell.dispose();
                    continue;
                }
                shell.setLocation(curLoc.x, curLoc.y - 100);
            }
        }
        _activeShells.add(_shell);
        NotifierDialog.fadeIn(_shell, fade);
    }

    private static void addLabelButtonListner(CLabel button) {
        button.addListener(3, _listner);
        button.addListener(4, _listner);
        button.addListener(6, _listner);
        button.addListener(7, _listner);
        button.addListener(32, _listner);
    }

    private static void fadeIn(final Shell _shell, final boolean fade) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    int cur = _shell.getAlpha();
                    if ((cur += 8) > 225) {
                        _shell.setAlpha(225);
                        if (fade) {
                            NotifierDialog.startTimer(_shell);
                        }
                        return;
                    }
                    _shell.setAlpha(cur);
                    CacheUtil.getDisplay().timerExec(50, this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        CacheUtil.getDisplay().timerExec(50, run);
    }

    private static void startTimer(final Shell _shell) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    NotifierDialog.fadeOut(_shell);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        CacheUtil.getDisplay().timerExec(5000, run);
    }

    private static void fadeOut(final Shell _shell) {
        Runnable run = new Runnable(){
            private int fadeValue = -1;

            @Override
            public void run() {
                try {
                    if (_shell == null || _shell.isDisposed()) {
                        return;
                    }
                    if (this.fadeValue < 0) {
                        this.fadeValue = _shell.getAlpha();
                    }
                    this.fadeValue -= 8;
                    if (this.fadeValue <= 0) {
                        _shell.setAlpha(0);
                        if (_oldImage != null) {
                            _oldImage.dispose();
                        }
                        _shell.dispose();
                        _activeShells.remove(_shell);
                        return;
                    }
                    _shell.setAlpha(this.fadeValue);
                    CacheUtil.getDisplay().timerExec(50, this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        };
        CacheUtil.getDisplay().timerExec(50, run);
    }

    static {
        _listner = new LabelButtonListener();
        startX = 0;
        startY = 0;
    }

    private static class LabelButtonListener
    implements Listener {
        private LabelButtonListener() {
        }

        @Override
        public void handleEvent(Event event) {
            if (event.widget instanceof CLabel) {
                CLabel bt = (CLabel)event.widget;
                Shell shell = bt.getParent().getShell();
                if (3 == event.type) {
                    bt.setImage(NotificationImage.XBUTTON_PUSH.getImage());
                } else if (4 == event.type) {
                    bt.setImage(NotificationImage.XBUTTON_NORMAL.getImage());
                    if (shell != null) {
                        shell.dispose();
                        _activeShells.remove(shell);
                    }
                } else if (32 == event.type) {
                    bt.setImage(NotificationImage.XBUTTON_HOVER.getImage());
                } else if (6 == event.type) {
                    bt.setImage(NotificationImage.XBUTTON_HOVER.getImage());
                } else if (7 == event.type) {
                    bt.setImage(NotificationImage.XBUTTON_NORMAL.getImage());
                }
            }
        }
    }
}

