/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.ui.cache;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.tizen.library.sdkmanager.ui.util.CacheUtil;

public class ImageCache {
    private static final String ICON_ROOT_PATH = "res/icon/";
    private static final HashMap<String, Image> _ImageMap = new HashMap();

    public static Image getImage(String fileName) {
        fileName = ICON_ROOT_PATH + fileName;
        Image image = _ImageMap.get(fileName);
        if (image == null) {
            image = ImageCache.createImage(fileName);
            _ImageMap.put(fileName, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Image createImage(String fileName) {
        InputStream is;
        block4: {
            Image image;
            ClassLoader classLoader = ImageCache.class.getClassLoader();
            is = classLoader.getResourceAsStream(fileName);
            try {
                if (is == null) {
                    is = classLoader.getResourceAsStream(fileName.substring(1));
                }
                if (is != null || (is = classLoader.getResourceAsStream(fileName)) != null || (is = classLoader.getResourceAsStream(fileName.substring(1))) != null) break block4;
                image = null;
            }
            catch (Throwable throwable) {
                CacheUtil.tryClose(is);
                throw throwable;
            }
            CacheUtil.tryClose(is);
            return image;
        }
        Image image = new Image((Device)CacheUtil.getDisplay(), is);
        CacheUtil.tryClose(is);
        return image;
    }

    public static synchronized void dispose() {
        CacheUtil.tryDispose(_ImageMap.values().toArray(new Widget[0]));
        _ImageMap.clear();
    }
}

