/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.ui.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Widget;
import org.tizen.library.sdkmanager.ui.cache.OneFont;
import org.tizen.library.sdkmanager.ui.util.CacheUtil;

public class FontCache {
    private static List<OneFont> _existing = new ArrayList<OneFont>();

    public static synchronized void disposeAll() {
        CacheUtil.tryDispose(_existing.toArray(new Widget[0]));
        _existing.clear();
    }

    public static synchronized Font getFont(FontData fd) {
        if (null == fd) {
            return null;
        }
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of : _existing) {
            if (!of.matches(fd)) continue;
            if (of.getFont().isDisposed()) {
                disposed = true;
                toRemove = of;
                break;
            }
            return of.getFont();
        }
        if (disposed) {
            _existing.remove(toRemove);
        }
        OneFont of = new OneFont(fd);
        _existing.add(of);
        return of.getFont();
    }

    public static synchronized int getCount() {
        return _existing.size();
    }

    public static Font getFont(Font font) {
        if (font == null || font.isDisposed()) {
            return null;
        }
        FontData fd = font.getFontData()[0];
        return FontCache.getFont(fd);
    }

    public static synchronized Font getFont(String fontName, int height, int style) {
        if (null == fontName) {
            return null;
        }
        boolean disposed = false;
        OneFont toRemove = null;
        for (OneFont of : _existing) {
            if (!of.getName().equals(fontName) || of.getHeight() != height || of.getStyle() != style) continue;
            if (of.getFont().isDisposed()) {
                disposed = true;
                toRemove = of;
                break;
            }
            return of.getFont();
        }
        if (disposed) {
            _existing.remove(toRemove);
        }
        OneFont of = new OneFont(fontName, height, style);
        _existing.add(of);
        return of.getFont();
    }
}

