/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.ui.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Selector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class CacheUtil {
    public static Display getDisplay() {
        Display dp = Display.getCurrent();
        if (null != dp) {
            return dp;
        }
        return Display.getDefault();
    }

    public static void tryDispose(Widget ... disposables) {
        if (null == disposables) {
            return;
        }
        for (Widget disposable : disposables) {
            if (null == disposable || disposable.isDisposed()) continue;
            disposable.dispose();
        }
    }

    public static void tryClose(Object ... closeables) {
        if (null == closeables) {
            return;
        }
        for (Object obj : closeables) {
            if (null == obj) continue;
            try {
                if (obj instanceof Closeable) {
                    ((Closeable)obj).close();
                    continue;
                }
                if (obj instanceof Selector) {
                    ((Selector)obj).close();
                    continue;
                }
                if (obj instanceof Socket) {
                    ((Socket)obj).close();
                    continue;
                }
                if (!(obj instanceof ServerSocket)) continue;
                ((ServerSocket)obj).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

