/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.tizen.library.sdkmanager.DummyPackageManager;
import org.tizen.library.sdkmanager.IPackageManager;
import org.tizen.library.sdkmanager.util.Log;
import org.tizen.library.sdkmanager.util.PathUtil;

public class PackageManagerFactory {
    private static final String SDK_LIBRARY_DIRECTORY_NAME = "library";
    private static final String PACKAGE_MANAGER_JAR_NAME = "package-manager.jar";
    private static final String PACKAGE_MANAGER_CLASS_NAME = "org.tizen.library.sdkmanager.packagemanager.PackageManager";

    public IPackageManager createPackageManager() {
        IPackageManager retPackageManager;
        block12: {
            retPackageManager = null;
            try {
                String sdkDirectory = PathUtil.findSDKInstallPath(PackageManagerFactory.class);
                if (sdkDirectory != null && !sdkDirectory.isEmpty()) {
                    String jarFilePath = PathUtil.getPath(sdkDirectory, SDK_LIBRARY_DIRECTORY_NAME, PACKAGE_MANAGER_JAR_NAME);
                    File jarFile = new File(jarFilePath);
                    if (jarFile != null && jarFile.exists()) {
                        Log.logInfo("Open package-manager.jar : " + jarFilePath);
                        ClassLoader classLoader = null;
                        ClassLoader parentLoader = null;
                        parentLoader = IPackageManager.class.getClassLoader();
                        try {
                            URL classURL = new URL("jar:" + jarFile.toURI().toURL() + "!/");
                            classLoader = new URLClassLoader(new URL[]{classURL}, parentLoader);
                        }
                        catch (MalformedURLException e1) {
                            Log.logInfo("MalformedURLException: " + e1.getMessage());
                        }
                        Class<?> clazz = classLoader.loadClass(PACKAGE_MANAGER_CLASS_NAME);
                        try {
                            retPackageManager = (IPackageManager)clazz.newInstance();
                        }
                        catch (InstantiationException e) {
                            Log.logInfo("InstantiationException: " + e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            Log.logInfo("IllegalAccessException: " + e.getMessage());
                        }
                        catch (ClassCastException e) {
                            Log.logInfo("ClassCastException: " + e.getMessage());
                        }
                        break block12;
                    }
                    Log.logInfo("exist file : " + jarFilePath);
                    break block12;
                }
                Log.logInfo("not found tizen install path from sdk info");
            }
            catch (ClassNotFoundException e) {
                Log.logInfo("ClassNotFoundException: " + e.getMessage());
            }
        }
        if (retPackageManager == null) {
            Log.logInfo("return dummy PackageManager instance.");
            retPackageManager = new DummyPackageManager();
        } else {
            Log.logInfo("return real PackageManager instance.");
        }
        return retPackageManager;
    }
}

