/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.util;

import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tizen.library.sdkmanager.util.PathUtil;

public class Log {
    private static final String LOG_FILE_HEAD = "tizen_sdk_manager";
    private static final String LOG_FILE_DIRECTORY = "sdk-manager-log";
    private static final String LOG4J_SYSTEM_PROPERTY_NAME = "sdkManagerLogFileName";
    private static final Date startTime = new Date();
    private static Logger logger = null;
    private static Logger infoLogger = null;

    public static void open() {
        Log.removeTooOldLogs();
        String path = PathUtil.getPath(Log.getLogDirectoryPath(), LOG_FILE_DIRECTORY, "tizen_sdk_manager_" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(startTime) + ".log");
        System.setProperty(LOG4J_SYSTEM_PROPERTY_NAME, path);
        logger = LogManager.getLogger(Log.class.getName());
        infoLogger = LogManager.getLogger("infoLoger");
    }

    private static void removeTooOldLogs() {
        File confDir = new File(PathUtil.getPath(Log.getLogDirectoryPath(), LOG_FILE_DIRECTORY));
        File[] logs = confDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().contains(Log.LOG_FILE_HEAD);
            }
        });
        if (logs == null) {
            return;
        }
        Arrays.sort(logs, new Comparator<File>(){

            @Override
            public int compare(File arg0, File arg1) {
                return arg0.compareTo(arg1);
            }
        });
        for (int i = 0; i < logs.length - 20; ++i) {
            if (logs[i].delete()) continue;
            logger.error("Fail to delete file ==> " + logs[i]);
        }
    }

    private static String getLogDirectoryPath() {
        String retPath = null;
        retPath = PathUtil.findSDKDataPath(Log.class);
        if (retPath == null || retPath.isEmpty()) {
            retPath = PathUtil.getClassPath(Log.class);
        }
        return retPath;
    }

    public static void logTitle(String msg) {
        infoLogger.info("**********************  " + msg + "  **********************");
    }

    public static void logInfo(String msg) {
        infoLogger.info(msg);
    }

    public static Logger getLogger(Class<?> object) {
        if (logger == null) {
            Log.open();
        }
        return LogManager.getLogger(object.getName());
    }
}

