/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkmanager.util;

import java.io.File;
import org.tizen.library.sdkmanager.util.ParsingUtil;

public class PathUtil {
    private static final String SDK_INFO_FILE_NAME = "sdk.info";
    private static final String SDK_INFO_INSTALL_PATH_KEY = "TIZEN_SDK_INSTALLED_PATH";
    private static final String SDK_INFO_DATA_PATH_KEY = "TIZEN_SDK_DATA_PATH";

    public static String getPath(String ... path_components) {
        String path = "";
        for (int i = 0; i < path_components.length; ++i) {
            path = i == 0 ? path_components[0] : path + File.separator + path_components[i];
        }
        return path;
    }

    public static String getClassPath(Class<?> curClass) {
        String classPath = curClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        File classFile = new File(classPath);
        String classDirectoryPath = classFile.getParent();
        return classDirectoryPath;
    }

    public static File findSDKInfoFromClass(Class<?> curClass) {
        File retFile = null;
        String path = curClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.replace("file:", "");
        for (File curFile = new File(path); curFile != null; curFile = curFile.getParentFile()) {
            File[] list;
            if (!curFile.isDirectory() || (list = curFile.listFiles()) == null) continue;
            for (File f : list) {
                if (!f.getName().equals(SDK_INFO_FILE_NAME) || !PathUtil.checkSDKInfoFile(f.getPath())) continue;
                retFile = f;
                break;
            }
            if (retFile != null) break;
        }
        return retFile;
    }

    public static String findSDKDataPath(Class<?> curClass) {
        String retPath = null;
        retPath = PathUtil.getPathFromSDKInfo(curClass, SDK_INFO_DATA_PATH_KEY);
        return retPath;
    }

    public static String findSDKInstallPath(Class<?> curClass) {
        String retPath = null;
        retPath = PathUtil.getPathFromSDKInfo(curClass, SDK_INFO_INSTALL_PATH_KEY);
        return retPath;
    }

    public static String getPathFromSDKInfo(Class<?> curClass, String parsingKey) {
        String tempPath;
        String retPath = null;
        File sdkInfoFile = PathUtil.findSDKInfoFromClass(curClass);
        if (sdkInfoFile != null && sdkInfoFile.exists() && (tempPath = ParsingUtil.parsingKeyValueFromPath(sdkInfoFile.getPath(), parsingKey)) != null && !tempPath.isEmpty()) {
            retPath = tempPath;
        }
        return retPath;
    }

    private static boolean checkSDKInfoFile(String path) {
        boolean retVal = false;
        String installPath = ParsingUtil.parsingKeyValueFromPath(path, SDK_INFO_INSTALL_PATH_KEY);
        String dataPath = ParsingUtil.parsingKeyValueFromPath(path, SDK_INFO_DATA_PATH_KEY);
        if (installPath != null && !installPath.isEmpty() && dataPath != null && !dataPath.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }
}

