/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.ui.notifier;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tizen.library.sdkutils.ui.notifier.UpdateAlarmContent;
import org.tizen.library.sdkutils.util.Log;
import org.tizen.library.sdkutils.util.PlatformUtil;

public class UpdateAlarm {
    private static final int MARGIN_NOTIFICATION_POPUP = 2;
    private static final int EXPIRE_NOTIFICATION_MILISEC_TIME = 7000;

    public static void main(String[] args) {
        UpdateAlarm updateAlarm = new UpdateAlarm();
        updateAlarm.runUpdateAlarm();
    }

    public UpdateAlarm() {
        Log.open("sdkUtilsUiLogFileName", "sdk-utils_ui_");
    }

    public void runUpdateAlarm() {
        Log.logTitle("This is SDK-Utils notification ui start!!");
        Log.trace("++++ runUpdateAlarm ++++");
        if (PlatformUtil.isMacOS()) {
            Log.info("This is MacOS");
            System.setProperty("apple.awt.UIElement", "true");
            Toolkit.getDefaultToolkit();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateAlarm.this.initJframeAndShow();
            }
        });
        Log.trace("---- runUpdateAlarm ----");
    }

    private void initJframeAndShow() {
        Log.trace("++++ initJframeAndShow ++++");
        JFrame frame = new JFrame();
        frame.setName("update notification");
        if (PlatformUtil.isWindows()) {
            frame.setType(Window.Type.UTILITY);
        } else {
            frame.setType(Window.Type.POPUP);
        }
        frame.setUndecorated(true);
        this.initContent(frame);
        frame.pack();
        this.moveNotificationLocation(frame);
        frame.setAlwaysOnTop(true);
        frame.toFront();
        frame.setVisible(true);
        this.expireTimer(frame);
        Log.trace("---- initJframeAndShow ----");
    }

    private void initContent(JFrame frame) {
        Log.trace("++++ initJframeAndShow ++++");
        UpdateAlarmContent nd = new UpdateAlarmContent(frame);
        JPanel panel = nd.makeGridContentPanel();
        frame.add(panel);
        Log.trace("---- initJframeAndShow ----");
    }

    private void expireTimer(final JFrame frame) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Log.info("expired timer, exit program");
                if (frame != null) {
                    frame.dispose();
                    Log.info("after expired timer");
                }
                System.exit(0);
            }
        }, 7000L);
    }

    private void moveNotificationLocation(JFrame frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Insets bounds = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
        double winWidth = dimension.width;
        double winHeigh = dimension.height;
        int posX = 0;
        int posY = 0;
        if (PlatformUtil.isMacOS()) {
            posX = (int)(winWidth - (double)frame.getWidth() - (double)bounds.right - 2.0);
            posY = bounds.top + 2;
        } else {
            posX = (int)(winWidth - (double)frame.getWidth() - (double)bounds.right - 2.0);
            posY = (int)(winHeigh - (double)frame.getHeight() - (double)bounds.bottom - 2.0);
        }
        frame.setLocation(posX, posY);
    }
}

