/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.ui.notifier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.tizen.library.sdkutils.util.Log;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.PlatformUtil;
import org.tizen.library.sdkutils.util.SDKToolContents;

public class UpdateAlarmContent {
    private static final String RESOURCE_PATH = "/res/icon/";
    private static final String TIZEN_ICON_IMG_NAME = "img_tizen_symbol.png";
    private static final String BUTTON_CLOSE_NORMAL = "btn_close_normal.png";
    private static final String BUTTON_CLOSE_PUSH = "btn_close_push.png";
    private static final String BUTTON_CLOSE_HOVER = "btn_close_hover.png";
    public static final int MARGIN_EXIT_BUTTON = 4;
    private static final int MARGIN_TEXT = 12;
    private static final String FONT_NAME = "Tizen Text";
    private JFrame mFrame = null;

    public UpdateAlarmContent(JFrame frame) {
        this.mFrame = frame;
    }

    public JPanel makeGridContentPanel() {
        Log.trace("++++ makeGirdContentPanel ++++");
        JPanel retPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics grphcs) {
                super.paintComponent(grphcs);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 0.0f, this.getHeight(), new Color(223, 246, 255));
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        retPanel.setBorder(new LineBorder(Color.GRAY, 1));
        retPanel.setLayout(new GridBagLayout());
        this.addComponent(retPanel, this.makeTizenImageGridCell(), 0, 0, 1, 2, 10, 10);
        this.addComponent(retPanel, this.makeTitileTextGridCell(), 1, 0, 1, 1, 17, 17);
        this.addComponent(retPanel, this.makeClickTextGridCell(), 1, 1, 1, 1, 17, 17);
        this.addComponent(retPanel, this.makeExitButtonGridCell(), 2, 0, 1, 2, 12, 12);
        Log.trace("---- makeGirdContentPanel ----");
        return retPanel;
    }

    private void addComponent(JPanel contentPanel, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        Log.trace("++++ addComponent ++++");
        Insets insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        contentPanel.add(component, gbc);
        Log.trace("---- addComponent ----");
    }

    private JLabel makeTizenImageGridCell() {
        Log.trace("++++ makeTizenImageGridCell ++++");
        JLabel tizenImage = new JLabel();
        tizenImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/img_tizen_symbol.png")));
        Log.trace("---- makeTizenImageGridCell ----");
        return tizenImage;
    }

    private JLabel makeTitileTextGridCell() {
        Log.trace("++++ makeTitileTextGridCell ++++");
        JLabel titleMsg = new JLabel("Tizen SDK Update Available.");
        titleMsg.setFont(new Font(FONT_NAME, 0, 12));
        titleMsg.setForeground(new Color(23, 51, 56));
        titleMsg.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        Log.trace("---- makeTitileTextGridCell ----");
        return titleMsg;
    }

    private JLabel makeClickTextGridCell() {
        Log.trace("++++ makeClickTextGridCell ++++");
        final JLabel clickMsg = new JLabel("Click here to review updates and install them.");
        clickMsg.setName("runUpdateManager");
        Font font = new Font(FONT_NAME, 0, 12);
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        clickMsg.setFont(font.deriveFont(attributes));
        clickMsg.setForeground(new Color(0, 127, 200));
        clickMsg.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        clickMsg.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                clickMsg.setForeground(new Color(0, 127, 200));
                Log.info("Run to update-manager");
                String binary = PathUtil.getPath(SDKToolContents.PACKAGEMANAGER_EXECUTABLE_PATH, SDKToolContents.PACKAGEMANAGER_EXECUTABLE_NAME);
                Log.info("update-manager Path is : " + binary);
                try {
                    if (PlatformUtil.isWindows()) {
                        Log.info("This is windows");
                        new ProcessBuilder("cmd", "/c", binary).start();
                    } else {
                        new ProcessBuilder(binary).start();
                    }
                    UpdateAlarmContent.this.terminatedApplication();
                }
                catch (IOException e) {
                    Log.throwing(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                clickMsg.setForeground(new Color(0, 51, 153));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                clickMsg.setCursor(new Cursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                clickMsg.setCursor(new Cursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
        Log.trace("---- makeClickTextGridCell ----");
        return clickMsg;
    }

    private JLabel makeExitButtonGridCell() {
        Log.trace("++++ makeExitButtonGridCell ++++");
        final JLabel exitImage = new JLabel();
        exitImage.setName("exitButton");
        exitImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/btn_close_normal.png")));
        exitImage.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 4));
        exitImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                Log.info("Exit button is clicked");
                exitImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/btn_close_normal.png")));
                UpdateAlarmContent.this.terminatedApplication();
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                exitImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/btn_close_push.png")));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                exitImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/btn_close_normal.png")));
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                exitImage.setIcon(new ImageIcon(this.getClass().getResource("/res/icon/btn_close_hover.png")));
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }
        });
        Log.trace("---- makeExitButtonGridCell ----");
        return exitImage;
    }

    private void terminatedApplication() {
        Log.trace("++++ terminatedApplication ++++");
        if (this.mFrame != null) {
            this.mFrame.dispose();
        }
        System.exit(0);
        Log.info("SDK-Utils ui is terminated");
        Log.trace("---- terminatedApplication ----");
    }
}

