/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import org.tizen.library.sdkutils.util.PlatformUtil;

public class FileDirUtil {
    public static String createDir(String dirName) {
        File dir = new File(dirName);
        File absPath = new File(dir.getAbsolutePath().toString());
        try {
            absPath.mkdirs();
        }
        catch (Exception e) {
            System.out.println(" failed to dir: " + dirName);
            return null;
        }
        if (absPath.isDirectory()) {
            return absPath.getAbsolutePath();
        }
        return null;
    }

    public static boolean moveFileTo(String filePath, String dirName) {
        File file = new File(filePath);
        File dir = new File(dirName);
        boolean result = false;
        try {
            Files.move(file.toPath(), dir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println(file.getName() + " is moved to " + dirName);
            result = true;
        }
        catch (IOException e) {
            System.out.println(file.getName() + " was failed to move to " + dirName);
        }
        return result;
    }

    public static boolean deleteDir(String dirPath) {
        boolean result = false;
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            System.out.println(dir.getName() + " is a directory");
            return result;
        }
        try {
            String rmPath = dir.getAbsolutePath();
            ProcessBuilder pb = null;
            if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
                pb = new ProcessBuilder("rm", "-rf", rmPath);
            } else if (PlatformUtil.isWindows()) {
                pb = new ProcessBuilder("rd", "/s", "/q", rmPath);
            }
            if (pb != null) {
                Process p = pb.start();
                p.waitFor();
                result = true;
            }
        }
        catch (Exception e) {
            System.out.println(" Failed to remove " + dirPath);
        }
        return result;
    }

    public static boolean deleteFile(String filePath) {
        boolean result = false;
        File file = new File(filePath);
        if (file.isDirectory()) {
            System.out.println(file.getName() + " is a directory");
            return result;
        }
        if (file.delete()) {
            System.out.println(file.getName() + " is deleted");
            result = true;
        } else {
            System.out.println(file.getName() + " was failed to be deleted");
        }
        return result;
    }

    public static boolean copyFileTo(String fileName, String dirName) {
        boolean result = false;
        File file = new File(fileName);
        File dir = new File(dirName);
        try {
            Files.copy(file.toPath(), dir.toPath(), StandardCopyOption.REPLACE_EXISTING);
            result = true;
        }
        catch (IOException e) {
            System.out.println("Cannot copy " + file.getName() + " to " + dir.getName());
            System.out.println(e.getMessage());
        }
        return result;
    }

    public static boolean copyDirectoryTo(String sourceDir, String targetDir) {
        boolean result = false;
        File sourceDirFile = new File(sourceDir);
        File targetDirFile = new File(targetDir);
        try {
            if (!sourceDirFile.isDirectory()) {
                return result;
            }
            if (targetDirFile.exists()) {
                if (targetDirFile.isDirectory()) {
                    FileDirUtil.deleteDir(targetDirFile.getAbsolutePath());
                } else {
                    targetDirFile.delete();
                }
            }
            Process p = null;
            ProcessBuilder pb = null;
            if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
                pb = new ProcessBuilder("cp", "-rf", sourceDir, targetDir);
            } else if (PlatformUtil.isWindows()) {
                FileDirUtil.createDir(targetDir);
                targetDir = "\"" + targetDir + "\"";
                sourceDir = "\"" + sourceDir + "\"";
                pb = new ProcessBuilder("xcopy", "/e", sourceDir, targetDir);
            }
            if (pb != null && (p = pb.start()).waitFor() == 0) {
                result = true;
            }
        }
        catch (IOException e) {
            System.out.println(" IOException : " + e.getMessage());
            result = false;
        }
        catch (InterruptedException e) {
            System.out.println(" InterruptedException : " + e.getMessage());
            result = false;
        }
        return result;
    }

    public static File findLastFile(String dirName, final String regExStr) {
        File dir = new File(dirName);
        File found = null;
        File[] files = regExStr == null || regExStr.length() == 0 ? dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        }) : dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().matches(regExStr);
            }
        });
        try {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File arg0, File arg1) {
                    return arg0.compareTo(arg1);
                }
            });
            found = files[files.length - 1];
        }
        catch (Exception e) {
            System.out.println(" [Exception] " + e.getMessage());
        }
        return found;
    }

    public static File findLastFile(String dirName) {
        File dir = new File(dirName);
        File found = null;
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        if (files != null) {
            long lastMod = Long.MIN_VALUE;
            for (File file : files) {
                if (file.lastModified() <= lastMod) continue;
                found = file;
                lastMod = file.lastModified();
            }
        }
        return found;
    }
}

