/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util.commonstring;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import org.tizen.library.sdkutils.util.commonstring.CSV2StringFile;

public class MakeStaticCommonStringFile {
    private static final String MAKED_FILE_LISENCE = "/*\n * sdk-utils\n *\n * Copyright (c) 2000 - 2017 Samsung Electronics Co., Ltd. All rights reserved.\n *\n * Contact: \n *  Taekgoo Kim <taekgoo.kim@samsung.com>\n *  Moonkyu Kang<moon.kang@samsung.com>\n *  SeungBum Kim <sb0729.kim@samsung.com>\n * \n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n *\n * Contributors:\n * - S-Core Co., Ltd\n *\n */";
    private static final String MAKED_FILE_PACKAGE_PATH = "package org.tizen.library.sdkutils.util.commonstring;";
    private static final String MAKED_FILE_CLASS = "public class CommonString";
    private static final String MAKED_FILE_COMMON_DECLARE = "\tpublic static final String ";
    private static final String MAKED_FILE_COMMON_COMMNET = "\t// ";

    public static void makeStringFile(String makeFilePath, Map<String, String> readMaps) {
        if (makeFilePath == null || makeFilePath.length() <= 0) {
            CSV2StringFile.PRINT_ERROR("Invalid maked file Path(NULL or zero length");
        } else if (readMaps == null || readMaps.isEmpty()) {
            CSV2StringFile.PRINT_ERROR("Invalid readMaps(NULL or zero length");
        } else {
            MakeStaticCommonStringFile.ifExistRemoveFile(makeFilePath);
            MakeStaticCommonStringFile.createAndWriteFile(makeFilePath, readMaps);
        }
    }

    private static void ifExistRemoveFile(String path) {
        try {
            File file = new File(path);
            if (file != null && !file.exists()) {
                CSV2StringFile.PRINT_INFO("file not exist : " + path);
            } else {
                try {
                    file.delete();
                }
                catch (SecurityException e) {
                    CSV2StringFile.PRINT_ERROR("SecurityException " + e.toString());
                }
            }
        }
        catch (Exception e) {
            CSV2StringFile.PRINT_ERROR("Exception " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAndWriteFile(String makeFilePath, Map<String, String> readMaps) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(makeFilePath, "UTF-8");
            MakeStaticCommonStringFile.inputClassFileTopContent(writer);
            MakeStaticCommonStringFile.inputKeyValueSetDeclaration(writer, readMaps);
            MakeStaticCommonStringFile.inputClassFileBottomContent(writer);
        }
    }

    private static void inputClassFileTopContent(PrintWriter writer) {
        writer.println(MAKED_FILE_LISENCE);
        writer.println(MAKED_FILE_PACKAGE_PATH);
        writer.println(System.getProperty("line.separator"));
        writer.println(MAKED_FILE_CLASS);
        writer.println("{");
    }

    private static void inputClassFileBottomContent(PrintWriter writer) {
        writer.println("}");
    }

    private static void inputKeyValueSetDeclaration(PrintWriter writer, Map<String, String> readMaps) {
        for (Map.Entry<String, String> entry : readMaps.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String fullDeclareString = "";
            if (key.contains("!*MAP_KEY_COMMNET*!")) {
                fullDeclareString = MAKED_FILE_COMMON_COMMNET + value;
            } else if (!key.contains("!*MAP_KEY_SPACELINE*!")) {
                fullDeclareString = MAKED_FILE_COMMON_DECLARE + key + " = \"" + value + "\";";
            }
            writer.println(fullDeclareString);
        }
    }
}

