/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tizen.library.sdkutils.util.ContentEditUtil;
import org.tizen.library.sdkutils.util.FileNotFoundException;
import org.tizen.library.sdkutils.util.PathUtil;

public class SDKInfoUtil {
    private static String SdkPath_HASH = null;
    private static String SdkPath = null;
    private static String SdkDataPath = null;

    public static File findSDKInfoFromClass(Class<?> curClass) {
        File retFile = null;
        String path = curClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        path = path.replace("file:", "");
        for (File curFile = new File(path); curFile != null; curFile = curFile.getParentFile()) {
            File[] list;
            if (!curFile.isDirectory() || (list = curFile.listFiles()) == null) continue;
            for (File f : list) {
                if (!f.getName().equals("sdk.info") || !SDKInfoUtil.checkSDKInfoFile(f.getAbsolutePath())) continue;
                retFile = f;
                break;
            }
            if (retFile != null) break;
        }
        return retFile;
    }

    public static String findSDKDataPath(Class<?> curClass) {
        if (SdkDataPath == null) {
            SdkDataPath = SDKInfoUtil.getPathFromSDKInfo(curClass, "TIZEN_SDK_DATA_PATH");
        }
        return SdkDataPath;
    }

    public static String findSDKInstallPath(Class<?> curClass) {
        if (SdkPath == null) {
            SdkPath = SDKInfoUtil.getPathFromSDKInfo(curClass, "TIZEN_SDK_INSTALLED_PATH");
        }
        return SdkPath;
    }

    public static String findSDKVersion() {
        String retVersion = null;
        String path = SDKInfoUtil.findSDKInstallPath(SDKInfoUtil.class);
        File sdkInfoFile = new File(path = PathUtil.getPath(path, "sdk.version"));
        if (sdkInfoFile != null && sdkInfoFile.exists()) {
            String tempPath = ContentEditUtil.getContent(sdkInfoFile, "TIZEN_SDK_VERSION");
            if (tempPath != null && !tempPath.isEmpty()) {
                retVersion = tempPath;
            }
        } else {
            throw new FileNotFoundException("[ERROR] [SDK-Utils] Could not find sdk-version file. Please check whether sdk.version is existed");
        }
        return retVersion;
    }

    public static String getDigestFromSDKInstallPath(Class<?> curClass) {
        if (SdkPath_HASH == null) {
            SdkPath_HASH = SDKInfoUtil.getDigestHashString(SDKInfoUtil.findSDKInstallPath(curClass), "MD5");
        }
        return SdkPath_HASH;
    }

    public static String getPathFromSDKInfo(Class<?> curClass, String parsingKey) throws RuntimeException {
        String retPath = null;
        File sdkInfoFile = SDKInfoUtil.findSDKInfoFromClass(curClass);
        if (sdkInfoFile != null && sdkInfoFile.exists()) {
            String tempPath = ContentEditUtil.getContent(sdkInfoFile, parsingKey);
            if (tempPath != null && !tempPath.isEmpty()) {
                retPath = tempPath;
            }
        } else {
            throw new FileNotFoundException("[ERROR] [SDK-Utils] Could not find sdk-info file. Please check whether sdk.info is existed");
        }
        return retPath;
    }

    private static boolean checkSDKInfoFile(String path) {
        boolean retVal = false;
        File file = new File(path);
        String installPath = ContentEditUtil.getContent(file, "TIZEN_SDK_INSTALLED_PATH");
        String dataPath = ContentEditUtil.getContent(file, "TIZEN_SDK_DATA_PATH");
        if (installPath != null && !installPath.isEmpty() && dataPath != null && !dataPath.isEmpty()) {
            retVal = true;
        }
        return retVal;
    }

    private static String getDigestHashString(String str, String hash) {
        String result = null;
        try {
            MessageDigest sh = MessageDigest.getInstance(hash);
            sh.update(str.getBytes());
            byte[] byteData = sh.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isAutoUpdate() {
        String path = SDKInfoUtil.findSDKInstallPath(SDKInfoUtil.class);
        File repoInfoFile = new File(path = PathUtil.getPath(path, ".info", "repository.info"));
        if (repoInfoFile != null && repoInfoFile.exists()) {
            String val = ContentEditUtil.getContent(repoInfoFile, "Auto-Update", ":");
            return val == null || val.isEmpty() || val.equalsIgnoreCase("null") || val.equalsIgnoreCase("true");
        }
        throw new FileNotFoundException("[ERROR] [SDK-Utils] Could not find repository.info file. Please check whether repository.info is existed");
    }

    public static boolean setAutoUpdate(boolean isAutoUpdate) {
        boolean retVal = false;
        String path = SDKInfoUtil.findSDKInstallPath(SDKInfoUtil.class);
        File repoInfoFile = new File(path = PathUtil.getPath(path, ".info", "repository.info"));
        if (repoInfoFile == null || !repoInfoFile.exists()) {
            throw new FileNotFoundException("[ERROR] [SDK-Utils] Could not find repository.info file. Please check whether repository.info is existed");
        }
        retVal = ContentEditUtil.replaceContent(repoInfoFile, "Auto-Update", String.valueOf(isAutoUpdate), ":");
        return retVal;
    }
}

