/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.api.impl;

import java.util.List;
import org.tizen.library.sdkutils.api.ISDKPackage;
import org.tizen.library.sdkutils.util.PathUtil;
import org.tizen.library.sdkutils.util.PlatformUtil;
import org.tizen.library.sdkutils.util.SDKInfoUtil;

public class SDKPackage
implements ISDKPackage {
    private String name;
    private String version;
    private List<String> os;
    private String buildHostOs;
    private List<String> installDependency;
    private List<String> buildDependency;
    private List<String> sourceDependency;
    private String attribute;
    private String sha256;
    private String size;
    private String path;
    private String label;
    private String description;
    private String formattedDescription;
    private String maintainer;
    private boolean installed;
    private boolean updateable;
    private boolean metaPkg;
    private ISDKPackage.Profile profile = ISDKPackage.Profile.COMMON;
    private ISDKPackage.PlatformVersion platformVersion = ISDKPackage.PlatformVersion.COMMON;
    private ISDKPackage.Type type;
    private boolean isExtension;
    private ISDKPackage.Extension extension = ISDKPackage.Extension.NONE;
    private String extName;
    private String extProfile;
    private String extSubProfile;
    private String extPlatform;
    private String extDevelopEnv;
    private String extPath;

    public SDKPackage() {
        this.type = ISDKPackage.Type.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public List<String> getOs() {
        return this.os;
    }

    public void setOs(List<String> os) {
        this.os = os;
    }

    @Override
    public String getBuildHostOs() {
        return this.buildHostOs;
    }

    public void setBuildHostOs(String buildHostOs) {
        this.buildHostOs = buildHostOs;
    }

    @Override
    public List<String> getInstallDependency() {
        return this.installDependency;
    }

    public void setInstallDependency(List<String> installDependency) {
        this.installDependency = installDependency;
    }

    @Override
    public List<String> getBuildDependency() {
        return this.buildDependency;
    }

    public void setBuildDependency(List<String> buildDependency) {
        this.buildDependency = buildDependency;
    }

    @Override
    public List<String> getSourceDependency() {
        return this.sourceDependency;
    }

    public void setSourceDependency(List<String> sourceDependency) {
        this.sourceDependency = sourceDependency;
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFormattedDescription() {
        return this.formattedDescription;
    }

    public void setFormattedDescription(String formattedDescription) {
        this.formattedDescription = formattedDescription;
    }

    @Override
    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    @Override
    public ISDKPackage.Profile getProfile() {
        return this.profile;
    }

    public void setProfile(ISDKPackage.Profile profile) {
        this.profile = profile;
    }

    @Override
    public ISDKPackage.PlatformVersion getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(ISDKPackage.PlatformVersion platformVersion) {
        this.platformVersion = platformVersion;
    }

    @Override
    @Deprecated
    public ISDKPackage.Extension getExtension() {
        return this.extension;
    }

    public void setExtension(ISDKPackage.Extension extension) {
        this.extension = extension;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public ISDKPackage.Type getType() {
        return this.type;
    }

    public void setType(ISDKPackage.Type type) {
        this.type = type;
    }

    @Override
    public boolean isExtension() {
        return this.isExtension;
    }

    public void setExtension(boolean isExtension) {
        this.isExtension = isExtension;
    }

    @Override
    public boolean isMetaPkg() {
        return this.metaPkg;
    }

    public void setMetaPkg(boolean metaPkg) {
        this.metaPkg = metaPkg;
    }

    public String getExtName() {
        return this.extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    public String getExtProfile() {
        return this.extProfile;
    }

    public void setExtProfile(String extProfile) {
        this.extProfile = extProfile;
    }

    public String getExtSubProfile() {
        return this.extSubProfile;
    }

    public void setExtSubProfile(String extSubProfile) {
        this.extSubProfile = extSubProfile;
    }

    public String getExtPlatform() {
        return this.extPlatform;
    }

    public void setExtPlatform(String extPlatform) {
        this.extPlatform = extPlatform;
    }

    public String getExtDevelopEnv() {
        return this.extDevelopEnv;
    }

    public void setExtDevelopEnv(String extDevelopEnv) {
        this.extDevelopEnv = extDevelopEnv;
    }

    public String getExtPath() {
        return this.extPath;
    }

    public void setExtPath(String extPath) {
        this.extPath = extPath;
    }

    @Override
    public String getExtensionProfile() {
        if (!this.isExtension) {
            return ISDKPackage.Extension.NONE.toString();
        }
        if (this.extSubProfile == null || this.extSubProfile.length() <= 0) {
            if (this.name != null && !this.name.isEmpty()) {
                if (ISDKPackage.Extension.STV.getPattern().matcher(this.name).find()) {
                    return ISDKPackage.Extension.STV.toString();
                }
                if (ISDKPackage.Extension.SCERT.getPattern().matcher(this.name).find()) {
                    return ISDKPackage.Extension.SCERT.toString();
                }
                if (ISDKPackage.Extension.SWEARABLE.getPattern().matcher(this.name).find()) {
                    return ISDKPackage.Extension.SWEARABLE.toString();
                }
            }
            return ISDKPackage.Extension.UNKNOWN.toString();
        }
        return this.extSubProfile;
    }

    @Override
    public String getPlatformPath() {
        String platformPath = null;
        if (!ISDKPackage.PlatformVersion.COMMON.equals((Object)this.platformVersion)) {
            platformPath = PathUtil.getPath(SDKInfoUtil.findSDKInstallPath(SDKPackage.class), "platforms", "tizen-" + this.platformVersion.toString());
            if (this.isExtension) {
                if (this.extPath != null && !this.extPath.isEmpty()) {
                    if (PlatformUtil.isWindows()) {
                        return PathUtil.getPath(SDKInfoUtil.findSDKInstallPath(SDKPackage.class), this.extPath.replace("/", "\\"));
                    }
                    return PathUtil.getPath(SDKInfoUtil.findSDKInstallPath(SDKPackage.class), this.extPath.replace("\\", "/"));
                }
                if (ISDKPackage.Extension.STV.equals((Object)this.extension)) {
                    return PathUtil.getPath(platformPath, ISDKPackage.Extension.STV.toString().toLowerCase());
                }
            } else if (!ISDKPackage.Profile.COMMON.equals((Object)this.profile)) {
                return PathUtil.getPath(platformPath, this.profile.toString().toLowerCase());
            }
        }
        return platformPath;
    }

    public String getStatus() {
        String status = "I";
        if (!this.installed) {
            status = "NI";
        } else if (this.updateable) {
            status = "U";
        }
        return status;
    }

    public String getPackageInfoString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ").append(this.getName()).append(System.getProperty("line.separator"));
        sb.append("version: ").append(this.getVersion()).append(System.getProperty("line.separator"));
        if (this.getOs() != null) {
            sb.append("version: ").append(this.getOs().toString()).append(System.getProperty("line.separator"));
        }
        sb.append("buildHostOs: ").append(this.getBuildHostOs()).append(System.getProperty("line.separator"));
        if (this.getInstallDependency() != null && !this.getInstallDependency().isEmpty()) {
            sb.append("installDependency: ").append(this.getInstallDependency()).append(System.getProperty("line.separator"));
        }
        if (this.getBuildDependency() != null && !this.getBuildDependency().isEmpty()) {
            sb.append("buildDependency: ").append(this.getBuildDependency()).append(System.getProperty("line.separator"));
        }
        if (this.getSourceDependency() != null && !this.getSourceDependency().isEmpty()) {
            sb.append("sourceDependency: ").append(this.getSourceDependency()).append(System.getProperty("line.separator"));
        }
        if (this.getAttribute() != null && this.getAttribute().isEmpty()) {
            sb.append("attribute: ").append(this.getAttribute()).append(System.getProperty("line.separator"));
        }
        sb.append("sha256: ").append(this.getSha256()).append(System.getProperty("line.separator"));
        sb.append("size: ").append(this.getSize()).append(System.getProperty("line.separator"));
        sb.append("path: ").append(this.getPath()).append(System.getProperty("line.separator"));
        sb.append("label: ").append(this.getLabel()).append(System.getProperty("line.separator"));
        sb.append("description: ").append(this.getDescription()).append(System.getProperty("line.separator"));
        sb.append("formattedDescription: ").append(this.getFormattedDescription()).append(System.getProperty("line.separator"));
        sb.append("maintainer: ").append(this.getMaintainer()).append(System.getProperty("line.separator"));
        sb.append("profile: ").append((Object)this.getProfile()).append(System.getProperty("line.separator"));
        sb.append("platformVersion: ").append((Object)this.getPlatformVersion()).append(System.getProperty("line.separator"));
        sb.append("extension: ").append((Object)this.getExtension()).append(System.getProperty("line.separator"));
        sb.append("extension profile: ").append(this.getExtensionProfile()).append(System.getProperty("line.separator"));
        sb.append("installed: ").append(this.isInstalled()).append(System.getProperty("line.separator"));
        sb.append("updatable: ").append(this.isUpdateable()).append(System.getProperty("line.separator"));
        sb.append("type: ").append((Object)this.getType()).append(System.getProperty("line.separator"));
        sb.append("isMeta: ").append(this.isMetaPkg()).append(System.getProperty("line.separator"));
        sb.append("isExtension: ").append(this.isExtension()).append(System.getProperty("line.separator"));
        sb.append("getPlatformPath: ").append(this.getPlatformPath()).append(System.getProperty("line.separator"));
        return sb.toString();
    }

    public String formattedDescription() {
        return null;
    }
}

