/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.library.sdkutils.cli;

import org.tizen.library.sdkutils.cli.common.Commands;
import org.tizen.library.sdkutils.cli.common.Options;

public class CLICommands {
    private Commands commands = this.createCommands();

    CLICommands() {
    }

    private Commands createCommands() {
        boolean isRequired = true;
        Commands commands = new Commands();
        commands.addCommand("show-sdk-path", "Show absolute path of the Tizen-sdk");
        commands.addCommand("show-sdkdata-path", "Show absolute path of the Tizen-sdk data");
        commands.addCommand("show-sdk-version", "Show version of the Tizen-sdk");
        commands.addCommand("show-autoupdate", "Show auto update value");
        Options setAutoUpdateOption = new Options();
        setAutoUpdateOption.addOption("--value", true, "value", "Auto update value (e.g. true or false)", isRequired);
        commands.addCommand("set-autoupdate", "Set auto update value", setAutoUpdateOption);
        Options tooPathOption = new Options();
        tooPathOption.addOption("--tool", true, "tool", "Specifies the SDK tool (e.g. tizen-studio, package-manager)", isRequired);
        commands.addCommand("show-tool-path", "execute a specified SDK tools", tooPathOption);
        Options showPkgOpt1 = new Options();
        showPkgOpt1.addOption("--pkg-name", true, "package", "search for package", isRequired);
        showPkgOpt1.addOption("--cache", false, null, "use cached file");
        commands.addCommand("show-package", "Show the package information", showPkgOpt1);
        Options showPkgOpt2 = new Options();
        showPkgOpt2.addOption("--profile", true, "profile", "search package for specific profile (mobile/wearable/tv)");
        showPkgOpt2.addOption("--version", true, "version", "search package for specific platform version (2.3/2.3.1/2.4)");
        showPkgOpt2.addOption("--ext-type", true, "type", "type of extension");
        showPkgOpt2.addOption("--pkg-type", true, "type", "type of package (all/meta-pkg/real-pkg)");
        showPkgOpt2.addOption("--install-only", false, null, "search installed package");
        showPkgOpt2.addOption("--cache", false, null, "use cached file");
        commands.addCommand("show-packages", "Show multiple information of packagesr", showPkgOpt2);
        Options executeOpt = new Options();
        executeOpt.addOption("--tool", true, "tool", "Specifies the SDK tool for execution (e.g. tizen-studio, package-manager)", isRequired);
        commands.addCommand("execute", "execute a specified SDK tools", executeOpt);
        commands.addCommand("version", "Show the version");
        Options helpOptions = new Options();
        helpOptions.addOption("show-package", false, null, "Help on a show-package command ");
        helpOptions.addOption("show-packages", false, null, "Help on a show-packages command");
        commands.addCommand("--help", "Help on a specific command", helpOptions);
        commands.addCommand(null, "create-cache", "Create cache file", null, false);
        return commands;
    }

    public Commands getCommands() {
        return this.commands;
    }
}

