#!/bin/bash

getEmbeddedJDKPath() {
    DONE=false
    until $DONE; do
    read line || DONE=true
    
    # reading each line
    if [[ $line == TIZEN_SDK_INSTALLED_PATH* ]]; then 
        sdkPath="$(cut -d'=' -f2 <<<$line)";
    fi
    if [[ $line == TIZEN_SDK_DATA_PATH* ]]; then 
        sdkDataPath="$(cut -d'=' -f2 <<<$line)"
    fi
    if [[ $line == JDK_PATH* ]]; then 
        sdkInfoJDKPath="$(cut -d'=' -f2 <<<$line)"
    fi
    
    done < "$1"
}

setJavaExecPath(){
    # extract the sdkPath, sdkDataPath, sdkInfoJDKPath
    getEmbeddedJDKPath $sdkInfoPath
    # update JAVA_EXEC if JDK_PATH specified(and exists) in sdk.info 
    if [ -d "$sdkInfoJDKPath" ]; then
        # jdk directory exixts
        JDK_PATH="$sdkInfoJDKPath"
    fi


    if [ ! -d "$JDK_PATH" ]; then 
        JAVA_EXEC="java"
    else
        UNAME=$(uname)
        case "$UNAME" in
        Linux)
                JAVA_EXEC="$JDK_PATH/bin/java"
            ;;
        Darwin)
                JAVA_EXEC="$JDK_PATH/Contents/Home/bin/java"
            ;;
        esac
    fi
}

#set JAVA_EXEC : relative path to embedded jdk
#read the contents of sdk.info to get the jdk path

SCRIPT_DIR="$(cd "$(dirname "$0")" ; pwd -P)"
JDK_PATH="$SCRIPT_DIR/../jdk"
sdkInfoPath="$SCRIPT_DIR/../sdk.info"

setJavaExecPath

### find location of script file ###
pushd . > /dev/null
SCRIPT_PATH="${BASH_SOURCE[0]}";
    while([ -h "${SCRIPT_PATH}" ]) do
        cd "`dirname "${SCRIPT_PATH}"`"
        SCRIPT_PATH="$(readlink "`basename "${SCRIPT_PATH}"`")";
    done
cd "`dirname "${SCRIPT_PATH}"`" > /dev/null
SCRIPT_PATH="`pwd`";
popd > /dev/null

sdk_utils_path=`echo "${SCRIPT_PATH}/sdk-utils-core.jar"`
#echo "sdk_utils_path=[${sdk_utils_path}]"

current_path=`pwd`
current_sdk_utils="$current_path/sdk-utils-core.jar"
#echo "current_sdk_utils=${current_sdk_utils}"

if [ -f "$current_sdk_utils" ]
then
"$JAVA_EXEC" -jar "$current_sdk_utils" "$@"
else
"$JAVA_EXEC" -jar "$sdk_utils_path" "$@"
fi

