/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SAMPLENATIVEIMELAYOUT_H_
#define SAMPLENATIVEIMELAYOUT_H_
#include "samplenativeimeuitypes.h"
#include <Elementary.h>

/**
 * brief initialize layout for given layout type
 *
 * @param keyboard_layout the layout to initialize
 * @param mode the display mode for layout
 * @param type the type of keyboard to initialize
 *
 * @return layout initialize, success or not
 * */
Eina_Bool sample_native_ime_layout_init(IMELayout *keyboard_layout, IMEDisplayMode mode, IMEKeyboardLayoutType type);

/**
 * @brief convert the layout name to layout type
 *
 * @param name the name of layout
 *
 * @return the layout type
 * */
IMEKeyboardLayoutType sample_native_ime_get_layout_type_by_name(char *name);

#endif /* SAMPLENATIVEIMELAYOUT_H_ */
