/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.nfc.cli;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.nfc.NFCErrorString;
import org.tizen.ecp.nfc.NFCEventException;
import org.tizen.ecp.nfc.cli.NFCCLIHelper;
import org.tizen.ecp.sock.MessageSender;

public class NFCP2pCLI
extends AbstractEmulatorCLI {
    @Argument(required=true, index=0, metaVar="attach send detach")
    String event;
    @Argument(required=false, index=1)
    String message;

    public NFCP2pCLI() {
        this.messageType = "nfc";
    }

    public void printHelp() {
        super.printHelp();
    }

    public int execute() {
        MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
        this.startRunning();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OnStatusEventProcPB(GeneratedMessage generatedMessage) {
        block12: {
            if (!(generatedMessage instanceof Ecs.DeviceNtf)) {
                return;
            }
            NFCCLIHelper nFCCLIHelper = null;
            Ecs.DeviceNtf deviceNtf = (Ecs.DeviceNtf)generatedMessage;
            String string = deviceNtf.getData().toStringUtf8();
            boolean bl = true;
            try {
                nFCCLIHelper = new NFCCLIHelper(string);
                if (this.event.equals("attach")) {
                    if (this.message != null) {
                        throw new NFCEventException(NFCErrorString.WrongArgument);
                    }
                    nFCCLIHelper.sendP2PDiscovered();
                    break block12;
                }
                if (this.event.equals("detach")) {
                    if (this.message != null) {
                        throw new NFCEventException(NFCErrorString.WrongArgument);
                    }
                    nFCCLIHelper.sendP2PDetached();
                    break block12;
                }
                if (this.event.equals("send")) {
                    nFCCLIHelper.sendP2PSend(this.message);
                    this.message = null;
                    break block12;
                }
                throw new NFCEventException(NFCErrorString.WrongArgument);
            }
            catch (NFCEventException nFCEventException) {
                bl = false;
                OutputUtil.printError((String)nFCEventException.getMessage());
                this.returnValue = 1;
            }
            finally {
                if (bl) {
                    MessageSender.getInstance().sendDeviceReq("nfc", 15, 0);
                }
                this.message = null;
                this.stopRunning();
            }
        }
    }
}

