/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(window, document, undefined) {
'use strict';
var ns = window.tau = window.tau || {},
nsConfig = window.tauConfig = window.tauConfig || {};
nsConfig.rootNamespace = 'tau';
nsConfig.fileName = 'tau';
ns.version = '1.1.3';
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* global window, define */
/* eslint-disable no-console */
/**
 * #Core namespace
 * Object contains main framework methods.
 * @class ns
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 */
(function (document, console) {
	"use strict";
			var idNumberCounter = 0,
			currentDate = +new Date(),
			slice = [].slice,
			rootNamespace = "",
			fileName = "",
			infoForLog = function (args) {
				var dateNow = new Date();

				args.unshift("[" + rootNamespace + "][" + dateNow.toLocaleString() + "]");
			},
			ns = window.ns || window.tau || {},
			nsConfig = window.nsConfig || window.tauConfig || {};

		ns.info = ns.info || {
			profile: "custom"
		};
		ns.tauPerf = ns.tauPerf || {};

		window.ns = ns;
		window.nsConfig = nsConfig;

		window.tau = ns;
		window.tauConfig = nsConfig;

		rootNamespace = nsConfig.rootNamespace;
		fileName = nsConfig.fileName;

		/**
		 * Return unique id
		 * @method getUniqueId
		 * @static
		 * @return {string}
		 * @member ns
		 */
		ns.getUniqueId = function () {
			return rootNamespace + "-" + ns.getNumberUniqueId() + "-" + currentDate;
		};

		/**
		 * Return unique id
		 * @method getNumberUniqueId
		 * @static
		 * @return {number}
		 * @member ns
		 */
		ns.getNumberUniqueId = function () {
			return idNumberCounter++;
		};

		/**
		 * logs supplied messages/arguments
		 * @method log
		 * @static
		 * @member ns
		 */
		ns.log = function () {
			var args = slice.call(arguments);

			infoForLog(args);
			if (console) {
				console.log.apply(console, args);
			}
		};

		/**
		 * logs supplied messages/arguments ad marks it as warning
		 * @method warn
		 * @static
		 * @member ns
		 */
		ns.warn = function () {
			var args = slice.call(arguments);

			infoForLog(args);
			if (console) {
				console.warn.apply(console, args);
			}
		};

		/**
		 * logs supplied messages/arguments and marks it as error
		 * @method error
		 * @static
		 * @member ns
		 */
		ns.error = function () {
			var args = slice.call(arguments);

			infoForLog(args);
			if (console) {
				console.error.apply(console, args);
			}
		};

		/**
		 * get from nsConfig
		 * @method getConfig
		 * @param {string} key
		 * @param {*} [defaultValue] value returned when config is not set
		 * @return {*}
		 * @static
		 * @member ns
		 */
		ns.getConfig = function (key, defaultValue) {
			return nsConfig[key] === undefined ? defaultValue : nsConfig[key];
		};

		/**
		 * set in nsConfig
		 * @method setConfig
		 * @param {string} key
		 * @param {*} value
		 * @param {boolean} [asDefault=false] value should be treated as default (doesn't overwrites
		 * the config[key] if it already exists)
		 * @static
		 * @member ns
		 */
		ns.setConfig = function (key, value, asDefault) {
			if (!asDefault || nsConfig[key] === undefined) {
				nsConfig[key] = value;
			}
		};

		/**
		 * Return path for framework script file.
		 * @method getFrameworkPath
		 * @return {?string}
		 * @member ns
		 */
		ns.getFrameworkPath = function () {
			var scripts = document.getElementsByTagName("script"),
				countScripts = scripts.length,
				i,
				url,
				arrayUrl,
				count;

			for (i = 0; i < countScripts; i++) {
				url = scripts[i].src;
				arrayUrl = url.split("/");
				count = arrayUrl.length;
				if (arrayUrl[count - 1] === fileName + ".js" ||
					arrayUrl[count - 1] === fileName + ".min.js") {
					return arrayUrl.slice(0, count - 1).join("/");
				}
			}
			return null;
		};

		}(window.document, window.console));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define*/
/*
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function () {
	"use strict";
	
			// Default configuration properties for mobile
			ns.setConfig("autoBuildOnPageChange", true, true);
			ns.setConfig("loader", false, true);
			ns.setConfig("pageContainerBody", true, true);
			ns.setConfig("popupTransition", "slideup", true);
			ns.setConfig("pageTransition", "slide", true);
			ns.setConfig("enablePageScroll", false, true);
			}());

/*global window, define, ns*/
/*jslint bitwise: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function () {
	"use strict";
	
			// Default configuration properties
			ns.setConfig("rootDir", ns.getFrameworkPath(), true);
			ns.setConfig("version", "", true);
			ns.setConfig("allowCrossDomainPages", false, true);
			ns.setConfig("domCache", false, true);
			// .. other possible options
			ns.setConfig("autoBuildOnPageChange", true, true);
			ns.setConfig("autoInitializePage", true, true);
			ns.setConfig("dynamicBaseEnabled", true, true);
			ns.setConfig("pageTransition", "none", true);
			ns.setConfig("popupTransition", "none", true);
			ns.setConfig("popupFullSize", false, true);
			ns.setConfig("scrollEndEffectArea", "content", true);
			ns.setConfig("enablePopupScroll", false, true);
			// ns.setConfig('container', document.body); // for defining application container
			// same as above, but for wearable version
			ns.setConfig("pageContainer", document.body, true);
			ns.setConfig("findProfileFile", false, true);
			ns.setConfig("keyboardSupport", false);

			}());

/*global define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #Defaults settings object
 *
 * This module is deprecated, please use tau.setConfig and tau.getConfig functions or tauConfig
 * object.
 *
 * @author Hyunkook Cho <hk0713.cho@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author junhyeonLee <juneh.lee@samsung.com>
 * @author heeju Joo <heeju.joo@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author hagun.kim <hagun.kim@samsung.com>
 * @class ns.defaults
 * @since 2.0
 * @deprecated 3.0
 */
(function () {
	"use strict";
				var defaults = {};

			/**
			 * Helper function to define property on object defaults
			 * @param {string} name Property name to define
			 */
			function defineProperty(name) {
				Object.defineProperty(ns.defaults, name, {
					get: function () {
						ns.warn("tau.defaults are deprecated from Tizen 3.0, please use tau.getConfig.");
						return ns.getConfig(name);
					},
					set: function (value) {
						ns.warn("tau.defaults are deprecated from Tizen 3.0, please use tau.setConfig.");
						return ns.setConfig(name, value);
					}
				});
			}

			ns.defaults = defaults;

			/**
			 * @property {boolean} autoInitializePage=true
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("autoInitializePage");
			/**
			 * @property {boolean} dynamicBaseEnabled=true
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("dynamicBaseEnabled");
			/**
			 * @property {string} pageTransition="none"
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("pageTransition");
			/**
			 * @property {string} popupTransition="none"
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("popupTransition");
			/**
			 * @property {boolean} popupFullSize=false
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("popupFullSize");
			/**
			 * @property {boolean} enablePageScroll=false
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("enablePageScroll");
			/**
			 * @property {string} scrollEndEffectArea="content
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("scrollEndEffectArea");
			/**
			 * @property {boolean} enablePopupScroll=false
			 * @member ns.defaults
			 * @static
			 */
			defineProperty("enablePopupScroll");

			}());

/*global window, ns, define*/
/*jslint bitwise: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Support
 * Namespace with helpers function connected with browser properties
 * @class ns.support
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function (window, document) {
	"use strict";
	
			/* $.mobile.media method: pass a CSS media type or query and get a bool return
			 note: this feature relies on actual media query support for media queries, though types will
			  work most anywhere
			 examples:
			 $.mobile.media('screen') // tests for screen media type
			 $.mobile.media('screen and (min-width: 480px)') // tests for screen media type with window
			  width > 480px
			 $.mobile.media('\@media screen and (-webkit-min-device-pixel-ratio: 2)') // tests for webkit
			  2x pixel ratio (iPhone 4)
			 */
			// TODO: use window.matchMedia once at least one UA implements it
			var cacheMedia = {},
				testDiv = document.createElement("div"),
				fakeBody = document.createElement("body"),
				fakeBodyStyle = fakeBody.style,
				html = document.getElementsByTagName("html")[0],
				style,
				vendors = ["Webkit", "Moz", "O"],
				webos = window.palmGetResource, //only used to rule out scrollTop
				opera = window.opera,
				operamini = window.operamini && ({}).toString.call(window.operamini) === "[object OperaMini]",
				blackBerry,
				testDivStyle = testDiv.style;

			testDiv.id = "jquery-mediatest";
			fakeBody.appendChild(testDiv);

			/**
			 * Method checks \@media "query" support
			 * @method media
			 * @param {string} query
			 * @return {boolean}
			 * @static
			 * @member ns.support
			 */
			function media(query) {
				var styleBlock = document.createElement("style"),
					cssrule = "@media " + query + " { #jquery-mediatest { position:absolute; } }";

				if (query.cacheMedia === undefined) {
					//must set type for IE!
					styleBlock.type = "text/css";

					if (styleBlock.styleSheet) {
						styleBlock.styleSheet.cssText = cssrule;
					} else {
						styleBlock.appendChild(document.createTextNode(cssrule));
					}

					if (html.firstChild) {
						html.insertBefore(fakeBody, html.firstChild);
					} else {
						html.appendChild(fakeBody);
					}
					html.insertBefore(styleBlock, fakeBody);
					style = window.getComputedStyle(testDiv);
					cacheMedia[query] = (style.position === "absolute");
					styleBlock.parentNode.removeChild(styleBlock);
					fakeBody.parentNode.removeChild(fakeBody);
				}
				return cacheMedia[query];
			}

			function validStyle(prop, value, checkVend) {
				var div = document.createElement("div"),
					uc = function (txt) {
						return txt.charAt(0).toUpperCase() + txt.substr(1);
					},
					vendPref = function (vend) {
						return "-" + vend.charAt(0).toLowerCase() + vend.substr(1) + "-";
					},
					returnValue,
					checkStyle = function (vend) {
						var vendProp = vendPref(vend) + prop + ": " + value + ";",
							ucVend = uc(vend),
							propStyle = ucVend + uc(prop);

						div.setAttribute("style", vendProp);

						if (div.style[propStyle]) {
							returnValue = true;
						}
					},
					checkVendors = checkVend ? [checkVend] : vendors,
					checkVendorsLength = checkVendors.length,
					i;

				for (i = 0; i < checkVendorsLength; i++) {
					checkStyle(checkVendors[i]);
				}
				return !!returnValue;
			}

			/**
			 *
			 * @param {string} prop
			 * @return {boolean}
			 */
			function propExists(prop) {
				var ucProp = prop.charAt(0).toUpperCase() + prop.substr(1),
					props = (prop + " " + vendors.join(ucProp + " ") + ucProp).split(" "),
					key;

				for (key = 0; key < props.length; key++) {
					if (props.hasOwnProperty(key) && fakeBodyStyle[props[key]] !== undefined) {
						return true;
					}
				}
				return false;
			}

			function transform3dTest() {
				var prop = "transform-3d";

				return validStyle("perspective", "10px", "moz") || media("(-" + vendors.join("-" + prop + "),(-") + "-" + prop + "),(" + prop + ")");
			}

			blackBerry = window.blackberry && !propExists("-webkit-transform");

			function baseTagTest() {
				var fauxBase = location.protocol + "//" + location.host + location.pathname + "ui-dir/",
					head = document.head,
					base = head.querySelector("base"),
					fauxEle = null,
					hadBase = false,
					href = "",
					link,
					rebase;

				if (base) {
					href = base.getAttribute("href");
					base.setAttribute("href", fauxBase);
					hadBase = true;
				} else {
					base = fauxEle = document.createElement("base");
					base.setAttribute("href", fauxBase);
					head.appendChild(base);
				}

				link = document.createElement("a");
				link.href = "testurl";
				if (fakeBody.firstChild) {
					fakeBody.insertBefore(link, fakeBody.firstChild);
				} else {
					fakeBody.appendChild(link);
				}
				rebase = link.href;
				base.href = href || location.pathname;

				if (fauxEle) {
					head.removeChild(fauxEle);
				}

				// Restore previous base href if base had existed
				if (hadBase) {
					base.setAttribute("href", href);
				}

				// Tell jQuery not to append <base> in build mode
				if (location.hash === "#build") {
					return false;
				}

				return rebase.indexOf(fauxBase) === 0;
			}

			function cssPointerEventsTest() {
				var element = document.createElement("x"),
					documentElement = document.documentElement,
					getComputedStyle = window.getComputedStyle,
					supports,
					elementStyle = element.style;

				if (elementStyle.pointerEvents === undefined) {
					return false;
				}

				elementStyle.pointerEvents = "auto";
				elementStyle.pointerEvents = "x";
				documentElement.appendChild(element);
				supports = getComputedStyle && getComputedStyle(element, "").pointerEvents === "auto";
				documentElement.removeChild(element);
				return !!supports;
			}

			function boundingRect() {
				var div = document.createElement("div");

				return div.getBoundingClientRect !== undefined;
			}

			ns.support = {
				media: media,
				/**
				 * Informs browser support transition
				 * @property {boolean} cssTransitions
				 * @member ns.support
				 * @static
				 */
				cssTransitions: (window.WebKitTransitionEvent !== undefined || validStyle("transition", "height 100ms linear")) && !opera,
				/**
				 * Informs browser support history.pushStare method
				 * @property {boolean} pushState
				 * @member ns.support
				 * @static
				 */
				pushState: window.history.pushState && window.history.replaceState && true,
				/**
				 * Informs browser support media query "only all"
				 * @property {boolean} mediaquery
				 * @member ns.support
				 * @static
				 */
				mediaquery: media("only all"),
				/**
				 * Informs browser support content property on element
				 * @property {boolean} cssPseudoElement
				 * @member ns.support
				 * @static
				 */
				cssPseudoElement: !!propExists("content"),
				/**
				 * Informs browser support overflowScrolling property on element
				 * @property {boolean} touchOverflow
				 * @member ns.support
				 * @static
				 */
				touchOverflow: !!propExists("overflowScrolling"),
				/**
				 * Informs browser support CSS 3D transitions
				 * @property {boolean} cssTransform3d
				 * @member ns.support
				 * @static
				 */
				cssTransform3d: transform3dTest(),
				/**
				 * Informs browser support boxShadow property on element
				 * @property {boolean} boxShadow
				 * @member ns.support
				 * @static
				 */
				boxShadow: !!propExists("boxShadow") && !blackBerry,
				/**
				 * Informs browser support scrollTop property
				 * @property {boolean} scrollTop
				 * @member ns.support
				 * @static
				 */
				scrollTop: ((window.pageXOffset || document.documentElement.scrollTop || fakeBody.scrollTop) !== undefined && !webos && !operamini) ? true : false,
				/**
				 * Informs browser support dynamic change base tag
				 * @property {boolean} dynamicBaseTag
				 * @member ns.support
				 * @static
				 */
				dynamicBaseTag: baseTagTest(),
				/**
				 * Informs browser support CSS pointer events
				 * @property {boolean} cssPointerEvents
				 * @member ns.support
				 * @static
				 */
				cssPointerEvents: cssPointerEventsTest(),
				/**
				 * Prefix for animations
				 * @property ("-webkit-"|"-moz-"|"-o-"|""} cssAnimationPrefix
				 * @member ns.support
				 * @static
				 */
				cssAnimationPrefix: testDivStyle.hasOwnProperty("webkitAnimation") ? "-webkit-" :
					testDivStyle.hasOwnProperty("mozAnimation") ? "-moz-" :
						testDivStyle.hasOwnProperty("oAnimation") ? "-o-" : "",
				/**
				 * Informs browser support getBoundingClientRect
				 * @property {boolean} boundingRect
				 * @member ns.support
				 * @static
				 */
				boundingRect: boundingRect(),
				/**
				 * Object with browser information
				 * @property (Object} browser
				 * @property {boolean} browser.ie detects Internet Explorer
				 * @member ns.support
				 * @static
				 */
				browser: {
					ie: (function () {
						var v = 3,
							div = document.createElement("div"),
							a = div.all || [];

						do {
							div.innerHTML = "<!--[if gt IE " + (++v) + "]><br><![endif]-->";
						} while (a[0]);
						return v > 4 ? v : !v;
					}())
				},
				/**
				 * Informs that browser pass all tests for run framework
				 * @method gradeA
				 * @member ns.support
				 * @static
				 * @return {boolean}
				 */
				gradeA: function () {
					return ((this.mediaquery || (this.browser.ie && this.browser.ie >= 7)) &&
					(this.boundingRect || ((window.jQuery && window.jQuery.fn && window.jQuery.fn.jquery.match(/1\.[0-7+]\.[0-9+]?/)) !== null)));
				},
				/**
				 * Informs browser support touch events
				 * @property {boolean} touch
				 * @member ns.support
				 * @static
				 */
				touch: document.ontouchend !== undefined,
				/**
				 * Informs browser support orientation property
				 * @property {boolean} orientation
				 * @member ns.support
				 * @static
				 */
				orientation: window.orientation !== undefined && window.onorientationchange !== undefined
			};
			testDiv = null;
			fakeBody = null;
			}(window, window.document));

/*global window, ns, define, XMLHttpRequest, console, Blob */
/*jslint nomen: true, browser: true, plusplus: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Utilities
 *
 * The Tizen Advanced UI (TAU) framework provides utilities for easy-developing
 * and fully replaceable with jQuery method. When user using these DOM and
 * selector methods, it provide more light logic and it proves performance
 * of web app. The following table displays the utilities provided by the
 * TAU framework.
 *
 * @class ns.util
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 */
(function (window, document, ns) {
	"use strict";
				var currentFrame = null,
				util = ns.util || {},
				// frames callbacks which should be run in next request animation frame
				waitingFrames = [],
				slice = [].slice,
				// inform that loop was added to request animation frame callback
				loopWork = false;

			/**
			 * Function which is use as workaround when any type of request animation frame not exists
			 * @param {Function} callback
			 * @method _requestAnimationFrameOnSetTimeout
			 * @static
			 * @member ns.util
			 * @protected
			 */
			util._requestAnimationFrameOnSetTimeout = function (callback) {
				currentFrame = window.setTimeout(callback.bind(callback, +new Date()), 1000 / 60);
			};

			/**
			 * Function which support every request animation frame.
			 * @method _loop
			 * @protected
			 * @static
			 * @member ns.util
			 */
			util._loop = function () {
				var loopWaitingFrames = slice.call(waitingFrames),
					currentFrameFunction = loopWaitingFrames.shift(),
					loopTime = performance.now();

				waitingFrames = [];

				while (currentFrameFunction) {
					currentFrameFunction();
					if (performance.now() - loopTime < 15) {
						currentFrameFunction = loopWaitingFrames.shift();
					} else {
						currentFrameFunction = null;
					}
				}
				if (loopWaitingFrames.length || waitingFrames.length) {
					waitingFrames.unshift.apply(waitingFrames, loopWaitingFrames);
					util.windowRequestAnimationFrame(util._loop);
				} else {
					loopWork = false;
				}
			};

			/**
			 * Find browser prefixed request animation frame function.
			 * @method _getRequestAnimationFrame
			 * @protected
			 * @static
			 * @member ns.util
			 */
			util._getRequestAnimationFrame = function () {
				return (window.requestAnimationFrame ||
					window.webkitRequestAnimationFrame ||
					window.mozRequestAnimationFrame ||
					window.oRequestAnimationFrame ||
					window.msRequestAnimationFrame ||
					util._requestAnimationFrameOnSetTimeout).bind(window);
			};

			/**
			 * Original requestAnimationFrame from object window.
			 * @method windowRequestAnimationFrame
			 * @static
			 * @member ns.util
			 */
			util.windowRequestAnimationFrame = util._getRequestAnimationFrame();

			/**
			 * Special requestAnimationFrame function which add functions to queue of callbacks
			 * @method requestAnimationFrame
			 * @static
			 * @member ns.util
			 */
			util.requestAnimationFrame = function (callback) {
				waitingFrames.push(callback);
				if (!loopWork) {
					util.windowRequestAnimationFrame(util._loop);
					loopWork = true;
				}
			};

			util._cancelAnimationFrameOnSetTimeout = function () {
				// probably wont work if there is any more than 1
				// active animationFrame but we are trying anyway
				window.clearTimeout(currentFrame);
			};

			util._getCancelAnimationFrame = function () {
				return (window.cancelAnimationFrame ||
					window.webkitCancelAnimationFrame ||
					window.mozCancelAnimationFrame ||
					window.oCancelAnimationFrame ||
					window.msCancelAnimationFrame ||
					util._cancelAnimationFrameOnSetTimeout).bind(window);
			};

			util.cancelAnimationFrame = util._getCancelAnimationFrame();

			/**
			 * fetchSync retrieves a text document synchronously, returns null on error
			 * @param {string} url
			 * @param {=string} [mime=""] Mime type of the resource
			 * @return {string|null}
			 * @static
			 * @member ns.util
			 */
			function fetchSync(url, mime) {
				var xhr = new XMLHttpRequest(),
					status;

				xhr.open("get", url, false);
				if (mime) {
					xhr.overrideMimeType(mime);
				}
				xhr.send();
				if (xhr.readyState === 4) {
					status = xhr.status;
					if (status === 200 || (status === 0 && xhr.responseText)) {
						return xhr.responseText;
					}
				}

				return null;
			}

			util.fetchSync = fetchSync;

			/**
			 * Removes all script tags with src attribute from document and returns them
			 * @param {HTMLElement} container
			 * @return {Array.<HTMLElement>}
			 * @protected
			 * @static
			 * @member ns.util
			 */
			function removeExternalScripts(container) {
				var scripts = slice.call(container.querySelectorAll("script[src]")),
					i = scripts.length,
					script;

				while (--i >= 0) {
					script = scripts[i];
					script.parentNode.removeChild(script);
				}

				return scripts;
			}

			util._removeExternalScripts = removeExternalScripts;

			/**
			 * Evaluates code, reason for a function is for an atomic call to evaluate code
			 * since most browsers fail to optimize functions with try-catch blocks, so this
			 * minimizes the effect, returns the function to run
			 * @param {string} code
			 * @return {Function}
			 * @static
			 * @member ns.util
			 */
			function safeEvalWrap(code) {
				return function () {
					try {
						window.eval(code);
					} catch (e) {
						if (e.stack) {
							ns.error(e.stack);
						} else if (e.name && e.message) {
							ns.error(e.name, e.message);
						} else {
							ns.error(e);
						}
					}
				};
			}

			util.safeEvalWrap = safeEvalWrap;

			/**
			 * Calls functions in supplied queue (array)
			 * @param {Array.<Function>} functionQueue
			 * @static
			 * @member ns.util
			 */
			function batchCall(functionQueue) {
				var i,
					length = functionQueue.length;

				for (i = 0; i < length; ++i) {
					functionQueue[i]();
				}
			}

			util.batchCall = batchCall;

			/**
			 * Creates new script elements for scripts gathered from a different document
			 * instance, blocks asynchronous evaluation (by renaming src attribute) and
			 * returns an array of functions to run to evaluate those scripts
			 * @param {Array.<HTMLElement>} scripts
			 * @param {HTMLElement} container
			 * @return {Array.<Function>}
			 * @protected
			 * @static
			 * @member ns.util
			 */
			function createScriptsSync(scripts, container) {
				var scriptElement,
					scriptBody,
					i,
					length,
					queue = [];

				// proper order of execution
				for (i = 0, length = scripts.length; i < length; ++i) {
					scriptBody = util.fetchSync(scripts[i].src, "text/plain");
					if (scriptBody) {
						scriptElement = document.adoptNode(scripts[i]);
						scriptElement.setAttribute("data-src", scripts[i].src);
						scriptElement.removeAttribute("src"); // block evaluation
						queue.push(util.safeEvalWrap(scriptBody));
						if (container) {
							container.appendChild(scriptElement);
						}
					}
				}

				return queue;
			}

			util._createScriptsSync = createScriptsSync;

			function removeInlineScripts(element) {
				var result = [],
					script;

				[].slice.call(element.querySelectorAll(
					"script:not([data-src]):not([type]):not([id]):not([src])"
					)).forEach(function (item) {
						script = document.createElement("script");
						script.innerText = item.textContent;
						item.parentNode.removeChild(item);
						result.push(script);
					});

				return result;
			}

			util._removeInlineScripts = removeInlineScripts;

			/**
			 * Method make asynchronous call of function
			 * @method async
			 * @inheritdoc #requestAnimationFrame
			 * @member ns.util
			 * @static
			 */
			util.async = util.requestAnimationFrame;

			/**
			 * Appends element from different document instance to current document in the
			 * container element and evaluates scripts (synchronously)
			 * @param {HTMLElement} element
			 * @param {HTMLElement} container
			 * @return {HTMLElement}
			 * @method importEvaluateAndAppendElement
			 * @member ns.util
			 * @static
			 */
			util.importEvaluateAndAppendElement = function (element, container) {
				var externalScriptsQueue =
						util._createScriptsSync(util._removeExternalScripts(element), element),
					inlineScripts = util._removeInlineScripts(element),
					newNode = document.importNode(element, true);

				container.appendChild(newNode); // append and eval inline
				inlineScripts.forEach(function (script) {
					container.appendChild(script);
				});
				util.batchCall(externalScriptsQueue);

				return newNode;
			};

			/**
			 * Checks if specified string is a number or not
			 * @method isNumber
			 * @param {string} query
			 * @return {boolean}
			 * @member ns.util
			 * @static
			 */
			util.isNumber = function (query) {
				var parsed = parseFloat(query);

				return !isNaN(parsed) && isFinite(parsed);
			};

			/**
			 * Reappear script tags to DOM structure to correct run script
			 * @method runScript
			 * @param {string} baseUrl
			 * @param {HTMLScriptElement} script
			 * @member ns.util
			 * @deprecated 2.3
			 */
			util.runScript = function (baseUrl, script) {
				var newScript = document.createElement("script"),
					scriptData,
					i,
					scriptAttributes = slice.call(script.attributes),
					src = script.getAttribute("src"),
					attribute,
					status;

				// 'src' may become null when none src attribute is set
				if (src !== null) {
					src = util.path.makeUrlAbsolute(src, baseUrl);
				}

				//Copy script tag attributes
				i = scriptAttributes.length;
				while (--i >= 0) {
					attribute = scriptAttributes[i];
					if (attribute.name !== "src") {
						newScript.setAttribute(attribute.name, attribute.value);
					} else {
						newScript.setAttribute("data-src", attribute.value);
					}
				}

				if (src) {
					scriptData = util.fetchSync(src, "text/plain");
									} else {
					scriptData = script.textContent;
				}

				if (scriptData) {
					// add the returned content to a newly created script tag
					newScript.src = window.URL.createObjectURL(new Blob([scriptData], {type: "text/javascript"}));
					newScript.textContent = scriptData; // for compatibility with some libs ex. template systems
				}
				script.parentNode.replaceChild(newScript, script);
			};

			ns.util = util;
			}(window, window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/**
 * #Array Utility
 *
 * Utility helps work with arrays.
 *
 * @class ns.util.array
 */
(function (ns) {
	"use strict";
	
			/**
			 * Convert values to common type and return information about type string or not.
			 * @param {number|string} low
			 * @param {number|string} high
			 * @return {{inival: *, endval: *, chars: boolean}}
			 */
			function convertTypes(low, high) {
				var inival,
					endval,
					chars = false;

				if (isNaN(low) && isNaN(high)) {
					chars = true;
					inival = low.charCodeAt(0);
					endval = high.charCodeAt(0);
				} else {
					inival = (isNaN(low) ? 0 : low);
					endval = (isNaN(high) ? 0 : high);
				}
				return {
					inival: inival,
					endval: endval,
					chars: chars
				};
			}

			/**
			 * Create an array containing the range of integers or characters
			 * from low to high (inclusive)
			 * @method range
			 * @param {number|string} low
			 * @param {number|string} high
			 * @param {number} step
			 * @static
			 * @return {Array} array containing continuos elements
			 * @member ns.util.array
			 */
			function range(low, high, step) {
				// Create an array containing the range of integers or characters
				// from low to high (inclusive)
				//
				// version: 1107.2516
				// discuss at: http://phpjs.org/functions/range
				// +   original by: Waldo Malqui Silva
				// *	example 1: range ( 0, 12 );
				// *	returns 1: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
				// *	example 2: range( 0, 100, 10 );
				// *	returns 2: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
				// *	example 3: range( 'a', 'i' );
				// *	returns 3: ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i']
				// *	example 4: range( 'c', 'a' );
				// *	returns 4: ['c', 'b', 'a']
				var matrix = [],
					inival,
					endval,
					plus,
					walker = step || 1,
					chars,
					typeData;

				typeData = convertTypes(low, high);
				inival = typeData.inival;
				endval = typeData.endval;
				chars = typeData.chars;

				plus = inival <= endval;
				if (plus) {
					while (inival <= endval) {
						matrix.push((chars ? String.fromCharCode(inival) : inival));
						inival += walker;
					}
				} else {
					while (inival >= endval) {
						matrix.push((chars ? String.fromCharCode(inival) : inival));
						inival -= walker;
					}
				}

				return matrix;
			}

			function isCorrectType(object) {
				return Array.isArray(object) || object instanceof NodeList || typeof object === "function";
			}

			function hasCorrectLength(object) {
				var length = object.length;

				return (length === 0 || typeof length === "number" && length > 0 && (length - 1) in object);
			}

			/**
			 * Check object is array-like (array-like include array and
			 * collection)
			 * @method isArrayLike
			 * @param {Object} object
			 * @return {boolean} Whether array-like object or not
			 * @member ns.util.array
			 * @static
			 */
			function isArrayLike(object) {

				// if object exists and is different from window
				// window object has length property
				if (object && object !== object.window) {
					// If length value is not number, object is not array and collection.
					// Collection type is not array but has length value.
					// e.g) Array.isArray(document.childNodes) ==> false
					return isCorrectType(object) && hasCorrectLength(object);
				}
				return false;
			}

			/**
			 * Faster version of standard forEach method in array
			 * Confirmed that this method is 20 times faster then native
			 * @method forEach
			 * @param {Array} array
			 * @param {Function} callback
			 * @member ns.util.array
			 * @static
			 */
			function forEach(array, callback) {
				var i,
					length,
					convertedArray = array;

				if (!(array instanceof Array)) {
					convertedArray = [].slice.call(array);
				}
				length = convertedArray.length;
				for (i = 0; i < length; i++) {
					callback(convertedArray[i], i, convertedArray);
				}
			}


			/**
			 * Faster version of standard filter method in array
			 * @method filter
			 * @param {Array} array
			 * @param {Function} callback
			 * @member ns.util.array
			 * @static
			 */
			function filter(array, callback) {
				var result = [],
					i,
					length,
					value,
					convertedArray = array;

				if (!(array instanceof Array)) {
					convertedArray = [].slice.call(array);
				}
				length = convertedArray.length;
				for (i = 0; i < length; i++) {
					value = convertedArray[i];
					if (callback(value, i, convertedArray)) {
						result.push(value);
					}
				}
				return result;
			}

			/**
			 * Faster version of standard map method in array
			 * Confirmed that this method is 60% faster then native
			 * @method map
			 * @param {Array} array
			 * @param {Function} callback
			 * @member ns.util.array
			 * @static
			 */
			function map(array, callback) {
				var result = [],
					i,
					length,
					convertedArray = array;

				if (!(array instanceof Array)) {
					convertedArray = [].slice.call(array);
				}
				length = convertedArray.length;
				for (i = 0; i < length; i++) {
					result.push(callback(convertedArray[i], i, convertedArray));
				}
				return result;
			}

			/**
			 * Faster version of standard reduce method in array
			 * Confirmed that this method is 60% faster then native
			 * @method reduce
			 * @param {Array} array
			 * @param {Function} callback
			 * @param {*} [initialValue]
			 * @member ns.util.array
			 * @return {*}
			 * @static
			 */
			function reduce(array, callback, initialValue) {
				var i,
					length,
					value,
					result = initialValue,
					convertedArray = array;

				if (!(array instanceof Array)) {
					convertedArray = [].slice.call(array);
				}
				length = convertedArray.length;
				for (i = 0; i < length; i++) {
					value = convertedArray[i];
					if (result === undefined && i === 0) {
						result = value;
					} else {
						result = callback(result, value, i, convertedArray);
					}
				}
				return result;
			}

			ns.util.array = {
				range: range,
				isArrayLike: isArrayLike,
				forEach: forEach,
				filter: filter,
				map: map,
				reduce: reduce
			};

			}(ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
/* global ns, define, CustomEvent */
/**
 * #Events
 *
 * The Tizen Advanced UI (TAU) framework provides events optimized for the Tizen
 * Web application. The following table displays the events provided by the TAU
 * framework.
 * @class ns.event
 */
(function (window, ns) {
	"use strict";
				/**
			 * Checks if specified variable is a array or not
			 * @method isArray
			 * @return {boolean}
			 * @member ns.event
			 * @private
			 * @static
			 */
			var instances = [],
				isArray = Array.isArray,
				isArrayLike = ns.util.array.isArrayLike,
				/**
				 * @property {RegExp} SPLIT_BY_SPACES_REGEXP
				 */
				SPLIT_BY_SPACES_REGEXP = /\s+/g,

				/**
				 * Returns trimmed value
				 * @method trim
				 * @param {string} value
				 * @return {string} trimmed string
				 * @static
				 * @private
				 * @member ns.event
				 */
				trim = function (value) {
					return value.trim();
				},

				/**
				 * Split string to array
				 * @method getEventsListeners
				 * @param {string|Array|Object} names string with one name of event, many names of events
				 * divided by spaces, array with names of widgets or object in which keys are names of
				 * events and values are callbacks
				 * @param {Function} globalListener
				 * @return {Array}
				 * @static
				 * @private
				 * @member ns.event
				 */
				getEventsListeners = function (names, globalListener) {
					var name,
						result = [],
						i;

					if (typeof names === "string") {
						names = names.split(SPLIT_BY_SPACES_REGEXP).map(trim);
					}

					if (isArray(names)) {
						for (i = 0; i < names.length; i++) {
							result.push({type: names[i], callback: globalListener});
						}
					} else {
						for (name in names) {
							if (names.hasOwnProperty(name)) {
								result.push({type: name, callback: names[name]});
							}
						}
					}
					return result;
				};

			/**
			 * Find instance by element
			 * @method findInstance
			 * @param {HTMLElement} element
			 * @return {ns.event.gesture.Instance}
			 * @member ns.event
			 * @static
			 * @private
			 */
			function findInstance(element) {
				var instance;

				instances.forEach(function (item) {
					if (item.element === element) {
						instance = item.instance;
					}
				});
				return instance;
			}

			/**
			 * Remove instance from instances by element
			 * @method removeInstance
			 * @param {HTMLElement} element
			 * @member ns.event
			 * @static
			 * @private
			 */
			function removeInstance(element) {
				instances.forEach(function (item, key) {
					if (item.element === element) {
						instances.splice(key, 1);
					}
				});
			}


			ns.event = {

				/**
				 * Triggers custom event fastOn element
				 * The return value is false, if at least one of the event
				 * handlers which handled this event, called preventDefault.
				 * Otherwise it returns true.
				 * @method trigger
				 * @param {HTMLElement|HTMLDocument} element
				 * @param {string} type
				 * @param {?*} [data=null]
				 * @param {boolean=} [bubbles=true]
				 * @param {boolean=} [cancelable=true]
				 * @return {boolean}
				 * @member ns.event
				 * @static
				 */
				trigger: function (element, type, data, bubbles, cancelable) {
					var evt = new CustomEvent(type, {
						"detail": data,
						//allow event to bubble up, required if we want to allow to listen fastOn document etc
						bubbles: typeof bubbles === "boolean" ? bubbles : true,
						cancelable: typeof cancelable === "boolean" ? cancelable : true
					});
										return element.dispatchEvent(evt);
				},

				/**
				 * Prevent default on original event
				 * @method preventDefault
				 * @param {Event} event
				 * @member ns.event
				 * @static
				 */
				preventDefault: function (event) {
					var originalEvent = event._originalEvent;
					// @todo this.isPropagationStopped = returnTrue;

					if (originalEvent && originalEvent.preventDefault) {
						originalEvent.preventDefault();
					}
					event.preventDefault();
				},

				/**
				 * Stop event propagation
				 * @method stopPropagation
				 * @param {Event} event
				 * @member ns.event
				 * @static
				 */
				stopPropagation: function (event) {
					var originalEvent = event._originalEvent;
					// @todo this.isPropagationStopped = returnTrue;

					if (originalEvent && originalEvent.stopPropagation) {
						originalEvent.stopPropagation();
					}
					event.stopPropagation();
				},

				/**
				 * Stop event propagation immediately
				 * @method stopImmediatePropagation
				 * @param {Event} event
				 * @member ns.event
				 * @static
				 */
				stopImmediatePropagation: function (event) {
					var originalEvent = event._originalEvent;
					// @todo this.isPropagationStopped = returnTrue;

					if (originalEvent && originalEvent.stopImmediatePropagation) {
						originalEvent.stopImmediatePropagation();
					}
					event.stopImmediatePropagation();
				},

				/**
				 * Return document relative cords for event
				 * @method documentRelativeCoordsFromEvent
				 * @param {Event} event
				 * @return {Object}
				 * @return {number} return.x
				 * @return {number} return.y
				 * @member ns.event
				 * @static
				 */
				documentRelativeCoordsFromEvent: function (event) {
					var _event = event ? event : window.event,
						client = {
							x: _event.clientX,
							y: _event.clientY
						},
						page = {
							x: _event.pageX,
							y: _event.pageY
						},
						posX = 0,
						posY = 0,
						touch0,
						body = document.body,
						documentElement = document.documentElement;

					if (event.type.match(/^touch/)) {
						touch0 = _event.targetTouches[0] || _event.originalEvent.targetTouches[0];
						page = {
							x: touch0.pageX,
							y: touch0.pageY
						};
						client = {
							x: touch0.clientX,
							y: touch0.clientY
						};
					}

					if (page.x || page.y) {
						posX = page.x;
						posY = page.y;
					} else if (client.x || client.y) {
						posX = client.x + body.scrollLeft + documentElement.scrollLeft;
						posY = client.y + body.scrollTop + documentElement.scrollTop;
					}

					return {x: posX, y: posY};
				},

				/**
				 * Return target relative cords for event
				 * @method targetRelativeCoordsFromEvent
				 * @param {Event} event
				 * @return {Object}
				 * @return {number} return.x
				 * @return {number} return.y
				 * @member ns.event
				 * @static
				 */
				targetRelativeCoordsFromEvent: function (event) {
					var target = event.target,
						cords = {
							x: event.offsetX,
							y: event.offsetY
						};

					if (cords.x === undefined || isNaN(cords.x) ||
						cords.y === undefined || isNaN(cords.y)) {
						cords = ns.event.documentRelativeCoordsFromEvent(event);
						cords.x -= target.offsetLeft;
						cords.y -= target.offsetTop;
					}

					return cords;
				},

				/**
				 * Add event listener to element
				 * @method fastOn
				 * @param {HTMLElement} element
				 * @param {string} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				fastOn: function (element, type, listener, useCapture) {
					element.addEventListener(type, listener, useCapture || false);
				},

				/**
				 * Remove event listener to element
				 * @method fastOff
				 * @param {HTMLElement} element
				 * @param {string} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				fastOff: function (element, type, listener, useCapture) {
					element.removeEventListener(type, listener, useCapture || false);
				},

				/**
				 * Add event listener to element with prefixes for all browsers
				 *
				 *	@example
				 * 		tau.event.prefixedFastOn(document, "animationEnd", function() {
				 *			console.log("animation ended");
				 *		});
				 *		// write "animation ended" on console on event "animationEnd", "webkitAnimationEnd", "mozAnimationEnd", "msAnimationEnd", "oAnimationEnd"
				 *
				 * @method fastPrefixedOn
				 * @param {HTMLElement} element
				 * @param {string} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				prefixedFastOn: function (element, type, listener, useCapture) {
					var nameForPrefix = type.charAt(0).toLocaleUpperCase() + type.substring(1);

					element.addEventListener(type.toLowerCase(), listener, useCapture || false);
					element.addEventListener("webkit" + nameForPrefix, listener, useCapture || false);
					element.addEventListener("moz" + nameForPrefix, listener, useCapture || false);
					element.addEventListener("ms" + nameForPrefix, listener, useCapture || false);
					element.addEventListener("o" + nameForPrefix.toLowerCase(), listener, useCapture || false);
				},

				/**
				 * Remove event listener to element with prefixes for all browsers
				 *
				 *	@example
				 *		tau.event.prefixedFastOff(document, "animationEnd", functionName);
				 *		// remove listeners functionName on events "animationEnd", "webkitAnimationEnd", "mozAnimationEnd", "msAnimationEnd", "oAnimationEnd"
				 *
				 * @method fastPrefixedOff
				 * @param {HTMLElement} element
				 * @param {string} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				prefixedFastOff: function (element, type, listener, useCapture) {
					var nameForPrefix = type.charAt(0).toLocaleUpperCase() + type.substring(1);

					element.removeEventListener(type.toLowerCase(), listener, useCapture || false);
					element.removeEventListener("webkit" + nameForPrefix, listener, useCapture || false);
					element.removeEventListener("moz" + nameForPrefix, listener, useCapture || false);
					element.removeEventListener("ms" + nameForPrefix, listener, useCapture || false);
					element.removeEventListener("o" + nameForPrefix.toLowerCase(), listener, useCapture || false);
				},

				/**
				 * Add event listener to element that can be added addEventListener
				 * @method on
				 * @param {HTMLElement|HTMLDocument|Window} element
				 * @param {string|Array|Object} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				on: function (element, type, listener, useCapture) {
					var i,
						j,
						elementsLength,
						typesLength,
						elements,
						listeners;

					if (isArrayLike(element)) {
						elements = element;
					} else {
						elements = [element];
					}
					elementsLength = elements.length;
					listeners = getEventsListeners(type, listener);
					typesLength = listeners.length;
					for (i = 0; i < elementsLength; i++) {
						if (typeof elements[i].addEventListener === "function") {
							for (j = 0; j < typesLength; j++) {
								ns.event.fastOn(elements[i], listeners[j].type, listeners[j].callback, useCapture);
							}
						}
					}
				},

				/**
				 * Remove event listener to element
				 * @method off
				 * @param {HTMLElement|HTMLDocument|Window} element
				 * @param {string|Array|Object} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				off: function (element, type, listener, useCapture) {
					var i,
						j,
						elementsLength,
						typesLength,
						elements,
						listeners;

					if (isArrayLike(element)) {
						elements = element;
					} else {
						elements = [element];
					}
					elementsLength = elements.length;
					listeners = getEventsListeners(type, listener);
					typesLength = listeners.length;
					for (i = 0; i < elementsLength; i++) {
						if (typeof elements[i].addEventListener === "function") {
							for (j = 0; j < typesLength; j++) {
								ns.event.fastOff(elements[i], listeners[j].type, listeners[j].callback, useCapture);
							}
						}
					}
				},

				/**
				 * Add event listener to element only for one trigger
				 * @method one
				 * @param {HTMLElement|HTMLDocument|window} element
				 * @param {string|Array|Object} type
				 * @param {Function} listener
				 * @param {boolean} [useCapture=false]
				 * @member ns.event
				 * @static
				 */
				one: function (element, type, listener, useCapture) {
					var arraySlice = [].slice,
						i,
						j,
						elementsLength,
						typesLength,
						elements,
						listeners,
						callbacks = [];

					if (isArrayLike(element)) {
						elements = arraySlice.call(element);
					} else {
						elements = [element];
					}
					elementsLength = elements.length;
					// pair type with listener
					listeners = getEventsListeners(type, listener);
					typesLength = listeners.length;
					// on each element
					for (i = 0; i < elementsLength; i++) {
						// if element has possibility of add listener
						if (typeof elements[i].addEventListener === "function") {
							callbacks[i] = [];
							// for each event type
							for (j = 0; j < typesLength; j++) {
								callbacks[i][j] = (function (i, j) {
									var args = arraySlice.call(arguments);

									ns.event.fastOff(elements[i], listeners[j].type, callbacks[i][j], useCapture);
									// remove the first argument of binding function
									args.shift();
									// remove the second argument of binding function
									args.shift();
									listeners[j].callback.apply(this, args);
								}).bind(null, i, j);
								ns.event.fastOn(elements[i], listeners[j].type, callbacks[i][j], useCapture);
							}
						}
					}
				},

				// disable is required because method has changing arguments
				/* eslint-disable jsdoc/check-param-names */

				/**
				 * Enable gesture handling on given HTML element or object
				 * @method enableGesture
				 * @param {HTMLElement} element
				 * @param {...Object} [gesture] Gesture object {@link ns.event.gesture}
				 * @member ns.event
				 */
				enableGesture: function (element) {
					var gestureInstance = findInstance(element),
						length = arguments.length,
						i = 1;

					if (!gestureInstance) {
						gestureInstance = new ns.event.gesture.Instance(element);
						instances.push({element: element, instance: gestureInstance});
					}

					for (; i < length; i++) {
						gestureInstance.addDetector(arguments[i]);
					}
				},

				/**
				 * Disable gesture handling from given HTML element or object
				 * @method disableGesture
				 * @param {HTMLElement} element
				 * @param {...Object} [gesture] Gesture object {@link ns.event.gesture}
				 * @member ns.event
				 */
				disableGesture: function (element) {
					var gestureInstance = findInstance(element),
						length = arguments.length,
						i = 1;

					if (!gestureInstance) {
						return;
					}

					if (length > 1) {
						gestureInstance.removeDetector(arguments[i]);
					} else {
						gestureInstance.destroy();
						removeInstance(element);
					}
				}

				/* eslint-disable jsdoc/check-param-names */
			};

			}(window, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Info
 *
 * Various TAU information
 * @class ns.info
 */
(function (window, document) {
	"use strict";
				/**
			 * @property {Object} info
			 * @property {string} [info.profile="default"] Current runtime profile
			 * @property {string} [info.theme="default"] Current runtime theme
			 * @property {string} info.version Current runtime version
			 * @member ns.info
			 * @static
			 */
			var eventUtils = ns.event,
				info = {
					profile: "default",
					theme: "default",
					version: ns.version,

					/**
					 * Refreshes information about runtime
					 * @method refreshTheme
					 * @param {Function} done Callback run when the theme is discovered
					 * @member ns.info
					 * @return {null|String}
					 * @static
					 */
					refreshTheme: function (done) {
						var el = document.createElement("span"),
							parent = document.body,
							themeName;

						if (document.readyState !== "interactive" && document.readyState !== "complete") {
							eventUtils.fastOn(document, "DOMContentLoaded", this.refreshTheme.bind(this, done));
							return null;
						}
						el.classList.add("tau-info-theme");

						parent.appendChild(el);
						themeName = window.getComputedStyle(el, ":after").content;
						if (themeName) {
							themeName = themeName.replace(/\"/g, "");
						}
						parent.removeChild(el);

						if (themeName && themeName.length > 0) {
							this.theme = themeName;
						}

						themeName = themeName || null;

						if (done) {
							done(themeName);
						}

						return themeName;
					}
				};

			info.refreshTheme();

			ns.info = info;
			}(window, window.document));

/*global define: false, window: false, ns: false */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Selectors Utility
 * Object contains functions to get HTML elements by different selectors.
 * @class ns.util.selectors
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@partner.samsung.com>
 * @author Damian Osipiuk <d.osipiuk@samsung.com>
 */
(function (document, ns) {
	"use strict";
				/**
			 * @method slice Alias for array slice method
			 * @member ns.util.selectors
			 * @private
			 * @static
			 */
			var slice = [].slice,
				/**
				 * @method matchesSelectorType
				 * @return {string|boolean}
				 * @member ns.util.selectors
				 * @private
				 * @static
				 */
				matchesSelectorType = (function () {
					var el = document.createElement("div");

					if (typeof el.webkitMatchesSelector === "function") {
						return "webkitMatchesSelector";
					}

					if (typeof el.mozMatchesSelector === "function") {
						return "mozMatchesSelector";
					}

					if (typeof el.msMatchesSelector === "function") {
						return "msMatchesSelector";
					}

					if (typeof el.matchesSelector === "function") {
						return "matchesSelector";
					}

					if (typeof el.matches === "function") {
						return "matches";
					}

					return "";
				}());

			/**
			 * Prefix selector with 'data-' and namespace if present
			 * @method getDataSelector
			 * @param {string} selector
			 * @return {string}
			 * @member ns.util.selectors
			 * @private
			 * @static
			 */
			function getDataSelector(selector) {
				var namespace = ns.getConfig("namespace");

				return "[data-" + (namespace ? namespace + "-" : "") + selector + "]";
			}

			/**
			 * Runs matches implementation of matchesSelector
			 * method on specified element
			 * @method matchesSelector
			 * @param {HTMLElement} element
			 * @param {string} selector
			 * @return {boolean}
			 * @static
			 * @member ns.util.selectors
			 */
			function matchesSelector(element, selector) {
				if (matchesSelectorType && element[matchesSelectorType]) {
					return element[matchesSelectorType](selector);
				}
				return false;
			}

			/**
			 * Return array with all parents of element.
			 * @method parents
			 * @param {HTMLElement} element
			 * @return {Array}
			 * @member ns.util.selectors
			 * @private
			 * @static
			 */
			function parents(element) {
				var items = [],
					current = element.parentNode;

				while (current && current !== document) {
					items.push(current);
					current = current.parentNode;
				}
				return items;
			}

			/**
			 * Checks if given element and its ancestors matches given function
			 * @method closest
			 * @param {HTMLElement} element
			 * @param {Function} testFunction
			 * @return {?HTMLElement}
			 * @member ns.util.selectors
			 * @static
			 * @private
			 */
			function closest(element, testFunction) {
				var current = element;

				while (current && current !== document) {
					if (testFunction(current)) {
						return current;
					}
					current = current.parentNode;
				}
				return null;
			}

			/**
			 * @method testSelector
			 * @param {string} selector
			 * @param {HTMLElement} node
			 * @return {boolean}
			 * @member ns.util.selectors
			 * @static
			 * @private
			 */
			function testSelector(selector, node) {
				return matchesSelector(node, selector);
			}

			/**
			 * @method testClass
			 * @param {string} className
			 * @param {HTMLElement} node
			 * @return {boolean}
			 * @member ns.util.selectors
			 * @static
			 * @private
			 */
			function testClass(className, node) {
				return node && node.classList && node.classList.contains(className);
			}

			/**
			 * @method testTag
			 * @param {string} tagName
			 * @param {HTMLElement} node
			 * @return {boolean}
			 * @member ns.util.selectors
			 * @static
			 * @private
			 */
			function testTag(tagName, node) {
				return node.tagName.toLowerCase() === tagName;
			}

			/**
			 * @class ns.util.selectors
			 */
			ns.util.selectors = {
				matchesSelector: matchesSelector,

				/**
				 * Return array with children pass by given selector.
				 * @method getChildrenBySelector
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getChildrenBySelector: function (context, selector) {
					return slice.call(context.children).filter(testSelector.bind(null, selector));
				},

				/**
				 * Return array with children pass by given data-namespace-selector.
				 * @method getChildrenByDataNS
				 * @param {HTMLElement} context
				 * @param {string} dataSelector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getChildrenByDataNS: function (context, dataSelector) {
					return slice.call(context.children).filter(testSelector.bind(null,
						getDataSelector(dataSelector)));
				},

				/**
				 * Return array with children with given class name.
				 * @method getChildrenByClass
				 * @param {HTMLElement} context
				 * @param {string} className
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getChildrenByClass: function (context, className) {
					return slice.call(context.children).filter(testClass.bind(null, className));
				},

				/**
				 * Return array with children with given tag name.
				 * @method getChildrenByTag
				 * @param {HTMLElement} context
				 * @param {string} tagName
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getChildrenByTag: function (context, tagName) {
					return slice.call(context.children).filter(testTag.bind(null, tagName));
				},

				/**
				 * Return array with all parents of element.
				 * @method getParents
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getParents: parents,

				/**
				 * Return array with all parents of element pass by given selector.
				 * @method getParentsBySelector
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getParentsBySelector: function (context, selector) {
					return parents(context).filter(testSelector.bind(null, selector));
				},

				/**
				 * Return array with all parents of element pass by given selector with namespace.
				 * @method getParentsBySelectorNS
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getParentsBySelectorNS: function (context, selector) {
					return parents(context).filter(testSelector.bind(null, getDataSelector(selector)));
				},

				/**
				 * Return array with all parents of element with given class name.
				 * @method getParentsByClass
				 * @param {HTMLElement} context
				 * @param {string} className
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getParentsByClass: function (context, className) {
					return parents(context).filter(testClass.bind(null, className));
				},

				/**
				 * Return array with all parents of element with given tag name.
				 * @method getParentsByTag
				 * @param {HTMLElement} context
				 * @param {string} tagName
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getParentsByTag: function (context, tagName) {
					return parents(context).filter(testTag.bind(null, tagName));
				},

				/**
				 * Return first element from parents of element pass by selector.
				 * @method getClosestBySelector
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {HTMLElement}
				 * @static
				 * @member ns.util.selectors
				 */
				getClosestBySelector: function (context, selector) {
					return closest(context, testSelector.bind(null, selector));
				},

				/**
				 * Return first element from parents of element pass by selector with namespace.
				 * @method getClosestBySelectorNS
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {HTMLElement}
				 * @static
				 * @member ns.util.selectors
				 */
				getClosestBySelectorNS: function (context, selector) {
					return closest(context, testSelector.bind(null, getDataSelector(selector)));
				},

				/**
				 * Return first element from parents of element with given class name.
				 * @method getClosestByClass
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {HTMLElement}
				 * @static
				 * @member ns.util.selectors
				 */
				getClosestByClass: function (context, selector) {
					return closest(context, testClass.bind(null, selector));
				},

				/**
				 * Return first element from parents of element with given tag name.
				 * @method getClosestByTag
				 * @param {HTMLElement} context
				 * @param {string} selector
				 * @return {HTMLElement}
				 * @static
				 * @member ns.util.selectors
				 */
				getClosestByTag: function (context, selector) {
					return closest(context, testTag.bind(null, selector));
				},

				/**
				 * Return array of elements from context with given data-selector
				 * @method getAllByDataNS
				 * @param {HTMLElement} context
				 * @param {string} dataSelector
				 * @return {Array}
				 * @static
				 * @member ns.util.selectors
				 */
				getAllByDataNS: function (context, dataSelector) {
					return slice.call(context.querySelectorAll(getDataSelector(dataSelector)));
				},

				/**
				 * Get scrollable parent element
				 * @method getScrollableParent
				 * @param {HTMLElement} element
				 * @return {HTMLElement}
				 * @static
				 * @member ns.util.selectors
				 */
				getScrollableParent: function (element) {
					var overflow,
						style;

					while (element && element !== document.body) {
						style = window.getComputedStyle(element);

						if (style) {
							overflow = style.getPropertyValue("overflow-y");
							if (overflow === "scroll" || (overflow === "auto" &&
								element.scrollHeight > element.clientHeight)) {
								return element;
							}
						}
						element = element.parentNode;
					}
					return null;
				}
			};
			}(window.document, ns));

/*global define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Object Utility
 * Object contains functions help work with objects.
 * @class ns.util.object
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function () {
	"use strict";
	
			var object = {
				/**
				 * Copy object to new object
				 * @method copy
				 * @param {Object} orgObject
				 * @return {Object}
				 * @static
				 * @member ns.util.object
				 */
				copy: function (orgObject) {
					return object.merge({}, orgObject);
				},

				/**
				 * Attach fields from second object to first object.
				 * @method fastMerge
				 * @param {Object} newObject
				 * @param {Object} orgObject
				 * @return {Object}
				 * @static
				 * @member ns.util.object
				 */
				fastMerge: function (newObject, orgObject) {
					var key;

					for (key in orgObject) {
						if (orgObject.hasOwnProperty(key)) {
							newObject[key] = orgObject[key];
						}
					}
					return newObject;
				},

				/**
				 * Attach fields from second and next object to first object.
				 * @method merge
				 * @return {Object}
				 * @static
				 * @member ns.util.object
				 */
				merge: function (/* newObject, orgObject, override */) {
					var newObject,
						orgObject,
						override,
						key,
						args = [].slice.call(arguments),
						argsLength = args.length,
						i;

					newObject = args.shift();
					override = true;
					if (typeof arguments[argsLength - 1] === "boolean") {
						override = arguments[argsLength - 1];
						argsLength--;
					}
					for (i = 0; i < argsLength; i++) {
						orgObject = args.shift();
						if (orgObject !== null) {
							for (key in orgObject) {
								if (orgObject.hasOwnProperty(key) && (override || newObject[key] === undefined)) {
									newObject[key] = orgObject[key];
								}
							}
						}
					}
					return newObject;
				},

				/**
				 * Function add to Constructor prototype Base object and add to prototype properties and methods from
				 * prototype object.
				 * @method inherit
				 * @param {Function} Constructor
				 * @param {Function} Base
				 * @param {Object} prototype
				 * @static
				 * @member ns.util.object
				 */
				/* jshint -W083 */
				inherit: function (Constructor, Base, prototype) {
					var basePrototype = new Base(),
						property,
						value;

					for (property in prototype) {
						if (prototype.hasOwnProperty(property)) {
							value = prototype[property];
							if (typeof value === "function") {
								basePrototype[property] = (function createFunctionWithSuper(Base, property, value) {
									var _super = function () {
										var superFunction = Base.prototype[property];

										if (superFunction) {
											return superFunction.apply(this, arguments);
										}
										return null;
									};

									return function () {
										var __super = this._super,
											returnValue;

										this._super = _super;
										returnValue = value.apply(this, arguments);
										this._super = __super;
										return returnValue;
									};
								}(Base, property, value));
							} else {
								basePrototype[property] = value;
							}
						}
					}

					Constructor.prototype = basePrototype;
					Constructor.prototype.constructor = Constructor;
				},

				/**
				 * Returns true if every property value corresponds value from 'value' argument
				 * @method hasPropertiesOfValue
				 * @param {Object} obj
				 * @param {*} [value=undefined]
				 * @return {boolean}
				 */
				hasPropertiesOfValue: function (obj, value) {
					var keys = Object.keys(obj),
						i = keys.length;

					// Empty array should return false
					if (i === 0) {
						return false;
					}

					while (--i >= 0) {
						if (obj[keys[i]] !== value) {
							return false;
						}
					}

					return true;
				},

				/**
				 * Remove properties from object.
				 * @method removeProperties
				 * @param {Object} object
				 * @param {Array} propertiesToRemove
				 * @return {Object}
				 */
				removeProperties: function (object, propertiesToRemove) {
					var length = propertiesToRemove.length,
						property,
						i;

					for (i = 0; i < length; i++) {
						property = propertiesToRemove[i];
						if (object.hasOwnProperty(property)) {
							delete object[property];
						}
					}
					return object;
				}
			};

			ns.util.object = object;
			}());

/*global window, define, ns, Node */
/*jslint nomen: true, plusplus: true, bitwise: false */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Engine
 * Main class with engine of library which control communication
 * between parts of framework.
 * @class ns.engine
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Michal Szepielak <m.szepielak@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@partner.samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author Przemyslaw Ciezkowski <p.ciezkowski@samsung.com>
 * @author Hyunkook, Cho <hk0713.cho@samsung.com>
 * @author Hyeoncheol Choi <hc7.choi@samsung.com>
 * @author Piotr Ostalski <p.ostalski@samsung.com>
 */
(function (window, document) {
	"use strict";
				var slice = [].slice,
				/**
				 * @property {Object} eventUtils {@link ns.event}
				 * @private
				 * @static
				 * @member ns.engine
				 */
				eventUtils = ns.event,
				util = ns.util,
				objectUtils = util.object,
				selectors = util.selectors,
				arrayUtils = ns.util.array,
				/**
				 * @property {Object} widgetDefinitions Object with widgets definitions
				 * @private
				 * @static
				 * @member ns.engine
				 */
				widgetDefinitions = {},
				/**
				 * @property {Object} widgetBindingMap Object with widgets bindings
				 * @private
				 * @static
				 * @member ns.engine
				 */
				widgetBindingMap = {},
				location = window.location,
				/**
				 * engine mode, if true then engine only builds widgets
				 * @property {boolean} justBuild
				 * @private
				 * @static
				 * @member ns.engine
				 */
				justBuild = location.hash === "#build",
				/**
				 * @property {string} [TYPE_STRING="string"] local cache of string type name
				 * @private
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				TYPE_STRING = "string",
				/**
				 * @property {string} [TYPE_FUNCTION="function"] local cache of function type name
				 * @private
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				TYPE_FUNCTION = "function",
				/**
				 * @property {string} [DATA_BUILT="data-tau-built"] attribute informs that widget id build
				 * @private
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				DATA_BUILT = "data-tau-built",
				/**
				 * @property {string} [DATA_NAME="data-tau-name"] attribute contains widget name
				 * @private
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				DATA_NAME = "data-tau-name",
				/**
				 * @property {string} [DATA_BOUND="data-tau-bound"] attribute informs that widget id bound
				 * @private
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				DATA_BOUND = "data-tau-bound",
				/**
				 * @property {string} NAMES_SEPARATOR
				 * @private
				 * @static
				 * @readonly
				 */
				NAMES_SEPARATOR = ",",
				/**
				 * @property {string} [querySelectorWidgets="*[data-tau-built][data-tau-name]:not([data-tau-bound])"] query selector for all widgets which are built but not bound
				 * @private
				 * @static
				 * @member ns.engine
				 */
				querySelectorWidgets = "*[" + DATA_BUILT + "][" + DATA_NAME + "]:not([" + DATA_BOUND + "])",
				/**
				 * @method excludeBuildAndBound
				 * @private
				 * @static
				 * @param {string} widgetType
				 * @member ns.engine
				 * @return {string} :not([data-tau-built*='widgetName']):not([data-tau-bound*='widgetName'])
				 */
				excludeBuiltAndBound = function (widgetType) {
					return ":not([" + DATA_BUILT + "*='" + widgetType + "']):not([" + DATA_BOUND + "*='" + widgetType + "'])";
				},

				/**
				 * Engine event types
				 * @property {Object} eventType
				 * @property {string} eventType.INIT="tauinit" INIT of framework init event
				 * @property {string} eventType.WIDGET_BOUND="widgetbound" WIDGET_BOUND of widget bound event
				 * @property {string} eventType.WIDGET_DEFINED="widgetdefined" WIDGET_DEFINED of widget built event
				 * @property {string} eventType.WIDGET_BUILT="widgetbuilt" WIDGET_BUILT of widget built event
				 * @property {string} eventType.BOUND="bound" BOUND of bound event
				 * @static
				 * @readonly
				 * @member ns.engine
				 */
				eventType = {
					INIT: "tauinit",
					READY: "tauready",
					WIDGET_BOUND: "widgetbound",
					WIDGET_DEFINED: "widgetdefined",
					WIDGET_BUILT: "widgetbuilt",
					DESTROY: "taudestroy",
					BOUND: "bound",
					WIDGET_INIT: "init",
					STOP_ROUTING: "tauroutingstop"
				},
				engine;

			/**
			 * This function prepares selector for widget' definition
			 * @method selectorChange
			 * @param {string} selectorName
			 * @return {string} new selector
			 * @member ns.engine
			 * @static
			 */
			function selectorChange(selectorName) {
				if (selectorName.match(/\[data-role=/) && !selectorName.match(/:not\(\[data-role=/)) {
					return selectorName.trim();
				}
				return selectorName.trim() + ":not([data-role='none'])";
			}

			/**
			 * Function to define widget
			 * @method defineWidget
			 * @param {string} name
			 * @param {string} selector
			 * @param {Array} methods
			 * @param {Object} widgetClass
			 * @param {string} [namespace]
			 * @param {boolean} [redefine]
			 * @param {boolean} [widgetNameToLowercase=true]
			 * @return {boolean}
			 * @member ns.engine
			 * @static
			 */
			function defineWidget(name, selector, methods, widgetClass, namespace, redefine, widgetNameToLowercase, BaseElement, buildOptions) {
				var definition;
				// Widget name is absolutely required

				buildOptions = buildOptions || {};
				if (name) {
					if (!widgetDefinitions[name] || redefine) {
												methods = methods || [];
						methods.push("destroy", "disable", "enable", "option", "refresh", "value");
						definition = {
							name: name,
							methods: methods,
							selector: selector || "",
							selectors: selector ? selector.split(",").map(selectorChange) : [],
							widgetClass: widgetClass || null,
							namespace: namespace || "",
							widgetNameToLowercase: widgetNameToLowercase === undefined ? true : !!widgetNameToLowercase,
							BaseElement: BaseElement,
							buildOptions: buildOptions
						};

						widgetDefinitions[name] = definition;
						if (namespace) {
							widgetDefinitions[namespace + "." + name] = definition;
						}
						eventUtils.trigger(document, "widgetdefined", definition, false);
						return true;
					}
									} else {
					ns.error("Widget with selector [" + selector + "] defined without a name, aborting!");
				}
				return false;
			}


			/**
			 * Get widget instance from binding for given element and type
			 * @method getInstanceByElement
			 * @static
			 * @param {Object} binding
			 * @param {HTMLElement} element
			 * @param {string} [type] widget name, if is empty then return first built widget
			 * @return {?Object}
			 * @member ns.engine
			 */
			function getInstanceByElement(binding, element, type) {
				var widgetInstance,
					bindingElement,
					storedWidgetNames,
					names = type ? type.split(".") : [],
					name = names.pop(),
					namespace = names.pop();

				// If name is defined it's possible to fetch it instantly
				if (name) {
					widgetInstance = binding.instances[name];
				} else {
					storedWidgetNames = Object.keys(binding.instances);
					widgetInstance = binding.instances[storedWidgetNames[0]];
				}

				if (namespace && widgetInstance && widgetInstance.namespace !== namespace) {
					widgetInstance = null;
				}

				// Return only it instance of the proper widget exists
				if (widgetInstance) {
					
					// Check if widget instance has that same object referenced
					if (widgetInstance.element === element) {
						return widgetInstance;
					}
				}

				return null;
			}

			/**
			 * Get binding for element
			 * @method getBinding
			 * @static
			 * @param {HTMLElement|string} element
			 * @param {string} [type] widget name
			 * @return {?Object}
			 * @member ns.engine
			 */
			function getBinding(element, type) {
				var id = !element || typeof element === TYPE_STRING ? element : element.id,
					binding;

				if (typeof element === TYPE_STRING) {
					element = document.getElementById(id);
				}

				if (element) {
					// Fetch group of widget defined for this element
					binding = widgetBindingMap[id];

					if (binding && typeof binding === "object") {
						return getInstanceByElement(binding, element, type);
					}
				}

				return null;
			}

			/**
			 * Set binding of widget
			 * @method setBinding
			 * @param {ns.widget.BaseWidget} widgetInstance
			 * @static
			 * @member ns.engine
			 */
			function setBinding(widgetInstance) {
				var id = widgetInstance.element.id,
					type = widgetInstance.name,
					widgetBinding = widgetBindingMap[id];

				
				// If the HTMLElement never had a widget declared create an empty object
				if (!widgetBinding) {
					widgetBinding = {
						elementId: id,
						element: widgetInstance.element,
						instances: {}
					};
				}

				widgetBinding.instances[type] = widgetInstance;
				widgetBindingMap[id] = widgetBinding;
			}

			/**
			 * Returns all bindings for element or id gives as parameter
			 * @method getAllBindings
			 * @param {HTMLElement|string} element
			 * @return {?Object}
			 * @static
			 * @member ns.engine
			 */
			function getAllBindings(element) {
				var id = !element || typeof element === TYPE_STRING ? element : element.id;

				return (widgetBindingMap[id] && widgetBindingMap[id].instances) || null;
			}

			/**
			 * Removes given name from attributeValue string.
			 * Names should be separated with a NAMES_SEPARATOR
			 * @param {string} name
			 * @param {string} attributeValue
			 * @private
			 * @static
			 * @return {string}
			 */
			function _removeWidgetNameFromAttribute(name, attributeValue) {
				var widgetNames,
					searchResultIndex;

				// Split attribute value by separator
				widgetNames = attributeValue.split(NAMES_SEPARATOR);
				searchResultIndex = widgetNames.indexOf(name);

				if (searchResultIndex > -1) {
					widgetNames.splice(searchResultIndex, 1);
					attributeValue = widgetNames.join(NAMES_SEPARATOR);
				}

				return attributeValue;
			}

			function _removeAllBindingAttributes(element) {
				element.removeAttribute(DATA_BUILT);
				element.removeAttribute(DATA_BOUND);
				element.removeAttribute(DATA_NAME);
			}

			/**
			 * Remove binding data attributes for element.
			 * @method _removeBindingAttributes
			 * @param {HTMLElement} element
			 * @param {string} type widget type (name)
			 * @private
			 * @static
			 * @member ns.engine
			 */
			function _removeWidgetFromAttributes(element, type) {
				var dataBuilt,
					dataBound,
					dataName;

				// Most often case is that name is not defined
				if (!type) {
					_removeAllBindingAttributes(element);
				} else {
					dataBuilt = _removeWidgetNameFromAttribute(type, element.getAttribute(DATA_BUILT) || "");
					dataBound = _removeWidgetNameFromAttribute(type, element.getAttribute(DATA_BOUND) || "");
					dataName = _removeWidgetNameFromAttribute(type, element.getAttribute(DATA_NAME) || "");

					// Check if all attributes have at least one widget
					if (dataBuilt && dataBound && dataName) {
						element.setAttribute(DATA_BUILT, dataBuilt);
						element.setAttribute(DATA_BOUND, dataBound);
						element.setAttribute(DATA_NAME, dataName);
					} else {
						// If something is missing remove everything
						_removeAllBindingAttributes(element);
					}
				}
			}

			/**
			 * Method removes binding for single widget.
			 * @method _removeSingleBinding
			 * @param {Object} bindingGroup
			 * @param {string} type
			 * @return {boolean}
			 * @private
			 * @static
			 */
			function _removeSingleBinding(bindingGroup, type) {
				var widgetInstance = bindingGroup[type];

				if (widgetInstance) {
					if (widgetInstance.element && typeof widgetInstance.element.setAttribute === TYPE_FUNCTION) {
						_removeWidgetFromAttributes(widgetInstance.element, type);
					}

					delete bindingGroup[type];

					return true;
				}

				return false;
			}

			/**
			 * Remove group of bindings for all types of widgets based on the same element
			 * @method removeGroupBindingAllTypes
			 * @param {Object} bindingGroup
			 * @param {string} id widget element id
			 * @return {boolean}
			 * @static
			 * @member ns.engine
			 */
			function removeGroupBindingAllTypes(bindingGroup, id) {
				var singleSuccess,
					widgetName,
					fullSuccess = true;

				// Iterate over group of created widgets
				for (widgetName in bindingGroup) {
					if (bindingGroup.hasOwnProperty(widgetName)) {
						singleSuccess = _removeSingleBinding(bindingGroup, widgetName);
						
						// As we iterate over keys we are sure we want to remove this element
						// NOTE: Removing property by delete is slower than assigning null value
						bindingGroup[widgetName] = null;

						fullSuccess = (fullSuccess && singleSuccess);
					}
				}

				// If the object bindingGroup is empty or every key has a null value
				if (objectUtils.hasPropertiesOfValue(bindingGroup, null)) {
					// NOTE: Removing property by delete is slower than assigning null value
					widgetBindingMap[id] = null;
				}

				return fullSuccess;
			}

			/**
			 * Remove group of bindings for widgets based on the same element
			 * @method removeGroupBinding
			 * @param {Object} bindingGroup
			 * @param {string} type object name
			 * @param {string} id widget element id
			 * @return {boolean}
			 * @static
			 * @member ns.engine
			 */
			function removeGroupBinding(bindingGroup, type, id) {
				var success;

				if (!type) {
					success = removeGroupBindingAllTypes(bindingGroup, id);
				} else {
					success = _removeSingleBinding(bindingGroup, type);
					if (objectUtils.hasPropertiesOfValue(bindingGroup, null)) {
						widgetBindingMap[id] = null;
					}
				}
				return success;
			}

			/**
			 * Remove binding for widget based on element.
			 * @method removeBinding
			 * @param {HTMLElement|string} element
			 * @param {?string} [type=null] widget name
			 * @return {boolean}
			 * @static
			 * @member ns.engine
			 */
			function removeBinding(element, type) {
				var id = (typeof element === TYPE_STRING) ? element : element.id,
					binding = widgetBindingMap[id],
					bindingGroup;

				// [NOTICE] Due to backward compatibility calling removeBinding
				// with one parameter should remove all bindings

				if (binding) {
					if (typeof element === TYPE_STRING) {
						// Search based on current document may return bad results,
						// use previously defined element if it exists
						element = binding.element;
					}

					if (element) {
						_removeWidgetFromAttributes(element, type);
					}

					bindingGroup = widgetBindingMap[id] && widgetBindingMap[id].instances;
					if (bindingGroup) {
						return removeGroupBinding(bindingGroup, type, id);
					}

					if (widgetBindingMap[id].instances && (Object.keys(widgetBindingMap[id].instances).length === 0)) {
						widgetBindingMap[id] = null;
					}
				}

				return false;
			}

			/**
			 * Removes all bindings of widgets.
			 * @method removeAllBindings
			 * @param {HTMLElement|string} element
			 * @return {boolean}
			 * @static
			 * @member ns.engine
			 */
			function removeAllBindings(element) {
				// @TODO this should be coded in the other way around, removeAll should loop through all bindings and inside call removeBinding
				// but due to backward compatibility that code should be more readable
				return removeBinding(element);
			}

			/**
			 * If element not exist create base element for widget.
			 * @method ensureElement
			 * @param {HTMLElement} element
			 * @param {ns.widget.BaseWidget} Widget
			 * @return {HTMLElement}
			 * @static
			 * @private
			 * @member ns.engine
			 */
			function ensureElement(element, Widget) {
				if (!element || !(element instanceof HTMLElement)) {
					if (typeof Widget.createEmptyElement === TYPE_FUNCTION) {
						element = Widget.createEmptyElement();
					} else {
						element = document.createElement("div");
					}
				}
				return element;
			}

			/**
			 * Process core widget method
			 * - configure
			 * - build
			 * - init
			 * - bindEvents
			 * @method processWidget
			 * @param {HTMLElement} element base element of widget
			 * @param {Object} widgetInstance instance of widget
			 * @param {Object} definition definition of widget
			 * @param {ns.widget.BaseWidget} definition.widgetClass
			 * @param {string} definition.name
			 * @param {Object} [options] options for widget
			 * @private
			 * @static
			 * @member ns.engine
			 */
			function coreProcessWidget(element, widgetInstance, definition, options) {
				var widgetOptions = options || {},
					createFunction = widgetOptions.create,
					buildAttribute;

				
				element = widgetInstance.configure(definition, element, options);

				// Run .create method from widget options when a [widgetName]create event is triggered
				if (typeof createFunction === TYPE_FUNCTION) {
					eventUtils.one(element, definition.name.toLowerCase() + "create", createFunction);
				}

				if (element.id) {
					widgetInstance.id = element.id;
				}

				// Check if this type of widget was build for this element before
				buildAttribute = element.getAttribute(DATA_BUILT);
				if (!buildAttribute ||
					buildAttribute.split(NAMES_SEPARATOR).indexOf(widgetInstance.name) === -1) {
					element = widgetInstance.build(element);
				}

				if (element) {
					widgetInstance.element = element;

					setBinding(widgetInstance);

					widgetInstance.trigger(eventType.WIDGET_BUILT, widgetInstance, false);

					if (!justBuild) {
						widgetInstance.init(element);
					}

					widgetInstance.bindEvents(element, justBuild);

					widgetInstance.trigger(widgetInstance.widgetEventPrefix + eventType.WIDGET_INIT);
					widgetInstance.trigger(eventType.WIDGET_BOUND, widgetInstance, false);
					eventUtils.trigger(document, eventType.WIDGET_BOUND, widgetInstance);
				} else {
									}
			}

			/**
			 * Load widget
			 * @method processWidget
			 * @param {HTMLElement} element base element of widget
			 * @param {Object} definition definition of widget
			 * @param {ns.widget.BaseWidget} definition.widgetClass
			 * @param {string} definition.name
			 * @param {Object} [options] options for widget
			 * @return {?HTMLElement}
			 * @private
			 * @static
			 * @member ns.engine
			 */
			function processWidget(element, definition, options) {
				var Widget = definition.widgetClass,
					/**
					 * @type {ns.widget.BaseWidget} widgetInstance
					 */
					widgetInstance,
					parentEnhance,
					existingBinding;

				element = ensureElement(element, Widget);
				widgetInstance = Widget ? new Widget(element, options) : false;

				// if any parent has attribute data-enhance=false then stop building widgets
				parentEnhance = selectors.getParentsBySelectorNS(element, "enhance=false");

				// While processing widgets queue other widget may built this one before
				// it reaches it's turn
				existingBinding = getBinding(element, definition.name);
				if (existingBinding && existingBinding.element === element) {
					return element;
				}

				if (widgetInstance) {
					if (!parentEnhance.length) {
						coreProcessWidget(element, widgetInstance, definition, options);
					}
					return widgetInstance.element;
				}

				return null;
			}

			/**
			 * Destroys widget of given 'type' for given HTMLElement.
			 * [NOTICE] This method won't destroy any children widgets.
			 * @method destroyWidget
			 * @param {HTMLElement|string} element
			 * @param {string} type
			 * @static
			 * @member ns.engine
			 */
			function destroyWidget(element, type) {
				var widgetInstance;

				if (typeof element === TYPE_STRING) {
					element = document.getElementById(element);
				}

				
				// If type is not defined all widgets should be removed
				// this is for backward compatibility
				widgetInstance = getBinding(element, type);

				if (widgetInstance) {
					//Destroy widget
					widgetInstance.destroy();
					widgetInstance.trigger("widgetdestroyed");

					removeBinding(element, type);
				}
			}

			/**
			 * Calls destroy on group of widgets connected with given HTMLElement
			 * @method destroyGroupWidgets
			 * @param {HTMLElement|string} element
			 * @static
			 * @private
			 * @member ns.engine
			 */
			function destroyGroupWidgets(element) {
				var widgetName,
					widgetInstance,
					widgetGroup;

				widgetGroup = getAllBindings(element);
				for (widgetName in widgetGroup) {
					if (widgetGroup.hasOwnProperty(widgetName)) {
						widgetInstance = widgetGroup[widgetName];

						//Destroy widget
						if (widgetInstance) {
							widgetInstance.destroy();
							widgetInstance.trigger("widgetdestroyed");
						}
					}
				}
			}

			/**
			 * Calls destroy on widget (or widgets) connected with given HTMLElement
			 * Removes child widgets as well.
			 * @method destroyAllWidgets
			 * @param {HTMLElement|string} element
			 * @param {boolean} [childOnly=false] destroy only widgets on children elements
			 * @static
			 * @member ns.engine
			 */
			function destroyAllWidgets(element, childOnly) {
				var childWidgets,
					i;

				if (typeof element === TYPE_STRING) {
					element = document.getElementById(element);
				}

				
				if (!childOnly) {
					// If type is not defined all widgets should be removed
					// this is for backward compatibility
					destroyGroupWidgets(element);
				}

				//Destroy child widgets, if something left.
				childWidgets = slice.call(element.querySelectorAll("[" + DATA_BOUND + "]"));
				for (i = childWidgets.length - 1; i >= 0; i -= 1) {
					if (childWidgets[i]) {
						destroyAllWidgets(childWidgets[i], false);
					}
				}

				removeAllBindings(element);
			}

			/**
			 * Load widgets from data-* definition
			 * @method processHollowWidget
			 * @param {HTMLElement} element base element of widget
			 * @param {Object} definition widget definition
			 * @param {Object} [options] options for create widget
			 * @return {HTMLElement} base element of widget
			 * @private
			 * @static
			 * @member ns.engine
			 */
			function processHollowWidget(element, definition, options) {
				var name = (element && element.getAttribute(DATA_NAME)) ||
					(definition && definition.name);
								definition = definition || (name && widgetDefinitions[name]) || {
					"name": name
				};
				return processWidget(element, definition, options);
			}

			/**
			 * Compare function for nodes on build queue
			 * @param {Object} nodeA
			 * @param {Object} nodeB
			 * @return {number}
			 * @private
			 * @static
			 */
			function compareByDepth(nodeA, nodeB) {
				/*jshint -W016 */
				var mask = Node.DOCUMENT_POSITION_CONTAINS | Node.DOCUMENT_POSITION_PRECEDING;

				if (nodeA.element === nodeB.element) {
					return 0;
				}

				if (nodeA.element.compareDocumentPosition(nodeB.element) & mask) {
					return 1;
				}
				/*jshint +W016 */
				return -1;
			}

			/**
			 * Processes one build queue item. Runs processHollowWidget
			 * underneath
			 * @method processBuildQueueItem
			 * @param {Object|HTMLElement} queueItem
			 * @private
			 * @static
			 */
			function processBuildQueueItem(queueItem) {
				// HTMLElement doesn't have .element property
				// widgetDefinitions will return undefined when called widgetDefinitions[undefined]
				processHollowWidget(queueItem.element || queueItem, widgetDefinitions[queueItem.widgetName]);
			}

			/**
			 * Build widgets on all children of context element
			 * @method createWidgets
			 * @static
			 * @param {HTMLElement} context base html for create children
			 * @member ns.engine
			 */
			function createWidgets(context) {
				// find widget which are built
				var builtWidgetElements = slice.call(context.querySelectorAll(querySelectorWidgets)),
					normal,
					buildQueue = [],
					selectorKeys = Object.keys(widgetDefinitions),
					excludeSelector,
					i,
					j,
					len = selectorKeys.length,
					definition,
					widgetName,
					definitionSelectors;

				
				
				// process built widgets
				builtWidgetElements.forEach(processBuildQueueItem);

				// process widgets didn't build
				for (i = 0; i < len; ++i) {
					widgetName = selectorKeys[i];
					if (widgetName.indexOf(".") === -1) {
						definition = widgetDefinitions[widgetName];
						definitionSelectors = definition.selectors;
						if (definitionSelectors.length) {
							excludeSelector = excludeBuiltAndBound(widgetName);

							normal = slice.call(context.querySelectorAll(definitionSelectors.join(excludeSelector + ",") +
							excludeSelector));
							j = normal.length;

							while (--j >= 0) {
								buildQueue.push({
									element: normal[j],
									widgetName: widgetName
								});
							}
						}
					}
				}

				// Sort queue by depth, on every DOM branch outer most element go first
				buildQueue.sort(compareByDepth);

				// Build all widgets from queue
				buildQueue.forEach(processBuildQueueItem);

				
				eventUtils.trigger(document, "built");
				eventUtils.trigger(document, eventType.BOUND);
							}

			/**
			 * Handler for event create
			 * @method createEventHandler
			 * @param {Event} event
			 * @static
			 * @member ns.engine
			 */
			function createEventHandler(event) {
				createWidgets(event.target);
			}

			function setViewport() {
				/**
				 * Sets viewport tag if not exists
				 */
				var documentHead = document.head,
					metaTagListLength,
					metaTagList,
					metaTag,
					i;

				metaTagList = documentHead.querySelectorAll("[name=\"viewport\"]");
				metaTagListLength = metaTagList.length;

				if (metaTagListLength > 0) {
					// Leave the last viewport tag
					--metaTagListLength;

					// Remove duplicated tags
					for (i = 0; i < metaTagListLength; ++i) {
						// Remove meta tag from DOM
						documentHead.removeChild(metaTagList[i]);
					}
				} else {
					// Create new HTML Element
					metaTag = document.createElement("meta");

					// Set required attributes
					metaTag.setAttribute("name", "viewport");
					metaTag.setAttribute("content", "width=device-width, user-scalable=no");

					// Force that viewport tag will be first child of head
					if (documentHead.firstChild) {
						documentHead.insertBefore(metaTag, documentHead.firstChild);
					} else {
						documentHead.appendChild(metaTag);
					}
				}
			}

			/**
			 * Build first page
			 * @method build
			 * @static
			 * @member ns.engine
			 */
			function build() {
				eventUtils.trigger(document, eventType.READY);
				setViewport();
			}

			/**
			 * Method to remove all listeners bound in run
			 * @method stop
			 * @static
			 * @member ns.engine
			 */
			function stop() {
				eventUtils.trigger(document, eventType.STOP_ROUTING);
			}

			/**
			 * Method to remove all listeners bound in run
			 * @method destroy
			 * @static
			 * @member ns.engine
			 */
			function destroy() {
				stop();
				eventUtils.fastOff(document, "create", createEventHandler);
				destroyAllWidgets(document, true);
				eventUtils.trigger(document, eventType.DESTROY);
			}

			/**
			 * Add to object value at index equal to type of arg.
			 * @method getType
			 * @param {Object} result
			 * @param {*} arg
			 * @return {Object}
			 * @static
			 * @private
			 * @member ns.engine
			 */
			function getType(result, arg) {
				var type = arg instanceof HTMLElement ? "HTMLElement" : typeof arg;

				result[type] = arg;
				return result;
			}

			/**
			 * Convert args array to object with keys being types and arguments mapped by values
			 * @method getArgumentsTypes
			 * @param {Arguments[]} args
			 * @return {Object}
			 * @static
			 * @private
			 * @member ns.engine
			 */
			function getArgumentsTypes(args) {
				return arrayUtils.reduce(args, getType, {});
			}

			ns.widgetDefinitions = {};
			engine = {
				justBuild: location.hash === "#build",
				/**
				 * object with names of engine attributes
				 * @property {Object} dataTau
				 * @property {string} [dataTau.built="data-tau-built"] attribute inform that widget id build
				 * @property {string} [dataTau.name="data-tau-name"] attribute contains widget name
				 * @property {string} [dataTau.bound="data-tau-bound"] attribute inform that widget id bound
				 * @property {string} [dataTau.separator=","] separation string for widget names
				 * @static
				 * @member ns.engine
				 */
				dataTau: {
					built: DATA_BUILT,
					name: DATA_NAME,
					bound: DATA_BOUND,
					separator: NAMES_SEPARATOR
				},
				destroyWidget: destroyWidget,
				destroyAllWidgets: destroyAllWidgets,
				createWidgets: createWidgets,

				/**
				 * Method to get all definitions of widgets
				 * @method getDefinitions
				 * @return {Object}
				 * @static
				 * @member ns.engine
				 */
				getDefinitions: function () {
					return widgetDefinitions;
				},
				/**
				 * Returns definition of widget
				 * @method getWidgetDefinition
				 * @param {string} name
				 * @static
				 * @member ns.engine
				 * @return {Object}
				 */
				getWidgetDefinition: function (name) {
					return widgetDefinitions[name];
				},
				defineWidget: defineWidget,
				getBinding: getBinding,
				getAllBindings: getAllBindings,
				setBinding: setBinding,
				removeBinding: removeBinding,
				removeAllBindings: removeAllBindings,

				/**
				 * Clear bindings of widgets
				 * @method _clearBindings
				 * @static
				 * @member ns.engine
				 */
				_clearBindings: function () {
					//clear and set references to the same object
					widgetBindingMap = {};
				},

				build: build,

				/**
				 * Run engine
				 * @method run
				 * @static
				 * @member ns.engine
				 */
				run: function () {
										// stop the TAU process if exists before
					stop();

					eventUtils.fastOn(document, "create", createEventHandler);

					eventUtils.trigger(document, eventType.INIT, {tau: ns});

					switch (document.readyState) {
						case "interactive":
						case "complete":
							// build widgets and initiate router
							build();
							break;
						default:
							// build widgets and initiate router
							eventUtils.one(document, "DOMContentLoaded", build.bind(engine));
							break;
					}
				},

				/**
				 * Build instance of widget and binding events
				 * Returns error when empty element is passed
				 * @method instanceWidget
				 * @param {HTMLElement|string} [element]
				 * @param {string} name
				 * @param {Object} [options]
				 * @return {?Object}
				 * @static
				 * @member ns.engine
				 */
				instanceWidget: function (element, name, options) {
					var binding,
						definition,
						argumentsTypes = getArgumentsTypes(arguments);

					// Map arguments with specific types to correct variables
					// Only name is required argument
					element = argumentsTypes.HTMLElement;
					name = argumentsTypes.string;
					options = argumentsTypes.object;
					// If element exists try to find existing binding
					if (element) {
						binding = getBinding(element, name);
					}
					// If didn't found binding build new widget
					if (!binding && widgetDefinitions[name]) {
						definition = widgetDefinitions[name];
						if (definition.buildOptions.requireMatchSelector &&
							!ns.util.selectors.matchesSelector(element, definition.selector)) {
							return null;
						}
						element = processHollowWidget(element, definition, options);
						binding = getBinding(element, name);
					} else if (binding) {
						// if widget was built early we should set options delivered to constructor
						binding.option(options);
					}
					return binding;
				},

				stop: stop,

				destroy: destroy,

				/**
				 * Method to change build mode
				 * @method setJustBuild
				 * @param {boolean} newJustBuild
				 * @static
				 * @member ns.engine
				 */
				setJustBuild: function (newJustBuild) {
					// Set location hash to have a consistent behavior
					if (newJustBuild) {
						location.hash = "build";
					} else {
						location.hash = "";
					}

					justBuild = newJustBuild;
				},

				/**
				 * Method to get build mode
				 * @method getJustBuild
				 * @return {boolean}
				 * @static
				 * @member ns.engine
				 */
				getJustBuild: function () {
					return justBuild;
				},
				_createEventHandler: createEventHandler
			};

			engine.eventType = eventType;
			ns.engine = engine;
			}(window, window.document));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping namespace
 * Object maps all methods enabling jQuery Mobile API.
 * @class ns.jqm
 */
(function (ns, window) {
	"use strict";
				var eventType = ns.engine.eventType;

			ns.jqm = {
				/**
				 * jQuery object
				 * @property {Object} jQuery
				 * @member ns.jqm
				 */
				jQuery: ns.getConfig("jQuery") || window.jQuery
			};

			/**
			 * Initialize framework in the same way as it is done in jQueryMobile
			 */
			function init() {
				// Tell the world that JQM is ready to serve Tau
				ns.event.trigger(document, "mobileinit");
			}

			/**
			 * Removes events listeners on framework destroy.
			 */
			function destroy() {
				document.removeEventListener(eventType.INIT, init, false);
				document.removeEventListener(eventType.DESTROY, destroy, false);
			}

			document.addEventListener(eventType.INIT, init, false);
			document.addEventListener(eventType.DESTROY, destroy, false);

			}(ns, window));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/**
 * #jQuery Mobile mapping defaults
 * Object maps default values from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.defaults
 */
(function (window, document) {
	"use strict";
				var engineEventsType = ns.engine.eventType,
				$ = ns.jqm.jQuery,
				eventType = {
					INIT: engineEventsType.INIT,
					DESTROY: engineEventsType.DESTROY
				},
				defaults = {
					/**
					 * Proxy colors library from ns namespace to jQM namespace
					 * @method init
					 * @member ns.jqm.defaults
					 * @static
					 */
					init: function () {
						if ($) {

							$.mobile = $.mobile || {};
							// Version of the jQuery Mobile Framework
							//$.mobile.version: __version__;

							// Namespace used framework-wide for data-attrs. Default is no namespace
							$.mobile.ns = "";

							// Define the url parameter used for referencing widget-generated sub-pages.
							// Translates to to example.html&ui-page=subpageIdentifier
							// hash segment before &ui-page= is used to make Ajax request
							$.mobile.subPageUrlKey = "ui-page";

							// Class assigned to page currently in view; and during transitions
							$.mobile.activePageClass = "ui-page-active";

							// Class used for "active" button state; from CSS framework
							$.mobile.activeBtnClass = "ui-btn-active";

							// Class used for "focus" form element state; from CSS framework
							$.mobile.focusClass = "ui-focus";

							// Automatically handle clicks and form submissions through Ajax; when same-domain
							$.mobile.ajaxEnabled = true;

							// Automatically load and show pages based on location.hash
							$.mobile.hashListeningEnabled = true;

							// disable to prevent jquery from bothering with links
							$.mobile.linkBindingEnabled = true;

							// Set default page transition - 'none' for no transitions
							$.mobile.defaultPageTransition = "fade";

							// Set maximum window width for transitions to apply - 'false' for no limit
							$.mobile.maxTransitionWidth = false;

							// Minimum scroll distance that will be remembered when returning to a page
							$.mobile.minScrollBack = 250;

							// DEPRECATED = the following property is no longer in use; but defined until 2.0 to prevent conflicts
							$.mobile.touchOverflowEnabled = false;

							// Set default dialog transition - 'none' for no transitions
							$.mobile.defaultDialogTransition = "pop";

							// Error response message - appears when an Ajax page request fails
							$.mobile.pageLoadErrorMessage = "Error Loading Page";

							// replace calls to window.history.back with phonegaps navigation helper
							// where it is provided on the window object
							$.mobile.phonegapNavigationEnabled = false;

							//automatically initialize the DOM when it's ready
							$.mobile.autoInitializePage = true;

							$.mobile.pushStateEnabled = true;

							// allows users to opt in to ignoring content by marking a parent element as
							// data-ignored
							$.mobile.ignoreContentEnabled = false;

							// turn of binding to the native orientationchange due to android orientation behavior
							$.mobile.orientationChangeEnabled = true;

							$.mobile.tizen = $.mobile.tizen || {};
							$.mobile.tizen.enableHWKeyHandler = true;
						}
					},
					destroy: function () {
						document.removeEventListener(eventType.INIT, defaults.init, false);
						document.removeEventListener(eventType.DESTROY, defaults.destroy, false);
						$ = null;
					}
				};

			// Listen when framework is ready
			document.addEventListener(eventType.INIT, defaults.init, false);
			document.addEventListener(eventType.DESTROY, defaults.destroy, false);

			}(window, window.document));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global define, ns */
/**
 * #String Utility
 * Utility helps work with strings.
 * @class ns.util.string
 */
(function () {
	"use strict";
				var DASH_TO_UPPER_CASE_REGEXP = /-([a-z])/gi,
				UPPER_TO_DASH_CASE_REGEXP = /([A-Z])/g,
				arrayUtil = ns.util.array;

			/**
			 * Callback method for regexp used in dashesToCamelCase method
			 * @method toUpperCaseFn
			 * @param {string} match
			 * @param {string} value
			 * @return {string}
			 * @member ns.util.string
			 * @static
			 * @private
			 */
			function toUpperCaseFn(match, value) {
				return value.toLocaleUpperCase();
			}

			/**
			 * Callback method for regexp used in camelCaseToDashes method
			 * @method toUpperCaseFn
			 * @param {string} match
			 * @param {string} value
			 * @return {string}
			 * @member ns.util.string
			 * @static
			 * @private
			 */
			function toLowerCaseFn(match, value) {
				return "-" + value.toLowerCase();
			}

			/**
			 * Changes dashes string to camel case string
			 * @method firstToUpperCase
			 * @param {string} str
			 * @return {string}
			 * @member ns.util.string
			 * @static
			 */
			function dashesToCamelCase(str) {
				return str.replace(DASH_TO_UPPER_CASE_REGEXP, toUpperCaseFn);
			}

			/**
			 * Changes camel case string to dashes string
			 * @method camelCaseToDashes
			 * @param {string} str
			 * @return {string}
			 * @member ns.util.string
			 * @static
			 */
			function camelCaseToDashes(str) {
				return str.replace(UPPER_TO_DASH_CASE_REGEXP, toLowerCaseFn);
			}

			/**
			 * Changes the first char in string to uppercase
			 * @method firstToUpperCase
			 * @param {string} str
			 * @return {string}
			 * @member ns.util.string
			 * @static
			 */
			function firstToUpperCase(str) {
				return str.charAt(0).toLocaleUpperCase() + str.substring(1);
			}

			/**
			 * Map different types to number if is possible.
			 * @param {string|*} x
			 * @return {*}
			 */
			function mapToNumber(x) {
				var parsed;

				if (x && (x + "").indexOf("%") === -1) {
					parsed = parseInt(x, 10);
					if (isNaN(parsed)) {
						parsed = null;
					}
					return parsed;
				}
				return x;
			}

			/**
			 * Parses comma separated string to array
			 * @method parseProperty
			 * @param {string} property
			 * @return {Array} containing number or null
			 * @member ns.util.string
			 * @static
			 */
			function parseProperty(property) {
				var arrayProperty;

				if (typeof property === "string") {
					arrayProperty = property.split(",");
				} else {
					arrayProperty = property || [];
				}

				return arrayUtil.map(arrayProperty, mapToNumber);
			}

			/* eslint-disable jsdoc/check-param-names */
			/**
			 * Returns a string of tags that exist in the first param but do not exist
			 * in rest of the params
			 * @param {string} baseWithTags
			 * @param {...string} compare
			 * @return {string}
			 */
			function removeExactTags(baseWithTags) {
				var tags = [];

				[].slice
					.call(arguments)
					.slice(1)
					.forEach(function (arg) {
						arg.split(" ")
							.forEach(function (tag) {
								tags.push(tag.trim());
							});
					});

				return baseWithTags
					.split(" ")
					.filter(function (tag) {
						return tags.indexOf(tag) === -1;
					}).join(" ");
			}
			/* eslint-enable jsdoc/check-param-names */

			ns.util.string = {
				dashesToCamelCase: dashesToCamelCase,
				camelCaseToDashes: camelCaseToDashes,
				firstToUpperCase: firstToUpperCase,
				parseProperty: parseProperty,
				removeExactTags: removeExactTags
			};
			}());

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns */
/**
 * #Utility DOM
 * Utility object with function to DOM manipulation, CSS properties support
 * and DOM attributes support.
 *
 * # How to replace jQuery methods  by ns methods
 * ## append vs appendNodes
 *
 * #### HTML code before manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">And</div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * #### jQuery manipulation
 *
 *     @example
 *     $( "#second" ).append( "<span>Test</span>" );

 * #### ns manipulation
 *
 *     @example
 *     var context = document.getElementById("second"),
 *         element = document.createElement("span");
 *     element.innerHTML = "Test";
 *     ns.util.DOM.appendNodes(context, element);
 *
 * #### HTML code after manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">And
 *             <span>Test</span>
 *         </div>
 *        <div id="third">Goodbye</div>
 *     </div>
 *
 * ## replaceWith vs replaceWithNodes
 *
 * #### HTML code before manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">And</div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * #### jQuery manipulation
 *
 *     @example
 *     $('#second').replaceWith("<span>Test</span>");
 *
 * #### ns manipulation
 *
 *     @example
 *     var context = document.getElementById("second"),
 *         element = document.createElement("span");
 *     element.innerHTML = "Test";
 *     ns.util.DOM.replaceWithNodes(context, element);
 *
 * #### HTML code after manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <span>Test</span>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * ## before vs insertNodesBefore
 *
 * #### HTML code before manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">And</div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * #### jQuery manipulation
 *
 *     @example
 *     $( "#second" ).before( "<span>Test</span>" );
 *
 * #### ns manipulation
 *
 *     @example
 *     var context = document.getElementById("second"),
 *         element = document.createElement("span");
 *     element.innerHTML = "Test";
 *     ns.util.DOM.insertNodesBefore(context, element);
 *
 * #### HTML code after manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <span>Test</span>
 *         <div id="second">And</div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * ## wrapInner vs wrapInHTML
 *
 * #### HTML code before manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">And</div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * #### jQuery manipulation
 *
 *     @example
 *     $( "#second" ).wrapInner( "<span class="new"></span>" );
 *
 * #### ns manipulation
 *
 *     @example
 *     var element = document.getElementById("second");
 *     ns.util.DOM.wrapInHTML(element, "<span class="new"></span>");
 *
 * #### HTML code after manipulation
 *
 *     @example
 *     <div>
 *         <div id="first">Hello</div>
 *         <div id="second">
 *             <span class="new">And</span>
 *         </div>
 *         <div id="third">Goodbye</div>
 *     </div>
 *
 * @class ns.util.DOM
 * @author Jadwiga Sosnowska <j.sosnowska@partner.samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function () {
	"use strict";
				ns.util.DOM = ns.util.DOM || {};
			}());

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/*
 * @author Jadwiga Sosnowska <j.sosnowska@partner.samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function () {
	"use strict";
	

			var selectors = ns.util.selectors,
				DOM = ns.util.DOM,
				NAMESPACE = "namespace";

			/**
			 * Returns given attribute from element or the closest parent,
			 * which matches the selector.
			 * @method inheritAttr
			 * @member ns.util.DOM
			 * @param {HTMLElement} element
			 * @param {string} attr
			 * @param {string} selector
			 * @return {?string}
			 * @static
			 */
			DOM.inheritAttr = function (element, attr, selector) {
				var value = element.getAttribute(attr),
					parent;

				if (!value) {
					parent = selectors.getClosestBySelector(element, selector);
					if (parent) {
						return parent.getAttribute(attr);
					}
				}
				return value;
			};

			/**
			 * Returns Number from properties described in html tag
			 * @method getNumberFromAttribute
			 * @member ns.util.DOM
			 * @param {HTMLElement} element
			 * @param {string} attribute
			 * @param {string=} [type] auto type casting
			 * @param {number} [defaultValue] default returned value
			 * @static
			 * @return {number}
			 */
			DOM.getNumberFromAttribute = function (element, attribute, type, defaultValue) {
				var value = element.getAttribute(attribute),
					result = defaultValue;

				if (!isNaN(value)) {
					if (type === "float") {
						value = parseFloat(value);
						if (!isNaN(value)) {
							result = value;
						}
					} else {
						value = parseInt(value, 10);
						if (!isNaN(value)) {
							result = value;
						}
					}
				}
				return result;
			};

			function getDataName(name, skipData) {
				var _namespace = ns.getConfig(NAMESPACE),
					prefix = "";

				if (!skipData) {
					prefix = "data-";
				}
				return prefix + (_namespace ? _namespace + "-" : "") + name;
			}

			/**
			 * Special function to set attribute and property in the same time
			 * @method setAttribute
			 * @param {HTMLElement} element
			 * @param {string} name
			 * @param {Mixed} value
			 * @member ns.util.DOM
			 * @static
			 */
			function setAttribute(element, name, value) {
				element[name] = value;
				element.setAttribute(name, value);
			}

			/**
			 * This function sets value of attribute data-{namespace}-{name} for element.
			 * If the namespace is empty, the attribute data-{name} is used.
			 * @method setNSData
			 * @param {HTMLElement} element Base element
			 * @param {string} name Name of attribute
			 * @param {string|number|boolean} value New value
			 * @member ns.util.DOM
			 * @static
			 */
			DOM.setNSData = function (element, name, value) {
				element.setAttribute(getDataName(name), value);
			};

			/**
			 * This function returns value of attribute data-{namespace}-{name} for element.
			 * If the namespace is empty, the attribute data-{name} is used.
			 * Method may return boolean in case of 'true' or 'false' strings as attribute value.
			 * @method getNSData
			 * @param {HTMLElement} element Base element
			 * @param {string} name Name of attribute
			 * @param {boolean} skipData
			 * @member ns.util.DOM
			 * @return {?string|boolean}
			 * @static
			 */
			DOM.getNSData = function (element, name, skipData) {
				var value = element.getAttribute(getDataName(name, skipData));

				if (value === "true") {
					return true;
				}

				if (value === "false") {
					return false;
				}

				return value;
			};

			/**
			 * This function returns true if attribute data-{namespace}-{name} for element is set
			 * or false in another case. If the namespace is empty, attribute data-{name} is used.
			 * @method hasNSData
			 * @param {HTMLElement} element Base element
			 * @param {string} name Name of attribute
			 * @member ns.util.DOM
			 * @return {boolean}
			 * @static
			 */
			DOM.hasNSData = function (element, name) {
				return element.hasAttribute(getDataName(name));
			};

			/**
			 * Get or set value on data attribute.
			 * @method nsData
			 * @param {HTMLElement} element
			 * @param {string} name
			 * @param {?Mixed} [value]
			 * @static
			 * @member ns.util.DOM
			 */
			DOM.nsData = function (element, name, value) {
				if (value === undefined) {
					return DOM.getNSData(element, name);
				} else {
					return DOM.setNSData(element, name, value);
				}
			};

			/**
			 * This function removes attribute data-{namespace}-{name} from element.
			 * If the namespace is empty, attribute data-{name} is used.
			 * @method removeNSData
			 * @param {HTMLElement} element Base element
			 * @param {string} name Name of attribute
			 * @member ns.util.DOM
			 * @static
			 */
			DOM.removeNSData = function (element, name) {
				element.removeAttribute(getDataName(name));
			};

			/**
			 * Returns object with all data-* attributes of element
			 * @method getData
			 * @param {HTMLElement} element Base element
			 * @member ns.util.DOM
			 * @return {Object}
			 * @static
			 */
			DOM.getData = function (element) {
				var dataPrefix = "data-",
					data = {},
					attributes = element.attributes,
					attribute,
					nodeName,
					value,
					i,
					length = attributes.length,
					lowerCaseValue;

				for (i = 0; i < length; i++) {
					attribute = attributes.item(i);
					nodeName = attribute.nodeName;
					if (nodeName.indexOf(dataPrefix) > -1) {
						value = attribute.value;
						lowerCaseValue = value.toLowerCase();
						if (lowerCaseValue === "true") {
							value = true;
						} else if (lowerCaseValue === "false") {
							value = false;
						}
						data[nodeName.replace(dataPrefix, "")] = value;
					}
				}

				return data;
			};

			/**
			 * Special function to remove attribute and property in the same time
			 * @method removeAttribute
			 * @param {HTMLElement} element
			 * @param {string} name
			 * @member ns.util.DOM
			 * @static
			 */
			DOM.removeAttribute = function (element, name) {
				element.removeAttribute(name);
				element[name] = false;
			};

			DOM.setAttribute = setAttribute;
			/**
			 * Special function to set attributes and properties in the same time
			 * @method setAttribute
			 * @param {HTMLElement} element
			 * @param {Object} values
			 * @member ns.util.DOM
			 * @static
			 */
			DOM.setAttributes = function (element, values) {
				var i,
					names = Object.keys(values),
					name,
					len;

				for (i = 0, len = names.length; i < len; i++) {
					name = names[i];
					setAttribute(element, name, values[name]);
				}
			};
			}());

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/*
 * @author Jadwiga Sosnowska <j.sosnowska@partner.samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function (window, ns) {
	"use strict";
	
			var DOM = ns.util.DOM,
				stringUtil = ns.util.string,
				appStyleSheet;

			/**
			 * Returns css property for element
			 * @method getCSSProperty
			 * @param {HTMLElement} element
			 * @param {string} property
			 * @param {string|number|null} [def=null] default returned value
			 * @param {"integer"|"float"|null} [type=null] auto type casting
			 * @return {string|number|null}
			 * @member ns.util.DOM
			 * @static
			 */
			function getCSSProperty(element, property, def, type) {
				var style = window.getComputedStyle(element),
					value,
					result = def;

				if (style) {
					value = style.getPropertyValue(property);
					if (value) {
						switch (type) {
							case "integer":
								value = parseInt(value, 10);
								if (!isNaN(value)) {
									result = value;
								}
								break;
							case "float":
								value = parseFloat(value);
								if (!isNaN(value)) {
									result = value;
								}
								break;
							default:
								result = value;
								break;
						}
					}
				}
				return result;
			}

			/**
			 * Convert string to float or integer
			 * @param {string} value
			 * @return {number}
			 */
			function convertToNumber(value) {
				if ((value + "").indexOf(".") > -1) {
					return parseFloat(value);
				}
				return parseInt(value, 10);
			}

			/**
			 * Extracts css properties from computed css for an element.
			 * The properties values are applied to the specified
			 * properties list (dictionary)
			 * @method extractCSSProperties
			 * @param {HTMLElement} element
			 * @param {Object} properties
			 * @param {?string} [pseudoSelector=null]
			 * @param {boolean} [noConversion=false]
			 * @member ns.util.DOM
			 * @static
			 */
			function extractCSSProperties(element, properties, pseudoSelector, noConversion) {
				var style = window.getComputedStyle(element, pseudoSelector),
					property,
					value,
					newValue;

				for (property in properties) {
					if (properties.hasOwnProperty(property)) {
						value = style.getPropertyValue(property);
						newValue = convertToNumber(value);

						if (!isNaN(newValue) || !noConversion) {
							value = newValue;
						}

						properties[property] = value;
					}
				}
			}

			function getOffset(element, props, pseudoSelector, force, offsetProperty) {
				var originalDisplay,
					originalVisibility,
					originalPosition,
					offsetValue,
					style = element.style;

				if (style.display !== "none") {
					extractCSSProperties(element, props, pseudoSelector, true);
					offsetValue = element[offsetProperty];
				} else if (force) {
					originalDisplay = style.display;
					originalVisibility = style.visibility;
					originalPosition = style.position;

					style.display = "block";
					style.visibility = "hidden";
					style.position = "relative";

					extractCSSProperties(element, props, pseudoSelector, true);
					offsetValue = element[offsetProperty];

					style.display = originalDisplay;
					style.visibility = originalVisibility;
					style.position = originalPosition;
				}
				return offsetValue;
			}

			/**
			 * Returns elements height from computed style
			 * @method getElementHeight
			 * @param {HTMLElement} element
			 * if null then the "inner" value is assigned
			 * @param {"outer"|null} [type=null]
			 * @param {boolean} [includeOffset=false]
			 * @param {boolean} [includeMargin=false]
			 * @param {?string} [pseudoSelector=null]
			 * @param {boolean} [force=false] check even if element is hidden
			 * @return {number}
			 * @member ns.util.DOM
			 * @static
			 */
			function getElementHeight(element, type, includeOffset, includeMargin, pseudoSelector, force) {
				var height = 0,
					outer = (type && type === "outer") || false,
					offsetHeight,
					property,
					props = {
						"height": 0,
						"margin-top": 0,
						"margin-bottom": 0,
						"padding-top": 0,
						"padding-bottom": 0,
						"border-top-width": 0,
						"border-bottom-width": 0,
						"box-sizing": ""
					};

				if (element) {
					offsetHeight = getOffset(element, props, pseudoSelector, force, "offsetHeight");

					for (property in props) {
						if (props.hasOwnProperty(property) && property !== "box-sizing") {
							props[property] = convertToNumber(props[property]);
						}
					}

					height += props["height"];

					if (props["box-sizing"] !== "border-box") {
						height += props["padding-top"] + props["padding-bottom"];
					}

					if (includeOffset) {
						height = offsetHeight;
					} else if (outer && props["box-sizing"] !== "border-box") {
						height += props["border-top-width"] + props["border-bottom-width"];
					}

					if (includeMargin) {
						height += Math.max(0, props["margin-top"]) + Math.max(0, props["margin-bottom"]);
					}
				}
				return height;
			}

			/**
			 * Returns elements width from computed style
			 * @method getElementWidth
			 * @param {HTMLElement} element
			 * if null then the "inner" value is assigned
			 * @param {"outer"|null} [type=null]
			 * @param {boolean} [includeOffset=false]
			 * @param {boolean} [includeMargin=false]
			 * @param {?string} [pseudoSelector=null]
			 * @param {boolean} [force=false] check even if element is hidden
			 * @return {number}
			 * @member ns.util.DOM
			 * @static
			 */
			function getElementWidth(element, type, includeOffset, includeMargin, pseudoSelector, force) {
				var width = 0,
					value,
					offsetWidth,
					property,
					outer = (type && type === "outer") || false,
					props = {
						"width": 0,
						"margin-left": 0,
						"margin-right": 0,
						"padding-left": 0,
						"padding-right": 0,
						"border-left-width": 0,
						"border-right-width": 0,
						"box-sizing": ""
					};

				if (element) {
					offsetWidth = getOffset(element, props, pseudoSelector, force, "offsetWidth");

					for (property in props) {
						if (props.hasOwnProperty(property) && property !== "box-sizing") {
							value = parseFloat(props[property]);
							props[property] = value;
						}
					}

					width += props["width"];
					if (props["box-sizing"] !== "border-box") {
						width += props["padding-left"] + props["padding-right"];
					}

					if (includeOffset) {
						width = offsetWidth;
					} else if (outer && props["box-sizing"] !== "border-box") {
						width += props["border-left-width"] + props["border-right-width"];
					}

					if (includeMargin) {
						width += Math.max(0, props["margin-left"]) + Math.max(0, props["margin-right"]);
					}
				}
				return width;
			}

			/**
			 * Returns offset of element
			 * @method getElementOffset
			 * @param {HTMLElement} element
			 * @return {Object}
			 * @member ns.util.DOM
			 * @static
			 */
			function getElementOffset(element) {
				var left = 0,
					top = 0,
					loopElement = element;

				do {
					top += loopElement.offsetTop;
					left += loopElement.offsetLeft;
					loopElement = loopElement.offsetParent;
				} while (loopElement !== null);

				return {
					top: top,
					left: left
				};
			}

			/**
			 * Check if element occupies place at view
			 * @method isOccupiedPlace
			 * @param {HTMLElement} element
			 * @return {boolean}
			 * @member ns.util.DOM
			 * @static
			 */
			function isOccupiedPlace(element) {
				return !(element.offsetWidth <= 0 && element.offsetHeight <= 0);
			}

			/**
			 * Set values for element with prefixes for browsers
			 * @method setPrefixedStyle
			 * @param {HTMLElement | CSSStyleRule} elementOrRule
			 * @param {string} property
			 * @param {string|Object|null} value
			 * @member ns.util.DOM
			 * @static
			 */
			function setPrefixedStyle(elementOrRule, property, value) {
				var style = elementOrRule.style,
					propertyForPrefix = property,
					values = (typeof value !== "object") ? {
						webkit: value,
						moz: value,
						o: value,
						ms: value,
						normal: value
					} : value;

				style.setProperty(property, values.normal);
				style.setProperty("-webkit-" + propertyForPrefix, values.webkit);
				style.setProperty("-moz-" + propertyForPrefix, values.moz);
				style.setProperty("-o-" + propertyForPrefix, values.o);
				style.setProperty("-ms-" + propertyForPrefix, values.ms);
			}

			/**
			 * Get value from element with prefixes for browsers
			 * @method getCSSProperty
			 * @param {string} value
			 * @return {Object}
			 * @member ns.util.DOM
			 * @static
			 */
			function getPrefixedValue(value) {
				return {
					webkit: "-webkit-" + value,
					moz: "-moz-" + value,
					o: "-ms-" + value,
					ms: "-o-" + value,
					normal: value
				};
			}

			/**
			 * Returns style value for css property with browsers prefixes
			 * @method getPrefixedStyle
			 * @param {HTMLStyle} styles
			 * @param {string} property
			 * @return {Object}
			 * @member ns.util.DOM
			 * @static
			 */
			function getPrefixedStyleValue(styles, property) {
				var prefixedProperties = getPrefixedValue(property),
					value,
					key;

				for (key in prefixedProperties) {
					if (prefixedProperties.hasOwnProperty(key)) {
						value = styles[prefixedProperties[key]];
						if (value && value !== "none") {
							return value;
						}
					}
				}
				return value;
			}

			/**
			 * Returns size (width, height) as CSS string
			 * @method toCSSSize
			 * @param {string|Array} size has to be comma separated string (eg. "10,100") or array with 2
			 * elements
			 * @return {string} if not enough arguments the method returns empty string
			 * @member ns.util.DOM
			 * @static
			 */
			function toCSSSize(size) {
				var cssSize = "",
					arraySize = stringUtil.parseProperty(size);

				if (arraySize && arraySize.length === 2) {
					cssSize = "width: " + arraySize[0] + "px; " +
					"height: " + arraySize[1] + "px;";
				}

				return cssSize;
			}

			/**
			 * Set CSS styles for pseudo class selector.
			 * @method setStylesForPseudoClass
			 * @param {string} selector selector of elements
			 * @param {string} pseudoClassName CSS pseudo class name to set, for example after, before
			 * @param {Object} cssValues object with styles to set
			 * @return {number?} return index of inserted rule
			 * @member ns.util.DOM
			 * @static
			 */
			function setStylesForPseudoClass(selector, pseudoClassName, cssValues) {
				var cssValuesArray = [],
					headElement,
					styleElement,
					name;

				// create style element on first use
				if (!appStyleSheet) {
					headElement = document.head || document.getElementsByTagName("head")[0];
					styleElement = document.createElement("style");
					styleElement.type = "text/css";
					headElement.appendChild(styleElement);
					appStyleSheet = styleElement.sheet;
				}

				for (name in cssValues) {
					if (cssValues.hasOwnProperty(name)) {
						cssValuesArray.push(name + ": " + cssValues[name]);
					}
				}

				if (cssValuesArray.length) {
					return appStyleSheet.addRule(selector + "::" + pseudoClassName, cssValuesArray.join("; "));
				}

				return null;
			}

			/**
			 * Remove CSS rule from sheet.
			 * @method removeCSSRule
			 * @param {number} ruleIndex Index of rule to remove
			 * @static
			 */
			function removeCSSRule(ruleIndex) {

				// create style element on first use
				if (appStyleSheet) {
					appStyleSheet.deleteRule(ruleIndex);
				}
			}

			// assign methods to namespace
			DOM.getCSSProperty = getCSSProperty;
			DOM.extractCSSProperties = extractCSSProperties;
			DOM.getElementHeight = getElementHeight;
			DOM.getElementWidth = getElementWidth;
			DOM.getElementOffset = getElementOffset;
			DOM.isOccupiedPlace = isOccupiedPlace;
			DOM.setPrefixedStyle = setPrefixedStyle;
			DOM.getPrefixedValue = getPrefixedValue;
			DOM.getPrefixedStyleValue = getPrefixedStyleValue;
			DOM.toCSSSize = toCSSSize;
			DOM.setStylesForPseudoClass = setStylesForPseudoClass;
			DOM.removeCSSRule = removeCSSRule;

			}(window, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/**
 * #Set Utility
 *
 * Own implementation of ECMAScript Set.
 *
 * @class ns.util.Set
 */
(function (window, ns) {
	"use strict";
				var Set = function () {
				this._data = [];
			};

			Set.prototype = {
				/**
				 * Add one or many arguments to set
				 * @method add
				 * @member ns.util.Set
				 */
				add: function () {
					var data = this._data;

					this._data = data.concat.apply(data, [].slice.call(arguments))
						.filter(function (item, pos, array) {
							return array.indexOf(item) === pos;
						});
				},
				/**
				 * Remove all items from set
				 * @method clear
				 * @member ns.util.Set
				 */
				clear: function () {
					this._data = [];
				},
				/**
				 * delete one item from set
				 * @method delete
				 * @param {*} item
				 * @member ns.util.Set
				 */
				delete: function (item) {
					var data = this._data,
						index = data.indexOf(item);

					if (index > -1) {
						data.splice(index, 1);
					}
				},
				/**
				 * Check that item exists in set
				 * @method has
				 * @param {Object} item
				 * @member ns.util.Set
				 * @return {boolean}
				 */
				has: function (item) {
					return this._data.indexOf(item) > -1;
				},
				/**
				 * Iterate on each set elements
				 * @method forEach
				 * @param {Function} cb
				 * @member ns.util.Set
				 */
				forEach: function (cb) {
					this._data.forEach(cb);
				}
			};

			// for tests
			ns.util._Set = Set;
			ns.util.Set = window.Set || Set;

			}(window, ns));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Namespace For Widgets
 * Namespace For Widgets
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @class ns.widget
 */
(function (document) {
	"use strict";
				var engine = ns.engine,
				eventType = engine.eventType,
				widget = {
					/**
					 * Get bound widget for element
					 * @method getInstance
					 * @static
					 * @param {HTMLElement|string} element
					 * @param {string} type widget name
					 * @return {?Object}
					 * @member ns.widget
					 */
					getInstance: engine.getBinding,
					/**
					 * Returns Get all bound widget for element or id gives as parameter
					 * @method getAllInstances
					 * @param {HTMLElement|string} element
					 * @return {?Object}
					 * @static
					 * @member ns.widget
					 */
					getAllInstances: engine.getAllBindings
				};

			function mapWidgetDefinition(name, element, options) {
				var widgetParams = {
					name: name,
					element: element,
					options: options
				}

				return widgetParams;
			}

			function widgetConstructor(name, element, options) {
				var widgetParams = mapWidgetDefinition(name, element, options);

				return engine.instanceWidget(widgetParams.element, widgetParams.name, widgetParams.options);
			}

			/**
			 * Register simple widget constructor in namespace
			 * @param {Event} event
			 */
			function defineWidget(event) {
				var definition = event.detail,
					name = definition.name;

				ns.widget[name] = widgetConstructor.bind(null, name);
			}

			/**
			 * Remove event listeners on framework destroy
			 */
			function destroy() {
				document.removeEventListener(eventType.WIDGET_DEFINED, defineWidget, true);
				document.removeEventListener(eventType.DESTROY, destroy, false);
			}

			document.addEventListener(eventType.WIDGET_DEFINED, defineWidget, true);
			document.addEventListener(eventType.DESTROY, destroy, false);

			/** @namespace ns.widget */
			ns.widget = widget;
			}(window.document));

/*global window, ns, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #BaseWidget
 * Prototype class of widget
 *
 * ## How to invoke creation of widget from JavaScript
 *
 * To build and initialize widget in JavaScript you have to use method
 * {@link ns.engine#instanceWidget}. First argument for method is HTMLElement, which specifies the
 * element of widget. Second parameter is name of widget to create.
 *
 * If you load jQuery before initializing tau library, you can use standard jQuery UI Widget
 * notation.
 *
 * ### Examples
 * #### Build widget from JavaScript
 *
 *        @example
 *        var element = document.getElementById("id"),
 *            ns.engine.instanceWidget(element, "Button");
 *
 * #### Build widget from jQuery
 *
 *        @example
 *        var element = $("#id").button();
 *
 * ## How to create new widget
 *
 *        @example
 *        (function (ns) {
 *			"use strict";
 *			 *					var BaseWidget = ns.widget.BaseWidget, // create alias to main objects
 *						...
 *						arrayOfElements, // example of private property, common for all instances of widget
 *						Button = function () { // create local object with widget
 *							...
 *						},
 *						prototype = new BaseWidget(); // add ns.widget.BaseWidget as prototype to widget's
 *						object, for better minification this should be assign to local variable and next
 *						variable should be assign to prototype of object.
 *
 *					function closestEnabledButton(element) { // example of private method
 *						...
 *					}
 *					...
 *
 *					prototype.options = { //add default options to be read from data- attributes
 *						theme: "s",
 *						...
 *					};
 *
 *					prototype._build = function (template, element) {
 *						// method called when the widget is being built, should contain all HTML
 *						// manipulation actions
 *						...
 *						return element;
 *					};
 *
 *					prototype._init = function (element) {
 *						// method called during initialization of widget, should contain all actions
 *						// necessary fastOn application start
 *						...
 *						return element;
 *					};
 *
 *					prototype._bindEvents = function (element) {
 *						// method to bind all events, should contain all event bindings
 *						...
 *					};
 *
 *					prototype._enable = function (element) {
 *						// method called during invocation of enable() method
 *						...
 *					};
 *
 *					prototype._disable = function (element) {
 *						// method called during invocation of disable() method
 *						...
 *					};
 *
 *					prototype.refresh = function (element) {
 *						// example of public method
 *						...
 *					};
 *
 *					prototype._refresh = function () {
 *						// example of protected method
 *						...
 *					};
 *
 *					Button.prototype = prototype;
 *
 *					engine.defineWidget( // define widget
 *						"Button", //name of widget
 *						"[data-role='button'],button,[type='button'],[type='submit'],[type='reset']",
 *						//widget's selector
 *						[ // public methods, here should be list all public method
 *							"enable",
 *							"disable",
 *							"refresh"
 *						],
 *						Button, // widget's object
 *						"mobile" // widget's namespace
 *					);
 *					ns.widget.Button = Button;
 *					 *		}(ns));
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author Przemyslaw Ciezkowski <p.ciezkowski@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Michał Szepielak <m.szepielak@samsung.com>
 * @class ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var slice = [].slice,
				/**
				 * Alias to ns.engine
				 * @property {ns.engine} engine
				 * @member ns.widget.BaseWidget
				 * @private
				 * @static
				 */
				engine = ns.engine,
				engineDataTau = engine.dataTau,
				util = ns.util,
				/**
				 * Alias to {@link ns.event}
				 * @property {Object} eventUtils
				 * @member ns.widget.BaseWidget
				 * @private
				 * @static
				 */
				eventUtils = ns.event,
				/**
				 * Alias to {@link ns.util.DOM}
				 * @property {Object} domUtils
				 * @private
				 * @static
				 */
				domUtils = util.DOM,
				utilString = util.string,
				/**
				 * Alias to {@link ns.util.object}
				 * @property {Object} objectUtils
				 * @private
				 * @static
				 */
				objectUtils = util.object,
				selectorUtils = util.selectors,
				Set = util.Set,
				BaseWidget = function () {
					this.flowState = "created";
					return this;
				},
				getNSData = domUtils.getNSData,
				prototype = {},
				/**
				 * Property with string represent function type
				 * (for better minification)
				 * @property {string} [TYPE_FUNCTION="function"]
				 * @private
				 * @static
				 * @readonly
				 */
				TYPE_FUNCTION = "function",
				disableClass = "ui-state-disabled",
				ariaDisabled = "aria-disabled",
				commonClasses = {
					INLINE: "ui-inline"
				},
				__callbacks;

			BaseWidget.classes = {
				disable: disableClass
			};

			prototype._configureDefinition = function (definition) {
				var self = this,
					definitionName,
					definitionNamespace;

				if (definition) {
					definitionName = definition.name;
					definitionNamespace = definition.namespace;
					/**
					 * Name of the widget
					 * @property {string} name
					 * @member ns.widget.BaseWidget
					 */
					self.name = definitionName;

					/**
					 * Name of the widget (in lower case)
					 * @property {string} widgetName
					 * @member ns.widget.BaseWidget
					 */
					self.widgetName = definitionName;

					/**
					 * Namespace of widget events
					 * @property {string} widgetEventPrefix
					 * @member ns.widget.BaseWidget
					 */
					self.widgetEventPrefix = definitionName.toLowerCase();

					/**
					 * Namespace of the widget
					 * @property {string} namespace
					 * @member ns.widget.BaseWidget
					 */
					self.namespace = definitionNamespace;

					/**
					 * Full name of the widget
					 * @property {string} widgetFullName
					 * @member ns.widget.BaseWidget
					 */
					self.widgetFullName = ((definitionNamespace ? definitionNamespace + "-" : "") +
						definitionName).toLowerCase();
					/**
					 * Id of widget instance
					 * @property {string} id
					 * @member ns.widget.BaseWidget
					 */
					self.id = ns.getUniqueId();

					/**
					 * Widget's selector
					 * @property {string} selector
					 * @member ns.widget.BaseWidget
					 */
					self.selector = definition.selector;
				}
			};

			/**
			 * Protected method configuring the widget
			 * @method _configure
			 * @member ns.widget.BaseWidget
			 * @protected
			 * @template
			 * @ignore
			 */
			/**
			 * Configures widget object from definition.
			 *
			 * It calls such methods as #\_getCreateOptions and #\_configure.
			 * @method configure
			 * @param {Object} definition
			 * @param {string} definition.name Name of the widget
			 * @param {string} definition.selector Selector of the widget
			 * @param {HTMLElement} element Element of widget
			 * @param {Object} options Configure options
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 * @ignore
			 */
			prototype.configure = function (definition, element, options) {
				var self = this;

				/**
				 * Object with options for widget
				 * @property {Object} [options={}]
				 * @member ns.widget.BaseWidget
				 */

				self.flowState = "configuring";

				self.options = self.options || {};
				/**
				 * Base element of widget
				 * @property {?HTMLElement} [element=null]
				 * @member ns.widget.BaseWidget
				 */
				self.element = self.element || null;

				self._configureDefinition(definition);

				if (typeof self._configure === TYPE_FUNCTION) {
					element = self._configure(element) || element;
				}

				self.isCustomElement = !!element.createdCallback;

				self._getCreateOptions(element);

				objectUtils.fastMerge(self.options, options);

				// move style attribute to another attribute for recovery in init method
				// this feature is required in widgets with container
				if (element.style.cssText) {
					element.dataset.originalStyle = element.style.cssText;
				}

				self.flowState = "configured";

				return element;
			};

			/**
			 * Reads data-* attributes and save to options object.
			 * @method _getCreateOptions
			 * @param {HTMLElement} element Base element of the widget
			 * @return {Object}
			 * @member ns.widget.BaseWidget
			 * @protected
			 */
			prototype._getCreateOptions = function (element) {
				var self = this,
					options = self.options,
					tag = element.localName.toLowerCase();

				if (options) {
					Object.keys(options).forEach(function (option) {
						var attributeName = utilString.camelCaseToDashes(option),
							baseValue,
							prefixedValue = getNSData(element, attributeName);

						if (prefixedValue !== null) {
							options[option] = prefixedValue;
						} else {
							if (typeof options[option] === "boolean") {
								if (!self._readCommonOptionFromElementClassname(element, option)) {
									if (!self._readPrefixedOptionFromElementClassname(element, option)) {
										if (typeof self._readWidgetSpecyficOptionFromElementClassname !== TYPE_FUNCTION ||
											typeof self._readWidgetSpecyficOptionFromElementClassname === TYPE_FUNCTION &&
											!self._readWidgetSpecyficOptionFromElementClassname(element, option)) {
											if (typeof self._getDefaultOption === TYPE_FUNCTION) {
												options[option] = self._getDefaultOption(option);
											}
										}
									}
								}
							}
						}

						if (option === "type" && tag === "input" ||
							option === "style"
						) { // don't set conflicting props
							return;
						}

						baseValue = getNSData(element, attributeName, true);
						if (baseValue !== null) {
							options[option] = baseValue;
						}
					});
				}

				return options;
			};

			/**
			 * Protected method building the widget
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement} widget's element
			 * @member ns.widget.BaseWidget
			 * @protected
			 * @template
			 */
			/**
			 * Builds widget.
			 *
			 * It calls method #\_build.
			 *
			 * Before starting building process, the event beforecreate with
			 * proper prefix defined in variable widgetEventPrefix is triggered.
			 * @method build
			 * @param {HTMLElement} element Element of widget before building process
			 * @return {HTMLElement} Element of widget after building process
			 * @member ns.widget.BaseWidget
			 * @ignore
			 */
			prototype.build = function (element) {
				var self = this,
					id,
					node,
					dataBuilt = element.getAttribute(engineDataTau.built),
					dataName = element.getAttribute(engineDataTau.name);

				eventUtils.trigger(element, self.widgetEventPrefix + "beforecreate");

				self.flowState = "building";

				id = element.id;
				if (id) {
					self.id = id;
				} else {
					element.id = self.id;
				}

				if (typeof self._build === TYPE_FUNCTION) {
					node = self._build(element);
				} else {
					node = element;
				}

				self._setBooleanOptions(element);

				// Append current widget name to data-tau-built and data-tau-name attributes
				dataBuilt = !dataBuilt ? self.name : dataBuilt + engineDataTau.separator + self.name;
				dataName = !dataName ? self.name : dataName + engineDataTau.separator + self.name;

				element.setAttribute(engineDataTau.built, dataBuilt);
				element.setAttribute(engineDataTau.name, dataName);

				self.flowState = "built";
				return node;
			};

			/**
			 * Protected method initializing the widget
			 * @method _init
			 * @param {HTMLElement} element
			 * @member ns.widget.BaseWidget
			 * @template
			 * @protected
			 */
			/**
			 * Initializes widget.
			 *
			 * It calls method #\_init.
			 * @method init
			 * @param {HTMLElement} element Element of widget before initialization
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 * @ignore
			 */
			prototype.init = function (element) {
				var self = this,
					container,
					originalStyleText;

				self.id = element.id;

				self.flowState = "initiating";

				// Move style properties that was defined before building to container element
				if (element.dataset.originalStyle) {
					container = self.getContainer();
					if (container != element) {
						originalStyleText = element.dataset.originalStyle;

						originalStyleText.split(";").forEach(function (keyValue) {
							var key,
								value,
								keyValuePair;

							keyValuePair = keyValue.split(":");
							if (keyValuePair.length === 2) {
								key = keyValuePair[0].trim();
								value = keyValuePair[1].trim();

								container.style[key] = element.style[key];

								if (element.style[key] === value) {
									element.style[key] = "";
								}
							}
						});
					}
				}

				if (typeof self._init === TYPE_FUNCTION) {
					self._init(element);
				}

				if (element.getAttribute("disabled") || self.options.disabled === true) {
					self.disable();
				} else {
					self.enable();
				}

				self.flowState = "initiated";
				return self;
			};

			/**
			 * Returns base element widget
			 * @member ns.widget.BaseWidget
			 * @return {HTMLElement|null}
			 * @instance
			 */
			prototype.getContainer = function () {
				var self = this;

				if (typeof self._getContainer === TYPE_FUNCTION) {
					return self._getContainer();
				}
				return self.element;
			};

			/**
			 * Bind widget events attached in init mode
			 * @method _bindEvents
			 * @param {HTMLElement} element Base element of widget
			 * @member ns.widget.BaseWidget
			 * @template
			 * @protected
			 */
			/**
			 * Binds widget events.
			 *
			 * It calls such methods as #\_buildBindEvents and #\_bindEvents.
			 * At the end of binding process, the event "create" with proper
			 * prefix defined in variable widgetEventPrefix is triggered.
			 * @method bindEvents
			 * @param {HTMLElement} element Base element of the widget
			 * @param {boolean} onlyBuild Inform about the type of bindings: build/init
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 * @ignore
			 */
			prototype.bindEvents = function (element, onlyBuild) {
				var self = this,
					dataBound = element.getAttribute(engineDataTau.bound);

				if (!onlyBuild) {
					dataBound = !dataBound ? self.name : dataBound + engineDataTau.separator + self.name;
					element.setAttribute(engineDataTau.bound, dataBound);
				}
				if (typeof self._buildBindEvents === TYPE_FUNCTION) {
					self._buildBindEvents(element);
				}
				if (!onlyBuild && typeof self._bindEvents === TYPE_FUNCTION) {
					self._bindEvents(element);
				}

				self.trigger(self.widgetEventPrefix + "create", self);

				return self;
			};

			/**
			 * Event triggered when method focus is called
			 * @event taufocus
			 * @member ns.widget.BaseWidget
			 */

			/**
			 * Focus widget's element.
			 *
			 * This function calls function focus on element and if it is known
			 * the direction of event, the proper css classes are added/removed.
			 * @method focus
			 * @param {Object} options The options of event.
			 * @param {HTMLElement} options.previousElement Element to blur
			 * @param {HTMLElement} options.element Element to focus
			 * @member ns.widget.BaseWidget
			 */
			prototype.focus = function (options) {
				var self = this,
					element = self.element,
					blurElement,
					scrollview,
					scrollviewElement,
					blurWidget;

				options = options || {};

				blurElement = options.previousElement;
				// we try to blur element, which has focus previously
				if (blurElement) {
					blurWidget = engine.getBinding(blurElement);
					// call blur function on widget
					if (blurWidget) {
						options = objectUtils.merge({}, options, {element: blurElement});
						blurWidget.blur(options);
					} else {
						// or on element, if widget does not exist
						blurElement.blur();
					}
				}

				options = objectUtils.merge({}, options, {element: element});
				scrollviewElement = selectorUtils.getClosestBySelector(element, "[data-tau-name='Scrollview']");
				if (scrollviewElement) {
					scrollview = engine.getBinding(scrollviewElement);
				}

				// set focus on element
				eventUtils.trigger(document, "taufocus", options);
				if (typeof self._focus === TYPE_FUNCTION) {
					if (options.event) {
						scrollview && scrollview.ensureElementIsVisible(element);
					}
					self._focus(element);
				} else {
					element.focus();
				}

				return true;
			};

			/**
			 * Event triggered then method blur is called.
			 * @event taublur
			 * @member ns.widget.BaseWidget
			 */

			/**
			 * Blur widget's element.
			 *
			 * This function calls function blur on element and if it is known
			 * the direction of event, the proper css classes are added/removed.
			 * @method blur
			 * @param {Object} options The options of event.
			 * @param {HTMLElement} options.element Element to blur
			 * @member ns.widget.BaseWidget
			 */
			prototype.blur = function (options) {
				var self = this,
					element = self.element;

				options = objectUtils.merge({}, options, {element: element});

				// blur element
				eventUtils.trigger(document, "taublur", options);
				if (typeof self._blur === TYPE_FUNCTION) {
					self._blur(element);
				} else {
					element.blur();
				}
				return true;
			};

			/**
			 * Protected method destroying the widget
			 * @method _destroy
			 * @template
			 * @protected
			 * @member ns.widget.BaseWidget
			 */
			/**
			 * Destroys widget.
			 *
			 * It calls method #\_destroy.
			 *
			 * At the end of destroying process, the event "destroy" with proper
			 * prefix defined in variable widgetEventPrefix is triggered and
			 * the binding set in engine is removed.
			 * @method destroy
			 * @param {HTMLElement} element Base element of the widget
			 * @member ns.widget.BaseWidget
			 */
			prototype.destroy = function (element) {
				var self = this;

				element = element || self.element;

				// the widget is in during destroy process
				self.flowState = "destroying";

				if (typeof self._destroy === TYPE_FUNCTION) {
					self._destroy(element);
				}
				if (self.element) {
					self.trigger(self.widgetEventPrefix + "destroy");
					if (self.element.dataset.originalStyle) {
						self.element.style.cssText = self.element.dataset.originalStyle;
						delete self.element.dataset.originalStyle;
					}
				}
				if (element) {
					engine.removeBinding(element, self.name);
				}
				// the widget was destroyed
				self.flowState = "destroyed";
			};

			/**
			 * Protected method disabling the widget
			 * @method _disable
			 * @protected
			 * @member ns.widget.BaseWidget
			 * @template
			 */
			/**
			 * Disables widget.
			 *
			 * It calls method #\_disable.
			 * @method disable
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 */
			prototype.disable = function () {
				var self = this,
					args = slice.call(arguments),
					element = self.element;

				element.classList.add(disableClass);
				element.setAttribute(ariaDisabled, true);

				if (typeof self._disable === TYPE_FUNCTION) {
					args.unshift(element);
					self._disable.apply(self, args);
				}
				return this;
			};

			/**
			 * Check if widget is disabled.
			 * @method isDisabled
			 * @member ns.widget.BaseWidget
			 * @return {boolean} Returns true if widget is disabled
			 */
			prototype.isDisabled = function () {
				var self = this;

				return self.element.getAttribute("disabled") || self.options.disabled === true;
			};

			/**
			 * Protected method enabling the widget
			 * @method _enable
			 * @protected
			 * @member ns.widget.BaseWidget
			 * @template
			 */
			/**
			 * Enables widget.
			 *
			 * It calls method #\_enable.
			 * @method enable
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 */
			prototype.enable = function () {
				var self = this,
					args = slice.call(arguments),
					element = self.element;

				element.classList.remove(disableClass);
				element.setAttribute(ariaDisabled, false);

				if (typeof self._enable === TYPE_FUNCTION) {
					args.unshift(element);
					self._enable.apply(self, args);
				}
				return this;
			};

			/**
			 * Protected method causing the widget to refresh
			 * @method _refresh
			 * @protected
			 * @member ns.widget.BaseWidget
			 * @template
			 */
			/**
			 * Refreshes widget.
			 *
			 * It calls method #\_refresh.
			 * @method refresh
			 * @member ns.widget.BaseWidget
			 * @return {ns.widget.BaseWidget}
			 */
			prototype.refresh = function () {
				var self = this;

				if (typeof self._refresh === TYPE_FUNCTION) {
					self._refresh.apply(self, arguments);
				}
				return self;
			};

			/**
			 * Reads class based on name conversion option value, for all options which have boolean value
			 * we can read option value by check that exists classname connected with option name. To
			 * correct use this method is required define in widget property _classesPrefix. If this
			 * condition is not met method returns false, otherwise returns true.
			 *
			 * For example for option middle in Button widget we will check existing of class
			 * ui-btn-middle.
			 *
			 * @method _readPrefixedOptionFromElementClassname
			 * @param {HTMLElement} element Main element of widget
			 * @param {string} name Name of option which should be used
			 * @return {boolean} If option value was successfully read
			 * @member ns.widget.BaseWidget
			 * @protected
			 */
			prototype._readPrefixedOptionFromElementClassname = function (element, name) {
				var classesPrefix = this._classesPrefix,
					className;

				if (classesPrefix) {
					className = classesPrefix + utilString.camelCaseToDashes(name);
					if (element.classList.contains(className)) {
						this.options[name] = element.classList.contains(className);
						// property exists in classname
						return true;
					}
				}

				return false;
			};

			/**
			 * Reads class based on name conversion option value, for all options which have boolean value
			 * we can read option value by check that exists classname connected with option name.
			 * Method returns true if class name contains common option, otherwise returns false.
			 *
			 * For example for option inline in widget we will check existing of class
			 * ui-inline.
			 *
			 * @method _readPrefixedOptionFromElementClassname
			 * @param {HTMLElement} element Main element of widget
			 * @param {string} name Name of option which should be used
			 * @return {boolean} If option value was successfully read
			 * @member ns.widget.BaseWidget
			 * @protected
			 */
			prototype._readCommonOptionFromElementClassname = function (element, name) {
				var options = this.options,
					classList = element.classList;

				switch (name) {
					case "inline" :
						if (classList.contains(commonClasses.INLINE)) {
							options.inline = true;
							return true;
						}
						break;
				}
				return false;
			};

			/**
			 * Sets or removes class based on name conversion option, for all options which have boolean
			 * value we can just set classname which is converted from camel case to dash style.
			 * To correct use this method is required define in widget property _classesPrefix.
			 *
			 * For example for option middle in Button widget we will set or remove class ui-btn-middle.
			 *
			 * @method _setBooleanOption
			 * @param {HTMLElement} element Main element of widget
			 * @param {string} name Name of option which should be used
			 * @param {boolean} value New value of option to set
			 * @member ns.widget.BaseWidget
			 * @protected
			 * @return {false} always return false to block refreshing
			 */
			prototype._setBooleanOption = function (element, name, value) {
				var classesPrefix = this._classesPrefix,
					className;

				if (classesPrefix) {
					className = classesPrefix + utilString.camelCaseToDashes(name);
					element.classList.toggle(className, value);
				}

				// we don't need refresh, always can return false
				return false;
			};

			/**
			 * For each options which has boolean value set or remove connected class.
			 *
			 * @method _setBooleanOptions
			 * @param {HTMLElement} element Base element of the widget
			 * @return {Object}
			 * @member ns.widget.BaseWidget
			 * @protected
			 */
			prototype._setBooleanOptions = function (element) {
				var self = this,
					classesPrefix = self._classesPrefix,
					options = self.options;

				if (classesPrefix && options !== undefined) {
					Object.keys(options).forEach(function (option) {
						if (typeof options[option] === "boolean") {
							options[option] = self._setBooleanOption(element, option, options[option]);
						}
					});
				}
				return options;
			};

			prototype._processOptionObject = function (firstArgument) {
				var self = this,
					key,
					partResult,
					refresh = false;

				for (key in firstArgument) {
					if (firstArgument.hasOwnProperty(key)) {
						partResult = self._oneOption(key, firstArgument[key]);
						if (key !== undefined && firstArgument[key] !== undefined) {
							refresh = refresh || partResult;
						}
					}
				}
				return refresh;
			};

			/**
			 * Gets or sets options of the widget.
			 *
			 * This method can work in many context.
			 *
			 * If first argument is type of object them, method set values for options given in object.
			 * Keys of object are names of options and values from object are values to set.
			 *
			 * If you give only one string argument then method return value for given option.
			 *
			 * If you give two arguments and first argument will be a string then second argument will be
			 * intemperate as value to set.
			 *
			 * @method option
			 * @param {string|Object} [name] name of option
			 * @param {*} [value] value to set
			 * @member ns.widget.BaseWidget
			 * @return {*} return value of option or null if method is called in setter context
			 */
			prototype.option = function (name, value) {
				var self = this,
					firstArgument = name,
					secondArgument = value,
					result = null,
					refresh = false;

				if (typeof firstArgument === "string") {
					result = self._oneOption(firstArgument, secondArgument);
					if (secondArgument !== undefined) {
						refresh = result;
						result = null;
					}
				} else if (typeof firstArgument === "object") {
					refresh = self._processOptionObject(firstArgument);
				}
				if (refresh) {
					self.refresh();
				}
				return result;
			};

			/**
			 * Gets or sets one option of the widget.
			 *
			 * @method _oneOption
			 * @param {string} field
			 * @param {*} value
			 * @member ns.widget.BaseWidget
			 * @return {*}
			 * @protected
			 */
			prototype._oneOption = function (field, value) {
				var self = this,
					methodName,
					refresh = false;

				if (value === undefined) {
					methodName = "_get" + (field[0].toUpperCase() + field.slice(1));

					if (typeof self[methodName] === TYPE_FUNCTION) {
						return self[methodName]();
					}

					return self.options[field];
				}

				methodName = "_set" + (field[0].toUpperCase() + field.slice(1));
				if (typeof self[methodName] === TYPE_FUNCTION) {
					refresh = self[methodName](self.element, value);
					if (self.element) {
						self.element.setAttribute("data-" + (field.replace(/[A-Z]/g, function (c) {
							return "-" + c.toLowerCase();
						})), value);
					}
				} else if (typeof value === "boolean") {
					refresh = self._setBooleanOption(self.element, field, value);
				} else {
					self.options[field] = value;

					if (self.element) {
						self.element.setAttribute("data-" + (field.replace(/[A-Z]/g, function (c) {
							return "-" + c.toLowerCase();
						})), value);
						refresh = true;
					}
				}

				if (value === "" && self.element) {
					self.element.removeAttribute("data-" + (field.replace(/[A-Z]/g, function (c) {
						return "-" + c.toLowerCase();
					})));
				}

				return refresh;
			};

			/**
			 * Returns true if widget has bounded events.
			 *
			 * This methods enables to check if the widget has bounded
			 * events through the {@link ns.widget.BaseWidget#bindEvents} method.
			 * @method isBound
			 * @param {string} [type] Type of widget
			 * @member ns.widget.BaseWidget
			 * @ignore
			 * @return {boolean} true if events are bounded
			 */
			prototype.isBound = function (type) {
				var element = this.element;

				type = type || this.name;
				return element && element.hasAttribute(engineDataTau.bound) &&
					element.getAttribute(engineDataTau.bound).indexOf(type) > -1;
			};

			/**
			 * Returns true if widget is built.
			 *
			 * This methods enables to check if the widget was built
			 * through the {@link ns.widget.BaseWidget#build} method.
			 * @method isBuilt
			 * @param {string} [type] Type of widget
			 * @member ns.widget.BaseWidget
			 * @ignore
			 * @return {boolean} true if the widget was built
			 */
			prototype.isBuilt = function (type) {
				var element = this.element;

				type = type || this.name;
				return element && element.hasAttribute(engineDataTau.built) &&
					element.getAttribute(engineDataTau.built).indexOf(type) > -1;
			};

			/**
			 * Protected method getting the value of widget
			 * @method _getValue
			 * @return {*}
			 * @member ns.widget.BaseWidget
			 * @template
			 * @protected
			 */
			/**
			 * Protected method setting the value of widget
			 * @method _setValue
			 * @param {*} value
			 * @return {*}
			 * @member ns.widget.BaseWidget
			 * @template
			 * @protected
			 */
			/**
			 * Gets or sets value of the widget.
			 *
			 * @method value
			 * @param {*} [value] New value of widget
			 * @member ns.widget.BaseWidget
			 * @return {*}
			 */
			prototype.value = function (value) {
				var self = this;

				if (value !== undefined) {
					if (typeof self._setValue === TYPE_FUNCTION) {
						return self._setValue(value);
					}
					return self;
				}
				if (typeof self._getValue === TYPE_FUNCTION) {
					return self._getValue();
				}
				return self;
			};

			/**
			 * Triggers an event on widget's element.
			 *
			 * @method trigger
			 * @param {string} eventName The name of event to trigger
			 * @param {?*} [data] additional Object to be carried with the event
			 * @param {boolean} [bubbles=true] Indicating whether the event
			 * bubbles up through the DOM or not
			 * @param {boolean} [cancelable=true] Indicating whether
			 * the event is cancelable
			 * @member ns.widget.BaseWidget
			 * @return {boolean} False, if any callback invoked preventDefault on event object
			 */
			prototype.trigger = function (eventName, data, bubbles, cancelable) {
				if (this.element) {
					return eventUtils.trigger(this.element, eventName, data, bubbles, cancelable);
				}
			};

			/**
			 * Adds event listener to widget's element.
			 * @method on
			 * @param {string} eventName The name of event
			 * @param {Function} listener Function called after event will be trigger
			 * @param {boolean} [useCapture=false] useCapture Parameter of addEventListener
			 * @member ns.widget.BaseWidget
			 */
			prototype.on = function (eventName, listener, useCapture) {
				eventUtils.on(this.element, eventName, listener, useCapture);
			};

			/**
			 * Removes event listener from  widget's element.
			 * @method off
			 * @param {string} eventName The name of event
			 * @param {Function} listener Function call after event will be trigger
			 * @param {boolean} [useCapture=false] useCapture Parameter of addEventListener
			 * @member ns.widget.BaseWidget
			 */
			prototype.off = function (eventName, listener, useCapture) {
				eventUtils.off(this.element, eventName, listener, useCapture);
			};

			prototype._framesFlow = function () {
				var self = this,
					args = slice.call(arguments),
					func = args.shift();

				if (typeof func === "function") {
					func();
				}
				if (func !== undefined) {
					util.requestAnimationFrame(function frameFlowCallback() {
						self._framesFlow.apply(self, args);
					});
				}
			};

			function callbacksFilter(item) {
				return !item.toRemove;
			}

			function callbacksForEach(item) {
				if (item.object[item.property] === item.value) {
					util.requestAnimationFrame(item.callback.bind(item.object));
					item.toRemove = true;
				}
			}

			function _controlWaitFor() {
				__callbacks.forEach(callbacksForEach);
				__callbacks = __callbacks.filter(callbacksFilter);
				if (__callbacks.length) {
					util.requestAnimationFrame(_controlWaitFor);
				}
			}

			prototype._waitFor = function (property, value, callback) {
				var self = this;

				if (self[property] === value) {
					callback.call(self);
				} else {
					__callbacks = __callbacks || [];
					__callbacks.push({
						object: self,
						property: property,
						value: value,
						callback: callback
					});
				}
				_controlWaitFor();
			};

			function readDOMElementStateClassList(element, stateObject) {
				var classList = stateObject.classList;

				if (classList !== undefined) {
					if (classList instanceof Set) {
						classList.clear();
					} else {
						classList = new Set();
						stateObject.classList = classList;
					}
					if (element.classList.length) {
						classList.add.apply(classList, slice.call(element.classList));
					}
				}
			}

			function readDOMElementState(element, stateObject) {
				readDOMElementStateClassList(element, stateObject);
				if (stateObject.offsetWidth !== undefined) {
					stateObject.offsetWidth = element.offsetWidth;
				}
				if (stateObject.style !== undefined) {
					domUtils.extractCSSProperties(element, stateObject.style, null, true);
				}
				if (stateObject.children !== undefined) {
					stateObject.children.forEach(function (child, index) {
						readDOMElementState(element.children[index], child);
					});
				}
			}

			function render(stateObject, element, isChild, options) {
				var recalculate = false,
					animation = (options) ? options.animation : null;

				if (animation && !animation.active) {
					// Animation has stopped before render
					return false;
				}

				if (stateObject.classList !== undefined) {
					slice.call(element.classList).forEach(function renderRemoveClassList(className) {
						if (!stateObject.classList.has(className)) {
							element.classList.remove(className);
							recalculate = true;
						}
					});
					stateObject.classList.forEach(function renderAddClassList(className) {
						if (!element.classList.contains(className)) {
							element.classList.add(className);
							recalculate = true;
						}
					});
				}
				if (stateObject.style !== undefined) {
					Object.keys(stateObject.style).forEach(function renderUpdateStyle(styleName) {
						element.style[styleName] = stateObject.style[styleName];
					});
				}
				if (stateObject.children !== undefined) {
					stateObject.children.forEach(function renderChildren(child, index) {
						render(child, element.children[index], true);
					});
				}
				if (recalculate && !isChild) {
					util.requestAnimationFrame(readDOMElementState.bind(null, element, stateObject));
				}
			}

			prototype._render = function (now) {
				var self = this,
					stateDOM = self._stateDOM,
					element = self.element,
					animation = self._animation;

				if (now) {
					render(stateDOM, element, false, {animation: animation});
				} else {
					util.requestAnimationFrame(render.bind(null, stateDOM, element, false, {animation: animation}));
				}
			};

			prototype._initDOMstate = function () {
				readDOMElementState(this.element, this._stateDOM);
			};

			prototype._togglePrefixedClass = function (stateDOM, prefix, name) {
				var requireRefresh = false,
					prefixedClassName = prefix + name;

				stateDOM.classList.forEach(function (className) {
					if (className.indexOf(prefix) === 0 && prefixedClassName !== className) {
						stateDOM.classList.delete(className);
						requireRefresh = true;
					}
				});
				if (!stateDOM.classList.has(prefixedClassName)) {
					stateDOM.classList.add(prefixedClassName);
					requireRefresh = true;
				}
				return requireRefresh;
			};

			BaseWidget.prototype = prototype;

			// definition
			ns.widget.BaseWidget = BaseWidget;

			}(window.document, ns));

/*global window, ns, define */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping widget
 * Object maps widgets from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.widget
 */
(function (window, document) {
	"use strict";
				/**
			 * Alias to Array.slice function
			 * @method slice
			 * @member ns.jqm.widget
			 * @private
			 * @static
			 */
			var slice = [].slice,
				$ = ns.jqm.jQuery,
				/**
				 * Wrap function in closure and wrap first argument in jquery object
				 * @param {Function} fn
				 */
				wrapFn = function (fn) {
					return function (el) {
						return fn($(el));
					};
				},
				/**
				 * Alias to ns.engine
				 * @member ns.jqm
				 * @private
				 * @static
				 */
				engine = ns.engine,
				object = ns.util.object,
				jqmWidget = {
					/**
					 * bind widget to jqm
					 * @method init
					 * @param {Object} engine ns.engine class
					 * @param {Object} definition widget definition
					 * @member ns.jqm.widget
					 * @static
					 */
					init: function (engine, definition) {
						var name = (definition.widgetNameToLowercase) ?
							definition.name.toLowerCase() :
							definition.name;

						if ($) {
							document.addEventListener(name + "create", function (event) {
								var element = event.target,
									instance = event.detail,
									data = $(element).data(name);

								if (instance) {
									instance.bindings = {};
									instance.hoverable = {};
									instance.focusable = {};
									instance.document = $(element.style ? element.ownerDocument : element.document || element);
									instance.window = $(instance.document[0].defaultView || instance.document[0].parentWindow);
									object.merge(instance, data);
									$(element).data(name, instance);
								}
							}, true);
							this.processDefinition(definition, engine);
						}
					},

					/**
					 * bind widget to jqm
					 * @method processDefinition
					 * @param {Object} definition widget definition
					 * @param {Object} engine ns.engine class
					 * @member ns.jqm.widget
					 * @static
					 */
					processDefinition: function (definition, engine) {
						/*
						 * name of widget
						 * type string
						 */
						var name = (definition.widgetNameToLowercase) ?
								definition.name.toLowerCase() :
								definition.name,
							/*
							 * list of public methods
							 * type Array
							 */
							methods = definition.methods;

						$.fn[name] = widgetConstructor(engine, name, methods, definition.name);
						if (definition.namespace) {
							$[definition.namespace] = $[definition.namespace] || {};
							$[definition.namespace][definition.name.toLowerCase()] = definition.widgetClass;
						}
						definition = null;
					}
				},
				eventType = engine.eventType;

			function widgetConstructor(engine, name, methods, instanceWidgetName) {
				/*
				 * widget instance
				 * type Object
				 */
				var instance = null;

				return function () {
					/*
					 * function arguments
					 * type Array
					 */
					var args = slice.call(arguments),
						/*
						 * element of jQuery collection
						 * type HTMLElement
						 */
						element,
						/*
						 * is built?
						 * type Boolean
						 */
						built,
						/*
						 * name of method
						 * type string
						 */
						method,
						/*
						 * result value
						 * type mixed
						 */
						resultValue,
						/*
						 * first argument of function
						 * type mixed
						 */
						firstArg,
						i,
						options = {};

					/*
					 * NOTE:
					 * The loop below contains some fixes/hacks for TizenSlider, Listview with FastScroll and AutoDividers
					 * and also Popup, please be aware while refactoring.
					 */
					for (i = 0; i < this.length; i++) {
						element = this.get(i);
						switch (name) {
							case "slider":
								instance = engine.getBinding(element, "Slider") || engine.getBinding(element, "TizenSlider");
								break;
							default:
								instance = engine.getBinding(element, instanceWidgetName);
						}

						built = instance && instance.isBuilt();
						firstArg = args.shift();
						if (firstArg === undefined || typeof firstArg === "object") {
							if (typeof firstArg === "object") {
								options = firstArg;
							}
							if (!instance || !built) {
								engine.instanceWidget(element, instanceWidgetName, options);
							} else {
								instance.option(options);
							}
						} else {
							if (instance === null) {
								return this;
							}
							method = firstArg;
							if (method === "destroy") {
								instance.destroy();
								return this;
							}
							if (methods.indexOf(method) < 0) {
								throw "Method " + method + " does not exist!";
							}
							if (name === "listview" &&
								method === "option" &&
								args[0] === "autodividersSelector" &&
								typeof args[1] === "function") {
								// wrap first argument of callback method in JQuery object
								args[1] = wrapFn(args[1]);
							}
							if (name === "popup" && method === "open") {
								// window.event is used because in Winset we open context popup by
								// $("#pop_text_only").popup("open") after clicking on input
								args[1] = window.event;
							}

							resultValue = instance[method].apply(instance, args);
							if (resultValue !== undefined) {
								if (resultValue !== instance) {
									return resultValue;
								}
							}
						}
					}
					return this;
				};
			}

			/**
			 * Callback for event widgetdefined, register widget in jqm namespace
			 * @param {Event} event
			 */
			function defineWidget(event) {
				jqmWidget.init(engine, event.detail);
			}

			/**
			 * Removes event listeners on framework destroy.
			 */
			function destroy() {
				document.removeEventListener(eventType.WIDGET_DEFINED, defineWidget, false);
				document.removeEventListener(eventType.INIT, defineOldWidgets, false);
				document.removeEventListener(eventType.DESTROY, destroy, false);
			}

			/**
			 * Define widgets which names was changed for backward capability.
			 */
			function defineOldWidgets() {
				engine.defineWidget(
					"FixedToolbar",
					"",
					[],
					ns.widget.Page,
					"mobile"
				);
				engine.defineWidget(
					"pagelayout",
					"",
					[],
					ns.widget.Page,
					"mobile"
				);
				engine.defineWidget(
					"popupwindow",
					"",
					[],
					ns.widget.Popup,
					"tizen"
				);
				engine.defineWidget(
					"ctxpopup",
					"",
					[],
					ns.widget.Popup,
					"tizen"
				);
			}

			document.addEventListener(eventType.WIDGET_DEFINED, defineWidget, false);
			document.addEventListener(eventType.INIT, defineOldWidgets, false);
			document.addEventListener(eventType.DESTROY, destroy, false);

			ns.jqm.widget = jqmWidget;
			}(window, window.document));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Callback Utility
 * Class creates a callback list
 *
 * Create a callback list using the following parameters:
 *  options: an optional list of space-separated options that will change how
 *            the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *    once:            will ensure the callback list can only be fired once (like a Deferred)
 *
 *    memory:            will keep track of previous values and will call any callback added
 *                    after the list has been fired right away with the latest "memorized"
 *                    values (like a Deferred)
 *
 *    unique:            will ensure a callback can only be added once (no duplicate in the list)
 *
 *    stopOnFalse:    interrupt callings when a callback returns false
 * @class ns.util.callbacks
 */
(function (window, document, ns) {
	"use strict";
				ns.util.callbacks = function (orgOptions) {

				var object = ns.util.object,
					options = object.copy(orgOptions),
					/**
					 * Alias to Array.slice function
					 * @method slice
					 * @member ns.util.callbacks
					 * @private
					 */
					slice = [].slice,
					/**
					 * Last fire value (for non-forgettable lists)
					 * @property {Object} memory
					 * @member ns.util.callbacks
					 * @private
					 */
					memory,
					/**
					 * Flag to know if list was already fired
					 * @property {boolean} fired
					 * @member ns.util.callbacks
					 * @private
					 */
					fired,
					/**
					 * Flag to know if list is currently firing
					 * @property {boolean} firing
					 * @member ns.util.callbacks
					 * @private
					 */
					firing,
					/**
					 * First callback to fire (used internally by add and fireWith)
					 * @property {number} [firingStart=0]
					 * @member ns.util.callbacks
					 * @private
					 */
					firingStart,
					/**
					 * End of the loop when firing
					 * @property {number} firingLength
					 * @member ns.util.callbacks
					 * @private
					 */
					firingLength,
					/**
					 * Index of currently firing callback (modified by remove if needed)
					 * @property {number} firingIndex
					 * @member ns.util.callbacks
					 * @private
					 */
					firingIndex,
					/**
					 * Actual callback list
					 * @property {Array} list
					 * @member ns.util.callbacks
					 * @private
					 */
					list = [],
					/**
					 * Stack of fire calls for repeatable lists
					 * @property {Array} stack
					 * @member ns.util.callbacks
					 * @private
					 */
					stack = !options.once && [],
					fire,
					add,
					self = {
						/**
						 * Add a callback or a collection of callbacks to the list
						 * @method add
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						add: function () {
							var start;

							if (list) {
								// First, we save the current length
								start = list.length;

								add(arguments);
								// Do we need to add the callbacks to the
								// current firing batch?
								if (firing) {
									firingLength = list.length;
									// With memory, if we're not firing then
									// we should call right away
								} else if (memory) {
									firingStart = start;
									fire(memory);
								}
							}
							return this;
						},
						/**
						 * Remove a callback from the list
						 * @method remove
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						remove: function () {
							if (list) {
								slice.call(arguments).forEach(function (arg) {
									var index = list.indexOf(arg);

									while (index > -1) {
										list.splice(index, 1);
										// Handle firing indexes
										if (firing) {
											if (index <= firingLength) {
												firingLength--;
											}
											if (index <= firingIndex) {
												firingIndex--;
											}
										}
										index = list.indexOf(arg, index);
									}
								});
							}
							return this;
						},
						/**
						 * Check if a given callback is in the list.
						 * If no argument is given,
						 * return whether or not list has callbacks attached.
						 * @method has
						 * @param {Function} fn
						 * @return {boolean}
						 * @member ns.util.callbacks
						 */
						has: function (fn) {
							return fn ? !!list && list.indexOf(fn) > -1 : !!(list && list.length);
						},
						/**
						 * Remove all callbacks from the list
						 * @method empty
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						empty: function () {
							list = [];
							firingLength = 0;
							return this;
						},
						/**
						 * Have the list do nothing anymore
						 * @method disable
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						disable: function () {
							list = stack = memory = undefined;
							return this;
						},
						/**
						 * Is it disabled?
						 * @method disabled
						 * @return {boolean}
						 * @member ns.util.callbacks
						 */
						disabled: function () {
							return !list;
						},
						/**
						 * Lock the list in its current state
						 * @method lock
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						lock: function () {
							stack = undefined;
							if (!memory) {
								self.disable();
							}
							return this;
						},
						/**
						 * Is it locked?
						 * @method locked
						 * @return {boolean} stack
						 * @member ns.util.callbacks
						 */
						locked: function () {
							return !stack;
						},
						/**
						 * Call all callbacks with the given context and
						 * arguments
						 * @method fireWith
						 * @param {Object} context
						 * @param {Array} args
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						fireWith: function (context, args) {
							if (list && (!fired || stack)) {
								args = args || [];
								args = [context, args.slice ? args.slice() : args];
								if (firing) {
									stack.push(args);
								} else {
									fire(args);
								}
							}
							return this;
						},
						/**
						 * Call all the callbacks with the given arguments
						 * @method fire
						 * @return {ns.util.callbacks} self
						 * @member ns.util.callbacks
						 */
						fire: function () {
							self.fireWith(this, arguments);
							return this;
						},
						/**
						 * To know if the callbacks have already been called at
						 * least once
						 * @method fired
						 * @return {boolean}
						 * @member ns.util.callbacks
						 */
						fired: function () {
							return !!fired;
						}
					};
				/**
				 * Adds functions to the callback list
				 * @method add
				 * @param {...*} argument
				 * @member ns.util.bezierCurve
				 * @private
				 */

				add = function (args) {
					slice.call(args).forEach(function (arg) {
						var type = typeof arg;

						if (type === "function") {
							if (!options.unique || !self.has(arg)) {
								list.push(arg);
							}
						} else if (arg && arg.length && type !== "string") {
							// Inspect recursively
							add(arg);
						}
					});
				};
				/**
				 * Fire callbacks
				 * @method fire
				 * @param {Array} data
				 * @member ns.util.bezierCurve
				 * @private
				 */
				fire = function (data) {
					memory = options.memory && data;
					fired = true;
					firingIndex = firingStart || 0;
					firingStart = 0;
					firingLength = list.length;
					firing = true;
					while (list && firingIndex < firingLength) {
						if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
							memory = false; // To prevent further calls using add
							break;
						}
						firingIndex++;
					}
					firing = false;
					if (list) {
						if (stack) {
							if (stack.length) {
								fire(stack.shift());
							}
						} else if (memory) {
							list = [];
						} else {
							self.disable();
						}
					}
				};

				return self;
			};

			}(window, window.document, ns));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Deferred Utility
 * Class creates object which can call registered callback depend from
 * state of object..
 * @class ns.util.deferred
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
*/(function (window, document, ns) {
	"use strict";
	
			var Deferred = function (callback) {
				var callbacks = ns.util.callbacks,
					object = ns.util.object,
					/**
					 * Register additional action for deferred object
					 * @property {Array} tuples
					 * @member ns.util.deferred
					 * @private
					 */
					tuples = [
						// action, add listener, listener list, final state
						["resolve", "done", callbacks({once: true, memory: true}), "resolved"],
						["reject", "fail", callbacks({once: true, memory: true}), "rejected"],
						["notify", "progress", callbacks({memory: true})]
					],
					state = "pending",
					deferred = {},
					promise = {
						/**
						 * Determine the current state of a Deferred object.
						 * @method state
						 * @return {"pending" | "resolved" | "rejected"} representing the current state
						 * @member ns.util.deferred
						 */
						state: function () {
							return state;
						},
						/**
						 * Add handlers to be called when the Deferred object
						 * is either resolved or rejected.
						 * @method always
						 * @return {ns.util.deferred} self
						 * @member ns.util.deferred
						 */
						always: function () {
							deferred.done(arguments).fail(arguments);
							return this;
						},
						/**
						 * Add handlers to be called when the Deferred object
						 * is resolved, rejected, or still in progress.
						 * @method then
						 * @return {Object} returns a new promise
						 * @member ns.util.deferred
						 */
						then: function () { /* fnDone, fnFail, fnProgress */
							var functions = arguments;

							return new Deferred(function (newDefer) {
								tuples.forEach(function (tuple, i) {
									var fn = (typeof functions[i] === "function") && functions[i];
									// deferred[ done | fail | progress ] for forwarding actions to newDefer

									deferred[tuple[1]](function () {
										var returned = fn && fn.apply(this, arguments);

										if (returned && (typeof returned.promise === "function")) {
											returned.promise()
												.done(newDefer.resolve)
												.fail(newDefer.reject)
												.progress(newDefer.notify);
										} else {
											newDefer[tuple[0] + "With"](this === promise ? newDefer.promise() : this, fn ? [returned] : arguments);
										}
									});
								});
								functions = null;
							}).promise();
						},
						/**
						 * Get a promise for this deferred. If obj is provided,
						 * the promise aspect is added to the object
						 * @method promise
						 * @param {Object} obj
						 * @return {Object} return a Promise object
						 * @member ns.util.deferred
						 */
						promise: function (obj) {
							if (obj) {
								return object.merge(obj, promise);
							}
							return promise;
						}
					};

				/**
				 * alias for promise.then, Keep pipe for back-compat
				 * @method pipe
				 * @member ns.util.deferred
				 */
				promise.pipe = promise.then;

				// Add list-specific methods

				tuples.forEach(function (tuple, i) {
					var list = tuple[2],
						stateString = tuple[3];

					// promise[ done | fail | progress ] = list.add
					promise[tuple[1]] = list.add;

					// Handle state
					if (stateString) {
						list.add(function () {
							// state = [ resolved | rejected ]
							state = stateString;

							// mapping of values [ reject_list | resolve_list ].disable; progress_list.lock
						}, tuples[i ^ 1][2].disable, tuples[2][2].lock);
					}

					// deferred[ resolve | reject | notify ]
					deferred[tuple[0]] = function () {
						deferred[tuple[0] + "With"](this === deferred ? promise : this, arguments);
						return this;
					};
					deferred[tuple[0] + "With"] = list.fireWith;
				});

				// Make the deferred a promise
				promise.promise(deferred);

				// Call given func if any
				if (callback) {
					callback.call(deferred, deferred);
				}

				// All done!
				return deferred;
			};

			ns.util.deferred = Deferred;
			}(window, window.document, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Globalize Utility
 * Object supports globalize options.
 * @class ns.util.globalize
 */

(function (window, document, ns, Globalize) {
	"use strict";
				var isGlobalizeInit = false,
				cldrDataCategory = {main: "main", supplemental: "supplemental"},
				cldrDataCache = {
					main: {},
					supplemental: {}
				},
				customDataCache = {},
				cldrJsonNames = {
					main: [ //has language dependency
						"currencies",
						"ca-gregorian",
						"numbers"
					],
					supplemental: [
						"scriptMetaData",
						"likelySubtags",
						"currencyData",
						"plurals",
						"timeData",
						"weekData",
						"numberingSystems" // this is for arab locale
					]
				},
				UtilDeferred = ns.util.deferred,
				globalizeInstance = null,
				rtlClassName = "ui-script-direction-rtl",
				extension = ".json",
				cldrDataName = "cldr-data",
				libPath = "lib",
				customLocalePathName = "locale";

			/**
			 * Get filtered path from array
			 * @method pathFilter
			 * @param {Array} path
			 * @return {string}
			 * @private
			 */
			function pathFilter(path) {
				return path.filter(function (item) {
					return item;
				}).join("/");
			}

			/**
			 * Get Language code
			 * @method getLang
			 * @param {string} language
			 * @return {string}
			 * @private
			 */
			function getLang(language) {
				var lang = language ||
						document.getElementsByTagName("html")[0].getAttribute("lang") ||
						window.navigator.language.split(".")[0] || // Webkit, Safari + workaround for Tizen
						"en",
					countryCode,
					countryCodeIdx = lang.lastIndexOf("-"),
					ignoreCodes = ["Cyrl", "Latn", "Mong"];	// Not country code!

				if (countryCodeIdx !== -1) {	// Found country code!
					countryCode = lang.substr(countryCodeIdx + 1);
					if (ignoreCodes.join("-").indexOf(countryCode) < 0) {
						// countryCode is not found from ignoreCodes.
						// Make countryCode to uppercase.
						lang = [lang.substr(0, countryCodeIdx), countryCode.toUpperCase()].join("-");
					}
				}
				// NOTE: "en-US"" to "en" because we do not use CLDR full data TODO:Make Guide document for CLDR full data
				lang = getNeutralLang(lang);
				return lang;
			}

			/**
			 * Get neutral language
			 * @method getNeutralLang
			 * @param {string} lang
			 * @return {string}
			 * @private
			 */
			function getNeutralLang(lang) {
				var neutralLangIdx = lang.lastIndexOf("-"),
					neutralLang;

				if (neutralLangIdx !== -1) {
					neutralLang = lang.substr(0, neutralLangIdx);
				} else {
					neutralLang = lang;
				}
				return neutralLang;
			}

			/**
			 * Get path of CLDR data
			 * @method getCldrFilesPath
			 * @param {string} subPath
			 * @param {string} lang
			 * @param {string} jsonName
			 * @return {string}
			 * @private
			 */
			function getCldrFilesPath(subPath, lang, jsonName) {
				var path;

				lang = (subPath === "supplemental") ? null : lang;

				// Default Globalize culture file path
				path = [
					libPath,
					cldrDataName,
					subPath,
					lang,
					jsonName + extension //TODO:Use gregorian
				];

				return pathFilter(path);
			}

			/**
			 * Get path of Custom data which is matched with language
			 * @method getCustomFilesPath
			 * @param {string} lang
			 * @return {string}
			 * @private
			 */
			function getCustomFilesPath(lang) {
				return pathFilter([
					customLocalePathName,
					lang + extension
				]);
			}

			/**
			 * Loads json file
			 * @method loadJSON
			 * @param {string} path
			 * @return {Deferred}
			 * @private
			 */
			function loadJSON(path) {
				var xhrObj,
					jsonObj,
					info,
					deferred = new UtilDeferred();

				if (path) {	// Invalid path -> Regard it as "404 Not Found" error.
					try {
						xhrObj = new XMLHttpRequest();
						xhrObj.onreadystatechange = function () {
							if (xhrObj.readyState === 4) {
								switch (xhrObj.status) {
									case 0:
									case 200:
										jsonObj = JSON.parse(xhrObj.responseText);
										info = {"state": xhrObj.status, "path": path, "data": jsonObj};
										deferred.resolve(info);
										break;
									case 404:
										info = {"state": xhrObj.status, "path": path, "data": null};
										deferred.reject(info);
										break;
									default:
										jsonObj = JSON.parse(xhrObj.responseText);
										info = {"state": xhrObj.status, "path": path, "data": jsonObj};
										deferred.reject(info);
										break;
								}
							}
						};
						xhrObj.open("GET", path, true);
						xhrObj.send("");
					} catch (e) {
						info = {"state": -1, "path": path, "data": null};
						deferred.reject(info);
					}
				} else {
					info = {"state": -2, "path": path, "data": null};
					deferred.reject(info);

				}
				return deferred;
			}

			/**
			 * Loads CLDR data
			 * @method loadCldrData
			 * @param {string|null} language
			 * @param {string} category
			 * @return {Deferred}
			 * @private
			 */
			function loadCldrData(language, category) {
				var path,
					cldrDataTotal = cldrJsonNames[category].length,
					cache = null,
					deferred = new UtilDeferred();

				if (language) { // when category is "main" , language must have value like "en" , "ko" .etc
					if (!cldrDataCache[category].hasOwnProperty(language)) {
						cache = cldrDataCache[category][language] = {};
					} else {
						cache = cldrDataCache[category][language];
					}
				} else { // when category is "supplement" language is empty
					cache = cldrDataCache[category];
				}

				cldrJsonNames[category].forEach(function (fileName) {

					path = getCldrFilesPath(category, language, fileName);

					if (!cache[path]) {
						loadJSON(path).then(function (info) {
							var jsonObj = info.data,
								key = info.path;

							cache[key] = jsonObj; //cache likelySubtags for Globalize
							Globalize.load(jsonObj); //load likelySubtags json
							if (Object.keys(cache).length === cldrDataTotal) {
								deferred.resolve(language);
							}

						}, deferred.reject);

					} else {
						//Globalize.load(cache[path]);
						deferred.resolve(language);
					}
				});

				return deferred;
			}

			/**
			 * Loads custom data
			 * @method loadCustomData
			 * @param {string} localeId
			 * @return {Deferred}
			 * @private
			 */
			function loadCustomData(localeId) {
				var path = null,
					deferred = new UtilDeferred(),
					cache = customDataCache;

				path = getCustomFilesPath(localeId);
				if (!cache[path]) {
					loadJSON(path).then(function (info) {
						cache[path] = info;
						deferred.resolve(info);
					},
						deferred.reject);
				} else {
					deferred.resolve(cache[path]);
				}
				return deferred;
			}

			/**
			 * Init Globalize
			 * @method initGlobalize
			 * @return {Deferred}
			 * @private
			 */
			function initGlobalize() {
				var deferred = new UtilDeferred();

				isGlobalizeInit = true;
				loadCldrData(null, cldrDataCategory.supplemental).then(deferred.resolve, deferred.reject);
				return deferred;
			}

			/**
			 * Check script direction of locale
			 * @method isRTL
			 * @param {string} locale
			 * @private
			 */
			function isRTL(locale) {
				var path = getCldrFilesPath(cldrDataCategory.supplemental, locale, cldrJsonNames.supplemental[0]),
					scriptMetaData = cldrDataCache.supplemental[path] || null,
					result = null;

				locale = Globalize.locale().attributes.script;

				if (scriptMetaData) {
					scriptMetaData.some(function (item) {
						if (item.IDENTIFIER === locale) {
							switch (item.RTL) {
								case "YES":
									result = true;
									break;
								case "NO":
									result = false;
									break;
								case "UNKNOWN":
									result = true;
									break;
							}
							return true;
						}
						return false;
					});
					return result;
				} else {
					throw new Error("Globalize is not initialized");
				}
			}


			/**
			 * Load Basic Locale files for "locale id" in cldr-data directory
			 * @method loadLocaleData
			 * Language code. ex) en-US, en, ko-KR, ko, If language is not
			 * given,
			 * first. Check window.tizen.systeminfo to get locale information
			 * second. Check language from html "lang" attribute.
			 * @param {string} localeId
			 * @return {Deferred}
			 * @private
			 */
			function loadLocaleData(localeId) {
				var deferred = new UtilDeferred();

				if (!isGlobalizeInit) {
					initGlobalize().then(function () {
						loadLocaleData(localeId).then(function (locale) {
							deferred.resolve(locale);
						}, deferred.reject);
					});
				} else {
					if (window.tizen && !localeId) {
						window.tizen.systeminfo.getPropertyValue("LOCALE", function (locale) {
							var countryLang = locale.country;

							if (countryLang) {
								countryLang = getNeutralLang(countryLang.replace("_", "-")); //TODO: Need to fix local id type
							}
							loadCldrData(countryLang, cldrDataCategory.main).then(function (locale) {
								deferred.resolve(locale);
							}, deferred.reject);
						});
					} else {
						//first  find "lang" attribute in html
						//second find "locale" in navigator in window.navigator
						loadCldrData(localeId, cldrDataCategory.main).then(function (locale) {
							deferred.resolve(locale);
						}, deferred.reject);

					}
				}
				return deferred;
			}

			/**
			 * Update class of body to indicate right-to-left language
			 * @method updateScriptDirectionClass
			 * if give language is rtl type than add class ("ui-script-direction-rtl") in body element
			 * @private
			 */
			function updateScriptDirectionClass() {
				var rtl = isRTL(Globalize.locale().locale),
					body = document.body,
					classList = body.classList;

				if (rtl) {
					if (!classList.contains(rtlClassName)) {
						classList.add(rtlClassName);
					}
					Globalize.prototype.rtl = true;
				} else {
					if (classList.contains(rtlClassName)) {
						classList.remove(rtlClassName);
					}
					Globalize.prototype.rtl = false;
				}
			}

			/**
			 * Update Globalize prototype
			 * @method updateGlobalize
			 * @private
			 */
			function updateGlobalize() {
				Globalize.prototype.getLocale = ns.util.globalize.getLocale;
				Globalize.prototype.getCalendar = ns.util.globalize.getCalendar;
			}

			/**
			 * Check Globalize and Cldr object in window object to use core/util/globalize.js
			 * @method checkDependency
			 * @private
			 */
			function checkDependency() {
				return (window.Globalize && window.Cldr);
			}

			ns.util.globalize = {

				/**
				 * Put the module into module array of core.util.globalize
				 * @method importModule
				 * @param {string} fileName
				 * @member ns.util.globalize
				 * @static
				 */
				importModule: function (fileName) {
					var module = fileName.split("/"),
						path = module.shift(),
						moduleMain = cldrJsonNames.main,
						moduleSupplemental = cldrJsonNames.supplemental,
						i = 0,
						j;

					fileName = module.shift();

					switch (path) {
						case "main":
							for (j = moduleMain.length; i < j; i++) {
								if (moduleMain[i] === fileName) {
									return;
								}
							}
							moduleMain.push(fileName);
							break;
						case "supplemental":
							for (j = moduleSupplemental.length; i < j; i++) {
								if (moduleSupplemental[i] === fileName) {
									return;
								}
							}
							moduleSupplemental.push(fileName);
							break;
					}
				},

				/**
				 * Set Locale. This API is Async API.
				 * Please use deferred callback functions which are returned( .done(), .then() .etc)
				 * @method setLocale
				 * @param {string} localeId
				 * @member ns.util.globalize
				 * @return {Deferred}
				 * @static
				 */
				setLocale: function (localeId) {
					var deferred = new UtilDeferred();

					localeId = getLang(localeId);
					if (checkDependency()) {
						loadLocaleData(localeId)
							.then(function (locale) {
								Globalize.locale(locale);
								globalizeInstance = new Globalize(locale);
								return locale;
							}, deferred.reject)
							.done(function (locale) {
								loadCustomData(locale)
									.then(function (info) {
										Globalize.loadMessages(info.data);
										globalizeInstance = new Globalize(locale);
										deferred.resolve(globalizeInstance);
									}, function () {
										globalizeInstance = new Globalize(locale);
										deferred.resolve(globalizeInstance); //we do not care of failure of "loadCustomData on purpose"
									});
							})
							.done(updateScriptDirectionClass)
							.done(updateGlobalize);

						return deferred;
					} else {
						throw new Error("Globalize is not loaded");
					}

				},

				/**
				 * Get Locale.
				 * @method getLocale
				 * @return {string} Current locale
				 * @member ns.util.globalize
				 * @static
				 */
				getLocale: function () {
					if (checkDependency()) {
						return Globalize.locale().locale;
					} else {
						throw new Error("Globalize is not loaded");
					}

				},

				/**
				 * Get gregorian calendar.
				 * @method getCalendar
				 * @return {Object} gregorian calendar data given locale.
				 * @member ns.util.globalize
				 * @static
				 */
				getCalendar: function () {
					//default is gregorian calendar
					//TODO: Need to implementation in jquery/globalize
					//TODO: Need to implement validation
					if (checkDependency() && globalizeInstance) {
						return globalizeInstance.cldr.main("dates/calendars/gregorian");
					} else {
						throw new Error("Globalize is not initialized");
					}

				}

			};

			}(window, window.document, ns, window.Globalize));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Zoom Utility
 * Object supports enabling and disabling zoom.
 * @class ns.util.zoom
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 */
(function (window, document, ns) {
	"use strict";
				var meta = document.querySelector("meta[name=viewport]"),
				initialContent = meta && meta.getAttribute("content"),
				disabledZoom = initialContent + ",maximum-scale=1, user-scalable=no",
				enabledZoom = initialContent + ",maximum-scale=10, user-scalable=yes",
				disabledInitially = /(user-scalable[\s]*=[\s]*no)|(maximum-scale[\s]*=[\s]*1)[$,\s]/.test(initialContent),
				zoom = {
					/**
					 * Status of zoom
					 * @property {boolean} enabled
					 * @static
					 * @member ns.util.zoom
					 */
					enabled: !disabledInitially,
					/**
					 * Flag shows actual locked/unlocked status
					 * @property {boolean} [locked=false]
					 * @static
					 * @member ns.util.zoom
					 */
					locked: false,
					/**
					 * Disable zoom
					 * @method disable
					 * @param {boolean} lock
					 * @static
					 * @member ns.util.zoom
					 */
					disable: function (lock) {
						if (!disabledInitially && !zoom.locked) {
							if (meta) {
								meta.setAttribute("content", disabledZoom);
							}
							zoom.enabled = false;
							zoom.locked = lock || false;
						}
					},
					/**
					 * Enable zoom
					 * @method enable
					 * @param {boolean} unlock
					 * @static
					 * @member ns.util.zoom
					 */
					enable: function (unlock) {
						if (!disabledInitially && (!zoom.locked || unlock === true)) {
							if (meta) {
								meta.setAttribute("content", enabledZoom);
							}
							zoom.enabled = true;
							zoom.locked = false;
						}
					},
					/**
					 * Restore zoom
					 * @method restore
					 * @static
					 * @member ns.util.zoom
					 */
					restore: function () {
						if (!disabledInitially) {
							if (meta) {
								meta.setAttribute("content", initialContent);
							}
							zoom.enabled = true;
						}
					}
				};

			ns.util.zoom = zoom;
			}(window, window.document, ns));

/*global window, ns, define, XMLHttpRequest, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Load Utility
 * Object contains function to load external resources.
 * @class ns.util.load
 */
(function (document, ns) {
	"use strict";
	
			/**
			 * Local alias for document HEAD element
			 * @property {HTMLHeadElement} head
			 * @static
			 * @private
			 * @member ns.util.load
			 */
			var head = document.head,
				/**
				 * Local alias for document styleSheets element
				 * @property {HTMLStyleElement} styleSheets
				 * @static
				 * @private
				 * @member ns.util.load
				 */
				styleSheets = document.styleSheets,
				/**
				 * Local alias for ns.util.DOM
				 * @property {Object} utilsDOM Alias for {@link ns.util.DOM}
				 * @member ns.util.load
				 * @static
				 * @private
				 */
				utilDOM = ns.util.DOM,
				getNSData = utilDOM.getNSData,
				setNSData = utilDOM.setNSData,
				load = ns.util.load || {},
				/**
				 * Regular expression for extracting path to the image
				 * @property {RegExp} IMAGE_PATH_REGEXP
				 * @static
				 * @private
				 * @member ns.util.load
				 */
				IMAGE_PATH_REGEXP = /url\((\.\/)?images/gm,
				/**
				 * Regular expression for extracting path to the css
				 * @property {RegExp} CSS_FILE_REGEXP
				 * @static
				 * @private
				 * @member ns.util.load
				 */
				CSS_FILE_REGEXP = /[^/]+\.css$/;

			/**
			 * Load file
			 * (synchronous loading)
			 * @method loadFileSync
			 * @param {string} scriptPath
			 * @param {?Function} successCB
			 * @param {?Function} errorCB
			 * @static
			 * @private
			 * @member ns.util.load
			 */
			function loadFileSync(scriptPath, successCB, errorCB) {
				var xhrObj = new XMLHttpRequest();

				// open and send a synchronous request
				xhrObj.open("GET", scriptPath, false);
				xhrObj.send();
				// add the returned content to a newly created script tag
				if (xhrObj.status === 200 || xhrObj.status === 0) {
					if (typeof successCB === "function") {
						successCB(xhrObj, xhrObj.status);
					}
				} else {
					if (typeof errorCB === "function") {
						errorCB(xhrObj, xhrObj.status, new Error(xhrObj.statusText));
					}
				}
			}

			/**
			 * Load JSON file
			 * (asynchronous loading)
			 * @method loadJSON
			 * @param {string} scriptPath
			 * @param {?Function} successCB
			 * @param {?Function} errorCB
			 * @static
			 * @member ns.util.load
			 */
			function loadJSON(scriptPath, successCB, errorCB) {
				var xhrObj = new XMLHttpRequest(),
					responseJSON,
					onsuccess = function () {
						if (xhrObj.status === 200) {
							if (typeof successCB === "function") {
								try {
									responseJSON = JSON.parse(xhrObj.responseText);
									successCB(responseJSON, xhrObj.status);
								} catch (err) {
									errorCB(xhrObj, xhrObj.status, new Error(err));
								}
							}
						} else {
							if (typeof errorCB === "function") {
								errorCB(xhrObj, xhrObj.status, new Error(xhrObj.statusText));
							}
						}
					},
					onreadystatechange = function () {
						if (xhrObj.status === 4) {
							onsuccess();
						}
					};

				// open and send a synchronous request
				xhrObj.open("GET", scriptPath, true);
				xhrObj.onreadystatechange = onreadystatechange;
				xhrObj.onload = onsuccess;
				xhrObj.onerror = function (err) {
					errorCB(xhrObj, xhrObj.status, new Error(err));
				};
				xhrObj.send();
			}

			/**
			 * Callback function on javascript load success
			 * @method scriptSyncSuccess
			 * @private
			 * @static
			 * @param {?Function} successCB
			 * @param {?Function} xhrObj
			 * @param {?string} status
			 * @member ns.util.load
			 */
			function scriptSyncSuccess(successCB, xhrObj, status) {
				var script = document.createElement("script");

				script.type = "text/javascript";
				script.text = xhrObj.responseText;
				document.body.appendChild(script);
				if (typeof successCB === "function") {
					successCB(xhrObj, status);
				}
			}


			/**
			 * Add script to document
			 * (synchronous loading)
			 * @method scriptSync
			 * @param {string} scriptPath
			 * @param {?Function} successCB
			 * @param {?Function} errorCB
			 * @static
			 * @member ns.util.load
			 */
			function scriptSync(scriptPath, successCB, errorCB) {
				loadFileSync(scriptPath, scriptSyncSuccess.bind(null, successCB), errorCB);
			}

			/**
			 * Callback function on css load success
			 * @method cssSyncSuccess
			 * @param {string} cssPath
			 * @param {?Function} successCB
			 * @param {?Function} xhrObj
			 * @member ns.util.load
			 * @static
			 * @private
			 */
			function cssSyncSuccess(cssPath, successCB, xhrObj) {
				var css = document.createElement("style");

				css.type = "text/css";
				css.textContent = xhrObj.responseText.replace(
					IMAGE_PATH_REGEXP,
					"url(" + cssPath.replace(CSS_FILE_REGEXP, "images")
				);
				if (typeof successCB === "function") {
					successCB(css);
				}
			}

			/**
			 * Add css to document
			 * (synchronous loading)
			 * @method cssSync
			 * @param {string} cssPath
			 * @param {?Function} successCB
			 * @param {?Function} errorCB
			 * @static
			 * @private
			 * @member ns.util.load
			 */
			function cssSync(cssPath, successCB, errorCB) {
				loadFileSync(cssPath, cssSyncSuccess.bind(null, cssPath, successCB), errorCB);
			}

			/**
			 * Add element to head tag
			 * @method addElementToHead
			 * @param {HTMLElement} element
			 * @param {boolean} [asFirstChildElement=false]
			 * @member ns.util.load
			 * @static
			 */
			function addElementToHead(element, asFirstChildElement) {
				var firstElement;

				if (head) {
					if (asFirstChildElement) {
						firstElement = head.firstElementChild;
						if (firstElement) {
							head.insertBefore(element, firstElement);
							return;
						}
					}
					head.appendChild(element);
				}
			}

			/**
			 * Create HTML link element with href
			 * @method makeLink
			 * @param {string} href
			 * @return {HTMLLinkElement}
			 * @member ns.util.load
			 * @static
			 */
			function makeLink(href) {
				var cssLink = document.createElement("link");

				cssLink.setAttribute("rel", "stylesheet");
				cssLink.setAttribute("href", href);
				cssLink.setAttribute("name", "tizen-theme");
				return cssLink;
			}

			/**
			 * Adds the given node to document head or replaces given 'replaceElement'.
			 * Additionally adds 'name' and 'theme-name' attribute
			 * @param {HTMLElement} node Element to be placed as theme link
			 * @param {string} themeName Theme name passed to the element
			 * @param {HTMLElement} [replaceElement=null] If replaceElement is given it gets replaced by node
			 */
			function addNodeAsTheme(node, themeName, replaceElement) {
				setNSData(node, "name", "tizen-theme");
				setNSData(node, "theme-name", themeName);

				if (replaceElement) {
					replaceElement.parentNode.replaceChild(node, replaceElement);
				} else {
					addElementToHead(node, true);
				}
			}

			/**
			 * Add css link element to head if not exists
			 * @method themeCSS
			 * @param {string} path
			 * @param {string} themeName
			 * @param {boolean} [embed=false] Embeds the CSS content to the document
			 * @member ns.util.load
			 * @static
			 */
			function themeCSS(path, themeName, embed) {
				var i,
					styleSheetsLength = styleSheets.length,
					ownerNode,
					previousElement = null,
					linkElement;
				// Find css link or style elements

				for (i = 0; i < styleSheetsLength; i++) {
					ownerNode = styleSheets[i].ownerNode;

					// We try to find a style / link node that matches current style or is linked to
					// the proper theme. We cannot use ownerNode.href because this returns the absolute path
					if (getNSData(ownerNode, "name") === "tizen-theme" || ownerNode.getAttribute("href") === path) {
						if (getNSData(ownerNode, "theme-name") === themeName) {
							// Nothing to change
							return;
						}
						previousElement = ownerNode;
						break;
					}
				}

				if (embed) {
					// Load and replace old styles or append new styles
					cssSync(path, function onSuccess(styleElement) {
						addNodeAsTheme(styleElement, themeName, previousElement);
					}, function onFailure(xhrObj, xhrStatus) {
						ns.warn("There was a problem when loading '" + themeName + "', status: " + xhrStatus);
					});
				} else {
					linkElement = makeLink(path);
					addNodeAsTheme(linkElement, themeName, previousElement);
				}
			}

			/**
			 * In debug mode add time to url to disable cache
			 * @property {string} cacheBust
			 * @member ns.util.load
			 * @static
			 */
			load.cacheBust = (document.location.href.match(/debug=true/)) ? "?cacheBust=" + (new Date()).getTime() : "";
			// the binding a local methods with the namespace
			load.scriptSync = scriptSync;
			load.addElementToHead = addElementToHead;
			load.makeLink = makeLink;
			load.themeCSS = themeCSS;
			load.JSON = loadJSON;

			ns.util.load = load;
			}(window.document, ns));

/*global window, define, ns*/
/*jslint bitwise: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Framework Data Object
 * Object contains properties describing run time environment.
 * @class ns.frameworkData
 */
(function (document, ns) {
	"use strict";
				var slice = Array.prototype.slice,
				FRAMEWORK_WEBUI = "tizen-web-ui-fw",
				FRAMEWORK_TAU = "tau",
				IS_TAU_REGEXP = /(^|[\\\/])(tau(\.full|\.mvc)?(\.min)?\.js)$/,
				// Regexp detect framework js file
				LIB_FILENAME_REGEXP = /(^|[\\\/])(tau|tizen-web-ui-fw)(\.full|\.mvc|\.custom)?(\.min)?\.js$/,
				// Regexp detect framework css file
				CSS_FILENAME_REGEXP = /(^|[\\\/])(tau|tizen-web-ui-fw)(\.full|\.mvc|\.custom)?(\.min)?\.css$/,
				// Regexp detect correct theme name
				TIZEN_THEMES_REGEXP = /^(changeable|white|black|default)$/i,
				MINIFIED_REGEXP = /\.min\.js$/,
				frameworkData = {
					/**
					 * The name of framework
					 * @property {string} frameworkName="tizen-web-ui-fw"
					 * @member ns.frameworkData
					 * @static
					 */
					frameworkName: FRAMEWORK_WEBUI,
					/**
					 * The root directory of framework on current device
					 * @property {string} rootDir="/usr/share/tizen-web-ui-fw"
					 * @member ns.frameworkData
					 * @static
					 */
					rootDir: "/usr/share/" + FRAMEWORK_WEBUI,
					/**
					 * The version of framework
					 * @property {string} version="latest"
					 * @member ns.frameworkData
					 * @static
					 */
					version: "latest",
					/**
					 * The theme of framework
					 * @property {string} theme="default"
					 * @member ns.frameworkData
					 * @static
					 */
					theme: "default",
					/**
					 * Tells if the theme that is set was already loaded
					 * @property {boolean} themeLoaded=false
					 * @member ns.frameworkData
					 * @static
					 */
					themeLoaded: false,
					/**
					 * The default width of viewport in framework.
					 * @property {number} defaultViewportWidth=360
					 * @member ns.frameworkData
					 * @static
					 */
					defaultViewportWidth: 360,
					/**
					 * The type of width of viewport in framework.
					 * @property {string} viewportWidth="device-width"
					 * @member ns.frameworkData
					 * @static
					 */
					viewportWidth: "device-width",
					/**
					 * Determines whether the viewport should be scaled
					 * @property {boolean} isMinified=false
					 * @member ns.frameworkData
					 * @static
					 */
					viewportScale: false,
					/**
					 * The default font size in framework.
					 * @property {number} defaultFontSize=22
					 * @member ns.frameworkData
					 * @static
					 */
					defaultFontSize: 22,
					/**
					 * Determines whether the framework is minified
					 * @property {boolean} minified=false
					 * @member ns.frameworkData
					 * @static
					 */
					minified: false,
					/**
					 * Determines the capability of device
					 * @property {Object} deviceCapa
					 * @property {boolean} deviceCapa.inputKeyBack=true
					 * Determines whether the back key is supported.
					 * @property {boolean} deviceCapa.inputKeyMenu=true
					 *  Determines whether the menu key is supported.
					 * @member ns.frameworkData
					 * @static
					 */
					deviceCapa: {inputKeyBack: true, inputKeyMenu: true},
					/**
					 * Determines whether the framework is loaded in debug profile.
					 * @property {boolean} debug=false
					 * @member ns.frameworkData
					 * @static
					 */
					debug: false,
					/**
					 * The version of framework's package
					 * @property {string} pkgVersion="0.2.83"
					 * @member ns.frameworkData
					 * @static
					 */
					pkgVersion: "0.2.83",
					/**
					 * The prefix of data used in framework
					 * @property {string} dataPrefix="data-framework-"
					 * @member ns.frameworkData
					 * @static
					 */
					dataPrefix: "data-framework-",
					/**
					 * The profile of framework
					 * @property {string} profile=""
					 * @member ns.frameworkData
					 * @static
					 */
					profile: ""
				};

			/**
			 * Get data-* params from <script> tag, and set tizen.frameworkData.* values
			 * Returns true if proper <script> tag is found, or false if not.
			 * @method getParams
			 * @return {boolean} Returns true if proper <script> tag is found, or false if not.
			 * @member ns.frameworkData
			 * @static
			 */
			frameworkData.getParams = function () {
				var self = this,
					dataPrefix = self.dataPrefix,
					scriptElements = slice.call(document.querySelectorAll("script[src]")),
					cssElements = slice.call(document.styleSheets),
					themeLoaded = false,
					theme;

				/**
				 * Following cases should be covered here (by recognizing on-page css files).
				 * The final theme and themePath values are determined after going through all script elements
				 *
				 *
				 * none                                       -> theme: null
				 * <link href="theme.css" />                  -> theme: null
				 * <link href="default/theme.css" />          -> theme: null
				 * <link href="tau.css" />                    -> theme: null
				 * <link href="white/tau.min.css" />          -> theme: "white"
				 * <link href="other/path/black/tau.css" />   -> theme: "black"
				 * <link href="other/path/black/tau.css" />   -> theme: "black"
				 * <link href="other/path/black/other.css" /> -> theme: null
				 * <link href="other/path/black/other.css" data-theme-name="white" />     -> theme: "white"
				 * @method findThemeInLinks
				 * @param {CSSStyleSheet} styleSheet
				 */
				// @TODO write unit tests for covering those cases
				function findThemeInLinks(styleSheet) {
					var cssElement = styleSheet.ownerNode,
						dataThemeName = cssElement.getAttribute("data-theme-name"),
						// Attribute value is taken because href property gives different output
						href = cssElement.getAttribute("href"),
						hrefFragments = href && href.split("/"),
						hrefDirPart;

					// If we have the theme name defined we can use it right away
					// without thinking about the naming convention
					if (dataThemeName) {
						if (TIZEN_THEMES_REGEXP.test(dataThemeName)) {
							theme = dataThemeName;
						}
					} else if (href && CSS_FILENAME_REGEXP.test(href)) {
						// We try to find file matching library theme CSS
						// If we have the theme name defined we can use it right away
						// We can only determine the current theme using path based approach when the .css file
						// is located in at least one directory
						if (hrefFragments.length >= 2) {
							// When the second to last element matches known themes set the theme to that name
							hrefDirPart = hrefFragments.slice(-2)[0].match(TIZEN_THEMES_REGEXP);
							theme = hrefDirPart && hrefDirPart[0];
						}
					}

					// In case a theme was found (here or in a previous stylesheet) this will be true
					themeLoaded = themeLoaded || !!theme;
				}

				/**
				 * Sets framework data based on found framework library
				 * @param {HTMLElement} scriptElement
				 */
				// @TODO write unit cases
				function findFrameworkDataInScripts(scriptElement) {
					var src = scriptElement.getAttribute("src"),
						profileName = "",
						frameworkName,
						themePath,
						jsPath;

					// Check if checked file is a known framework
					// no need to check if src exists because of the query selector
					if (LIB_FILENAME_REGEXP.test(src)) {

						// Priority:
						// 1. theme loaded with css
						// 2. theme from attribute
						// 3. default theme
						theme = theme || scriptElement.getAttribute(dataPrefix + "theme") || self.theme;

						theme = theme.toLowerCase();

						if (IS_TAU_REGEXP.test(src)) {
							frameworkName = FRAMEWORK_TAU;
							// Get profile name.
							// Profile may be defined from framework script or
							// it can be assumed, that profile name is second up directory name
							// e.g. pathToLib/profileName/js/tau.js
							profileName = scriptElement.getAttribute(dataPrefix + "profile") || src.split("/").slice(-3)[0];
							themePath = "/" + profileName + "/theme/" + theme;

							// TAU framework library link
							jsPath = "/" + profileName + "/js";
						} else {
							// tizen-web-ui framework
							frameworkName = FRAMEWORK_WEBUI;
							themePath = "/latest/themes/" + theme;
							jsPath = "/latest/js";
						}

						self.rootDir = scriptElement.getAttribute(dataPrefix + "root") ||
							// remove from src path jsPath and "/" sign
							src.substring(0, src.lastIndexOf(frameworkName) - jsPath.length - 1) ||
							self.rootDir;

						self.themePath = self.rootDir + themePath;
						self.jsPath = self.rootDir + jsPath;
						self.version = scriptElement.getAttribute(dataPrefix + "version") || self.version;
						self.theme = theme;
						self.themeLoaded = themeLoaded;
						self.frameworkName = frameworkName;
						self.minified = src.search(MINIFIED_REGEXP) > -1;
						self.profile = profileName;
					}
				}

				cssElements.forEach(findThemeInLinks);
				scriptElements.forEach(findFrameworkDataInScripts);
			};

			ns.frameworkData = frameworkData;
			// self init
			ns.frameworkData.getParams();
			}(window.document, ns));

/*global window, ns, define */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping engine
 * Object maps engine object from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.engine
 */
(function (window, document) {
	"use strict";
				/**
			 * Alias to Array.slice function
			 * @method slice
			 * @member ns.jqm.engine
			 * @private
			 * @static
			 */
			var slice = [].slice,
				/**
				 * @property {Object} nsNormalizeDict directory of data-* attributes normalized name
				 * @member ns.jqm.engine
				 * @private
				 * @static
				 */
				nsNormalizeDict = {},
				$ = ns.jqm.jQuery,
				util = ns.util,
				zoom = util.zoom,
				events = ns.event,
				load = util.load,
				utilsObject = util.object,
				/*
				 * Convert jQuery object to HTMLElement or Array of HTMLElements
				 * @param {jQuery|HTMLElement|Array} item
			   * @return {HTMLElement|Array}
				 */
				mapItem = function (item) {
					if (typeof item === "object" && item.selector && item.get) {
						return item.length === 1 ? item.get(0) : item.toArray();
					}

					return item;
				},
				engine = ns.engine,
				eventType = engine.eventType,

			/**
			 * append ns functions to jQuery Mobile namespace
			 * @method init
			 * @member ns.jqm.engine
			 * @static
			 */
				init = function () {
					var keys = Object.keys(engine),
						i,
						len,
						name,
						/*
						 * original jQuery find function
						 * type function
						 */
						oldFind,
						/*
						 * regular expression to find data-{namespace}-attribute
						 */
						jqmDataRE = /:jqmData\(([^)]*)\)/g, // @TODO fix, insecure (jslint)
						/*
						 * string to detect exists jqmData selector
						 */
						jqmDataStr = ":jqmData",


						tizen;

					if ($) {

						for (i = 0, len = keys.length; i < len; ++i) {
							name = keys[i];
							$[name] = widgetFunction.bind(null, arguments, mapItem, engine, name);
						}

						utilsObject.merge($.mobile, {
							/*
							 * jQuery Mobile namespace
							 */
							ns: "",
							/**
							 *
							 * @param {string} prop
							 * @return {?string}
							 */
							nsNormalize: function (prop) {
								if (!prop) {
									return null;
								}
								nsNormalizeDict[prop] = nsNormalizeDict[prop] || $.camelCase($.mobile.ns + prop);
								return nsNormalizeDict[prop];
							},
							activeBtnClass: ns.widget.core.Button.classes.uiBtnActive,
							activePageClass: ns.widget.core.Page.classes.uiPageActive,
							focusClass: ns.widget.core.Button.classes.uiFocus,
							version: "1.2.0",
							getAttrFixed: function (element, key) {
								var value = element.getAttribute(key);

								return value === "true" ? true :
									value === "false" ? false :
										value === null ? undefined :
											value;
							},
							path: ns.util.path,
							back: window.history.back.bind(window.history),
							silentScroll: function (yPos) {
								if (yPos === undefined) {
									yPos = $.mobile.defaultHomeScroll;
								}

								// prevent scrollstart and scrollstop events
								// @TODO enable event control
								//ns.event.special.scrollstart.enabled = false;

								setTimeout(function () {
									window.scrollTo(0, yPos);
									events.trigger(document, "silentscroll", {x: 0, y: yPos});
								}, 20);

								setTimeout(function () {
									// @TODO enable event control
									//$.event.special.scrollstart.enabled = true;
								}, 150);
							},
							nsNormalizeDict: nsNormalizeDict,
							closestPageData: function (target) {
								var page = ns.util.selectors.getClosestBySelector($(target)[0],
									"[data-" + ($.mobile.ns || "") + "role='page'], [data-" + ($.mobile.ns || "") + "role='dialog']");

								return ns.engine.instanceWidget(page, "Page");
							},
							enhanceable: function ($set) {
								return this.haveParents($set, "enhance");
							},
							hijackable: function ($set) {
								return this.haveParents($set, "ajax");
							},
							haveParents: function ($set, attr) {
								var count = 0,
									$newSet = null,
									e,
									$element,
									excluded,
									i,
									c;

								if (!$.mobile.ignoreContentEnabled) {
									return $set;
								}

								count = $set.length;
								$newSet = $();

								for (i = 0; i < count; i++) {
									$element = $set.eq(i);
									excluded = false;
									e = $set[i];

									while (e) {
										c = e.getAttribute ? e.getAttribute("data-" + $.mobile.ns + attr) : "";

										if (c === "false") {
											excluded = true;
											break;
										}

										e = e.parentNode;
									}

									if (!excluded) {
										$newSet = $newSet.add($element);
									}
								}

								return $newSet;
							},
							getScreenHeight: function () {
								// Native innerHeight returns more accurate value for this across platforms,
								// jQuery version is here as a normalized fallback for platforms like Symbian
								return window.innerHeight;
							},
							widget: function () {
								// @todo fill data
								return null;
							},
							media: ns.support.media,
							browser: {},
							gradeA: function () {
								// @todo fill data
								return null;
							},
							zoom: zoom,
							popupwindow: {}
						});
						$.mobile.buttonMarkup = $.mobile.buttonMarkup || ns.widget.mobile.Button;
						$.mobile.$window = $(window);
						$.mobile.$document = $(document);
						$.mobile.keyCode = {
							ALT: 18,
							BACKSPACE: 8,
							CAPS_LOCK: 20,
							COMMA: 188,
							COMMAND: 91,
							COMMAND_LEFT: 91, // COMMAND
							COMMAND_RIGHT: 93,
							CONTROL: 17,
							DELETE: 46,
							DOWN: 40,
							END: 35,
							ENTER: 13,
							ESCAPE: 27,
							HOME: 36,
							INSERT: 45,
							LEFT: 37,
							MENU: 93, // COMMAND_RIGHT
							NUMPAD_ADD: 107,
							NUMPAD_DECIMAL: 110,
							NUMPAD_DIVIDE: 111,
							NUMPAD_ENTER: 108,
							NUMPAD_MULTIPLY: 106,
							NUMPAD_SUBTRACT: 109,
							PAGE_DOWN: 34,
							PAGE_UP: 33,
							PERIOD: 190,
							RIGHT: 39,
							SHIFT: 16,
							SPACE: 32,
							TAB: 9,
							UP: 38,
							WINDOWS: 91 // COMMAND
						};
						$.tizen = $.tizen || {};
						tizen = $.tizen;
						tizen.globalize = ns.util.globalize;
						$.mobile.tizen = utilsObject.merge($.mobile.tizen, {
							_widgetPrototypes: {},
							disableSelection: function () {
								ns.warn("Function $.mobile.tizen.disableSelection is deprecated");
							},
							enableSelection: function () {
								ns.warn("Function $.mobile.tizen.enableSelection is deprecated");
							},
							enableContextMenu: function () {
								ns.warn("Function $.mobile.tizen.enableContextMenu is deprecated");
							},
							disableContextMenu: function () {
								ns.warn("Function $.mobile.tizen.disableContextMenu is deprecated");
							}
						});
						$.mobile.tizen.loadPrototype = null;

						/*
						 * jqmData function from jQuery Mobile
						 */
						$.fn.jqmData = function (prop, value) {
							var result;

							if (prop !== undefined) {
								if (prop) {
									prop = $.mobile.nsNormalize(prop);
								}
								if (arguments.length < 2 || value === undefined) {
									result = this.data(prop);
								} else {
									result = this.data(prop, value);
								}
							}
							return result;
						};

						$.fn.jqmRemoveData = function (prop) {
							if (prop !== undefined) {
								if (prop) {
									prop = $.mobile.nsNormalize(prop);
								}
								this.removeData(prop);
							}
							return this;
						};

						$.jqmData = function (context, prop, value) {
							var result = $(context).jqmData(prop, value);

							return value || result;
						};

						$.jqmRemoveData = function (context, prop) {
							$(context).jqmRemoveData(prop);
						};

						$.fn.removeWithDependents = function () {
							$.removeWithDependents(this);
						};

						$.removeWithDependents = function (elem) {
							var $elem = $(elem);

							($elem.jqmData("dependents") || $()).remove();
							$elem.remove();
						};

						$.fn.addDependents = function (newDependents) {
							$.addDependents($(this), newDependents);
						};

						$.addDependents = function (elem, newDependents) {
							var dependents = $(elem).jqmData("dependents") || $();

							$(elem).jqmData("dependents", $.merge(dependents, newDependents));
						};

						$.fn.getEncodedText = function () {
							return $("<div/>").text($(this).text()).html();
						};

						// fluent helper function for the mobile namespaced equivalent
						$.fn.jqmEnhanceable = function () {
							return $.mobile.enhanceable(this);
						};

						$.fn.jqmHijackable = function () {
							return $.mobile.hijackable(this);
						};

						/*
						 * Add support of jqmData() in jQuery find
						 */
						oldFind = $.find;

						$.find = function (selector, context, ret, extra) {
							if (selector.indexOf(jqmDataStr) > -1) {
								selector = selector.replace(jqmDataRE, "[data-" + ($.mobile.ns || "") + "$1]");
							}
							return oldFind.call(this, selector, context, ret, extra);
						};

						$.extend($.find, oldFind);

						$.find.matches = function (expr, set) {
							return $.find(expr, null, null, set);
						};

						$.find.matchesSelector = function (node, expr) {
							return $.find(expr, null, null, [node]).length > 0;
						};

						/* support for global object $.mobile
						 * @TODO this is temporary fix, we have to think about this function
						 */
						$(document).bind("create", ns.engine._createEventHandler);
						// support creating widgets by triggering pagecreate
						$(document).bind("pagecreate", function (event) {
							var originalEvent = event.originalEvent || event,
								isPage = originalEvent.detail instanceof ns.widget.core.Page,
								pageWidget;

							if (!isPage) { // trigger create when the pagecreate trigger is from outside
								pageWidget = engine.instanceWidget(originalEvent.target, "Page");
								pageWidget.refresh();
								ns.engine._createEventHandler(originalEvent);
							}
						});
						$(document).bind("activePopup", function (event) {
							$.mobile.popup.active = $.mobile.popupwindow.active = event.originalEvent.detail;
						});

						// @TODO fill this object proper data
						$.tizen.frameworkData = ns.frameworkData;

						$.tizen.__tizen__ = tizen;
						tizen.libFileName = "tizen-web-ui-fw(.custom|.full)?(.min)?.js";
						tizen.log = {
							debug: function (msg) {
								if ($.tizen.frameworkData.debug) {
									ns.log(msg);
								}
							},
							warn: ns.warn.bind(ns),
							error: ns.error.bind(ns),
							alert: window.alert.bind(window)
						};
						tizen.util = {
							loadScriptSync: load.scriptSync,
							isMobileBrowser: function () {
								ns.warn("Function $.tizen.__tizen__.util.isMobileBrowser is deprecated");
							}
						};
						tizen.css = {
							cacheBust: load.cacheBust,
							addElementToHead: load.addElementToHead.bind(load),
							makeLink: load.makeLink.bind(load),
							load: load.themeCSS
						};
						tizen.loadTheme = function () {
							ns.warn("Function $.tizen.__tizen__.loadTheme is deprecated");
						};
						//tizen.loadGlobalizeCulture = ns.util.globalize.loadGlobalizeCulture.bind(ns.util.globalize);
						tizen.setLocale = util.globalize.setLocale;
						tizen.setViewport = function () {
							ns.warn("Function $.tizen.__tizen__.setViewport is deprecated");
						};
						tizen.scaleBaseFontSize = function () {
							ns.warn("Function $.tizen.__tizen__.scaleBaseFontSize is deprecated");
						};
						tizen.setScaling = function () {
							ns.warn("Function $.tizen.__tizen__.setScaling is deprecated");
						};
						tizen.getParams = ns.frameworkData.getParams.bind(ns.frameworkData);

						ns.setConfig("enableHWKeyHandler", $.mobile.tizen.enableHWKeyHandler);
					}
				},
				/**
				 * Removes events listeners on destroy of framework.
				 */
				destroy = function () {
					document.removeEventListener(eventType.INIT, init, false);
					document.removeEventListener(eventType.DESTROY, destroy, false);
				};

			/**
			 * Function which is used as jQuery mapping engine method
			 * @param {Arguments} parentArguments
			 * @param {Function} mapItem
			 * @param {Object} engine
			 * @param {string} name
			 */
			function widgetFunction(parentArguments, mapItem, engine, name) {
				var args = slice.call(parentArguments).map(mapItem);

				engine[name].apply(engine, args);
			}

			// Listen when framework is ready
			document.addEventListener(eventType.INIT, init, false);
			document.addEventListener(eventType.DESTROY, destroy, false);

			}(window, window.document));

/*global CustomEvent, define, window, ns */
/*jslint plusplus: true, nomen: true, bitwise: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Virtual Mouse Events
 * Reimplementation of jQuery Mobile virtual mouse events.
 *
 * ##Purpose
 * It will let for users to register callbacks to the standard events like bellow,
 * without knowing if device support touch or mouse events
 * @class ns.event.vmouse
 */
/**
 * Triggered after mouse-down or touch-started.
 * @event vmousedown
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-click or touch-end when touch-move didn't occur
 * @event vclick
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-up or touch-end
 * @event vmouseup
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-move or touch-move
 * @event vmousemove
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-over or touch-start if went over coordinates
 * @event vmouseover
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-out or touch-end
 * @event vmouseout
 * @member ns.event.vmouse
 */
/**
 * Triggered when mouse-cancel or touch-cancel and when scroll occur during touchmove
 * @event vmousecancel
 * @member ns.event.vmouse
 */
(function (window, document, ns) {
	"use strict";
				/**
			 * Object with default options
			 * @property {Object} vmouse
			 * @member ns.event.vmouse
			 * @static
			 * @private
			 **/
			var vmouse,
				/**
				 * @property {Object} eventProps Contains the properties which are copied from the original
				 * event to custom v-events
				 * @member ns.event.vmouse
				 * @static
				 * @private
				 **/
				eventProps,
				/**
				 * Indicates if the browser support touch events
				 * @property {boolean} touchSupport
				 * @member ns.event.vmouse
				 * @static
				 **/
				touchSupport = window.hasOwnProperty("ontouchstart"),
				/**
				 * @property {boolean} didScroll The flag tell us if the scroll event was triggered
				 * @member ns.event.vmouse
				 * @static
				 * @private
				 **/
				didScroll,
				/** @property {HTMLElement} lastOver holds reference to last element that touch was over
				 * @member ns.event.vmouse
				 * @private
				 */
				lastOver = null,
				/**
				 * @property {number} [startX=0] Initial data for touchstart event
				 * @member ns.event.vmouse
				 * @static
				 * @private
				 **/
				startX = 0,
				/**
				 * @property {number} [startY=0] Initial data for touchstart event
				 * @member ns.event.vmouse
				 * @private
				 * @static
				 **/
				startY = 0,
				touchEventProps = ["clientX", "clientY", "pageX", "pageY", "screenX", "screenY"],
				KEY_CODES = {
					enter: 13
				};

			/**
			 * Extends objects with other objects
			 * @method copyProps
			 * @param {Object} from Sets the original event
			 * @param {Object} to Sets the new event
			 * @param {Object} properties Sets the special properties for position
			 * @param {Object} propertiesNames Describe parameters which will be copied from Original to
			 * event
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function copyProps(from, to, properties, propertiesNames) {
				var i,
					length,
					descriptor,
					property;

				for (i = 0, length = propertiesNames.length; i < length; ++i) {
					property = propertiesNames[i];
					if (isNaN(properties[property]) === false || isNaN(from[property]) === false) {
						descriptor = Object.getOwnPropertyDescriptor(to, property);
						if (property !== "detail" && (!descriptor || descriptor.writable)) {
							to[property] = properties[property] || from[property];
						}
					}
				}
			}

			/**
			 * Create custom event
			 * @method createEvent
			 * @param {string} newType gives a name for the new Type of event
			 * @param {Event} original Event which trigger the new event
			 * @param {Object} properties Sets the special properties for position
			 * @return {Event}
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function createEvent(newType, original, properties) {
				var evt = new CustomEvent(newType, {
						"bubbles": original.bubbles,
						"cancelable": original.cancelable,
						"detail": original.detail
					}),
					originalType = original.type,
					changeTouches,
					touch,
					j = 0,
					len,
					prop;

				copyProps(original, evt, properties, eventProps);
				evt._originalEvent = original;

				if (originalType.indexOf("touch") !== -1) {
					originalType = original.touches;
					changeTouches = original.changedTouches;

					if (originalType && originalType.length) {
						touch = originalType[0];
					} else {
						touch = (changeTouches && changeTouches.length) ? changeTouches[0] : null;
					}

					if (touch) {
						for (len = touchEventProps.length; j < len; j++) {
							prop = touchEventProps[j];
							evt[prop] = touch[prop];
						}
					}
				}

				return evt;
			}

			/**
			 * Dispatch Events
			 * @method fireEvent
			 * @param {string} eventName event name
			 * @param {Event} evt original event
			 * @param {Object} [properties] Sets the special properties for position
			 * @return {boolean}
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function fireEvent(eventName, evt, properties) {
				return evt.target.dispatchEvent(createEvent(eventName, evt, properties || {}));
			}

			eventProps = [
				"currentTarget",
				"detail",
				"button",
				"buttons",
				"clientX",
				"clientY",
				"offsetX",
				"offsetY",
				"pageX",
				"pageY",
				"screenX",
				"screenY",
				"toElement",
				"which"
			];

			vmouse = {
				/**
				 * Sets the distance of pixels after which the scroll event will be successful
				 * @property {number} [eventDistanceThreshold=10]
				 * @member ns.event.vmouse
				 * @static
				 */
				eventDistanceThreshold: 10,

				touchSupport: touchSupport
			};

			/**
			 * Handle click down
			 * @method handleDown
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleDown(evt) {
				fireEvent("vmousedown", evt);
			}

			/**
			 * Prepare position of event for keyboard events.
			 * @method preparePositionForClick
			 * @param {Event} event
			 * @return {?Object} options
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function preparePositionForClick(event) {
				var x = event.clientX,
					y = event.clientY;
				// event comes from keyboard

				if (!x && !y) {
					return preparePositionForEvent(event);
				}
			}

			/**
			 * Handle click
			 * @method handleClick
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleClick(evt) {
				fireEvent("vclick", evt, preparePositionForClick(evt));
			}

			/**
			 * Handle click up
			 * @method handleUp
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleUp(evt) {
				fireEvent("vmouseup", evt);
			}

			/**
			 * Handle click move
			 * @method handleMove
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleMove(evt) {
				fireEvent("vmousemove", evt);
			}

			/**
			 * Handle click over
			 * @method handleOver
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleOver(evt) {
				fireEvent("vmouseover", evt);
			}

			/**
			 * Handle click out
			 * @method handleOut
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleOut(evt) {
				fireEvent("vmouseout", evt);
			}

			/**
			 * Handle touch start
			 * @method handleTouchStart
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleTouchStart(evt) {
				var touches = evt.touches,
					firstTouch;

				//if touches are registered and we have only one touch
				if (touches && touches.length === 1) {
					didScroll = false;
					firstTouch = touches[0];
					startX = firstTouch.pageX;
					startY = firstTouch.pageY;

					// Check if we have touched something on our page
					// @TODO refactor for multi touch
					/*
					 over = document.elementFromPoint(startX, startY);
					 if (over) {
					 lastOver = over;
					 fireEvent("vmouseover", evt);
					 }
					 */
					fireEvent("vmousedown", evt);
				}

			}

			/**
			 * Handle touch end
			 * @method handleTouchEnd
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleTouchEnd(evt) {
				var touches = evt.touches;

				if (touches && touches.length === 0) {
					fireEvent("vmouseup", evt);
					fireEvent("vmouseout", evt);
					// Reset flag for last over element
					lastOver = null;
				}
			}

			/**
			 * Handle touch move
			 * @method handleTouchMove
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleTouchMove(evt) {
				var over,
					firstTouch = evt.touches && evt.touches[0],
					didCancel = didScroll,
					//sets the threshold, based on which we consider if it was the touch-move event
					moveThreshold = vmouse.eventDistanceThreshold;

				/**
				 * Ignore the touch which has identifier other than 0.
				 * Only first touch has control others are ignored.
				 * Patch for webkit behavior where touchmove event
				 * is triggered between touchend events
				 * if there is multi touch.
				 */

				if ((firstTouch === undefined) || firstTouch.identifier > 0) {
					//evt.preventDefault(); // cant preventDefault passive events!!!
					evt.stopPropagation();
					return;
				}

				didScroll = didScroll ||
					//check in both axes X,Y if the touch-move event occur
					(Math.abs(firstTouch.pageX - startX) > moveThreshold ||
					Math.abs(firstTouch.pageY - startY) > moveThreshold);

				// detect over event
				// for compatibility with mouseover because "touchenter" fires only once
				// @TODO Handle many touches
				over = document.elementFromPoint(firstTouch.pageX, firstTouch.pageY);
				if (over && lastOver !== over) {
					lastOver = over;
					fireEvent("vmouseover", evt);
				}

				//if didScroll occur and wasn't canceled then trigger touchend otherwise just touchmove
				if (didScroll && !didCancel) {
					fireEvent("vmousecancel", evt);
					lastOver = null;
				}
				fireEvent("vmousemove", evt);
			}

			/**
			 * Handle Scroll
			 * @method handleScroll
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleScroll(evt) {
				if (!didScroll) {
					fireEvent("vmousecancel", evt);
				}
				didScroll = true;
			}

			/**
			 * Handle touch cancel
			 * @method handleTouchCancel
			 * @param {Event} evt
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleTouchCancel(evt) {

				fireEvent("vmousecancel", evt);
				lastOver = null;
			}

			/**
			 * Prepare position of event for keyboard events.
			 * @method preparePositionForEvent
			 * @param {Event} event
			 * @return {Object} properties
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function preparePositionForEvent(event) {
				var targetRect = event.target && event.target.getBoundingClientRect(),
					properties = {};

				if (targetRect) {
					properties = {
						"clientX": targetRect.left + targetRect.width / 2,
						"clientY": targetRect.top + targetRect.height / 2,
						"which": 1
					};
				}
				return properties;
			}

			/**
			 * Handle key up
			 * @method handleKeyUp
			 * @param {Event} event
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleKeyUp(event) {
				var properties;

				if (event.keyCode === KEY_CODES.enter) {
					properties = preparePositionForEvent(event);
					fireEvent("vmouseup", event, properties);
					fireEvent("vclick", event, properties);
				}
			}

			/**
			 * Handle key down
			 * @method handleKeyDown
			 * @param {Event} event
			 * @private
			 * @static
			 * @member ns.event.vmouse
			 */
			function handleKeyDown(event) {
				if (event.keyCode === KEY_CODES.enter) {
					fireEvent("vmousedown", event, preparePositionForEvent(event));
				}
			}

			/**
			 * Binds events common to mouse and touch to support virtual mouse.
			 * @method bindCommonEvents
			 * @static
			 * @member ns.event.vmouse
			 */
			vmouse.bindCommonEvents = function () {
				document.addEventListener("keyup", handleKeyUp, true);
				document.addEventListener("keydown", handleKeyDown, true);
				document.addEventListener("scroll", handleScroll, true);
				document.addEventListener("click", handleClick, true);
			};

			// @TODO delete touchSupport flag and attach touch and mouse listeners,
			// @TODO check if v-events are not duplicated if so then called only once

			/**
			 * Binds touch events to support virtual mouse.
			 * @method bindTouch
			 * @static
			 * @member ns.event.vmouse
			 */
			vmouse.bindTouch = function () {
				document.addEventListener("touchstart", handleTouchStart, true);
				document.addEventListener("touchend", handleTouchEnd, true);
				document.addEventListener("touchmove", handleTouchMove, true);
				document.addEventListener("touchcancel", handleTouchCancel, true);
			};

			/**
			 * Binds mouse events to support virtual mouse.
			 * @method bindMouse
			 * @static
			 * @member ns.event.vmouse
			 */
			vmouse.bindMouse = function () {
				document.addEventListener("mousedown", handleDown, true);
				document.addEventListener("mouseup", handleUp, true);
				document.addEventListener("mousemove", handleMove, true);
				document.addEventListener("mouseover", handleOver, true);
				document.addEventListener("mouseout", handleOut, true);
			};

			/**
			 * Unbinds touch events to support virtual mouse.
			 * @method unbindTouch
			 * @static
			 * @member ns.event.vmouse
			 */
			vmouse.unbindTouch = function () {
				document.removeEventListener("touchstart", handleTouchStart, true);
				document.removeEventListener("touchend", handleTouchEnd, true);
				document.removeEventListener("touchmove", handleTouchMove, true);

				document.removeEventListener("touchcancel", handleTouchCancel, true);

				document.removeEventListener("click", handleClick, true);
			};

			/**
			 * Unbinds mouse events to support virtual mouse.
			 * @method unbindMouse
			 * @static
			 * @member ns.event.vmouse
			 */
			vmouse.unbindMouse = function () {
				document.removeEventListener("mousedown", handleDown, true);

				document.removeEventListener("mouseup", handleUp, true);
				document.removeEventListener("mousemove", handleMove, true);
				document.removeEventListener("mouseover", handleOver, true);
				document.removeEventListener("mouseout", handleOut, true);

				document.removeEventListener("keyup", handleKeyUp, true);
				document.removeEventListener("keydown", handleKeyDown, true);
				document.removeEventListener("scroll", handleScroll, true);
				document.removeEventListener("click", handleClick, true);
			};

			ns.event.vmouse = vmouse;

			if (touchSupport) {
				vmouse.bindTouch();
			} else {
				vmouse.bindMouse();
			}
			vmouse.bindCommonEvents();

			}(window, window.document, ns));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Event orientationchange
 * Namespace to support orientationchange event
 * @class ns.event.orientationchange
 */
/**
 * Event orientationchange
 * @event orientationchange
 * @member ns.event.orientationchange
 */
(function (window, document, ns) {
	"use strict";
				var eventUtils = ns.event,
				eventType = ns.engine.eventType,
				orientationchange = {
					/**
					 * Window alias
					 * @property {Window} window
					 * @member ns.event.orientationchange
					 * @static
					 * @protected
					 */
					_window: window,
					/**
					 * Informs about support orientation change event.
					 * @property {boolean} supported
					 * @member ns.event.orientationchange
					 */
					supported: (window.orientation !== undefined) && (window.onorientationchange !== undefined),
					/**
					 * List of properties copied to event details object
					 * @property {Array} properties
					 * @member ns.event.orientationchange
					 * @static
					 */
					properties: ["orientation"],

					/**
					 * Chosen orientation
					 * @property {Window} [orientation=portrait]
					 * @member ns.event.orientationchange
					 * @protected
					 * @static
					 */
					_orientation: "portrait"
				},
				detectOrientationByDimensions = function (omitCustomEvent) {
					var win = orientationchange._window,
						width = win.innerWidth,
						height = win.innerHeight;

					if (win.screen) {
						width = win.screen.availWidth;
						height = win.screen.availHeight;
					}

					if (width > height) {
						orientationchange._orientation = "landscape";
					} else {
						orientationchange._orientation = "portrait";
					}

					if (!omitCustomEvent) {
						eventUtils.trigger(window, "orientationchange", {"orientation": orientationchange._orientation});
					}
				},
				checkReportedOrientation = function () {
					if (orientationchange._window.orientation) {
						switch (orientationchange._window.orientation) {
							case 90:
							case -90:
								orientationchange._orientation = "portrait";
								break;
							default:
								orientationchange._orientation = "landscape";
								break;
						}
					} else {
						detectOrientationByDimensions(true);
					}
				},
				matchMediaHandler = function (mediaQueryList, omitEvent) {
					if (mediaQueryList.matches) {
						orientationchange._orientation = "portrait";
					} else {
						orientationchange._orientation = "landscape";
					}

					if (!omitEvent) { // this was added explicit for testing
						eventUtils.trigger(window, "orientationchange", {"orientation": orientationchange._orientation});
					}
				},
				portraitMatchMediaQueryList = null;

			/**
			* Returns current orientation.
			* @method getOrientation
			* @return {"landscape"|"portrait"}
			* @member ns.event.orientationchange
			* @static
			*/
			orientationchange.getOrientation = function () {
				return orientationchange._orientation;
			};

			/**
			* Triggers event orientationchange on element
			* @method trigger
			* @param {HTMLElement} element
			* @member ns.event.orientationchange
			* @static
			*/
			orientationchange.trigger = function (element) {
				eventUtils.trigger(element, "orientationchange", {"orientation": orientationchange._orientation});
			};

			/**
			* Unbinds events
			* @member ns.event.orientationchange
			* @static
			*/
			orientationchange.unbind = function () {
				window.removeEventListener("orientationchange", checkReportedOrientation, false);
				document.removeEventListener("throttledresize", detectOrientationByDimensions, true);
				document.removeEventListener(eventType.DESTROY, orientationchange.unbind, false);
			};

			/**
			* Performs orientation detection
			* @member ns.event.orientationchange
			* @static
			*/
			orientationchange.detect = function () {
				if (orientationchange.supported) {
					window.addEventListener("orientationchange", checkReportedOrientation, false);
					checkReportedOrientation();
					// try media queries
				} else {
					if (orientationchange._window.matchMedia) {
						portraitMatchMediaQueryList = orientationchange._window.matchMedia("(orientation: portrait)");
						if (portraitMatchMediaQueryList.matches) {
							orientationchange._orientation = "portrait";
						} else {
							orientationchange._orientation = "landscape";
						}
						portraitMatchMediaQueryList.addListener(matchMediaHandler);
					} else {
						document.addEventListener("throttledresize", detectOrientationByDimensions, true);
						detectOrientationByDimensions();
					}
				}
			};

			document.addEventListener(eventType.DESTROY, orientationchange.unbind, false);

			orientationchange.detect();

			ns.event.orientationchange = orientationchange;

			}(window, window.document, ns));

/*global window, ns, define */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping events
 * Object maps events from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.event
 */
(function (window, document) {
	"use strict";
	
			var eventUtils = ns.event,
				$ = ns.jqm.jQuery,
				originalTrigger,
				originalDispatch,
				eventType = {
					CLICK: "click",
					SUBMIT: "submit",
					KEYUP: "keyup",
					TOUCHSTART: "touchstart",
					TOUCHEND: "touchend",
					VCLICK: "vclick",
					MOUSEDOWN: "mousedown",
					MOUSEUP: "mouseup",
					BEFOREROUTERINIT: "beforerouterinit",
					DESTROY: "taudestroy"
				},
				registerEventNames = ["touchstart", "touchmove", "touchend", "tap", "taphold", "swipeleft", "swiperight", "scrollstart", "scrollstop"],

				event = {
					/**
					 * Create method on jQuery object with name represent event.
					 * @method proxyEventTriggerMethod
					 * @param {string} name Name of event and new method
					 * @param {Function} trigger Function called after invoke method
					 * @member ns.jqm.event
					 * @static
					 */
					proxyEventTriggerMethod: function (name, trigger) {
						$.fn[name] = function () {
							var $elements = this,
								elementsLength = $elements.length,
								i;

							for (i = 0; i < elementsLength; i++) {
								trigger($elements.get(i));
							}
						};
					},

					/**
					 * Adds proxy to jquery.trigger method
					 * @method proxyTrigger
					 * @param {string} type event type
					 * @param {Mixed} data event data
					 * @return {jQuery}
					 * @member ns.jqm.event
					 */
					proxyTrigger: function (type, data) {
						var $elements = this,
							elementsLength = $elements.length,
							i;

						if (!eventType[type.toUpperCase()]) {
							originalTrigger.call($elements, type, data);
						}

						for (i = 0; i < elementsLength; i++) {
							eventUtils.trigger($elements.get(i), type);
						}

						return this;
					},

					/**
					 * Method read additional data from event.detail and move these data as additional argument to jQuery.event.dispatch
					 * @method proxyDispatch
					 * @param {jQuery.Event} event event type
					 * @return {jQuery}
					 * @member ns.jqm.event
					 */
					proxyDispatch: function (event) {
						var data = (event.originalEvent && event.originalEvent.detail) || event.detail,
							args;

						args = [].slice.call(arguments);
						if (data) {
							args.push(data);
						}
						return originalDispatch.apply(this, args);
					},

					/**
					 * Copy properties from originalEvent.detail.* to event Object.
					 * @method copyEventProperties
					 * @param {HTMLElement} root root element to catch all events window/document
					 * @param {string} name Name of event
					 * @param {Array.<string>} properties Array of properties to copy from originalEvent to jQuery Event
					 * @member ns.jqm.event
					 * @static
					 */
					copyEventProperties: function (root, name, properties) {
						$(root).on(name, function (event) {
							var i,
								property;

							for (i = 0; i < properties.length; i++) {
								property = properties[i];
								if (!event[property]) {
									if (root instanceof window.screen.constructor) {
										// In case of orientation change event the properties are set to window.screen object
										// that's why we check if root is Screen in the first place
										event[property] = event.originalEvent.detail &&
											event.originalEvent.detail[property] ||
											event.target[property];
									} else {
										event[property] = event.originalEvent.detail && event.originalEvent.detail[property];
									}
								}
							}
						});
					},

					/**
					 * Proxy events from ns namespace to jQM namespace
					 * @method init
					 * @member ns.jqm.event
					 * @static
					 */
					init: function () {
						var removeEvents = function (event) {
								event.stopPropagation();
								event.preventDefault();
								return false;
							},
							blockedEvents = [eventType.TOUCHSTART, eventType.TOUCHEND, eventType.VCLICK, eventType.MOUSEDOWN, eventType.MOUSEUP, eventType.CLICK],
							blockedEventsLength = blockedEvents.length,
							html = document.body.parentNode;

						if ($) {
							// setup new event shortcuts
							registerEventNames.forEach(function (name) {
								$.fn[name] = function (fn) {
									return fn ? this.bind(name, fn) : this.trigger(name);
								};
								// jQuery < 1.8
								if ($.attrFn) {
									$.attrFn[name] = true;
								}
							});

							event.copyEventProperties(window.screen, "orientationchange", eventUtils.orientationchange.properties);
							event.proxyEventTriggerMethod("orientationchange", eventUtils.orientationchange.trigger);

							// Proxies jQuery's trigger method to fire swipe event
							if (originalTrigger === undefined) {
								originalTrigger = $.fn.trigger;
								$.fn.trigger = event.proxyTrigger;
							}

							if (!originalDispatch) {
								originalDispatch = $.event.dispatch;
								$.event.dispatch = event.proxyDispatch;
							}

							$.mobile = $.mobile || {};
							$.mobile.tizen = $.mobile.tizen || {};
							$.mobile.tizen.documentRelativeCoordsFromEvent = null;
							$.mobile.tizen.targetRelativeCoordsFromEvent = null;
							$.mobile.addEventBlocker = function () {
								var i;

								html.classList.add("ui-blocker");
								for (i = 0; i < blockedEventsLength; i++) {
									html.addEventListener(blockedEvents[i], removeEvents, true);
								}
							};
							$.mobile.removeEventBlocker = function () {
								var i;

								html.classList.remove("ui-blocker");
								for (i = 0; i < blockedEventsLength; i++) {
									html.removeEventListener(blockedEvents[i], removeEvents, true);
								}
							};
							$.mobile.tizen.documentRelativeCoordsFromEvent = eventUtils.documentRelativeCoordsFromEvent.bind(eventUtils);
							$.mobile.tizen.targetRelativeCoordsFromEvent = eventUtils.targetRelativeCoordsFromEvent.bind(eventUtils);
						}
					},
					/**
					 * Removes events listeners on destroy of framework.
					 */
					destroy: function () {
						document.removeEventListener(eventType.BEFOREROUTERINIT, event.init, false);
						document.removeEventListener(eventType.DESTROY, event.destroy, false);
					}
				};

			// Listen when framework is ready
			document.addEventListener(eventType.BEFOREROUTERINIT, event.init, false);
			document.addEventListener(eventType.DESTROY, event.destroy, false);

			ns.jqm.event = event;
			}(window, window.document));

/*global window, ns, define, RegExp */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Path Utility
 * Object helps work with paths.
 * @class ns.util.path
 * @static
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 */
(function (window, document, ns) {
	"use strict";
				var utilsObject = ns.util.object,
				/**
				 * Local alias for ns.util.selectors
				 * @property {Object} utilsSelectors Alias for {@link ns.util.selectors}
				 * @member ns.util.path
				 * @static
				 * @private
				 */
				utilsSelectors = ns.util.selectors,
				/**
				 * Local alias for ns.util.DOM
				 * @property {Object} utilsDOM Alias for {@link ns.util.DOM}
				 * @member ns.util.path
				 * @static
				 * @private
				 */
				utilsDOM = ns.util.DOM,
				/**
				 * Cache for document base element
				 * @member ns.util.path
				 * @property {HTMLBaseElement} base
				 * @static
				 * @private
				 */
				base,
				/**
				 * location object
				 * @property {Object} location
				 * @static
				 * @private
				 * @member ns.util.path
				 */
				location = {},
				path = {
					/**
					 * href part for mark state
					 * @property {string} [uiStateKey="&ui-state"]
					 * @static
					 * @member ns.util.path
					 */
					uiStateKey: "&ui-state",

					// This scary looking regular expression parses an absolute URL or its relative
					// variants (protocol, site, document, query, and hash), into the various
					// components (protocol, host, path, query, fragment, etc that make up the
					// URL as well as some other commonly used sub-parts. When used with RegExp.exec()
					// or String.match, it parses the URL into a results array that looks like this:
					//
					//	[0]: http://jblas:password@mycompany.com:8080/mail/inbox?msg=1234&type=unread#
					//       msg-content?param1=true&param2=123
					//	[1]: http://jblas:password@mycompany.com:8080/mail/inbox?msg=1234&type=unread
					//	[2]: http://jblas:password@mycompany.com:8080/mail/inbox
					//	[3]: http://jblas:password@mycompany.com:8080
					//	[4]: http:
					//	[5]: //
					//	[6]: jblas:password@mycompany.com:8080
					//	[7]: jblas:password
					//	[8]: jblas
					//	[9]: password
					//	[10]: mycompany.com:8080
					//	[11]: mycompany.com
					//	[12]: 8080
					//	[13]: /mail/inbox
					//	[14]: /mail/
					//	[15]: inbox
					//	[16]: ?msg=1234&type=unread
					//	[17]: #msg-content?param1=true&param2=123
					//	[18]: #msg-content
					//	[19]: ?param1=true&param2=123
					//
					/**
					 * @property {RegExp} urlParseRE Regular expression for parse URL
					 * @member ns.util.path
					 * @static
					 */
					urlParseRE: /^(((([^:\/#\?]+:)?(?:(\/\/)((?:(([^:@\/#\?]+)(?:\:([^:@\/#\?]+))?)@)?(([^:\/#\?\]\[]+|\[[^\/\]@#?]+\])(?:\:([0-9]+))?))?)?)?((\/?(?:[^\/\?#]+\/+)*)([^\?#]*)))?(\?[^#]+)?)((#[^\?]*)(\?.*)?)?/,

					/**
					 * Abstraction to address xss (Issue #4787) by removing the authority in
					 * browsers that auto decode it. All references to location.href should be
					 * replaced with a call to this method so that it can be dealt with properly here
					 * @method getLocation
					 * @param {string|Object} [url]
					 * @return {string}
					 * @member ns.util.path
					 */
					getLocation: function (url) {
						var uri = this.parseUrl(url || window.location.href),
							hash = uri.hash,
							search = uri.hashSearch;
						// mimic the browser with an empty string when the hash and hashSearch are empty

						hash = hash === "#" && !search ? "" : hash;
						location = uri;
						// Make sure to parse the url or the location object for the hash because using
						// location.hash is automatically decoded in firefox, the rest of the url should be from the
						// object (location unless we're testing) to avoid the inclusion of the authority
						return uri.protocol + "//" + uri.host + uri.pathname + uri.search + hash + search;
					},

					/**
					 * Return the original document url
					 * @method getDocumentUrl
					 * @member ns.util.path
					 * @param {boolean} [asParsedObject=false]
					 * @return {string|Object}
					 * @static
					 */
					getDocumentUrl: function (asParsedObject) {
						return asParsedObject ? utilsObject.copy(path.documentUrl) : path.documentUrl.href;
					},

					/**
					 * Parse a location into a structure
					 * @method parseLocation
					 * @return {Object}
					 * @member ns.util.path
					 */
					parseLocation: function () {
						return this.parseUrl(this.getLocation());
					},

					/**
					 * Parse a URL into a structure that allows easy access to
					 * all of the URL components by name.
					 * If we're passed an object, we'll assume that it is
					 * a parsed url object and just return it back to the caller.
					 * @method parseUrl
					 * @member ns.util.path
					 * @param {string|Object} url
					 * @return {Object} uri record
					 * @return {string} return.href
					 * @return {string} return.hrefNoHash
					 * @return {string} return.hrefNoSearch
					 * @return {string} return.domain
					 * @return {string} return.protocol
					 * @return {string} return.doubleSlash
					 * @return {string} return.authority
					 * @return {string} return.username
					 * @return {string} return.password
					 * @return {string} return.host
					 * @return {string} return.hostname
					 * @return {string} return.port
					 * @return {string} return.pathname
					 * @return {string} return.directory
					 * @return {string} return.filename
					 * @return {string} return.search
					 * @return {string} return.hash
					 * @return {string} return.hashSearch
					 * @static
					 */
					parseUrl: function (url) {
						var matches;

						if (typeof url === "object") {
							return url;
						}
						matches = path.urlParseRE.exec(url || "") || [];

						// Create an object that allows the caller to access the sub-matches
						// by name. Note that IE returns an empty string instead of undefined,
						// like all other browsers do, so we normalize everything so its consistent
						// no matter what browser we're running on.
						return {
							href: matches[0] || "",
							hrefNoHash: matches[1] || "",
							hrefNoSearch: matches[2] || "",
							domain: matches[3] || "",
							protocol: matches[4] || "",
							doubleSlash: matches[5] || "",
							authority: matches[6] || "",
							username: matches[8] || "",
							password: matches[9] || "",
							host: matches[10] || "",
							hostname: matches[11] || "",
							port: matches[12] || "",
							pathname: matches[13] || "",
							directory: matches[14] || "",
							filename: matches[15] || "",
							search: matches[16] || "",
							hash: matches[18] || "",
							hashSearch: matches[19] || ""
						};
					},

					/**
					 * Turn relPath into an absolute path. absPath is
					 * an optional absolute path which describes what
					 * relPath is relative to.
					 * @method makePathAbsolute
					 * @member ns.util.path
					 * @param {string} relPath
					 * @param {string} [absPath=""]
					 * @return {string}
					 * @static
					 */
					makePathAbsolute: function (relPath, absPath) {
						var absStack,
							relStack,
							directory,
							i;

						if (relPath && relPath.charAt(0) === "/") {
							return relPath;
						}

						relPath = relPath || "";
						absPath = absPath ? absPath.replace(/^\/|(\/[^\/]*|[^\/]+)$/g, "") : "";

						absStack = absPath ? absPath.split("/") : [];
						relStack = relPath.split("/");
						for (i = 0; i < relStack.length; i++) {
							directory = relStack[i];
							switch (directory) {
								case ".":
									break;
								case "..":
									if (absStack.length) {
										absStack.pop();
									}
									break;
								default:
									absStack.push(directory);
									break;
							}
						}
						return "/" + absStack.join("/");
					},

					/**
					 * Returns true if both urls have the same domain.
					 * @method isSameDomain
					 * @member ns.util.path
					 * @param {string|Object} absUrl1
					 * @param {string|Object} absUrl2
					 * @return {boolean}
					 * @static
					 */
					isSameDomain: function (absUrl1, absUrl2) {
						return path.parseUrl(absUrl1).domain === path.parseUrl(absUrl2).domain;
					},

					/**
					 * Returns true for any relative variant.
					 * @method isRelativeUrl
					 * @member ns.util.path
					 * @param {string|Object} url
					 * @return {boolean}
					 * @static
					 */
					isRelativeUrl: function (url) {
						// All relative Url variants have one thing in common, no protocol.
						return path.parseUrl(url).protocol === "";
					},

					/**
					 * Returns true for an absolute url.
					 * @method isAbsoluteUrl
					 * @member ns.util.path
					 * @param {string} url
					 * @return {boolean}
					 * @static
					 */
					isAbsoluteUrl: function (url) {
						return path.parseUrl(url).protocol !== "";
					},

					/**
					 * Turn the specified relative URL into an absolute one. This function
					 * can handle all relative variants (protocol, site, document, query, fragment).
					 * @method makeUrlAbsolute
					 * @member ns.util.path
					 * @param {string} relUrl
					 * @param {string} absUrl
					 * @return {string}
					 * @static
					 */
					makeUrlAbsolute: function (relUrl, absUrl) {
						var relObj,
							absObj,
							protocol,
							doubleSlash,
							authority,
							hasPath,
							pathname,
							search,
							hash;

						if (!path.isRelativeUrl(relUrl)) {
							return relUrl;
						}

						relObj = path.parseUrl(relUrl);
						absObj = path.parseUrl(absUrl);
						protocol = relObj.protocol || absObj.protocol;
						doubleSlash = relObj.protocol ? relObj.doubleSlash : (relObj.doubleSlash || absObj.doubleSlash);
						authority = relObj.authority || absObj.authority;
						hasPath = relObj.pathname !== "";
						pathname = path.makePathAbsolute(relObj.pathname || absObj.filename, absObj.pathname);
						search = relObj.search || (!hasPath && absObj.search) || "";
						hash = relObj.hash;

						return protocol + doubleSlash + authority + pathname + search + hash;
					},

					/**
					 * Add search (aka query) params to the specified url.
					 * If page is embedded page, search query will be added after
					 * hash tag. It's allowed to add query content for both external
					 * pages and embedded pages.
					 * Examples:
					 * http://domain/path/index.html#embedded?search=test
					 * http://domain/path/external.html?s=query#embedded?s=test
					 * @method addSearchParams
					 * @member ns.util.path
					 * @param {string|Object} url
					 * @param {Object|string} params
					 * @return {string}
					 */
					addSearchParams: function (url, params) {
						var urlObject = path.parseUrl(url),
							paramsString = (typeof params === "object") ? this.getAsURIParameters(params) : params,
							searchChar,
							urlObjectHash = urlObject.hash;

						if (path.isEmbedded(url) && paramsString.length > 0) {
							searchChar = urlObject.hashSearch || "?";
							return urlObject.hrefNoHash + (urlObjectHash || "") + searchChar + (searchChar.charAt(searchChar.length - 1) === "?" ? "" : "&") + paramsString;
						}

						searchChar = urlObject.search || "?";
						return urlObject.hrefNoSearch + searchChar + (searchChar.charAt(searchChar.length - 1) === "?" ? "" : "&") + paramsString + (urlObjectHash || "");
					},

					/**
					 * Add search params to the specified url with hash
					 * @method addHashSearchParams
					 * @member ns.util.path
					 * @param {string|Object} url
					 * @param {Object|string} params
					 * @return {string}
					 */
					addHashSearchParams: function (url, params) {
						var urlObject = path.parseUrl(url),
							paramsString = (typeof params === "object") ? path.getAsURIParameters(params) : params,
							hash = urlObject.hash,
							searchChar = hash ? (hash.indexOf("?") < 0 ? hash + "?" : hash + "&") : "#?";

						return urlObject.hrefNoHash + searchChar + (searchChar.charAt(searchChar.length - 1) === "?" ? "" : "&") + paramsString;
					},

					/**
					 * Convert absolute Url to data Url
					 * - for embedded pages strips parameters
					 * - for the same domain as document base remove domain
					 * otherwise returns decoded absolute Url
					 * @method convertUrlToDataUrl
					 * @member ns.util.path
					 * @param {string} absUrl
					 * @param {boolean} dialogHashKey
					 * @param {Object} documentBase uri structure
					 * @return {string}
					 * @static
					 */
					convertUrlToDataUrl: function (absUrl, dialogHashKey, documentBase) {
						var urlObject = path.parseUrl(absUrl);

						if (path.isEmbeddedPage(urlObject, !!dialogHashKey)) {
							// Keep hash and search data for embedded page
							return path.getFilePath(urlObject.hash + urlObject.hashSearch, dialogHashKey);
						}
						documentBase = documentBase || path.documentBase;
						if (path.isSameDomain(urlObject, documentBase)) {
							return urlObject.hrefNoHash.replace(documentBase.domain, "");
						}

						return window.decodeURIComponent(absUrl);
					},

					/**
					 * Get path from current hash, or from a file path
					 * @method get
					 * @member ns.util.path
					 * @param {string} newPath
					 * @return {string}
					 */
					get: function (newPath) {
						if (newPath === undefined) {
							newPath = this.parseLocation().hash;
						}
						return this.stripHash(newPath).replace(/[^\/]*\.[^\/*]+$/, "");
					},

					/**
					 * Test if a given url (string) is a path
					 * NOTE might be exceptionally naive
					 * @method isPath
					 * @member ns.util.path
					 * @param {string} url
					 * @return {boolean}
					 * @static
					 */
					isPath: function (url) {
						return (/\//).test(url);
					},

					/**
					 * Return a url path with the window's location protocol/hostname/pathname removed
					 * @method clean
					 * @member ns.util.path
					 * @param {string} url
					 * @param {Object} documentBase  uri structure
					 * @return {string}
					 * @static
					 */
					clean: function (url, documentBase) {
						return url.replace(documentBase.domain, "");
					},

					/**
					 * Just return the url without an initial #
					 * @method stripHash
					 * @member ns.util.path
					 * @param {string} url
					 * @return {string}
					 * @static
					 */
					stripHash: function (url) {
						return url.replace(/^#/, "");
					},

					/**
					 * Return the url without an query params
					 * @method stripQueryParams
					 * @member ns.util.path
					 * @param {string} url
					 * @return {string}
					 * @static
					 */
					stripQueryParams: function (url) {
						return url.replace(/\?.*$/, "");
					},

					/**
					 * Validation proper hash
					 * @method isHashValid
					 * @member ns.util.path
					 * @param {string} hash
					 * @static
					 */
					isHashValid: function (hash) {
						return (/^#[^#]+$/).test(hash);
					},

					/**
					 * Check whether a url is referencing the same domain, or an external domain or different
					 * protocol could be mailto, etc
					 * @method isExternal
					 * @member ns.util.path
					 * @param {string|Object} url
					 * @param {Object} documentUrl uri object
					 * @return {boolean}
					 * @static
					 */
					isExternal: function (url, documentUrl) {
						var urlObject = path.parseUrl(url);

						return urlObject.protocol && urlObject.domain !== documentUrl.domain ? true : false;
					},

					/**
					 * Check if the url has protocol
					 * @method hasProtocol
					 * @member ns.util.path
					 * @param {string} url
					 * @return {boolean}
					 * @static
					 */
					hasProtocol: function (url) {
						return (/^(:?\w+:)/).test(url);
					},

					/**
					 * Check if the url refers to embedded content
					 * @method isEmbedded
					 * @member ns.util.path
					 * @param {string} url
					 * @return {boolean}
					 * @static
					 */
					isEmbedded: function (url) {
						var urlObject = path.parseUrl(url);

						if (urlObject.protocol !== "") {
							return (!path.isPath(urlObject.hash) && !!urlObject.hash && (urlObject.hrefNoHash === path.parseLocation().hrefNoHash));
						}
						return (/\?.*#|^#/).test(urlObject.href);
					},

					/**
					 * Get the url as it would look squashed on to the current resolution url
					 * @method squash
					 * @member ns.util.path
					 * @param {string} url
					 * @param {string} [resolutionUrl=undefined]
					 * @return {string}
					 */
					squash: function (url, resolutionUrl) {
						var href,
							cleanedUrl,
							search,
							stateIndex,
							isPath = this.isPath(url),
							uri = this.parseUrl(url),
							preservedHash = uri.hash,
							uiState = "";

						// produce a url against which we can resole the provided path
						resolutionUrl = resolutionUrl || (path.isPath(url) ? path.getLocation() : path.getDocumentUrl());

						// If the url is anything but a simple string, remove any preceding hash
						// eg #foo/bar -> foo/bar
						//	#foo -> #foo
						cleanedUrl = isPath ? path.stripHash(url) : url;

						// If the url is a full url with a hash check if the parsed hash is a path
						// if it is, strip the #, and use it otherwise continue without change
						cleanedUrl = path.isPath(uri.hash) ? path.stripHash(uri.hash) : cleanedUrl;

						// Split the UI State keys off the href
						stateIndex = cleanedUrl.indexOf(this.uiStateKey);

						// store the ui state keys for use
						if (stateIndex > -1) {
							uiState = cleanedUrl.slice(stateIndex);
							cleanedUrl = cleanedUrl.slice(0, stateIndex);
						}

						// make the cleanedUrl absolute relative to the resolution url
						href = path.makeUrlAbsolute(cleanedUrl, resolutionUrl);

						// grab the search from the resolved url since parsing from
						// the passed url may not yield the correct result
						search = this.parseUrl(href).search;

						// @TODO all this crap is terrible, clean it up
						if (isPath) {
							// reject the hash if it's a path or it's just a dialog key
							if (path.isPath(preservedHash) || preservedHash.replace("#", "").indexOf(this.uiStateKey) === 0) {
								preservedHash = "";
							}

							// Append the UI State keys where it exists and it's been removed
							// from the url
							if (uiState && preservedHash.indexOf(this.uiStateKey) === -1) {
								preservedHash += uiState;
							}

							// make sure that pound is on the front of the hash
							if (preservedHash.indexOf("#") === -1 && preservedHash !== "") {
								preservedHash = "#" + preservedHash;
							}

							// reconstruct each of the pieces with the new search string and hash
							href = path.parseUrl(href);
							href = href.protocol + "//" + href.host + href.pathname + search + preservedHash;
						} else {
							href += href.indexOf("#") > -1 ? uiState : "#" + uiState;
						}

						return href;
					},

					/**
					 * Check if the hash is preservable
					 * @method isPreservableHash
					 * @member ns.util.path
					 * @param {string} hash
					 * @return {boolean}
					 */
					isPreservableHash: function (hash) {
						return hash.replace("#", "").indexOf(this.uiStateKey) === 0;
					},

					/**
					 * Escape weird characters in the hash if it is to be used as a selector
					 * @method hashToSelector
					 * @member ns.util.path
					 * @param {string} hash
					 * @return {string}
					 * @static
					 */
					hashToSelector: function (hash) {
						var hasHash = (hash.substring(0, 1) === "#");

						if (hasHash) {
							hash = hash.substring(1);
						}
						return (hasHash ? "#" : "") + hash.replace(new RegExp("([!\"#$%&'()*+,./:;<=>?@[\\]^`{|}~])", "g"), "\\$1");
					},

					/**
					 * Check if the specified url refers to the first page in the main application document.
					 * @method isFirstPageUrl
					 * @member ns.util.path
					 * @param {string} url
					 * @param {HTMLElement} firstPageElement first page element
					 * @param {string} documentBase uri structure
					 * @param {boolean} documentBaseDiffers
					 * @param {Object} documentUrl uri structure
					 * @return {boolean}
					 * @static
					 */
					isFirstPageUrl: function (url, firstPageElement, documentBase, documentBaseDiffers, documentUrl) {
						var urlStructure,
							samePath,
							firstPageId,
							hash;

						documentBase = documentBase === undefined ? path.documentBase : documentBase;
						documentBaseDiffers = documentBaseDiffers === undefined ? path.documentBaseDiffers : documentBaseDiffers;
						documentUrl = documentUrl === undefined ? path.documentUrl : documentUrl;

						// We only deal with absolute paths.
						urlStructure = path.parseUrl(path.makeUrlAbsolute(url, documentBase));

						// Does the url have the same path as the document?
						samePath = urlStructure.hrefNoHash === documentUrl.hrefNoHash || (documentBaseDiffers && urlStructure.hrefNoHash === documentBase.hrefNoHash);

						// Get the id of the first page element if it has one.
						firstPageId = firstPageElement && firstPageElement.id || false;
						hash = urlStructure.hash;

						// The url refers to the first page if the path matches the document and
						// it either has no hash value, or the hash is exactly equal to the id of the
						// first page element.
						return samePath && (!hash || hash === "#" || (firstPageId && hash.replace(/^#/, "") === firstPageId));
					},

					/**
					 * Some embedded browsers, like the web view in Phone Gap, allow cross-domain XHR
					 * requests if the document doing the request was loaded via the file:// protocol.
					 * This is usually to allow the application to "phone home" and fetch app specific
					 * data. We normally let the browser handle external/cross-domain urls, but if the
					 * allowCrossDomainPages option is true, we will allow cross-domain http/https
					 * requests to go through our page loading logic.
					 * @method isPermittedCrossDomainRequest
					 * @member ns.util.path
					 * @param {Object} docUrl
					 * @param {string} reqUrl
					 * @return {boolean}
					 * @static
					 */
					isPermittedCrossDomainRequest: function (docUrl, reqUrl) {
						return ns.getConfig("allowCrossDomainPages", false) &&
							docUrl.protocol === "file:" &&
							reqUrl.search(/^https?:/) !== -1;
					},

					/**
					 * Convert a object data to URI parameters
					 * @method getAsURIParameters
					 * @member ns.util.path
					 * @param {Object} data
					 * @return {string}
					 * @static
					 */
					getAsURIParameters: function (data) {
						var url = "",
							key;

						for (key in data) {
							if (data.hasOwnProperty(key)) {
								url += encodeURIComponent(key) + "=" + encodeURIComponent(data[key]) + "&";
							}
						}
						return url.substring(0, url.length - 1);
					},

					/**
					 * Document Url
					 * @member ns.util.path
					 * @property {string|null} documentUrl
					 */
					documentUrl: null,

					/**
					 * The document base differs
					 * @member ns.util.path
					 * @property {boolean} documentBaseDiffers
					 */
					documentBaseDiffers: false,

					/**
					 * Set location hash to path
					 * @method set
					 * @member ns.util.path
					 * @param {string} path
					 * @static
					 */
					set: function (path) {
						location.hash = path;
					},

					/**
					 * Return the substring of a file path before the sub-page key,
					 * for making a server request
					 * @method getFilePath
					 * @member ns.util.path
					 * @param {string} path
					 * @param {string} dialogHashKey
					 * @return {string}
					 * @static
					 */
					getFilePath: function (path, dialogHashKey) {
						var splitKey = "&" + ns.getConfig("subPageUrlKey", "");

						return path && path.split(splitKey)[0].split(dialogHashKey)[0];
					},

					/**
					 * Remove the preceding hash, any query params, and dialog notations
					 * @method cleanHash
					 * @member ns.util.path
					 * @param {string} hash
					 * @param {string} dialogHashKey
					 * @return {string}
					 * @static
					 */
					cleanHash: function (hash, dialogHashKey) {
						return path.stripHash(hash.replace(/\?.*$/, "").replace(dialogHashKey, ""));
					},

					/**
					 * Check if url refers to the embedded page
					 * @method isEmbeddedPage
					 * @member ns.util.path
					 * @param {string} url
					 * @param {boolean} allowEmbeddedOnlyBaseDoc
					 * @return {boolean}
					 * @static
					 */
					isEmbeddedPage: function (url, allowEmbeddedOnlyBaseDoc) {
						var urlObject = path.parseUrl(url);

						//if the path is absolute, then we need to compare the url against
						//both the documentUrl and the documentBase. The main reason for this
						//is that links embedded within external documents will refer to the
						//application document, whereas links embedded within the application
						//document will be resolved against the document base.
						if (urlObject.protocol !== "") {
							return (urlObject.hash &&
							(allowEmbeddedOnlyBaseDoc ?
								urlObject.hrefNoHash === path.documentUrl.hrefNoHash :
								urlObject.hrefNoHash === path.parseLocation().hrefNoHash));
						}
						return (/^#/).test(urlObject.href);
					}
				};

			path.documentUrl = path.parseLocation();

			base = document.querySelector("base");

			/**
			 * The document base URL for the purposes of resolving relative URLs,
			 * and the name of the default browsing context for the purposes of
			 * following hyperlinks
			 * @member ns.util.path
			 * @property {Object} documentBase uri structure
			 * @static
			 */
			path.documentBase = base ? path.parseUrl(path.makeUrlAbsolute(base.getAttribute("href"),
				path.documentUrl.href)) : path.documentUrl;

			path.documentBaseDiffers = (path.documentUrl.hrefNoHash !== path.documentBase.hrefNoHash);

			/**
			 * Get document base
			 * @method getDocumentBase
			 * @member ns.util.path
			 * @param {boolean} [asParsedObject=false]
			 * @return {string|Object}
			 * @static
			 */
			path.getDocumentBase = function (asParsedObject) {
				return asParsedObject ? utilsObject.copy(path.documentBase) : path.documentBase.href;
			};

			/**
			 * Find the closest page and extract out its url
			 * @method getClosestBaseUrl
			 * @member ns.util.path
			 * @param {HTMLElement} element
			 * @param {string} selector
			 * @return {string}
			 * @static
			 */
			path.getClosestBaseUrl = function (element, selector) {
				// Find the closest page and extract out its url.
				var url = utilsDOM.getNSData(utilsSelectors.getClosestBySelector(element, selector), "url"),
					baseUrl = path.documentBase.hrefNoHash;

				if (!ns.getConfig("dynamicBaseEnabled", true) || !url || !path.isPath(url)) {
					url = baseUrl;
				}

				return path.makeUrlAbsolute(url, baseUrl);
			};

			ns.util.path = path;
			}(window, window.document, ns));

/**
 *
 */
(function (window) {
	"use strict";
				var isarray = Array.isArray;

			pathToRegexp.parse = parse
			pathToRegexp.compile = compile
			pathToRegexp.tokensToFunction = tokensToFunction
			pathToRegexp.tokensToRegExp = tokensToRegExp

/**
 * Start original file
 * Licence MIT
 * https://github.com/pillarjs/path-to-regexp
 */
/**
 * The main path matching regexp utility.
 *
 * @type {RegExp}
 */
var PATH_REGEXP = new RegExp([
	// Match escaped characters that would otherwise appear in future matches.
	// This allows the user to escape special characters that won't transform.
	'(\\\\.)',
	// Match Express-style parameters and un-named parameters with a prefix
	// and optional suffixes. Matches appear as:
	//
	// "/:test(\\d+)?" => ["/", "test", "\d+", undefined, "?"]
	// "/route(\\d+)" => [undefined, undefined, undefined, "\d+", undefined]
	'([\\/.])?(?:\\:(\\w+)(?:\\(((?:\\\\.|[^)])*)\\))?|\\(((?:\\\\.|[^)])*)\\))([+*?])?'
].join('|'), 'g')

/**
 * Parse a string for the raw tokens.
 *
 * @param  {String} str
 * @return {Array}
 */
function parse (str) {
	var tokens = []
	var key = 0
	var index = 0
	var path = ''
	var res

	while ((res = PATH_REGEXP.exec(str)) != null) {
		var m = res[0]
		var escaped = res[1]
		var offset = res.index
		path += str.slice(index, offset)
		index = offset + m.length

		// Ignore already escaped sequences.
		if (escaped) {
			path += escaped[1]
			continue
		}

		// Push the current path onto the tokens.
		if (path) {
			tokens.push(path)
			path = ''
		}

		var prefix = res[2]
		var name = res[3]
		var capture = res[4]
		var group = res[5]
		var suffix = res[6]

		var repeat = suffix === '+' || suffix === '*'
		var optional = suffix === '?' || suffix === '*'
		var delimiter = prefix || '/'

		tokens.push({
			name: name || key++,
			prefix: prefix || '',
			delimiter: delimiter,
			optional: optional,
			repeat: repeat,
			pattern: escapeGroup(capture || group || '[^' + delimiter + ']+?')
		})
	}

	// Match any characters still remaining.
	if (index < str.length) {
		path += str.substr(index)
	}

	// If the path exists, push it onto the end.
	if (path) {
		tokens.push(path)
	}

	return tokens
}

/**
 * Compile a string to a template function for the path.
 *
 * @param  {String}   str
 * @return {Function}
 */
function compile (str) {
	return tokensToFunction(parse(str))
}

/**
 * Expose a method for transforming tokens into the path function.
 */
function tokensToFunction (tokens) {
	// Compile all the tokens into regexps.
	var matches = new Array(tokens.length)

	// Compile all the patterns before compilation.
	for (var i = 0; i < tokens.length; i++) {
		if (typeof tokens[i] === 'object') {
			matches[i] = new RegExp('^' + tokens[i].pattern + '$')
		}
	}

	return function (obj) {
		var path = ''

		obj = obj || {}

		for (var i = 0; i < tokens.length; i++) {
			var key = tokens[i]

			if (typeof key === 'string') {
				path += key

				continue
			}

			var value = obj[key.name]

			if (value == null) {
				if (key.optional) {
					continue
				} else {
					throw new TypeError('Expected "' + key.name + '" to be defined')
				}
			}

			if (isarray(value)) {
				if (!key.repeat) {
					throw new TypeError('Expected "' + key.name + '" to not repeat')
				}

				if (value.length === 0) {
					if (key.optional) {
						continue
					} else {
						throw new TypeError('Expected "' + key.name + '" to not be empty')
					}
				}

				for (var j = 0; j < value.length; j++) {
					if (!matches[i].test(value[j])) {
						throw new TypeError('Expected all "' + key.name + '" to match "' + key.pattern + '"')
					}

					path += (j === 0 ? key.prefix : key.delimiter) + encodeURIComponent(value[j])
				}

				continue
			}

			if (!matches[i].test(value)) {
				throw new TypeError('Expected "' + key.name + '" to match "' + key.pattern + '"')
			}

			path += key.prefix + encodeURIComponent(value)
		}

		return path
	}
}

/**
 * Escape a regular expression string.
 *
 * @param  {String} str
 * @return {String}
 */
function escapeString (str) {
	return str.replace(/([.+*?=^!:${}()[\]|\/])/g, '\\$1')
}

/**
 * Escape the capturing group by escaping special characters and meaning.
 *
 * @param  {String} group
 * @return {String}
 */
function escapeGroup (group) {
	return group.replace(/([=!:$\/()])/g, '\\$1')
}

/**
 * Attach the keys as a property of the regexp.
 *
 * @param  {RegExp} re
 * @param  {Array}  keys
 * @return {RegExp}
 */
function attachKeys (re, keys) {
	re.keys = keys
	return re
}

/**
 * Get the flags for a regexp from the options.
 *
 * @param  {Object} options
 * @return {String}
 */
function flags (options) {
	return options.sensitive ? '' : 'i'
}

/**
 * Pull out keys from a regexp.
 *
 * @param  {RegExp} path
 * @param  {Array}  keys
 * @return {RegExp}
 */
function regexpToRegexp (path, keys) {
	// Use a negative lookahead to match only capturing groups.
	var groups = path.source.match(/\((?!\?)/g)

	if (groups) {
		for (var i = 0; i < groups.length; i++) {
			keys.push({
				name: i,
				prefix: null,
				delimiter: null,
				optional: false,
				repeat: false,
				pattern: null
			})
		}
	}

	return attachKeys(path, keys)
}

/**
 * Transform an array into a regexp.
 *
 * @param  {Array}  path
 * @param  {Array}  keys
 * @param  {Object} options
 * @return {RegExp}
 */
function arrayToRegexp (path, keys, options) {
	var parts = []

	for (var i = 0; i < path.length; i++) {
		parts.push(pathToRegexp(path[i], keys, options).source)
	}

	var regexp = new RegExp('(?:' + parts.join('|') + ')', flags(options))

	return attachKeys(regexp, keys)
}

/**
 * Create a path regexp from string input.
 *
 * @param  {String} path
 * @param  {Array}  keys
 * @param  {Object} options
 * @return {RegExp}
 */
function stringToRegexp (path, keys, options) {
	var tokens = parse(path)
	var re = tokensToRegExp(tokens, options)

	// Attach keys back to the regexp.
	for (var i = 0; i < tokens.length; i++) {
		if (typeof tokens[i] !== 'string') {
			keys.push(tokens[i])
		}
	}

	return attachKeys(re, keys)
}

/**
 * Expose a function for taking tokens and returning a RegExp.
 *
 * @param  {Array}  tokens
 * @param  {Array}  keys
 * @param  {Object} options
 * @return {RegExp}
 */
function tokensToRegExp (tokens, options) {
	options = options || {}

	var strict = options.strict
	var end = options.end !== false
	var route = ''
	var lastToken = tokens[tokens.length - 1]
	var endsWithSlash = typeof lastToken === 'string' && /\/$/.test(lastToken)

	// Iterate over the tokens and create our regexp string.
	for (var i = 0; i < tokens.length; i++) {
		var token = tokens[i]

		if (typeof token === 'string') {
			route += escapeString(token)
		} else {
			var prefix = escapeString(token.prefix)
			var capture = token.pattern

			if (token.repeat) {
				capture += '(?:' + prefix + capture + ')*'
			}

			if (token.optional) {
				if (prefix) {
					capture = '(?:' + prefix + '(' + capture + '))?'
				} else {
					capture = '(' + capture + ')?'
				}
			} else {
				capture = prefix + '(' + capture + ')'
			}

			route += capture
		}
	}

	// In non-strict mode we allow a slash at the end of match. If the path to
	// match already ends with a slash, we remove it for consistency. The slash
	// is valid at the end of a path match, not in the middle. This is important
	// in non-ending mode, where "/test/" shouldn't match "/test//route".
	if (!strict) {
		route = (endsWithSlash ? route.slice(0, -2) : route) + '(?:\\/(?=$))?'
	}

	if (end) {
		route += '$'
	} else {
		// In non-ending mode, we need the capturing groups to match as much as
		// possible by using a positive lookahead to the end or next path segment.
		route += strict && endsWithSlash ? '' : '(?=\\/|$)'
	}

	return new RegExp('^' + route, flags(options))
}

/**
 * Normalize the given path string, returning a regular expression.
 *
 * An empty array can be passed in for the keys, which will hold the
 * placeholder key descriptions. For example, using `/user/:id`, `keys` will
 * contain `[{ name: 'id', delimiter: '/', optional: false, repeat: false }]`.
 *
 * @param  {(String|RegExp|Array)} path
 * @param  {Array}                 [keys]
 * @param  {Object}                [
 *
 * options]
 * @return {RegExp}
 */
function pathToRegexp (path, keys, options) {
	keys = keys || []

	if (!isarray(keys)) {
		options = keys
		keys = []
	} else if (!options) {
		options = {}
	}

	if (path instanceof RegExp) {
		return regexpToRegexp(path, keys, options)
	}

	if (isarray(path)) {
		return arrayToRegexp(path, keys, options)
	}

	return stringToRegexp(path, keys, options)
}

/**
 * End original file
 */
			window.pathToRegexp = pathToRegexp;
			}(window));
/*global define, ns */
/*
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Path to Regexp Utility
 * Convert string to regexp and can match path string to one defined regex path
 *
 * Syntax of paths is the same as in Express for nodejs
 *
 * Library based on https://github.com/pillarjs/path-to-regexp
 * @class ns.util.pathToRegexp
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 *
 */
(function (window) {
	"use strict";
	
			ns.util.pathToRegexp = window.pathToRegexp;

			}(window));

/*global define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Router
 * Namespace for routers
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @class ns.router
 */
(function () {
	"use strict";
				ns.router = ns.router || {};
			}());

/*global define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Route Namespace
 * Object contains rules for router.
 *
 * @class ns.router.route
 */
/*
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 */
(function () {
	"use strict";
				ns.router.route = ns.router.route || {};
			}());

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
/**
 * #History
 * Object controls history changes.
 *
 * @class ns.history
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 */
(function (window) {
	"use strict";
				var historyVolatileMode,
				object = ns.util.object,
				historyUid = 0,
				historyActiveIndex = 0,
				windowHistory = window.history,
				history = {
					/**
					 * Property contains active state in history.
					 * @property {Object} activeState
					 * @static
					 * @member ns.history
					 */
					activeState: null,

					/**
					 * Property contains starting url for tau instance
					 * @property {Object} startURL
					 * @static
					 * @member ns.history
					 */
					startURL: null,

					/**
					 * This method replaces or pushes state to history.
					 * @method replace
					 * @param {Object} state The state object
					 * @param {string} stateTitle The title of state
					 * @param {string} url The new history entry's URL
					 * @static
					 * @member ns.history
					 */
					replace: function (state, stateTitle, url) {
						var newState = object.merge({}, state, {
							uid: historyVolatileMode ? historyActiveIndex : ++historyUid,
							stateUrl: url,
							stateTitle: stateTitle
						});

						if (!this.startURL && url && url.length) {
							this.startURL = url;
						}
						windowHistory[historyVolatileMode ? "replaceState" : "pushState"](newState, stateTitle, url);
						history.setActive(newState);
					},

					/**
					 * This method moves backward through history.
					 * @method back
					 * @static
					 * @member ns.history
					 */
					back: function () {

						var event;

						// If we are out of the start page go back to previous page
						// otherwise handle page internal history e.g. for panel
						//
						// TODO: handle widget history when on page different than start page
						//
						if (this.startURL !== window.location.href) {
							windowHistory.back();
						} else {
							event = new CustomEvent("tauback", {
								"bubbles": true,
								"cancelable": true
							});

							document.body.dispatchEvent(event);
						}
					},

					/**
					 * This method sets active state.
					 * @method setActive
					 * @param {Object} state Activated state
					 * @static
					 * @member ns.history
					 */
					setActive: function (state) {
						if (state) {
							history.activeState = state;
							historyActiveIndex = state.uid;

							if (state.volatileRecord) {
								history.enableVolatileMode();
								return;
							}
						}

						history.disableVolatileMode();
					},

					/**
					 * This method returns "back" if state is in history or "forward" if it is new state.
					 * @method getDirection
					 * @param {Object} state Checked state
					 * @return {"back"|"forward"}
					 * @static
					 * @member ns.history
					 */
					getDirection: function (state) {
						if (state) {
							return state.uid <= historyActiveIndex ? "back" : "forward";
						}
						return "back";
					},

					/**
					 * This method sets volatile mode to true.
					 * @method enableVolatileMode
					 * @static
					 * @member ns.history
					 */
					enableVolatileMode: function () {
						historyVolatileMode = true;
					},

					/**
					 * This method sets volatile mode to false.
					 * @method disableVolatileMode
					 * @static
					 * @member ns.history
					 */
					disableVolatileMode: function () {
						historyVolatileMode = false;
					}
				};

			ns.history = history;
			}(window));

/*global window, define, ns */
/*jslint browser: true, nomen: true */
/**
 * # History manager
 *
 * Control events connected with history change and trigger events to controller
 * or router.
 *
 * @class ns.history.manager
 * @since 2.4
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 */
/**
 * Event historystatechange
 * @event historystatechange
 * @class ns.history.manager
 */
/**
 * Event historyhashchange
 * @event historyhashchange
 * @class ns.history.manager
 */
/**
 * Event historyenabled
 * @event historyenabled
 * @class ns.history.manager
 */
/**
 * Event historydisabled
 * @event historydisabled
 * @class ns.history.manager
 */
(function (window, document) {
	"use strict";
				var manager = Object.create(null), // we don't need the Object proto
				WINDOW_EVENT_POPSTATE = "popstate",
				WINDOW_EVENT_HASHCHANGE = "hashchange",
				DOC_EVENT_VCLICK = "vclick",
				LINK_SELECTOR = "a,tau-button",
				util = ns.util,
				history = ns.history,
				eventUtils = ns.event,
				selectorUtils = util.selectors,
				objectUtils = util.object,
				pathUtils = util.path,
				DOM = util.DOM,
				EVENT_STATECHANGE = "historystatechange",
				EVENT_HASHCHANGE = "historyhashchange",
				EVENT_ENABLED = "historyenabled",
				EVENT_DISABLED = "historydisabled",
				/**
				 * Engine event types
				 * @property {Object} events
				 * @property {string} events.STATECHANGE="historystatechange" event name on history manager change state
				 * @property {string} events.HASHCHANGE="historyhashchange" event name on history manager change hash
				 * @property {string} events.ENABLED="historyenabled" event name on enable history manager
				 * @property {string} events.DISABLED="historydisabled" event name on disable history manager
				 * @static
				 * @readonly
				 * @member ns.history.manager
				 */
				events = {
					STATECHANGE: EVENT_STATECHANGE,
					HASHCHANGE: EVENT_HASHCHANGE,
					ENABLED: EVENT_ENABLED,
					DISABLED: EVENT_DISABLED
				};

			manager.events = events;

			/**
			 * Trigger event "historystatechange" on document
			 * @param {Object} options
			 * @return {boolean}
			 */
			function triggerStateChange(options) {
				return eventUtils.trigger(document, EVENT_STATECHANGE, options, true, true);
			}

			/**
			 * Callback for link click
			 * @param {Event} event
			 * @return {boolean}
			 */
			function onLinkAction(event) {
				var target = event.target,
					link = selectorUtils.getClosestBySelector(target, LINK_SELECTOR),
					href,
					useDefaultUrlHandling,
					options, // this should be empty object but some utils that work on it
					rel; // require hasOwnProperty :(

								if (link && event.which === 1) {
					href = link.getAttribute("href");
					rel = link.getAttribute("rel");
					useDefaultUrlHandling = rel === "external" || link.hasAttribute("target");
					if (!useDefaultUrlHandling) {
						options = DOM.getData(link);
						options.event = event;
						if (rel && !options.rel) {
							options.rel = rel;
						} else {
							rel = options.rel;
						}
						if (href && !options.href) {
							options.href = href;
						}
						if (rel === "popup" && link && !options.link) {
							options.link = link;
						}
						history.disableVolatileMode();
						if (!triggerStateChange(options)) {
							// mark as handled
							// but not on back
							if (!rel || (rel !== "back")) {
								eventUtils.preventDefault(event);
								return false;
							}
						}
					}
				}
				return true;
			}


			/**
			 * Callback on popstate event.
			 * @param {Event} event
			 */
			function onPopState(event) {
				var state = event.state,
					lastState = history.activeState,
					options = {},
					reverse,
					resultOfTrigger = true,
					skipTriggerStateChange = false;

								if (manager.locked) {
					history.disableVolatileMode();
					if (lastState) {
						history.replace(lastState, lastState.stateTitle, lastState.stateUrl);
					}
				} else if (state) {
					reverse = history.getDirection(state) === "back";
					options = objectUtils.merge(options, state, {
						reverse: reverse,
						transition: reverse ? ((lastState && lastState.transition) || "none") : state.transition,
						fromHashChange: true
					});

					if (lastState) {
						resultOfTrigger = eventUtils.trigger(document, EVENT_HASHCHANGE, objectUtils.merge(options,
							{url: pathUtils.getLocation(), stateUrl: lastState.stateUrl}), true, true);

						
						// if EVENT HASHCHANGE has been triggered successfully then skip trigger HistoryStateChange
						skipTriggerStateChange = resultOfTrigger;
					}

					state.url = pathUtils.getLocation();
					history.setActive(state);

					if (!skipTriggerStateChange) {
						options.event = event;
						triggerStateChange(options);
					}
				}
			}

			/**
			 * Callback on "hashchange" event
			 * @param {Event} event
			 */
			function onHashChange(event) {
				var newURL = event.newURL;

								if (newURL && history.activeState.url !== newURL) {
					triggerStateChange({href: newURL, fromHashChange: true, event: event});
				}
			}

			/**
			 * Inform that manager is enabled or not.
			 * @property {boolean} [enabled=true]
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.enabled = true;
			/**
			 * Informs that manager is enabled or not.
			 *
			 * If manager is locked then not trigger events historystatechange.
			 * @property {boolean} [locked=false]
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.locked = false;

			/**
			 * Locks history manager.
			 *
			 * Sets locked property to true.
			 *
			 *	@example
			 *		tau.history.manager.lock();
			 *
			 * @method lock
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.lock = function () {
				this.locked = true;
			};

			/**
			 * Unlocks history manager.
			 *
			 * Sets locked property to false.
			 *
			 *	@example
			 *		tau.history.manager.unlock();
			 *
			 * @method unlock
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.unlock = function () {
				this.locked = false;
			};

			/**
			 * Enables history manager.
			 *
			 * This method adds all event listeners connected with history manager.
			 *
			 * Event listeners:
			 *
			 *  - popstate on window
			 *  - hashchange on window
			 *  - vclick on document
			 *
			 * After set event listeners method sets property enabled to true.
			 *
			 *	@example
			 *		tau.history.manager.enable();
			 *		// add event's listeners
			 *		// after click on link or hash change history manager will handle events
			 *
			 * @method enable
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.enable = function () {
				document.addEventListener(DOC_EVENT_VCLICK, onLinkAction, false);
				window.addEventListener(WINDOW_EVENT_POPSTATE, onPopState, false);
				window.addEventListener(WINDOW_EVENT_HASHCHANGE, onHashChange, false);
				history.enableVolatileMode();
				this.enabled = true;
				eventUtils.trigger(document, EVENT_ENABLED, this);
			};

			/**
			 * Disables history manager.
			 *
			 * This method removes all event listeners connected with history manager.
			 *
			 * After set event listeners method sets property enabled to true.
			 *
			 *	@example
			 *		tau.history.manager.disable();
			 *		// remove event's listeners
			 *		// after click on link or hash change history manager will not handle events
			 *
			 * @method disable
			 * @static
			 * @since 2.4
			 * @member ns.history.manager
			 */
			manager.disable = function () {
				document.removeEventListener(DOC_EVENT_VCLICK, onLinkAction, false);
				window.removeEventListener(WINDOW_EVENT_POPSTATE, onPopState, false);
				window.removeEventListener(WINDOW_EVENT_HASHCHANGE, onHashChange, false);
				history.disableVolatileMode();
				this.enabled = false;
				eventUtils.trigger(document, EVENT_DISABLED, this);
			};

			ns.history.manager = manager;
			}(window, window.document));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #Namespace For Core Widgets
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @class ns.widget.core
 */
(function (document, ns) {
	"use strict";
				ns.widget.core = ns.widget.core || {};
			}(window.document, ns));

/*global window, define, ns, HTMLElement, Node */
/*
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */

(function (document, ns) {
	"use strict";
				var engine = ns.engine,
				DOM = ns.util.DOM,
				object = ns.util.object,
				utilArray = ns.util.array,
				eventUtils = ns.event,
				selectorUtils = ns.util.selectors,
				atan2 = Math.atan2,
				abs = Math.abs,
				PI = Math.PI,
				sqrt = Math.sqrt,
				slice = [].slice,
				// focus configuration
				SIDE_DISTANCE_LIMIT = 200,
				prototype = {
					_supportKeyboard: false
				},
				BaseKeyboardSupport = function () {
					var self = this,
						options = self.options || {};

					object.merge(self, prototype);
					// new options requires by keyboard support

					object.merge(options, {
						// "top"|"right"|"bottom"|"left"
						focusDirection: null,
						focusContext: null,
						focusContainerContext: false,
						focusUp: null,
						focusDown: null,
						focusLeft: null,
						focusRight: null,
						focusLock: false
					});

					// widget has keyboard support
					self.isKeyboardSupport = true;

					// prepare selector
					if (selectorsString === "") {
						prepareSelector();
					}
					self._onKeyupHandler = null;
					self._onClickHandler = null;
					self._onHWKeyHandler = null;
					// time of keydown event
					self.keydownEventTimeStart = null; // [ms]
					// flag for keydown event
					self.keydownEventRepeated = false;
				},
				classes = {
					focusDisabled: "ui-focus-disabled",
					focusEnabled: "ui-focus-enabled",
					focusDisabledByWidget: "ui-focus-disabled-by-widget",
					focus: "ui-focus"
				},
				KEY_CODES = {
					left: 37,
					up: 38,
					right: 39,
					down: 40,
					enter: 13,
					tab: 9,
					escape: 27
				},
				activeElement = null,
				EVENT_POSITION = {
					up: "up",
					down: "down",
					left: "left",
					right: "right"
				},
				selectorSuffix = ":not(." + classes.focusDisabled + ")" +
								":not(." + ns.widget.BaseWidget.classes.disable + ")",
				// define standard focus selectors
				// includeDisabled: false - disabled element will be not focusable
				// includeDisabled: true - disabled element will be focusable
				// count - number of defined selectors
				selectors = [{
					value: "a",
					includeDisabled: false,
					count: 1
				}, {
					value: "." + classes.focusEnabled,
					includeDisabled: false,
					count: 1
				}, {
					value: "[tabindex]",
					includeDisabled: false,
					count: 1
				}, {
					value: "[data-focus-lock=true]",
					includeDisabled: false,
					count: 1
				}
				],
				selectorsString = "",
				/**
				* @property {Array} Array containing number of registrations of each selector
				* @member ns.widget.tv.BaseKeyboardSupport
				* @private
				*/
				currentKeyboardWidget,
				lastMoveDirection,
				previousKeyboardWidgets = [],
				ANIMATION_MIN_TIME = 50;

			BaseKeyboardSupport.KEY_CODES = KEY_CODES;
			BaseKeyboardSupport.classes = classes;
			/**
			 * Get focused element.
			 * @method getFocusedLink
			 * @return {HTMLElement}
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getFocusedLink() {
				return document.querySelector(":focus") || document.activeElement;
			}

			/**
			 * Test if the key code is a cursor key code
			 * @method isCursorKey
			 * @param {number} key
			 * @return {boolean}
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function isCursorKey(key) {
				return key === KEY_CODES.left ||
					key === KEY_CODES.right ||
					key === KEY_CODES.up ||
					key === KEY_CODES.down ||
					key === KEY_CODES.enter ||
					key === KEY_CODES.escape;
			}

			/**
			 * Finds all visible links.
			 * @method getFocusableElements
			 * @param {HTMLElement} widgetElement
			 * @param {boolean} visibleOnly select only visible elements
			 * @return {Array}
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getFocusableElements(widgetElement, visibleOnly) {
				var focusableElements = [];

				if (!widgetElement) {
					return [];
				}

				focusableElements = slice.call(widgetElement.querySelectorAll(selectorsString));

				if (!visibleOnly) {
					return focusableElements;
				}
				return focusableElements.filter(function (element) {
					return element.offsetWidth && window.getComputedStyle(element).visibility !== "hidden";
				});
			}

			prototype.preventFocusOnElement = function (element) {
				element.classList.add(classes.focusDisabled);
			}

			/**
			 * Method makes focusable element as disabled for focus selection
			 * @method disableFocusableElements
			 * @param {HTMLElement} element parent element for disabled elements
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.disableFocusableElements = function (element) {
				this.getFocusableElements(element).forEach(function (focusableElement) {
					focusableElement.classList.add(classes.focusDisabled);
					// this class describe that focus on element was disabled by widget, not developer
					focusableElement.classList.add(classes.focusDisabledByWidget);
				});
			}

			/**
			 * Method enables previously disabled the focusable element
			 * @method enableDisabledFocusableElements
			 * @param {HTMLElement} element parent element for disabled elements
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.enableDisabledFocusableElements = function (element) {
				var disabledFocusableElements;

				if (element) {
					disabledFocusableElements = element.querySelectorAll("." + classes.focusDisabledByWidget);

					slice.call(disabledFocusableElements).forEach(function (focusableElement) {
						focusableElement.classList.remove(classes.focusDisabled);
						// this class describe that focus on element was disabled by widget, not developer
						focusableElement.classList.remove(classes.focusDisabledByWidget);
					});
				}
			}

			/**
			 * Extracts element from offsetObject.
			 * @method mapToElement
			 * @param {Object} linkOffset
			 * @param {HTMLElement} linkOffset.element
			 * @return {HTMLElement}
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function mapToElement(linkOffset) {
				return linkOffset.element;
			}

			/**
			 * Set string with selector
			 * @method prepareSelector
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function prepareSelector() {
				var length = selectors.length;

				selectorsString = "";
				utilArray.forEach(selectors, function (object, index) {
					selectorsString += object.value;
					if (!object.includeDisabled) {
						selectorsString += selectorSuffix;
					}
					if (index < length - 1) {
						selectorsString += ",";
					}
				});
			}

			prototype.getActiveSelector = function () {
				return selectorsString;
			};

			BaseKeyboardSupport.copyFocusAttributes = function (widgetInstance, wrapper) {
				var options = widgetInstance.options;

				DOM.setNSDataAttributes(wrapper, {
					focusDirection: options.focusDirection,
					focusContext: options.focusContext,
					focusContainerContext: options.focusContainerContext,
					focusUp: options.focusUp,
					focusDown: options.focusDown,
					focusLeft: options.focusLeft,
					focusRight: options.focusRight
				}, true);
			};

			function getDistanceByCenter(contextRect, referenceElement) {
				var referenceRect = (referenceElement instanceof HTMLElement) ?
						referenceElement.getBoundingClientRect() :
						referenceElement,
					contextCenter = {
						x: contextRect.width / 2 + contextRect.left,
						y: contextRect.height / 2 + contextRect.top
					},
					referenceCenter = {
						x: referenceRect.width / 2 + referenceRect.left,
						y: referenceRect.height / 2 + referenceRect.top
					},
					dy = contextCenter.y - referenceCenter.y,
					dx = contextCenter.x - referenceCenter.x;

				return Math.sqrt(dy * dy + dx * dx);
			}

			function isInLine(contextRect, referenceElement, direction) {
				var a1,
					a2,
					b1,
					b2,
					result = false,
					referenceRect = (referenceElement instanceof HTMLElement) ?
						referenceElement.getBoundingClientRect() :
						referenceElement;

				if (direction === "down" || direction === "up") {
					a1 = referenceRect.left;
					a2 = referenceRect.left + referenceRect.width;
					b1 = contextRect.left;
					b2 = contextRect.left + contextRect.width;
				} else if (direction === "left" || direction === "right") {
					a1 = referenceRect.top;
					a2 = referenceRect.top + referenceRect.height;
					b1 = contextRect.top;
					b2 = contextRect.top + contextRect.height;
				}

				result = ((a1 > b1) && (a1 < b2)) || // at the left
					((a2 > b1) && (a2 < b2)) || // at the right
					// above conditions are applicable also
					// if the context contains the reference element
					((a1 <= b1) && (a2 >= b2)); // content is inside reference element

				return result;
			}

			/**
			 * return angle between two elements
			 * @method getRelativeAngle
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 * @param {Object} contextRect
			 * @param {HTMLElement} referenceElement
			 * @return {number}
			 */
			function getRelativeAngle(contextRect, referenceElement) {
				var referenceRect = (referenceElement instanceof HTMLElement) ?
						referenceElement.getBoundingClientRect() :
						referenceElement,
					contextCenter = {
						x: contextRect.width / 2 + contextRect.left,
						y: contextRect.height / 2 + contextRect.top
					},
					referenceCenter = {
						x: referenceRect.width / 2 + referenceRect.left,
						y: referenceRect.height / 2 + referenceRect.top
					},
					dy = contextCenter.y - referenceCenter.y,
					dx = contextCenter.x - referenceCenter.x,
					angle = atan2(-dy, dx) * 180 / PI;

				// determining the angle between the centers of two rectangles
				return angle;
			}

			/**
			 * return direction from angle
			 * @method getDirectionFromAngle
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 * @param {number} angle
			 * @param tolerance [0.0 .. 45.0]
			 * @return {string}
			 */
			function getDirectionFromAngle(angle, tolerance) {
				tolerance = tolerance || 0.0;

				if ((abs(angle - 180) < tolerance) || (abs(angle + 180) < tolerance)) {
					return EVENT_POSITION.left;
				} else if (abs(angle - 90) < tolerance) {
					return EVENT_POSITION.up;
				} else if (abs(angle) < tolerance) {
					return EVENT_POSITION.right;
				} else if (abs(angle + 90) < tolerance) {
					return EVENT_POSITION.down;
				}
				return "";
			}

			/**
			 * Compares two numbers and return order for sorting functions
			 * @method getOrder
			 * @param {number} number1
			 * @param {number} number2
			 * @return {number}
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getOrder(number1, number2) {
				if (number1 === number2) {
					return 0;
				}
				if (number1 < number2) {
					return -1;
				}
				return 1;
			}

			/**
			 * return direction from origin rect to element rect in movement direction
			 * @param {DOMRect} originRect
			 * @param {DOMRect} elementRect
			 * @param {"top"|"right"|"bottom"|"left"} movementDirection
			 * @return {"top"|"right"|"bottom"|"left"}
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getDirection(originRect, elementRect, movementDirection) {
				if (movementDirection === EVENT_POSITION.right &&
					parseInt(originRect.right) <= parseInt(elementRect.left)) {
					return movementDirection;
				}

				if (movementDirection === EVENT_POSITION.left &&
					parseInt(elementRect.right) <= parseInt(originRect.left)) {
					return movementDirection;
				}

				if (movementDirection === EVENT_POSITION.down &&
					parseInt(originRect.bottom) <= parseInt(elementRect.top)) {
					return movementDirection;
				}

				if (movementDirection === EVENT_POSITION.up &&
					parseInt(originRect.top) >= parseInt(elementRect.bottom)) {
					return movementDirection;
				}

				if (elementRect) {
					// tolerance 5 degrees
					return getDirectionFromAngle(getRelativeAngle(elementRect, originRect), 5.0);
				}

				return "";
			}

			/**
			 * Gets distance between two ClientRects
			 * @param {DOMRect} aElementRect
			 * @param {DOMRect} bElementRect
			 * @return {number}
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getDistanceLeftTopCorner(aElementRect, bElementRect) {
				var x = aElementRect.left - bElementRect.left,
					y = aElementRect.top - bElementRect.top;

				return sqrt(x * x + y * y) | 0;
			}

			/**
			 * Gets distance between two ClientRects by sides
			 * @param {DOMRect} elementRect
			 * @param {DOMRect} referenceElementRect
			 * @return {Object}
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getDistanceBySides(elementRect, referenceElementRect) {
				/*
				 * This values represents distance from reference element to element
				 * at indicated direction:
				 *
				 * example:
				 * =======
				 *
				 *     _ _ _ _
				 *     ^      [element]
				 *     |           ^
				 *     | bottom    | top
				 *     |           |
				 *     |_ [reference element]
				 *
				 *
				 *         _ _ _ _ _ _ _ _ _ _ _ _ [element]
				 *           ^                     |       |
				 *           | top                 |
				 *           |              right  |       |
				 *     [reference element] ------->|
				 *     |                                   |
				 *     |          left
				 *     |---------------------------------->|
				 *
				 * example:
				 * =======
				 *
				 *            _ _ _ _ _ _ _ _ _[reference element]
 				 *             |               |
				 *             | bottom        |
				 *             |               |
				 *             /         left  |
				 *         [element]<----------|
				 *
				 */
				var result = {
					top: referenceElementRect.top - (elementRect.top + elementRect.height) + 0,
					bottom: elementRect.top - referenceElementRect.top - referenceElementRect.height,
					right: elementRect.left - referenceElementRect.left - referenceElementRect.width,
					left: referenceElementRect.left - (elementRect.left + elementRect.width)
				};

				/*
				 * example:
				 * =======
				 *
				 *     [++++++++ element ++++++++]
				 *     |                         |
				 *     |                   left  |
				 *     |               |-------->|
				 *     |
				 *     |<--leftRest----[reference element]
				 *
				 *    Focus on left should takes account also element
				 *    which "leftRest" value is positive
				 *
				 */
				result.leftRest = result.left + elementRect.width;
				result.rightRest = result.right + elementRect.width;
				result.topRest = result.top + elementRect.height;
				result.bottomRest = result.bottom + elementRect.height;
				return result;
			}

			/**
			 * Sorting callback, sorts by distance
			 * @param {Object} a
			 * @param {Object} b
			 * @return {number}
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function sortByDistanceByCenter(a, b) {
				return (a.distanceByCenter === b.distanceByCenter) ? 0 :
					(a.distanceByCenter < b.distanceByCenter) ? -1 : 1;
			}

			function sortByDistance(a, b) {
				return (a.distanceByDirection.distance === b.distanceByDirection.distance) ?
					sortByDistanceByCenter(a, b) :
						(a.distanceByDirection.distance < b.distanceByDirection.distance) ? -1 : 1;
			}

			function sortByInSideDistanceLimit(a, b) {
				// sort by inSideDistanceLimit
				return (a.inSideDistanceLimit && b.inSideDistanceLimit) ? sortByDistance(a, b) :
						(!a.inSideDistanceLimit && !b.inSideDistanceLimit) ? sortByDistanceByCenter(a, b) :
							(a.inSideDistanceLimit && !b.inSideDistanceLimit) ? -1 : 1;
			}

			/**
			 * Sorting callback, sorts by distance
			 * @param {Object} a
			 * @param {Object} b
			 * @return {number}
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function sortFocusableElements(a, b) {
				/**
				 * Sort order
				 * - inLine
				 * - inSideDistanceLimit
				 * ---  distanceByDirection.distance
				 * ---  distanceByCenter
				 */
				// sort by inline
				return (a.inLine && b.inLine || !a.inLine && !b.inLine) ? sortByInSideDistanceLimit(a, b) :
					(a.inLine && !b.inLine) ? -1 : 1;
			}

			function getDistanceByDirection(distances, direction) {
				switch (direction) {
					case "left": return {
						distance: distances.left,
						distanceRest: distances.leftRest
					};
					case "right": return {
						distance: distances.right,
						distanceRest: distances.rightRest
					};
					case "up": return {
						distance: distances.top,
						distanceRest: distances.topRest
					};
					case "down": return {
						distance: distances.bottom,
						distanceRest: distances.bottomRest
					};
				}
			}

			/**
			 * Calculates neighborhood links.
			 * @method getNeighborhoodLinks
			 * @param {HTMLElement} element Base element fo find links
			 * @param {HTMLElement} [currentElement] current focused element
			 * @param {Object} [options] Options for function
			 * @param {Function} [options._filterNeighbors] Function used to filtering focusable elements
			 * @param {"top"|"right"|"bottom"|"left"} [options.direction] direction
			 * @return {Object}
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getNeighborhoodLinks(element, currentElement, options) {
				var links,
					direction = options.direction,
					currentLink = currentElement || getFocusedLink(),
					customFocus,
					linksOffset = [],
					elementRect = currentLink.getBoundingClientRect(),
					focusableElements = [],
					focusableElement = null,
					focusableElementRect = null,
					distances = {},
					distanceByDirection,
					i = 0,
					l = 0;

				customFocus = (currentLink && fetchCustomFocusElement(currentLink, direction, element));
				if (customFocus) {
					return [customFocus];
				}

				links = getFocusableElements(element, true);

				if (currentLink && currentLink !== document.body) {

					for (i = 0, l = links.length; i < l; ++i) {
						focusableElement = links[i];
						focusableElementRect = focusableElement.getBoundingClientRect();
						distances = getDistanceBySides(focusableElementRect, elementRect);
						distanceByDirection = getDistanceByDirection(distances, direction);
						focusableElements.push({
							element: focusableElement,
							angle: getRelativeAngle(focusableElementRect, elementRect),
							direction: getDirection(elementRect, focusableElementRect, direction, focusableElement),
							distance: getDistanceLeftTopCorner(elementRect, focusableElementRect),
							distanceByDirection: distanceByDirection,
							distanceByCenter: getDistanceByCenter(focusableElementRect, elementRect),
							inLine: isInLine(focusableElementRect, elementRect, direction),
							inSideDistanceLimit: distanceByDirection.distance >= 0 &&
								distanceByDirection.distance < SIDE_DISTANCE_LIMIT
						});
					}

					// remove from list an elements behind move direction
					focusableElements = focusableElements.filter(function (focusableElement) {
						return focusableElement.distanceByDirection.distanceRest > 0;
					});

					focusableElements = focusableElements.filter(function (focusableElement) {
						// corner cases, when element positions overlap
						if (focusableElement.distance === 0) {
							if (direction === EVENT_POSITION.down) {
								return currentLink.compareDocumentPosition(typeof focusableElement === element ? focusableElement : focusableElement.element) &
										Node.DOCUMENT_POSITION_CONTAINED_BY;
							} else if (direction === EVENT_POSITION.up) {
								return currentLink.compareDocumentPosition(typeof focusableElement === element ? focusableElement : focusableElement.element) &
										Node.DOCUMENT_POSITION_PRECEDING;
							}
							return false;
						}
						return focusableElement.direction === direction;
					});

					// This sort method is major action to make order in the moving of focus
					focusableElements = focusableElements.sort(sortFocusableElements).map(mapToElement);

					// return result;
					return focusableElements;
				}
				linksOffset = utilArray.map(links, function (link) {
					var linkOffset = link.getBoundingClientRect();

					return {
						offset: linkOffset,
						element: link,
						width: link.offsetWidth,
						height: link.offsetHeight
					};
				});
				return utilArray.map(linksOffset.sort(function (linkOffset1, linkOffset2) {
					// every sort function *must* return 0 on equal elements to prevent
					// changing of input order
					if (linkOffset1.offset.top === linkOffset2.offset.top) {
						return getOrder(linkOffset1.offset.left, linkOffset2.offset.left);
					}
					return getOrder(linkOffset1.offset.top, linkOffset2.offset.top);
				}), mapToElement);
			}

			/**
			 * This method triggers 'blur' event on widget or html element
			 * @method blurOnActiveElement
			 * @param {Object} options
			 * @static
			 * @memberof ns.widget.tv.BaseKeyboardSupport
			 */
			function blurOnActiveElement(options) {
				var currentElement,
					preventDefault,
					currentWidget

				options = options || {};
				currentElement = options.current || activeElement || getFocusedLink();

				// and blur the previous one
				if (currentElement) {
					currentWidget = engine.getBinding(currentElement);
					if (currentWidget) {
						currentWidget.blur(options);
					} else {
						options.element = currentElement;
						preventDefault = !eventUtils.trigger(currentElement, "taublur", options);
						if (!preventDefault) {
							currentElement.classList.remove(classes.focus);
							currentElement.blur();
						}
					}
					// set active element to null;
					activeElement = null;
				}
			}

			/**
			 * Method trying to focus on widget or on HTMLElement and blur on active element or widget.
			 * @method focusOnElement
			 * @param {?ns.widget.BaseWidget} self
			 * @param {HTMLElement} element
			 * @param {Object} [options]
			 * @return  {boolean} Return true if focus finished success
			 * @static
			 * @private
			 * @memberof ns.widget.tv.BaseKeyboardSupport
			 */
			function focusOnElement(self, element, options) {
				var setFocus,
					currentElement = options.current || activeElement || getFocusedLink(),
					nextElementWidget,
					lockedElement = element && selectorUtils.getClosestBySelectorNS(element.parentNode, "focus-lock=true"),
					lockedWidget = (lockedElement && engine.getBinding(lockedElement)) || null,
					preventDefault;

				if (lockedWidget && lockedWidget !== currentKeyboardWidget) {
					return false;
				}

				options = options || {};
				nextElementWidget = engine.getBinding(element);

				if (nextElementWidget) {
					// we call function focus if the element is connected with widget
					options.previousElement = currentElement;
					setFocus = nextElementWidget.focus(options);
					blurOnActiveElement(options);
				} else {
					if (element !== currentElement) {
						options.previousElement = currentElement;
						// or only set focus on element
						// for mouse is possible to focus on null element
						if (element) {
							options.element = element;
							preventDefault = !eventUtils.trigger(element, "taufocus", options);
							if (!preventDefault) {
								element.classList.add(classes.focus);
								element.focus();
							}
						}
						// and blur the previous one
						blurOnActiveElement(options);
						setFocus = true;
					}
				}

				// The currently focused element becomes active
				// We need this for proper focus locking
				activeElement = element;

				if (self) {
					if (self._openActiveElement) {
						self._openActiveElement(element);
					}
				}

				return setFocus;
			}

			/**
			 * @method blurOnActiveElement
			 */
			prototype.blurOnActiveElement = blurOnActiveElement;

			/**
			 * Tries to fetch custom focus attributes and move to the specified element
			 * @param {HTMLElement} element
			 * @param {string} direction
			 * @param {HTMLElement} [queryContext=undefined]
			 * @method fetchCustomFocusElement
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function fetchCustomFocusElement(element, direction, queryContext) {
				var selector = element.getAttribute("data-focus-" + direction),
					eventData = {
						selector: selector,
						direction: direction,
						currentElement: element,
						nextElement: null
					},
					useQueryContext = element.getAttribute("data-focus-container-context") === "true",
					customQueryContextSelector = element.getAttribute("data-focus-context");

				if (selector) {
					// notify observers about custom query for focus element
					// observers can catch the event and choose their own elements
					// this supports customSelectors like ::virtualgrid-* which
					// is implemented in virtualgrid, if the event was not consumed
					// assume normal selector
					if (eventUtils.trigger(element, "focusquery", eventData, true, true)) {
						if (useQueryContext) {
							if (customQueryContextSelector) {
								queryContext = document.querySelector(customQueryContextSelector);
							}
							if (queryContext) {
								return queryContext.parentNode.querySelector(selector);
							}
						}
						return element.parentNode.querySelector(selector);
					}
					// if some code managed to fill nextElement use it
					if (eventData.nextElement) {
						return eventData.nextElement;
					}
				}

				return null;
			}

			/**
			 * Locks focus on element if possible
			 * @param {ns.widget.tv.BaseKeyboardSupport} self
			 * @param {HTMLElement} element
			 * @return {boolean}
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function lockFocus(self, element) {
				var widget = null;

				if (DOM.getNSData(element, "focus-lock") === true) {
					widget = engine.getBinding(element);
					if (widget && widget !== currentKeyboardWidget) {
						widget.saveKeyboardSupport();
						widget.enableKeyboardSupport();
						widget.blur();
						focusOnNeighborhood(self, element, {direction: lastMoveDirection, key: KEY_CODES.down});
						return true;
					}
				}
				return false;
			}

			/**
			 * Unlocks focus from element if possible
			 * @param {ns.widget.tv.BaseKeyboardSupport} self
			 * @param {HTMLElement} element
			 * @return {boolean}
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function unlockFocus(self, element) {
				var widget;
				// enable escape from children (usability)

				if (DOM.getNSData(element, "focus-lock") !== true) {
					element = selectorUtils.getClosestBySelectorNS(element.parentNode, "focus-lock=true");
					if (!element) {
						return false;
					}
				}
				widget = engine.getBinding(element);
				if (widget && widget === currentKeyboardWidget) {
					widget.disableKeyboardSupport();
					widget.restoreKeyboardSupport();
					focusOnElement(self, element, {direction: lastMoveDirection, key: KEY_CODES.down});
					return true;
				}

				return false;
			}

			function focusOnNeighborhood(self, element, options) {
				var positionFrom = "",
					nextElements = [],
					nextElement,
					nextNumber = 0,
					current = options.current,
					event = options.event,
					widget,
					setFocus = false;

				switch (options.key) {
					case KEY_CODES.left:
						positionFrom = EVENT_POSITION.left;
						break;
					case KEY_CODES.up:
						positionFrom = EVENT_POSITION.up;
						break;
					case KEY_CODES.right:
						positionFrom = EVENT_POSITION.right;
						break;
					case KEY_CODES.down:
						positionFrom = EVENT_POSITION.down;
						break;
					case KEY_CODES.enter:
						// @TODO context enter
						if (current) {
							if (lockFocus(self, current)) {
								if (event) {
									event.preventDefault();
									event.stopImmediatePropagation();
								}
							} else {
								widget = ns.engine.getBinding(current);
								if (widget && typeof widget._actionEnter === "function") {
									widget._actionEnter(current);
								}
							}
							return;
						}
						break;
					case KEY_CODES.escape:
						// this also is done by hwkey
						if (current) {
							if (unlockFocus(self, current)) {
								if (event) {
									event.preventDefault();
									event.stopImmediatePropagation();
								}
							} else {
								widget = ns.engine.getBinding(current);
								if (widget && typeof widget._actionEscape === "function") {
									widget._actionEscape(current);
								}
							}
							return;
						}
						break;
					default:
						return;
				}

				options.direction = options.direction || positionFrom;
				if (positionFrom) {
					lastMoveDirection = positionFrom;
				}

				nextElement = fetchCustomFocusElement(element, positionFrom);

				if (!nextElement) {
					nextElements = getNeighborhoodLinks(element, current, options);
					nextElement = nextElements[nextNumber];
				}

				if (options._last) {
					// we are looking for element to focus from the farthest to the nearest
					nextNumber = nextElements.length - 1;
					nextElement = nextElements[nextNumber];
					while (nextElement && !setFocus) {
						// if element to focus is found
						setFocus = focusOnElement(self, nextElement, options);
						nextElement = nextElements[--nextNumber];
					}
				} else {
					// we are looking for element to focus from the nearest
					nextNumber = 0;
					nextElement = nextElements[nextNumber];
					if (nextElement) {
						while (nextElement && !setFocus) {
							// if element to focus is found
							setFocus = focusOnElement(self, nextElement, options);
							nextElement = nextElements[++nextNumber];
						}
					} else {
						eventUtils.trigger(
							// if current element is not parent of current element
							// then we cannot trigger event on current element
							// eg. current page doesn't have any focusable element
							//     and current focusable element is on previous page
							//     in this case event has to be trigger on current page
							//     not on previous page
							DOM.isChildElementOf(current, element) ? current : element,
							"taufocusborder",
							options
						);
					}
				}
			}

			/**
			 * Supports keyboard event.
			 * @method _onKeyup
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._onKeyup = function (event) {
				var self = this,
					keyboardSupportState = ns.getConfig("keyboardSupport", false);

				if (keyboardSupportState && self._supportKeyboard) {
					if (!self.keydownEventRepeated) {
						// short press was detected
						self._onShortPress(event);
					}
					self.keydownEventTimeStart = null;
					self.keydownEventRepeated = false;
				}
			};

			/**
			 * Mouse move listener
			 * @method _onMouseMove
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._onMouseMove = function (event) {
				var self = this,
					// we finding element on current position
					target = document.elementFromPoint(event.pageX, event.pageY),
					keyboardSupportState = ns.getConfig("keyboardSupport", false),
					element = null,
					currentElement = activeElement,
					fromPosition = EVENT_POSITION.down;

				if (keyboardSupportState && self._supportKeyboard) {
					// check matching or find matching parent
					element = selectorUtils.getClosestBySelector(target, selectorsString);

					if (element !== currentElement) {
						if (currentElement) {
							fromPosition = getDirectionFromAngle(
								getRelativeAngle({
									left: event.pageX,
									top: event.pageY
								}, currentElement)
							);
						} else {
							// if we not have currently focused element we calculate move direction
							// in compare with previous mouse position
							fromPosition = getDirectionFromAngle(
								getRelativeAngle({
									left: event.pageX,
									top: event.pageY
								}, {
									left: event.pageX - event.movementX,
									top: event.pageY - event.movementY
								})
							);
						}

						focusOnElement(self, element, {
							direction: fromPosition
						});
					}
				}
			};

			/**
			 * This function is used as a filtering function in function getNeighborhoodLinks.
			 * @method _onKeyup
			 * @param {string} direction
			 * @param {Object} filteredElement Information about element, which is being already filtered.
			 * @param {HTMLElement} element Current element
			 * @param {Object} [elementOffset] Offset of current element
			 * @private
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function filterNeighbors(direction, filteredElement, element, elementOffset) {
				var filteredElementOffset = filteredElement.offset,
					filteredElementHeight = filteredElement.height,
					filteredElementWidth = filteredElement.width,
					elementHeight = element.offsetHeight,
					elementWidth = element.offsetWidth;

				elementOffset = elementOffset || element.getBoundingClientRect();
				switch (direction) {
					case "top":
						// we are looking for elements, which are above the current element, but
						// only in the same column
						if (elementOffset.left >= filteredElementOffset.left + filteredElementWidth ||
							elementOffset.left + elementWidth <= filteredElementOffset.left) {
							// if element is on the right or on the left of the current element,
							// we remove it from the set
							return false;
						}
						return filteredElementOffset.top < elementOffset.top;
					case "bottom":
						// we are looking for elements, which are under the current element, but
						// only in the same column
						if (elementOffset.left >= filteredElementOffset.left + filteredElementWidth ||
							elementOffset.left + elementWidth <= filteredElementOffset.left) {
							return false;
						}
						return filteredElementOffset.top >= elementOffset.bottom;
					case "left":
						// we are looking for elements, which are on the left of the current element, but
						// only in the same row
						if (elementOffset.top >= filteredElementOffset.top + filteredElementHeight ||
							elementOffset.top + elementHeight <= filteredElementOffset.top) {
							return false;
						}
						return filteredElementOffset.left < elementOffset.left;
					case "right":
						// we are looking for elements, which are ont the right of the current element, but
						// only in the same row
						if (elementOffset.top >= filteredElementOffset.top + filteredElementHeight ||
							elementOffset.top + elementHeight <= filteredElementOffset.top) {
							return false;
						}
						return filteredElementOffset.left >= elementOffset.right;
				}
			}

			prototype._onHWKey = function (event) {
				var self = this,
					current = activeElement || getFocusedLink();

				if (event.keyName === "back" && current && unlockFocus(self, current)) {
					event.preventDefault();
					event.stopImmediatePropagation();
					return true;
				}

				return false;
			};

			/**
			 * Supports keyboard long press event.
			 * It is called on keydown event, when the long press was not detected.
			 * @method _onLongPress
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._onLongPress = function (event) {
				var self = this,
					delay = ns.getConfig("keyboardLongpressInterval", 100),
					options = {
						current: activeElement || getFocusedLink(),
						key: event.keyCode,
						// it is repeated event, so we make animation shorter
						duration: ((delay - 30) >= ANIMATION_MIN_TIME ? delay - 30 : ANIMATION_MIN_TIME),
						_last: true, // option for function focusOnNeighborhood
						_filterNeighbors: filterNeighbors // option for function getNeighborhoodLinks
					};

				// set focus on next element
				focusOnNeighborhood(self, self.keyboardElement || self.element, options);
			};

			/**
			 * Supports keyboard short press event.
			 * It is called on keyup event, when the long press was not detected.
			 * @method _onShortPress
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._onShortPress = function (event) {
				var self = this;

				if (!ns.getConfig("keyboardSupport", false)) {
					return false;
				}

				// set focus on next element
				focusOnNeighborhood(self, self.keyboardElement || self.element, {
					current: activeElement || getFocusedLink(),
					event: event,
					key: event.keyCode
				});
			};

			/**
			 * Supports keyboard event.
			 * @method _onKeydown
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._onKeydown = function (event) {
				var self = this,
					delay = ns.getConfig("keyboardLongpressInterval", 1000),
					keyboardSupportState = ns.getConfig("keyboardSupport", false),
					currentTime;

				// if widget supports keyboard's events
				if (keyboardSupportState && self._supportKeyboard && isCursorKey(event.keyCode)) {
					// stop scrolling
					event.preventDefault();
					event.stopPropagation();

					currentTime = Date.now();
					// we check if it is a single event or repeated one
					// @note: On TV property .repeat for event is not available, so we have to count time
					//        between events
					if (!self.keydownEventTimeStart || (currentTime - self.keydownEventTimeStart > delay)) {
						// stop scrolling
						//event.preventDefault();
						//event.stopPropagation();

						// if it is repeated event, we make animation shorter
						if (self.keydownEventTimeStart) {
							// long press was detected
							self._onLongPress(event);
							self.keydownEventRepeated = true;
						}
						self.keydownEventTimeStart = currentTime;
					}
				}
			};

			/**
			 * Add Supports keyboard event.
			 *
			 * This method should be called in _bindEvent method in widget.
			 * @method _bindEventKey
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._bindEventKey = function () {
				var self = this;

				if (!self._onKeyupHandler) {
					self._onKeyupHandler = self._onKeyup.bind(self);
					self._onKeydownHandler = self._onKeydown.bind(self);
					self._onHWKeyHandler = self._onHWKey.bind(self);
					document.addEventListener("keyup", self._onKeyupHandler, false);
					document.addEventListener("keydown", self._onKeydownHandler, false);
					document.addEventListener("tizenhwkey", self._onHWKeyHandler, false);
				}
			};

			/**
			 * Adds support for mouse events
			 * @method _bindEventMouse
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._bindEventMouse = function () {
				var self = this;

				if (!self._onMouseMoveHandler) {
					self._onMouseMoveHandler = self._onMouseMove.bind(self);
					//we resign from virtual events because of problems with enter event
					document.addEventListener("mousemove", self._onMouseMoveHandler, false);
				}
			};

			/**
			 * Supports keyboard event.
			 *
			 * This method should be called in _destroy method in widget.
			 * @method _destroyEventKey
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._destroyEventKey = function () {
				if (this._onKeyupHandler) {
					document.removeEventListener("keyup", this._onKeyupHandler, false);
					document.removeEventListener("keydown", this._onKeydownHandler, false);
					document.removeEventListener("tizenhwkey", this._onHWKeyHandler, false);
					this._onKeyupHandler = null;
				}
			};

			/**
			 * Removes support for mouse events
			 * @method _destroyEventMouse
			 * @protected
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype._destroyEventMouse = function () {
				if (this._onClickHandler) {
					//we resign from virtual events because of problems with enter event
					document.removeEventListener("mousemove", this._onMouseMoveHandler, false);
				}
			};

			/**
			 * Blurs from focused element.
			 * @method blur
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			BaseKeyboardSupport.blurAll = function () {
				var focusedElement = activeElement || getFocusedLink(),
					focusedElementWidget = focusedElement && engine.getBinding(focusedElement);

				if (focusedElementWidget) {
					// call blur on widget
					focusedElementWidget.blur();
				} else if (focusedElement) {
					// or call blur on element
					focusedElement.blur();
				}
			};

			/**
			 * Focuses on element.
			 * @method focusElement
			 * @param {HTMLElement} [element] widget's element
			 * @param {?HTMLElement|number|boolean|string} [elementToFocus] element to focus
			 * @param {Object} [options]
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			BaseKeyboardSupport.focusElement = function (element, elementToFocus, options) {
				var links,
					linksLength,
					i;

				options = options || {};
				if (options.current === undefined) {
					options.current = getFocusedLink();
				}

				if (elementToFocus instanceof HTMLElement) {
					if (element) {
						links = getFocusableElements(element, true);
						linksLength = links.length;
						for (i = 0; i < linksLength; i++) {
							if (links[i] === elementToFocus) {
								elementToFocus.focus();
							}
						}
					} else {
						elementToFocus.focus();
					}
				} else if (typeof elementToFocus === "number") {
					links = getFocusableElements(element, true);
					if (links[elementToFocus]) {
						focusOnElement(null, links[elementToFocus], options);
					}
				} else if (typeof elementToFocus === "string" && KEY_CODES[elementToFocus]) {
					options.direction = KEY_CODES[elementToFocus];
					focusOnNeighborhood(null, element, options);
				} else {
					links = getFocusableElements(element, true);
					if (links[0]) {
						focusOnElement(null, links[0], options);
					}
				}
			};

			/**
			 * Enables keyboard support on widget.
			 * @method enableKeyboardSupport
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.enableKeyboardSupport = function () {
				this._supportKeyboard = true;
				currentKeyboardWidget = this;
			};

			/**
			 * Enables keyboard support on widget.
			 * @method restoreKeyboardSupport
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.restoreKeyboardSupport = function () {
				var previousKeyboardWidget = previousKeyboardWidgets.pop();

				if (previousKeyboardWidget) {
					previousKeyboardWidget.enableKeyboardSupport();
				}
			};

			/**
			 * Disables keyboard support on widget.
			 * @method disableKeyboardSupport
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.disableKeyboardSupport = function () {
				currentKeyboardWidget = null;
				this._supportKeyboard = false;
			};

			/**
			 * Save history of keyboard support on widget.
			 * @method saveKeyboardSupport
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			prototype.saveKeyboardSupport = function () {
				if (currentKeyboardWidget) {
					previousKeyboardWidgets.push(currentKeyboardWidget);
					currentKeyboardWidget.disableKeyboardSupport();
				}
			};

			/**
			 * Convert selector object to string
			 * @method getValueOfSelector
			 * @param {Object} selectorObject
			 * @static
			 * @private
			 * @return {string}
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function getValueOfSelector(selectorObject) {
				return selectorObject.value;
			}

			/**
			 * Find index in selectors array for given selector
			 * @method findSelectorIndex
			 * @param {string} selector
			 * @static
			 * @private
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			function findSelectorIndex(selector) {
				return utilArray.map(selectors, getValueOfSelector).indexOf(selector);
			}

			/**
 			 * @method getFocusableElements
			 */
			prototype.getFocusableElements = getFocusableElements;

			/**
			 * Registers an active selector.
			 * @param {string} selector
			 * @param {boolean} includeDisabled
			 * @method registerActiveSelector
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			BaseKeyboardSupport.registerActiveSelector = function (selector, includeDisabled) {
				var selectorArray = selector.split(","),
					index;

				utilArray.forEach(selectorArray, function (currentSelector) {
					currentSelector = currentSelector.trim();
					index = findSelectorIndex(currentSelector);

					// check if not registered yet
					if (index === -1) {
						selectors.push({
							value: currentSelector,
							includeDisabled: includeDisabled,
							count: 1
						});
					} else {
						selectors[index].count++;
					}
				});

				prepareSelector();
			};

			/**
			 * Unregister an active selector.
			 * @param {string} selector
			 * @method unregisterActiveSelector
			 * @static
			 * @member ns.widget.tv.BaseKeyboardSupport
			 */
			BaseKeyboardSupport.unregisterActiveSelector = function (selector) {
				var selectorArray = selector.split(","),
					index;

				utilArray.forEach(selectorArray, function (currentSelector) {
					currentSelector = currentSelector.trim();
					index = findSelectorIndex(currentSelector);

					if (index !== -1) {
						--selectors[index].count;
						// check reference counter
						if (selectors[index].count === 0) {
							// remove selector
							selectors.splice(index, 1);
						}
					}
				});

				prepareSelector();
			};

			ns.widget.core.BaseKeyboardSupport = BaseKeyboardSupport;

			}(window.document, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true */
/**
 * # Page Widget
 * Page is main element of application's structure.
 *
 * ## Default selectors
 * In the Tizen Web UI framework the application page structure is based on a header, content and footer elements:
 *
 * - **The header** is placed at the top, and displays the page title and optionally buttons.
 * - **The content** is the section below the header, showing the main content of the page.
 * - **The footer** is a bottom part of page which can display for example buttons
 *
 * The following table describes the specific information for each section.
 *
 * <table>
 *     <tr>
 *         <th>Section</th>
 *         <th>Class</th>
 *         <th>Mandatory</th>
 *         <th>Description</th>
 *     </tr>
 *     <tr>
 *         <td rowspan="2">Page</td>
 *         <td>ui-page</td>
 *         <td>Yes</td>
 *         <td>Defines the element as a page.
 *
 * The page widget is used to manage a single item in a page-based architecture.
 *
 * A page is composed of header (optional), content (mandatory), and footer (optional) elements.</td>
 *      </tr>
 *      <tr>
 *          <td>ui-page-active</td>
 *          <td>No</td>
 *          <td>If an application has a static start page, insert the ui-page-active class in the page element to
 *          speed up the application launch. The start page with the ui-page-active class can be displayed before
 *          the framework is fully loaded.
 *
 *          If this class is not used, the framework inserts the class automatically to the first page of the
 *          application.
 *
 *          However, this has a slowing effect on the application launch, because the page is displayed only after
 *          *the* framework is fully loaded.</td>
 *      </tr>
 *      <tr>
 *          <td>Header</td>
 *          <td>ui-header</td>
 *          <td>No</td>
 *          <td>Defines the element as a header.</td>
 *      </tr>
 *      <tr>
 *          <td>Content</td>
 *          <td>ui-content</td>
 *          <td>Yes</td>
 *          <td>Defines the element as content.</td>
 *      </tr>
 *      <tr>
 *          <td>Footer</td>
 *          <td>ui-footer</td>
 *          <td>No</td>
 *          <td>Defines the element as a footer.
 *
 * The footer section is mostly used to include option buttons.</td>
 *      </tr>
 *  </table>
 *
 * All elements with class=ui-page will be become page widgets
 *
 *      @example
 *         <!--Page layout-->
 *         <div class="ui-page ui-page-active">
 *             <header class="ui-header"></header>
 *             <div class="ui-content"></div>
 *             <footer class="ui-footer"></footer>
 *         </div>
 *
 *         <!--Page layout with more button in header-->
 *         <div class="ui-page ui-page-active">
 *             <header class="ui-header ui-has-more">
 *                 <h2 class="ui-title">Call menu</h2>
 *                 <button type="button" class="ui-more ui-icon-overflow">More Options</button>
 *             </header>
 *             <div class="ui-content">Content message</div>
 *             <footer class="ui-footer">
 *                 <button type="button" class="ui-btn">Footer Button</button>
 *             </footer>
 *         </div>
 *
 * ## Manual constructor
 * For manual creation of page widget you can use constructor of widget from **tau** namespace:
 *
 *        @example
 *        var pageElement = document.getElementById("page"),
 *            page = tau.widget.Page(buttonElement);
 *
 * Constructor has one require parameter **element** which are base **HTMLElement** to create widget.
 * We recommend get
 * this element by method *document.getElementById*.
 *
 * ## Multi-page Layout
 *
 * You can implement a template containing multiple page containers in the application index.html file.
 *
 * In the multi-page layout, the main page is defined with the ui-page-active class.
 * If no page has the ui-page-active
 * class, the framework automatically sets up the first page in the source order
 * as the main page. You can improve the
 * launch performance by explicitly defining the main page to be displayed first.
 * If the application has to wait for
 * the framework to set up the main page, the page is displayed with some delay
 * only after the framework is fully
 * loaded.
 *
 * You can link to internal pages by referring to the ID of the page. For example, to link to the page with an ID
 * of
 * two, the link element needs the href="#two" attribute in the code, as in the following example.
 *
 *      @example
 *         <!--Main page-->
 *         <div id="one" class="ui-page ui-page-active">
 *             <header class="ui-header"></header>
 *             <div class="ui-content"></div>
 *             <footer class="ui-footer"></footer>
 *         </div>
 *
 *         <!--Secondary page-->
 *         <div id="two" class="ui-page">
 *             <header class="ui-header"></header>
 *             <div class="ui-content"></div>
 *             <footer class="ui-footer"></footer>
 *         </div>
 *
 * To find the currently active page, use the ui-page-active class.
 *
 * ## Changing Pages
 * ### Go to page in JavaScript
 * To change page use method *tau.changePage*
 *
 *      @example
 *      tau.changePage("page-two");
 *
 * ### Back in JavaScript
 * To back to previous page use method *tau.back*
 *
 *      @example
 *      tau.back();
 *
 * ## Transitions
 *
 * When changing the active page, you can use a page transition.
 *
 * Tizen Web UI Framework does not apply transitions by default. To set a custom transition effect,
 * you must add the
 * data-transition attribute to a link:
 *
 *      @example
 *      <a href="index.html" data-transition="slideup">I\'ll slide up</a>
 *
 * To set a default custom transition effect for all pages, use the pageTransition property:
 *
 *      @example
 *      tau.defaults.pageTransition = "slideup";
 *
 * ### Transitions list
 *
 *  - **none** no transition.
 *  - **slideup** Makes the content of the next page slide up, appearing to conceal the content of the previous page.
 *
 * ## Handling Page Events
 *
 * With page widget we have connected many of events.
 *
 * To handle page events, use the following code:
 *
 *      @example
 *        <div id="page" class="ui-page">
 *             <header class="ui-header"></header>
 *             <div class="ui-content"></div>
 *         </div>
 *
 *         <script>
 *             var page = document.getElementById("page");
 *             page.addEventListener("Event", function(event) {
 *                 // Your code
 *             });
 *         </script>
 *
 * To bind an event callback on the Back key, use the following code:
 *
 * Full list of available events is in [events list section](#events-list).
 *
 * To bind an event callback on the Back key, use the following code:
 *
 *      @example
 *         <script>
 *             window.addEventListener("tizenhwkey", function (event) {
 *                 if (event.keyName == "back") {
 *                     // Call window.history.back() to go to previous browser window
 *                     // Call tizen.application.getCurrentApplication().exit() to exit application
 *                     // Add script to add another behavior
 *                 }
 *             });
 *         </script>
 *
 *
 * ## Methods
 *
 * To call method on widget you can use tau API:
 *
 *        @example
 *        var pageElement = document.getElementById("page"),
 *            page = tau.widget.Page(buttonElement);
 *
 *        page.methodName(methodArgument1, methodArgument2, ...);
 *
 * @class ns.widget.core.Page
 * @extends ns.widget.BaseWidget
 * @component-selector .ui-page
 * @component-type container-component
 * @component-constraint 'popup', 'drawer', 'header', 'bottom-button'
 * @component-attachable false
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Damian Osipiuk <d.osipiuk@samsung.com>
 */
(function (document, ns) {
	"use strict";
				/**
			 * Alias for {@link ns.widget.BaseWidget}
			 * @property {Object} BaseWidget
			 * @member ns.widget.core.Page
			 * @private
			 * @static
			 */
			var BaseWidget = ns.widget.BaseWidget,
				/**
				 * Alias for {@link ns.util}
				 * @property {Object} util
				 * @member ns.widget.core.Page
				 * @private
				 * @static
				 */
				util = ns.util,
				utilsDOM = util.DOM,
				/**
				 * Alias for {@link ns.util.selectors}
				 * @property {Object} utilSelectors
				 * @member ns.widget.core.Page
				 * @private
				 * @static
				 */
				utilSelectors = util.selectors,
				/**
				 * Alias for {@link ns.engine}
				 * @property {Object} engine
				 * @member ns.widget.core.Page
				 * @private
				 * @static
				 */
				engine = ns.engine,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				arrayUtil = ns.util.array,

				Page = function (element, options) {
					var self = this;

					BaseKeyboardSupport.call(self);

					/**
					 * Callback on resize
					 * @property {?Function} _contentFillAfterResizeCallback
					 * @private
					 * @member ns.widget.core.Page
					 */
					self._contentFillAfterResizeCallback = null;
					self._initialContentStyle = {};
					/**
					 * Options for widget.
					 * @property {Object} options
					 * @member ns.widget.core.Page
					 */
					self.options = options || {};

					self._contentStyleAttributes = ["height", "width", "minHeight", "marginTop", "marginBottom"];

					self._ui = {};
				},
				/**
				 * Dictionary for page related event types
				 * @property {Object} EventType
				 * @member ns.widget.core.Page
				 * @static
				 */
				EventType = {
					/**
					 * Triggered on the page we are transitioning to,
					 * after the transition animation has completed.
					 * @event pageshow
					 * @member ns.widget.core.Page
					 */
					SHOW: "pageshow",
					/**
					 * Triggered on the page we are transitioning away from,
					 * after the transition animation has completed.
					 * @event pagehide
					 * @member ns.widget.core.Page
					 */
					HIDE: "pagehide",
					/**
					 * Triggered when the page has been created in the DOM
					 * (for example, through Ajax) but before all widgets
					 * have had an opportunity to enhance the contained markup.
					 * @event pagecreate
					 * @member ns.widget.core.Page
					 */
					CREATE: "pagecreate",
					/**
					 * Triggered when the page is being initialized,
					 * before most plugin auto-initialization occurs.
					 * @event pagebeforecreate
					 * @member ns.widget.core.Page
					 */
					BEFORE_CREATE: "pagebeforecreate",
					/**
					 * Triggered on the page we are transitioning to,
					 * before the actual transition animation is kicked off.
					 * @event pagebeforeshow
					 * @member ns.widget.core.Page
					 */
					BEFORE_SHOW: "pagebeforeshow",
					/**
					 * Triggered on the page we are transitioning away from,
					 * before the actual transition animation is kicked off.
					 * @event pagebeforehide
					 * @member ns.widget.core.Page
					 */
					BEFORE_HIDE: "pagebeforehide"
				},
				/**
				 * Dictionary for page related css class names
				 * @property {Object} classes
				 * @member ns.widget.core.Page
				 * @static
				 * @readonly
				 */
				classes = {
					uiPage: "ui-page",
					/**
					 * Indicates active page
					 * @style ui-page-active
					 * @member ns.widget.core.Page
					 */
					uiPageActive: "ui-page-active",
					uiSection: "ui-section",
					uiHeader: "ui-header",
					uiMore: "ui-more",
					uiHeaderOnlyMoreButton: "ui-header-has-only-more-button",
					uiFooter: "ui-footer",
					uiContent: "ui-content",
					uiTitle: "ui-title",
					uiPageScroll: "ui-scroll-on",
					uiScroller: "ui-scroller",
					uiContentUnderPopup: "ui-content-under-popup"
				},
				HEADER_SELECTOR = "header,[data-role='header'],." + classes.uiHeader,
				FOOTER_SELECTOR = "footer,[data-role='footer'],." + classes.uiFooter,
				//ui-indexscrollbar is needed as widget ads html markup at the
				//same level as content, other wise page content is build on
				//indexscrollbar element
				CONTENT_SELECTOR = "[data-role='content'],." + classes.uiContent,
				ONLY_CHILD_MORE_BUTTON_SELECTOR = "." + classes.uiMore + ":first-child:last-child",
				prototype = new BaseWidget();

			Page.classes = classes;
			Page.events = EventType;

			/**
			 * Configure default options for widget
			 * @method _configure
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._configure = function () {
				var options = this.options;
				/**
				 * Object with default options
				 * @property {Object} options
				 * @property {boolean|string|null} [options.header=false] Sets content of header.
				 * @property {boolean|string|null} [options.footer=false] Sets content of footer.
				 * @property {boolean} [options.autoBuildWidgets=false] Automatically build widgets inside page.
				 * @property {string} [options.content=null] Sets content of popup.
				 * @member ns.widget.core.Page
				 * @static
				 */

				options.header = null;
				options.footer = null;
				options.content = null;
				options.enablePageScroll = ns.getConfig("enablePageScroll");
				options.autoBuildWidgets = ns.getConfig("autoBuildOnPageChange");
				this.options = options;
			};

			/**
			 * Setup size of element to 100% of screen
			 * @method _contentFill
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._contentFill = function () {
				var self = this,
					element = self.element,
					screenWidth = window.innerWidth,
					screenHeight = window.innerHeight,
					elementStyle = element.style,
					ui = self._ui,
					content = ui.content,
					contentStyle,
					header = ui.header,
					top = 0,
					bottom = 0,
					footer = ui.footer;

				elementStyle.width = screenWidth + "px";
				elementStyle.height = screenHeight + "px";

				if (content && !element.classList.contains("ui-page-flex")) {
					contentStyle = content.style;
					
					if (header) {
						top = utilsDOM.getElementHeight(header);
					}

					if (footer) {
						bottom = footer.getBoundingClientRect().height;
						contentStyle.marginBottom = bottom + "px";
						contentStyle.paddingBottom = (-bottom) + "px";
					}

					if (!self.options.enablePageScroll) {
						contentStyle.height = (screenHeight - top - bottom) + "px";
					}
				}

				if (self.options.model) {
					self._fillContentsFromModel();
				}
			};

			prototype._fillContentsFromModel = function () {
				var self = this,
					model = self.options.model || {},
					data = model;

				Object.keys(data).forEach(function (key) {
					[].slice.call(self.element.querySelectorAll("[data-bind='" + key + "']"))
						.forEach(function (elem) {
							elem.textContent = data[key];
						});
				});
			}

			prototype._storeContentStyle = function () {
				var self = this,
					initialContentStyle = self._initialContentStyle,
					contentStyleAttributes = self._contentStyleAttributes,
					content = self.element.querySelector("." + classes.uiContent),
					contentStyle = content ? content.style : {};

				contentStyleAttributes.forEach(function (name) {
					initialContentStyle[name] = contentStyle[name];
				});
			};

			/**
			 * Restore saved styles for content.
			 * Called on refresh or hide.
			 * @protected
			 */
			prototype._restoreContentStyle = function () {
				var self = this,
					initialContentStyle = self._initialContentStyle,
					contentStyleAttributes = self._contentStyleAttributes,
					content = self.element.querySelector("." + classes.uiContent),
					contentStyle = content ? content.style : {};

				contentStyleAttributes.forEach(function (name) {
					contentStyle[name] = initialContentStyle[name];
				});
			};

			/**
			 * Setter for footer option
			 * @method _setFooter
			 * @param {HTMLElement} element
			 * @param {string} value
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._setFooter = function (element, value) {
				var self = this,
					ui = self._ui,
					footer = ui.footer;

				// footer element if footer does not exist and value is true or string
				if (!footer && value) {
					footer = document.createElement("footer");
					element.appendChild(footer);
					ui.footer = footer;
				}
				if (footer) {
					// remove child if footer does not exist and value is set to false
					if (value === false) {
						element.removeChild(footer);
						ui.footer = null;
					} else {
						// if options is set to true, to string or not is set
						// add class
						footer.classList.add(classes.uiFooter);
						// if is string fill content by string value
						if (typeof value === "string") {
							ui.footer.textContent = value;
						}
					}
					// and remember options
					self.options.footer = value;
				}
			};

			/**
			 * Setter for header option
			 * @method _setHeader
			 * @param {HTMLElement} element
			 * @param {string} value
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._setHeader = function (element, value) {
				var self = this,
					ui = self._ui,
					header = ui.header;

				// header element if header does not exist and value is true or string
				if (!header && value) {
					header = document.createElement("header");
					element.appendChild(header);
					ui.header = header;
				}
				if (header) {
					// remove child if header does not exist and value is set to false
					if (value === false) {
						element.removeChild(header);
						ui.header = null;
					} else {
						// if options is set to true, to string or not is set
						// add class
						header.classList.add(classes.uiHeader);
						// if is string fill content by string value
						if (typeof value === "string") {
							ui.header.textContent = value;
						}

						if (ns.support && ns.support.shape && ns.support.shape.circle) {
							// patch for backward compability - if header has only more button
							// (it was common for rectangle devices) header should be marked
							// and take no place at all.
							if (header.querySelector(ONLY_CHILD_MORE_BUTTON_SELECTOR) && header.textContent.trim() === "") {
								header.classList.add(classes.uiHeaderOnlyMoreButton);
							}
						}
					}
					// and remember options
					self.options.header = value;
				}
			};

			/**
			 * Setter for content option
			 * @method _setContent
			 * @param {HTMLElement} element
			 * @param {string} value
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._setContent = function (element, value) {
				var self = this,
					ui = self._ui,
					content = ui.content,
					child = element.firstChild,
					next;

				if (!content && value) {
					content = document.createElement("div");
					while (child) {
						next = child.nextSibling;
						if (child !== ui.footer && child !== ui.header) {
							content.appendChild(child);
						}
						child = next;
					}
					element.insertBefore(content, ui.footer);
					ui.content = content;
				}
				if (content) {
					// remove child if content exist and value is set to false
					if (value === false) {
						element.removeChild(content);
						ui.content = null;
					} else {
						// if options is set to true, to string or not is set
						// add class
						content.classList.add(classes.uiContent);
						// if is string fill content by string value
						if (typeof value === "string") {
							content.textContent = value;
						}
					}
					// and remember options
					self.options.content = value;
				}
			};

			/**
			 * Method creates empty page header. It also checks for additional
			 * content to be added in header.
			 * @method _buildHeader
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._buildHeader = function (element) {
				var self = this;

				self._ui.header = utilSelectors.getChildrenBySelector(element, HEADER_SELECTOR)[0] || null;
				if (self.options.header === undefined) {
					self.options.header = !!self._ui.header;
				}
				self._setHeader(element, self.options.header);
			};

			/**
			 * Method creates empty page footer.
			 * @method _buildFooter
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._buildFooter = function (element) {
				var self = this;

				self._ui.footer = utilSelectors.getChildrenBySelector(element, FOOTER_SELECTOR)[0] || null;
				if (self.options.footer === undefined) {
					self.options.footer = !!self._ui.footer;
				}
				self._setFooter(element, self.options.footer);
			};

			/**
			 * Method creates empty page content.
			 * @method _buildContent
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._buildContent = function (element) {
				var self = this;

				self._ui.content = utilSelectors.getChildrenBySelector(element, CONTENT_SELECTOR)[0] || null;
				if (self.options.content === undefined) {
					self.options.content = !!self._ui.content;
				}
				self._setContent(element, self.options.content);
			};


			/**
			 * Set ARIA attributes on page structure
			 * @method _setAria
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._setAria = function () {
				var self = this,
					ui = self._ui,
					content = ui.content,
					header = ui.header,
					footer = ui.footer,
					title = ui.title;

				if (content) {
					content.setAttribute("role", "main");
				}

				if (header) {
					header.setAttribute("role", "header");
				}

				if (footer) {
					footer.setAttribute("role", "footer");
				}

				if (title) {
					title.setAttribute("role", "heading");
					title.setAttribute("aria-level", 1);
					title.setAttribute("aria-label", "title");
				}
			};

			/**
			 * Find title of page
			 * @param {HTMLElement} element
			 * @method _setTitle
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._setTitle = function (element) {
				var self = this,
					dataPageTitle = utilsDOM.getNSData(element, "title"),
					header = self._ui.header,
					pageTitle = dataPageTitle,
					titleElements,
					mainTitleElement;

				if (header) {
					titleElements = utilSelectors.getChildrenBySelector(header, "h1, h2, h3, h4, h5, h6");

					mainTitleElement = titleElements[0];

					if (!pageTitle && mainTitleElement) {
						pageTitle = mainTitleElement.innerText;
						self._ui.title = mainTitleElement;
					}

					if (!dataPageTitle && pageTitle) {
						utilsDOM.setNSData(element, "title", pageTitle);
					}

					arrayUtil.forEach(titleElements, function (titleElement) {
						titleElement.classList.add(classes.uiTitle)
					});
				}
			};

			/**
			 * Build page
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._build = function (element) {
				var self = this;

				element.classList.add(classes.uiPage);
				self._buildHeader(element);
				self._buildFooter(element);
				self._buildContent(element);
				self._setTitle(element);
				self._setAria();

				//it means that we are in wearable profile and we want to make a scrollview on page element (not content)
				if (self.options.enablePageScroll === true && !element.querySelector("." + classes.uiScroller)) {
					engine.instanceWidget(element, "Scrollview");
				}
				return element;
			};


			/**
			 * This method sets page active or inactive.
			 *
			 *    @example
			 *    <div id="myPage"></div>
			 *    <script type="text/javascript">
			 *      var page = tau.widget.Page(document.getElementById("myPage"));
			 *      page.setActive(true);
			 *    </script>
			 *
			 * @method setActive
			 * @param {boolean} [value=true] If true, then page will be active. Otherwise, page will be inactive.
			 * @member ns.widget.core.Page
			 */
			prototype.setActive = function (value) {
				var elementClassList = this.element.classList;

				if (value || value === undefined) {
					this.focus();
					elementClassList.add(classes.uiPageActive);
				} else {
					this.blur();
					elementClassList.remove(classes.uiPageActive);
				}
			};

			/**
			 * Return current status of page.
			 * @method isActive
			 * @member ns.widget.core.Page
			 * @instance
			 */
			prototype.isActive = function () {
				return this.element.classList.contains(classes.uiPageActive);
			};

			/**
			 * Sets the focus to page
			 * @method focus
			 * @member ns.widget.core.Page
			 */
			prototype.focus = function () {
				var element = this.element,
					focusable = element.querySelector("[autofocus]") || element;

				focusable.focus();
			};

			/**
			 * Removes focus from page and all descendants
			 * @method blur
			 * @member ns.widget.core.Page
			 */
			prototype.blur = function () {
				var element = this.element,
					focusable = document.activeElement || element;

				focusable.blur();
			};

			/**
			 * Bind events to widget
			 * @method _bindEvents
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._bindEvents = function () {
				var self = this;

				self._contentFillAfterResizeCallback = self._contentFill.bind(self);
				window.addEventListener("resize", self._contentFillAfterResizeCallback, false);
			};

			/**
			 * Refresh widget structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._refresh = function () {
				this._restoreContentStyle();
				this._contentFill();
			};

			/**
			 * Layouting page structure
			 * @method layout
			 * @internal
			 * @member ns.widget.core.Page
			 */
			prototype.layout = function () {
				this._storeContentStyle();
				this._contentFill();
			};

			/**
			 * This method triggers BEFORE_SHOW event.
			 * @method onBeforeShow
			 * @internal
			 * @member ns.widget.core.Page
			 */
			prototype.onBeforeShow = function () {
				var self = this;

				if (typeof self.enableKeyboardSupport === "function") {
					self.enableKeyboardSupport();
					// add keyboard events
					self._bindEventKey();
				}
				self.trigger(EventType.BEFORE_SHOW);
			};

			/**
			 * This method triggers SHOW event.
			 * @method onShow
			 * @internal
			 * @member ns.widget.core.Page
			 */
			prototype.onShow = function () {
								this.trigger(EventType.SHOW);
			};

			/**
			 * This method triggers BEFORE_HIDE event.
			 * @method onBeforeHide
			 * @internal
			 * @member ns.widget.core.Page
			 */
			prototype.onBeforeHide = function () {
				var self = this;

				if (typeof self.disableKeyboardSupport === "function") {
					self.disableKeyboardSupport();
					// remove keyboard events
					self._destroyEventKey();
				}
				self.trigger(EventType.BEFORE_HIDE);
			};

			/**
			 * This method triggers HIDE event.
			 * @method onHide
			 * @internal
			 * @member ns.widget.core.Page
			 */
			prototype.onHide = function () {
				this._restoreContentStyle();
				this.trigger(EventType.HIDE);
			};

			/**
			 * Destroy widget
			 * @method _destroy
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Page
			 */
			prototype._destroy = function (element) {
				var self = this;

				element = element || self.element;
				
				window.removeEventListener("resize", self._contentFillAfterResizeCallback, false);
				// destroy widgets on children
				engine.destroyAllWidgets(element, true);

				self._contentFillAfterResizeCallback = null;
			};

			/**
			 * Return scroller
			 * @method getScroller
			 * @member ns.widget.core.Page
			 */
			prototype.getScroller = function () {
				var element = this.element,
					scroller = element.querySelector("." + classes.uiScroller);

				return scroller || element.querySelector("." + classes.uiContent) || element;
			};

			Page.prototype = prototype;

			Page.createEmptyElement = function () {
				var div = document.createElement("div");

				div.classList.add(classes.uiPage);
				return div;
			};

			engine.defineWidget(
				"Page",
				"[data-role=page],.ui-page",
				[
					"focus",
					"blur",
					"setActive"
				],
				Page,
				// for register in jQuery Mobile space
				"mobile"
			);

			ns.widget.core.Page = Page;
			}(window.document, ns));
/**
 * #Footer
 *
 * ## Creating footer
 *
 *    @example template
 *      <footer class="ui-footer"></footer>
 *
 * @class ns.widget.core.Footer
 * @component-selector .ui-page > footer, .ui-page .ui-footer
 * @component-type layout-component
 * @extends ns.widget.BaseWidget
 *
 */

/**
 * #Header
 *
 *    @example template
 *      <header class="ui-header"><h2 class="ui-title">Header</h2></header>
 *
 * @class ns.widget.core.Header
 * @component-selector .ui-page > header, .ui-page > .ui-header
 * @component-type layout-component
 * @extends ns.widget.BaseWidget
 */
/**
 * Button for menu with icon in header
 * @style ui-more
 * @selector .ui-btn
 * @member ns.widget.core.Header
 * @wearable
 * @since 2.3.1
 */
/**
 * Icon style for menu button
 * @style ui-icon-detail
 * @selector .ui-btn.ui-more
 * @member ns.widget.core.Header
 * @wearable
 * @since 2.3.1
 */
/**
 * Icon style for menu button
 * @style ui-icon-overflow
 * @selector .ui-btn.ui-more
 * @member ns.widget.core.Header
 * @wearable
 * @since 2.3.1
 */
/**
 * Icon style for menu button
 * @style ui-icon-selectall
 * @selector .ui-btn.ui-more
 * @member ns.widget.core.Header
 * @wearable
 * @since 2.3.1
 */

/**
 * #Content
 *
 *    @example template
 *      <div class="ui-content"></div>
 *
 * @class ns.widget.core.Content
 * @component-selector .ui-content
 * @component-type container-component
 * @component-constraint 'bottom-button', 'checkbox', 'listview', 'processing', 'closet-tau-circle-progress', 'radio', 'toggleswitch', 'text', 'closet-image', 'sectionchanger'
 * @extends ns.widget.BaseWidget
 */
/**
 * Defines the buttons inside column width as 100% of the screen
 * @style ui-grid-col-1
 * @selector div:not(.ui-grid-col-1):not(.ui-grid-col-2):not(.ui-grid-col-3):not(.ui-grid-row)
 * @member ns.widget.core.Content
 * @wearable
 * @since 2.3.1
 */
/**
 * Defines the buttons inside column width as 50% of the screen
 * @style ui-grid-col-2
 * @selector div:not(.ui-grid-col-1):not(.ui-grid-col-2):not(.ui-grid-col-3):not(.ui-grid-row)
 * @member ns.widget.core.Content
 * @wearable
 * @since 2.3.1
 */
/**
 * Defines the buttons inside column width as 50% of the screen
 * @style ui-grid-col-3
 * @selector div:not(.ui-grid-col-1):not(.ui-grid-col-2):not(.ui-grid-col-3):not(.ui-grid-row)
 * @member ns.widget.core.Content
 * @wearable
 * @since 2.3.1
 */
/**
 * Arranges the buttons inside in a row
 * @style ui-grid-row
 * @selector div:not(.ui-grid-col-1):not(.ui-grid-col-2):not(.ui-grid-col-3):not(.ui-grid-row)
 * @member ns.widget.core.Content
 * @wearable
 * @since 2.3.1
 */
;
/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * # PageContainer Widget
 * PageContainer is a widget, which is supposed to have multiple child pages but display only one at a time.
 *
 * @class ns.widget.core.PageContainer
 * @extends ns.widget.BaseWidget
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Krzysztof Głodowski <k.glodowski@samsung.com>
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				util = ns.util,
				DOM = util.DOM,
				engine = ns.engine,
				classes = {
					pageContainer: "ui-page-container",
					uiViewportTransitioning: "ui-viewport-transitioning",
					out: "out",
					in: "in",
					reverse: "reverse",
					uiPreIn: "ui-pre-in",
					uiBuild: "ui-page-build"
				},
				PageContainer = function () {
					/**
					 * Active page.
					 * @property {ns.widget.core.Page} [activePage]
					 * @member ns.widget.core.PageContainer
					 */
					this.activePage = null;
					this.inTransition = false;
				},
				EventType = {
					/**
					 * Triggered before the changePage() request
					 * has started loading the page into the DOM.
					 * @event pagebeforechange
					 * @member ns.widget.core.PageContainer
					 */
					PAGE_BEFORE_CHANGE: "pagebeforechange",
					/**
					 * Triggered after the changePage() request
					 * has finished loading the page into the DOM and
					 * all page transition animations have completed.
					 * @event pagechange
					 * @member ns.widget.core.PageContainer
					 */
					PAGE_CHANGE: "pagechange",
					PAGE_REMOVE: "pageremove"
				},
				animationend = "animationend",
				webkitAnimationEnd = "webkitAnimationEnd",
				mozAnimationEnd = "mozAnimationEnd",
				msAnimationEnd = "msAnimationEnd",
				oAnimationEnd = "oAnimationEnd",
				animationEndNames = [
					animationend,
					webkitAnimationEnd,
					mozAnimationEnd,
					msAnimationEnd,
					oAnimationEnd
				],
				prototype = new BaseWidget();
			//When resolved deferred function is responsible for triggering events related to page change as well as
			//destroying unused widgets from last page and/or removing last page

			function deferredFunction(fromPageWidget, toPageWidget, self, options) {
				if (fromPageWidget) {
					fromPageWidget.onHide();
					self._removeExternalPage(fromPageWidget, options);
				}
				toPageWidget.onShow();
								self.trigger(EventType.PAGE_CHANGE);
							}

			/**
			 * Dictionary for PageContainer related event types.
			 * @property {Object} events
			 * @property {string} [events.PAGE_CHANGE="pagechange"]
			 * @member ns.router.route.popup
			 * @static
			 */
			PageContainer.events = EventType;

			/**
			 * Dictionary for PageContainer related css class names
			 * @property {Object} classes
			 * @member ns.widget.core.Page
			 * @static
			 * @readonly
			 */
			PageContainer.classes = classes;

			/**
			 * Build widget structure
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._build = function (element) {
				element.classList.add(classes.pageContainer);
				return element;
			};

			/**
			 * This method changes active page to specified element.
			 * @method change
			 * @param {HTMLElement} toPageElement The element to set
			 * @param {Object} [options] Additional options for the transition
			 * @param {string} [options.transition=none] Specifies the type of transition
			 * @param {boolean} [options.reverse=false] Specifies the direction of transition
			 * @member ns.widget.core.PageContainer
			 */
			prototype.change = function (toPageElement, options) {
				var self = this,
					fromPageWidget = self.getActivePage(),
					toPageWidget,
					calculatedOptions = options || {};

				// store options to detect that option was changed before process finish
				self._options = calculatedOptions;

				calculatedOptions.widget = calculatedOptions.widget || "Page";

				// The change should be made only if no active page exists
				// or active page is changed to another one.
				if (!fromPageWidget || (fromPageWidget.element !== toPageElement)) {
					if (toPageElement.parentNode !== self.element) {
						toPageElement = self._include(toPageElement);
					}

					self.trigger(EventType.PAGE_BEFORE_CHANGE);

					toPageElement.classList.add(classes.uiBuild);

					toPageWidget = engine.instanceWidget(toPageElement, calculatedOptions.widget, options);

					// set sizes of page for correct display
					toPageWidget.layout();

					if (toPageWidget.option("autoBuildWidgets") || toPageElement.querySelector('.ui-i3d')) {
						engine.createWidgets(toPageElement, options);
					}

					if (fromPageWidget) {
						fromPageWidget.onBeforeHide();
					}
					toPageWidget.onBeforeShow();

					toPageElement.classList.remove(classes.uiBuild);

					// if options is different that this mean that another change page was called and we need stop
					// previous change page
					if (calculatedOptions === self._options) {
						calculatedOptions.deferred = {
							resolve: deferredFunction
						};
						self._transition(toPageWidget, fromPageWidget, calculatedOptions);
					}
				}
			};

			/**
			 * This method performs transition between the old and a new page.
			 * @method _transition
			 * @param {ns.widget.core.Page} toPageWidget The new page
			 * @param {ns.widget.core.Page} fromPageWidget The page to be replaced
			 * @param {Object} [options] Additional options for the transition
			 * @param {string} [options.transition=none] The type of transition
			 * @param {boolean} [options.reverse=false] Specifies transition direction
			 * @param {Object} [options.deferred] Deferred object
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._transition = function (toPageWidget, fromPageWidget, options) {
				var self = this,
					element = self.element,
					elementClassList = element.classList,
					transition = !fromPageWidget || !options.transition ? "none" : options.transition,
					deferred = options.deferred,
					clearClasses = [classes.in, classes.out, classes.uiPreIn, transition],
					oldDeferredResolve,
					oneEvent;

				if (options.reverse) {
					clearClasses.push(classes.reverse);
				}
				self.inTransition = true;
				elementClassList.add(classes.uiViewportTransitioning);
				oldDeferredResolve = deferred.resolve;
				deferred.resolve = function () {
					var fromPageWidgetClassList = fromPageWidget && fromPageWidget.element.classList,
						toPageWidgetClassList = toPageWidget.element.classList;

					self._setActivePage(toPageWidget);
					self._clearTransitionClasses(clearClasses, fromPageWidgetClassList, toPageWidgetClassList);
					oldDeferredResolve(fromPageWidget, toPageWidget, self, options);
				};

				if (transition !== "none") {
					oneEvent = function () {
						toPageWidget.off(
							animationEndNames,
							oneEvent,
							false
						);
						deferred.resolve();
					};
					toPageWidget.on(
						animationEndNames,
						oneEvent,
						false
					);
					self._appendTransitionClasses(fromPageWidget, toPageWidget, transition, options.reverse);
				} else {
					window.setTimeout(deferred.resolve, 0);
				}
			};

			/**
			 * This method adds proper transition classes to specified page widgets.
			 * @param {ns.widget.core.Page} fromPageWidget Page widget from which transition will occur
			 * @param {ns.widget.core.Page} toPageWidget Destination page widget for transition
			 * @param {string} transition Specifies the type of transition
			 * @param {boolean} reverse Specifies the direction of transition
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._appendTransitionClasses = function (fromPageWidget, toPageWidget, transition, reverse) {
				var classList;

				if (fromPageWidget) {
					classList = fromPageWidget.element.classList;
					classList.add(transition, classes.out);
					if (reverse) {
						classList.add(classes.reverse);
					}
				}

				classList = toPageWidget.element.classList;
				classList.add(transition, classes.in, classes.uiPreIn);
				if (reverse) {
					classList.add(classes.reverse);
				}
			};

			/**
			 * This method removes transition classes from classLists of page widget elements.
			 * @param {Object} clearClasses An array containing classes to be removed
			 * @param {Object} fromPageWidgetClassList classList object from source page element
			 * @param {Object} toPageWidgetClassList classList object from destination page element
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._clearTransitionClasses = function (clearClasses, fromPageWidgetClassList, toPageWidgetClassList) {
				var self = this,
					element = self.element,
					elementClassList = element.classList;

				elementClassList.remove(classes.uiViewportTransitioning);
				self.inTransition = false;
				clearClasses.forEach(function (className) {
					toPageWidgetClassList.remove(className);
				});
				if (fromPageWidgetClassList) {
					clearClasses.forEach(function (className) {
						fromPageWidgetClassList.remove(className);
					});
				}
			};

			/**
			 * This method adds an element as a page.
			 * @method _include
			 * @param {HTMLElement} page an element to add
			 * @return {HTMLElement}
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._include = function (page) {
				var element = this.element;

				if (!page.parentNode || page.ownerDocument !== document) {
					page = util.importEvaluateAndAppendElement(page, element);
				}
				return page;
			};

			/**
			 * This method sets currently active page.
			 * @method _setActivePage
			 * @param {ns.widget.core.Page} page a widget to set as the active page
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._setActivePage = function (page) {
				var self = this;

				if (self.activePage) {
					self.activePage.setActive(false);
				}

				self.activePage = page;

				page.setActive(true);
			};

			/**
			 * This method returns active page widget.
			 * @method getActivePage
			 * @member ns.widget.core.PageContainer
			 * @return {ns.widget.core.Page} Currently active page
			 */
			prototype.getActivePage = function () {
				return this.activePage;
			};

			/**
			 * This method removes page element from the given widget and destroys it.
			 * @method _removeExternalPage
			 * @param {ns.widget.core.Page} fromPageWidget the widget to destroy
			 * @param {Object} [options] transition options
			 * @param {boolean} [options.reverse=false] specifies transition direction
			 * @member ns.widget.core.PageContainer
			 * @protected
			 */
			prototype._removeExternalPage = function (fromPageWidget, options) {
				var fromPageElement = fromPageWidget.element;

				if (options && options.reverse && DOM.hasNSData(fromPageElement, "external") &&
					fromPageElement.parentNode) {
					fromPageWidget.destroy();
					fromPageElement.parentNode.removeChild(fromPageElement);
					this.trigger(EventType.PAGE_REMOVE);
				}
			};

			PageContainer.prototype = prototype;

			// definition
			ns.widget.core.PageContainer = PageContainer;

			engine.defineWidget(
				"pagecontainer",
				"",
				["change", "getActivePage"],
				PageContainer,
				"core"
			);
			}(window.document, ns));

/*global define, ns */
/*jslint nomen: true, plusplus: true, bitwise: false */
/*
 * Copyright (c) 2010 - 2014 Samsung Electronics Co., Ltd.
 * License : MIT License V2
 */
/**
 * #Template Manager
 *
 * Object menage template's engines and renderer HTMLElement by template engine.
 *
 * @class ns.template
 * @since 2.4
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 */
(function () {
	"use strict";
				var utilPath = ns.util.path,
				template,
				templateFunctions = {},
				globalOptions = {
					"pathPrefix": "",
					"default": ""
				};

			/**
			 * Function to get global option
			 *
			 *	@example
			 *		tau.template.get("pathPrefix");
			 *		// -> "/prefix/to/all/paths"
			 *
			 * @method get
			 * @param {string} name param name which will be return
			 * @return {*} return value of option
			 * @since 2.4
			 * @member ns.template
			 */
			function get(name) {
				return globalOptions[name];
			}

			/**
			 * Function to set global option
			 *
			 *	@example
			 *		tau.template.set("pathPrefix", "/views");
			 *
			 * @method set
			 * @param {string} name param name which will be set
			 * @param {*} value value to set
			 * @since 2.4
			 * @member ns.template
			 */
			function set(name, value) {
				globalOptions[name] = value;
			}

			/**
			 * Register new template function
			 *
			 * Template function should have 4 arguments:
			 *
			 *  - globalOptions - global options of template engine
			 *  - path - path or id of template content
			 *  - data - data for template render
			 *  - callback - callback call on finish
			 *
			 * and should call callback on finish with arguments:
			 *
			 *  - status - object describing status of render
			 *  - element - base HTMLElement of template results (on error can be null)
			 *
			 * after registration you can use engine in render function.
			 *
			 *	@example
			 *		tau.template.register("inline", function(globalOptions, path, data, callback) {
			 *			callback({
			 *						success: true
			 *					},
			 *					document.createElement("div")
			 *				);
			 *		});
			 *
			 * @method register
			 * @param {string} name Engine name
			 * @param {Function} templateFunction function to renderer template
			 * @since 2.4
			 * @member ns.template
			 */
			function register(name, templateFunction) {
				templateFunctions[name] = templateFunction;
			}

			/**
			 * Unregister template function
			 *
			 * @method unregister
			 * @param {string} name Engine name
			 * @since 2.4
			 * @member ns.template
			 */
			function unregister(name) {
				templateFunctions[name] = null;
			}

			/**
			 * Return engine with given name
			 *
			 * @method engine
			 * @param {string} name Engine name
			 * @since 2.4
			 * @member ns.template
			 */
			function engine(name) {
				return templateFunctions[name];
			}

			/**
			 * Create absolute path for given path.
			 * If parameter withProfile is true, the returned path will have name of profile
			 * separated by dots before the last dot.
			 * @method getAbsUrl
			 * @param {string} path
			 * @param {boolean} withProfile Create path with profile's name
			 * @return {string} changed path
			 * @since 2.4
			 */
			function getAbsUrl(path, withProfile) {
				var profile = ns.info.profile,
					lastDot = path.lastIndexOf(".");

				if (utilPath.isAbsoluteUrl(path)) {
					return path;
				}

				if (withProfile) {
					path = path.substring(0, lastDot) + "." + profile + path.substring(lastDot);
				}

				return utilPath.makeUrlAbsolute((globalOptions.pathPrefix || "") + path, utilPath.getLocation());
			}

			/**
			 * Return HTMLElement for given path
			 *
			 * When engine name is not given then get default name from global options. If this is not set then get first registered engine.
			 *
			 * Result of this method is handed to callback. First parameter of callback is object with status. Second is HTMLElement generated by engine.
			 *
			 * Status object contains properties:
			 *
			 *  - _boolean_ success - inform about success or error
			 *  - _string_ description contains details on error
			 *
			 *	@example
			 *		tau.template.render("external/path/to/file.html", {additionalParameter: true}, function(status, element) {
			 *			if (status.success) {
			 *				document.body.appendChild(element);
			 *			} else {
			 *				console.error(status.description);
			 *			}, "html");
			 *
			 * @method render
			 * @param {string} path Path to file ot other id for template system
			 * @param {Object} data additional data for template system
			 * @param {Function} callback function which will be called on finish
			 * @param {string} [engineName] engine name
			 * @since 2.4
			 * @member ns.template
			 */
			function render(path, data, callback, engineName) {
				var templateFunction = templateFunctions[engineName || get("default") || ""],
					targetCallback = function (status, element) {
						// add current patch
						status.absUrl = targetPath;
						callback(status, element);
					},
					templateCallback = function (status, element) {
						if (status.success) {
							// path was found and callback can be called
							targetCallback(status, element);
						} else {
							// try one more time with path without profile
							targetPath = getAbsUrl(path, false);
							templateFunction(globalOptions, targetPath, data || {}, targetCallback);
						}
					},
					targetPath;

				// if template engine name and default name is not given then we
				// take first registered engine
				if (!templateFunction) {
					templateFunction = templateFunctions[Object.keys(templateFunctions).pop()];
				}

				// if template system exists then we go to him
				if (templateFunction) {
					targetPath = getAbsUrl(path, ns.getConfig("findProfileFile", false));
					templateFunction(globalOptions, targetPath, data || {}, templateCallback);
				} else {
					// else we return error
					callback({
						success: false,
						description: "Can't get engine system"
					}, null);
				}
			}

			template = {
				get: get,
				set: set,
				register: register,
				unregister: unregister,
				engine: engine,
				render: render
			};

			ns.template = template;
			}());

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* global define, HTMLElement, ns */
/**
 * #Router
 *
 * Main class to navigate between pages, popups and other widgets which has own rules in all profiles.
 *
 * Class communicates with PageContainer which deactivate and activate changed pages.
 *
 * Router listening on events triggered by history manager.
 *
 * ## Getting instance
 *
 * To receive instance of router you should use method _getInstance_
 *
 * 	@example
 * 		var router = ns.router.Router.getInstance();
 *
 * By default TAU create instance of router and getInstance method return this instance.
 *
 * ##Connected widgets
 *
 * Router cooperate with widgets:
 *
 *  - Page
 *  - Popup
 *  - Drawer
 *  - Dialog (mobile)
 *  - CircularIndexScrollBar (wearable - circle)
 *
 * Opening or closing these widgets are possible by create link with correct rel.
 *
 * ##Global options used in router
 *
 *  - *pageContainer* = document.body - default container element
 *  - *pageContainerBody* = false - use body instead pageContainer option
 *  - *autoInitializePage* = true - automatically initialize first page
 *  - *addPageIfNotExist* = true - automatically add page if doesn't exist
 *  - *loader* = false - enable loader on change page
 *  - *disableRouter* = false - disable auto initialize of router
 *
 * @class ns.router.Router
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Tomasz Lukawski <t.lukawski@samsung.com>
 * @author Hyunkook, Cho <hk0713.cho@samsung.com>
 * @author Piotr Czajka <p.czajka@samsung.com>
 * @author Junhyeon Lee <juneh.lee@samsung.com>
 * @author Michał Szepielak <m.szepielak@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Heeju Joo <heeju.joo@samsung.com>
 */
(function (window, document) {
	"use strict";
				/**
			 * Local alias for ns.util
			 * @property {Object} util Alias for {@link ns.util}
			 * @member ns.router.Router
			 * @static
			 * @private
			 */
			var util = ns.util,
				/**
				 * Local alias for ns.event
				 * @property {Object} eventUtils Alias for {@link ns.event}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				eventUtils = ns.event,
				/**
				 * Alias for {@link ns.util.DOM}
				 * @property {Object} DOM
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				DOM = util.DOM,
				/**
				 * Local alias for ns.util.path
				 * @property {Object} path Alias for {@link ns.util.path}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				path = util.path,
				/**
				 * Local alias for ns.util.selectors
				 * @property {Object} selectors Alias for {@link ns.util.selectors}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				selectors = util.selectors,
				/**
				 * Local alias for ns.util.object
				 * @property {Object} object Alias for {@link ns.util.object}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				object = util.object,
				/**
				 * Local alias for ns.engine
				 * @property {Object} engine Alias for {@link ns.engine}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				engine = ns.engine,
				/**
				 * Local alias for ns.router
				 * @property {Object} router Alias for namespace ns.router
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				router = ns.router,
				/**
				 * Local alias for ns.history
				 * @property {Object} history Alias for {@link ns.history}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				history = ns.history,
				historyManager = history.manager,
				/**
				 * Local alias for ns.history.manager.events
				 * @property {Object} historyManagerEvents Alias for (@link ns.history.manager.events}
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				historyManagerEvents = historyManager.events,
				/**
				 * Local alias for ns.router.route
				 * @property {Object} route Alias for namespace ns.router.route
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				route = router.route,
				/**
				 * Local alias for document body element
				 * @property {HTMLElement} body
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				body = document.body,
				/**
				 * Alias to Array.slice method
				 * @method slice
				 * @member ns.router.Router
				 * @private
				 * @static
				 */
				slice = [].slice,
				/**
				 * Local instance of the Router
				 * @property {Object} routerInstance
				 * @member ns.router.Router
				 * @static
				 * @private
				 */
				_isLock = false,

				ORDER_NUMBER = {
					1: "page",
					10: "panel",
					100: "popup",
					101: "dialog",
					1000: "drawer",
					2000: "circularindexscrollbar"
				},

				eventType = {
					BEFORE_ROUTER_INIT: "beforerouterinit",
					ROUTER_INIT: "routerinit"
				},

				HASH_REGEXP = /[#|\s]/g,

				Page = ns.widget.core.Page,

				routerInstance,

				template = ns.template,

				Router = function () {
					var self = this;

					/**
					 * Instance of widget PageContainer which controls page changing.
					 * @property {?ns.widget.core.PageContainer} [container=null]
					 * @member ns.router.Router
					 */
					self.container = null;
					/**
					 * Settings for last call of method open
					 * @property {Object} [settings={}]
					 * @member ns.router.Router
					 */
					self.settings = {};

					/**
					 * Handler for event "statechange"
					 * @property {Function} [_onStateChangeHandler=null]
					 * @member ns.router.Router
					 * @protected
					 * @since 2.4
					 */
					self._onStateChangeHandler = null;
					/**
					 * Handler for event "hashchange"
					 * @property {Function} [_onHashChangeHandler=null]
					 * @member ns.router.Router
					 * @protected
					 * @since 2.4
					 */
					self._onHashChangeHandler = null;
					/**
					 * Handler for event "controllercontent"
					 * @property {Function} [_onControllerContent=null]
					 * @member ns.router.Router
					 * @protected
					 * @since 2.4
					 */
					self._onControllerContent = null;

					/**
					 * Router locking flag
					 * @property {boolean} locked=false
					 * @member ns.router.Router
					 * @since 2.4
					 */
					self.locked = false;
				};

			/**
			 * Default values for router
			 * @property {Object} defaults
			 * @property {boolean} [defaults.fromHashChange=false] Sets if will be changed after hashchange.
			 * @property {boolean} [defaults.reverse=false] Sets the direction of change.
			 * @property {boolean} [defaults.volatileRecord=false] Sets if the current history entry will be modified or a new one will be created.
			 * @member ns.router.Router
			 */
			Router.prototype.defaults = {
				fromHashChange: false,
				reverse: false,
				volatileRecord: false
			};

			/**
			 * Find the closest link for element
			 * @method findClosestLink
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @private
			 * @static
			 * @member ns.router.Router
			 */
			function findClosestLink(element) {
				while (element) {
					if (element.nodeType === Node.ELEMENT_NODE && element.nodeName && element.nodeName === "A") {
						break;
					}
					element = element.parentNode;
				}
				return element;
			}

			/**
			 * Handle event link click
			 * @method linkClickHandler
			 * @param {ns.router.Router} router
			 * @param {Event} event
			 * @private
			 * @static
			 * @member ns.router.Router
			 */
			function linkClickHandler(router, event) {
				var link = findClosestLink(event.target),
					href,
					useDefaultUrlHandling,
					options;

				if (link && event.which === 1) {
					href = link.getAttribute("href");
					useDefaultUrlHandling = (link.getAttribute("rel") === "external") || link.hasAttribute("target");
					if (!useDefaultUrlHandling) {
						options = DOM.getData(link);
						router.open(href, options, event);
						eventUtils.preventDefault(event);
					}
				}
			}

			Router.prototype.linkClick = function (event) {
				linkClickHandler(this, event);
			};

			function openUrlFromState(instanceRouter, state) {
				var rules = router.route,
					prevState = history.activeState,
					reverse = state && history.getDirection(state) === "back",
					maxOrderNumber,
					orderNumberArray = [],
					ruleKey,
					options,
					url = path.getLocation(),
					isContinue = true,
					transition,
					rule;

				transition = reverse ? ((prevState && prevState.transition) || "none") : state.transition;
				options = object.merge({}, state, {
					reverse: reverse,
					transition: transition,
					fromHashChange: true
				});

				// find rule with max order number
				for (ruleKey in rules) {
					if (rules.hasOwnProperty(ruleKey) && rules[ruleKey].active) {
						orderNumberArray.push(rules[ruleKey].orderNumber);
					}
				}
				maxOrderNumber = Math.max.apply(null, orderNumberArray);
				rule = rules[ORDER_NUMBER[maxOrderNumber]];

				if (rule && rule.onHashChange(url, options, prevState)) {
					if (maxOrderNumber === 10) {
						// rule is panel
						return;
					}
					isContinue = false;
				}

				history.setActive(state);
				if (isContinue) {
					instanceRouter.open(state.url, options);
				}
			}

			/**
			 * Detect rel attribute from HTMLElement.
			 *
			 * This method tries to match element to each rule filter and return first rule name which match.
			 *
			 * If don't match any rule then return null.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.detectRel(document.getElementById("pageId"));
			 *		// if HTML element will be match to selector of page then return rule for page
			 *
			 * @param {HTMLElement} to element to check
			 * @member ns.router.Router
			 * @return {?string}
			 */
			Router.prototype.detectRel = function (to) {
				var rule,
					i;

				for (i in route) {
					if (route.hasOwnProperty(i)) {
						rule = route[i];
						if (selectors.matchesSelector(to, rule.filter)) {
							return i;
						}
					}
				}

				return null;
			};


			/**
			 * Open given page with deferred
			 * @method _openDeferred
			 * @param {HTMLElement} to HTMLElement of page
			 * @param {Object} [options]
			 * @param {"page"|"popup"|"external"} [options.rel = "page"] Represents kind of link as "page"
			 * or "popup"
			 * or "external" for linking to another domain.
			 * @param {string} [options.transition = "none"] Sets the animation used during change of
			 * page.
			 * @param {boolean} [options.reverse = false] Sets the direction of change.
			 * @param {boolean} [options.fromHashChange = false] Sets if will be changed after hashchange.
			 * @param {boolean} [options.volatileRecord = false] Sets if the current history entry will
			 * be modified or
			 * a new one will be created.
			 * @param {boolean} [options.dataUrl] Sets if page has url attribute.
			 * @param {?string} [options.container = null] It is used in RoutePopup as selector for
			 * container.
			 * @param {Event} event
			 * @member ns.router.Router
			 * @protected
			 */
			Router.prototype._openDeferred = function (to, options, event) {
				var self = this,
					rule = route[options.rel],
					deferred = {
						resolve: function (_options, content) {
							rule.open(content, _options, event);
						},
						reject: function (_options) {
							eventUtils.trigger(self.container.element, "changefailed", _options);
						}
					};

				if (typeof to === "string") {
					if (to.replace(HASH_REGEXP, "")) {
						self._loadUrl(to, options, rule, deferred);
					}
				} else {
					// execute deferred object immediately
					if (to && selectors.matchesSelector(to, rule.filter)) {
						deferred.resolve(options, to);
					} else {
						deferred.reject(options);
					}
				}
			};

			/**
			 * Change page to page given in parameter "to".
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.open("pageId");
			 *		// open page with given id
			 *		router.open("page.html");
			 *		// open page from html file
			 *		router.open("popupId");
			 *		// open popup with given id
			 *
			 * @method open
			 * @param {string|HTMLElement} to Id of page or file url or HTMLElement of page
			 * @param {Object} [options]
			 * @param {"page"|"popup"|"external"} [options.rel="page"] Represents kind of link as "page" or "popup" or "external" for linking to another domain.
			 * @param {string} [options.transition="none"] Sets the animation used during change of page.
			 * @param {boolean} [options.reverse=false] Sets the direction of change.
			 * @param {boolean} [options.fromHashChange=false] Sets if will be changed after hashchange.
			 * @param {boolean} [options.volatileRecord=false] Sets if the current history entry will be modified or a new one will be created.
			 * @param {boolean} [options.dataUrl] Sets if page has url attribute.
			 * @param {?string} [options.container=null] It is used in RoutePopup as selector for container.
			 * @param {Event} [event] Event object
			 * @member ns.router.Router
			 */
			Router.prototype.open = function (to, options, event) {
				var self = this,
					rel,
					rule;

				if (!_isLock) {
					to = getHTMLElement(to);
					rel = (options && options.rel) ||
						(to instanceof HTMLElement && self.detectRel(to));
					rel = rel || "page";
					rule = route[rel];

					if (rel === "back") {
						history.back();
					} else if (rule) {
						options = object.merge(
							{
								rel: rel
							},
							self.defaults,
							rule.option(),
							options
						);
						self._openDeferred(to, options, event);
					} else {
						throw new Error("Not defined router rule [" + rel + "]");
					}
				}
			};


			/**
			 * Init routes defined in router
			 * @method _initRoutes
			 * @member ns.router.Router
			 */
			Router.prototype._initRoutes = function () {
				var ruleKey,
					rules = router.route;

				for (ruleKey in rules) {
					if (rules.hasOwnProperty(ruleKey) && rules[ruleKey].init) {
						rules[ruleKey].init();
					}
				}
			};

			function removeActivePageClass(containerElement) {
				var PageClasses = Page.classes,
					uiPageActiveSelector = "." + PageClasses.uiPageActive,
					activePages = slice.call(containerElement.querySelectorAll(uiPageActiveSelector));

				activePages.forEach(function (page) {
					page.classList.remove(uiPageActiveSelector);
				});
			}

			Router.prototype._autoInitializePage = function (containerElement, pages, pageSelector) {
				var self = this,
					page,
					location = window.location,
					uiPageActiveClass = Page.classes.uiPageActive,
					firstPage = containerElement.querySelector("." + uiPageActiveClass);

				if (!firstPage) {
					firstPage = pages[0];
				}

				if (firstPage) {
					removeActivePageClass(containerElement);
				}

				if (location.hash) {
					//simple check to determine if we should show firstPage or other
					page = document.getElementById(location.hash.replace("#", ""));
					if (page && selectors.matchesSelector(page, pageSelector)) {
						firstPage = page;
					}
				}

				if (!firstPage && ns.getConfig("addPageIfNotExist", true)) {
					firstPage = Page.createEmptyElement();
					while (containerElement.firstChild) {
						firstPage.appendChild(containerElement.firstChild);
					}
					containerElement.appendChild(firstPage);
				}

				if (self.justBuild) {
										if (firstPage) {
						self.register(
							engine.instanceWidget(containerElement, "pagecontainer"),
							firstPage
						);
					}
				}

				return firstPage;
			};

			/**
			 * Method initializes page container and builds the first page if flag autoInitializePage is
			 * set.
			 * @method init
			 * @param {boolean} justBuild
			 * @member ns.router.Router
			 */
			Router.prototype.init = function (justBuild) {
				var containerElement,
					firstPage,
					pages,
					pageDefinition = ns.engine.getWidgetDefinition("Page"),
					pageSelector = pageDefinition.selector,
					self = this;

				eventUtils.trigger(document, eventType.BEFORE_ROUTER_INIT, self, false);

				body = document.body;
				self.justBuild = justBuild;

				containerElement = ns.getConfig("pageContainer") || body;
				pages = slice.call(containerElement.querySelectorAll(pageSelector));

				if (!ns.getConfig("pageContainerBody", false)) {
					containerElement = pages.length ? pages[0].parentNode : containerElement;
				}

				if (ns.getConfig("autoInitializePage", true)) {
					firstPage = self._autoInitializePage(containerElement, pages, pageSelector);
					if (justBuild) {
						return;
					}
				}

				historyManager.enable();

				// init router's routes
				self._initRoutes();

				self.register(
					engine.instanceWidget(containerElement, "pagecontainer"),
					firstPage
				);

				eventUtils.trigger(document, eventType.ROUTER_INIT, self, false);
			};

			/**
			 * Method removes all events listeners set by router.
			 *
			 * Also remove singleton instance of router;
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.destroy();
			 *		var router2 = tau.router.Router.getInstance();
			 *		// router !== router2
			 *
			 * @method destroy
			 * @member ns.router.Router
			 */
			Router.prototype.destroy = function () {
				var self = this,
					routePanel = this.getRoute("panel");

				historyManager.disable();

				window.removeEventListener("popstate", self.popStateHandler, false);
				if (routePanel) {
					window.removeEventListener("tauback", routePanel.tauback, false);
				}
				if (body) {
					body.removeEventListener("pagebeforechange", self.pagebeforechangeHandler, false);
					body.removeEventListener("vclick", self.linkClickHandler, false);
				}
				ns.setConfig("pageContainer", null);
			};

			/**
			 * Method sets instance of PageContainer widget
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.setContainer(new ns.widget.PageContainer());
			 *
			 * @method setContainer
			 * @param {ns.widget.core.PageContainer} container
			 * @member ns.router.Router
			 */
			Router.prototype.setContainer = function (container) {
				this.container = container;
			};

			/**
			 * Method returns instance of PageContainer widget
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		containerWidget = router.getContainer();
			 *
			 * @method getContainer
			 * @return {ns.widget.core.PageContainer}
			 * @member ns.router.Router
			 */
			Router.prototype.getContainer = function () {
				return this.container;
			};

			/**
			 * Method returns ths first page HTMLElement
			 * @method getFirstPage
			 * @return {HTMLElement}
			 * @member ns.router.Router
			 */
			Router.prototype.getFirstPage = function () {
				return this.getRoute("page").getFirstElement();
			};


			/**
			 * Callback for event "historyhashchange" which is triggered by history manager after hash is changed
			 * @param {ns.router.Router} router
			 * @param {Event} event
			 */
			function onHistoryHashChange(router, event) {
								openUrlFromState(router, event.detail);
			}

			/**
			 * Callback for event "historystatechange" which is triggered by history manager after hash is changed
			 * @param {ns.router.Router} router
			 * @param {Event} event
			 */
			function onHistoryStateChange(router, event) {
				var options = event.detail,
					//
					url = options.reverse ? options.url : (options.href || options.url);

				delete options.event;
				router.open(url, options);
				// prevent current event
				eventUtils.preventDefault(event);
				eventUtils.stopImmediatePropagation(event);
			}

			/**
			 * Convert HTML string to HTMLElement
			 * @param {string|HTMLElement} content
			 * @param {string} title
			 * @return {?HTMLElement}
			 */
			function convertToNode(content, title) {
				var contentNode = null,
					externalDocument = document.implementation.createHTMLDocument(title),
					externalBody = externalDocument.body;

				if (content instanceof HTMLElement) {
					// if content is HTMLElement just set to contentNode
					contentNode = content;
				} else {
					// otherwise convert string to HTMLElement
					try {
						externalBody.insertAdjacentHTML("beforeend", content);
						contentNode = externalBody.firstChild;
					} catch (e) {
						ns.error("Failed to inject element", e);
					}
				}
				return contentNode;
			}

			/**
			 * Set data-url on HTMLElement if not exists
			 * @param {HTMLElement} contentNode
			 * @param {string} url
			 */
			function setURLonElement(contentNode, url) {
				if (url) {
					if (contentNode instanceof HTMLElement && !DOM.hasNSData(contentNode, "url")) {
						// if url is missing we need set data-url attribute for good finding by method open in router
						url = url.replace(/^#/, "");
						DOM.setNSData(contentNode, "url", url);
					}
				}
			}

			/**
			 * Callback for event "controller-content-available" which is triggered by controller after application handle hash change
			 * @param {ns.router.Router} router
			 * @param {Event} event
			 */
			function onControllerContent(router, event) {
				var data = event.detail,
					content = data.content,
					options = data.options,
					contentNode,
					url = (options.href || options.url);

				// if controller give content
				if (content) {
					// convert to node if content is string
					contentNode = convertToNode(content, options.title);

					// set data-url on node
					setURLonElement(contentNode, url);

					// calling open method
					router.open(contentNode, options);

					//prevent event
					eventUtils.preventDefault(event);
				}
			}


			/**
			 * Method registers page container and the first page.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.register(new ns.widget.PageContainer(), document.getElementById("firstPage"));
			 *
			 * @method register
			 * @param {ns.widget.core.PageContainer} container
			 * @param {HTMLElement} firstPage
			 * @member ns.router.Router
			 */
			Router.prototype.register = function (container, firstPage) {
				var self = this,
					routePopup = this.getRoute("popup");

				// sets instance of PageContainer widget
				self.container = container;

				// sets first page HTMLElement
				self.getRoute("page").setFirstElement(firstPage);

				eventUtils.trigger(document, "themeinit", self);

				// sets events handlers
				if (!self._onHashChangeHandler) {
					self._onHashChangeHandler = onHistoryHashChange.bind(null, self);
					window.addEventListener(historyManagerEvents.HASHCHANGE, self._onHashChangeHandler, false);
				}
				if (!self._onStateChangeHandler) {
					self._onStateChangeHandler = onHistoryStateChange.bind(null, self);
					window.addEventListener(historyManagerEvents.STATECHANGE, self._onStateChangeHandler, false);
				}
				if (!self._onControllerContent) {
					self._onControllerContent = onControllerContent.bind(null, self);
					window.addEventListener("controller-content-available", self._onControllerContent, false);
				}

				// if loader config is set then create loader widget
				if (ns.getConfig("loader", false)) {
					container.element.appendChild(self.getLoader().element);
				}

				// set history support
				history.enableVolatileMode();

				// if first page exist open this page without transition
				if (firstPage) {
					self.open(firstPage, {transition: "none"});
				}

				if (routePopup) {
					routePopup.setActive(null);
				}
			};

			/**
			 * Convert string id to HTMLElement or return HTMLElement if is given
			 * @param {string|HTMLElement} idOrElement
			 * @return {HTMLElement|string}
			 */
			function getHTMLElement(idOrElement) {
				var stringId,
					toElement;

				// if given argument is string then
				if (typeof idOrElement === "string") {
					if (idOrElement[0] === "#") {
						// trim first char if it is #
						stringId = idOrElement.substr(1);
					} else {
						stringId = idOrElement;
					}
					// find element by id
					toElement = document.getElementById(stringId);

					if (toElement) {
						// is exists element by id then return it
						idOrElement = toElement;
					}
					// otherwise return string
				}
				return idOrElement;
			}

			/**
			 * Method close route element, eg page or popup.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.close("popupId", {transition: "none"});
			 *
			 * @method close
			 * @param {string|HTMLElement} to Id of page or file url or HTMLElement of page
			 * @param {Object} [options]
			 * @param {"page"|"popup"|"external"} [options.rel="page"] Represents kind of link as "page" or "popup" or "external" for linking to another domain
			 * @member ns.router.Router
			 */
			Router.prototype.close = function (to, options) {
				var rel = "back",
					closingWidget = getHTMLElement(to),
					rule;

				if (options && options.rel) {
					rel = options.rel;
				} else if (closingWidget) {
					rel = this.detectRel(closingWidget);
				}

				rule = route[rel];

				// if router is not locked
				if (!this.locked) {
					// if rel is back then call back method
					if (rel === "back") {
						history.back();
					} else {
						// otherwise if rule exists
						if (rule) {
							// call close on rule
							rule.close(closingWidget, options);
						} else {
							throw new Error("Not defined router rule [" + rel + "]");
						}
					}
				}
			};

			/**
			 * Method back to previous state.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.back();
			 *
			 * @method close
			 * @member ns.router.Router
			 */
			Router.prototype.back = function () {

				// if router is not locked
				if (!this.locked) {
					history.back();
				}
			};

			/**
			 * Method opens popup.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.openPopup("popupId", {transition: "none"});
			 *
			 * @method openPopup
			 * @param {HTMLElement|string} to Id or HTMLElement of popup.
			 * @param {Object} [options]
			 * @param {string} [options.transition="none"] Sets the animation used during change of page.
			 * @param {boolean} [options.reverse=false] Sets the direction of change.
			 * @param {boolean} [options.fromHashChange=false] Sets if will be changed after hashchange.
			 * @param {boolean} [options.volatileRecord=false] Sets if the current history entry will be modified or a new one will be created.
			 * @param {boolean} [options.dataUrl] Sets if page has url attribute.
			 * @param {?string} [options.container=null] It is used in RoutePopup as selector for container.
			 * @member ns.router.Router
			 */
			Router.prototype.openPopup = function (to, options) {
				// call method open with overwrite rel option
				this.open(to, object.fastMerge({rel: "popup"}, options));
			};

			/**
			 * Method closes popup.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance();
			 *		router.closePopup();
			 *
			 * @method closePopup
			 * @param {Object} options
			 * @param {string=} [options.transition]
			 * @param {string=} [options.ext="in ui-pre-in"] options.ext
			 * @member ns.router.Router
			 */
			Router.prototype.closePopup = function (options) {
				var popupRoute = this.getRoute("popup");

				if (popupRoute) {
					popupRoute.close(null, options);
				}
			};

			/**
			 * Lock router
			 * @method lock
			 * @member ns.router.Router
			 */
			Router.prototype.lock = function () {
				this.locked = true;
			};

			/**
			 * Unlock router and history manager
			 * @method unlock
			 * @member ns.router.Router
			 */
			Router.prototype.unlock = function () {
				this.locked = false;
			};

			/**
			 * Load content from url.
			 *
			 * Method prepare url and call template function to load external file.
			 *
			 * If option showLoadMsg is ste to tru open loader widget before start loading.
			 *
			 * @method _loadUrl
			 * @param {string} url full URL to load
			 * @param {Object} options options for this and next methods in chain
			 * @param {boolean} [options.data] Sets if page has url attribute.
			 * @param {Object} rule rule which support given call
			 * @param {Object} deferred object with callbacks
			 * @param {Function} deferred.reject callback on error
			 * @param {Function} deferred.resolve callback on success
			 * @member ns.router.Router
			 * @protected
			 */
			Router.prototype._loadUrl = function (url, options, rule, deferred) {
				var absUrl = path.makeUrlAbsolute(url, path.getLocation()),
					content,
					self = this,
					data = options.data || {};

				// check if content is loaded in current document
				content = rule.find(absUrl);

				// if content doesn't find and url is embedded url
				if (!content && path.isEmbedded(absUrl)) {
					// reject
					deferred.reject({});
				} else {
					// If the content we are interested in is already in the DOM,
					// and the caller did not indicate that we should force a
					// reload of the file, we are done. Resolve the deferred so that
					// users can bind to .done on the promise
					if (content) {
						// content was found and we resolve
						deferred.resolve(object.fastMerge({absUrl: absUrl}, options), content);
					} else {

						// Load the new content.
						eventUtils.trigger(self.getContainer().element, options.rel + "beforeload");

						// force return full document from template system
						data.fullDocument = true;
						// we put url, not the whole path to function render,
						// because this path can be modified by template's module
						template.render(url, data, function (status, element) {
							// if template loaded successful
							if (status.success) {
								self._loadSuccess(status.absUrl, options, rule, deferred, element);
								eventUtils.trigger(self.getContainer().element, options.rel + "load");
							} else {
								self._loadError(status.absUrl, options, deferred);
							}
						});
					}
				}
			};

			/**
			 * Error handler for loading content by AJAX
			 * @method _loadError
			 * @param {string} absUrl full URL to load
			 * @param {Object} options options for this and next methods in chain
			 * @param {boolean} [options.showLoadMsg=true] Sets if message will be shown during loading.
			 * @param {Object} deferred object with callbacks
			 * @param {Function} deferred.reject callback on error
			 * @member ns.router.Router
			 * @protected
			 */
			Router.prototype._loadError = function (absUrl, options, deferred) {
				var detail = object.fastMerge({url: absUrl}, options),
					self = this;

				ns.error("load error, file: ", absUrl);

				self.container.trigger("loadfailed", detail);
				deferred.reject(detail);
			};

			// TODO it would be nice to split this up more but everything appears to be "one off"
			//	or require ordering such that other bits are sprinkled in between parts that
			//	could be abstracted out as a group
			/**
			 * Success handler for loading content by AJAX
			 * @method _loadSuccess
			 * @param {string} absUrl full URL to load
			 * @param {Object} options options for this and next methods in chain
			 * @param {boolean} [options.showLoadMsg=true] Sets if message will be shown during loading.
			 * @param {Object} rule rule which support given call
			 * @param {Object} deferred object with callbacks
			 * @param {Function} deferred.reject callback on error
			 * @param {Function} deferred.resolve callback on success
			 * @param {string} html
			 * @member ns.router.Router
			 * @protected
			 */
			Router.prototype._loadSuccess = function (absUrl, options, rule, deferred, html) {
				var detail = object.fastMerge({url: absUrl}, options),
					// find element with given id in returned html
					content = rule.parse(html, absUrl);

				if (content) {
					deferred.resolve(detail, content);
				} else {
					deferred.reject(detail);
				}
			};

			// TODO the first page should be a property set during _create using the logic
			//	that currently resides in init
			/**
			 * Get initial content
			 * @method _getInitialContent
			 * @member ns.router.Router
			 * @return {HTMLElement} the first page
			 * @protected
			 */
			Router.prototype._getInitialContent = function () {
				return this.getRoute("page").getFirstElement();
			};

			/**
			 * Report an error loading
			 * @method _showError
			 * @param {string} absUrl
			 * @member ns.router.Router
			 * @protected
			 */
			Router.prototype._showError = function (absUrl) {
				ns.error("load error, file: ", absUrl);
			};

			/**
			 * Returns Page or Popup widget
			 * @param {string} [routeName="page"] in default page or popup
			 * @method getActive
			 * @return {ns.widget.BaseWidget}
			 * @member ns.router.Router
			 */
			Router.prototype.getActive = function (routeName) {
				var route = this.getRoute(routeName || "page");

				return route && route.getActive();
			};

			/**
			 * Returns true if element in given route is active.
			 * @param {string} [routeName="page"] in default page or popup
			 * @method hasActive
			 * @return {boolean}
			 * @member ns.router.Router
			 */
			Router.prototype.hasActive = function (routeName) {
				var route = this.getRoute(routeName || "page");

				return !!(route && route.hasActive());
			};

			/**
			 * Returns true if any popup is active.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance(),
			 *			hasActivePopup = router.hasActivePopup();
			 *			// -> true | false
			 *
			 * @method hasActivePopup
			 * @return {boolean}
			 * @member ns.router.Router
			 */
			Router.prototype.hasActivePopup = function () {
				return this.hasActive("popup");
			};

			/**
			 * This function returns proper route.
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance(),
			 *			route = router.getRoute("page"),
			 *			// -> Object with pages support
			 *			activePage = route.getActive();
			 *			// instance of Page widget
			 *
			 * @method getRoute
			 * @param {string} type Type of route
			 * @return {?ns.router.route.interface}
			 * @member ns.router.Router
			 */
			Router.prototype.getRoute = function (type) {
				return route[type];
			};

			/**
			 * Returns instance of loader widget.
			 *
			 * If loader not exist then is created on first element matched to selector
			 * or is created new element.
			 *
			 *	@example
			 *		var loader = router.getLoader();
			 *		// get or create loader
			 *		loader.show();
			 *		// show loader
			 *
			 * @return {?ns.widget.mobile.Loader}
			 * @member ns.router.Page
			 * @method getLoader
			 */
			Router.prototype.getLoader = function () {
				var loaderDefinition = engine.getWidgetDefinition("Loader"),
					loaderSelector = loaderDefinition.selector,
					loaderElement;

				if (loaderDefinition) {
					loaderElement = document.querySelector(loaderSelector);
					return engine.instanceWidget(loaderElement, "Loader");
				}
				return null;
			};

			/**
			 * Creates a new instance of the router and returns it
			 *
			 *	@example
			 *		var router = Router.newInstance();
			 *
			 * @method newInstance
			 * @member ns.router.Router
			 * @static
			 * @return {ns.router.Router}
			 * @since 2.4
			 */
			Router.newInstance = function () {
				return (routerInstance = new Router());
			};

			/**
			 * Returns a instance of the router, creates a new if does not exist
			 *
			 *	@example
			 *		var router = tau.router.Router.getInstance(),
			 *			// if router not exists create new instance and return
			 *			router2 = tau.router.Router.getInstance();
			 *			// only return router from first step
			 *			// router === router2
			 *
			 * @method getInstance
			 * @member ns.router.Router
			 * @return {ns.router.Router}
			 * @since 2.4
			 * @static
			 */
			Router.getInstance = function () {
				if (!routerInstance) {
					return this.newInstance();
				}
				return routerInstance;
			};

			router.Router = Router;

			Router.eventType = eventType;

			/**
			 * Returns router instance
			 * @deprecated 2,4
			 * @return {ns.router.Router}
			 */
			engine.getRouter = function () { //@TODO FIX HACK old API
				//@TODO this is suppressed since the tests are unreadable
				// tests need fixes
				ns.warn("getRouter() method is deprecated! Use tau.router.Router.getInstance() instead");
				return Router.getInstance();
			};

			if (!ns.getConfig("disableRouter", false)) {
				document.addEventListener(engine.eventType.READY, function () {
					Router.getInstance().init();
				}, false);
				document.addEventListener(engine.eventType.DESTROY, function () {
					Router.getInstance().destroy();
				}, false);
				document.addEventListener(engine.eventType.STOP_ROUTING, function () {
					Router.getInstance().destroy();
				}, false);
			}

			//engine.initRouter(Router);
			}(window, window.document));

/*global window, ns, define, HTMLElement */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping router
 * Object maps router from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.router
 */
(function (window, document) {
	"use strict";
	
			var engine = ns.engine,
				$ = ns.jqm.jQuery,
				eventType = ns.router.Router.eventType,
				jqmRouter = {
					/**
					 * Enables support jQM before router init.
					 * @method beforeinit
					 * @member ns.jqm.router
					 */
					beforeinit: function () {
						var container,
							router = ns.router.Router.getInstance();

						if ($) {
							if ($.mobile) {
								if ($.mobile.pageContainer) {
									container = $.mobile.pageContainer;
									if (container instanceof $) {
										container = container[0];
									}
									if (!(container instanceof HTMLElement)) {
										container = document.body;
									}
									ns.setConfig("pageContainer", container);
									$.mobile.pageContainer = $(container);
								}
								if ($.mobile.autoInitializePage !== undefined) {
									ns.setConfig("autoInitializePage", $.mobile.autoInitializePage);
								}
								if ($.mobile._bindPageRemove !== undefined) {
									ns.setConfig("_bindPageRemove", $.mobile._bindPageRemove);
								}
								$.mobile.changePage = function (toPage, options) {
									var htmlElementToPage;

									if (toPage instanceof $) {
										htmlElementToPage = $(toPage).get(0);
										return router.open(htmlElementToPage, options);
									}
									return router.open(toPage, options);
								};
								document.addEventListener("pagechange", function () {
									var route = router.getRoute("page"),
										activePage = route && route.getActive(),
										target = activePage && activePage.element;

									$.mobile.activePage = $(target);
								}, true);
								$.mobile.activePage = $();
								$.mobile.firstPage = $(router.getRoute("page").getFirstElement());
								$.mobile.pageContainer = $();
								$.mobile.subPageUrlKey = ns.widget.core.Page.classes.uiPage;
								$.mobile.ajaxEnabled = true;
								$.mobile.hashListeningEnabled = true;
								$.mobile.linkBindingEnabled = true;
								$.mobile.maxTransitionWidth = false;
								$.mobile.minScrollBack = 250;
								$.mobile.touchOverflowEnabled = false;
								$.mobile.defaultDialogTransition = "pop";
								$.mobile.pageLoadErrorMessage = "Error Loading Page";
								$.mobile.pageLoadErrorMessageTheme = "e";
								$.mobile.phonegapNavigationEnabled = false;
								$.mobile.autoInitializePage = false;
								$.mobile.pushStateEnabled = true;
								$.mobile.ignoreContentEnabled = false;
								$.mobile.orientationChangeEnabled = true;
								$.mobile.ajaxBlacklist = false;
								$.mobile.defaultTransitionHandler = null;
								$.mobile.transitionHandlers = {};
								$.mobile.transitionFallbacks = {};
								$.mobile._maybeDegradeTransition = null;
								$.mobile.focusPage = null;
								//$.mobile.urlHistory = ns.router.urlHistory;
								$.mobile.dialogHashKey = "&ui-state=dialog";
								$.mobile.allowCrossDomainPages = false;
								$.mobile.getDocumentUrl = ns.util.path.getDocumentUrl;
								$.mobile.getDocumentBase = ns.util.path.getDocumentBase;
								$.mobile._bindPageRemove = null;
								$.mobile.loadPage = router.loadPage === undefined ? ns.error.bind(null, "router PageExternal is not loaded") : router.loadPage.bind(router);
								$.mobile.navreadyDeferred = router.navreadyDeferred;
								$.mobile.initializePage = null;
								$.mobile._handleHashChange = router._hashChangeHandler;
							} else {
								$.mobile = {};
							}
						}
					},
					/**
					 * Enables support jQM after router init.
					 * @method init
					 * @member ns.jqm.router
					 */
					init: function () {
						var transitions,
							name,
							router = ns.router.Router.getInstance(),
							containerWidget;

						if ($) {
							$.mobile.defaultPageTransition = "none";

							if (router.getTransitions) {
								transitions = router.getTransitions();
								for (name in transitions) {
									if (transitions.hasOwnProperty(name)) {
										if (transitions[name].fallback !== undefined) {
											$.mobile.transitionFallbacks[name] = transitions[name].fallback;
										}
										if (transitions[name].handler !== undefined) {
											$.mobile.transitionHandlers[name] = transitions[name].handler;
										}
									}
								}
								$.mobile.defaultTransitionHandler = transitions.sequential.handler;
								$.mobile._maybeDegradeTransition = router._maybeDegradeTransition.bind(router);
								$.mobile.getMaxScrollForTransition = router.getMaxScrollForTransition.bind(router);
							}

							$.mobile.focusPage = function (toPage) {
								var page = $(toPage)[0],
									pageWidget = engine.getBinding(page);

								pageWidget.focus();
							};

							$.mobile.initializePage = router.init.bind(router);
							containerWidget = router.getContainer();
							if (containerWidget) {
								$.mobile.pageContainer = $(containerWidget.element);
							}
						}
					},
					destroy: function () {
						document.removeEventListener(eventType.ROUTER_INIT, jqmRouter.init, false);
						document.removeEventListener(eventType.BEFORE_ROUTER_INIT, jqmRouter.beforeinit, false);
						document.removeEventListener(eventType.DESTROY, jqmRouter.destroy, false);
					}
				};

			document.addEventListener(eventType.ROUTER_INIT, jqmRouter.init, false);
			document.addEventListener(eventType.BEFORE_ROUTER_INIT, jqmRouter.beforeinit, false);
			document.addEventListener(eventType.DESTROY, jqmRouter.destroy, false);

			ns.jqm.router = jqmRouter;
			}(window, window.document));

/*global window, ns, define */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping support
 * Object maps support object from TAU namespace to jQuery Mobile namespace.
 * @class ns.jqm.support
 */
(function (window, document) {
	"use strict";
				var support = ns.support,
				$ = ns.jqm.jQuery,
				object = ns.util.object,
				eventType = ns.engine.eventType,
				jqmSupport = {
					/**
					 * Touch support flag
					 * @property {boolean} touch
					 * @member ns.jqm.support
					 */
					touch: document.ontouchend !== undefined,
					/**
					 * Enables support in jQM after TAU init
					 * @method init
					 * @member ns.jqm.support
					 */
					init: function () {
						var router = ns.router.Router.getInstance();

						if ($) {
							ns.support = object.merge($.support, support);
							$.mobile = $.mobile || {};
							$.mobile.support = $.mobile.support || {};
							$.mobile.support.touch = support.touch;
							$.mobile.base = support.dynamicBaseTag && {
								element: router.resetBase === undefined ? ns.error.bind(null, "router PageExternal is not loaded") : router.resetBase(),
								set: router.setBase === undefined ? ns.error.bind(null, "router PageExternal is not loaded") : router.setBase.bind(router),
								reset: router.resetBase === undefined ? ns.error.bind(null, "router PageExternal is not loaded") : router.resetBase.bind(router)
							};
							$.mobile.gradeA = ns.support.gradeA.bind(ns.support);
							$.mobile.browser = ns.support.browser;
						}
					},
					/**
					 * Removes events listeners on framework destroy
					 */
					destroy: function () {
						document.removeEventListener(eventType.INIT, jqmSupport.init, false);
						document.removeEventListener(eventType.DESTROY, jqmSupport.destroy, false);
					}
				};

			// Listen when framework is ready
			document.addEventListener(eventType.INIT, jqmSupport.init, false);
			document.addEventListener(eventType.DESTROY, jqmSupport.destroy, false);

			ns.jqm.support = jqmSupport;
			}(window, window.document));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Colors Utility
 * Class supports converting between color formats
 * @class ns.util.colors
 */

(function (window, document, ns) {
	"use strict";
				ns.util.colors = {
				/**
				 * Round to the nearest Integer
				 * @method nearestInt
				 * @param {number} val
				 * @return {number}
				 * @member ns.util.colors
				 * @static
				 */
				nearestInt: function (val) {
					var theFloor = Math.floor(val);

					return (((val - theFloor) > 0.5) ? (theFloor + 1) : theFloor);
				},

				/**
				 * Converts html color string to rgb array.
				 * @method HTMLToRGB
				 * @param {string} clrStr is of the form "#aabbcc"
				 * @return {number[]} Returns: [ r, g, b ], where
				 * r is in [0, 1]
				 * g is in [0, 1]
				 * b is in [0, 1]
				 * @member ns.util.colors
				 * @static
				 */
				HTMLToRGB: function (clrStr) {
					clrStr = (("#" === clrStr.charAt(0)) ? clrStr.substring(1) : clrStr);
					return ([
						clrStr.substring(0, 2),
						clrStr.substring(2, 4),
						clrStr.substring(4, 6)
					].map(function (val) {
						return parseInt(val, 16) / 255.0;
					}));
				},

				/**
				 * Converts rgb array to html color string.
				 * @method RGBToHTML
				 * @param {number[]} rgb Input: [ r, g, b ], where
				 * r is in [0, 1]
				 * g is in [0, 1]
				 * b is in [0, 1]
				 * @return {string} Returns string of the form "#aabbcc"
				 * @member ns.util.colors
				 * @static
				 */
				RGBToHTML: function (rgb) {
					return ("#" +
					rgb.map(function (val) {
						var ret = val * 255,
							theFloor = Math.floor(ret);

						ret = ((ret - theFloor > 0.5) ? (theFloor + 1) : theFloor);
						ret = (((ret < 16) ? "0" : "") + (ret & 0xff).toString(16));
						return ret;
					})
						.join(""));
				},

				/**
				 * Converts hsl to rgb.
				 * @method HSLToRGB
				 * @param {number[]} hsl Input: [ h, s, l ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * l is in [0,   1]
				 * @return {number[]} Returns: [ r, g, b ], where
				 * r is in [0, 1]
				 * g is in [0, 1]
				 * b is in [0, 1]
				 * @member ns.util.colors
				 * @static
				 */
				HSLToRGB: function (hsl) {
					var h = hsl[0] / 360.0,
						s = hsl[1],
						l = hsl[2],
						temp1,
						temp2,
						temp3,
						ret;

					if (0 === s) {
						ret = [l, l, l];
					} else {
						temp2 = ((l < 0.5) ? l * (1.0 + s) : l + s - l * s);
						temp1 = 2.0 * l - temp2;
						temp3 = {
							r: h + 1.0 / 3.0,
							g: h,
							b: h - 1.0 / 3.0
						};

						temp3.r = ((temp3.r < 0) ? (temp3.r + 1.0) : ((temp3.r > 1) ? (temp3.r - 1.0) : temp3.r));
						temp3.g = ((temp3.g < 0) ? (temp3.g + 1.0) : ((temp3.g > 1) ? (temp3.g - 1.0) : temp3.g));
						temp3.b = ((temp3.b < 0) ? (temp3.b + 1.0) : ((temp3.b > 1) ? (temp3.b - 1.0) : temp3.b));

						ret = [
							(((6.0 * temp3.r) < 1) ? (temp1 + (temp2 - temp1) * 6.0 * temp3.r) :
								(((2.0 * temp3.r) < 1) ? temp2 :
									(((3.0 * temp3.r) < 2) ? (temp1 + (temp2 - temp1) * ((2.0 / 3.0) - temp3.r) * 6.0) :
										temp1))),
							(((6.0 * temp3.g) < 1) ? (temp1 + (temp2 - temp1) * 6.0 * temp3.g) :
								(((2.0 * temp3.g) < 1) ? temp2 :
									(((3.0 * temp3.g) < 2) ? (temp1 + (temp2 - temp1) * ((2.0 / 3.0) - temp3.g) * 6.0) :
										temp1))),
							(((6.0 * temp3.b) < 1) ? (temp1 + (temp2 - temp1) * 6.0 * temp3.b) :
								(((2.0 * temp3.b) < 1) ? temp2 :
									(((3.0 * temp3.b) < 2) ? (temp1 + (temp2 - temp1) * ((2.0 / 3.0) - temp3.b) * 6.0) :
										temp1)))
						];
					}

					return ret;
				},

				/**
				 * Converts hsv to rgb.
				 * @method HSVToRGB
				 * @param {number[]} hsv Input: [ h, s, v ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * v is in [0,   1]
				 * @return {number[]} Returns: [ r, g, b ], where
				 * r is in [0, 1]
				 * g is in [0, 1]
				 * b is in [0, 1]
				 * @member ns.util.colors
				 */
				HSVToRGB: function (hsv) {
					return this.HSLToRGB(this.HSVToHSL(hsv));
				},

				/**
				 * Converts rgb to hsv.
				 * @method HSVToRGB
				 * @param {number[]} rgb Input: [ r, g, b ], where
				 * r is in [0,   1]
				 * g is in [0,   1]
				 * b is in [0,   1]
				 * @return {number[]} Returns: [ h, s, v ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * v is in [0,   1]
				 * @member ns.util.colors
				 * @static
				 */
				RGBToHSV: function (rgb) {
					var min,
						max,
						delta,
						h,
						s,
						v,
						r = rgb[0],
						g = rgb[1],
						b = rgb[2];

					min = Math.min(r, Math.min(g, b));
					max = Math.max(r, Math.max(g, b));
					delta = max - min;

					h = 0;
					s = 0;
					v = max;

					if (delta > 0.00001) {
						s = delta / max;

						if (r === max) {
							h = (g - b) / delta;
						} else {
							if (g === max) {
								h = 2 + (b - r) / delta;
							} else {
								h = 4 + (r - g) / delta;
							}
						}

						h *= 60;

						if (h < 0) {
							h += 360;
						}
					}

					return [h, s, v];
				},

				/**
				 * Converts Converts hsv to hsl.
				 * @method HSVToHSL
				 * @param {number[]} hsv Input: [ h, s, v ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * v is in [0,   1]
				 * @return {number[]} Returns: [ h, s, l ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * l is in [0,   1]
				 * @member ns.util.colors
				 * @static
				 */
				HSVToHSL: function (hsv) {
					var max = hsv[2],
						delta = hsv[1] * max,
						min = max - delta,
						sum = max + min,
						halfSum = sum / 2,
						sDivisor = ((halfSum < 0.5) ? sum : (2 - max - min));

					return [hsv[0], ((0 === sDivisor) ? 0 : (delta / sDivisor)), halfSum];
				},

				/**
				 * Converts rgb to hsl
				 * @method RGBToHSL
				 * @param {number[]} rgb Input: [ r, g, b ], where
				 * r is in [0,   1]
				 * g is in [0,   1]
				 * b is in [0,   1]
				 * @return {number[]} Returns: [ h, s, l ], where
				 * h is in [0, 360]
				 * s is in [0,   1]
				 * l is in [0,   1]
				 * @member ns.util.colors
				 */
				RGBToHSL: function (rgb) {
					return this.HSVToHSL(this.RGBToHSV(rgb));
				}
			};
			}(window, window.document, ns));

/*global window, ns, define */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #jQuery Mobile mapping colors
 * Object maps color support object from TAU namespace to
 * jQuery Mobile namespace.
 * @class ns.jqm.colors
 */
(function (document) {
	"use strict";
				var eventType = ns.engine.eventType,
				$ = ns.jqm.jQuery,
				colors = {
					/**
					 * Initializes colors util in jQueryMobile namespace
					 */
					init: function () {
						if ($) {
							$.mobile.tizen.clrlib = colors;
						}
					},

					/**
					 * Destroys colors util in jQueryMobile namespace
					 */
					destroy: function () {
						document.removeEventListener(eventType.INIT, colors.init, false);
						document.removeEventListener(eventType.DESTROY, colors.destroy, false);
						if ($) {
							delete $.mobile.tizen.clrlib;
						}
						window.ns = null;
						$ = null;
						eventType = null;
						colors = null;
					}
				};

			// Listen when framework is ready
			document.addEventListener(eventType.INIT, colors.init, false);
			document.addEventListener(eventType.DESTROY, colors.destroy, false);

			}(window.document));

/*global define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Anchor Highlight Utility
 *
 * Utility enables highlight on clickable components.
 * @class ns.util.anchorHighlight
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Damian Osipiuk <d.osipiuk@samsung.com>
 * @author Konrad Lipner <k.lipner@samsung.com>
 */
(function (document, window, ns) {
	"use strict";
				/* anchorHighlightController.js
			 To prevent performance regression when scrolling,
			 do not apply hover class in anchor.
			 Instead, this code checks scrolling for time threshold and
			 decide how to handle the color.
			 When scrolling with anchor, it checks flag and decide to highlight anchor.
			 While it helps to improve scroll performance,
			 it lowers responsiveness of the element for 50msec.
			 */

			/**
			 * Touch start x
			 * @property {number} startX
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			var startX = 0,
				/**
				 * Touch start y
				 * @property {number} startY
				 * @member ns.util.anchorHighlight
				 * @private
				 * @static
				 */
				startY = 0,
				/**
				 * Touch target element
				 * @property {HTMLElement} target
				 * @member ns.util.anchorHighlight
				 * @private
				 * @static
				 */
				classes = {
					/**
					 * Class used to mark element as active
					 * @property {string} [classes.ACTIVE_LI="ui-li-active"]
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					ACTIVE_LI: "ui-li-active",
					/**
					 * Class used to mark button as active
					 * @property {string} [classes.ACTIVE_BTN="ui-btn-active"]
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					ACTIVE_BTN: "ui-btn-active",
					/**
					 * Class used to mark button as inactive
					 * @property {string} [classes.INACTIVE_BTN="ui-btn-inactive"]
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					INACTIVE_BTN: "ui-btn-inactive",
					/**
					 * Class used to select button
					 * @property {string} [classes.BUTTON="ui-btn"] btn
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					BUTTON: "ui-btn",
					/**
					 * Class used to select button in header (old notation)
					 * @property {string} [classes.HEADER_BUTTON="ui-header-btn"] btn
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					HEADER_BUTTON: "ui-header-btn",
					/**
					 * Class used to select anchor in tabbar widget
					 * @property {string} [classes.TABBAR_ANCHOR="ui-tabbar-anchor"] anchor
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					TABBAR_ANCHOR: "ui-tabbar-anchor",
					/**
					 * Class used to select navigation item
					 * @property {string} [classes.NAVIGATION_BUTTON="ui-navigation-item"] btn
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					NAVIGATION_BUTTON: "ui-navigation-item"
				},
				events = {
					ACTIVE_LI: "anchorhighlightactiveli"
				},
				/**
				 * Alias for class {@link ns.util.selectors}
				 * @property {Object} selectors
				 * @member ns.util.anchorHighlight
				 * @private
				 * @static
				 */
				selectors = ns.util.selectors,
				/**
				 * Alias for class {@link ns.event}
				 * @property {Object} event
				 * @member ns.util.anchorHighlight
				 * @private
				 * @static
				 */
				eventUtil = ns.event,

				// cache function
				abs = Math.abs,

				/**
				 * Get closest li element
				 * @method detectLiElement
				 * @param {HTMLElement} target
				 * @return {HTMLElement}
				 * @member ns.util.anchorHighlight
				 * @private
				 * @static
				 */
				detectLiElement = function (target) {
					return selectors.getClosestByTag(target, "li");
				},

				anchorHighlight = {
					/**
					 * Object with default options
					 * @property {Object} options
					 * Threshold after which didScroll will be set
					 * @property {number} [options.scrollThreshold=10]
					 * Time to wait before adding activeClass
					 * @property {number} [options.addActiveClassDelay=50]
					 * Time to stay activeClass after touch end
					 * @property {number} [options.keepActiveClassDelay=100]
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					options: {
						scrollThreshold: 10,
						addActiveClassDelay: 50,
						keepActiveClassDelay: 100
					},
					_startTime: 0,
					_startRemoveTime: 0,
					// inform that touch was ended
					_touchEnd: false,
					_liTarget: null,

					/**
					 * Touch button target element
					 * @property {HTMLElement} buttonTarget
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					_target: null,
					/**
					 * Did page scrolled
					 * @property {boolean} didScroll
					 * @member ns.util.anchorHighlight
					 * @private
					 * @static
					 */
					_didScroll: false,
					_buttonTarget: null,
					// inform that animation of button's activation was ended
					_activeAnimationFinished: false,
					//cache function
					_requestAnimationFrame: ns.util.windowRequestAnimationFrame
				},

				// cache function
				slice = Array.prototype.slice;


			/**
			 * Get closest highlightable element
			 * @method detectHighlightTarget
			 * @param {HTMLElement} target
			 * @return {HTMLElement}
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function detectHighlightTarget(target) {
				return selectors.getClosestBySelector(target, "a, label");
			}

			/**
			 * Get closest button element
			 * @method detectLiElement
			 * @param {HTMLElement} target
			 * @return {HTMLElement}
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function detectBtnElement(target) {
				return selectors.getClosestByClass(target, classes.BUTTON) ||
					selectors.getClosestByClass(target, classes.HEADER_BUTTON) ||
					selectors.getClosestByClass(target, classes.NAVIGATION_BUTTON) ||
					selectors.getClosestByClass(target, classes.TABBAR_ANCHOR);
			}

			/**
			 * Clear active class on button
			 * @method clearBtnActiveClass
			 * @param {Event} event
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function clearBtnActiveClass(event) {
				var target = event.target,
					classList = target.classList;
				// if this is callback of activate animation and

				if (classList.contains(classes.ACTIVE_BTN) && !classList.contains(classes.INACTIVE_BTN)) {
					// set that animation was ended (used in touch end)
					anchorHighlight._activeAnimationFinished = true;

					// if touch end previously
					if (anchorHighlight._touchEnd || target !== anchorHighlight._buttonTarget) {
						// start inactivate animation
						classList.add(classes.INACTIVE_BTN);
					}
				} else {
					//when target of animationend event is child of active element instead of active element
					// itself
					if (!classList.contains(classes.ACTIVE_BTN) &&
						!classList.contains(classes.INACTIVE_BTN)) {
						target.parentNode.classList.remove(classes.ACTIVE_BTN);
						target.parentNode.classList.remove(classes.INACTIVE_BTN);
					}
					// this is callback for inactive animation end
					classList.remove(classes.INACTIVE_BTN);
					classList.remove(classes.ACTIVE_BTN);
				}
			}

			/**
			 * Add inactive class on touch end
			 * @method addButtonInactiveClass
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function addButtonInactiveClass() {
				if (anchorHighlight._buttonTarget) {
					anchorHighlight._buttonTarget.classList.add(classes.INACTIVE_BTN);
				}
			}

			/**
			 * Add active class on touch end
			 * @method addButtonActiveClass
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function addButtonActiveClass() {
				anchorHighlight._buttonTarget.classList.add(classes.ACTIVE_BTN);
				anchorHighlight._activeAnimationFinished = false;
			}

			/**
			 * Clear classes on page or popup hide
			 * @method hideClear
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function hideClear() {
				var btnTarget = anchorHighlight._buttonTarget;

				if (btnTarget) {
					btnTarget.classList.remove(classes.ACTIVE_BTN);
					btnTarget.classList.remove(classes.INACTIVE_BTN);
				}
				if (anchorHighlight._target) {
					anchorHighlight._target.classList.remove(classes.ACTIVE_LI);
				}
			}

			/**
			 * Add active class to touched element
			 * @method addActiveClass
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function addActiveClass() {
				var btnTargetClassList,
					dTime;

				if (anchorHighlight._startTime) {
					dTime = Date.now() - anchorHighlight._startTime;

					if (dTime > anchorHighlight.options.addActiveClassDelay) {
						anchorHighlight._startTime = 0;
						anchorHighlight._buttonTarget = detectBtnElement(anchorHighlight._target);
						anchorHighlight._target = detectHighlightTarget(anchorHighlight._target);
						if (!anchorHighlight._didScroll) {
							anchorHighlight._liTarget = anchorHighlight._detectLiElement(anchorHighlight._target);
							if (anchorHighlight._liTarget) {
								anchorHighlight._liTarget.classList.add(classes.ACTIVE_LI);
								eventUtil.trigger(anchorHighlight._liTarget, events.ACTIVE_LI, {});
							}
							anchorHighlight._liTarget = null;
							if (anchorHighlight._buttonTarget) {
								btnTargetClassList = anchorHighlight._buttonTarget.classList;
								btnTargetClassList.remove(classes.ACTIVE_BTN);
								btnTargetClassList.remove(classes.INACTIVE_BTN);
								anchorHighlight._requestAnimationFrame(addButtonActiveClass);
							}
						}
					} else {
						anchorHighlight._requestAnimationFrame(addActiveClass);
					}
				}
			}

			/**
			 * Get all active elements
			 * @method getActiveElements
			 * @return {Array}
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function getActiveElements() {
				return slice.call(document.getElementsByClassName(classes.ACTIVE_LI));
			}

			/**
			 * Remove active class from current active objects
			 * @method clearActiveClass
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function clearActiveClass() {
				var activeA = getActiveElements(),
					activeALength = activeA.length,
					i = 0;

				for (; i < activeALength; i++) {
					activeA[i].classList.remove(classes.ACTIVE_LI);
				}
			}

			/**
			 * Remove active class from active elements
			 * @method removeActiveClass
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function removeActiveClassLoop() {
				var dTime = Date.now() - anchorHighlight._startRemoveTime;

				if (dTime > anchorHighlight.options.keepActiveClassDelay) {
					// after touchend
					clearActiveClass();
				} else {
					anchorHighlight._requestAnimationFrame(removeActiveClassLoop);
				}
			}

			/**
			 * Function invoked during touch move (and mouse)
			 * @method touchmoveHandler
			 * @param {Event} event
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function touchmoveHandler(event) {
				var touch = event.touches[0],
					scrollThreshold = anchorHighlight.options.scrollThreshold;

				// if move looks like scroll
				if (!anchorHighlight._didScroll &&
					// if move is bigger then threshold
					(abs(touch.clientX - startX) > scrollThreshold ||
					abs(touch.clientY - startY) > scrollThreshold)) {
					anchorHighlight._startTime = 0;
					// we clear active classes
					anchorHighlight._requestAnimationFrame(clearActiveClass);
					anchorHighlight._didScroll = true;
				}
			}

			/**
			 * Function invoked after touch start (and mouse)
			 * @method touchstartHandler
			 * @param {Event} event
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function touchstartHandler(event) {
				var touches = event.touches,
					pointer = (!touches) ? event : // mouse event
						(touches.length === 1) ? touches[0] : null; // touch event

				if (pointer) {
					anchorHighlight._didScroll = false;
					startX = pointer.clientX;
					startY = pointer.clientY;
					anchorHighlight._target = event.target;
					anchorHighlight._startTime = Date.now();
					anchorHighlight._startRemoveTime = 0;
					anchorHighlight._requestAnimationFrame(addActiveClass);
					anchorHighlight._touchEnd = false;
				}
			}


			/**
			 * Function invoked after touch (and mouse)
			 * @method touchendHandler
			 * @param {Event} event
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function touchendHandler(event) {
				anchorHighlight._startRemoveTime = event.timeStamp;

				if (!event.touches || event.touches && event.touches.length === 0) {
					if (!anchorHighlight._didScroll) {
						anchorHighlight._startTime = 0;
						anchorHighlight._requestAnimationFrame(removeActiveClassLoop);
					}
					// if we finished activate animation then start inactive animation
					if (anchorHighlight._activeAnimationFinished) {
						anchorHighlight._requestAnimationFrame(addButtonInactiveClass);
					}
					anchorHighlight._didScroll = false;
					anchorHighlight._touchEnd = true;
				}
			}

			/**
			 * Function invoked after visibilitychange event
			 * @method checkPageVisibility
			 * @member ns.util.anchorHighlight
			 * @private
			 * @static
			 */
			function checkPageVisibility() {
				/* istanbul ignore if  */
				if (document.visibilityState === "hidden") {
					anchorHighlight._removeActiveClassLoop();
				}
			}

			ns.util.anchorHighlight = anchorHighlight;
			anchorHighlight.enable = enable;
			anchorHighlight.disable = disable;
			anchorHighlight._clearActiveClass = clearActiveClass;
			anchorHighlight._detectHighlightTarget = detectHighlightTarget;
			anchorHighlight._detectBtnElement = detectBtnElement;
			anchorHighlight._clearBtnActiveClass = clearBtnActiveClass;
			anchorHighlight._removeActiveClassLoop = removeActiveClassLoop;
			anchorHighlight._addButtonInactiveClass = addButtonInactiveClass;
			anchorHighlight._addButtonActiveClass = addButtonActiveClass;
			anchorHighlight._hideClear = hideClear;
			anchorHighlight._addActiveClass = addActiveClass;
			anchorHighlight._detectLiElement = detectLiElement;
			anchorHighlight._touchmoveHandler = touchmoveHandler;
			anchorHighlight._touchendHandler = touchendHandler;
			anchorHighlight._touchstartHandler = touchstartHandler;
			anchorHighlight._checkPageVisibility = checkPageVisibility;
			anchorHighlight._hideClear = hideClear;
			anchorHighlight._clearBtnActiveClass = clearBtnActiveClass;

			/**
			 * Bind events to document
			 * @method enable
			 * @member ns.util.anchorHighlight
			 * @static
			 */
			function enable() {
				document.addEventListener("touchstart", anchorHighlight._touchstartHandler, false);
				document.addEventListener("touchend", anchorHighlight._touchendHandler, false);
				document.addEventListener("touchmove", anchorHighlight._touchmoveHandler, false);
				// for TAU in browser
				document.addEventListener("mousedown", anchorHighlight._touchstartHandler, false);
				document.addEventListener("mouseup", anchorHighlight._touchendHandler, false);

				document.addEventListener("visibilitychange", anchorHighlight._checkPageVisibility, false);
				document.addEventListener("pagehide", anchorHighlight._hideClear, false);
				document.addEventListener("popuphide", anchorHighlight._hideClear, false);
				document.addEventListener("animationend", anchorHighlight._clearBtnActiveClass, false);
				document.addEventListener("animationEnd", anchorHighlight._clearBtnActiveClass, false);
				document.addEventListener("webkitAnimationEnd", anchorHighlight._clearBtnActiveClass,
					false);
			}

			/**
			 * Unbinds events from document.
			 * @method disable
			 * @member ns.util.anchorHighlight
			 * @static
			 */
			function disable() {
				document.removeEventListener("touchstart", anchorHighlight._touchstartHandler, false);
				document.removeEventListener("touchend", anchorHighlight._touchendHandler, false);
				document.removeEventListener("touchmove", anchorHighlight._touchmoveHandler, false);
				// for TAU in browser
				document.removeEventListener("mousedown", anchorHighlight._touchstartHandler, false);
				document.removeEventListener("mouseup", anchorHighlight._touchendHandler, false);

				document.removeEventListener("visibilitychange", anchorHighlight._checkPageVisibility,
					false);
				document.removeEventListener("pagehide", anchorHighlight._hideClear, false);
				document.removeEventListener("popuphide", anchorHighlight._hideClear, false);
				document.removeEventListener("animationend", anchorHighlight._clearBtnActiveClass, false);
				document.removeEventListener("animationEnd", anchorHighlight._clearBtnActiveClass, false);
				document.removeEventListener("webkitAnimationEnd", anchorHighlight._clearBtnActiveClass,
					false);
			}

			enable();

			}(document, window, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Grid Utility
 * Object helps creating grids.
 * @class ns.util.grid
 */
(function (ns) {
	"use strict";
				/**
			 * Local alias for ns.util.selectors
			 * @property {Object} selectors Alias for {@link ns.util.selectors}
			 * @member ns.util.grid
			 * @static
			 * @private
			 */
			var selectors = ns.util.selectors,
				/**
				 * Alias to Array.slice method
				 * @method slice
				 * @member ns.util.grid
				 * @private
				 * @static
				 */
				slice = [].slice,
				/**
				 * grid types
				 * @property {Array} gridTypes
				 * @member ns.util.grid
				 * @static
				 * @private
				 */
				gridTypes = [
					null,
					"solo", //1
					"a",	//2
					"b",	//3
					"c",	//4
					"d"	//5
				];

			/**
			 * Add classes on the matched elements
			 * @method setClassOnMatches
			 * @param {HTMLElementCollection} elements
			 * @param {string} selector
			 * @param {string} className
			 * @private
			 * @member ns.util.grid
			 * @static
			 */
			function setClassOnMatches(elements, selector, className) {
				elements.forEach(function (item) {
					if (selectors.matchesSelector(item, selector)) {
						item.classList.add(className);
					}
				});
			}

			ns.util.grid = {
				/**
				 * make css grid
				 * @method makeGrid
				 * @param {HTMLElement} element
				 * @param {?string} [gridType="a"]
				 * @static
				 * @member ns.util.grid
				 */
				makeGrid: function (element, gridType) {
					var gridClassList = element.classList,
						kids = slice.call(element.children),
						iterator;

					if (!gridType) {
						gridType = gridTypes[kids.length];
						if (!gridType) {
							//if gridType is not defined in gritTypes
							//make it grid type "a""
							gridType = "a";
							iterator = 2;
							gridClassList.add("ui-grid-duo");
						}
					}
					if (!iterator) {
						//jquery grid doesn't care if someone gives non-existing gridType
						iterator = gridTypes.indexOf(gridType);
					}

					gridClassList.add("ui-grid-" + gridType);

					setClassOnMatches(kids, ":nth-child(" + iterator + "n+1)", "ui-block-a");

					if (iterator > 1) {
						setClassOnMatches(kids, ":nth-child(" + iterator + "n+2)", "ui-block-b");
					}
					if (iterator > 2) {
						setClassOnMatches(kids, ":nth-child(" + iterator + "n+3)", "ui-block-c");
					}
					if (iterator > 3) {
						setClassOnMatches(kids, ":nth-child(" + iterator + "n+4)", "ui-block-d");
					}
					if (iterator > 4) {
						setClassOnMatches(kids, ":nth-child(" + iterator + "n+5)", "ui-block-e");
					}
				}
			};
			}(ns));

/*global window, ns, define, Object, Element, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Data Attributes Utility
 * Object menages data attributes
 * @class ns.util.data
 */
(function (window, document, ns) {
	"use strict";
				var hashMap = {},
				eventUtils = ns.event,
				objectUtils = ns.util.object,
				body = document.body,
				/**
				 * Return hash for object
				 * @method fetchDom
				 * @param {HTMLElement} element
				 * @param {string} key
				 * @return {?Object}
				 * @member ns.util.data
				 * @static
				 * @private
				 */
				fetchDom = function (element, key) {
					var dataKey = "data-" + key,
						data,
						result;

					if (element.hasAttribute(dataKey)) {
						data = element.getAttribute(dataKey);
						try {
							result = JSON.parse(data);
						} catch (ignore) {
						}
					}
					return result;
				},
				/**
				 * Remove attribute from element
				 * @method removeDom
				 * @param {HTMLElement} element
				 * @param {string} key
				 * @member ns.util.data
				 * @static
				 * @private
				 */
				removeDom = function (element, key) {
					var dataKey = "data-" + key;

					if (element.hasAttribute(dataKey)) {
						element.removeAttribute(dataKey);
					}
				},
				/**
				 * Return hash for object
				 * @method hashObject
				 * @param {*} value
				 * @return {string}
				 * @member ns.util.data
				 * @static
				 * @private
				 */
				hashObject = function (value) {
					var hash;

					if (value === undefined ||
						value === null ||
						value === false) {
						throw "Hashed object/primitive can not be undefined, null or false";
					}

					if (value instanceof Element && value.hasAttribute("data-ns-hash")) {
						return value.getAttribute("data-ns-hash");
					}

					if (value instanceof Object) {
						value.__tauHash = value.__tauHash || ns.getUniqueId();
					}
					hash = (typeof value) + "-" + (value instanceof Object ?
						value.__tauHash : value.toString());

					if (value instanceof Element) {
						value.setAttribute("data-ns-hash", hash);
					}
					return hash;
				};

			ns.util.data = {
				/**
				 * Set value for element
				 * @method set
				 * @param {HTMLElement} element
				 * @param {string} key
				 * @param {*} value
				 * @return {*}
				 * @member ns.util.data
				 * @static
				 */
				set: function (element, key, value) {
					var hash = hashObject(element);

					if (!hash) {
						return false;
					}

					if (!hashMap[hash]) {
						hashMap[hash] = {};
					}

					hashMap[hash][key] = value;

					if (element instanceof Element) {
						eventUtils.trigger(element, "setData", {
							"key": key,
							"value": value
						});
					}
					eventUtils.trigger(body, "globalSetData", {
						"element": element,
						"key": key,
						"value": value
					});

					return value;
				},

				/**
				 * Get value for element
				 * @method get
				 * @param {HTMLElement} element
				 * @param {string} key
				 * @param {?*} defaultValue
				 * @return {Mixed}
				 * @member ns.util.data
				 * @static
				 */
				get: function (element, key, defaultValue) {
					var hash = hashObject(element),
						value;

					if (hash) {
						if (hashMap[hash] && hashMap[hash][key] !== undefined) {
							value = hashMap[hash][key];
						}

						if (element instanceof Element) {
							if (value === undefined) {
								value = fetchDom(element, key);
								// pass it to memory HashMap
								hashMap[hash] = hashMap[hash] || {};
								hashMap[hash][key] = hashMap[hash][key] || value;
							}
							eventUtils.trigger(element, "getData", {
								"key": key,
								"value": value
							});
						}
						eventUtils.trigger(body, "globalGetData", {
							"element": element,
							"key": key,
							"value": value
						});

						return value;
					}

					return defaultValue;
				},

				/**
				 * remove value for element
				 * @method remove
				 * @param {HTMLElement} element
				 * @param {string} key
				 * @return {boolean}
				 * @member ns.util.data
				 * @static
				 */
				remove: function (element, key) {
					var hash = hashObject(element),
						value;

					if (hash && hashMap[hash] && hashMap[hash][key] !== undefined) {
						value = hashMap[hash][key];

						// Delete keyword has a performance impact on the execution, that's why we assign
						// undefined
						hashMap[hash][key] = undefined;

						// If any property is defined we cannot clear the hashMap[hash]
						if (objectUtils.hasPropertiesOfValue(hashMap[hash], undefined)) {
							hashMap[hash] = undefined;
						}

						if (element instanceof Element) {
							removeDom(element, key);
							eventUtils.trigger(element, "removeData", {
								"key": key,
								"value": value
							});
						}
						eventUtils.trigger(body, "globalRemoveData", {
							"element": element,
							"key": key,
							"value": value
						});

						return true;
					}
					return false;
				}
			};
			}(window, window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns */
/**
 * #Date Utility
 * Object supports work with date and time
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @class ns.util.date
 */
(function (ns) {
	"use strict";
				var timeRegex = /([\-0-9.]*)(ms|s)?/i,
				date = {
					/**
					 * Convert string time length to miliseconds
					 * Note: this was implemented only for animation package
					 * and the string input should be conforming to css <time>
					 * unit definition (ref: https://developer.mozilla.org/en-US/docs/Web/CSS/time)
					 * If a different format or more functionality needs to be implemented, please
					 * change this function and usage cases in animation package accordingly
					 * @method convertToMiliseconds
					 * @param {string} string
					 * @return {number}
					 * @static
					 * @member ns.util.date
					 */
					convertToMiliseconds: function (string) {
						var parsed = string.match(timeRegex),
							miliseconds = 0,
							parsedNumber;

						if (parsed.length === 3) {
							parsedNumber = parseFloat(parsed[1]) || 0;
							if (parsed[2] === "ms") {
								miliseconds = parsedNumber;
							} else if (parsed[2] === "s") {
								miliseconds = parsedNumber * 1000;
							}
						}
						return miliseconds;
					}
				};

			ns.util.date = date;
			}(ns));

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Deferred When Utility
 * Class groups many deferred object to one.
 * @class ns.util.deferredWhen
 */
(function (window, document, ns) {
	"use strict";
				var when = function (subordinate /* , ..., subordinateN */) {
				var i = 0,
					resolveValues = [].slice.call(arguments),
					length = resolveValues.length,

					/**
					 * The count of uncompleted subordinates
					 * @property {number} remaining
					 * @member ns.util.deferredWhen
					 * @private
					 */
					remaining = length !== 1 || (subordinate && (typeof subordinate.promise === "function")) ? length : 0,

					/**
					 * The master Deferred. If resolveValues consist of only
					 * a single Deferred, just use that.
					 * @property {ns.util.deferred} deferred
					 * @member ns.util.deferredWhen
					 * @private
					 */
					deferred = remaining === 1 ? subordinate : new ns.util.deferred(),

					/**
					 * Update function for both resolve and progress values
					 * @method updateFunc
					 * @param {number} i
					 * @param {Array} contexts
					 * @param {Array} values
					 * @return {Function} representing the current state
					 * "pending" | "resolved" | "rejected"
					 * @member ns.util.deferredWhen
					 * @private
					 */
					updateFunc = function (i, contexts, values) {
						return function (value) {
							contexts[i] = this;
							values[i] = arguments.length > 1 ? [].slice.call(arguments) : value;
							if (values === progressValues) {
								deferred.notifyWith(contexts, values);

							} else if (!(--remaining)) {
								deferred.resolveWith(contexts, values);
							}
						};
					},

					progressValues,
					progressContexts,
					resolveContexts;

				// add listeners to Deferred subordinates; treat others as resolved
				if (length > 1) {
					progressValues = [];
					progressValues.length = length;
					progressContexts = [];
					progressContexts.length = length;
					resolveContexts = [];
					resolveContexts.length = length;
					for (; i < length; i++) {
						if (resolveValues[i] && (typeof resolveValues[i].promise === "function")) {
							resolveValues[i].promise()
								.done(updateFunc(i, resolveContexts, resolveValues))
								.fail(deferred.reject)
								.progress(updateFunc(i, progressContexts, progressValues));
						} else {
							--remaining;
						}
					}
				}

				// if we're not waiting on anything, resolve the master
				if (!remaining) {
					deferred.resolveWith(resolveContexts, resolveValues);
				}

				return deferred.promise();
			};

			ns.util.deferredWhen = when;

			}(window, window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window: false, define: false, Math: false, ns */
/**
 * #Bezier Curves Utility
 * Class supports calculating Bezier Curves.
 * @class ns.util.bezierCurve
 */
(function (ns) {
	"use strict";
			/**
		 * Store constant value for half PI
		 * @property {number} HALF_PI
		 * @member ns.util.bezierCurve
		 * @private
		 * @static
		 */
		var HALF_PI = Math.PI / 2,
			/**
			 * Store constant value for DEFAULT_STEP
			 * @property {number} DEFAULT_STEP
			 * @member ns.util.bezierCurve
			 * @private
			 * @static
			 */
			DEFAULT_STEP = 0.001,
			BezierCurve,
			/**
			 * Calculates the arc length
			 * @method arcLength3d
			 * @param {Array} p0
			 * @param {Array} p1
			 * @return {number}
			 * @member ns.util.bezierCurve
			 * @private
			 * @static
			 */
			arcLength3d = function (p0, p1) {
				var d = [p1[0] - p0[0], p1[1] - p0[1], p1[2] - p0[2]];

				return Math.sqrt(d[0] * d[0] + d[1] * d[1] + d[2] * d[2]);
			};

		BezierCurve = function () {
			return this;
		};
		BezierCurve.prototype = {
			points: [],
			step: DEFAULT_STEP,
			length: 0,
			levels: [],
			/**
			 * Init BezierCurve
			 * @method init
			 * @param {Object} data
			 * @return {ns.util.BezierCurve} self
			 * @member ns.util.bezierCurve
			 */
			init: function (data) {
				this.points = data.points;
				this.step = data.step || DEFAULT_STEP;
				this.length = this.calculateTotalLength();
				this.levels = this.calculateLevel(data.maxLevel) || [];
				return this;
			},
			/**
			 * Calculate levels
			 * @method calculateLevel
			 * @param {?number} [maxLevel=null]
			 * @return {?Array} levels
			 * @member ns.util.bezierCurve
			 */
			calculateLevel: function (maxLevel) {
				var totalLength = this.length,
					interval = totalLength / maxLevel,
					levels = [],
					i;

				if (!maxLevel) {
					return null;
				}

				for (i = 0; i < maxLevel; i += 1) {
					levels[maxLevel - i] = this.getPercent(0, interval * i);
				}

				return levels;
			},
			/**
			 * Calculate total length
			 * @method calculateTotalLength
			 * @return {number}
			 * @member ns.util.bezierCurve
			 */
			calculateTotalLength: function () {
				var step = this.step,
					current = this.getPosition(0),
					last = current,
					length = 0,
					percent;

				for (percent = step; percent <= 1; percent += step) {
					current = this.getPosition(percent);
					length += arcLength3d(last, current);
					last = current;
				}
				return length;
			},
			/**
			 * Get position
			 * @method getPosition
			 * @param {number} percent
			 * @return {Array}
			 * @member ns.util.bezierCurve
			 */
			getPosition: function (percent) {
				var points = this.points,
					getValue = function (p1, c1, c2, p2, t) {
						return Math.pow(1 - t, 3) * p1 +
							3 * t * Math.pow(1 - t, 2) * c1 +
							3 * Math.pow(t, 2) * (1 - t) * c2 +
							Math.pow(t, 3) * p2;
					},
					result = [
						getValue(points[0][0], points[1][0], points[2][0], points[3][0], percent),
						getValue(points[0][2], points[1][2], points[2][2], points[3][2], percent)
					];

				return [result[0], 0, result[1]];
			},
			/**
			 * Get percent
			 * @method getPercent
			 * @param {number} [start=0]
			 * @param {?number} interval
			 * @return {number}
			 * @member ns.util.bezierCurve
			 */
			getPercent: function (start, interval) {
				var step = this.step,
					current,
					last,
					targetLength,
					length = 0,
					percent;

				start = start || 0;
				current = this.getPosition(start);
				last = current;
				targetLength = start + interval;
				for (percent = start + step; percent <= 1; percent += step) {
					current = this.getPosition(percent);
					length += arcLength3d(last, current);
					if (length >= targetLength) {
						return percent;
					}
					last = current;
				}
				return 1;
			},
			/**
			 * Get angle
			 * @method getAngle
			 * @param {number} percent
			 * @return {number}
			 * @member ns.util.bezierCurve
			 */
			getAngle: function (percent) {
				var points = this.points,
					getTangent = function (p1, c1, c2, p2, t) {
						return 3 * t * t * (-p1 + 3 * c1 - 3 * c2 + p2) + 6 * t * (p1 - 2 * c1 + c2) + 3 * (-p1 + c1);
					},
					tx = getTangent(points[0][0], points[1][0], points[2][0], points[3][0], percent),
					ty = getTangent(points[0][2], points[1][2], points[2][2], points[3][2], percent);

				return Math.atan2(tx, ty) - HALF_PI;
			}
		};
		ns.util.bezierCurve = new BezierCurve();

		}(ns));

/*global define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Animation namespace
 * Namespace for animation utilities
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @class ns.util.anim
 */
(function (ns) {
	"use strict";
				ns.util.anim = ns.util.anim || {};
			}(ns));

/*global window, define, ns */
/*jslint nomen: true, plusplus: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # Keyframes
 *
 * Keyframes class for easy keyframe css syntax creation and
 * managing. Each frame is specified as an element of an array
 * with size 100.
 *
 * @example

 *        <div id="test"
 *                style="width: 10px; height: 10px; background: red;"></div>
 *
 *        <script>
 *        var frames = [{ "background-color": "red" }],
 *            anim,
 *            keys;
 *
 *        frames[100] = {"background-color": "blue"};
 *        keys = new tau.util.anim.Keyframes(frames);
 *        anim = new tau.util.anim.Animation({
 *				element: document.getElementById("test"),
 *				fillMode: "both",
 *				delay: "2s",
 *				duration: "5s",
 *				steps: keys,
 *				onEnd: function () {
 *					console.log("Yay, finished!");
 *				}
 *			});
 *        </script>
 *
 * @class ns.util.anim.Keyframes
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 */
(function (document) {
	"use strict";
				// Reference to stylesheet
			var styleContainer = null,
				/**
				 * Helper function for generating css string from
				 * optimized (most usages will use maybe up to 3-5
				 * array elements, when it has 100) but thats not
				 * important for the moment
				 * frames array
				 * @param {string} prefix
				 * @param {string} name
				 * @param {Array} steps
				 * @return {string}
				 * @private
				 * @static
				 * @method keyframesToString
				 * @member ns.utils.anim.Keyframes
				 */
				// @TODO the steps array could be probably be more
				keyframesToString = function (prefix, name, steps) {
					var buff = "@" + prefix + "keyframes " + name + " {",
						i,
						l,
						prop,
						step;

					for (i = 0, l = steps.length; i < l; ++i) {
						step = steps[i];
						if (!step) {
							continue;
						}
						buff += i + "% { ";
						for (prop in step) {
							if (step.hasOwnProperty(prop)) {
								buff += prop + ": " + step[prop] + "; ";
							}
						}
						buff += "} ";
					}
					buff += "} ";
					return buff;
				},

				cssPropertyPrefix = ns.support.cssAnimationPrefix,

				Keyframes = function (steps) {
					var id = ns.getUniqueId(),
						element;

					if (!styleContainer) {
						element = document.createElement("style");
						// a text node hack, it forces the browser
						// to create a stylesheet object in the
						// HTMLStyleElement object, which we can
						// then use
						element.appendChild(document.createTextNode(""));
						document.head.appendChild(element);
						styleContainer = element.sheet;
					}
					styleContainer.insertRule(keyframesToString(cssPropertyPrefix, id, steps),
						0);
					/**
					 * Keyframes rule reference
					 * @property {CSSRule} keyframes
					 * @readonly
					 */
					this.keyframes = styleContainer.rules[0];
					/**
					 * Keyframes name
					 * @property {string} id
					 * @readonly
					 */
					this.id = id;
				};

			/**
			 * Destroys keyframes and removes css references from stylesheet
			 * @method destroy
			 * @member ns.util.anim.Keyframes
			 */
			Keyframes.prototype.destroy = function () {
				var keyframes = this.keyframes,
					stylesheet = keyframes.parentStyleSheet,
					rules = stylesheet.rules,
					i,
					l;

				// no other way for removal than with index
				// and since it changes we have to search for it
				// :(
				for (i = 0, l = rules.length; i < l; ++i) {
					if (rules[i] === keyframes) {
						stylesheet.deleteRule(i);
						break;
					}
				}
			};

			ns.util.anim.Keyframes = Keyframes;
			}(window.document));

/*global window, define, ns */
/*jslint nomen: true, plusplus: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # Animation
 *
 * Animation class for easy animations of elements. There can be
 * multiple animations on one element but in such case the usage
 * of tau.util.anim.Chain is preferred.
 *
 * ## Usage example
 *
 * @example
 *
 *        <div id="test"
 *                style="width: 10px; height: 10px; background: red;"></div>
 *
 *        <script>
 *            var a = new tau.util.anim.Animation({
 *				element: document.getElementById("test"),
 *				fillMode: "both",
 *				delay: "2s",
 *				duration: "5s",
 *				from: {
 *					"background-color": "red"
 *				},
 *				to: {
 *					"background-color": "blue"
 *				},
 *				onEnd: function () {
 *					console.log("Yay, finished!");
 *				}
 *			});
 *        </script>
 *
 * @class ns.util.anim.Animation
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 */
(function () {
	"use strict";
	
			var objectUtils = ns.util.object,
				Keyframes = ns.util.anim.Keyframes,
				CSSUtils = ns.util.DOM,
				dateUtils = ns.util.date,
				cssPropertyPrefix = ns.support.cssAnimationPrefix,

				/**
				 * Simple helper for using trim in Array.map() function
				 * @param {string} string
				 * @return {string}
				 * @private
				 * @static
				 * @method trim
				 * @member ns.util.anim.Animation
				 */
				trim = function (string) {
					return string.trim();
				},

				/**
				 * Helper for fetching animation index in animation list
				 * @param {string|string[]} props
				 * @param {string} name
				 * @return {string}
				 * @private
				 * @static
				 * @member ns.util.anim.Animation
				 */
				getAnimationIndex = function (props, name) {
					if (typeof props === "string") {
						props = props.split(",").map(trim);
					}
					return props.indexOf(name);
				},

				eventPrefix = (cssPropertyPrefix || "").replace(/\-/gi, ""),
				endEventName = eventPrefix.length > 0 ? eventPrefix +
				"AnimationEnd" : "animationEnd",
				// paused state flag
				PAUSED = 0,
				// playing state flag
				PLAYING = 1,
				// finished state flag
				FINISHED = 2,
				// alias for function string for typeof conditionals
				TYPE_FUNCTION = "function",
				/**
				 * Animation end handler
				 * @param {ns.util.anim.Animation} self
				 * @param {Event} event
				 * @private
				 * @static
				 * @member ns.util.anim.Animation
				 */
				handleEnd = function (self, event) {
					var options = self.options,
						element = options.element,
						onEnd = options.onEnd,
						onPause = options.onPause;

					if (event.animationName === self.keyframes.id) {
						switch (self.state) {
							case PLAYING:
								self.state = FINISHED;
								if (typeof onEnd === TYPE_FUNCTION) {
									onEnd(self, element, event);
								}
								break;
							case PAUSED:
								if (typeof onPause === TYPE_FUNCTION) {
									onPause(self, element, event);
								}
								break;
						}
					}
				},
				/**
				 * Helper for playing/pausing
				 * @param {ns.util.anim.Animation} self
				 * @param {string} state
				 * @return {ns.util.anim.Animation}
				 * @private
				 * @static
				 * @member ns.util.anim.Animation
				 */
				changeState = function (self, state) {
					var options,
						element = null,
						onPlay = null,
						style,
						keyframes,
						propString,
						propsArray,
						index;

					if (!self._applied) { // !set before keyframe fetch
						self._apply();
					}

					options = self.options;
					element = options.element;
					onPlay = options.onPlay;
					style = element.style;
					keyframes = self.keyframes;
					propString = style.getPropertyValue(cssPropertyPrefix +
						"animation-play-state");
					propsArray = (propString && propString.split(",").map(trim)) || [];
					index = keyframes ? getAnimationIndex(
						style.getPropertyValue(cssPropertyPrefix +
							"animation-name"),
						keyframes.id
					) : -1;

					if (index > -1) {
						propsArray[index] = state || "running";
						style.setProperty(cssPropertyPrefix +
							"animation-play-state", propsArray.join(","));
						self.state = PLAYING;
						if (typeof onPlay === TYPE_FUNCTION) {
							window.clearTimeout(self.playTimer);
							self.playTimer = window.setTimeout(function () {
								onPlay(self, element);
							}, dateUtils.convertToMiliseconds(options.delay));
						}
					}
					return self;
				},
				/**
				 * Constructor for Animation object
				 * @param {Object} options
				 * @param {HTMLElement} options.element The animated element
				 * @param {Object|null} [options.from=null] The starting step, this can be defined later
				 * @param {Object|null} [options.to=null]  The finishing step, this can also be defined later
				 * @param {Object[]} [options.steps=Array(0)] Animation steps, when advanced keying is required, the array must have 100 elements, which are percentages of the timeline (animation duration)
				 * @param {string} [options.duration="0"] The duration of the animation
				 * @param {string} [options.direction="normal"] The direction of the animation (for possible values, refer to CSS Animation spec)
				 * @param {string} [options.delay="0"] The delay of the animation. Please remember when using ns.util.anim.Chain with concurrent option to false, the of subsequent animations will be modified
				 * @param {string} [options.fillMode="none"] The fill mode of the animations (for possible values, refer to CSS Animation spec)
				 * @param {string} [options.timingFunction="ease"] Chooses the timing function for the css animation
				 * @param {boolean} [options.autoPlay=false] Defines if the animation will start after definition
				 * @constructor
				 * @member ns.util.anim.Animation
				 */
				Animation = function (options) {
					var self = this,
						/**
						 * @property {Object} options
						 * @property {HTMLElement} options.element The animated element
						 * @property {Object|null} [options.from=null] The starting step, this
						 *        can be defined later
						 * @property {Object|null} [options.to=null]  The finishing step, this
						 *        can also be defined later
						 * @property {Object[]} [options.steps=Array(0)] Animation steps,
						 *        when advanced keying is required, the array must have 100 elements,
						 *        which are percentages of the timeline (animation duration)
						 * @property {string} [options.duration="0"] The duration of the animation
						 * @property {string} [options.direction="normal"] The direction of the
						 *        animation (for possible values, refer to CSS Animation spec)
						 * @property {string} [options.delay="0"] The delay of the animation.
						 *        Please remember when using ns.util.anim.Chain with concurrent
						 *        option to false, the of subsequent animations will be modified
						 * @property {string} [options.fillMode="none"] The fill mode of the
						 *        animations (for possible values, refer to CSS Animation spec)
						 * @property {boolean} [options.preserve=false] Indicates if the last
						 *        key frame props should be kept after animation is destroyed
						 *        (not implemented!)
						 * @property {string} [options.timingFunction="ease"] Chooses the timing
						 *        function for the css animation (for possible values, refer to CSS
						 *        Animation spec)
						 * @property {boolean} [options.autoPlay=false] Defines if the animation
						 *        will start after definition
						 * @member ns.util.anim.Animation
						 */
						opts = objectUtils.merge({
							element: null,
							from: null,
							to: null,
							steps: [],
							duration: "0",
							direction: "normal",
							delay: "0",
							iterationCount: 1,
							infinite: false,
							fillMode: "none",
							preserve: false, //@TODO preserve props after animation destroy!
							onEnd: null,
							onPause: null,
							onPlay: null,
							timingFunction: "ease",
							autoPlay: false
						}, options || {}),
						steps,
						props,
						endCallback = handleEnd.bind(null, this),
						element = opts.element;

					if (opts.steps.length === 0) {
						steps = [];
						steps.length = 101;
						if (opts.to) {
							steps[100] = opts.to;
						}
						if (!opts.from) {
							if (opts.to && opts.element) {
								props = Object.keys(opts.to);
								CSSUtils.extractCSSProperties(opts.element, props);
								steps[0] = props;
							}
						} else {
							steps[0] = opts.from;
						}
					} else {
						steps = opts.steps;
					}

					self.options = opts;
					/**
					 * @property {Array.<Object>} steps Array of animation steps
					 * @readonly
					 */
					self.steps = steps;
					// indicates if the css props were applied
					self._applied = false;
					/**
					 * @property {ns.util.anim.Keyframes|null} keyframes Keyframes reference
					 * @readonly
					 */
					self.keyframes = null;
					/**
					 * @property {number} [state=0] Animation state
					 *        (ns.util.anim.Animation.states.*)
					 * @readonly
					 */
					self.state = PAUSED;
					// timer for onPlay callback (we need to simulate actual event firing
					self.playTimer = null;
					this._endCallback = endCallback;

					if (element) {
						element.addEventListener(endEventName, endCallback, false);
						if (opts.autoPlay) {
							self.play();
						}
					}

				},
				proto = {};

			/**
			 * Applies css properties for the element
			 * @method _apply
			 * @protected
			 * @member ns.util.anim.Animation
			 */
			proto._apply = function () {
				var self = this,
					opts = self.options,
					element = opts.element,
					style = element.style,
					propString = style.getPropertyValue(cssPropertyPrefix + "animation"),
					propsArray = (propString && propString.split(",").map(trim)) || [],
					id;

				self.keyframes = new Keyframes(self.steps);
				id = self.keyframes.id;
				if (element) {
					propsArray.push(id + " " + opts.duration + " " + opts.timingFunction +
						" " + opts.delay + " " + opts.iterationCount + " " + opts.direction +
						" " + opts.fillMode);
					element.style.setProperty(cssPropertyPrefix + "animation",
						propsArray.join(","));
					self._applied = true;
				}
			};

			/**
			 * Adds step to animation
			 * Note: this will reset the whole animation, so do it only in paused state
			 * @param {number} timePoint A keyframe number between from 0 to 100
			 * @param {Object} stepOptions Css props to change in the keyframe
			 * @return {ns.util.anim.Animation}
			 * @method step
			 * @member ns.util.anim.Animation
			 */
			proto.step = function (timePoint, stepOptions) {
				var self = this;

				self.steps[timePoint] = stepOptions;
				return self.reset();
			};

			/**
			 * Resets the animation
			 * @return {ns.util.anim.Animation}
			 * @method reset
			 * @member ns.util.anim.Animation
			 */
			proto.reset = function () {
				var self = this,
					keyframes = self.keyframes,
					style = self.options.element.style,
					propString = style.getPropertyValue(cssPropertyPrefix + "animation-name"),
					propsArray = (propString && propString.split(",").map(trim)) || [],
					index = keyframes ? propsArray.indexOf(keyframes.id) : -1;

				if (self.keyframes) {
					self.keyframes.destroy();
				}

				keyframes = new Keyframes(self.steps);
				if (index > -1) {
					propsArray[index] = keyframes.id;
					self.keyframes = keyframes;
					style.setProperty(cssPropertyPrefix + "animation-name",
						propsArray.join(","));
				}

				return self;
			};

			/**
			 * Starts playback
			 * @return {ns.util.anim.Animation}
			 * @method play
			 * @member ns.util.anim.Animation
			 */
			proto.play = function () {
				return changeState(this, "running");
			};

			/**
			 * Pauses playback
			 * @return {ns.util.anim.Animation}
			 * @method pause
			 * @member ns.util.anim.Animation
			 */
			proto.pause = function () {
				return changeState(this, "paused");
			};

			/**
			 * Destroys the animation
			 * Note: Please use "preserve" options to keep applied last animation props
			 * @return {ns.util.anim.Animation}
			 * @method destroy
			 * @member ns.util.anim.Animation
			 */
			proto.destroy = function () {
				var self = this,
					element = self.options.element,
					prop,
					style,
					keyframes = self.keyframes,
					endCallback = self._endCallback,
					propRegexp;

				if (element) {
					if (self._applied && keyframes) {
						style = element.style;
						prop = style.getPropertyValue(cssPropertyPrefix + "animation");
						if (prop) {
							propRegexp = new RegExp(",? ?" + keyframes.id + "[^,%]*,? ?", "i");
							style.removeProperty(cssPropertyPrefix + "animation",
								prop.replace(propRegexp, ""));
						}
						keyframes.destroy();
						self._applied = false;
					}
					if (endCallback) {
						element.removeEventListener(endEventName, endCallback, false);
					}
				}
				window.clearTimeout(self.playTimer);
			};

			/**
			 * @property {Object} states animation state definitions
			 * @property {number} [states.PAUSED=0] paused state
			 * @property {number} [states.PLAYING=1] playing state
			 * @property {number} [states.FINISHED=2] finished state
			 * @static
			 * @readonly
			 * @member ns.util.anim.Animation
			 */
			Animation.states = {
				"PAUSED": PAUSED,
				"PLAYING": PLAYING,
				"FINISHED": FINISHED
			};
			Animation.prototype = proto;
			ns.util.anim.Animation = Animation;
			}());

/*global define, ns */
/*jslint plusplus: true, nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # Chain
 *
 * Chain class for easy multiple animations management. The chain
 * can be executed as is (animations are concurrent) or in order
 * of adding in which animations are delayed so that the execute
 * in turn
 *
 * ## Usage example
 *
 * @example
 *
 *        <div id="test"
 *                style="width: 10px; height: 10px; background: red; position: absolute;">
 *        </div>
 *
 *        <script>
 *            var element = document.getElementById("test"),
 *                chain = new tau.util.anim.Chain(
 *                    {
 *						concurrent: false,
 *						onPlay: function () {
 *							console.log("chain started to play");
 *						},
 *						onPause: function () {
 *							console.log("chain paused");
 *						},
 *						onEnd: function () {
 *							console.log("chain finished");
 *						}
 *					},
 *                    [
 *                        {
 *							element: element,
 *							from: { "background-color": "red" },
 *							to: { "background-color": "blue"},
 *							duration: "3s",
 *							onPlay: function () {
 *								console.log("animation 1 started to play");
 *							},
 *							onPause: function () {
 *								console.log("animation 1 paused");
 *							},
 *							onEnd: function () {
 *								console.log("animation 1 finished");
 *							}
 *						},
 *                        {
 *							element: element,
 *						from: { "-webkit-transform": "translate3d(0,0,0)" },
 *							to: { "-webkit-transform": "translate3d(100px, 100px, 0)"},
 *							duration: "3s",
 *							onPlay: function () {
 *								console.log("animation 2 started to play");
 *							},
 *							onPause: function () {
 *								console.log("animation 2 paused");
 *							},
 *							onEnd: function () {
 *								console.log("animation 2 finished");
 *							}
 *						}
 *                    ]
 *                );
 *            chain.play();
 *        </script>
 *
 * @class ns.util.anim.Chain
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 */
(function () {
	"use strict";
				var Animation = ns.util.anim.Animation,
				objectUtils = ns.util.object,
				dateUtils = ns.util.date,
				// paused state flag
				PAUSED = 0,
				// playing state flag
				PLAYING = 1,
				// finished state flag
				FINISHED = 2,
				// function type for typeof comparisons
				TYPE_FUNCTION = "function",
				/**
				 * Animation end handler
				 * @param {ns.util.anim.Chain} self
				 * @param {ns.util.anim.Animation} animation
				 * @method handleEnd
				 * @member ns.util.anim.Chain
				 * @private
				 * @static
				 */
				handleEnd = function (self, animation) {
					var onEnd = self.options.onEnd,
						animations = self.animations,
						index = animations.indexOf(animation);

					self.current = index;
					if (index === animations.length - 1) {
						self.state = FINISHED;
						if (typeof onEnd === TYPE_FUNCTION) {
							onEnd(self);
						}
					}
				},
				Chain = function (options, animations) {
					/**
					 * @property {Object} options
					 * @property {boolean} [options.concurent='false'] Sets the type of the chain
					 * @property {function(ns.util.anim.Chain)} [options.onPlay=null] a callback for play start
					 * @property {function(ns.util.anim.Chain)} [options.onPause=null] a callback for play pause
					 * @property {function(ns.util.anim.Chain)} [options.onEnd=null] a callback for play end
					 */
					var opts = objectUtils.merge({
							conocurrent: true,
							onPlay: null,
							onPause: null,
							onEnd: null
						}, options || {}),
						self = this;
					/**
					 * @property {number} current Marks current animation
					 * @readonly
					 */

					self.current = null;
					/**
					 * @property {Array.<ns.util.anim.Animation>} animations The animations holder
					 * @readonly
					 */
					self.animations = [];
					/**
					 * @property {number} totalTime
					 * @readonly
					 */
					self.totalTime = 0;
					self.options = opts;
					/**
					 * @property {number} state=0 (ns.util.anim.Chain.states.*)
					 * @readonly
					 */
					self.state = PAUSED;

					if (animations && animations.length > 0) {
						self.addMultiple(animations);
					}
				},
				proto = {
					/**
					 * Adds animation to chain
					 * @param {ns.util.anim.Animation} animation
					 * @return {ns.util.anim.Chain}
					 * @method add
					 * @member ns.util.anim.Chain
					 */
					add: function (animation) {
						var animationInstance = animation instanceof Animation ?
								animation :
								new Animation(animation),
							animationOptions = animationInstance.options,
							time = dateUtils.convertToMiliseconds(animationOptions.duration),
							delay = dateUtils.convertToMiliseconds(animationOptions.delay),
							onEndCallback = animationOptions.onEnd,
							self = this;

						if (typeof onEndCallback === TYPE_FUNCTION) {
							animationOptions.onEnd = function (_animation, element, event) {
								onEndCallback(_animation, element, event);
								handleEnd(self, _animation);
							};
						} else {
							animationOptions.onEnd = handleEnd.bind(null, self);
						}

						if (self.options.concurrent === false) {
							animationOptions.delay = (delay + self.totalTime) + "ms";
							self.totalTime += delay + time;
						}

						self.animations.push(animationInstance);
						if (!self.current) {
							self.current = 0;
						}
						return self;
					},

					/**
					 * Adds multiple animations to chain
					 * @param {Array.<ns.util.anim.Animation>} animations
					 * @return {ns.util.anim.Chain}
					 * @method addMultiple
					 * @member ns.util.anim.Chain
					 */
					addMultiple: function (animations) {
						var i,
							l;

						for (i = 0, l = animations.length; i < l; ++i) {
							this.add(animations[i]);
						}
						return this;
					},

					/**
					 * Starts playing animation chain
					 * @method play
					 * @return {ns.util.anim.Chain}
					 * @member ns.util.anim.Chain
					 */
					play: function () {
						var i,
							l,
							self = this,
							onPlay = self.options.onPlay;

						for (i = self.current, l = self.animations.length; i < l; ++i) {
							self.animations[i].play();
						}
						self.state = PLAYING;
						if (typeof onPlay === TYPE_FUNCTION) {
							onPlay(self);
						}
						return self;
					},

					/**
					 * Pauses playback
					 * @method pause
					 * @return {ns.util.anim.Animation}
					 * @member ns.util.anim.Chain
					 */
					pause: function () {
						var i,
							l,
							self = this,
							onPause = self.options.onPause;

						for (i = self.current, l = self.animations.length; i < l; ++i) {
							self.animations[i].pause();
						}
						self.state = PAUSED;
						if (typeof onPause === TYPE_FUNCTION) {
							onPause(self);
						}
						return self;
					},

					/**
					 * Destroys chain and animations
					 * @method destroy
					 * @member ns.util.anim.Chain
					 */
					destroy: function () {
						var i,
							l;

						for (i = 0, l = this.animations.length; i < l; ++i) {
							this.animations[i].destroy();
						}
					}
				};

			/**
			 * Animation chain states
			 * @property {Object} states
			 * @property {number} [states.PAUSED = 0]
			 * @property {number} [states.PLAYING = 1]
			 * @property {number} [states.FINISHED = 2]
			 * @readonly
			 * @static
			 * @member ns.util.anim.Chain
			 */
			Chain.states = {
				"PAUSED": PAUSED,
				"PLAYING": PLAYING,
				"FINISHED": FINISHED
			};
			Chain.prototype = proto;
			ns.util.anim.Chain = Chain;
			}());

/*global window, ns, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Event hwkey
 * Namespace to support tizenhwkey event
 * @class ns.event.hwkey
 */
(function (window, ns) {
	"use strict";
				var popupClose = function (event) {
					var keyName = event.keyName,
						activePopup = ns.activePopup,
						container,
						containerClass,
						focused;

					// Check enableHWKeyHandler property
					if (ns.getConfig("enableHWKeyHandler", true) && activePopup) {
						container = activePopup._ui.container;
						containerClass = container && container.classList;
						if (keyName === "menu") {
							focused = activePopup.element.querySelector(".ui-focus");
							if (focused) {
								// NOTE: If a popup is opened and focused element exists in it,
								//       do not close that popup.
								//       'false' is returned here, hence popup close routine is not run.
								event.preventDefault();
								event.stopPropagation();
								return;
							}
						}
						if (keyName === "menu" || keyName === "back") {
							if (containerClass && (!containerClass.contains("ui-datetimepicker") || containerClass.contains("in"))) {
								activePopup.close();
								event.preventDefault();
								event.stopPropagation();
							}
						}
					}
				},
				selectMenuClose = function (event) {
					var keyName = event.keyName,
						elActiveSelectMenu,
						activeSelectMenu;

					if (ns.getConfig("enableHWKeyHandler", true) && (keyName === "menu" || keyName === "back")) {
						elActiveSelectMenu = document.querySelector("div.ui-selectmenu-active select");
						if (elActiveSelectMenu) {
							activeSelectMenu = ns.widget.SelectMenu(elActiveSelectMenu);
							activeSelectMenu.close();
							event.preventDefault();
							event.stopPropagation();
						}
					}
				},
				eventType = ns.engine.eventType,
				hwkey = {
					/**
					 * Bind event tizenhwkey to support hardware keys.
					 * @method bind
					 * @static
					 * @member ns.event.hwkey
					 */
					bind: function () {
						document.addEventListener("tizenhwkey", popupClose, true);
						document.addEventListener("tizenhwkey", selectMenuClose, true);
					},

					/**
					 * Unbind event tizenhwkey to support hardware keys.
					 * @method unbind
					 * @static
					 * @member ns.event.hwkey
					 */
					unbind: function () {
						document.removeEventListener("tizenhwkey", popupClose, true);
						document.removeEventListener("tizenhwkey", selectMenuClose, true);
					}
				};

			ns.event.hwkey = hwkey;

			function init() {
				hwkey.unbind();
				hwkey.bind();
			}

			function destroy() {
				document.removeEventListener(eventType.INIT, init, false);
				document.removeEventListener(eventType.DESTROY, destroy, false);
			}

			document.addEventListener(eventType.INIT, init, false);
			document.addEventListener(eventType.DESTROY, destroy, false);

			}(window, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, ns, define */
/**
 * #Event throttledresize
 * Object supports throttledresize event.
 * @class ns.event.throttledresize
 */
/**
 * Event throttledresize
 * @event throttledresize
 * @member ns.event.throttledresize
 */
(function (window) {
	"use strict";
				var throttledresize = {
					/**
					 * State of event support
					 * @property {boolean} [enabled=true]
					 * @static
					 * @member ns.event.throttledresize
					 */
					enabled: ns.getConfig("enableThrottleResize", true),
					/**
					 * Timeout of triggering event.
					 * @property {number} [ttl=250]
					 * @static
					 * @member ns.event.throttledresize
					 */
					ttl: 250
				},
				timerID,
				eventUtils = ns.event,
				resizeHandler = function () {
					if (timerID) {
						window.clearTimeout(timerID);
					}
					timerID = window.setTimeout(function () {
						eventUtils.trigger(window, "throttledresize");
					}, throttledresize.ttl);
				},
				/**
				 * Enables event support
				 * @method enable
				 * @static
				 * @member ns.event.throttledresize
				 */
				enable = function () {
					if (!throttledresize.enabled) {
						throttledresize.enabled = true;
					}
					window.addEventListener("resize", resizeHandler, true);
				},

				unbind = function () {
					throttledresize.enabled = false;
					window.removeEventListener("resize", resizeHandler, true);
				};

			if (throttledresize.enabled) {
				enable();
			}

			throttledresize.enable = enable;
			throttledresize.unbind = unbind;

			ns.event.throttledresize = throttledresize;

			}(window));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* global window, define, ns, CustomEvent */
/*
 * @class ns.event.gesture
 */
(function (ns) {
	"use strict";
			var event = ns.event,
			gesture = function (elem, options) {
				return new ns.event.gesture.Instance(elem, options);
			};

			/**
			 * Default values for Gesture feature
			 * @property {Object} defaults
			 * @property {boolean} [defaults.triggerEvent=false]
			 * @property {number} [defaults.updateVelocityInterval=16]
			 * Interval in which Gesture recalculates current velocity in ms
			 * @property {number} [defaults.estimatedPointerTimeDifference=15]
			 * pause time threshold.. tune the number to up if it is slow
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.defaults = {
			triggerEvent: false,
			updateVelocityInterval: 16,
			estimatedPointerTimeDifference: 15
		};

		/**
			 * Dictionary of orientation
			 * @property {Object} Orientation
			 * @property {1} Orientation.VERTICAL vertical orientation
			 * @property {2} Orientation.HORIZONTAL horizontal orientation
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.Orientation = {
			VERTICAL: "vertical",
			HORIZONTAL: "horizontal"
		};

		/**
			 * Dictionary of direction
			 * @property {Object} Direction
			 * @property {1} Direction.UP up
			 * @property {2} Direction.DOWN down
			 * @property {3} Direction.LEFT left
			 * @property {4} Direction.RIGHT right
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.Direction = {
			UP: "up",
			DOWN: "down",
			LEFT: "left",
			RIGHT: "right"
		};

		/**
			 * Dictionary of gesture events state
			 * @property {Object} Event
			 * @property {"start"} Event.START start
			 * @property {"move"} Event.MOVE move
			 * @property {"end"} Event.END end
			 * @property {"cancel"} Event.CANCEL cancel
			 * @property {"blocked"} Event.BLOCKED blocked
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.Event = {
			START: "start",
			MOVE: "move",
			END: "end",
			CANCEL: "cancel",
			BLOCKED: "blocked"
		};

		/**
			 * Dictionary of gesture events flags
			 * @property {Object} Result
			 * @property {number} [Result.PENDING=1] is pending
			 * @property {number} [Result.RUNNING=2] is running
			 * @property {number} [Result.FINISHED=4] is finished
			 * @property {number} [Result.BLOCK=8] is blocked
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.Result = {
			PENDING: 1,
			RUNNING: 2,
			FINISHED: 4,
			BLOCK: 8
		};

		/**
			 * Create plugin namespace.
			 * @property {Object} plugin
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.plugin = {};

		/**
			 * Create object of Detector
			 * @method createDetector
			 * @param {string} gesture
			 * @param {HTMLElement} eventSender
			 * @param {Object} options
			 * @return {ns.event.gesture.Gesture}
			 * @member ns.event.gesture
			 * @static
			 */
		gesture.createDetector = function (gesture, eventSender, options) {
			if (!gesture.plugin[gesture]) {
				throw gesture + " gesture is not supported";
			}
			return new gesture.plugin[gesture](eventSender, options);
		};

		event.gesture = gesture;
		}(ns));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Gesture.Detector class
 * Base class for create detectors in gestures.
 *
 * @class ns.event.gesture.Detector
 */
(function (ns) {
	"use strict";
				var gesture = ns.event.gesture,

				objectMerge = ns.util.object.merge,

				Detector = function (strategy, sender) {
					this.sender = sender;
					this.strategy = strategy.create();
					this.name = this.strategy.name;
					this.index = this.strategy.index || 100;
					this.options = this.strategy.options || {};
				};

			/**
			 * Start of gesture detection of given type
			 * @method detect
			 * @param {string} gestureEvent
			 * @return {Object}
			 * @member ns.event.gesture.Detector
			 */
			Detector.prototype.detect = function (gestureEvent) {
				return this.strategy.handler(gestureEvent, this.sender, this.strategy.options);
			};

			Detector.Sender = {
				sendEvent: function () {
				// Empty function for creating interface
				}
			};

		/**
			 * Create plugin namespace.
			 * @property {Object} plugin
			 * @member ns.event.gesture.Detector
			 */
			Detector.plugin = {};

		/**
			 * Methods creates plugin
			 * @method create
			 * @param {Object} gestureHandler
			 * @return {ns.event.gesture.Detector} gestureHandler
			 * @member ns.event.gesture.Detector.plugin
			 */
			Detector.plugin.create = function (gestureHandler) {
				var detector;

				if (!gestureHandler.types) {
					gestureHandler.types = [gestureHandler.name];
				}

				detector = function (options) {
					this.options = objectMerge({}, gestureHandler.defaults, options);
				};

				detector.prototype.create = function () {
					return objectMerge({
						options: this.options
					}, gestureHandler);
				};

				Detector.plugin[gestureHandler.name] = detector;

				return detector;
			};

		// definition
			gesture.Detector = Detector;

		}(ns));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Gesture Utilities
 * Contains helper function to gesture support.
 * @class ns.event.gesture.utils
 */
(function (ns, Math) {
	"use strict";
	
		/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.utils
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture;

			gesture.utils = {

			/**
				 * Get center from array of touches
				 * @method getCenter
				 * @param {Event[]} touches description
				 * @member ns.event.gesture.utils
				 * @return {Object} position
				 * @return {number} return.clientX position X
				 * @return {number} return.clientY position Y
				 */
				getCenter: function (touches) {
					var valuesX = [],
						valuesY = [];

					[].forEach.call(touches, function (touch) {
					// I prefer clientX because it ignore the scrolling position
						valuesX.push(!isNaN(touch.clientX) ? touch.clientX : touch.pageX);
						valuesY.push(!isNaN(touch.clientY) ? touch.clientY : touch.pageY);
					});

					return {
						clientX: (Math.min.apply(Math, valuesX) + Math.max.apply(Math, valuesX)) / 2,
						clientY: (Math.min.apply(Math, valuesY) + Math.max.apply(Math, valuesY)) / 2
					};
				},

			/**
				 * Get velocity
				 * @method getVelocity
				 * @param {number} deltaTime Delta of time
				 * @param {number} deltaX Position change on x axis
				 * @param {number} deltaY Position change on y axis
				 * @return {Object} velocity
				 * @return {number} return.x velocity on X axis
				 * @return {number} return.y velocity on Y axis
				 * @member ns.event.gesture.utils
				 */
				getVelocity: function (deltaTime, deltaX, deltaY) {
					return {
						x: Math.abs(deltaX / deltaTime) || 0,
						y: Math.abs(deltaY / deltaTime) || 0
					};
				},

			/**
				 * Get angel between position of two touches
				 * @method getAngle
				 * @param {Event} touch1 first touch
				 * @param {Event} touch2 second touch
				 * @return {number} angel (deg)
				 * @member ns.event.gesture.utils
				 */
				getAngle: function (touch1, touch2) {
					var y = touch2.clientY - touch1.clientY,
						x = touch2.clientX - touch1.clientX;

					return Math.atan2(y, x) * 180 / Math.PI;
				},

			/**
				 * Get direction indicated by position of two touches
				 * @method getDirection
				 * @param {Event} touch1 first touch
				 * @param {Event} touch2 second touch
				 * @return {ns.event.gesture.Direction.LEFT|ns.event.gesture.Direction.RIGHT|ns.event.gesture.Direction.UP|ns.event.gesture.Direction.DOWN}
				 * @member ns.event.gesture.utils
				 */
				getDirection: function (touch1, touch2) {
					var x = Math.abs(touch1.clientX - touch2.clientX),
						y = Math.abs(touch1.clientY - touch2.clientY);

					if (x >= y) {
						return touch1.clientX - touch2.clientX > 0 ? gesture.Direction.LEFT : gesture.Direction.RIGHT;
					}
					return touch1.clientY - touch2.clientY > 0 ? gesture.Direction.UP : gesture.Direction.DOWN;
				},

			/**
				 * Get distance indicated by position of two touches
				 * @method getDistance
				 * @param {Event} touch1 first touch
				 * @param {Event} touch2 second touch
				 * @return {number} distance
				 * @member ns.event.gesture.utils
				 */
				getDistance: function (touch1, touch2) {
					var x = touch2.clientX - touch1.clientX,
						y = touch2.clientY - touch1.clientY;

					return Math.sqrt((x * x) + (y * y));
				},

			/**
				 * Get scale indicated by position of the first and the last touch
				 * @method getScale
				 * @param {Event} start start touch
				 * @param {Event} end end touch
				 * @return {number} scale
				 * @member ns.event.gesture.utils
				 */
				getScale: function (start, end) {
				// need two fingers...
					if (start.length >= 2 && end.length >= 2) {
						return this.getDistance(end[0], end[1]) / this.getDistance(start[0], start[1]);
					}
					return 1;
				},

			/**
				 * Get value of rotation indicated by position
				 * of the first and the last touch
				 * @method getRotation
				 * @param {Event} start start touch
				 * @param {Event} end end touch
				 * @return {number} angle (deg)
				 * @member ns.event.gesture.utils
				 */
				getRotation: function (start, end) {
				// need two fingers
					if (start.length >= 2 && end.length >= 2) {
						return this.getAngle(end[1], end[0]) -
							this.getAngle(start[1], start[0]);
					}
					return 0;
				},

			/**
				 * Check if the direction is vertical
				 * @method isVertical
				 * @param {ns.event.gesture.Direction.LEFT|ns.event.gesture.Direction.RIGHT|ns.event.gesture.Direction.UP|ns.event.gesture.Direction.DOWN} direction start touch
				 * @return {boolean}
				 * @member ns.event.gesture.utils
				 */
				isVertical: function (direction) {
					return direction === gesture.Direction.UP || direction === gesture.Direction.DOWN;
				},

			/**
				 * Check if the direction is horizontal
				 * @method isHorizontal
				 * @param {ns.event.gesture.Direction.LEFT|ns.event.gesture.Direction.RIGHT|ns.event.gesture.Direction.UP|ns.event.gesture.Direction.DOWN} direction start touch
				 * @return {boolean}
				 * @member ns.event.gesture.utils
				 */
				isHorizontal: function (direction) {
					return direction === gesture.Direction.LEFT || direction === gesture.Direction.RIGHT;
				},

			/**
				 * Check if the direction is horizontal
				 * @method getOrientation
				 * @param {ns.event.gesture.Direction.LEFT|ns.event.gesture.Direction.RIGHT|ns.event.gesture.Direction.UP|ns.event.gesture.Direction.DOWN} direction
				 * @return {boolean}
				 * @member ns.event.gesture.utils
				 */
				getOrientation: function (direction) {
					return this.isVertical(direction) ? gesture.Orientation.VERTICAL : gesture.Orientation.HORIZONTAL;
				}
			};
		}(ns, window.Math));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Gesture.Manager class
 * Main class controls all gestures.
 * @class ns.event.gesture.Manager
 */
(function (ns, window, document) {
	"use strict";
	
		/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.Manager
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture,

				gestureUtils = gesture.utils,

				utilObject = ns.util.object,

				instance = null,

				touchCheck = /touch/,

				Manager = function () {
					var self = this;

					self.instances = [];
					self.gestureDetectors = [];
					self.runningDetectors = [];
					self.detectorRequestedBlock = null;

					self.unregisterBlockList = [];

					self.gestureEvents = {};
					self.velocity = null;

					self._isReadyDetecting = false;
					self._blockMouseEvent = false;
					self.touchSupport = "ontouchstart" in window;
				};

			function sortInstances(a, b) {
				if (a.index < b.index) {
					return -1;
				} else if (a.index > b.index) {
					return 1;
				}
				return 0;
			}

			Manager.prototype = {
			/**
				 * Bind start events
				 * @method _bindStartEvents
				 * @param {ns.event.gesture.Instance} _instance gesture instance
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_bindStartEvents: function (_instance) {
					var element = _instance.getElement();

					if (this.touchSupport) {
						element.addEventListener("touchstart", this, false);
					} else {
						element.addEventListener("mousedown", this, false);
					}
				},

			/**
				 * Bind move, end and cancel events
				 * @method _bindEvents
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_bindEvents: function () {
					var self = this;

					if (self.touchSupport) {
						document.addEventListener("touchmove", self);
						document.addEventListener("touchend", self);
						document.addEventListener("touchcancel", self);
					} else {
						document.addEventListener("mousemove", self);
						document.addEventListener("mouseup", self);
					}
				},

			/**
				 * Unbind start events
				 * @method _unbindStartEvents
				 * @param {ns.event.gesture.Instance} _instance gesture instance
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_unbindStartEvents: function (_instance) {
					var element = _instance.getElement();

					if (this.touchSupport) {
						element.removeEventListener("touchstart", this, false);
					} else {
						element.removeEventListener("mousedown", this, false);
					}
				},

			/**
				 * Unbind move, end and cancel events
				 * @method _bindEvents
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_unbindEvents: function () {
					var self = this;

					if (self.touchSupport) {
						document.removeEventListener("touchmove", self, false);
						document.removeEventListener("touchend", self, false);
						document.removeEventListener("touchcancel", self, false);
					} else {
						document.removeEventListener("mousemove", self, false);
						document.removeEventListener("mouseup", self, false);
					}
				},

			/**
				 * Detect that event should be processed by handleEvent
				 * @param {Event} event Input event object
				 * @return {null|string}
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_detectEventType: function (event) {
					var eventType = event.type;

					if (eventType.match(touchCheck)) {
						this._blockMouseEvent = true;
					} else {
						if (this._blockMouseEvent || event.which !== 1) {
							return null;
						}
					}
					return eventType;
				},

			/**
				 * Handle event
				 * @method handleEvent
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				handleEvent: function (event) {
					var self = this,
						eventType = self._detectEventType(event);

					switch (eventType) {
						case "mousedown":
						case "touchstart":
							self._start(event);
							break;
						case "mousemove":
						case "touchmove":
							self._move(event);
							break;
						case "mouseup":
						case "touchend":
							self._end(event);
							break;
						case "touchcancel":
							self._cancel(event);
							break;
					}
				},

			/**
				 * Handler for gesture start
				 * @method _start
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_start: function (event) {
					var self = this,
						element = event.currentTarget,
						startEvent = {},
						detectors = [];

					if (!self._isReadyDetecting) {
						self._resetDetecting();
						self._bindEvents();

						startEvent = self._createDefaultEventData(gesture.Event.START, event);

						self.gestureEvents = {
							start: startEvent,
							last: startEvent
						};

						self.velocity = {
							event: startEvent,
							x: 0,
							y: 0
						};

						startEvent = utilObject.fastMerge(startEvent,
							self._createGestureEvent(gesture.Event.START, event));
						self._isReadyDetecting = true;
					}

					self.instances.forEach(function (_instance) {
						if (_instance.getElement() === element) {
							detectors = detectors.concat(_instance.getGestureDetectors());
						}
					}, self);

					detectors.sort(sortInstances);

					self.gestureDetectors = self.gestureDetectors.concat(detectors);

					self._detect(detectors, startEvent);
				},

			/**
				 * Handler for gesture move
				 * @method _move
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_move: function (event) {
					var newEvent,
						self = this;

					if (self._isReadyDetecting) {
						newEvent = self._createGestureEvent(gesture.Event.MOVE, event);
						self._detect(self.gestureDetectors, newEvent);
						self.gestureEvents.last = newEvent;
					}
				},

			/**
				 * Handler for gesture end
				 * @method _end
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_end: function (event) {
					var self = this,
						newEvent = utilObject.merge(
						{},
							self.gestureEvents.last,
							self._createDefaultEventData(gesture.Event.END, event)
					);

					if (newEvent.pointers.length === 0) {
						self._detect(self.gestureDetectors, newEvent);

						self.unregisterBlockList.forEach(function (_instance) {
							this.unregister(_instance);
						}, self);

						self._resetDetecting();
						self._blockMouseEvent = false;
					}
				},

			/**
				 * Handler for gesture cancel
				 * @method _cancel
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_cancel: function (event) {
					var self = this;

					event = utilObject.merge(
					{},
						self.gestureEvents.last,
						self._createDefaultEventData(gesture.Event.CANCEL, event)
				);

					self._detect(self.gestureDetectors, event);

					self.unregisterBlockList.forEach(function (_instance) {
						this.unregister(_instance);
					}, self);

					self._resetDetecting();
					self._blockMouseEvent = false;
				},

			/**
				 * Detect gesture
				 * @method _detect
				 * @param {Array} detectors
				 * @param {Event} event
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_detect: function (detectors, event) {
					var self = this,
						finishedDetectors = [];

					detectors.forEach(function (detector) {
						var result;

						if (!self.detectorRequestedBlock) {
							result = detector.detect(event);
							if ((result & gesture.Result.RUNNING) &&
								self.runningDetectors.indexOf(detector) < 0) {
								self.runningDetectors.push(detector);
							}
							if (result & gesture.Result.FINISHED) {
								finishedDetectors.push(detector);
							}
							if (result & gesture.Result.BLOCK) {
								self.detectorRequestedBlock = detector;
							}
						}
					});

				// remove finished detectors.
					finishedDetectors.forEach(function (detector) {
						var idx = self.gestureDetectors.indexOf(detector);

						if (idx > -1) {
							self.gestureDetectors.splice(idx, 1);
						}
						idx = self.runningDetectors.indexOf(detector);
						if (idx > -1) {
							self.runningDetectors.splice(idx, 1);
						}
					});

				// remove all detectors except the detector that return block result
					if (self.detectorRequestedBlock) {
					// send to cancel event.
						self.runningDetectors.forEach(function (detector) {
							var cancelEvent = utilObject.fastMerge({}, event);

							cancelEvent.eventType = gesture.Event.BLOCKED;
							detector.detect(cancelEvent);
						});
						self.runningDetectors.length = 0;
						self.gestureDetectors.length = 0;
						if (finishedDetectors.indexOf(self.detectorRequestedBlock) < 0) {
							self.gestureDetectors.push(self.detectorRequestedBlock);
						}
					}
				},

			/**
				 * Reset of gesture manager detector
				 * @method _resetDetecting
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_resetDetecting: function () {
					var self = this;

					self._isReadyDetecting = false;

					self.gestureDetectors.length = 0;
					self.runningDetectors.length = 0;
					self.detectorRequestedBlock = null;

					self.gestureEvents = {};
					self.velocity = null;

					self._unbindEvents();
				},

			/**
				 * Create default event data
				 * @method _createDefaultEventData
				 * @param {string} type event type
				 * @param {Event} event source event
				 * @return {Object} default event data
				 * @return {string} return.eventType
				 * @return {number} return.timeStamp
				 * @return {Touch} return.pointer
				 * @return {TouchList} return.pointers
				 * @return {Event} return.srcEvent
				 * @return {Function} return.preventDefault
				 * @return {Function} return.stopPropagation
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_createDefaultEventData: function (type, event) {
					var pointers = event.touches;

					if (!pointers) {
						if (event.type === "mouseup") {
							pointers = [];
						} else {
							event.identifier = 1;
							pointers = [event];
						}
					}

					return {
						eventType: type,
						timeStamp: Date.now(),
						pointer: pointers[0],
						pointers: pointers,

						srcEvent: event,
						preventDefault: event.preventDefault.bind(event),
						stopPropagation: event.stopPropagation.bind(event)
					};
				},

			/**
				 * Create gesture event
				 * @method _createGestureEvent
				 * @param {string} type event type
				 * @param {Event} event source event
				 * @return {Object} gesture event consist from Event class and additional properties
				 * @return {number} return.deltaTime
				 * @return {number} return.deltaX
				 * @return {number} return.deltaY
				 * @return {number} return.velocityX
				 * @return {number} return.velocityY
				 * @return {number} return.estimatedX
				 * @return {number} return.estimatedY
				 * @return {number} return.estimatedDeltaX
				 * @return {number} return.estimatedDeltaY
				 * @return {number} return.distance
				 * @return {number} return.angle
				 * @return {number} return.direction
				 * @return {number} return.scale
				 * @return {number} return.rotation (deg)
				 * @return {Event} return.startEvent
				 * @return {Event} return.lastEvent
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_createGestureEvent: function (type, event) {
					var self = this,
						defaultEvent = self._createDefaultEventData(type, event),
						startEvent = self.gestureEvents.start,
						lastEvent = self.gestureEvents.last,
						velocity = self.velocity,
						velocityEvent = velocity.event,
						delta = {
							time: defaultEvent.timeStamp - startEvent.timeStamp,
							x: defaultEvent.pointer.clientX - startEvent.pointer.clientX,
							y: defaultEvent.pointer.clientY - startEvent.pointer.clientY
						},
						deltaFromLast = {
							x: defaultEvent.pointer.clientX - lastEvent.pointer.clientX,
							y: defaultEvent.pointer.clientY - lastEvent.pointer.clientY
						},
					/* pause time threshold.util. tune the number to up if it is slow */
						timeDifference = gesture.defaults.estimatedPointerTimeDifference,
						estimated;

					// reset start event for multi touch
					if (startEvent && defaultEvent.pointers.length !== startEvent.pointers.length) {
						startEvent.pointers = Array.prototype.slice.call(defaultEvent.pointers);
					}

					if (defaultEvent.timeStamp - velocityEvent.timeStamp >
						gesture.defaults.updateVelocityInterval) {
						utilObject.fastMerge(velocity, gestureUtils.getVelocity(
							defaultEvent.timeStamp - velocityEvent.timeStamp,
							defaultEvent.pointer.clientX - velocityEvent.pointer.clientX,
							defaultEvent.pointer.clientY - velocityEvent.pointer.clientY
					));
						velocity.event = defaultEvent;
					}

					estimated = {
						x: Math.round(defaultEvent.pointer.clientX +
							(timeDifference * velocity.x * (deltaFromLast.x < 0 ? -1 : 1))),
						y: Math.round(defaultEvent.pointer.clientY +
							(timeDifference * velocity.y * (deltaFromLast.y < 0 ? -1 : 1)))
					};

				// Prevent that point goes back even though direction is not changed.
					if ((deltaFromLast.x < 0 && estimated.x > lastEvent.estimatedX) ||
						(deltaFromLast.x > 0 && estimated.x < lastEvent.estimatedX)) {
						estimated.x = lastEvent.estimatedX;
					}

					if ((deltaFromLast.y < 0 && estimated.y > lastEvent.estimatedY) ||
						(deltaFromLast.y > 0 && estimated.y < lastEvent.estimatedY)) {
						estimated.y = lastEvent.estimatedY;
					}

					utilObject.fastMerge(defaultEvent, {
						deltaTime: delta.time,
						deltaX: delta.x,
						deltaY: delta.y,

						velocityX: velocity.x,
						velocityY: velocity.y,

						estimatedX: estimated.x,
						estimatedY: estimated.y,
						estimatedDeltaX: estimated.x - startEvent.pointer.clientX,
						estimatedDeltaY: estimated.y - startEvent.pointer.clientY,

						distance: gestureUtils.getDistance(startEvent.pointer, defaultEvent.pointer),

						angle: gestureUtils.getAngle(startEvent.pointer, defaultEvent.pointer),

						direction: gestureUtils.getDirection(startEvent.pointer, defaultEvent.pointer),

						scale: gestureUtils.getScale(startEvent.pointers, defaultEvent.pointers),
						rotation: gestureUtils.getRotation(startEvent.pointers, defaultEvent.pointers),

						startEvent: startEvent,
						lastEvent: lastEvent
					});

					return defaultEvent;
				},

			/**
				 * Register instance of gesture
				 * @method register
				 * @param {ns.event.gesture.Instance} instance gesture instance
				 * @member ns.event.gesture.Manager
				 */
				register: function (instance) {
					var self = this,
						idx = self.instances.indexOf(instance);

					if (idx < 0) {
						self.instances.push(instance);
						self._bindStartEvents(instance);
					}
				},

			/**
				 * Unregister instance of gesture
				 * @method unregister
				 * @param {ns.event.gesture.Instance} instance gesture instance
				 * @member ns.event.gesture.Manager
				 */
				unregister: function (instance) {
					var idx,
						self = this;

					if (self.gestureDetectors.length) {
						self.unregisterBlockList.push(instance);
					} else {
						idx = self.instances.indexOf(instance);
						if (idx > -1) {
							self.instances.splice(idx, 1);
							self._unbindStartEvents(instance);
						}

						if (!self.instances.length) {
							self._destroy();
						}
					}
				},

			/**
				 * Destroy instance of Manager
				 * @method _destroy
				 * @member ns.event.gesture.Manager
				 * @protected
				 */
				_destroy: function () {
					var self = this;

					self._resetDetecting();
					self.instances.length = 0;
					self.unregisterBlockList.length = 0;
					self._blockMouseEvent = false;
					instance = null;
				}

			};

			Manager.getInstance = function () {
				if (!instance) {
					instance = new Manager();
				}
				return instance;
			};

			gesture.Manager = Manager;
		}(ns, window, window.document));

/*global ns, window, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
(function (ns) {
	"use strict";
			/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.Instance
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture,
			/**
				 * Local alias for {@link ns.event.gesture.Detector}
				 * @property {Object}
				 * @member ns.event.gesture.Instance
				 * @private
				 * @static
				 */
				Detector = gesture.Detector,
			/**
				 * Local alias for {@link ns.event.gesture.Manager}
				 * @property {Object}
				 * @member ns.event.gesture.Instance
				 * @private
				 * @static
				 */
				Manager = gesture.Manager,
			/**
				 * Local alias for {@link ns.event}
				 * @property {Object}
				 * @member ns.event.gesture.Instance
				 * @private
				 * @static
				 */
				events = ns.event,
			/**
				 * Alias for method {@link ns.util.object.merge}
				 * @property {Function} merge
				 * @member ns.event.gesture.Instance
				 * @private
				 * @static
				 */
				merge = ns.util.object.merge,

			/**
				 * #Gesture.Instance class
				 * Creates instance of gesture manager on element.
				 * @param {HTMLElement} element
				 * @param {Object} options
				 * @class ns.event.gesture.Instance
				 */
				Instance = function (element, options) {
					this.element = element;
					this.eventDetectors = [];
					this.options = merge({}, gesture.defaults, options);

					this.gestureManager = Manager.getInstance();
					this.eventSender = merge({}, Detector.Sender, {
						sendEvent: this.trigger.bind(this)
					});
				};

			Instance.prototype = {
			/**
				 * Set options
				 * @method setOptions
				 * @param {Object} options options
				 * @return {ns.event.gesture.Instance}
				 * @member ns.event.gesture.Instance
				 */
				setOptions: function (options) {
					merge(this.options, options);
					return this;
				},

			/**
				 * Add detector
				 * @method addDetector
				 * @param {Object} detectorStrategy strategy
				 * @return {ns.event.gesture.Instance}
				 * @member ns.event.gesture.Instance
				 */
				addDetector: function (detectorStrategy) {
					var detector = new Detector(detectorStrategy, this.eventSender),
						alreadyHasDetector = !!this.eventDetectors.length;

					this.eventDetectors.push(detector);

					if (!!this.eventDetectors.length && !alreadyHasDetector) {
						this.gestureManager.register(this);
					}

					return this;
				},

			/**
				 * Remove detector
				 * @method removeDetector
				 * @param {Object} detectorStrategy strategy
				 * @return {ns.event.gesture.Instance}
				 * @member ns.event.gesture.Instance
				 */
				removeDetector: function (detectorStrategy) {
					var idx = this.eventDetectors.indexOf(detectorStrategy);

					if (idx > -1) {
						this.eventDetectors.splice(idx, 1);
					}

					if (!this.eventDetectors.length) {
						this.gestureManager.unregister(this);
					}

					return this;
				},

			/**
				 * Triggers the gesture event
				 * @method trigger
				 * @param {string} gestureName gestureName name
				 * @param {Object} eventInfo data provided to event object
				 * @member ns.event.gesture.Instance
				 */
				trigger: function (gestureName, eventInfo) {
					return events.trigger(this.element, gestureName, eventInfo, false);
				},

			/**
				 * Get HTML element assigned to gesture event instance
				 * @method getElement
				 * @member ns.event.gesture.Instance
				 */
				getElement: function () {
					return this.element;
				},

			/**
				 * Get gesture event detectors assigned to instance
				 * @method getGestureDetectors
				 * @member ns.event.gesture.Instance
				 */
				getGestureDetectors: function () {
					return this.eventDetectors;
				},

			/**
				 * Destroy instance
				 * @method destroy
				 * @member ns.event.gesture.Instance
				 */
				destroy: function () {
					this.element = null;
					this.eventHandlers = {};
					this.gestureManager = null;
					this.eventSender = null;
					this.eventDetectors.length = 0;
				}
			};

			gesture.Instance = Instance;

		}(ns));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # Gesture Plugin: drag
 * Plugin enables drag event.
 *
 * @class ns.event.gesture.Drag
 */
(function (ns, window, tizen) {
	"use strict";
	
		/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.Drag
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture,
			/**
				 * Local alias for {@link ns.event.gesture.Detector}
				 * @property {Object}
				 * @member ns.event.gesture.Drag
				 * @private
				 * @static
				 */
				gestureUtils = gesture.utils,

				Detector = gesture.Detector,
			/**
				 * Alias for method {@link ns.util.object.merge}
				 * @property {Function} merge
				 * @member ns.event.gesture.Drag
				 * @private
				 * @static
				 */
				merge = ns.util.object.merge,

				eventNames = {
					start: "dragstart",
					drag: "drag",
					end: "dragend",
					cancel: "dragcancel",
					prepare: "dragprepare"
				},

			// TODO UA test will move to support.
				isTizenWebkit2Browser = !!window.navigator.userAgent.match(/tizen/i) && (function () {
					var result = true,
						version;

					if (tizen && tizen.systeminfo && tizen.systeminfo.getCapability) {
						try {
							version = tizen.systeminfo.getCapability("http://tizen.org/feature/platform.version");
							return version < "3.0";
						} catch (error) {
							ns.error("Error name: " + error.name + ", message: " + error.message);
						}
					}
					return result;
				})(),

				isChromeBrowser = window.navigator.userAgent.indexOf("Chrome") > -1,

				RESULTS = gesture.Result,

				Drag = Detector.plugin.create({

				/**
					 * Gesture name
					 * @property {string} [name="drag"]
					 * @member ns.event.gesture.Drag
					 */
					name: "drag",

				/**
					 * Gesture Index
					 * @property {number} [index=500]
					 * @member ns.event.gesture.Drag
					 */
					index: 500,

				/**
					 * Default values for drag gesture
					 * @property {Object} defaults
					 * @property {boolean} [defaults.blockHorizontal=false]
					 * @property {boolean} [defaults.blockVertical=false]
					 * @property {number} [defaults.threshold=20]
					 * @property {number} [defaults.delay=0]
					 * @member ns.event.gesture.Drag
					 */
					defaults: {
						blockHorizontal: false,
						blockVertical: false,
						threshold: 20,
						delay: 0
					},

				/**
					 * Triggered
					 * @property {boolean} [isTriggered=false]
					 * @member ns.event.gesture.Drag
					 */
					isTriggered: false,

				/**
					 * Handler for drag gesture
					 * @method handler
					 * @param {Event} gestureEvent gesture event
					 * @param {Object} sender event's sender
					 * @param {Object} options options
					 * @return {number}
					 * @member ns.event.gesture.Drag
					 */
					handler: function (gestureEvent, sender, options) {
						var newGestureEvent,
							threshold = options.threshold,
							result = RESULTS.PENDING,
							direction = gestureEvent.direction;

						if (!this.isTriggered && gestureEvent.eventType === gesture.Event.MOVE) {
							if (Math.abs(gestureEvent.deltaX) < threshold && Math.abs(gestureEvent.deltaY) < threshold) {
							// Branching statement for specifying Tizen 2.X and Tizen 3.0
								if (isChromeBrowser) {
									gestureEvent.preventDefault();
								}
								return RESULTS.PENDING;
							}

							if (options.delay && gestureEvent.deltaTime < options.delay) {
								if (!isTizenWebkit2Browser) {
									gestureEvent.preventDefault();
								}
								return RESULTS.PENDING;
							}

							if (options.blockHorizontal && gestureUtils.isHorizontal(gestureEvent.direction) ||
								options.blockVertical && gestureUtils.isVertical(gestureEvent.direction)) {
								return RESULTS.FINISHED;
							}

							this.fixedStartPointX = 0;
							this.fixedStartPointY = 0;
							if (gestureUtils.isHorizontal(gestureEvent.direction)) {
								this.fixedStartPointX = (gestureEvent.deltaX < 0 ? 1 : -1) * threshold;
							} else {
								this.fixedStartPointY = (gestureEvent.deltaY < 0 ? 1 : -1) * threshold;
							}
						}

						if (options.blockHorizontal) {
							direction = gestureEvent.deltaY < 0 ? gesture.Direction.UP : gesture.Direction.DOWN;
						}

						if (options.blockVertical) {
							direction = gestureEvent.deltaX < 0 ? gesture.Direction.LEFT : gesture.Direction.RIGHT;
						}

						newGestureEvent = merge({}, gestureEvent, {
							deltaX: gestureEvent.deltaX + this.fixedStartPointX,
							deltaY: gestureEvent.deltaY + this.fixedStartPointY,
							estimatedDeltaX: gestureEvent.estimatedDeltaX + this.fixedStartPointX,
							estimatedDeltaY: gestureEvent.estimatedDeltaY + this.fixedStartPointY,

							direction: direction
						});

						switch (newGestureEvent.eventType) {
							case gesture.Event.START:
								this.isTriggered = false;
								if (sender.sendEvent(eventNames.prepare, newGestureEvent) === false) {
									result = RESULTS.FINISHED;
								}
								break;
							case gesture.Event.MOVE:
								if (!this.isTriggered && sender.sendEvent(eventNames.start, newGestureEvent) === false) {
									newGestureEvent.preventDefault();
								}
								result = sender.sendEvent(eventNames.drag, newGestureEvent) ? RESULTS.RUNNING : RESULTS.FINISHED;
								if (result === false) {
									newGestureEvent.preventDefault();
								}
								this.isTriggered = true;
								break;

							case gesture.Event.BLOCKED:
							case gesture.Event.END:
								result = RESULTS.FINISHED;
								if (this.isTriggered) {
									if (sender.sendEvent(eventNames.end, newGestureEvent) === false) {
										newGestureEvent.preventDefault();
									}
									this.isTriggered = false;
								}
								break;

							case gesture.Event.CANCEL:
								result = RESULTS.FINISHED;
								if (this.isTriggered) {
									if (sender.sendEvent(eventNames.cancel, newGestureEvent) === false) {
										newGestureEvent.preventDefault();
									}
									this.isTriggered = false;
								}
								break;
						}

						return result;
					}
				});

			ns.event.gesture.Drag = Drag;
		}(ns, window, window.tizen));

/*global ns, window, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Gesture Plugin: swipe
 * Plugin enables swipe event.
 *
 * @class ns.event.gesture.Swipe
 */
(function (ns) {
	"use strict";
	
			var gesture = ns.event.gesture,
				Result = gesture.Result,
				Detector = gesture.Detector,
				Swipe = Detector.plugin.create({
				/**
					 * Gesture name
					 * @property {string} [name="swipe"]
					 * @member ns.event.gesture.Swipe
					 */
					name: "swipe",

				/**
					 * Gesture Index
					 * @property {number} [index=400]
					 * @member ns.event.gesture.Swipe
					 */
					index: 400,

				/**
					 * Default values for swipe gesture
					 * @property {Object} defaults
					 * @property {number} [defaults.timeThreshold=400]
					 * @property {number} [defaults.velocity=0.6]
					 * @property {ns.event.gesture.HORIZONTAL|ns.event.gesture.VERTICAL} [defaults.orientation=ns.event.gesture.HORIZONTAL]
					 * @member ns.event.gesture.Swipe
					 */
					defaults: {
						timeThreshold: 400,
						velocity: 0.6,
						orientation: gesture.Orientation.HORIZONTAL
					},

				/**
					 * Handler for swipe gesture
					 * @method handler
					 * @param {Event} gestureEvent gesture event
					 * @param {Object} sender event's sender
					 * @param {Object} options options
					 * @return {number}
					 * @member ns.event.gesture.Swipe
					 */
					handler: function (gestureEvent, sender, options) {
						var result = Result.PENDING,
							velocity = options.velocity;

						if (gestureEvent.eventType === gesture.Event.END) {
							if ((gestureEvent.deltaTime > options.timeThreshold) ||
								(options.orientation !== gesture.utils.getOrientation(gestureEvent.direction))) {
								result = Result.FINISHED;
							} else if (gestureEvent.velocityX > velocity || gestureEvent.velocityY > velocity) {
								sender.sendEvent(this.name, gestureEvent);
								result = Result.FINISHED | Result.BLOCK;
							}
						}

						return result;
					}
				});

			gesture.Swipe = Swipe;

		}(ns));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # Gesture Plugin: pinch
 * Plugin enables pinch event.
 *
 * @class ns.event.gesture.Pinch
 */
(function (ns) {
	"use strict";
	
		/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.Pinch
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture,
			/**
				 * Local alias for {@link ns.event.gesture.Detector}
				 * @property {Object}
				 * @member ns.event.gesture.Pinch
				 * @private
				 * @static
				 */
				Result = gesture.Result,

				Detector = ns.event.gesture.Detector,
				eventNames = {
					start: "pinchstart",
					move: "pinchmove",
					end: "pinchend",
					cancel: "pinchcancel",
					in: "pinchin",
					out: "pinchout"
				},

				Pinch = Detector.plugin.create({
				/**
					 * Gesture name
					 * @property {string} [name="pinch"]
					 * @member ns.event.gesture.Pinch
					 */
					name: "pinch",

				/**
					 * Gesture Index
					 * @property {number} [index=300]
					 * @member ns.event.gesture.Pinch
					 */
					index: 300,

				/**
					 * Array of possible pinch events
					 * @property {Object} eventNames
					 * @member ns.event.gesture.Pinch
					 */
					eventNames: eventNames,

				/**
					 * Default values for pinch gesture
					 * @property {Object} defaults
					 * @property {number} [defaults.velocity=0.6]
					 * @property {number} [defaults.timeThreshold=400]
					 * @member ns.event.gesture.Pinch
					 */
					defaults: {
						velocity: 0.6,
						timeThreshold: 400
					},

				/**
					 * Triggered
					 * @property {boolean} [isTriggered=false]
					 * @member ns.event.gesture.Pinch
					 */
					isTriggered: false,

				/**
					 * Handler for pinch gesture
					 * @method handler
					 * @param {Event} gestureEvent gesture event
					 * @param {Object} sender event's sender
					 * @param {Object} options options
					 * @return {number}
					 * @member ns.event.gesture.Pinch
					 */
					handler: function (gestureEvent, sender, options) {
						var result = Result.PENDING,
							prevented;

						switch (gestureEvent.eventType) {
							case gesture.Event.MOVE:
								if (gestureEvent.pointers.length === 1 && gestureEvent.distance > 35) {
									result = Result.FINISHED;
								} else if (!this.isTriggered && gestureEvent.pointers.length >= 2) {
									this.isTriggered = true;
									if (sender.sendEvent(eventNames.start, gestureEvent) === false) {
										gestureEvent.preventDefault();
									}
									result = Result.RUNNING;
								} else if (this.isTriggered) {
									if ((gestureEvent.deltaTime < options.timeThreshold) &&
										(gestureEvent.velocityX > options.velocity || gestureEvent.velocityY > options.velocity)) {
										if (gestureEvent.scale < 1) {
											prevented = sender.sendEvent(eventNames.in, gestureEvent);
										} else {
											prevented = sender.sendEvent(eventNames.out, gestureEvent);
										}
										if (prevented === false) {
											gestureEvent.preventDefault();
										}
										this.isTriggered = false;
										result = Result.FINISHED | Result.BLOCK;
										return result;
									} else {
										if (sender.sendEvent(eventNames.move, gestureEvent) === false) {
											gestureEvent.preventDefault();
										}
										result = Result.RUNNING;
									}
								}
								break;
							case gesture.Event.BLOCKED:
							case gesture.Event.END:
								if (this.isTriggered) {
									if (sender.sendEvent(eventNames.end, gestureEvent) === false) {
										gestureEvent.preventDefault();
									}
									this.isTriggered = false;
									result = Result.FINISHED;
								}
								break;
							case gesture.Event.CANCEL:
								if (this.isTriggered) {
									if (sender.sendEvent(eventNames.cancel, gestureEvent) === false) {
										gestureEvent.preventDefault();
									}
									this.isTriggered = false;
									result = Result.FINISHED;
								}
								break;
						}
						return result;
					}
				});

			ns.event.gesture.Pinch = Pinch;
		}(ns));

/*global ns, window, define */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Gesture Plugin: longPress
 * Plugin enables long press event.
 *
 * @class ns.event.gesture.LongPress
 */
(function (ns) {
	"use strict";
	
		/**
			 * Local alias for {@link ns.event.gesture}
			 * @property {Object}
			 * @member ns.event.gesture.LongPress
			 * @private
			 * @static
			 */
			var gesture = ns.event.gesture,
			/**
				 * Local alias for {@link ns.event.gesture.Detector}
				 * @property {Object}
				 * @member ns.event.gesture.LongPress
				 * @private
				 * @static
				 */
				Detector = gesture.Detector,

				LongPress = Detector.plugin.create({
				/**
					 * Gesture name
					 * @property {string} [name="longpress"]
					 * @member ns.event.gesture.LongPress
					 */
					name: "longpress",

				/**
					 * Gesture Index
					 * @property {number} [index=200]
					 * @member ns.event.gesture.LongPress
					 */
					index: 600,

				/**
					 * Default values for longPress gesture
					 * @property {Object} defaults
					 * @property {number} [defaults.timeThreshold=400]
					 * @property {number} [defaults.longPressDistanceThreshold=15]
					 * @property {boolean} [defaults.preventClick]
					 * @member ns.event.gesture.LongPress
					 */
					defaults: {
						longPressTimeThreshold: 750,
						longPressDistanceThreshold: 20,
						preventClick: true
					},

				/**
					 * IsTriggered
					 * @property {boolean} [isTriggered=false]
					 * @member ns.event.gesture.LongPress
					 */
					isTriggered: false,

				/**
					 * longPressTimeOutId
					 * @property {number} [longPressTimeOutId=0]
					 * @member ns.event.gesture.LongPress
					 */
					longPressTimeOutId: 0,

				/**
					 * Handler for longPress gesture
					 * @method handler
					 * @param {Event} gestureEvent gesture event
					 * @param {Object} sender event's sender
					 * @param {Object} options options
					 * @return {number}
					 * @member ns.event.gesture.LongPress
					 */
					handler: function (gestureEvent, sender, options) {
						var result = gesture.Result.PENDING;

						switch (gestureEvent.eventType) {
							case gesture.Event.START:
								this.isTriggered = false;
								this.longPressTimeOutId = setTimeout(function () {
									this.isTriggered = true;
									sender.sendEvent(this.name, gestureEvent);
								}.bind(this), options.longPressTimeThreshold);
								break;

							case gesture.Event.MOVE:
								if (gestureEvent.distance > options.longPressDistanceThreshold && !this.isTriggered) {
									clearTimeout(this.longPressTimeOutId);
									result = gesture.Result.FINISHED;
								}
								break;

							case gesture.Event.END:
								if (!this.isTriggered) {
									clearTimeout(this.longPressTimeOutId);
								} else if (options.preventClick) {
									gestureEvent.preventDefault();
								}
								result = gesture.Result.FINISHED;
								break;
						}
						return result;
					}
				});

			gesture.LongPress = LongPress;

		}(ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Scroller namespace
 * Namespace contains classes and objects connected with scroller widget.
 * @class ns.widget.core.scroller
 * @internal
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 */
(function (window, ns) {
	"use strict";
				ns.widget.core.scroller = ns.widget.core.scroller || {};
			}(window, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #Effect namespace
 * Namespace with effects for scroller widget.
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @internal
 * @class ns.widget.core.scroller.effect
 */
(function (window, ns) {
	"use strict";
				ns.widget.core.scroller.effect = ns.widget.core.scroller.effect || {};
			}(window, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * # Bouncing effect
 * Bouncing effect for scroller widget.
 * @class ns.widget.core.scroller.effect.Bouncing
 * @internal
 * @since 2.3
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller
			var utilsObject = ns.util.object,
				selectors = ns.util.selectors,
				Bouncing = function (scrollerElement, options) {
					var self = this;

					self._orientation = null;
					self._maxValue = null;

					self._container = null;
					self._minEffectElement = null;
					self._maxEffectElement = null;

					self.options = utilsObject.merge({}, Bouncing.defaults, {scrollEndEffectArea: ns.getConfig("scrollEndEffectArea", Bouncing.defaults.scrollEndEffectArea)});
					/**
					 * target element for bouncing effect
					 * @property {HTMLElement} targetElement
					 * @member ns.widget.core.scroller.effect.Bouncing
					 */
					self._targetElement = null;

					self._isShow = false;
					self._isDrag = false;
					self._isShowAnimating = false;
					self._isHideAnimating = false;

					self._create(scrollerElement, options);
				},
				Orientation = {
					VERTICAL: "vertical",
					HORIZONTAL: "horizontal"
				},
				endEffectAreaType = {
					content: "content",
					screen: "screen"
				},
				defaults = {
					duration: 500,
					scrollEndEffectArea: "content"
				},
				classes = {
					bouncingEffect: "ui-scrollbar-bouncing-effect",
					page: "ui-page",
					left: "ui-left",
					right: "ui-right",
					top: "ui-top",
					bottom: "ui-bottom",
					hide: "ui-hide",
					show: "ui-show"
				};

			Bouncing.Orientation = Orientation;

			Bouncing.defaults = defaults;

			Bouncing.prototype = {
				_create: function (scrollerElement, options) {
					var self = this;

					if (self.options.scrollEndEffectArea === endEffectAreaType.content) {
						self._container = scrollerElement;
					} else {
						self._container = selectors.getClosestByClass(scrollerElement, classes.page);
					}

					self._orientation = options.orientation;
					self._maxValue = self._getValue(options.maxScrollX, options.maxScrollY);

					self._initLayout();
				},

				_initLayout: function () {
					var self = this,
						minElement = self._minEffectElement = document.createElement("DIV"),
						maxElement = self._maxEffectElement = document.createElement("DIV"),
						className = classes.bouncingEffect;

					if (self._orientation === Orientation.HORIZONTAL) {
						minElement.className = className + " " + classes.left;
						maxElement.className = className + " " + classes.right;
					} else {
						minElement.className = className + " " + classes.top;
						maxElement.className = className + " " + classes.bottom;
					}

					self._container.appendChild(minElement);
					self._container.appendChild(maxElement);

					minElement.addEventListener("animationEnd", this);
					minElement.addEventListener("webkitAnimationEnd", this);
					minElement.addEventListener("mozAnimationEnd", this);
					minElement.addEventListener("msAnimationEnd", this);
					minElement.addEventListener("oAnimationEnd", this);

					maxElement.addEventListener("animationEnd", this);
					maxElement.addEventListener("webkitAnimationEnd", this);
					maxElement.addEventListener("mozAnimationEnd", this);
					maxElement.addEventListener("msAnimationEnd", this);
					maxElement.addEventListener("oAnimationEnd", this);
				},

				/**
				 * ...
				 * @method drag
				 * @param {number} x
				 * @param {number} y
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				drag: function (x, y) {
					this._isDrag = true;
					this._checkAndShow(x, y);
				},

				/**
				 * ...
				 * @method dragEnd
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				dragEnd: function () {
					var self = this;

					if (self._isShow && !self._isShowAnimating && !self._isHideAnimating) {
						self._beginHide();
					}

					self._isDrag = false;
				},

				/**
				 * Shows effect.
				 * @method show
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				show: function () {
					var self = this;

					if (self._targetElement) {
						self._isShow = true;
						self._beginShow();
					}
				},

				/**
				 * Hides effect.
				 * @method hide
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				hide: function () {
					var self = this;

					if (self._isShow) {
						self._minEffectElement.style.display = "none";
						self._maxEffectElement.style.display = "none";
						self._targetElement.classList.remove(classes.hide);
						self._targetElement.classList.remove(classes.show);
					}
					self._isShow = false;
					self._isShowAnimating = false;
					self._isHideAnimating = false;
					self._targetElement = null;
				},

				_checkAndShow: function (x, y) {
					var self = this,
						val = self._getValue(x, y);

					if (!self._isShow) {
						if (val >= 0) {
							self._targetElement = self._minEffectElement;
							self.show();
						} else if (val <= self._maxValue) {
							self._targetElement = self._maxEffectElement;
							self.show();
						}

					} else if (self._isShow && !self._isDrag && !self._isShowAnimating && !self._isHideAnimating) {
						self._beginHide();
					}
				},

				_getValue: function (x, y) {
					return this._orientation === Orientation.HORIZONTAL ? x : y;
				},

				_beginShow: function () {
					var self = this;

					if (!self._targetElement || self._isShowAnimating) {
						return;
					}

					self._targetElement.style.display = "block";

					self._targetElement.classList.remove(classes.hide);
					self._targetElement.classList.add(classes.show);

					self._isShowAnimating = true;
					self._isHideAnimating = false;
				},

				_finishShow: function () {
					var self = this;

					self._isShowAnimating = false;
					if (!self._isDrag) {
						self._targetElement.classList.remove(classes.show);
						self._beginHide();
					}
				},

				_beginHide: function () {
					var self = this;

					if (self._isHideAnimating) {
						return;
					}

					self._targetElement.classList.remove(classes.show);
					self._targetElement.classList.add(classes.hide);

					self._isHideAnimating = true;
					self._isShowAnimating = false;
				},

				_finishHide: function () {
					var self = this;

					self._isHideAnimating = false;
					self._targetElement.classList.remove(classes.hide);
					self.hide();
					self._checkAndShow();
				},

				/**
				 * Supports events.
				 * @method handleEvent
				 * @param {Event} event
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				handleEvent: function (event) {
					if (event.type.toLowerCase().indexOf("animationend") > -1 && event.animationName.charAt(0) !== "-") {
						if (this._isShowAnimating) {
							this._finishShow();
						} else if (this._isHideAnimating) {
							this._finishHide();
						}
					}
				},

				/**
				 * Destroys effect.
				 * @method destroy
				 * @member ns.widget.core.scroller.effect.Bouncing
				 */
				destroy: function () {
					var self = this,
						maxEffectElement = this._maxEffectElement,
						minEffectElement = this._minEffectElement;

					minEffectElement.removeEventListener("animationEnd", this);
					minEffectElement.removeEventListener("webkitAnimationEnd", this);
					minEffectElement.removeEventListener("mozAnimationEnd", this);
					minEffectElement.removeEventListener("msAnimationEnd", this);
					minEffectElement.removeEventListener("oAnimationEnd", this);

					maxEffectElement.removeEventListener("animationEnd", this);
					maxEffectElement.removeEventListener("webkitAnimationEnd", this);
					maxEffectElement.removeEventListener("mozAnimationEnd", this);
					maxEffectElement.removeEventListener("msAnimationEnd", this);
					maxEffectElement.removeEventListener("oAnimationEnd", this);

					self._container.removeChild(minEffectElement);
					self._container.removeChild(maxEffectElement);

					self._container = null;
					self._minEffectElement = null;
					self._maxEffectElement = null;
					self._targetElement = null;

					self._isShow = null;
					self._orientation = null;
					self._maxValue = null;
				}
			};

			ns.widget.core.scroller.effect.Bouncing = Bouncing;
			}(window.document, ns));

/*global window, define, Event, console, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * # Scroller Widget
 * Widget creates scroller on content.
 * @class ns.widget.core.scroller.Scroller
 * @since 2.3
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller
			var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				utilsObject = ns.util.object,
				utilsEvents = ns.event,
				prototype = new BaseWidget(),
				EffectBouncing = ns.widget.core.scroller.effect.Bouncing,
				eventType = {
					/**
					 * event trigger when scroller start
					 * @event scrollstart
					 */
					START: "scrollstart",
					/**
					 * event trigger when scroller move
					 * @event scrollmove
					 */
					MOVE: "scrollmove",
					/**
					 * event trigger when scroller end
					 * @event scrollend
					 */
					END: "scrollend",
					/**
					 * event trigger when scroll is cancel
					 * @event scrollcancel
					 */
					CANCEL: "scrollcancel"
				},

				/*
				 * this option is related operation of scroll bar.
				 * the value is true, scroll bar is shown during touching screen even if content doesn't scroll.
				 * the value is false, scroll bar disappear when there is no movement of the scroll bar.
				 */
				_keepShowingScrollbarOnTouch = false,

				Scroller = function () {
				};

			Scroller.Orientation = {
				VERTICAL: "vertical",
				HORIZONTAL: "horizontal"
			};

			Scroller.EventType = eventType;

			prototype._build = function (element) {
				if (element.children.length !== 1) {
					ns.error("[Scroller] Scroller should have only one child.");
				} else {

					this.scroller = element.children[0];
					this.scrollerStyle = this.scroller.style;

					this.bouncingEffect = null;
					this.scrollbar = null;

					this.scrollerWidth = 0;
					this.scrollerHeight = 0;
					this.scrollerOffsetX = 0;
					this.scrollerOffsetY = 0;

					this.maxScrollX = 0;
					this.maxScrollY = 0;

					this.startScrollerOffsetX = 0;
					this.startScrollerOffsetY = 0;

					this.orientation = null;

					this.enabled = true;
					this.scrolled = false;
					this.dragging = false;
					this.scrollCanceled = false;
				}

				return element;
			};

			prototype._configure = function () {
				/**
				 * @property {Object} options Options for widget
				 * @property {number} [options.scrollDelay=0]
				 * @property {number} [options.threshold=10]
				 * @property {""|"bar"|"tab"} [options.scrollbar=""]
				 * @property {boolean} [options.useBouncingEffect=true]
				 * @property {"vertical"|"horizontal"} [options.orientation="vertical"]
				 * @member ns.widget.core.Scroller
				 */
				this.options = utilsObject.merge({}, this.options, {
					scrollDelay: 0,
					threshold: 30,
					scrollbar: "",
					useBouncingEffect: true,
					orientation: "vertical"	// vertical or horizontal,
				});
			};

			prototype._init = function (element) {
				var scroller = null,
					options = this.options,
					scrollerChildren = null,
					elementStyle = element.style,
					scrollerStyle = null,
					elementHalfWidth = element.offsetWidth / 2,
					elementHalfHeight = element.offsetHeight / 2;

				scroller = element.children[0];
				this.scroller = scroller;
				scrollerStyle = scroller.style,
				this.scrollerStyle = scrollerStyle;
				scrollerChildren = scroller.children;

				this.orientation = this.orientation ||
					(options.orientation === "horizontal" ? Scroller.Orientation.HORIZONTAL : Scroller.Orientation.VERTICAL);
				this.scrollerWidth = scroller.offsetWidth;
				this.scrollerHeight = scroller.offsetHeight;

				if (scrollerChildren.length) {
					this.maxScrollX = elementHalfWidth - this.scrollerWidth + scrollerChildren[scrollerChildren.length - 1].offsetWidth / 2;
					this.maxScrollY = elementHalfHeight - this.scrollerHeight + scrollerChildren[scrollerChildren.length - 1].offsetHeight / 2;
					this.minScrollX = elementHalfWidth - scrollerChildren[0].offsetWidth / 2;
					this.minScrollY = elementHalfHeight - scrollerChildren[0].offsetHeight / 2;
				} else {
					this.maxScrollY = 360;
					this.minScrollY = 0;
				}

				this.scrolled = false;
				this.touching = true;
				this.scrollCanceled = false;

				if (this.orientation === Scroller.Orientation.HORIZONTAL) {
					this.maxScrollY = 0;
				} else {
					this.maxScrollX = 0;
				}
				elementStyle.overflow = "hidden";
				elementStyle.position = "relative";
				scrollerStyle.position = "absolute";
				scrollerStyle.top = "0px";
				scrollerStyle.left = "0px";
				scrollerStyle.width = this.scrollerWidth + "px";
				scrollerStyle.height = this.scrollerHeight + "px";
				this._initScrollbar();
				this._initBouncingEffect();
				return element;
			};

			prototype._initScrollbar = function () {
				var type = this.options.scrollbar,
					scrollbarType;

				if (type) {
					scrollbarType = ns.widget.core.scroller.scrollbar.type[type];
					if (scrollbarType) {
						this.scrollbar = engine.instanceWidget(this.element, "ScrollBar", {
							type: scrollbarType,
							orientation: this.orientation
						});
					}
				}
			};

			prototype._initBouncingEffect = function () {
				var o = this.options;

				if (o.useBouncingEffect) {
					this.bouncingEffect = new EffectBouncing(this.element, {
						maxScrollX: this.maxScrollX,
						maxScrollY: this.maxScrollY,
						orientation: this.orientation
					});
				}
			};

			prototype._resetLayout = function () {
				var elementStyle = this.element.style,
					scrollerStyle = this.scrollerStyle;

				elementStyle.overflow = "";
				elementStyle.position = "";

				elementStyle.overflow = "hidden";
				elementStyle.position = "relative";

				if (scrollerStyle) {
					scrollerStyle.position = "";
					scrollerStyle.top = "";
					scrollerStyle.left = "";
					scrollerStyle.width = "";
					scrollerStyle.height = "";

					scrollerStyle["-webkit-transform"] = "";
					scrollerStyle["-moz-transition"] = "";
					scrollerStyle["-ms-transition"] = "";
					scrollerStyle["-o-transition"] = "";
					scrollerStyle["transition"] = "";
				}
			};

			prototype._bindEvents = function () {
				ns.event.enableGesture(
					this.scroller,

					new ns.event.gesture.Drag({
						threshold: this.options.threshold,
						delay: this.options.scrollDelay,
						blockVertical: this.orientation === Scroller.Orientation.HORIZONTAL,
						blockHorizontal: this.orientation === Scroller.Orientation.VERTICAL
					})
				);

				utilsEvents.on(this.scroller, "drag dragstart dragend dragcancel", this);
				window.addEventListener("resize", this);
			};

			prototype._unbindEvents = function () {
				if (this.scroller) {
					ns.event.disableGesture(this.scroller);
					utilsEvents.off(this.scroller, "drag dragstart dragend dragcancel", this);
					window.removeEventListener("resize", this);
				}
			};

			/* jshint -W086 */
			prototype.handleEvent = function (event) {
				switch (event.type) {
					case "dragstart":
						this._start(event);
						break;
					case "drag":
						this._move(event);
						break;
					case "dragend":
						this._end(event);
						break;
					case "dragcancel":
						this._cancel(event);
						break;
					case "resize":
						this.refresh();
						break;
				}
			};

			prototype._refresh = function () {
				this._unbindEvents();
				this._clear();
				this._init(this.element);
				this._bindEvents();
			};

			/**
			 * Scrolls to new position.
			 * @method scrollTo
			 * @param {number} x
			 * @param {number} y
			 * @param {number} duration
			 * @member ns.widget.core.scroller.Scroller
			 */
			prototype.scrollTo = function (x, y, duration) {
				this._translate(x, y, duration);
				this._translateScrollbar(x, y, duration);
			};

			prototype._translate = function (x, y, duration) {
				var translate,
					transition = {
						normal: "none",
						webkit: "none",
						moz: "none",
						ms: "none",
						o: "none"
					},
					scrollerStyle = this.scrollerStyle;

				if (duration) {
					transition.normal = "transform " + duration / 1000 + "s ease-out";
					transition.webkit = "-webkit-transform " + duration / 1000 + "s ease-out";
					transition.moz = "-moz-transform " + duration / 1000 + "s ease-out";
					transition.ms = "-ms-transform " + duration / 1000 + "s ease-out";
					transition.o = "-o-transform " + duration / 1000 + "s ease-out";
				}
				translate = "translate3d(" + x + "px," + y + "px, 0)";

				scrollerStyle["-webkit-transform"] =
					scrollerStyle["-moz-transform"] =
						scrollerStyle["-ms-transform"] =
							scrollerStyle["-o-transform"] =
								scrollerStyle.transform = translate;
				scrollerStyle.transition = transition.normal;
				scrollerStyle["-webkit-transition"] = transition.webkit;
				scrollerStyle["-moz-transition"] = transition.moz;
				scrollerStyle["-ms-transition"] = transition.ms;
				scrollerStyle["-o-transition"] = transition.o;

				this.scrollerOffsetX = window.parseInt(x, 10);
				this.scrollerOffsetY = window.parseInt(y, 10);
			};

			prototype._translateScrollbar = function (x, y, duration, autoHidden) {
				if (!this.scrollbar) {
					return;
				}

				this.scrollbar.translate(this.orientation === Scroller.Orientation.HORIZONTAL ? -x : -y, duration, autoHidden);
			};

			prototype._start = function () {
				var self = this;

				self.scrolled = false;
				self.dragging = true;
				self.scrollCanceled = false;
				self.startScrollerOffsetX = self.scrollerOffsetX;
				self.startScrollerOffsetY = self.scrollerOffsetY;
			};

			prototype._move = function (event) {
				var newX = this.startScrollerOffsetX,
					newY = this.startScrollerOffsetY,
					autoHide = !_keepShowingScrollbarOnTouch;

				if (!this.enabled || this.scrollCanceled || !this.dragging) {
					return;
				}

				if (this.orientation === Scroller.Orientation.HORIZONTAL) {
					newX += event.detail.estimatedDeltaX;
				} else {
					newY += event.detail.estimatedDeltaY;
				}

				if (newX > this.minScrollX || newX < this.maxScrollX) {
					newX = newX > this.minScrollX ? this.minScrollX : this.maxScrollX;
				}
				if (newY > this.minScrollY || newY < this.maxScrollY) {
					newY = newY > this.minScrollY ? this.minScrollY : this.maxScrollY;
				}

				if (newX !== this.scrollerOffsetX || newY !== this.scrollerOffsetY) {
					if (!this.scrolled) {
						this.trigger(eventType.START);
					}
					this.scrolled = true;

					this._translate(newX, newY);
					this._translateScrollbar(newX, newY, 0, autoHide);
					// TODO to dispatch move event is too expansive. it is better to use callback.
					this.trigger(eventType.MOVE);

					if (this.bouncingEffect) {
						this.bouncingEffect.hide();
					}
				} else {
					if (this.bouncingEffect) {
						this.bouncingEffect.drag(newX, newY);
					}
					this._translateScrollbar(newX, newY, 0, autoHide);
				}
			};

			prototype._end = function () {
				if (this.dragging) {

					// bouncing effect
					if (this.bouncingEffect) {
						this.bouncingEffect.dragEnd();
					}

					if (this.scrollbar) {
						this.scrollbar.end();
					}

					this._endScroll();
					this.dragging = false;
				}
			};

			prototype._endScroll = function () {
				if (this.scrolled) {
					this.trigger(eventType.END);
				}

				this.scrolled = false;
			};

			/**
			 * Cancels scroll.
			 * @method _cancel
			 * @protected
			 * @member ns.widget.core.scroller.Scroller
			 */
			prototype._cancel = function () {
				this.scrollCanceled = true;

				if (this.scrolled) {
					this._translate(this.startScrollerOffsetX, this.startScrollerOffsetY);
					this._translateScrollbar(this.startScrollerOffsetX, this.startScrollerOffsetY);
					this.trigger(eventType.CANCEL);
				}

				if (this.scrollbar) {
					this.scrollbar.end();
				}

				this.scrolled = false;
				this.dragging = false;
			};

			prototype._clear = function () {
				this.scrolled = false;
				this.scrollCanceled = false;

				this._resetLayout();
				this._clearScrollbar();
				this._clearBouncingEffect();
			};

			prototype._clearScrollbar = function () {
				if (this.scrollbar) {
					this.scrollbar.destroy();
				}
				this.scrollbar = null;
			};

			prototype._clearBouncingEffect = function () {
				if (this.bouncingEffect) {
					this.bouncingEffect.destroy();
				}
				this.bouncingEffect = null;
			};

			prototype._disable = function () {
				this.enabled = false;
			};

			prototype._enable = function () {
				this.enabled = true;
			};

			prototype._destroy = function () {
				this._unbindEvents();
				this._clear();
				this.scrollerStyle = null;
				this.scroller = null;
			};

			Scroller.prototype = prototype;

			ns.widget.core.scroller.Scroller = Scroller;

			engine.defineWidget(
				"Scroller",
				".scroller",
				["scrollTo", "cancel"],
				Scroller
			);
			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #Scrollbar namespace
 * Namespace with scrollbar for scroller widget.
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @class ns.widget.core.scroller.scrollbar
 */
(function (window, ns) {
	"use strict";
				ns.widget.core.scroller.scrollbar = ns.widget.core.scroller.scrollbar || {};
			}(window, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #type namespace
 * Namespace with types of scroll bars..
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @class ns.widget.core.scroller.scrollbar.type
 * @internal
 */
(function (window, ns) {
	"use strict";
				/** @namespace ns.widget.core */
			ns.widget.core.scroller.scrollbar.type = ns.widget.core.scroller.scrollbar.type || {};
			}(window, ns));

/*global window, define, Event, console, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Type Interface
 * Interface for types used in scroll bar widget.
 * @class ns.widget.core.scroller.scrollbar.type.interface
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller

			ns.widget.core.scroller.scrollbar.type.interface = {
				/**
				 * Inserts elements end decorate.
				 * @method insertAndDecorate
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.interface
				 */
				setScrollbarLayout: function (/* options */) {
				},
				/**
				 * Removes element.
				 * @method remove
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.interface
				 */
				remove: function (/* options */) {
				},
				/**
				 * ...
				 * @method start
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.interface
				 */
				start: function (/* scrollbarElement, barElement */) {
				},
				/**
				 * ...
				 * @method end
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.interface
				 */
				end: function (/* scrollbarElement, barElement */) {
				},
				/**
				 * ...
				 * @method offset
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.interface
				 */
				offset: function (/* orientation, offset  */) {
				}
			};
			}(window.document, ns));

/*global window, define, Event, console, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Bar Type
 * Bar type support for scroll bar widget.
 * @class ns.widget.core.scroller.scrollbar.type.bar
 * @extends ns.widget.core.scroller.scrollbar.type.interface
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller
			var utilsObject = ns.util.object,
				type = ns.widget.core.scroller.scrollbar.type,
				typeInterface = type.interface,
				Scroller = ns.widget.core.scroller.Scroller;

			type.bar = utilsObject.merge({}, typeInterface, {
				options: {
					animationDuration: 500
				},

				/**
				 * @method setScrollbar
				 * @param viewLayout
				 * @param firstChildLayout
				 * @param clipLayout
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.bar
				 */

				setScrollbar: function (viewLayout, firstChildLayout, clipLayout) {
					this._viewLayout = viewLayout;
					this._clipLayout = clipLayout;
					this._firstChildLayout = firstChildLayout;
					this._ratio = clipLayout / firstChildLayout;
				},

				/**
				 * @method getScrollbarSize
				 * @return {number} scrollbar size
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.bar
				 */
				getScrollbarSize: function () {
					return this._firstChildLayout / this._viewLayout * this._firstChildLayout * this._ratio;
				},
				/**
				 * @method offset
				 * @param {string} orientation
				 * @param {number} offset
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.bar
				 */
				offset: function (orientation, offset) {
					var x,
						y;

					offset = offset * this._clipLayout / this._viewLayout;

					if (orientation === Scroller.Orientation.VERTICAL) {
						x = 0;
						y = offset;
					} else {
						x = offset;
						y = 0;
					}

					return {
						x: x,
						y: y
					};
				},

				/**
				 * @method start
				 * @param {HTMLElement} scrollbarElement
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.bar
				 */
				start: function (scrollbarElement/*, barElement */) {
					var style = scrollbarElement.style,
						duration = this.options.animationDuration;

					style["-webkit-transition"] =
						style["-moz-transition"] =
							style["-ms-transition"] =
								style["-o-transition"] =
									style.transition = "opacity " + duration / 1000 + "s ease";
					style.opacity = 1;
				},

				/**
				 * @method end
				 * @param {HTMLElement} scrollbarElement
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.bar
				 */
				end: function (scrollbarElement) {
					var style = scrollbarElement.style,
						duration = this.options.animationDuration;

					style["-webkit-transition"] =
						style["-moz-transition"] =
							style["-ms-transition"] =
								style["-o-transition"] =
									style.transition = "opacity " + duration / 1000 + "s ease";
					style.opacity = 0;
				}
			});

			}(window.document, ns));

/*global window, define, Event, console, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Tab Type
 * Tab type support for scroll bar widget.
 * @class ns.widget.core.scroller.scrollbar.type.tab
 * @extends ns.widget.core.scroller.scrollbar.type.interface
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller
			var utilsObject = ns.util.object,
				type = ns.widget.core.scroller.scrollbar.type,
				typeInterface = type.interface,
				Scroller = ns.widget.core.scroller.Scroller;

			type.tab = utilsObject.merge({}, typeInterface, {
				options: {
					wrapperClass: "ui-scrollbar-tab-type",
					barClass: "ui-scrollbar-indicator",
					margin: 1
				},
				/**
				 * ...
				 * @method insertAndDecorate
				 * @param {Object} data
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.tab
				 */
				insertAndDecorate: function (data) {
					var scrollbarElement = data.wrapper,
						barElement = data.bar,
						container = data.container,
						clip = data.clip,
						sections = data.sections,
						orientation = data.orientation,
						margin = this.options.margin,
						clipWidth = clip.offsetWidth,
						clipHeight = clip.offsetHeight,
						containerWidth = container.offsetWidth,
						containerHeight = container.offsetHeight,
						clipSize = orientation === Scroller.Orientation.VERTICAL ? clipHeight : clipWidth,
						containerSize = orientation === Scroller.Orientation.VERTICAL ? containerHeight : containerWidth,
						sectionSize = clipSize / containerSize,
						height,
						barHeight,
						i,
						len;

					this.containerSize = containerWidth;
					this.maxScrollOffset = clipSize - containerSize;
					this.scrollZoomRate = containerWidth / clipSize;
					this.barSize = window.parseInt((containerWidth - margin * 2 * (sectionSize - 1)) / sectionSize);

					scrollbarElement.className = this.options.wrapperClass;
					barElement.className = this.options.barClass;

					barElement.style.width = this.barSize + "px";
					barElement.style.left = "0px";

					container.insertBefore(scrollbarElement, clip);

					// reset page container and section layout.
					barHeight = barElement.offsetHeight;
					height = clipHeight - barHeight;
					clip.style.height = height + "px";
					if (sections && sections.length) {
						for (i = 0, len = sections.length; i < len; i++) {
							sections[i].style.height = height + "px";
						}
					}
				},

				/**
				 * ...
				 * @method remove
				 * @param {Object} data
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.tab
				 */
				remove: function (data) {
					var scrollbarElement = data.wrapper,
						container = data.container;

					if (container && scrollbarElement) {
						container.removeChild(scrollbarElement);
					}
				},

				/**
				 * ...
				 * @method offset
				 * @param {string} orientation
				 * @param {number} offset
				 * @static
				 * @member ns.widget.core.scroller.scrollbar.type.tab
				 */
				offset: function (orientation, offset) {
					return {
						x: offset === 0 ? -1 :
							offset === this.maxScrollOffset ? this.containerSize - this.barSize - this.options.margin : offset * this.scrollZoomRate,
						y: 0
					};
				}

			});
			}(window.document, ns));

/*global window, define, Event, console, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Scroll Bar Widget
 * Widget creates scroll bar.
 * @class ns.widget.core.scroller.scrollbar.ScrollBar
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				// scroller.start event trigger when user try to move scroller
			var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				prototype = new BaseWidget(),
				utilsObject = ns.util.object,
				selectors = ns.util.selectors,
				Page = ns.widget.core.Page,
				Classes = {
					wrapperClass: "ui-scrollbar-bar-type",
					barClass: "ui-scrollbar-indicator",
					orientationClass: "ui-scrollbar-",
					page: Page.classes.uiPage
				},

				Scroller = ns.widget.core.scroller.Scroller,
				ScrollerScrollBar = function () {

					this.wrapper = null;
					this.barElement = null;

					this.container = null;
					this.view = null;

					this.options = {};
					this.type = null;

					this.maxScroll = null;
					this.started = false;
					this.displayDelayTimeoutId = null;

					this.lastScrollPosition = 0;
				};

			prototype._build = function (scrollElement) {
				this.clip = scrollElement;
				this.view = scrollElement.children[0];
				this.firstChild = this.view.children[0];
				return scrollElement;
			};

			prototype._configure = function () {
				/**
				 * @property {Object} options Options for widget
				 * @property {boolean} [options.type=false]
				 * @property {number} [options.displayDelay=700]
				 * @property {"vertical"|"horizontal"} [options.orientation="vertical"]
				 * @member ns.widget.core.scroller.scrollbar.ScrollBar
				 */
				this.options = utilsObject.merge({}, this.options, {
					type: false,
					displayDelay: 700,
					orientation: Scroller.Orientation.VERTICAL
				});
			};

			prototype._init = function (scrollElement) {
				this.clip = scrollElement;
				this.view = scrollElement.children[0];
				this.firstChild = this.view.children[0];
				this.type = this.options.type;

				if (!this.type) {
					return;
				}
				this._createScrollbar();
			};

			prototype._bindEvents = function () {
				document.addEventListener("visibilitychange", this);
			};

			prototype._createScrollbar = function () {
				var orientation = this.options.orientation,
					wrapper = document.createElement("DIV"),
					bar = document.createElement("span"),
					view = this.view,
					clip = this.clip,
					firstChild = this.firstChild,
					type = this.type;

				clip.appendChild(wrapper);
				wrapper.appendChild(bar);
				wrapper.classList.add(Classes.wrapperClass);
				bar.className = Classes.barClass;

				if (orientation === Scroller.Orientation.HORIZONTAL) {
					type.setScrollbar(view.offsetWidth, firstChild.offsetWidth, clip.offsetWidth);
					bar.style.width = type.getScrollbarSize() + "px";
					wrapper.classList.add(Classes.orientationClass + "horizontal");
				} else {
					type.setScrollbar(view.offsetHeight, firstChild.offsetHeight, clip.offsetHeight);
					bar.style.height = type.getScrollbarSize() + "px";
					wrapper.classList.add(Classes.orientationClass + "vertical");
				}

				this.wrapper = wrapper;
				this.barElement = bar;
			};

			prototype._removeScrollbar = function () {
				this.clip.removeChild(this.wrapper);

				this.wrapper = null;
				this.barElement = null;
			};

			prototype._refresh = function () {
				var self = this;

				self._clear();
				self._init();
				self.translate(self.lastScrollPosition);
			};

			/**
			 * Translates widget.
			 * @method translate
			 * @param {number} offset
			 * @param {number} duration
			 * @param {boolean} autoHidden
			 * @member ns.widget.core.scroller.scrollbar.ScrollBar
			 */
			prototype.translate = function (offset, duration, autoHidden) {
				var orientation = this.options.orientation,
					translate,
					transition = {
						normal: "none",
						webkit: "none",
						moz: "none",
						ms: "none",
						o: "none"
					},
					barStyle,
					endDelay;

				if (!this.wrapper || !this.type || this.lastScrollPosition === offset) {
					return;
				}

				autoHidden = autoHidden !== false;

				this.lastScrollPosition = offset;

				offset = this.type.offset(orientation, offset);

				barStyle = this.barElement.style;
				if (duration) {
					transition.normal = "transform " + duration / 1000 + "s ease-out";
					transition.webkit = "-webkit-transform " + duration / 1000 + "s ease-out";
					transition.moz = "-moz-transform " + duration / 1000 + "s ease-out";
					transition.ms = "-ms-transform " + duration / 1000 + "s ease-out";
					transition.o = "-o-transform " + duration / 1000 + "s ease-out";
				}

				translate = "translate3d(" + offset.x + "px," + offset.y + "px, 0)";

				barStyle["-webkit-transform"] =
					barStyle["-moz-transform"] =
						barStyle["-ms-transform"] =
							barStyle["-o-transform"] =
								barStyle.transform = translate;
				barStyle["-webkit-transition"] = transition.webkit;
				barStyle["-moz-transition"] = transition.moz;
				barStyle["-ms-transition"] = transition.ms;
				barStyle["-o-transition"] = transition.o;
				barStyle.transition = transition.normal;

				if (!this.started) {
					this._start();
				}

				if (this.displayDelayTimeoutId !== null) {
					window.clearTimeout(this.displayDelayTimeoutId);
					this.displayDelayTimeoutId = null;
				}

				if (autoHidden) {
					endDelay = (duration || 0) + this.options.displayDelay;
					this.displayDelayTimeoutId = window.setTimeout(this._end.bind(this), endDelay);
				}
			};

			prototype.end = function () {
				if (!this.displayDelayTimeoutId) {
					this.displayDelayTimeoutId = window.setTimeout(this._end.bind(this), this.options.displayDelay);
				}
			};

			prototype._start = function () {
				this.type.start(this.wrapper, this.barElement);
				this.started = true;
			};

			prototype._end = function () {
				this.started = false;
				this.displayDelayTimeoutId = null;

				if (this.type) {
					this.type.end(this.wrapper, this.barElement);
				}
			};

			/**
			 * Supports events.
			 * @method handleEvent
			 * @param {Event} event
			 * @member ns.widget.core.scroller.scrollbar.ScrollBar
			 */
			prototype.handleEvent = function (event) {
				var page;

				switch (event.type) {
					case "visibilitychange":
						page = selectors.getClosestBySelector(this.clip, "." + Classes.page);
						if (document.visibilityState === "visible" && page === ns.activePage) {
							this.refresh();
						}
						break;
				}
			};

			prototype._clear = function () {
				this._removeScrollbar();

				this.started = false;
				this.type = null;
				this.barElement = null;
				this.displayDelayTimeoutId = null;
			};

			prototype._destroy = function () {
				this._clear();
				document.removeEventListener("visibilitychange", this);

				this.options = null;
				this.clip = null;
				this.view = null;
			};

			ScrollerScrollBar.prototype = prototype;

			ns.widget.core.scroller.scrollbar.ScrollBar = ScrollerScrollBar;

			engine.defineWidget(
				"ScrollBar",
				"",
				["translate"],
				ScrollerScrollBar
			);
			}(window.document, ns));

/*global window, ns, define */
/*jslint nomen: true, plusplus: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Easing Utility
 * Utility calculates time function for animations.
 * @class ns.util.easing
 */

(function (ns) {
	"use strict";
				ns.util.easing = {
				/**
				 * Performs cubit out easing calculations based on time
				 * @method cubicOut
				 * @member ns.util.easing
				 * @param {number} currentTime
				 * @param {number} startValue
				 * @param {number} changeInValue
				 * @param {number} duration
				 * @return {number}
				 * @static
				 */
				cubicOut: function (currentTime, startValue, changeInValue, duration) {
					currentTime /= duration;
					currentTime--;
					return changeInValue * (currentTime * currentTime * currentTime + 1) + startValue;
				},

				/**
				 * Performs quad easing out calculations based on time
				 * @method easeOutQuad
				 * @member ns.util.easing
				 * @param {number} currentTime
				 * @param {number} startValue
				 * @param {number} changeInValue
				 * @param {number} duration
				 * @return {number}
				 * @static
				 */
				easeOutQuad: function (currentTime, startValue, changeInValue, duration) {
					return -changeInValue * (currentTime /= duration) * (currentTime - 2) + startValue;
				},

				/**
				 * Performs sine easing out calculations based on time
				 * The easing functions can be compared on: https://easings.net
				 * @method easeOutSine
				 * @member ns.util.easing
				 * @param {number} currentTime
				 * @param {number} startValue
				 * @param {number} changeInValue
				 * @param {number} duration
				 * @return {number}
				 * @static
				 */
				easeOutSine: function (currentTime, startValue, changeInValue, duration) {
					return changeInValue * Math.sin(currentTime / duration * (Math.PI / 2)) + startValue;
				},

				/**
				 * Performs out expo easing calculations based on time
				 * @method easeOutExpo
				 * @member ns.util.easing
				 * @param {number} currentTime
				 * @param {number} startValue
				 * @param {number} changeInValue
				 * @param {number} duration
				 * @return {number}
				 * @static
				 */
				easeOutExpo: function (currentTime, startValue, changeInValue, duration) {
					return (currentTime === duration) ?
						startValue + changeInValue :
						changeInValue * (-Math.pow(2, -10 * currentTime / duration) + 1) +
					startValue;
				},
				/**
				 * Performs out linear calculations based on time
				 * @method linear
				 * @member ns.util.easing
				 * @param {number} currentTime
				 * @param {number} startValue
				 * @param {number} changeInValue
				 * @param {number} duration
				 * @return {number}
				 * @static
				 */
				linear: function (currentTime, startValue, changeInValue, duration) {
					return startValue + changeInValue * currentTime / duration;
				}
			};
			}(ns));

/*global window, define, ns*/
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # ScrollView Widget
 * Widgets allows for creating scrollable panes, lists, etc.
 *
 * ## Default selectors
 * All elements with _data-role=content attribute or _.ui-scrollview
 * css class will be changed to ScrollView widgets, unless they specify
 * _data-scroll=none attribute.
 *
 * ### HTML Examples
 *
 * #### Data attribute
 *
 *        @example
 *        <div data-role="page">
 *            <div data-role="content"><!-- this will become scrollview //-->
 *                content data
 *            </div>
 *        </div>
 *
 * #### CSS Class
 *
 *        @example
 *        <div data-role="page">
 *            <div class="ui-content"><!-- this will become scrollview //-->
 *                content data
 *            </div>
 *        </div>
 *
 * ## Manual constructor
 *
 * To create the widget manually you can use 2 different APIs, the TAU
 * API or jQuery API.
 *
 * ### Create scrollview by TAU API
 *
 *        @example
 *        <div data-role="page" id="myPage">
 *            <div data-role="content">
 *                page content
 *            </div>
 *        </div>
 *        <script>
 *            var page = tau.widget.Page(document.getElementById("myPage")),
 *                scrollview = tau.widget.Scrollview(page.ui.content);
 *        </script>
 *
 * ### Create scrollview using jQuery API
 *
 *        @example
 *        <div data-role="page" id="myPage">
 *            <div data-role="content">
 *                page content
 *            </div>
 *        </div>
 *        <script>
 *            $("#myPage > div[data-role='content']").scrollview();
 *        </script>
 *
 * ## Options for Scrollview widget
 *
 * Options can be set using data-* attributes or by passing them to
 * the constructor.
 *
 * There is also a method **option** for changing them after widget
 * creation.
 *
 * jQuery mobile format is also supported.
 *
 * ## Scroll
 *
 * This options specifies of a content element should become Scrollview
 * widget.
 *
 * You can change this by all available methods for changing options.
 *
 * ### By data-scroll attribute
 *
 *        @example
 *        <div data-role="page">
 *            <div data-role="content" data-scroll="none">
 *                content
 *            </div>
 *        </div>
 *
 * ### By config passed to constructor
 *
 *        @example
 *        <div class="myPageClass" data-role="page">
 *            <div data-role="content">
 *                content
 *            </div>
 *        </div>
 *        <script>
 *            var contentElement = document.querySelector(".myPageClass > div[data-role=content]");
 *            tau.widget.Scrollview(contentElement, {
 *				"scroll": false
 *			});
 *        </script>
 *
 * ### By using jQuery API
 *
 *        @example
 *        <div class="myPageClass" data-role="page">
 *            <div data-role="content">
 *                content
 *            </div>
 *        </div>
 *        <script>
 *            $(".myPageClass > div[data-role='content']").scrollview({
 *				"scroll": false
 *			});
 *        </script>
 *
 * ## ScrollJumps
 *
 * Scroll jumps are small buttons which allow the user to quickly
 * scroll to top or left
 *
 * You can change this by all available methods for changing options.
 *
 * ### By data-scroll-jump
 *
 *        @example
 *        <div data-role="page">
 *            <div data-role="content" data-scroll-jump="true">
 *                content
 *            </div>
 *        </div>
 *
 * ### By config passed to constructor
 *
 *        @example
 *        <div class="myPageClass" data-role="page">
 *            <div data-role="content">
 *                content
 *            </div>
 *        </div>
 *        <script>
 *            var contentElement = document.querySelector(".myPageClass > div[data-role=content]");
 *            tau.widget.Scrollview(contentElement, {
 *				"scrollJump": true
 *			});
 *        </script>
 *
 * ### By using jQuery API
 *
 *        @example
 *        <div class="myPageClass" data-role="page">
 *            <div data-role="content">
 *                content
 *            </div>
 *        </div>
 *        <script>
 *            $(".myPageClass > div[data-role='content']").scrollview({
 *				"scrollJump": true
 *			});
 *        </script>
 *
 * ## Methods
 *
 * Page methods can be called trough 2 APIs: TAU API and jQuery API
 * (jQuery mobile-like API)
 *
 * @class ns.widget.core.Scrollview
 * @extends ns.widget.BaseWidget
 *
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Grzegorz Osimowicz <g.osimowicz@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Hyunkook Cho <hk0713.cho@samsung.com>
 * @author Junhyeon Lee <juneh.lee@samsung.com>
 */
/**
 * Triggered when scrolling operation starts
 * @event scrollstart
 * @member ns.widget.core.Scrollview
 */
/**
 * Triggered when scroll is being updated
 * @event scrollupdate
 * @member ns.widget.core.Scrollview
 */
/**
 * Triggered when scrolling stops
 * @event scrollstop
 * @member ns.widget.core.Scrollview
 */
(function (window, document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				util = ns.util,
				easingUtils = ns.util.easing,
				eventUtils = ns.event,
				DOMUtils = ns.util.DOM,
				selectors = ns.util.selectors,
				currentTransition = null,
				Page = ns.widget.core.Page,
				pageClass = Page.classes.uiPage,
				pageActiveClass = Page.classes.uiPageActive,
				pageEvents = Page.events,
				Scrollview = function () {
					var self = this,
						ui;
					/**
					 * @property {Object} _scrollState Scrollview internal state object
					 * @property {Function} _scrollState.currentTransition Instance transition function
					 * @readonly
					 */

					self._scrollState = {
						currentTransition: null
					};
					/**
					 * @property {number} scrollDuration The time length of the scroll animation
					 * @member ns.widget.core.Scrollview
					 */
					self.scrollDuration = 300;
					self.scrollviewSetHeight = false;
					/**
					 * Scrollview options
					 * @property {Object} options
					 * @property {string} [options.scroll='y'] Scroll direction
					 * @property {boolean} [options.scrollJump=false] Scroll jump buttons flag
					 * @member ns.widget.core.Scrollview
					 */
					self.options = {
						scroll: "y",
						scrollJump: false,
						scrollIndicator: false
					};
					/**
					 * Dictionary for holding internal DOM elements
					 * @property {Object} ui
					 * @property {HTMLElement} ui.view The main view element
					 * @property {HTMLElement} ui.page The main page element
					 * @property {HTMLElement} ui.jumpHorizontalButton Jump left button
					 * @property {HTMLElement} ui.jumpVerticalButton Jump top button
					 * @member ns.widget.core.Scrollview
					 * @readonly
					 */
					ui = self._ui || {};
					ui.view = null;
					ui.page = null;
					ui.jumpHorizontalButton = null;
					ui.jumpVerticalButton = null;
					self._ui = ui;
					/**
					 * Dictionary for holding internal listeners
					 * @property {Object} _callbacks
					 * @property {Function} _callbacks.repositionJumps Refresh jumps listener
					 * @property {Function} _callbacks.jumpTop Top jump button click callback
					 * @property {Function} _callbacks.jumpLeft Left jump button click callback
					 * @member ns.widget.core.Scrollview
					 * @protected
					 * @readonly
					 */
					self._callbacks = {
						repositionJumps: null,
						jumpTop: null,
						jumpBottom: null
					};

					self._timers = {
						scrollIndicatorHide: null
					};
				},
				/**
				 * Dictionary for scrollview css classes
				 * @property {Object} classes
				 * @property {string} [classes.view='ui-scrollview-view'] View main class
				 * @property {string} [classes.clip='ui-scrollview-clip'] Clip main class
				 * @property {string} [classes.jumpTop='ui-scroll-jump-top-bg'] Jump top button background
				 * @property {string} [classes.jumpLeft='ui-scroll-jump-left-bg'] Jump bottom button background
				 * @member ns.widget.core.Scrollview
				 * @static
				 * @readonly
				 */
				classes = {
					view: "ui-scrollview-view",
					clip: "ui-scrollview-clip",
					jumpTop: "ui-scroll-jump-top-bg",
					jumpLeft: "ui-scroll-jump-left-bg",
					indicatorTop: "ui-overflow-indicator-top",
					indicatorBottom: "ui-overflow-indicator-bottom",
					indicatorTopShown: "ui-scrollindicator-top",
					indicatorBottomShown: "ui-scrollindicator-bottom",
					indicatorLeftShown: "ui-scrollindicator-left",
					indicatorRightShown: "ui-scrollindicator-right"
				};

			// Changes static position to relative
			// @param {HTMLElement} view
			function makePositioned(view) {
				if (DOMUtils.getCSSProperty(view, "position") === "static") {
					view.style.position = "relative";
				} else {
					view.style.position = "absolute";
				}
			}

			// Translation animation loop
			// @param {Object} state Scrollview instance state
			// @param {HTMLElement} element
			// @param {number} startTime
			// @param {number} startX
			// @param {number} startY
			// @param {number} translateX
			// @param {number} translateY
			// @param {number} endX
			// @param {number} endY
			// @param {number} duration
			function translateTransition(state, element, startTime, startX, startY, translateX, translateY, endX, endY, duration) {
				var timestamp = (new Date()).getTime() - startTime,
					newX = parseInt(easingUtils.cubicOut(timestamp, startX, translateX, duration), 10),
					newY = parseInt(easingUtils.cubicOut(timestamp, startY, translateY, duration), 10);

				if (element.scrollLeft !== endX) {
					element.scrollLeft = newX;
				}
				if (element.scrollTop !== endY) {
					element.scrollTop = newY;
				}

				if ((newX !== endX || newY !== endY) &&
					(newX >= 0 && newY >= 0) &&
					state.currentTransition) {
					util.requestAnimationFrame(state.currentTransition);
				} else {
					state.currentTransition = null;
				}
			}

			// Translates scroll position directly or with an animation
			// if duration is specified
			// @param {Object} state Scrollview instance state
			// @param {HTMLElement} element
			// @param {number} x
			// @param {number} y
			// @param {number=} [duration]
			function translate(state, element, x, y, duration) {
				if (duration) {
					state.currentTransition = translateTransition.bind(
						null,
						state,
						element,
						(new Date()).getTime(),
						element.scrollLeft,
						element.scrollTop,
						x,
						y,
						element.scrollLeft + x,
						element.scrollTop + y,
						duration
					);
					util.requestAnimationFrame(state.currentTransition);
				} else {
					if (x) {
						element.scrollLeft = element.scrollLeft + x;
					}
					if (y) {
						element.scrollTop = element.scrollTop + y;
					}
				}
			}

			// Refresh jumpTop jumpLeft buttons
			// @param {ns.widget.core.Scrollview} self
			function repositionJumps(self) {
				var ui = self._ui,
					horizontalJumpButton = ui.jumpHorizontalButton,
					verticalJumpButton = ui.jumpVerticalButton,
					offsets = horizontalJumpButton || verticalJumpButton ? DOMUtils.getElementOffset(self.element) : null; // don't calc when not used

				if (horizontalJumpButton) {
					horizontalJumpButton.style.left = offsets.left + "px";
				}

				if (verticalJumpButton) {
					verticalJumpButton.style.top = offsets.top + "px";
				}
			}

			Scrollview.classes = classes;

			Scrollview.prototype = new BaseWidget();

			/**
			 * Builds the widget
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @method _build
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._build = function (element) {
				//@TODO wrap element's content with external function
				var self = this,
					ui = self._ui,
					view = selectors.getChildrenByClass(element, classes.view)[0] || document.createElement("div"),
					clipStyle = element.style,
					node,
					child = element.firstChild,
					options = self.options,
					direction = options.scroll,
					jumpButton,
					jumpBackground;

				view.className = classes.view;

				while (child) {
					node = child;
					child = child.nextSibling;
					if (view !== node) {
						view.appendChild(node);
					}
				}

				if (view.parentNode !== element) {
					element.appendChild(view);
				}

				// setting view style
				makePositioned(view);

				element.classList.add(classes.clip);

				// Adding ui-content class for the proper styling with CE
				element.classList.add("ui-content");

				switch (direction) {
					case "x":
						clipStyle.overflowX = "scroll";
						break;
					case "xy":
						clipStyle.overflow = "scroll";
						break;
					default:
						clipStyle.overflowY = "auto";
						break;
				}

				if (options.scrollJump) {
					if (direction.indexOf("x") > -1) {
						jumpBackground = document.createElement("div");
						jumpBackground.className = classes.jumpLeft;
						jumpButton = document.createElement("div");

						jumpBackground.appendChild(jumpButton);
						element.appendChild(jumpBackground);
						engine.instanceWidget(
							jumpButton,
							"Button",
							{
								"icon": "scrollleft",
								"style": "box"
							}
						);
						ui.jumpHorizontalButton = jumpBackground;
					}

					if (direction.indexOf("y") > -1) {
						jumpBackground = document.createElement("div");
						jumpBackground.className = classes.jumpTop;
						jumpButton = document.createElement("div");

						jumpBackground.appendChild(jumpButton);
						element.appendChild(jumpBackground);
						engine.instanceWidget(
							jumpButton,
							"Button",
							{
								"icon": "scrolltop",
								"style": "box"
							}
						);
						ui.jumpVerticalButton = jumpBackground;
					}
				}

				ui.view = view;

				// add scroll indicators
				if (options.scrollIndicator) {
					self._addOverflowIndicator(element);
				}

				return element;
			};

			/**
			 * Inits widget
			 * @method _init
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._init = function (element) {
				var ui = this._ui,
					page = ui.page;

				if (!ui.view) {
					ui.view = selectors.getChildrenByClass(element, classes.view)[0];
				}

				if (!page) {
					page = selectors.getClosestByClass(element, pageClass);
					if (page) {
						ui.page = page;
						if (page.classList.contains(pageActiveClass) && this.options.scrollJump) {
							repositionJumps(this);
						}
					}
				}
			};

			/**
			 * Adds overflow indicators
			 * @param {HTMLElement} clip
			 * @method _addOverflowIndicator
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._addOverflowIndicator = function (clip) {
				clip.insertAdjacentHTML("beforeend",
					"<div class='" + classes.indicatorTop + "'></div><div class='" + classes.indicatorBottom + "'></div>");
			};

			/**
			 * Clear classes and styles of indicators
			 * @param {HTMLElement} element
			 * @method clearIndicator
			 * @private
			 * @member ns.widget.core.Scrollview
			 */
			function clearIndicator(element) {
				var clipClasses = element.classList,
					topIndicator = selectors.getChildrenByClass(element, classes.indicatorTop)[0],
					bottomIndicator = selectors.getChildrenByClass(element, classes.indicatorBottom)[0];

				clipClasses.remove(classes.indicatorTopShown);
				clipClasses.remove(classes.indicatorBottomShown);
				clipClasses.remove(classes.indicatorRightShown);
				clipClasses.remove(classes.indicatorLeftShown);
				topIndicator.style = "";
				bottomIndicator.style = "";
			}

			/**
			 * Set top and bottom indicators
			 * @param {HTMLElement} clip
			 * @param {Object} options
			 * @method setTopAndBottomIndicators
			 * @private
			 * @member ns.widget.core.Scrollview
			 */
			function setTopAndBottomIndicators(clip, options) {
				var topIndicator = selectors.getChildrenByClass(clip, classes.indicatorTop)[0],
					bottomIndicator = selectors.getChildrenByClass(clip, classes.indicatorBottom)[0],
					style;

				// set top indicator
				if (topIndicator) {
					style = topIndicator.style;
					style.width = options.width + "px";
					style.top = options.clipTop + "px";
					style.backgroundColor = options.color;
				}
				if (bottomIndicator) {
					// set bottom indicator
					style = bottomIndicator.style;
					style.width = options.width + "px";
					style.top = options.clipTop + options.clipHeight - DOMUtils.getElementHeight(bottomIndicator) + "px";
					style.backgroundColor = options.color;
				}
			}

			/**
			 * Show scroll indicators.
			 * @method _showScrollIndicator
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._showScrollIndicator = function () {
				var self = this,
					clip = self.element,
					view = self._ui.view,
					scrollTop = clip.scrollTop,
					clipHeight = DOMUtils.getElementHeight(clip),
					clipOffset = DOMUtils.getElementOffset(clip),
					viewHeight = DOMUtils.getElementHeight(view),
					viewWidth = DOMUtils.getElementWidth(view),
					viewOffset = DOMUtils.getElementOffset(view);

				clearIndicator(clip);

				switch (self.options.scroll) {
					case "x":
					case "xy":
						// @todo
						break;
					default:
						setTopAndBottomIndicators(clip, {
							clipTop: clipOffset.top,
							clipHeight: clipHeight,
							width: viewWidth,
							color: window.getComputedStyle(clip).backgroundColor
						});
						if (viewOffset.top - scrollTop < clipOffset.top) {
							// the top is not visible
							clip.classList.add(classes.indicatorTopShown);
						}
						if (viewOffset.top - scrollTop + viewHeight > clipOffset.top + clipHeight) {
							// the bottom is not visible
							clip.classList.add(classes.indicatorBottomShown);
						}
				}
			};

			/**
			 * Hide scroll indicators.
			 * @method _hideScrollIndicator
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._hideScrollIndicator = function () {
				var self = this,
					timers = self._timers,
					timer = timers.scrollIndicatorHide;

				if (timer) {
					window.clearTimeout(timer);
				}
				timers.scrollIndicatorHide = window.setTimeout(function () {
					clearIndicator(self.element);
				}, 1500);
			};

			/**
			 * Scrolls to specified position
			 *
			 * This method give possibility to scroll on Scrollview widget form JS interface of widget.
			 *
			 * <mobile>
			 * On mobile profile you can use method in jQuery style.
			 * </mobile>
			 *
			 * If duration is set then scroll will be animated in given time period.
			 *
			 * <wearable>
			 * On wearable profile Scrollview widget isn't build automatically. Before using method scrollTo, you need
			 * create widget on content of page.
			 * </wearable>
			 * ### Example usage with TAU API
			 *
			 *		@example mobile wearable
			 *		<div class="myPageClass" data-role="page">
			 *			<div data-role="content" data-scroll="y">
			 *				content
			 *			</div>
			 *		</div>
			 *		<script>
			 *			var scrollview = tau.widget.Scrollview(document.querySelector(".myPageClass > div[data-role=content]"));
			 *			scrollview.scrollTo(0, 200, 1000); // scroll to 200px vertical with 1s animation
			 *		</script>
			 *
			 * ### Example usage with jQuery API
			 *
			 *		@example mobile
			 *		<div class="myPageClass" data-role="page">
			 *			<div data-role="content" data-scroll="y">
			 *				content
			 *			</div>
			 *		</div>
			 *		<script>
			 *			var element = $(".myPageClass > div[data-role=content]"));
			 *			element.scrollview();
			 *			element.scrollview("scrollTo", 0, 200, 1000); // scroll to 200px vertical with 1s animation
			 *		</script>
			 *
			 * @param {number} x
			 * @param {number} y
			 * @param {number=} [duration]
			 * @method scrollTo
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype.scrollTo = function (x, y, duration) {
				var element = this.element;

				this.translateTo(x - element.scrollLeft, y - element.scrollTop, duration);
			};

			/**
			 * Translates the scroll to specified position
			 *
			 * ### Example usage with TAU API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var scrollview = tau.widget.Scrollview(document.querySelector(".myPageClass > div[data-role=content]"));
			 *            scrollview.translateTo(0, 200, 1000); // scroll forward 200px in vertical direction with 1s animation
			 *        </script>
			 *
			 * ### Example usage with jQuery API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var element = $(".myPageClass > div[data-role=content]"));
			 *            element.scrollview();
			 *            element.scrollview("translateTo", 0, 200, 1000); // scroll forward 200px in vertical direction with 1s animation
			 *        </script>
			 *
			 * @param {number} x
			 * @param {number} y
			 * @param {number=} [duration]
			 * @method translateTo
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype.translateTo = function (x, y, duration) {
				translate(this._scrollState, this.element, x, y, duration);
			};

			/**
			 * Ensures that specified element is visible in the
			 * clip area
			 *
			 * ### Example usage with TAU API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *                <div class="testElementClass">some data</div>
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var scrollview = tau.widget.Scrollview(document.querySelector(".myPageClass > div[data-role=content]")),
			 *                testElement = document.querySelector(".testElementClass");
			 *            scrollview.ensureElementIsVisible(testElement);
			 *        </script>
			 *
			 * ### Example usage with jQuery API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *                <div class="testElementClass">some data</div>
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var element = $(".myPageClass > div[data-role=content]")),
			 *                testElement = $(".testElementClass");
			 *            element.scrollview();
			 *            element.scrollview("ensureElementIsVisible", testElement);
			 *        </script>
			 *
			 * @param {HTMLElement} element
			 * @method ensureElementIsVisible
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype.ensureElementIsVisible = function (element) {
				var clip = this.element,
					clipHeight = DOMUtils.getElementHeight(clip),
					clipWidth = DOMUtils.getElementWidth(clip),
					clipTop = 0,
					clipBottom = clipHeight,
					elementHeight = DOMUtils.getElementHeight(element),
					elementWidth = DOMUtils.getElementWidth(element),
					elementTop = 0,
					elementBottom,
					elementFits = clipHeight >= elementHeight && clipWidth >= elementWidth,
					anchor,
					anchorPositionX,
					anchorPositionY,
					parent,
					findPositionAnchor = function (input) {
						var id = input.getAttribute("id"),
							tagName = input.tagName.toLowerCase();

						if (id && ["input", "textarea", "button"].indexOf(tagName) > -1) {
							return input.parentNode.querySelector("label[for=" + id + "]");
						}
					},
					_true = true;

				parent = element.parentNode;
				while (parent && parent !== clip) {
					elementTop += parent.offsetTop;
					//elementLeft += parent.offsetLeft;
					parent = parent.parentNode;
				}
				elementBottom = elementTop + elementHeight;
				//elementRight = elementLeft + elementWidth;

				/* C1) element fits in view is inside clip area
				 * C2) element visible only at top; eg. partly visible textarea
				 * C3) element visible only at bottom
				 * C4) element fits in view but its visible only at top
				 * C5) element fits in view but its visible only at bottom
				 */
				switch (_true) {
					case elementFits && clipTop < elementTop && clipBottom > elementBottom:
					case clipTop < elementTop && elementTop < clipBottom && clipBottom < elementBottom:
					case clipTop > elementTop && clipBottom > elementBottom:
						// (1) pass, element position is ok
						// (2, 3) pass, we cant do anything, if we move the scroll the user could lost view of
						// something he scrolled to
						break;
					case elementFits && clipTop < elementTop && clipBottom < elementBottom:
					case elementFits && clipTop > elementTop && clipBottom > elementBottom:
					case elementFits: // element fits in view but is not visible
						this.centerToElement(element);
						break;
					default: // element is not visible
						anchor = findPositionAnchor(element);
						if (!anchor) {
							anchor = element;
						}
						anchorPositionX = anchor.offsetLeft + DOMUtils.getCSSProperty(anchor, "margin-left", 0, "integer");
						anchorPositionY = anchor.offsetTop + DOMUtils.getCSSProperty(anchor, "margin-top", 0, "integer");
						parent = anchor.parentNode;
						while (parent && parent !== clip) {
							anchorPositionX += parent.offsetLeft;
							anchorPositionY += parent.offsetTop;
							parent = parent.parentNode;
						}
						this.scrollTo(anchorPositionX, anchorPositionY, this.scrollDuration);
						break;
				}
			};

			/**
			 * Centers specified element in the clip area
			 *
			 * ### Example usage with TAU API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *                <div class="testElementClass">some data</div>
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var scrollview = tau.widget.Scrollview(document.querySelector(".myPageClass > div[data-role=content]")),
			 *                testElement = document.querySelector(".testElementClass");
			 *            scrollview.centerToElement(testElement);
			 *        </script>
			 *
			 * ### Example usage with jQuery API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *                <div class="testElementClass">some data</div>
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var element = $(".myPageClass > div[data-role=content]")),
			 *                testElement = $(".testElementClass");
			 *            element.scrollview();
			 *            element.scrollview("centerToElement", testElement);
			 *        </script>
			 *
			 * @param {HTMLElement} element
			 * @method centerToElement
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype.centerToElement = function (element) {
				var clip = this.element,
					deltaX = parseInt(DOMUtils.getElementWidth(clip) / 2 - DOMUtils.getElementWidth(element) / 2, 10),
					deltaY = parseInt(DOMUtils.getElementHeight(clip) / 2 - DOMUtils.getElementHeight(element) / 2, 10),
					elementPositionX = element.offsetLeft,
					elementPositionY = element.offsetTop,
					parent = element.parentNode;

				while (parent && parent !== clip) {
					elementPositionX += parent.offsetLeft + DOMUtils.getCSSProperty(parent, "margin-left", 0, "integer");
					elementPositionY += parent.offsetTop + DOMUtils.getCSSProperty(parent, "margin-top", 0, "integer");
					parent = parent.parentNode;
				}
				this.scrollTo(elementPositionX - deltaX, elementPositionY - deltaY, this.scrollDuration);
			};

			/**
			 * Returns scroll current position
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var scrollview = tau.widget.Scrollview(document.querySelector(".myPageClass > div[data-role=content]")),
			 *                currentPosition = scrollview.getScrollPosition();
			 *        </script>
			 *
			 * ### Example usage with jQuery API
			 *
			 *        @example
			 *        <div class="myPageClass" data-role="page">
			 *            <div data-role="content" data-scroll="y">
			 *                content
			 *            </div>
			 *        </div>
			 *        <script>
			 *            var element = $(".myPageClass > div[data-role=content]")),
			 *                position;
			 *            element.scrollview();
			 *            position = element.scrollview("getScrollPosition");
			 *        </script>
			 *
			 * @return {Object}
			 * @method getScrollPosition
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype.getScrollPosition = function () {
				var element = this.element;

				return {
					"x": element.scrollLeft,
					"y": element.scrollTop
				};
			};

			/**
			 * Binds scrollview events
			 * @method _bindEvents
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Scrollview
			 */
			Scrollview.prototype._bindEvents = function (element) {
				var scrollTimer = null,
					notifyScrolled = function () {
						eventUtils.trigger(element, "scrollstop");
						window.clearTimeout(scrollTimer);
						scrollTimer = null;
					},
					self = this,
					//FIXME there should be some other way to get parent container
					ui = self._ui,
					page = ui.page,
					jumpTop = ui.jumpVerticalButton,
					jumpLeft = ui.jumpHorizontalButton,
					repositionJumpsCallback,
					jumpTopCallback,
					jumpLeftCallback,
					callbacks = self._callbacks;

				if (page) {
					if (this.options.scrollJump) {
						repositionJumpsCallback = repositionJumps.bind(null, this);
						jumpTopCallback = function () {
							self.scrollTo(element.scrollLeft, 0, 250);
						};
						jumpLeftCallback = function () {
							self.scrollTo(0, element.scrollTop, 250);
						};
						page.addEventListener(pageEvents.SHOW, repositionJumpsCallback, false);
						if (jumpTop) {
							jumpTop.firstChild.addEventListener("vclick", jumpTopCallback, false);
						}
						if (jumpLeft) {
							jumpLeft.firstChild.addEventListener("vclick", jumpLeftCallback, false);
						}

						callbacks.repositionJumps = repositionJumpsCallback;
						callbacks.jumpTop = jumpTopCallback;
						callbacks.jumpLeft = jumpLeftCallback;
					}

					element.addEventListener("scroll", function () {
						if (scrollTimer) {
							window.clearTimeout(scrollTimer);
						} else {
							eventUtils.trigger(element, "scrollstart");
						}
						scrollTimer = window.setTimeout(notifyScrolled, 100);
						eventUtils.trigger(element, "scrollupdate");
					}, false);

					document.addEventListener("vmousedown", function () {
						if (currentTransition) {
							currentTransition = null;
						}
					}, false);

					if (self.options.scrollIndicator) {
						callbacks.scrollUpdate = self._showScrollIndicator.bind(self);
						element.addEventListener("scrollupdate", callbacks.scrollUpdate, false);
						callbacks.scrollStop = self._hideScrollIndicator.bind(self);
						element.addEventListener("scrollstop", callbacks.scrollStop, false);
					}

				}
			};

			Scrollview.prototype._destroy = function () {
				var self = this,
					element = self.element,
					ui = self._ui,
					page = ui.page,
					scrollJump = this.options.scrollJump,
					jumpTop = ui.jumpVerticalButton,
					jumpLeft = ui.jumpHorizontalButton,
					callbacks = self._callbacks,
					repositionJumpsCallback = callbacks.repositionJumps,
					jumpTopCallback = callbacks.jumpTop,
					jumpLeftCallback = callbacks.jumpLeft;

				if (scrollJump) {
					if (page && repositionJumpsCallback) {
						page.removeEventListener(pageEvents.SHOW, repositionJumpsCallback, false);
					}
					if (jumpTop && jumpTopCallback) {
						jumpTop.firstChild.removeEventListener("vclick", jumpTopCallback, false);
					}
					if (jumpLeft && jumpLeftCallback) {
						jumpLeft.firstChild.removeEventListener("vclick", jumpLeftCallback, false);
					}
				}

				if (self.options.scrollIndicator) {
					element.removeEventListener("scrollupdate", callbacks.scrollUpdate, false);
				}

				if (self._timers.scrollIndicatorHide) {
					window.clearTimeout(self._timers.scrollIndicatorHide);
				}

			};

			ns.widget.core.Scrollview = Scrollview;
			}(window, window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * @class ns.widget.mobile.Tab
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				events = ns.event,
				Tab = function () {
				},
				/**
				 * Object with class dictionary
				 * @property {Object} classes
				 * @static
				 * @member ns.widget.mobile.Tab
				 * @readonly
				 */
				classes = {},
				CustomEvent = {
					TAB_CHANGE: "tabchange"
				},
				prototype = new BaseWidget();

			Tab.prototype = prototype;
			Tab.classes = classes;

			/**
			 * Set the active tab
			 * @method setActive
			 * @param {number} index of the tab
			 * @public
			 * @member ns.widget.mobile.Tab
			 */
			prototype._setActive = function (index) {
				var element = this.element;

				events.trigger(element, CustomEvent.TAB_CHANGE, {
					active: index
				});
			};
			/**
			 * Set the active tab
			 * @method setActive
			 * @param {number} index of the tab
			 * @public
			 * @member ns.widget.mobile.Tab
			 */
			prototype.setActive = function (index) {
				this._setActive(index);
			};

			/**
			 * Get the active tab
			 * @method setActive
			 * @public
			 * @member ns.widget.mobile.Tab
			 */
			prototype._getActive = function () {
				return this.options.active;
			};

			/**
			 * Get the active tab
			 * @method setActive
			 * @public
			 * @member ns.widget.mobile.Tab
			 */
			prototype.getActive = function () {
				return this._getActive();
			};

			ns.widget.core.Tab = Tab;
			engine.defineWidget(
				"Tab",
				"",
				["setActive", "getActive"],
				Tab,
				"tizen"
			);
			}(window.document, ns));

/*global window, ns, define, Event, console */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #TabIndicator Widget
 * Widget create tabs indicator.
 * @class ns.widget.core.TabIndicator
 * @since 2.3
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var Tab = ns.widget.core.Tab,
				engine = ns.engine,
				object = ns.util.object,

				TabIndicator = function () {
					this.tabSize = 0;
					this.width = 0;
				},

				TabPrototype = Tab.prototype,
				prototype = new Tab();

			TabIndicator.prototype = prototype;

			prototype._init = function (element) {
				var o = this.options;

				this.width = element.offsetWidth;
				element.classList.add(o.wrapperClass);
			};

			prototype._configure = function () {
				/**
				 * @property {Object} options Options for widget
				 * @property {number} [options.margin=2]
				 * @property {boolean} [options.triggerEvent=false]
				 * @property {string} [options.wrapperClass="ui-tab-indicator]
				 * @property {string} [options.itemClass="ui-tab-item"]
				 * @property {string} [options.activeClass="ui-tab-active"]
				 * @member ns.widget.core.TabIndicator
				 */
				object.merge(this.options, {
					margin: 4,
					triggerEvent: false,
					wrapperClass: "ui-tab-indicator",
					itemClass: "ui-tab-item",
					activeClass: "ui-tab-active",
					active: 0
				});
			};

			prototype._createIndicator = function () {
				var o = this.options,
					wrap = document.createDocumentFragment(),
					widthTable = [],
					margin = o.margin,
					i = 0,
					len = this.tabSize,
					width = this.width - margin * (len - 1),
					std = Math.floor(width / len),
					remain = width % len,
					span,
					offset = 0;

				for (i = 0; i < len; i++) {
					widthTable[i] = std;
				}

				for (i = Math.floor((len - remain) / 2); remain > 0; i++, remain--) {
					widthTable[i] += 1;
				}

				for (i = 0; i < len; i++) {
					span = document.createElement("span");
					span.classList.add(o.itemClass);
					span.style.width = widthTable[i] + "px";
					span.style.left = offset + "px";
					offset += widthTable[i] + margin;

					if (i === o.active) {
						span.classList.add(o.activeClass);
					}
					wrap.appendChild(span);
				}

				this.element.appendChild(wrap);
			};

			prototype._removeIndicator = function () {
				this.element.innerHTML = "";
			};

			prototype._refresh = function () {
				this._removeIndicator();
				this._createIndicator();
			};

			/**
			 * @method setActive
			 * @param {number} index
			 * @member ns.widget.core.TabIndicator
			 */
			prototype._setActive = function (index) {
				var o = this.options,
					nodes = this.element.children;

				o.active = index;

				[].forEach.call(nodes, function (element) {
					element.classList.remove(o.activeClass);
				});

				if (index < nodes.length) {
					nodes[index].classList.add(o.activeClass);

					TabPrototype._setActive.call(this, index);
				}
			};

			/**
			 * @method setSize
			 * @param {number} size
			 * @member ns.widget.core.TabIndicator
			 */
			prototype.setSize = function (size) {
				var needRefresh = this.tabSize !== size;

				this.tabSize = size;
				if (needRefresh) {
					this.refresh();
				}
			};

			prototype._destroy = function () {
				var o = this.options;

				this._removeIndicator();

				this.element.classList.remove(o.wrapperClass);
			};

			ns.widget.core.TabIndicator = TabIndicator;

			engine.defineWidget(
				"TabIndicator",
				".ui-tab",
				["setActive", "getActive", "setSize"],
				TabIndicator
			);
			}(window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns*/
/**
 * # Section Changer
 * Section changer component provides an application architecture, which has multiple sections on one page.
 *
 * The section changer widget provides an application architecture, which has
 * multiple sections on a page and enables scrolling through the *section* elements.
 *
 * ## Manual constructor
 *
 *      @example template tau-section-changer
 *         <div class="ui-section-changer">
 *             <div>
 *                 <section style="text-align:center"><span>${1:Section 1}</span></section>
 *                 <section style="text-align:center"><span>${2:Section 2}</span></section>
 *             </div>
 *         </div>
 *
 *
 *      @example
 *         <div id="hasSectionchangerPage" class="ui-page">
 *             <header class="ui-header">
 *                 <h2 class="ui-title">SectionChanger</h2>
 *             </header>
 *             <div id="sectionchanger" class="ui-content">
 *                 <!--Section changer has only one child-->
 *                 <div>
 *                     <section>
 *                         <h3>LEFT1 PAGE</h3>
 *                     </section>
 *                     <section class="ui-section-active">
 *                         <h3>MAIN PAGE</h3>
 *                     </section>
 *                     <section>
 *                         <h3>RIGHT1 PAGE</h3>
 *                     </section>
 *                 </div>
 *             </div>
 *         </div>
 *         <script>
 *             (function () {
 *                 var page = document.getElementById("hasSectionchangerPage"),
 *                     element = document.getElementById("sectionchanger"),
 *                     sectionChanger;
 *
 *                 page.addEventListener("pageshow", function () {
 *                     // Create the SectionChanger object
 *                     sectionChanger = new tau.SectionChanger(element, {
 *                         circular: true,
 *                         orientation: "horizontal",
 *                         useBouncingEffect: true
 *                     });
 *                 });
 *
 *                 page.addEventListener("pagehide", function () {
 *                     // Release the object
 *                     sectionChanger.destroy();
 *                 });
 *             })();
 *         </script>
 *
 * ## Handling Events
 *
 * To handle section changer events, use the following code:
 *
 *      @example
 *         <script>
 *             (function () {
 *                 var changer = document.getElementById("sectionchanger");
 *                 changer.addEventListener("sectionchange", function (event) {
 *                     console.debug(event.detail.active + " section is active.");
 *                 });
 *             })();
 *         </script>
 *
 * @class ns.widget.core.SectionChanger
 * @since 2.4
 * @component-selector [data-role="section-changer"], .ui-section-changer
 * @component-type container-component
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var Scroller = ns.widget.core.scroller.Scroller,
				gesture = ns.event.gesture,
				Orientation = gesture.Orientation,
				engine = ns.engine,
				utilsObject = ns.util.object,
				utilsEvents = ns.event,
				objectMerge = ns.util.object.merge,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				Page = ns.widget.core.Page,
				selectors = ns.util.selectors,
				eventType = objectMerge({
					/**
					 * Triggered when the section is changed.
					 * @event sectionchange
					 * @member ns.widget.core.SectionChanger
					 */
					CHANGE: "sectionchange"
				}, Scroller.EventType),
				classes = {
					uiSectionChanger: "ui-section-changer"
				},
				/**
				 * Options for widget
				 * @property {Object} defaultOptions
				 * @property {"horizontal"|"vertical"} [defaultOptions.orientation="horizontal"] Sets the section changer orientation:
				 * @property {boolean} [defaultOptions.circular=false] Presents the sections in a circular scroll fashion.
				 * @property {boolean} [defaultOptions.useBouncingEffect=false] Shows a scroll end effect on the scroll edge.
				 * @property {string} [defaultOptions.items="section"] Defines the section element selector.
				 * @property {string} [defaultOptions.activeClass="ui-section-active"] Specifies the CSS classes which define the active section element. Add the specified class (ui-section-active) to a *section* element to indicate which section must be shown first. By default, the first section is shown first.
				 * @property {boolean} [defaultOptions.fillContent=true] declare to section tag width to fill content or not.
				 * @member ns.widget.core.SectionChanger
				 */
				defaultOptions = {
					items: "section",
					activeClass: "ui-section-active",
					circular: false,
					animate: true,
					animateDuration: 100,
					orientation: "horizontal",
					changeThreshold: -1,
					useTab: false,
					fillContent: true,
					model: null,
					directives: null
				};

			function SectionChanger() {
				this.options = objectMerge({}, defaultOptions);
				BaseKeyboardSupport.call(this);
				this._ui = {
					page: null
				};
			}

			function calculateCustomLayout(direction, elements, lastIndex) {
				var elementsLength = elements.length,
					length = lastIndex !== undefined ? lastIndex : elementsLength,
					result = 0,
					i = 0;

				if (length > elementsLength) {
					length = elementsLength;
				}

				for (i; i < length; i++) {
					result += direction === Orientation.HORIZONTAL ? elements[i].offsetWidth : elements[i].offsetHeight;
				}
				return result;
			}

			function calculateCenter(direction, elements, index) {
				var result = calculateCustomLayout(direction, elements, index + 1),
					element = elements[index];

				if (element) {
					result -= direction === Orientation.HORIZONTAL ? element.offsetWidth / 2 : element.offsetHeight / 2;
				}

				return result;
			}

			utilsObject.inherit(SectionChanger, Scroller, {
				_build: function (element) {
					var self = this,
						options = self.options,
						offsetHeight;

					self.tabIndicatorElement = null;
					self.tabIndicator = null;

					self.sections = null;
					self.sectionPositions = [];

					self.activeIndex = 0;
					self.beforeIndex = 0;

					self._super(element);

					element.classList.add(classes.uiSectionChanger);

					self.scroller.style.position = "absolute";
					offsetHeight = element.offsetHeight;

					if (offsetHeight === 0) {
						offsetHeight = element.parentNode.offsetHeight;
						element.style.height = offsetHeight + "px";
					}

					self._sectionChangerWidth = element.offsetWidth;
					self._sectionChangerHeight = offsetHeight;
					self._sectionChangerHalfWidth = self._sectionChangerWidth / 2;
					self._sectionChangerHalfHeight = self._sectionChangerHeight / 2;
					self.orientation = options.orientation === "horizontal" ? Orientation.HORIZONTAL : Orientation.VERTICAL;

					return element;
				},

				_configure: function () {
					this._super();
					this.options = utilsObject.merge(this.options, defaultOptions);
				},

				/**
				 * Generic method for data-bind for HTML element
				 * @method _fillElementFromModel
				 * @param {HTMLElement} element
				 * @param {Object} dataItem
				 * @param {Function[]} directive
				 * @member ns.widget.core.SectionChanger
				 * @protected
				 */
				_fillElementFromModel: function (element, dataItem, directive) {
					var itemName,
						dataBoundElement;

					for (itemName in dataItem) {
						if (dataItem.hasOwnProperty(itemName)) {
							dataBoundElement = element.querySelector("[data-bind='" + itemName + "']");
							if (dataBoundElement) {
								if (typeof directive[itemName] === "function") {
									directive[itemName].call(dataBoundElement, dataItem[itemName]);
								} else {
									dataBoundElement.innerText = dataItem[itemName];
								}
							}
						}
					}
				},

				/**
				 * Specific method for widget filling from model
				 * @method _fillElementFromModel
				 * @param {string} key
				 * @param {Array} data
				 * @param {Function} directive
				 * @member ns.widget.core.SectionChanger
				 * @protected
				 */
				_fillWidgetFromModel: function (key, data, directive) {
					var self = this,
						element = self.element,
						dataBoundElements,
						dataBoundElement,
						content,
						parentElement;

					// clone section for all items
					dataBoundElements = element.querySelectorAll("[data-bind='" + key + "'] > section");

					if (dataBoundElements.length === 1) { // clone element for each item
						dataBoundElement = dataBoundElements[0];
						content = dataBoundElement.innerHTML;
						parentElement = dataBoundElement.parentElement;

						parentElement.removeChild(dataBoundElement);
						data.forEach(function (dataItem) {
							var newElement = dataBoundElement.cloneNode();

							newElement.innerHTML = content;
							self._fillElementFromModel(newElement, dataItem, directive);

							parentElement.appendChild(newElement);
						});
					} else {
						// @todo
						// fill existent elements by data
					}
				},

				_findDataBinding: function () {
					var model = this.options.model,
						modelItem,
						directives = this.options.directives,
						directive,
						key;

					// create items for data
					if (model) {
						for (key in model) {
							if (model.hasOwnProperty(key)) {
								modelItem = model[key];
								if (typeof modelItem === "string") {
									// @todo
									// innerText for item
								} else if (Array.isArray(modelItem)) {
									if (directives) {
										directive = directives[key];
									}
									this._fillWidgetFromModel(key, modelItem, directive);
								}
							}
						}
					}
				},

				_init: function (element) {
					var self = this,
						options = self.options,
						scroller = self.scroller,
						sectionLength,
						i,
						className,
						ui = self._ui;

					if (options.scrollbar === "tab") {
						options.scrollbar = false;
						options.useTab = true;
					}

					if (options.model) {
						self._findDataBinding();
					}

					// find parent page
					ui.page = selectors.getClosestBySelector(self.element, "." + Page.classes.uiPage);

					if (scroller) {
						self.sections = typeof options.items === "string" ?
							scroller.querySelectorAll(options.items) :
							options.items;

						sectionLength = self.sections.length;

						if (options.circular && sectionLength < 3) {
							ns.error("[SectionChanger] if you use circular option, you must have at least three sections.");
						} else {
							for (i = 0; i < sectionLength; i++) {
								className = self.sections[i].className;
								if (className && className.indexOf(options.activeClass) > -1) {
									self.activeIndex = i;
								} else {
									if (self.isKeyboardSupport === true) {
										self.disableFocusableElements(self.sections[i]);
									}
								}

								self.sectionPositions[i] = i;
							}

							self._prepareLayout();
							self._initLayout();
							self._super(element);
							self._repositionSections(true);
							self.setActiveSection(self.activeIndex);

							// set correct options values.
							if (!options.animate) {
								options.animateDuration = 0;
							}
							if (options.changeThreshold < 0) {
								options.changeThreshold = self._sectionChangerHalfWidth;
							}
						}
					}

					return element;
				},

				_prepareLayout: function () {
					var o = this.options,
						sectionLength = this.sections.length,
						width = this._sectionChangerWidth,
						height = this._sectionChangerHeight,
						orientation = this.orientation,
						scrollerStyle = this.scroller.style,
						tabHeight;

					if (o.useTab) {
						this._initTabIndicator();
						tabHeight = this.tabIndicatorElement.offsetHeight;
						height -= tabHeight;
						this._sectionChangerHalfHeight = height / 2;
						this.element.style.height = height + "px";
						this._sectionChangerHeight = height;
					}

					if (orientation === Orientation.HORIZONTAL) {
						scrollerStyle.width = (o.fillContent ? width * sectionLength : calculateCustomLayout(orientation, this.sections)) + "px";
						scrollerStyle.height = height + "px"; //set Scroller width
					} else {
						scrollerStyle.width = width + "px"; //set Scroller width
						scrollerStyle.height = (o.fillContent ? height * sectionLength : calculateCustomLayout(orientation, this.sections)) + "px";
					}

				},

				_initLayout: function () {
					var sectionStyle,
						left = 0,
						top = 0,
						i,
						sectionLength;

					//section element has absolute position
					for (i = 0, sectionLength = this.sections.length; i < sectionLength; i++) {
						//Each section set initialize left position
						sectionStyle = this.sections[i].style;
						sectionStyle.position = "absolute";
						if (this.options.fillContent) {
							sectionStyle.width = this._sectionChangerWidth + "px";
							sectionStyle.height = this._sectionChangerHeight + "px";
						}

						if (this.orientation === Orientation.HORIZONTAL) {
							top = 0;
							left = calculateCustomLayout(this.orientation, this.sections, i);
						} else {
							top = calculateCustomLayout(this.orientation, this.sections, i);
							left = 0;
						}

						sectionStyle.top = top + "px";
						sectionStyle.left = left + "px";
					}

				},

				_initBouncingEffect: function () {
					var o = this.options;

					if (!o.circular) {
						this._super();
					}
				},

				_translateScrollbar: function (x, y, duration, autoHidden) {
					var self = this,
						offset,
						scrollbar = self.scrollbar;

					if (scrollbar) {
						if (self.orientation === Orientation.HORIZONTAL) {
							offset = -x + self.minScrollX;
						} else {
							offset = -y + self.minScrollY;
						}

						scrollbar.translate(offset, duration, autoHidden);
					}
				},

				_translateScrollbarWithPageIndex: function (pageIndex, duration) {
					var offset;

					if (!this.scrollbar) {
						return;
					}

					offset = calculateCustomLayout(this.orientation, this.sections, this.activeIndex);

					this.scrollbar.translate(offset, duration);
				},

				_initTabIndicator: function () {
					var self = this,
						tabElement = document.createElement("div"),
						element = self.element,
						tabIndicator = null;

					self.tabIndicatorElement = tabElement;

					element.parentNode.insertBefore(tabElement, element);

					tabIndicator = new engine.instanceWidget(tabElement, "TabIndicator");
					self.tabIndicator = tabIndicator;
					tabIndicator.setSize(self.sections.length);
					tabIndicator.setActive(self.activeIndex);
					self.tabIndicatorHandler = function (event) {
						this.tabIndicator.setActive(event.detail.active);
					}.bind(self);
					element.addEventListener(eventType.CHANGE, self.tabIndicatorHandler, false);
				},

				_clearTabIndicator: function () {
					if (this.tabIndicator) {
						this.element.parentNode.removeChild(this.tabIndicatorElement);
						this.element.removeEventListener(eventType.CHANGE, this.tabIndicatorHandler, false);
						this.tabIndicator.destroy();
						this.tabIndicator = null;
						this.tabIndicatorElement = null;
						this.tabIndicatorHandler = null;
					}
				},

				_resetLayout: function () {
					var //scrollerStyle = this.scroller.style,
						sectionStyle,
						i,
						sectionLength;

					//scrollerStyle.width = "";
					//scrollerStyle.height = "";
					//this.scroller || this.scroller._resetLayout();

					for (i = 0, sectionLength = this.sections.length; i < sectionLength; i++) {
						sectionStyle = this.sections[i].style;

						sectionStyle.position = "";
						sectionStyle.width = "";
						sectionStyle.height = "";
						sectionStyle.top = "";
						sectionStyle.left = "";
					}

					this._super();
				},

				_bindEvents: function () {
					var self = this;

					self._super();

					if (self.scroller) {
						ns.event.enableGesture(
							self.scroller,

							new ns.event.gesture.Swipe({
								orientation: self.orientation === Orientation.HORIZONTAL ?
									gesture.Orientation.HORIZONTAL :
									gesture.Orientation.VERTICAL
							})
						);

						utilsEvents.on(self.scroller,
							"swipe transitionEnd webkitTransitionEnd mozTransitionEnd msTransitionEnd oTransitionEnd", self);
						if (self._ui.page) {
							utilsEvents.on(self._ui.page, "taufocusborder", self);
						}
					}

					document.addEventListener("rotarydetent", self, true);
				},

				_unbindEvents: function () {
					var self = this;

					self._super();

					if (self.scroller) {
						ns.event.disableGesture(self.scroller);
						utilsEvents.off(self.scroller,
							"swipe transitionEnd webkitTransitionEnd mozTransitionEnd msTransitionEnd oTransitionEnd", self);
						if (self._ui.page) {
							utilsEvents.off(self._ui.page, "taufocusborder", self);
						}
					}

					document.removeEventListener("rotarydetent", self, true);
				},

				/**
				 * This method manages events.
				 * @method handleEvent
				 * @param {Event} event
				 * @member ns.widget.core.SectionChanger
				 */
				handleEvent: function (event) {
					this._super(event);

					switch (event.type) {
						case "swipe":
						case "rotarydetent" :
						case "taufocusborder":
							this._change(event);
							break;
						case "webkitTransitionEnd":
						case "mozTransitionEnd":
						case "msTransitionEnd":
						case "oTransitionEnd":
						case "transitionEnd":
							if (event.target === this.scroller) {
								this._endScroll();
							}
							break;
					}
				},

				_notifyChangedSection: function (index) {
					var activeClass = this.options.activeClass,
						sectionLength = this.sections.length,
						i = 0,
						section;

					for (i = 0; i < sectionLength; i++) {
						section = this.sections[i];
						section.classList.remove(activeClass);
						if (i === this.activeIndex) {
							section.classList.add(activeClass);
						}
					}

					this.trigger(eventType.CHANGE, {
						active: index
					});
				},

				/**
				 * Changes the currently active section element.
				 * @method setActiveSection
				 * @param {number} index
				 * @param {number} duration For smooth scrolling,
				 * the duration parameter must be in milliseconds.
				 * @param {number} [direct=false]
				 * @member ns.widget.core.SectionChanger
				 */
				setActiveSection: function (index, duration, direct) {
					var position = this.sectionPositions[index],
						scrollbarDuration = duration,
						oldActiveIndex = this.activeIndex,
						newX = 0,
						newY = 0;

					if (this.orientation === Orientation.HORIZONTAL) {
						newX = this._sectionChangerHalfWidth - calculateCenter(this.orientation, this.sections, position);

					} else {
						newY = this._sectionChangerHalfHeight - calculateCenter(this.orientation, this.sections, position);
					}

					if (this.beforeIndex - index > 1 || this.beforeIndex - index < -1) {
						scrollbarDuration = 0;
					}

					// disable keyboard on latest section
					if (this.activeIndex !== index && this.isKeyboardSupport === true) {
						this.disableFocusableElements(this.sections[this.activeIndex]);
					}

					this.activeIndex = index;
					this.beforeIndex = this.activeIndex;

					if (newX !== this.scrollerOffsetX || newY !== this.scrollerOffsetY) {
						if (direct !== false) {
							this.trigger(eventType.START);
							this.scrolled = true;
						}

						this._translate(newX, newY, duration);
						this._translateScrollbarWithPageIndex(index, scrollbarDuration);
					} else {
						this._endScroll();
					}

					// notify changed section.
					if (this.activeIndex !== oldActiveIndex) {
						this._notifyChangedSection(this.activeIndex);
					}
				},

				/**
				 * Gets the currently active section element's index.
				 * @method getActiveSectionIndex
				 * @return {number}
				 * @member ns.widget.core.SectionChanger
				 */
				getActiveSectionIndex: function () {
					return this.activeIndex;
				},

				_start: function (e) {
					this._super(e);

					this.beforeIndex = this.activeIndex;
				},

				_move: function (event) {
					var self = this,
						changeThreshold = self.options.changeThreshold,
						delta = self.orientation === Orientation.HORIZONTAL ? event.detail.deltaX : event.detail.deltaY,
						oldActiveIndex = self.activeIndex,
						beforeIndex = self.beforeIndex;

					self._super(event);

					if (self.scrolled) {
						if (delta > changeThreshold) {
							self.activeIndex = self._calculateIndex(beforeIndex - 1);
						} else if (delta < -changeThreshold) {
							self.activeIndex = self._calculateIndex(beforeIndex + 1);
						} else {
							self.activeIndex = beforeIndex;
						}

						// notify changed section.
						if (self.activeIndex !== oldActiveIndex) {
							self._notifyChangedSection(self.activeIndex);
						}
					}
				},

				_end: function () {
					var self = this;

					if (self.scrollbar) {
						self.scrollbar.end();
					}

					if (self.enabled && !self.scrollCanceled && self.dragging) {
						// bouncing effect
						if (self.bouncingEffect) {
							self.bouncingEffect.dragEnd();
						}

						self.setActiveSection(self.activeIndex, self.options.animateDuration, false);
						self.dragging = false;
					}
				},

				_change: function (event) {
					var self = this,
						direction = event.detail.direction,
						offset = direction === gesture.Direction.UP ||
							direction === gesture.Direction.LEFT ||
							direction === "CW" ? 1 : -1,
						newIndex;

					if (event.type === "taufocusborder") {
						offset *= -1; // invert direction;
					}

					newIndex = self._calculateIndex(self.beforeIndex + offset);

					if (self.enabled && !self.scrollCanceled) {
						// bouncing effect
						if (self.bouncingEffect) {
							self.bouncingEffect.dragEnd();
						}

						if (self.activeIndex !== newIndex) {
							// disable keyboard on latest section
							if (self.isKeyboardSupport === true && self.sections) {
								self.disableFocusableElements(self.sections[self.activeIndex]);
								self.blurOnActiveElement();
							}
							self.activeIndex = newIndex;
							self._notifyChangedSection(newIndex);
						}

						self.setActiveSection(newIndex, self.options.animateDuration, false);

						self.dragging = false;
					}
				},

				_endScroll: function () {
					var self = this;

					// enable keyboard focus on section at current index
					if (this.isKeyboardSupport === true) {
						self.enableDisabledFocusableElements(self.sections[self.activeIndex]);
					}

					if (!self.enabled || !self.scrolled || self.scrollCanceled) {
						return;
					}

					self._repositionSections();
					self._super();
				},

				_repositionSections: function (init) {
					// if developer set circular option is true, this method used when webkitTransitionEnd event fired
					var self = this,
						sections = self.sections,
						activeIndex = self.activeIndex,
						orientation = self.orientation,
						isHorizontal = orientation === Orientation.HORIZONTAL,
						sectionLength = sections.length,
						curPosition = self.sectionPositions[activeIndex],
						centerPosition = Math.floor(sectionLength / 2),
						circular = self.options.circular,
						centerX = 0,
						centerY = 0,
						i,
						sectionStyle,
						sIdx,
						top,
						left,
						newX,
						newY;

					if (isHorizontal) {
						newX = -(calculateCenter(orientation, sections, (circular ? centerPosition : activeIndex)));
						newY = 0;
					} else {
						newX = 0;
						newY = -(calculateCenter(orientation, sections, (circular ? centerPosition : activeIndex)));
					}

					self._translateScrollbarWithPageIndex(activeIndex);

					if (init || (curPosition === 0 || curPosition === sectionLength - 1)) {
						if (isHorizontal) {
							centerX = self._sectionChangerHalfWidth + newX;
						} else {
							centerY = self._sectionChangerHalfHeight + newY;
						}
						self._translate(centerX, centerY);

						if (circular) {
							for (i = 0; i < sectionLength; i++) {
								sIdx = (sectionLength + activeIndex - centerPosition + i) % sectionLength;
								sectionStyle = sections[sIdx].style;

								self.sectionPositions[sIdx] = i;

								if (isHorizontal) {
									top = 0;
									left = calculateCustomLayout(orientation, sections, i);
								} else {
									top = calculateCustomLayout(orientation, sections, i);
									left = 0;
								}

								sectionStyle.top = top + "px";
								sectionStyle.left = left + "px";
							}
						}
					}
				},

				_calculateIndex: function (newIndex) {
					var sectionLength = this.sections.length;

					if (this.options.circular) {
						newIndex = (sectionLength + newIndex) % sectionLength;
					} else {
						newIndex = newIndex < 0 ? 0 : (newIndex > sectionLength - 1 ? sectionLength - 1 : newIndex);
					}

					return newIndex;
				},

				_clear: function () {
					this._clearTabIndicator();
					this._super();
					this.sectionPositions.length = 0;
				},

				_destroy: function () {
					var element = this.element;

					// clear dimensions set in _build
					element.style.height = null;
					element.style.width = null;
					this._super();
				}
			});

			ns.widget.core.SectionChanger = SectionChanger;

			engine.defineWidget(
				"SectionChanger",
				"[data-role='section-changer'], .ui-section-changer",
				["getActiveSectionIndex", "setActiveSection"],
				SectionChanger
			);
			}(window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns */
/**
 * #Dimmer
 *
 * @example
 *    <div class="ui-dimmer"></dimmer>
 *
 * @since 5.0
 * @class ns.widget.core.Dimmer
 * @extends ns.widget.core.BaseWidget
 */
(function (window, document, ns) {
	"use strict";
				var utilsObject = ns.util.object,

				Dimmer = function () {
					this.options = utilsObject.merge({}, Dimmer.defaults);
					this.bulbMode = false;
					this._observer = null;
					this._observerCallback = this._checkStyleChange.bind(this);
					this._refreshCallback = this.refresh.bind(this);
				},

				DOMUtils = ns.util.DOM,

				defaults = {
					value: 50,
					min: 0,
					max: 100,
					bulb: false,
					options: "30:blue; 60:yellow; 100:red"
				},

				classes = {
					UI_DIMMER: "ui-dimmer",
					UI_DIMMER_BULB: "ui-dimmer-lightbulb",
					UI_DIMMER_BULB_LIGHT: "ui-dimmer-lightbulb-light",
					UI_DIMMER_TEXT: "ui-dimmer-text",
					UI_DIMMER_HIDDEN: "ui-dimmer-hidden"
				},

				BaseWidget = ns.widget.BaseWidget,
				prototype = new BaseWidget();

			Dimmer.prototype = prototype;
			Dimmer.defaults = defaults;
			Dimmer.classes = classes;

			prototype._init = function (element) {
				var self = this,
					observer = new MutationObserver(this._observerCallback);

				if (!element.getAttribute("value")) {
					element.setAttribute("value", self.options.value);
				}

				observer.observe(element, {attributes: true});
				self._observer = observer;

				return element;
			};

			function rebuild(element, bulbMode) {
				var child = document.createElement("div"),
					text = element.querySelector("." + classes.UI_DIMMER_TEXT),
					light = element.querySelector("." + classes.UI_DIMMER_BULB_LIGHT),
					elementCls = element.classList;

				if (child) {
					if (bulbMode) {
						text.classList.add(classes.UI_DIMMER_HIDDEN);
						light.classList.remove(classes.UI_DIMMER_HIDDEN);
					} else {
						text.classList.remove(classes.UI_DIMMER_HIDDEN);
						light.classList.add(classes.UI_DIMMER_HIDDEN);
					}
				}

				if (bulbMode) {
					elementCls.add(classes.UI_DIMMER_BULB);
				} else {
					elementCls.remove(classes.UI_DIMMER_BULB);
				}
			}

			function processBulbMode(element) {
				return DOMUtils.getCSSProperty(element, "background-image", "none", "string") !==
						"none";
			}

			prototype._checkStyleChange = function (mutationsList) {
				var self = this,
					options = self.options,
					refresh = self._refreshCallback;

				mutationsList.forEach(function (mutation) {
					if (mutation.attributeName === "style") {
						options.bulb = processBulbMode(mutation.target);
						refresh();
					}
				});
			};


			prototype._refresh = function () {
				var self = this;

				rebuild(self.element, self.options.bulb);
				self.value(self.options.value);
			};

			prototype._build = function (element) {
				var bulb = processBulbMode(element),
					options = this.options,
					textElement = element.querySelector("." + classes.UI_DIMMER_TEXT),
					light = document.createElement("div");

				if (!textElement) {
					textElement = document.createElement("span");
					textElement.classList.add(classes.UI_DIMMER_TEXT);
					element.appendChild(textElement);
				}
				light.classList.add(classes.UI_DIMMER_BULB_LIGHT);
				element.appendChild(light);

				if (!bulb) {
					bulb = element.classList.contains(classes.UI_DIMMER_BULB);

					if (!options.bulb) {
						options.bulb = bulb;
					}
				}

				rebuild(element, options.bulb);

				this._refreshValue(element);

				return element;
			};

			prototype._destroy = function () {
				this._observer.disconnect();
				this.element.innerHTML = "";
			};

			prototype._refreshValue = function (element) {
				var self = this,
					options = self.options,
					value = options.value,
					min = options.min,
					max = options.max,
					textElement,
					colors = [],
					ranges = [],
					opacity,
					items,
					itemArray,
					lightElement,
					i;

				element = element || self.element;
				textElement = element.querySelector(".ui-dimmer-text");

				if (!options.bulb) {
					value = parseInt(value, 10);
					opacity = value / max;
					element.style.border = "60px solid rgba(0, 151, 216, " + opacity + ")";
					textElement.innerHTML = value + "%";
					return true;
				} else if (options.bulb && options.options) {
					items = options.options.replace(/\s+/g, "").split(";").filter(function (item) {
						return item && item.length > 0;
					});

					items.forEach(function (item) {
						itemArray = item.split(":");
						ranges.push(itemArray[0]);
						colors.push(itemArray[1]);
					});

					lightElement = element.querySelector("." + classes.UI_DIMMER_BULB_LIGHT);
					ranges.unshift(min);

					for (i = 0; i < ranges.length; i++) {
						if (i > 0 && value < ranges[i] && value > ranges[i - 1]) {
							lightElement.style.backgroundColor = colors[i - 1];
							return true;
						}
					}
				}
			}

			prototype._setValue = function (element, value) {
				var self = this,
					options = self.options;

				// Patch for BaseWidget.value
				if (!(element instanceof HTMLElement)) {
					value = element;
					element = self.element;
				}

				if (value < options.min) {
					value = options.min;
				} else if (value > options.max) {
					value = options.max;
				}

				options.value = value;
				element.setAttribute("value", value);

				self._refreshValue();

				return false;
			};

			prototype._setBulb = function (element, value) {
				this.options.bulb = value;

				return true;
			};

			prototype._getValue = function () {
				return parseInt(this.element.getAttribute("value"), 10);
			};

			ns.widget.core.Dimmer = Dimmer;
			ns.engine.defineWidget(
				"Dimmer",
				"." + classes.UI_DIMMER,
				[],
				Dimmer,
				"core"
			);
			}(window, window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Checkbox
 * Checkbox component changes the default browser checkboxes to a form more adapted to the mobile
 * environment.
 *
 * @since 2.4
 * @class ns.widget.core.Checkbox
 * @extends ns.widget.BaseWidget
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Checkbox
 *
 * ## HTML examples
 *
 * ### Basic use
 *      @example template
 *      <input type="checkbox"/>
 *
 * ### Checkbox with label
 *      @example tau-checkbox
 *      <input type="checkbox" name="${5:mycheck}" id="${3:check-test}" checked="${2:checked}"/>\n<label for="${4:check-test}">${1:Checkbox}</label>
 *
 * @class ns.widget.core.Checkbox
 * @component-selector input[type="checkbox"]:not(.ui-slider-switch-input):not([data-role="toggleswitch"]):not(.ui-toggleswitch):not(.ui-switch-input), input.ui-checkbox
 * @component-type standalone-component
 * @component-attachable true
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				keyCodes = BaseKeyboardSupport.KEY_CODES,
				engine = ns.engine,
				eventUtils = ns.event,
				Checkbox = function () {
					this.element = null;

					BaseKeyboardSupport.call(this);
				},
				classes = {
					checkbox: "ui-checkbox",
					focus: "ui-checkbox-focus"
				},
				prototype = new BaseWidget();

			Checkbox.prototype = prototype;

			/**
			 * Build Checkbox widget
			 * @method _build
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Checkbox
			 * @instance
			 */
			prototype._build = function (element) {
				if (element.getAttribute("type") === "checkbox") {
					element.classList.add(classes.checkbox);
				}
				return element;
			};

			/**
			 * Returns the value of checkbox
			 * @method _getValue
			 * @member ns.widget.core.Checkbox
			 * @return {?string}
			 * @protected
			 */
			prototype._getValue = function () {
				return this.element.value;
			};

			/**
			 * Set value to the checkbox
			 * @method _setValue
			 * @param {string} value
			 * @member ns.widget.core.Checkbox
			 * @return {ns.widget.core.Checkbox}
			 * @protected
			 */
			prototype._setValue = function (value) {
				this.element.value = value;
			};

			/**
			 * Set focus on widget
			 * @method _focus
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._focus = function () {
				var self = this,
					element = self.element;

				element.focus();
			};

			/**
			 * Blurs focus from widget
			 * @method _blur
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._blur = function () {
				var self = this,
					element = self.element;

				element.blur();
			};

			/**
			 * Checkbox element focus callback
			 * @method _onFocus
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._onFocus = function () {
				var self = this,
					element = self.element;

				if (ns.getConfig("keyboardSupport", false)) {
					element.classList.add(classes.focus);
				}
			};

			/**
			 * Checkbox element blur callback
			 * @method _onBlur
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._onBlur = function () {
				var self = this,
					element = self.element;

				if (ns.getConfig("keyboardSupport", false)) {
					element.classList.remove(classes.focus);
				}
			};

			/**
			 * Checkbox element keyup callback
			 * @method _onKeyUp
			 * @param {Event} event
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._onKeyUp = function (event) {
				var self = this,
					element = self.element;

				if (event.keyCode === keyCodes.enter) {
					eventUtils.trigger(element, "input");
					element.checked = !element.checked;
					eventUtils.trigger(element, "change");
				}
			}

			/**
			 * Bind events to widgets
			 * @method _bindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._bindEvents = function (element) {
				var self = this;

				self._focusCallbackBound = self._onFocus.bind(self);
				self._blurCallbackBound = self._onBlur.bind(self);
				self._keyupCallbackBound = self._onKeyUp.bind(self);

				element.addEventListener("focus", self._focusCallbackBound, false);
				element.addEventListener("blur", self._blurCallbackBound, false);
				element.addEventListener("keyup", self._keyupCallbackBound, false);
			}

			/**
			 * Unbinds events from widget
			 * @method _unbindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.Checkbox
			 * @protected
			 */
			prototype._unbindEvents = function (element) {
				var self = this;

				element.removeEventListener("focus", self._focusCallbackBound, false);
				element.removeEventListener("blur", self._blurCallbackBound, false);
				element.reEventListener("keyup", self._keyupCallbackBound, false);
			}

			// definition
			ns.widget.core.Checkbox = Checkbox;

			BaseKeyboardSupport.registerActiveSelector("input[type='checkbox'], input.ui-checkbox");

			engine.defineWidget(
				"Checkbox",
				"input[type='checkbox']:not(.ui-slider-switch-input):not([data-role='toggleswitch'])" +
				":not(.ui-toggleswitch):not(.ui-toggle-switch), input.ui-checkbox",
				[],
				Checkbox,
				"core",
				false,
				false,
				HTMLInputElement
			);

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Radio
 *
 *     @example template tau-radio
 *         <input type="radio"/>
 *
 * @class ns.widget.core.Radio
 * @component-selector input[type=radio]
 * @component-type standalone-component
 * @since 2.4
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				KEY_CODES = BaseKeyboardSupport.KEY_CODES,
				Radio = function () {
					BaseKeyboardSupport.call(self);
					this.element = null;
				},
				classes = {
					/**
					 * Standard radio widget
					 * @style ui-radio
					 * @member ns.widget.core.Radio
					 */
					radio: "ui-radio",
					focus: "ui-radio-focus"
				},
				events = ns.event,
				prototype = new BaseWidget();

			Radio.prototype = prototype;

			/**
			 * Build Radio widget
			 * @method _build
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.Radio
			 * @instance
			 */
			prototype._build = function (element) {
				if (element.getAttribute("type") === "radio") {
					element.classList.add(classes.radio);
				}

				return element;
			};

			/**
			 * Focus callback
			 * @protected
			 * @member ns.widget.Radio
			 */
			prototype._onFocus = function () {
				var element = this.element;

				if (ns.getConfig("keyboardSupport", false)) {
					element.focus();
					element.classList.add(classes.focus)
				}
			}

			/**
			 * Blur callback
			 * @protected
			 * @member ns.widget.Radio
			 */
			prototype._onBlur = function () {
				var element = this.element;

				if (ns.getConfig("keyboardSupport", false)) {
					element.blur();
					element.classList.remove(classes.focus)
				}
			}

			/**
			 * KeyUp callback
			 * @protected
			 * @param {Event} event
			 * @member ns.widget.Radio
			 */
			prototype._onKeyUp = function (event) {
				var element = this.element;

				if (ns.getConfig("keyboardSupport", false)) {
					if (event.keyCode === KEY_CODES.enter) {
						element.checked = true;
						events.trigger(element, "change");
					}
				}
			}

			/**
			 * Handle events
			 * @protected
			 * @member ns.widget.Radio
			 */
			prototype.handleEvent = function (event) {
				var self = this;

				switch (event.type) {
					case "focus":
						self._onFocus(event);
						break;
					case "blur":
						self._onBlur(event);
						break;
					case "keyup":
						self._onKeyUp(event);
						break;
				}
			}

			/**
			 * Binds events to a Radio widget
			 * @method _bindEvents
			 * @member ns.widget.core.Radio
			 * @protected
			 */
			prototype._bindEvents = function (element) {
				events.on(element, "focus blur keyup", this, false);
			}

			/**
			 * Unbinds events from a Radio widget
			 * @method _bindEvents
			 * @member ns.widget.core.Radio
			 * @protected
			 */
			prototype._unbindEvents = function (element) {
				events.off(element, "focus blur keyup", this, false);
			};

			/**
			 * Returns the value of radio
			 * @method _getValue
			 * @member ns.widget.Radio
			 * @return {?string}
			 * @protected
			 */
			prototype._getValue = function () {
				return this.element.value;
			};

			/**
			 * Set value to the radio
			 * @method _setValue
			 * @param {string} value
			 * @member ns.widget.Radio
			 * @return {ns.widget.Radio}
			 * @protected
			 */
			prototype._setValue = function (value) {
				this.element.value = value;
			};

			// definition
			ns.widget.core.Radio = Radio;
			engine.defineWidget(
				"Radio",
				"input[type='radio'], input.ui-radio",
				[],
				Radio,
				"core",
				false,
				false,
				HTMLInputElement
			);

			BaseKeyboardSupport.registerActiveSelector("input[type='radio'], input.ui-radio");

			}(window.document, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Panel
 * Panel is component that can have header, content, footer, listview and so on like the page component.
 *
 * Panel has been made that developer can implement to multi panel in one page.
 * But, Panel don't need to implement in one html file. Panel can be existed other html files.
 * PanelChanger controlled Panel lifecycle so If you implement to Panel in PanelChanger, you can experience UX that multi page existed in one page.
 *
 * @class ns.widget.core.Panel
 * @extends ns.widget.BaseWidget
 * @author Hyeoncheol Choi <hc7.choi@samsung.com>
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				events = ns.event,
				classes = {
					/**
					 * Standard panel widget
					 * @style ui-panel
					 * @member ns.widget.core.Panel
					 */
					PANEL: "ui-panel",
					/**
					 * Set panel widget as active
					 * @style ui-panel-active
					 * @member ns.widget.core.Panel
					 */
					ACTIVE_PANEL: "ui-panel-active"
				},
				EVENT_TYPE = {
					BEFORE_CREATE: "panelbeforecreate",
					CREATE: "panelcreate",
					BEFORE_SHOW: "panelbeforeshow",
					SHOW: "panelshow",
					BEFORE_HIDE: "panelbeforehide",
					HIDE: "panelhide",
					CHANGE: "panelchange"
				},
				Panel = function () {
				},
				prototype = new BaseWidget();

			Panel.eventType = EVENT_TYPE;
			Panel.classes = classes;
			Panel.prototype = prototype;

			/**
			 * Build Panel component
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement} Returns built element
			 * @member ns.widget.core.Panel
			 * @protected
			 */
			prototype._build = function (element) {
				var routePanel = ns.router.Router.getInstance().getRoute("panel");

				element.classList.add(classes.PANEL);
				routePanel.setActive(element);

				return element;
			};

			/**
			 * Destroy Panel component
			 * @method _destroy
			 * @param {HTMLElement} element
			 * @return {HTMLElement} Returns built element
			 * @member ns.widget.core.Panel
			 * @protected
			 */
			prototype._destroy = function (element) {
				events.trigger(element, EVENT_TYPE.HIDE);
			};
			// definition
			ns.widget.core.Panel = Panel;

			engine.defineWidget(
				"Panel",
				"[data-role='panel'], .ui-panel",
				[],
				Panel,
				"core"
			);
			}(window.document, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * # Panel Changer
 * Panel changer and panel component provide multi page layout in a page component.
 *
 * PanelChanger managed panel life-cycle and routing. So, If you want to use panel likes page,
 * you should wrap the pages as PanelChanger component.
 *
 * @since 2.4
 * @class ns.widget.core.PanelChanger
 * @component-selector .ui-panel-changer, [data-role]="panel-changer"
 * @extends ns.widget.BaseWidget
 * @author Hyeoncheol Choi <hc7.choi@samsung.com>
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				selectors = ns.util.selectors,
				object = ns.util.object,
				engine = ns.engine,
				page = ns.widget.core.Page,
				panel = ns.widget.core.Panel,
				events = ns.event,
				classes = {
					PANEL_CHANGER: "ui-panel-changer",
					PAGE: page.classes.uiPage,
					PANEL: panel.classes.PANEL,
					ACTIVE_PANEL: panel.classes.ACTIVE_PANEL,
					HEADER: "ui-header",
					FOOTER: "ui-footer",
					PRE_IN: "pre-in",
					IN: "-in",
					OUT: "-out"
				},
				PanelChanger = function () {
					var self = this;

					self._ui = {};
					self.options = {};
					self.eventType = {};
					self._animating = false;
					self._animationClasses = {};
					self.history = [];
				},
				DEFAULT = {
					ANIMATE: "slide",
					STORAGE_NAME: "panelhistory"
				},
				prototype = new BaseWidget();

			PanelChanger.default = DEFAULT;
			PanelChanger.classes = classes;
			PanelChanger.prototype = prototype;

			/**
			 * Configure PanelChanger component
			 * @method _configure
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._configure = function () {
				var self = this;

				object.merge(self.options, {
					animationType: DEFAULT.ANIMATE,
					manageHistory: true
				});
				object.merge(self.eventType, panel.eventType);
			};

			/**
			 * Build PanelChanger component
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._build = function (element) {
				element.classList.add(classes.PANEL_CHANGER);

				return element;
			};

			/**
			 * Init PanelChanger component
			 * @method _init
			 * @param {HTMLElement} element
			 * @return {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._init = function (element) {
				var self = this,
					ui = self._ui;

				ui.page = selectors.getClosestByClass(element, classes.PAGE);
				ui.header = ui.page.querySelector("." + classes.HEADER);
				ui.footer = ui.page.querySelector("." + classes.FOOTER);
				ui.activePanel = ui.page.querySelector("." + classes.ACTIVE_PANEL);
				if (!ui.activePanel) {
					ui.activePanel = ui.page.querySelector("[data-role='panel'], .ui-panel");
					ui.activePanel.classList.add(classes.ACTIVE_PANEL);
				}
				ui.activePanel.style.display = "block";
				self._direction = "forward";
				localStorage[DEFAULT.STORAGE_NAME] = [];
				self.history.push(ui.activePanel.id);
				localStorage[DEFAULT.STORAGE_NAME] = JSON.stringify(self.history);
				self._animationType = self.options.animationType;
				this._initLayout();
				return element;
			};

			/**
			 * InitLayout PanelChanger component
			 * @method _initLayout
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._initLayout = function () {
				var self = this,
					element = self.element,
					ui = self._ui,
					pageOffsetHeight = ui.page ? ui.page.offsetHeight : 0,
					headerOffsetHeight = ui.header ? ui.header.offsetHeight : 0,
					footerOffsetHeight = ui.footer ? ui.footer.offsetHeight : 0;

				element.style.height = pageOffsetHeight - headerOffsetHeight - footerOffsetHeight + "px";
			};
			/**
			 * Bind events on PanelChanger component
			 * @method _bindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._bindEvents = function (element) {
				bindEvents.call(this, element);
			};

			/**
			 * Change panel
			 * @method _changePanel
			 * @param {string} address
			 * @param {string} animationType
			 * @param {string} direction
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._changePanel = function (address, animationType, direction) {
				var self = this,
					request = new XMLHttpRequest(),
					url = address ? address.split(/[#|?]+/)[0] : null;

				if (animationType) {
					self._animationType = animationType;
				}
				self._direction = direction;
				request.responseType = "document";
				request.open("GET", url);
				request.addEventListener("error", self._loadError);
				request.addEventListener("load", function (event) {
					var request = event.target;

					if (request.readyState === 4) {
						if (request.status === 200 || (request.status === 0 && request.responseXML)) {
							self._loadSuccess(address, request.responseXML, direction);
						} else {
							self._loadError();
						}
					}
				});
				request.send();
			};

			/**
			 * AJAX loadsuccess event handler
			 * @method _loadSuccess
			 * @param {string} href address string
			 * @param {XML} xml element
			 * @param {string} direction
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._loadSuccess = function (href, xml, direction) {
				var self = this,
					element = self.element,
					id = href.substring(href.lastIndexOf("#")),
					eventType = self.eventType,
					ui = self._ui,
					panel = id.length > 1 ? element.querySelector(id) : null,
					panelStyle,
					i,
					len,
					transformCacheValue;

				if (!panel && id.length > 1) {
					panel = xml.querySelector(id) || xml.querySelector("[data-role='panel'], .ui-panel");
				}


				if (!panel) {
					ns.warn("Panel is not existed");
					return;
				}

				panelStyle = panel.style;
				panelStyle.display = "block";
				transformCacheValue = panelStyle.transform;
				panelStyle.transform = "translate(-9999px, -9999px)";

				element.appendChild(panel);
				ui.toPanel = panel;
				events.trigger(panel, eventType.BEFORE_CREATE);
				engine.createWidgets(element);
				events.trigger(panel, eventType.CREATE);
				events.trigger(panel, eventType.BEFORE_SHOW);
				events.trigger(ui.activePanel, eventType.BEFORE_HIDE);
				panel.classList.add(classes.PRE_IN);
				panelStyle.display = "none";
				panelStyle.transform = transformCacheValue;

				self.history = JSON.parse(localStorage[DEFAULT.STORAGE_NAME] || "[]");
				if (direction === "forward") {
					self.history.push(panel.getAttribute("id"));
					localStorage[DEFAULT.STORAGE_NAME] = JSON.stringify(self.history);
				} else {
					len = self.history.length - 1;
					for (i = self.history.indexOf(panel.id); i < len; i++) {
						self.history.pop();
					}
					localStorage[DEFAULT.STORAGE_NAME] = JSON.stringify(self.history);
				}

				self._show();
			};

			/**
			 * Show next panel component
			 * @method _show
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._show = function () {
				var self = this,
					toPanel = self._ui.toPanel,
					fromPanel = self._ui.activePanel,
					type = self._animationType,
					animationClasses = self._animationClasses;

				self._animating = true;
				fromPanel.classList.remove(classes.ACTIVE_PANEL);
				toPanel.style.display = "block";
				animationClasses.IN = type + classes.IN;
				animationClasses.OUT = type + classes.OUT;

				fromPanel.classList.add(animationClasses.OUT);
				toPanel.classList.add(animationClasses.IN);

				if (type === "none") {
					self._onAnimationEnd();
				}
			};

			/**
			 * Loaderror event handler
			 * @method _loadError
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._loadError = function () {
				ns.warn("We can't load AJAX")
			};

			/**
			 * Bind events on this component
			 * @method bindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @private
			 */
			function bindEvents(element) {
				var self = this;

				events.on(element, "vclick", self, false);
				events.prefixedFastOn(element, "animationEnd", self, false);
			}

			/**
			 * Bind events on PanelChanger component
			 * @method _bindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._bindEvents = function (element) {
				bindEvents.call(this, element);
			};

			/**
			 * Click event handler
			 * @method _onClick
			 * @param {Event} event
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._onClick = function (event) {
				var self = this,
					link = event.target.tagName.toLowerCase() === "a" ? event.target : selectors.getClosestByTag(event.target, "A"),
					href;

				if (link && !self._animating && !link.getAttribute("data-rel")) {
					href = link.getAttribute("href");
					self._changePanel(href, self.options.animationType, "forward");
					event.preventDefault();
				}
			};

			/**
			 * animationEnd event handler
			 * @method _onAnimationEnd
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._onAnimationEnd = function () {
				var self = this,
					element = self.element,
					toPanel = self._ui.toPanel,
					activePanel = self._ui.activePanel,
					animationClasses = self._animationClasses;

				if (!self._animating) {
					return;
				}
				activePanel.style.display = "none";
				activePanel.classList.remove(animationClasses.OUT);
				toPanel.classList.add(classes.ACTIVE_PANEL);
				toPanel.classList.remove(classes.PRE_IN);
				toPanel.classList.remove(animationClasses.IN);

				events.trigger(activePanel, self.eventType.HIDE);
				events.trigger(toPanel, self.eventType.SHOW);
				events.trigger(element, self.eventType.CHANGE, {
					fromPanel: activePanel,
					toPanel: toPanel,
					direction: self._direction
				});
				self._ui.activePanel = toPanel;
				self._animating = false;
			};

			/**
			 * Bind pageBeforeShow event
			 * @method _onPagebeforeshow
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._onPagebeforeshow = function () {
				var routePanel = ns.router.Router.getInstance().getRoute("panel");

				routePanel.setActive(this._ui._activePanel);
			};

			/**
			 * Unbind events on this component
			 * @method unBindEvents
			 * @param {HTMLElement} element
			 * @member ns.widget.core.PanelChanger
			 * @private
			 */
			function unBindEvents(element) {
				var self = this;

				events.off(element, "vclick", self, false);
				events.prefixedFastOff(element, "animationEnd", self, false);
			}

			/**
			 * handleEvent
			 * @method bindEvents
			 * @param {Event} event
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype.handleEvent = function (event) {
				var self = this;

				switch (event.type) {
					case "vclick":
						self._onClick(event);
						break;
					case "webkitAnimationEnd":
					case "mozAnimationEnd":
					case "msAnimationEnd":
					case "oAnimationEnd":
					case "animationend":
						self._onAnimationEnd(event);
						break;
					case "pagebeforeshow":
						self._onPagebeforeshow(event);
						break;
				}
			};

			/**
			 * Change panel method
			 * @method changePanel
			 * @param {string} address
			 * @param {string} animationType
			 * @param {string} direction
			 * @member ns.widget.core.PanelChanger
			 * @public
			 */
			prototype.changePanel = function (address, animationType, direction) {
				this._changePanel(address, animationType, direction);
			};

			/**
			 * Destroy panel component
			 * @method _destroy
			 * @member ns.widget.core.PanelChanger
			 * @protected
			 */
			prototype._destroy = function () {
				var self = this;

				self._ui = null;
				self.options = null;
				self._eventType = null;
				unBindEvents(self.element);
			};
			// definition
			ns.widget.core.PanelChanger = PanelChanger;

			engine.defineWidget(
				"PanelChanger",
				"[data-role='panel-changer'], .ui-panel-changer",
				["changePanel"],
				PanelChanger,
				"core"
			);
			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	 http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Page Indicator
 * PageIndicator component presents as a dot-typed indicator.
 *
 * @since 2.4
 * @class ns.widget.core.PageIndicator
 * @component-selector [data-role="page-indicator"], .ui-page-indicator
 * @component-type standalone-component
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,

				PageIndicator = function () {
					var self = this;

					self._activeIndex = null;
					self.options = {};
				},
				classes = {
					/**
					 * Standard page indicator widget
					 * @style ui-page-indicator
					 * @member ns.widget.core.PageIndicator
					 */
					indicator: "ui-page-indicator",
					/**
					 * Set dots of page indicator to be active
					 * @style ui-page-indicator-active
					 * @member ns.widget.core.PageIndicator
					 */
					indicatorActive: "ui-page-indicator-active",
					/**
					 * Create items for page indicator widget
					 * @style ui-page-indicator-item
					 * @member ns.widget.core.PageIndicator
					 */
					indicatorItem: "ui-page-indicator-item",
					/**
					 * Set style of page indicator dots to dashed
					 * @style ui-page-indicator-dashed
					 * @member ns.widget.core.PageIndicator
					 */
					indicatorDashed: "ui-page-indicator-dashed",
					/**
					 * Set page indicator to set dots in linear order
					 * @style ui-page-indicator-linear
					 * @member ns.widget.core.PageIndicator
					 */
					linearIndicator: "ui-page-indicator-linear",
					/**
					 * Set page indicator to set dots in circular order
					 * @style ui-page-indicator-circular
					 * @member ns.widget.core.PageIndicator
					 */
					circularIndicator: "ui-page-indicator-circular"
				},
				maxDots = {
					IN_CIRCLE: 60,
					IN_LINEAR: 5
				},
				layoutType = {
					LINEAR: "linear",
					CIRCULAR: "circular"
				},
				DISTANCE_FROM_EDGE = 8,

				prototype = new BaseWidget();

			PageIndicator.classes = classes;

			prototype._configure = function () {
				/**
				 * Options for widget.
				 * @property {Object} options
				 * @property {number} [options.maxPage=null] Maximum number of dots(pages) in indicator.
				 * @property {number} [options.numberOfPages=null] Number of pages to be linked to PageIndicator.
				 * @property {string} [options.layout="linear"] Layout type of page indicator.
				 * @property {number} [options.intervalAngle=6] angle between each dot in page indicator.
				 * @property {string} [options.appearance="dashed"] style of the page indicator "dotted" "dashed"
				 * @member ns.widget.core.PageIndicator
				 */
				this.options = {
					maxPage: null,
					numberOfPages: null,
					layout: "linear",
					intervalAngle: 6,
					appearance: "dashed"
				};
			};
			/**
			 * Build PageIndicator
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._build = function (element) {
				var self = this,
					options = self.options;

				self._createIndicator(element);
				if (options.layout === layoutType.CIRCULAR) {
					self._circularPositioning(element);
				}
				if (options.appearance === "dashed") {
					element.classList.add(classes.indicatorDashed);
				}
				return element;
			};

			/**
			 * Create HTML elements for PageIndicator
			 * @method _createIndicator
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._createIndicator = function (element) {
				var self = this,
					i,
					len,
					maxPage,
					span,
					numberOfPages = self.options.numberOfPages;

				if (numberOfPages === null) {
					ns.error("build error: numberOfPages is null");
					return;
				}

				self.options.layout = self.options.layout.toLowerCase();

				if (self.options.layout === layoutType.CIRCULAR) {
					element.classList.remove(classes.linearIndicator);
					element.classList.add(classes.circularIndicator);
				} else {
					element.classList.remove(classes.circularIndicator);
					element.classList.add(classes.linearIndicator);
				}

				maxPage = self._getMaxPage();

				len = numberOfPages < maxPage ? numberOfPages : maxPage;

				for (i = 0; i < len; i++) {
					span = document.createElement("span");
					span.classList.add(classes.indicatorItem);

					element.appendChild(span);
				}
			};

			/**
			 * Make circular positioned indicator
			 * @method _circularPositioning
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._circularPositioning = function (element) {
				var self = this,
					items = element.children,
					numberOfDots = items.length,
					intervalAngle = self.options.intervalAngle - "0",
					translatePixel,
					style,
					i;

				translatePixel = element.offsetWidth / 2 - DISTANCE_FROM_EDGE;

				for (i = 0; i < numberOfDots; i++) {
					style = "rotate(" + (i * intervalAngle - 90 - (numberOfDots - 1) * intervalAngle * 0.5) + "deg) translate(" +
						translatePixel + "px) ";

					items[i].style.transform = style;
				}

			};

			/**
			 * Return maximum number of dots(pages) in indicator
			 * @method _getMaxPage
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._getMaxPage = function () {
				var self = this,
					options = self.options,
					maxPage;

				if (options.layout === layoutType.CIRCULAR) {
					maxPage = options.maxPage || maxDots.IN_CIRCLE;
				} else {
					maxPage = options.maxPage || maxDots.IN_LINEAR;
				}
				return maxPage;
			};

			/**
			 * Remove contents of HTML elements for PageIndicator
			 * @method _removeIndicator
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._removeIndicator = function (element) {
				element.textContent = "";
			};

			/**
			 * This method sets a dot to active state.
			 * @method setActive
			 * @param {number} position index to be active state.
			 * @member ns.widget.core.PageIndicator
			 */
			prototype.setActive = function (position) {
				var self = this,
					dotIndex = position,
					elPageIndicatorItems = self.element.children,
					maxPage,
					numberOfPages = parseInt(self.options.numberOfPages, 10),
					middle,
					numberOfCentralDotPages = 0,
					indicatorActive = classes.indicatorActive,
					previousActive;

				if (position === null || position === undefined) {
					return;
				}

				self._activeIndex = position;
				maxPage = self._getMaxPage();
				middle = window.parseInt(maxPage / 2, 10);

				if (numberOfPages > maxPage) {
					numberOfCentralDotPages = numberOfPages - maxPage;
				} else if (isNaN(numberOfPages)) {
					ns.error("setActive error: numberOfPages is not a number");
					return;
				} else if (numberOfPages === 0) {
					return;
				}

				previousActive = self.element.querySelector("." + indicatorActive);
				if (previousActive) {
					previousActive.classList.remove(indicatorActive);
				}

				if ((middle < position) && (position <= (middle + numberOfCentralDotPages))) {
					dotIndex = middle;
				} else if (position > (middle + numberOfCentralDotPages)) {
					dotIndex = position - numberOfCentralDotPages;
				}

				elPageIndicatorItems[dotIndex].classList.add(indicatorActive);
			};

			/**
			 * Refresh widget structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._refresh = function () {
				var self = this,
					element = self.element;

				self._removeIndicator(element);
				self._createIndicator(element);
				if (self.options.layout === layoutType.CIRCULAR) {
					self._circularPositioning(element);
				}
			};

			/**
			 * Destroy widget
			 * @method _destroy
			 * @protected
			 * @member ns.widget.core.PageIndicator
			 */
			prototype._destroy = function () {
				this._removeIndicator(this.element);
			};

			PageIndicator.prototype = prototype;

			ns.widget.core.PageIndicator = PageIndicator;

			engine.defineWidget(
				"PageIndicator",
				"[data-role='page-indicator'], .ui-page-indicator",
				["setActive"],
				PageIndicator,
				"core"
			);
			}(window.document, ns));

/*global window, define, ns */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Slider
 * Slider component changes the range-type browser input to sliders.
 *
 * ##Default selectors
 * In default all **INPUT** tags with type equals _range_  and _data-role=slider_ are changed to TAU sliders.
 *
 * ###HTML Examples
 *
 *         @example
 *              <input type="range" name="slider-1" id="slider" value="60" min="0" max="100">
 *
 * ###Manual constructor
 * For manual creation of slider widget you can use constructor of widget
 *
 *         @example
 *              <input id="slider">
 *              <script>
 *                  var sliderElement = document.getElementById("slider"),
 *                      slider;
 *
 *                  slider = tau.widget.Slider(sliderElement);
 *
 *                  // You can make slider component for TizenSlider component name,
 *                  // for example, tau.widget.TizenSlider(sliderElement).
 *                  // But, TizenSlider component name will be deprecated since tizen 2.4
 *                  // because we don't recommend this method.
 *              </script>
 *
 * @since 2.0
 * @class ns.widget.core.Slider
 * @component-selector .ui-slider [data-type]="slider"
 * @extends ns.widget.BaseWidget
 * @author Hyeoncheol Choi <hc7.choi@samsung.com>
 */
(function (document, ns) {
	"use strict";
				/**
			 * @property {Object} Widget Alias for {@link ns.widget.BaseWidget}
			 * @member ns.widget.core.Drawer
			 * @private
			 * @static
			 */
			var BaseWidget = ns.widget.BaseWidget,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				engine = ns.engine,
				selectors = ns.util.selectors,
				utilDOM = ns.util.DOM,
				events = ns.event,
				Gesture = ns.event.gesture,
				utilSelector = ns.util.selectors,
				COLORS = {
					BACKGROUND: "rgba(145, 145, 145, 0.7)",
					ACTIVE: "rgba(61, 185, 204, 1)",
					WARNING_BG: "rgba(201, 133, 133, 1)",
					WARNING: "rgba(255, 25, 25, 1)"
				},
				DEFAULT = {
					HORIZONTAL: "horizontal"
				},
				Slider = function () {
					var self = this;
					/**
					 * Widget options
					 * @property {boolean} [options.type="normal"] Slider type. 'normal', 'center' or 'circle'
					 * @property {string} [options.orientation="horizontal"] Slider orientation. horizontal or vertical
					 * @property {boolean} [options.expand=false] Slider expand mode. true or false
					 **/

					self.options = {
						type: "normal",
						orientation: DEFAULT.HORIZONTAL,
						expand: false,
						warning: false,
						warningLevel: 0,
						disabled: false,
						toggle: ""
					};

					BaseKeyboardSupport.call(self);

					self._ui = {};
				},
				classes = {
					SLIDER: "ui-slider",
					SLIDER_HORIZONTAL: "ui-slider-horizontal",
					SLIDER_VERTICAL: "ui-slider-vertical",
					SLIDER_VALUE: "ui-slider-value",
					SLIDER_HANDLER: "ui-slider-handler",
					SLIDER_HANDLER_EXPAND: "ui-slider-handler-expand",
					SLIDER_CENTER: "ui-slider-center",
					SLIDER_HANDLER_ACTIVE: "ui-slider-handler-active",
					SLIDER_WARNING: "ui-slider-warning",
					SLIDER_DISABLED: "ui-disabled",
					SLIDER_HANDLER_VALUE: "ui-slider-handler-value",
					SLIDER_HANDLER_SMALL: "ui-slider-handler-small",
					SLIDER_FOCUS: "ui-slider-focus"
				},
				prototype = new BaseWidget();

			Slider.prototype = prototype;
			Slider.classes = classes;

			/**
			 * Bind events
			 * @method bindEvents
			 * @param {Object} self
			 * @member ns.widget.core.Slider
			 * @private
			 * @static
			 */
			function bindEvents(self) {
				var ui = self._ui,
					element = ui.barElement,
					toggle = ui.toggle;

				events.enableGesture(
					element,

					new Gesture.Drag({
						orientation: self.options.orientation,
						threshold: 0
					})
				);
				// @todo remove drag handlers
				//events.on(element, "dragstart drag dragend dragcancel", self, false);
				events.on(self.element, "input change touchstart touchend", self, false);
				events.on(self.element, "focus", self, false);
				events.on(self.element, "blur", self, false);
				events.on(self.element, "keyup", self, false);
				if (toggle) {
					events.on(toggle, "change", self);
				}
			}

			/**
			 * unBind events
			 * @method unbindEvents
			 * @param {Object} self
			 * @member ns.widget.core.Slider
			 * @private
			 * @static
			 */
			function unbindEvents(self) {
				var ui = self._ui,
					element = ui.barElement,
					toggle = ui.toggle;

				events.disableGesture(element);
				// @todo remove drag handlers
				//events.off(element, "dragstart drag dragend dragcancel", self, false);
				events.off(self.element, "input change touchstart touchend", self, false);
				if (toggle) {
					events.off(toggle, "change", self);
				}
			}

			/**
			 * Build structure of Slider component
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement} Returns built element
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._build = function (element) {
				var self = this,
					ui = self._ui,
					barElement = document.createElement("div"),
					valueElement = document.createElement("div"),
					handlerElement = document.createElement("div");

				barElement.classList.add(classes.SLIDER);

				valueElement.classList.add(classes.SLIDER_VALUE);
				barElement.appendChild(valueElement);
				handlerElement.classList.add(classes.SLIDER_HANDLER);
				barElement.appendChild(handlerElement);

				element.parentNode.appendChild(barElement);
				ui.valueElement = valueElement;
				ui.handlerElement = handlerElement;
				ui.barElement = barElement;

				element.parentNode.replaceChild(barElement, element);
				barElement.appendChild(element);

				if (self.isKeyboardSupport) {
					self.preventFocusOnElement(element);
					barElement.setAttribute("data-focus-lock", "true");
					barElement.setAttribute("tabindex", "0");
				}

				return element;
			};

			/**
			 * init Slider component
			 * @method _init
			 * @param {HTMLElement} element
			 * @return {HTMLElement} Returns built element
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._init = function (element) {
				var self = this,
					attrMin = parseFloat(element.getAttribute("min")),
					attrMax = parseFloat(element.getAttribute("max")),
					attrValue = parseFloat(element.getAttribute("value")),
					ui = self._ui,
					options = self.options;

				self._min = attrMin ? attrMin : 0;
				self._max = attrMax ? attrMax : 100;
				self._minValue = self._min;
				self._maxValue = self._max;
				self._value = attrValue ? attrValue : parseFloat(self.element.value);
				self._interval = self._max - self._min;
				self._previousValue = self._value;
				self._warningLevel = parseInt(options.warningLevel, 10);
				self._setDisabled(element);
				self._locked = false;

				if (!ui.toggle && options.toggle) {
					ui.toggle = document.querySelector(options.toggle);
				}

				self._initLayout();
				return element;
			};

			prototype._setInputRangeSize = function () {
				var self = this,
					input = self.element,
					barElement = self._ui.barElement,
					options = self.options,
					rectBar = barElement.getBoundingClientRect();

				if (options.orientation === DEFAULT.HORIZONTAL) {
					input.style.width = (rectBar.width + 16) + "px";
					input.style.top = "-12px"; // @todo change this hardcoded size;
					input.style.left = "-8px";
				} else {
					input.style.width = (rectBar.width + 16) + "px";
					input.style.height = rectBar.height + "px";
					input.style.left = "-10px";
				}
			};

			/**
			 * init layout of Slider component
			 * @method _initLayout
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._initLayout = function () {
				var self = this,
					options = self.options,
					ui = self._ui,
					barElement = ui.barElement,
					handlerElement = ui.handlerElement;

				if (options.orientation === DEFAULT.HORIZONTAL) {
					barElement.classList.remove(classes.SLIDER_VERTICAL);
					barElement.classList.add(classes.SLIDER_HORIZONTAL);
				} else {
					barElement.classList.remove(classes.SLIDER_HORIZONTAL);
					barElement.classList.add(classes.SLIDER_VERTICAL);
				}

				options.type === "center" ? barElement.classList.add(classes.SLIDER_CENTER) : barElement.classList.remove(classes.SLIDER_CENTER);

				options.expand ? handlerElement.classList.add(classes.SLIDER_HANDLER_EXPAND) : handlerElement.classList.remove(classes.SLIDER_HANDLER_EXPAND);


				self._barElementWidth = ui.barElement.offsetWidth;
				if (self.options.orientation !== DEFAULT.HORIZONTAL) {
					self._barElementHeight = ui.barElement.offsetHeight;
				}
				self._setValue(self._value);
				self._setSliderColors(self._value);

				self._setInputRangeSize();
			};

			/**
			 * Set value of Slider center mode
			 * @method _setCenterValue
			 * @param {number} value
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._setCenterValue = function (value) {
				var self = this,
					ui = self._ui,
					validValue,
					valueElementValidStyle,
					barElementLength,
					center,
					validStyle,
					inValidStyle;

				if (self.options.orientation === DEFAULT.HORIZONTAL) {
					barElementLength = self._barElementWidth;
					center = barElementLength / 2;
					validValue = barElementLength * (value - self._min) / self._interval;
					validStyle = validValue < center ? "right" : "left";
					inValidStyle = validValue < center ? "left" : "right";
					valueElementValidStyle = "width";
					ui.handlerElement.style["left"] = validValue + "px";
				} else {
					barElementLength = self._barElementHeight;
					center = barElementLength / 2;
					validValue = barElementLength * (value - self._min) / self._interval;
					validStyle = validValue < center ? "top" : "bottom";
					inValidStyle = validValue < center ? "bottom" : "top";
					valueElementValidStyle = "height";
					ui.handlerElement.style["top"] = (barElementLength - validValue) + "px";
				}

				ui.valueElement.style[validStyle] = "50%";
				ui.valueElement.style[inValidStyle] = "initial";

				ui.valueElement.style[valueElementValidStyle] = Math.abs(center - validValue) + "px";
			};

			/**
			 * Set value of Slider normal mode
			 * @method _setNormalValue
			 * @param {number} value
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._setNormalValue = function (value) {
				var self = this,
					ui = self._ui,
					options = self.options,
					barElementLength,
					validValue;

				if (options.orientation === DEFAULT.HORIZONTAL) {
					barElementLength = self._barElementWidth;
					validValue = barElementLength * (value - self._min) / self._interval;
					ui.valueElement.style["width"] = validValue + "px";
					ui.handlerElement.style["left"] = validValue + "px";
				} else {
					barElementLength = self._barElementHeight;
					validValue = barElementLength * (value - self._min) / self._interval;
					ui.valueElement.style["height"] = validValue + "px";
					ui.handlerElement.style["top"] = (barElementLength - validValue) + "px";
				}
			};

			/**
			 * Set value of Slider
			 * @method _setValue
			 * @param {number} value
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._setValue = function (value) {
				var self = this,
					ui = self._ui,
					options = self.options,
					element = self.element,
					toggle = ui.toggle,
					floatValue,
					expendedClasses;

				self._previousValue = self._value;

				if (value < self._min) {
					value = self._min;
				} else if (value > self._max) {
					value = self._max;
				}

				floatValue = parseFloat(value);

				if (options.type === "center") {
					self._setCenterValue(value);
				} else if (options.type === "normal") {
					self._setNormalValue(value);
				}

				self._setHandlerStyle(value);
				self._updateSliderColors(value);

				if (self.options.expand) {
					expendedClasses = classes.SLIDER_HANDLER_VALUE;
					if (floatValue > 99 || floatValue < -10) {
						expendedClasses += " " + classes.SLIDER_HANDLER_SMALL;
					}
					ui.handlerElement.innerHTML = "<span class=" + expendedClasses + ">" + floatValue + "</span>";
				}

				if (self._previousValue !== floatValue) {
					element.setAttribute("value", floatValue);
					element.value = floatValue;
					self._value = floatValue;

					if (toggle) {
						if (floatValue === 0 && !toggle.checked) {
							toggle.checked = true;
						}

						if (floatValue !== 0 && toggle.checked) {
							toggle.checked = false;
						}
					}

					//events.trigger(element, "input");
				}
			};

			prototype._getValue = function () {
				return this._value;
			};

			prototype._getContainer = function () {
				return this._ui.barElement;
			}

			/**
			 * Set background as a gradient
			 * @param {HTMLElement} element
			 * @param {string} orientation
			 * @param {string} reverseOrientation
			 * @param {string} color1
			 * @param {string} level1
			 * @param {string} color2
			 * @param {string} level2
			 * @param {string} currentValue This param is added only because gradients do not work in proper way on Tizen
			 * @private
			 */
			function setBackground(element, orientation, reverseOrientation, color1, level1, color2, level2, currentValue) {
				// gradients on Tizen do not work in proper way, so this condition is workaround
				// if gradients work properly, this should be removed!
				if (parseFloat(currentValue) > parseFloat(level1)) {
					element.style.background = "-webkit-linear-gradient(" + reverseOrientation + "," +
						color1 + " " + level1 + ", " + color2 + " " + level2 + ")";
				} else {
					element.style.background = color1;
				}
			}

			/**
			 * Set warning level for slider
			 * @param {number} value
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._setSliderColors = function (value) {
				var self = this,
					ui = self._ui,
					barElement = ui.barElement,
					sliderValueElement = ui.valueElement,
					orientation,
					reverseOrientation,
					barLength,
					warningLevel,
					level;

				if (self.options.type === "normal" && self.options.warning && value >= self._min && value <= self._max) {
					if (self.options.orientation === DEFAULT.HORIZONTAL) {
						orientation = "right";
						reverseOrientation = "left";
						barLength = self._barElementWidth;
					} else {
						orientation = "top";
						reverseOrientation = "bottom";
						barLength = self._barElementHeight;
					}
					warningLevel = barLength * self._warningLevel / (self._max - self._min) + "px";
					level = barLength * value / (self._max - self._min) + "px";

					// set background for value bar and slider bar
					setBackground(sliderValueElement, orientation, reverseOrientation, COLORS.ACTIVE, warningLevel, COLORS.WARNING, warningLevel, level);
					setBackground(barElement, orientation, reverseOrientation, COLORS.BACKGROUND, warningLevel, COLORS.WARNING_BG, warningLevel,
						parseInt(warningLevel, 10) + 2);
				} else {
					// gradients on Tizen do not work in proper way, so this is workaround
					// if gradients work properly, this should be removed!
					sliderValueElement.style.background = COLORS.ACTIVE;
					barElement.style.background = COLORS.BACKGROUND;
				}
			};

			// gradients on Tizen do not work in proper way, so this is workaround
			// if gradients work properly, this should be removed!
			prototype._updateSliderColors = function (value) {
				this._setSliderColors(value);
			};

			/**
			 * Set style for handler
			 * @param {number} value
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._setHandlerStyle = function (value) {
				var self = this;

				if (self.options.warning) {
					if (value >= self._warningLevel) {
						self._ui.handlerElement.classList.add(classes.SLIDER_WARNING);
					} else {
						self._ui.handlerElement.classList.remove(classes.SLIDER_WARNING);
					}
				}
			};

			prototype._setDisabled = function (element) {
				var self = this,
					options = self.options;

				if (options.disabled === true || element.disabled) {
					self._disable(element);
				} else {
					self._enable(element);
				}
			};

			prototype._enable = function (element) {
				if (element) {
					this.options.disabled = false;
					if (this._ui.barElement) {
						this._ui.barElement.classList.remove(classes.SLIDER_DISABLED);
					}
				}
			};

			prototype._disable = function (element) {
				if (element) {
					this.options.disabled = true;
					if (this._ui.barElement) {
						this._ui.barElement.classList.add(classes.SLIDER_DISABLED);
					}
				}
			};

			/**
			 * Bind events to Slider
			 * @method _bindEvents
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._bindEvents = function () {
				bindEvents(this);
			};

			/**
			 * Bind event handlers
			 * @method handleEvent
			 * @param {Event} event
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype.handleEvent = function (event) {
				var self = this,
					toggle = self._ui.toggle,
					eventType = event.type;

				if (eventType === "change" && toggle && toggle === event.target) {
					self._handleToggle(event);
				} else if (!this.options.disabled) {
					switch (eventType) {
						case "dragstart":
							self._onDragstart(event);
							break;
						case "dragend":
						case "dragcancel":
							self._onDragend(event);
							break;
						case "drag":
							self._onDrag(event);
							break;
						case "input" :
						case "change" :
							self._setValue(self.element.value);
							break;
						case "touchstart":
							self._onTouchStart(event);
							break;
						case "touchend":
							self._onTouchEnd(event);
							break;
						// case "focus":
						// 	self._onFocus(event);
						// 	break;
						// case "blur":
						// 	self._onBlur(event);
						// 	break;
						case "keyup":
							self._onKeyUp(event);
							break;
					}
				}
			};

			prototype._handleToggle = function (event) {
				var self = this,
					options = self.options,
					element = self.element,
					target = event.target,
					mute = target.checked,
					value;

				if (mute && self.value() > 0) {
					utilDOM.setNSData(target, "slider-value", self.value());
					self.value(self._minValue);
					options.disabled = true;
					self._setDisabled(element);
				} else if (self.value() === 0) {
					value = parseFloat(utilDOM.getNSData(target, "slider-value")) || 0
					options.disabled = false;
					self._setDisabled(element);
					self.value(value);
				}
			};

			/**
			 * Drag event handler
			 * @method _onDrag
			 * @param {Event} event
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._onDrag = function (event) {
				var self = this,
					ui = self._ui,
					validPosition,
					value;

				if (self._active) {
					validPosition = self.options.orientation === DEFAULT.HORIZONTAL ?
						event.detail.estimatedX - ui.barElement.offsetLeft :
						self._barElementHeight -
					(event.detail.estimatedY - utilDOM.getElementOffset(ui.barElement).top + selectors.getScrollableParent(self.element).scrollTop),

					value = self.options.orientation === DEFAULT.HORIZONTAL ?
						self._interval * validPosition / self._barElementWidth :
						self._interval * validPosition / self._barElementHeight;

					value += self._min;
					self._setValue(value);
				}
			};

			/**
			 * DragStart event handler
			 * @method _onDragstart
			 * @param {Event} event
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._onDragstart = function (event) {
				var self = this,
					ui = self._ui,
					validPosition = self.options.orientation === DEFAULT.HORIZONTAL ?
						event.detail.estimatedX - ui.barElement.offsetLeft :
						self._barElementHeight -
					(event.detail.estimatedY - utilDOM.getElementOffset(ui.barElement).top + selectors.getScrollableParent(self.element).scrollTop),
					value = self.options.orientation === DEFAULT.HORIZONTAL ?
						self._interval * validPosition / self._barElementWidth :
						self._interval * validPosition / self._barElementHeight;

				ui.handlerElement.classList.add(classes.SLIDER_HANDLER_ACTIVE);
				value += self._min;
				self._setValue(value);
				self._active = true;
			};

			/**
			 * DragEnd event handler
			 * @method _onDragend
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._onDragend = function () {
				var self = this,
					ui = self._ui;

				ui.handlerElement.classList.remove(classes.SLIDER_HANDLER_ACTIVE);
				self._active = false;
				if (self._previousValue !== self.element.value) {
					events.trigger(self.element, "change");
				}
				self._previousValue = self.element.value;
			};

			prototype._onTouchStart = function () {
				this._ui.handlerElement.classList.add(classes.SLIDER_HANDLER_ACTIVE);
			};

			prototype._onTouchEnd = function () {
				this._ui.handlerElement.classList.remove(classes.SLIDER_HANDLER_ACTIVE);
			};

			// prototype._onFocus = function () {
			// 	var container = this._ui.barElement.parentElement;

			// 	container && container.classList.add("ui-listview-item-focus");
			// };

			// prototype._onBlur = function () {
			// 	var container = this._ui.barElement.parentElement;

			// 	container && container.classList.remove("ui-listview-item-focus");
			// };

			prototype._decreaseValue = function () {
				var self = this;

				self._setValue(self._value - (parseFloat(self.element.step) || 1));
			};

			prototype._increaseValue = function () {
				var self = this;

				self._setValue(self._value + (parseFloat(self.element.step) || 1));
			};

			// prototype._lockKeyboard = function () {
			// 	var self = this,
			// 		listview = utilSelector.getClosestBySelector(self.element, ".ui-listview"),
			// 		listviewWidget = engine.getBinding(listview, "Listview");

			// 	self._locked = true;
			// 	listviewWidget.saveKeyboardSupport();
			// 	listviewWidget.disableKeyboardSupport();
			// 	self.enableKeyboardSupport();
			// 	self._ui.barElement.classList.add(classes.SLIDER_FOCUS);
			// };

			// prototype._unlockKeyboard = function () {
			// 	var self = this,
			// 		listview = utilSelector.getClosestBySelector(self.element, ".ui-listview"),
			// 		listviewWidget = engine.getBinding(listview, "Listview");

			// 	self._locked = false;
			// 	listviewWidget.restoreKeyboardSupport();
			// 	listviewWidget.enableKeyboardSupport();
			// 	self.disableKeyboardSupport();
			// 	self._ui.barElement.classList.remove(classes.SLIDER_FOCUS);
			// };

			prototype._onKeyUp = function (event) {
				var self = this,
					KEY_CODES = BaseKeyboardSupport.KEY_CODES;

				if (self._locked) {
					switch (event.keyCode) {
						// case KEY_CODES.escape :
						// case KEY_CODES.enter :
						// 	self._unlockKeyboard();
						// 	break;
						case KEY_CODES.left :
							self._decreaseValue();
							break;
						case KEY_CODES.right :
							self._increaseValue();
							break;
					}
				} else {
					// switch (event.keyCode) {
					// 	case KEY_CODES.enter :
					// 		self._lockKeyboard();
					// 		break;
					// }
				}
			};

			/**
			 * Refresh to Slider component
			 * @method refresh
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype.refresh = function () {
				this._setDisabled(this.element);
				this._initLayout();
			};

			/**
			 * Destroy Slider component
			 * @method _destroy
			 * @member ns.widget.core.Slider
			 * @protected
			 */
			prototype._destroy = function () {
				var self = this,
					barElement = self._ui.barElement;

				unbindEvents(self);
				if (barElement.parentNode) {
					barElement.parentNode.removeChild(barElement);
				}
				self._ui = null;
				self._options = null;
			};

			ns.widget.core.Slider = Slider;
			engine.defineWidget(
				"Slider",
				"input[data-role='slider'], input[type='range'], input[data-type='range']",
				[
					"value"
				],
				Slider,
				"core"
			);

			BaseKeyboardSupport.registerActiveSelector("input[data-role='slider'], input[type='range'], input[data-type='range'], .ui-slider-handler");

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true */
/**
 * #Progress namespace
 * Namespace with progress.
 * @author Heeju Joo <heeju.joo@samsung.com>
 */
(function (document, ns) {
	"use strict";
				ns.widget.core.progress = ns.widget.core.progress || {};
			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #type namespace
 * Namespace with types of Progress
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @class ns.widget.core.progress.type
 * @internal
 */
(function (window, ns) {
	"use strict";
				/** @namespace ns.widget.core */
			ns.widget.core.progress.type = ns.widget.core.progress.type || {};
			}(window, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Progress type Interface
 * Interface for type of progress
 * @internal
 * @class ns.widget.core.progress.type.interface
 */
(function (document, ns) {
	"use strict";
	
			ns.widget.core.progress.type.interface = {
				/**
				 * Init DOM for progress
				 * @method build
				 * @static
				 * @member ns.widget.core.progress.type.interface
				 */
				build: function (/*Progress*/) {
				},
				/**
				 * Init Style for progress
				 * @method init
				 * @static
				 * @member ns.widget.core.progress.type.interface
				 */
				init: function (/*Progress*/) {
				},
				/**
				 * Init Style for progress
				 * @method refresh
				 * @static
				 * @member ns.widget.core.progress.type.interface
				 */
				refresh: function (/*Progress*/) {

				},
				/**
				 * Init Style for progress
				 * @method changeValue
				 * @static
				 * @member ns.widget.core.progress.type.interface
				 */
				changeValue: function (/*Progress*/) {

				},
				/**
				 * Init Style for progress
				 * @method destroy
				 * @static
				 * @member ns.widget.core.progress.type.interface
				 */
				destroy: function (/*Progress*/) {

				}
			};
			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Activity Bar Type
 * activityBar type support for Progress widget.
 * @internal
 * @class ns.widget.core.progress.type.activitybar
 * @extends ns.widget.core.progress.type.interface
 */
(function (document, ns) {
	"use strict";
				var utilsObject = ns.util.object,
				type = ns.widget.core.progress.type,
				typeInterface = type.interface,
				classes = {
					uiActivitybar: "ui-activity-bar",
					uiActivitybarActivity: "ui-activity-bar-activity"
				};

			function paintProgressStyle(progress) {
				var ui = progress._ui,
					options = progress.options,
					percentValue = (options.value * 100) / (options.max - options.min);

				ui.activityBarElement.style.width = percentValue + "%";
			}

			type.activitybar = utilsObject.merge({}, typeInterface, {
				build: function (progress, element) {
					var ui = {},
						activityElement = element,
						activityBarElement;

					activityBarElement = document.createElement("div");

					activityElement.classList.add(classes.uiActivitybar);
					activityBarElement.classList.add(classes.uiActivitybarActivity);

					activityElement.appendChild(activityBarElement);

					ui.activityBarElement = activityBarElement;

					progress._ui = ui;

					return activityElement;
				},

				init: function (progress, element) {
					var ui = progress._ui,
						activityElement = element;

					ui.activityBarElement = ui.activityBarElement || activityElement.querySelector("." + classes.uiActivitybarActivity);

					paintProgressStyle(progress);
				},

				refresh: function (progress) {
					paintProgressStyle(progress);
				},

				changeValue: function (progress) {
					paintProgressStyle(progress);
				}
			});

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #activityCircle Type
 * activityCircle type support for Progress widget.
 * @internal
 * @class ns.widget.core.progress.type.activitycircle
 * @extends ns.widget.core.progress.type.interface
 */
(function (document, ns) {
	"use strict";
				var utilsObject = ns.util.object,
				type = ns.widget.core.progress.type,
				typeInterface = type.interface,
				classes = {
					uiActivityCircle: "ui-activity-circle",
					uiActivityCircleSmall: "ui-activity-circle-small",
					uiActivityCircleMedium: "ui-activity-circle-medium",
					uiActivityCircleLarge: "ui-activity-circle-large",
					uiActivityCircle1: "ui-activity-circle1",
					uiActivityCircle2: "ui-activity-circle2",
					uiActivityCircle3: "ui-activity-circle3",
					uiCircle1Svg: "ui-circle1-svg",
					uiCircle2Svg: "ui-circle2-svg",
					uiCircle3Svg: "ui-circle3-svg",
					uiCircle1In: "ui-circle1-in",
					uiCircle2In: "ui-circle2-in",
					uiCircle3In: "ui-circle3-in"
				};

			function setSVGInnerAttribute(ui) {
				ui.animationCircle1SVGElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
				ui.animationCircle2SVGElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
				ui.animationCircle3SVGElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
				ui.animationCircle1SVGElement.setAttribute("viewBox", "0 0 360 360");
				ui.animationCircle2SVGElement.setAttribute("viewBox", "0 0 360 360");
				ui.animationCircle3SVGElement.setAttribute("viewBox", "0 0 360 360");
				ui.animationCircle1SVGInnerElement.setAttribute("cx", "334");
				ui.animationCircle1SVGInnerElement.setAttribute("cy", "180");
				ui.animationCircle1SVGInnerElement.setAttribute("r", "15");
				ui.animationCircle2SVGInnerElement.setAttribute("cx", "180");
				ui.animationCircle2SVGInnerElement.setAttribute("cy", "180");
				ui.animationCircle2SVGInnerElement.setAttribute("r", "154.333");
				ui.animationCircle3SVGInnerElement.setAttribute("cx", "180");
				ui.animationCircle3SVGInnerElement.setAttribute("cy", "180");
				ui.animationCircle3SVGInnerElement.setAttribute("r", "154.333");

			}

			function resetActivityCircleClasses(element, optionSize) {
				if (!element.classList.contains(classes.uiActivityCircle)) {
					element.classList.add(classes.uiActivityCircle);
				}

				element.classList.remove(classes.uiActivityCircleSmall);
				element.classList.remove(classes.uiActivityCircleMedium);
				element.classList.remove(classes.uiActivityCircleLarge);

				switch (optionSize) {
					case "small":
						element.classList.add(classes.uiActivityCircleSmall);
						break;
					case "medium":
						element.classList.add(classes.uiActivityCircleMedium);
						break;
					case "large":
						element.classList.add(classes.uiActivityCircleLarge);
						break;
					default:
						element.classList.add(classes.uiActivityCircleMedium);
				}
			}

			type.activitycircle = utilsObject.merge({}, typeInterface, {
				build: function (progress, element) {
					var ui = {},
						activityElement = element,
						animationCircle1Element,
						animationCircle2Element,
						animationCircle3Element,
						animationCircle1SVGElement,
						animationCircle2SVGElement,
						animationCircle3SVGElement,
						animationCircle1SVGInnerElement,
						animationCircle2SVGInnerElement,
						animationCircle3SVGInnerElement,
						svgNS = "http://www.w3.org/2000/svg",
						svgName = "svg",
						svgInnerName = "circle";

					animationCircle1Element = document.createElement("div");
					animationCircle2Element = document.createElement("div");
					animationCircle3Element = document.createElement("div");
					animationCircle1Element.classList.add(classes.uiActivityCircle1);
					animationCircle2Element.classList.add(classes.uiActivityCircle2);
					animationCircle3Element.classList.add(classes.uiActivityCircle3);

					/* CreateSVG Element for animationCircle1 */
					animationCircle1SVGElement = document.createElementNS(svgNS, svgName);
					animationCircle1SVGElement.setAttribute("class", classes.uiCircle1Svg);
					animationCircle1SVGInnerElement = document.createElementNS(svgNS, svgInnerName);
					animationCircle1SVGInnerElement.setAttribute("class", classes.uiCircle1In);
					animationCircle1SVGElement.appendChild(animationCircle1SVGInnerElement);

					/* CreateSVG Element for animationCircle2 */
					animationCircle2SVGElement = document.createElementNS(svgNS, svgName);
					animationCircle2SVGElement.setAttribute("class", classes.uiCircle2Svg);
					animationCircle2SVGInnerElement = document.createElementNS(svgNS, svgInnerName);
					animationCircle2SVGInnerElement.setAttribute("class", classes.uiCircle2In);
					animationCircle2SVGElement.appendChild(animationCircle2SVGInnerElement);

					/* CreateSVG Element for animationCircle3 */
					animationCircle3SVGElement = document.createElementNS(svgNS, svgName);
					animationCircle3SVGElement.setAttribute("class", classes.uiCircle3Svg);
					animationCircle3SVGInnerElement = document.createElementNS(svgNS, svgInnerName);
					animationCircle3SVGInnerElement.setAttribute("class", classes.uiCircle3In);
					animationCircle3SVGElement.appendChild(animationCircle3SVGInnerElement);

					animationCircle1Element.appendChild(animationCircle1SVGElement);
					animationCircle2Element.appendChild(animationCircle2SVGElement);
					animationCircle3Element.appendChild(animationCircle3SVGElement);

					activityElement.appendChild(animationCircle1Element);
					activityElement.appendChild(animationCircle2Element);
					activityElement.appendChild(animationCircle3Element);

					ui.animationCircle1Element = animationCircle1Element;
					ui.animationCircle2Element = animationCircle2Element;
					ui.animationCircle3Element = animationCircle3Element;
					ui.animationCircle1SVGElement = animationCircle1SVGElement;
					ui.animationCircle2SVGElement = animationCircle2SVGElement;
					ui.animationCircle3SVGElement = animationCircle3SVGElement;
					ui.animationCircle1SVGInnerElement = animationCircle1SVGInnerElement;
					ui.animationCircle2SVGInnerElement = animationCircle2SVGInnerElement;
					ui.animationCircle3SVGInnerElement = animationCircle3SVGInnerElement;

					progress._ui = ui;
					return element;
				},

				init: function (progress, element) {
					var options = progress.options,
						activityCircleSize = options.size;

					setSVGInnerAttribute(progress._ui);
					resetActivityCircleClasses(element, activityCircleSize);
				},
				refresh: function (progress) {
					var element = progress.element,
						activityCircleSize = progress.options.size;

					resetActivityCircleClasses(element, activityCircleSize);

				}
			});

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #progressBar Type
 * progressBar type support for Progress widget.
 * @internal
 * @class ns.widget.core.progress.type.progressbar
 * @extends ns.widget.core.progress.type.interface
 */
(function (document, ns) {
	"use strict";
				var utilsObject = ns.util.object,
				type = ns.widget.core.progress.type,
				typeInterface = type.interface,

				classes = {
					uiProgressbar: "ui-progress-bar",
					uiProgressbarValue: "ui-progress-bar-value",
					uiProgressbarDecorator: "ui-progress-bar-decorator"
				},

				createAnimationFrame = function (duration, call1, call2, call3) {
					return [
						{
							start: 0,
							end: 800,
							callback: function (t, end) {
								call1.call(this, t, end);
							}
						},
						{
							start: 800,
							end: 1350,
							callback: function (t, end) {
								call2.call(this, t, end);
							}
						},
						{
							start: 1550,
							end: 1850,
							callback: function (t, end) {
								call3.call(this, t, end);
							}
						}
					];
				};

			function setAriaValues(element, options) {
				//set Aria value
				element.setAttribute("aria-valuenow", options.value);
				element.setAttribute("aria-valuemin", options.min);
				element.setAttribute("aria-valuemax", options.max);
			}

			function paintProgressStyle(progress) {
				var ui = progress._ui,
					options = progress.options,
					element = progress.element,
					elementHeightPercentValue = (element.offsetHeight * 100) / element.offsetWidth,
					percentValue = (options.value * 100) / (options.max - options.min);

				ui.progressBarValueElement.style.width = percentValue + "%";
				ui.progressBarDecoratorElement.style.width = elementHeightPercentValue + "%";
				ui.progressBarDecoratorElement.style.left = (percentValue - elementHeightPercentValue) + "%";
			}

			type.bar = utilsObject.merge({}, typeInterface, {
				build: function (progress, element) {
					var ui = {},
						progressBarValueElement,
						progressBarDecoratorElement;

					element.classList.add(classes.uiProgressbar);

					progressBarValueElement = document.createElement("div");
					progressBarValueElement.classList.add(classes.uiProgressbarValue);
					progressBarDecoratorElement = document.createElement("div");
					progressBarDecoratorElement.classList.add(classes.uiProgressbarDecorator);

					element.appendChild(progressBarValueElement);
					element.appendChild(progressBarDecoratorElement);

					ui.progressBarValueElement = progressBarValueElement;
					ui.progressBarDecoratorElement = progressBarDecoratorElement;

					progress._ui = ui;
					return element;
				},

				init: function (progress, element) {
					var ui = progress._ui,
						options = progress.options;

					ui.progressBarValueElement = ui.progressBarValueElement || element.querySelector("." + classes.uiProgressbarValue);
					ui.progressBarDecoratorElement = ui.progressBarDecoratorElement || element.querySelector("." + classes.progressBarDecoratorElement);

					ui.progressBarDecoratorElement.style.left = 0;

					setAriaValues(element, options);
					paintProgressStyle(progress);
				},

				refresh: function (progress) {
					setAriaValues(progress.element, progress.options);
					paintProgressStyle(progress);
				},

				changeValue: function (progress, oldValue, newValue) {
					var duration = 1850,
						element = progress.element,
						valueElement = progress._ui.progressBarValueElement,
						decoElement = progress._ui.progressBarDecoratorElement,
						decoElementOldLeft = parseFloat(decoElement.style.left),
						decoElementOldWidth = (decoElement.offsetWidth * 100) / element.offsetWidth,
						elementHeightPercentValue = (element.offsetHeight * 100) / element.offsetWidth,
						oldPercentValue = (oldValue * 100) / (progress.options.max - progress.options.min),
						newPercentValue = (newValue * 100) / (progress.options.max - progress.options.min),
						animationFrames;

					if (!progress._isAnimating) {
						decoElement.style.opacity = 1;
						animationFrames = createAnimationFrame(duration, function (t, end) {
							valueElement.style.width = oldPercentValue + ((newPercentValue - oldPercentValue) * t / end) + "%";
							if (newValue > oldValue) {
								decoElement.style.width = decoElementOldWidth + ((newPercentValue - oldPercentValue) * t / end) + "%";
							} else {
								decoElement.style.width = decoElementOldWidth + ((oldPercentValue - newPercentValue) * t / end) + "%";
								decoElement.style.left = oldPercentValue - parseFloat(decoElement.style.width) + "%";
								decoElementOldLeft = parseFloat(decoElement.style.left);
							}
						}, function (t, end) {
							if (newValue > oldValue) {
								decoElement.style.left = decoElementOldLeft + ((newPercentValue - decoElementOldLeft - elementHeightPercentValue) * t / end) + "%";
								decoElement.style.width = (decoElementOldWidth + newPercentValue - oldPercentValue) - ((decoElementOldWidth + newPercentValue - oldPercentValue - elementHeightPercentValue) * t / end) + "%";
							} else {
								decoElement.style.width = (decoElementOldWidth + (oldPercentValue - newPercentValue)) - ((oldPercentValue - newPercentValue) * t / end) + "%";
							}
						}, function (t, end) {
							if (newValue >= progress.options.max) {
								decoElement.style.opacity = 1 - t / end;
							}
						});
						progress._animate(duration, function (t) {
							animationFrames.forEach(function (animation) {
								if (t >= animation.start && t <= animation.end) {
									animation.callback(t - animation.start, animation.end - animation.start);
								} else if (t > animation.end) {
									animation.callback(1, 1);
								}
							});
						}, function () {
							if (progress.options.value !== newValue) {
								type.bar.changeValue(progress, newValue, progress.options.value);
							}
						});
					}
				}
			});
			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #progressCircle Type
 * progressCircle type support for Progress widget.
 * @internal
 * @class ns.widget.core.progress.type.progresscircle
 * @extends ns.widget.core.progress.type.interface
 */
(function (document, ns) {
	"use strict";
				var utilsObject = ns.util.object,
				doms = ns.util.DOM,
				type = ns.widget.core.progress.type,
				typeInterface = type.interface,
				classes = {
					uiProgressCircle: "ui-progress-circle",
					uiProgressCircleBg: "ui-progress-circle-bg",
					uiProgressCircleValue: "ui-progress-circle-value",
					uiProgressCircleValueLeft: "ui-progress-circle-value-left",
					uiProgressCircleValueRight: "ui-progress-circle-value-right",
					uiProgressCircleHalf: "ui-progress-circle-half"
				};

			/* make widget refresh with new value */
			function paintProgressCircle(self) {
				var options = self.options,
					percentValue = (options.value * 100) / (options.max - options.min),
					rotateValue,
					ui = self._ui;

				if (percentValue >= 50) {
					ui.progressValue.classList.add(classes.uiProgressCircleHalf);
				} else {
					ui.progressValue.classList.remove(classes.uiProgressCircleHalf);
				}

				rotateValue = 360 * (percentValue / 100);

				ui.progressValueLeft.style.webkitTransform = "rotate3d(0.0, 0.0, 1.0, " + rotateValue + "deg)";
			}

			function setProgressBarSize(self) {
				var progressSize = self.options.size,
					sizeToNumber = parseFloat(progressSize),
					ui = self._ui;

				if (!isNaN(sizeToNumber)) {
					ui.progressContainer.style.fontSize = progressSize + "px";
					ui.progressContainer.style.width = progressSize + "px";
					ui.progressContainer.style.height = progressSize + "px";
				} else {
					switch (progressSize) {
						case "full":
						case "large":
						case "medium":
						case "small":
							ui.progressContainer.classList.add("ui-progress-circle-" + progressSize);
							break;
					}
					ui.progressContainer.style.fontSize = doms.getCSSProperty(ui.progressContainer, "width", 0, "float") + "px";
				}
			}

			function resetDOM(ui) {
				ui.progressValue.classList.remove(classes.uiProgressbarHalf);
				ui.progressValueLeft.style.webkitTransform = "";
			}

			type.circle = utilsObject.merge({}, typeInterface, {
				build: function (progress, element) {
					var ui = {},
						progressElement = element,
						progresscircleBg,
						progresscircleValue,
						progresscircleValueLeft,
						progresscircleValueRight;

					ui.progressContainer = progressElement;
					ui.progressValueBg = progresscircleBg = document.createElement("div");
					ui.progressValue = progresscircleValue = document.createElement("div");
					ui.progressValueLeft = progresscircleValueLeft = document.createElement("div");
					ui.progressValueRight = progresscircleValueRight = document.createElement("div");

					// set classNames of progresscircle DOMs.
					progressElement.className = classes.uiProgressCircle;
					progresscircleBg.className = classes.uiProgressCircleBg;
					progresscircleValue.className = classes.uiProgressCircleValue;
					progresscircleValueLeft.className = classes.uiProgressCircleValueLeft;
					progresscircleValueRight.className = classes.uiProgressCircleValueRight;

					progresscircleValue.appendChild(progresscircleValueLeft);
					progresscircleValue.appendChild(progresscircleValueRight);
					progressElement.appendChild(progresscircleValue);
					progressElement.appendChild(progresscircleBg);

					progress._ui = ui;
					return element;
				},

				init: function (progress, element) {
					var ui = progress._ui;

					ui.progressContainer = ui.progressContainer || element;
					ui.progressValueBg = ui.progressValueBg || element.querySelector("." + classes.uiProgressCircleBg);
					ui.progressValue = ui.progressValue || element.querySelector("." + classes.uiProgressCircleValue);
					ui.progressValueLeft = ui.progressValueLeft || element.querySelector("." + classes.uiProgressCircleValueLeft);
					ui.progressValueRight = ui.progressValueRight || element.querySelector("." + classes.uiProgressCircleValueRight);

					setProgressBarSize(progress);
					paintProgressCircle(progress);
				},

				refresh: function (progress) {
					resetDOM(progress._ui);
					setProgressBarSize(progress);
					paintProgressCircle(progress);
				},

				changeValue: function (progress) {
					paintProgressCircle(progress);
				}
			});

			}(window.document, ns));

/*global window, define, ns */
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Progress
 * Progress component shows that an operation is in progress.
 *
 * #Crete widget
 *
 * Shows a control that indicates the progress percentage of an on-going operation by circular shape.
 *
 *     @example template tau-progress
 *         <progress class="ui-circle-progress" max="${1:100}" value="${2:20}"></progress>
 *
 *
 * ##Set and Get the value
 * You can set or get the value with the value() method
 *
 * @since 2.0
 * @class ns.widget.core.progress.Progress
 * @component-selector .ui-circle-progress, .ui-progress
 * @extends ns.widget.BaseWidget
 * @author Heeju Joo <heeju.joo@samsung.com>
 */
(function (document, ns) {
	"use strict";
	
			var BaseWidget = ns.widget.BaseWidget,
				events = ns.event,
				engine = ns.engine,
				util = ns.util,
				selectors = ns.util.selectors,
				utilsObject = ns.util.object,
				Page = ns.widget.core.Page,
				eventType = {
					/**
					 * Event is triggered when value of widget is changing.
					 * @event change
					 * @member ns.widget.mobile.ProgressBar
					 */
					CHANGE: "change"
				},

				progressType = {
					PROGRESS_BAR: "bar",
					PROGRESS_CIRCLE: "circle",
					ACTIVITY_BAR: "activitybar",
					ACTIVITY_CIRCLE: "activitycircle"
				},

				circleSize = {
					SMALL: "small",
					MEDIUM: "medium",
					LARGE: "large",
					FULL: "full"
				},
				/**
				 * Progress constructor
				 * @method Progress
				 */
				Progress = function () {
					var self = this;

					self.options = utilsObject.merge({}, Progress.defaults);
					self._ui = {};
					self._type = null;
					self._progress = null;
					self._isAnimating = false;
					self._callbacks = {};
				},
				/**
				 * Dictionary object containing commonly used widget classes
				 * @property {Object} classes
				 * @member ns.widget.core.progress.Progress
				 * @private
				 * @static
				 * @readonly
				 */
				classes = {
					uiProgress: "ui-progress"
				},
				defaults = {
					type: progressType.PROGRESS_BAR,
					size: circleSize.MEDIUM,
					value: 100,
					min: 0,
					max: 100
				},

				prototype = new BaseWidget();

			Progress.prototype = prototype;
			Progress.classes = classes;
			Progress.events = eventType;
			Progress.defaults = defaults;

			/**
			 * Build structure of Progress component
			 * @method _build
			 * @param {HTMLElement} element
			 * @member ns.widget.core.progress.Progress
			 * @protected
			 */
			prototype._build = function (element) {
				var self = this,
					options = self.options;

				self._type = options.type;

				element.classList.add(classes.uiProgress);
				self._progress = ns.widget.core.progress.type[options.type];
				self._progress.build(self, element);

				return element;
			};

			/**
			 * Initialization of Progress component
			 * @method _init
			 * @param {HTMLElement} element
			 * @member ns.widget.core.progress.Progress
			 * @protected
			 */
			prototype._init = function (element) {
				var self = this;

				self._progress.init(self, element);
				element.setAttribute("value", self.options.value);

				return element;
			};

			/**
			 * Refresh of Progress
			 * @method _refresh
			 * @param {HTMLElement} element
			 * @member ns.widget.core.progress.Progress
			 * @protected
			 */
			prototype._refresh = function (element) {
				var self = this,
					options = self.options;

				if (self._type !== options.type) {
					self._destroy();
					return ns.widget.Progress(element, {type: options.type});
				} else {
					self._progress.refresh(self);
					self._setValue(self.options.value);
				}

				return element;
			};

			prototype._setValue = function (value) {
				var self = this,
					options = self.options,
					element = self.element;

				self._oldValue = options.value;


				if (typeof value === "number") {
					value = Math.min(options.max, Math.max(options.min, value));
					// value changed
					if (value !== self._oldValue) {
						options.value = value;
						if (!self.isCustomElement) {
							element.setAttribute("data-value", value);
						}
						element.setAttribute("value", value);
						events.trigger(element, eventType.CHANGE);
						self._progress.changeValue(self, self._oldValue, value);
					}
					return true;
				}
				return false;
			};

			/**
			 * Return value of progress
			 * @return {number}
			 * @private
			 */
			prototype._getValue = function () {
				return parseInt(this.element.getAttribute("value"), 10);
			};

			prototype._animate = function (duration, progressCallback, finishCallback) {
				var self = this,
					startTime = null;

				self._isAnimating = true;

				util.requestAnimationFrame(function step(timeStamp) {
					var currentTimeGap = 0;

					if (startTime === null) {
						startTime = timeStamp;
					}
					currentTimeGap = timeStamp - startTime;

					progressCallback(currentTimeGap);

					if (self._isAnimating && duration > currentTimeGap) {
						util.requestAnimationFrame(step);
					} else {
						self._isAnimating = false;
						finishCallback();
					}
				});
			};

			/**
			 * Callback on event pagebeforeshow
			 * @method pageBeforeShow
			 * @param {ns.widget.core.progress.Progress} self
			 * @private
			 * @member ns.widget.core.progress.Progress
			 */
			function pageBeforeShow(self) {
				self.refresh();
			}

			/**
			 * Bind events to Progress
			 * @method _bindEvents
			 * @member ns.widget.core.progress.Progress
			 * @protected
			 */
			prototype._bindEvents = function () {
				var self = this,
					element = self.element,
					page = selectors.getClosestByClass(element, Page.classes.uiPage);

				self._callbacks.onPageBeforeShow = pageBeforeShow.bind(null, self);
				page.addEventListener(Page.events.BEFORE_SHOW, self._callbacks.onPageBeforeShow, false);
			};

			/**
			 * Destroys Progress component
			 * @method _destroy
			 * @member ns.widget.core.progress.Progress
			 * @protected
			 */
			prototype._destroy = function () {
				var self = this,
					element = self.element,
					page;

				while (element.firstChild) {
					element.removeChild(element.firstChild);
				}

				self._ui = null;
				self._oldValue = null;

				if (self._callbacks.onPageBeforeShow) {
					page = selectors.getClosestByClass(element, Page.classes.uiPage);
					page.removeEventListener(Page.events.BEFORE_SHOW, self._callbacks.onPageBeforeShow, false);
				}

				return element;
			};

			ns.widget.core.progress.Progress = Progress;

			engine.defineWidget(
				"Progress",
				"[data-role='progress'], .ui-progress",
				[],
				Progress,
				"core"
			);

			return Progress;
			}(window.document, ns));

/*global window, define, ns */
/*
* Copyright (c) 2019 Samsung Electronics Co., Ltd
*
* Licensed under the Flora License, Version 1.1 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://floralicense.org/license/
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
/* #Interactive 3D
* Interactive 3D widget is using the r-type library to show 3D model.
* It is included at the libs folder. If you want to use the Interactive 3D,
* you have to add the r-type library in your project.
*
* <script src="tau/libs/r-type.min.js></script>"
*
* @example
* <div class="ui-i3d"></div>
*
* @since 5.5
* @class ns.widget.core.Interactive3D
* @extends ns.widget.BaseWidget
* @author Hunseop Jeong <hs85.jeong@samsung.com>
*/
(function (window, document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				Interactive3D = function () {
					this._ui = {};
				},
				allowAttributes = [
					"width", "height", "position", "scale", "rotation", "controls",
					"autoplay", "light", "src", "show", "hide", "mtl"
				],
				prototype = new BaseWidget();

			Interactive3D.prototype = prototype;

			/**
			* Init widget
			* @method _init
			* @param {HTMLElement} element
			* @return {HTMLElement} Returns built element
			* @member ns.widget.core.Interactive3D
			* @protected
			*/
			prototype._init = function (element) {
				var self = this;

				self.observer = new MutationObserver(self._attributeChange.bind(this));
				self.observer.observe(element, {attributes: true});

				return element;
			}

			/**
			* Observe whether the attribute changes
			* @method _attributeChange
			* @param {Object[]} mutationList
			* @member ns.widget.core.Interactive3D
			* @protected
			*/
			prototype._attributeChange = function (mutationList) {
				var self = this;

				mutationList.forEach(function (mutation) {
					var attributeName = mutation.attributeName,
						target;

					if (allowAttributes.indexOf(attributeName) !== -1) {
						target = mutation.target;

						if (target.hasAttribute(attributeName)) {
							self._ui.rType.setAttribute(attributeName, target.attributes[attributeName].value);
						} else {
							self._ui.rType.removeAttribute(attributeName);
						}
					}
				});
			};

			/**
			* Build widget structure
			* @method _build
			* @param {HTMLElement} element
			* @return {HTMLElement} Returns built element
			* @member ns.widget.core.Interactive3D
			* @protected
			*/
			prototype._build = function (element) {
				var rType = document.createElement("r-type"),
					attributes = element.attributes,
					i;

				for (i = 0; i < attributes.length; i++) {
					if (allowAttributes.indexOf(attributes[i].name) !== -1) {
						rType.setAttribute(attributes[i].name, attributes[i].value);
					}
				}

				this._ui.rType = rType;
				element.appendChild(rType);

				return element;
			};

			/**
			* Destroys Interactive 3D widget
			* @method _destroy
			* @member ns.widget.core.Interactive3D
			* @protected
			*/
			prototype._destroy = function () {
				var self = this,
					ui = self._ui,
					rType = ui.rType;

				if (rType && rType.parentNode) {
					rType.parentNode.removeChild(rType);
				}

				this.observer.disconnect();
			};

			ns.widget.core.Interactive3D = Interactive3D;

			engine.defineWidget(
				"Interactive3D",
				".ui-i3d",
				[],
				Interactive3D,
				"core"
			);
			}(window, window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2019 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * #CoverFlow
 * Cover flow widget is using the jQuery.Flipster library for cover flow
 * effect.
 * It is included at the libs folder. If you want to use the CoverFlow,
 * you have to add the jQuery.Flipster library in your project after jQuery.
 *
 * <script src="tau/mobile/js/jquery.min.js"></script>
 * <script src="tau/libs/jquery.flipster.min.js></script>"
 *
 * @example
 * <div class="ui-coverflow"></div>
 *
 * @since 5.5
 * @class ns.widget.core.CoverFlow
 * @extends ns.widget.BaseWidget
 * @author Dohyung Lim <delight.lim@samsung.com>
 */
(function (window, document, ns) {
	"use strict";
				var utilsObject = ns.util.object,

				CoverFlow = function () {
					this.options = utilsObject.merge({}, CoverFlow.defaults);
					this.observer = null;
				},

				defaults = { value: "coverflow" },

				BaseWidget = ns.widget.BaseWidget,
				prototype = new BaseWidget();

			CoverFlow.prototype = prototype;
			CoverFlow.defaults = defaults;

			prototype._init = function (element) {
				var self = this;

				if (!element.getAttribute("value")) {
					element.setAttribute("value", self.options.value);
				}

				self.observer = new MutationObserver(self._checkEffectChange.bind(this));
				self.observer.observe(element, {attributes: true});

				return element;
			};

			prototype._checkEffectChange = function (mutationsList) {
				mutationsList.forEach(function (mutation) {
					if (mutation.attributeName === "data-effect" && this.element.getAttribute("data-effect")) {
						this.options.value = this.element.getAttribute("data-effect");
						this._refresh();
					}
				}.bind(this));
			};

			prototype._refresh = function () {
				var self = this;
				self._setValue(self.options.value);
			}

			prototype._setValue = function (value) {
				this.ui = {};
				this.ui.$element = window.jQuery(this.element).flipster({
					style: value,
					spacing: -0.5
				});
			}

			prototype._build = function (element) {
				if (element.getAttribute("data-effect")) {
					this.options.value = element.getAttribute("data-effect");
				}

				this.ui = {};
				if (window.jQuery && typeof window.jQuery.fn.flipster === "function") {
					this.ui.$element = window.jQuery(element).flipster({
						style: this.options.value,
						spacing: -0.5
					});
				} else {
					ns.warn("JQuery or flipster.js not exists");
				}
				return element;
			};

			prototype._destroy = function () {
				this.observer.disconnect();
			}

			ns.engine.defineWidget(
				"CoverFlow",
				".ui-coverflow",
				[],
				CoverFlow,
				"core"
			);
			}(window, window.document, ns));

/*
 * Copyright (c) 2018 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns */
/*
 * #Graph
 *
 * Graph widget are using external libraries:
 * http://cdn.jsdelivr.net/d3js/3.5.17/d3.min.js
 * http://cdn.jsdelivr.net/npm/taucharts@1/build/production/tauCharts.min.js
 * These libraries are not part of TAU source code.
 * These libraries are attached to project but references should be added in a application
 *
 * <script src="tau/libs/d3.min.js" charset="utf-8"></script>
 * <script src="tau/libs/tauCharts.min.js" type="text/javascript"></script>
 * <link rel="stylesheet" type="text/css" href="tau/libs/tauCharts.min.css">
 *
 * @example
 * 	<div class="ui-graph"></div>
 *
 * <div class="ui-graph"
 *      data-graph="scatterplot"
 *      data-color="#FF0000"
 *      data-xlabel="x label"
 *      data-ylabel="y label"
 * ></div>
 *
 * @since 5.0
 * @class ns.widget.core.Graph
 * @extends ns.widget.core.BaseWidget
 */
(function (window, document, ns) {
	"use strict";
				var utilsObject = ns.util.object,

				Graph = function () {
					var self = this;

					self.options = utilsObject.merge({}, Graph.defaults);

					self.data = [];
					self.size = "";
					self._initialData = true;
					self.split = "formula";
					self.guide = {
						color: {
							brewer: [defaults.color]
						},
						showGridLines: "xy",
						x: {
							nice: false,
							label: {
								text: defaults.xlabel
							}
						},
						y: {
							nice: false,
							label: {
								text: defaults.ylabel
							}
						}
					};
					self.dimensions = {
						x: {
							type: "order",
							scale: "time"
						},
						y: {
							type: "order",
							scale: "linear"
						}
					};
					self.chart = null;
				},

				addLibText = "Please, include tauCharts library (https://www.taucharts.com/).",

				MODE_INTERMITTENT = "intermittent",
				MODE_CONTINUOUS = "continuous",

				xAxis = "x",
				yAxis = "y",

				TIME_AXIS_X = xAxis,
				TIME_AXIS_Y = yAxis,
				TIME_AXIS_NONE = "none",

				graphTypes = {
					stackedBar: "stacked-bar",
					line: "line",
					stackedArea: "stacked-area",
					scatterplot: "scatterplot",
					bar: "bar"
				},

				defaults = {
					graph: graphTypes.line,
					color: "#0097D8",
					xlabel: "",
					ylabel: "",
					xinit: 0,
					yinit: 0,
					axisXType: "time",
					axisYType: "linear",
					mode: MODE_INTERMITTENT,
					value: [],
					timeAxis: TIME_AXIS_X, // only when one value supplied
					groupKey: "label",
					legend: false
				},

				classes = {
					graphContainer: "ui-graph"
				},


				BaseWidget = ns.widget.BaseWidget,
				prototype = new BaseWidget();

			Graph.prototype = prototype;
			Graph.defaults = defaults;
			Graph.MODE = {
				INTERMITTENT: MODE_INTERMITTENT,
				CONTINUOS: MODE_CONTINUOUS
			};
			Graph.TIME_AXIS = {
				X: TIME_AXIS_X,
				Y: TIME_AXIS_Y,
				NONE: TIME_AXIS_NONE
			};

			prototype._newChart = function (element) {
				var self = this,
					data = null;

				self.element.innerHTML = "";
				self._rebuildCache();
				data = self._prepareChartData();
				self.chart = new window.tauCharts.Chart({
					data: [],
					type: self.options.graph,
					x: xAxis,
					y: yAxis,
					color: "label",
					size: self.size,
					split: self.split,
					guide: self.guide,
					dimensions: self.dimensions,
					plugins: (self.options.legend) ? [window.tauCharts.api.plugins.get("legend")] : []
				});

				self.chart.renderTo(element);

				self._updateChart(data);
			};

			prototype._setChartAxis = function (identifier) {
				var self = this,
				    axisDimensions = self.dimensions[identifier],
				    axisType = self.options["axis" + identifier.toUpperCase() + "Type"];

				axisDimensions.type = "order";
				switch (axisType) {
					case "time":
					case "index":
						axisDimensions.scale = "time";
						self.guide[identifier].tickFormat = "day";
					break;
					case "order":
						axisDimensions.scale = "ordinal";
					break;
					case "linear":
						axisDimensions.scale = "linear";
					break;
				}
			}

			prototype._init = function (element) {
				var self = this,
					oldData = [],
					guide = self.guide;

				self.options.color = self.options.color.split(",")
				guide.color.brewer = self.options.color;
				guide.x.label.text = self.options.xlabel;
				guide.y.label.text = self.options.ylabel;

				self._setChartAxis("x");
				self._setChartAxis("y");

				self.data.length = 0;
				// get chart data from data-value attribute
				if (self.options.value) {
					try {
						oldData = JSON.parse(self.options.value);
					} catch (e) { }

					if (oldData.length > 0) {
						//self.data = self.data.concat(oldData);
						oldData.forEach(function (data) {
							self._addData(data);
						});
						self._initialData = true;
					}
				} else {
					self._addData(0);
					self._initialData = true;
				}

				// create chart widget
				self._newChart(element);

				return element;
			};

			prototype._build = function (element) {
				var self = this;

				if (window.tauCharts) {
					self._createDivElement(
						element, classes.graphContainer);
					return element;
				} else {
					console.warn(addLibText);
				}
			};

			prototype._addData = function (value) {
				var now = Date.now(),
					valueObject = {
						time: now,
						value: value,
						cache: null
					},
					self = this;

				if (self._initialData) { // remove initial data
					self.data = [];
					self._initialData = false;
				}

				valueObject.cache = self._map(valueObject, self.data.length);
				self.data.push(valueObject);
			};

			prototype._map = function (valueObject, index) {
				var dataset = [],
					value = valueObject.value,
					time = valueObject.time,
					timeAxis = this.options.timeAxis,
					axisXType = this.options.axisXType,
					groupKey = this.options.groupKey,
					label,
					x = 0,
					y = 0;

				// Convert data to array [x, y]
				if (typeof value === "object") {
					// if data object has "x" and "y" property
					if (value.x !== undefined) {
						dataset.push(value.x);
						if (value.y !== undefined) {
							dataset.push(value.y);
						}
						if (value[groupKey] !== undefined) {
							dataset.push(value[groupKey]);
						}
					} else {
						// data object has other keys
						Object.keys(value).forEach(function (key) {
							dataset.push(value[key]);
						});
					}
				} else {
					// value is single value;
					dataset = [value];
				}

				// convert array [x, y] to object {x: x, y: y}
				if (dataset.length === 1) {
					switch (axisXType) {
						case "time":
							if (timeAxis === TIME_AXIS_X) {
								y = parseFloat(dataset[0]) || 0;
								x = time;
							} else {
								x = parseFloat(dataset[0]) || 0;
								if (timeAxis === TIME_AXIS_Y) {
									y = time;
								}
							}
							break;
						case "index":
							x = index;
							y = parseFloat(dataset[0]) || 0;
							break;
					}
					label = "Series 1";
				} else {
					switch (axisXType) {
						case "index":
							x = index;
							y = parseFloat(dataset[0]) || 0;
							break;
						default:
							x = parseFloat(dataset[0]) || 0;
							y = parseFloat(dataset[1]) || 0;
							break;
					}
					label = dataset[dataset.length - 1];
				}

				return {
					x: x,
					y: y,
					label: label
				}
			}

			prototype._rebuildCache = function () {
				var self = this;

				self.data.forEach(function (value, index) {
					value.cache = self._map(value, index);
				});
			};

			prototype._prepareChartData = function () {
				return this.data.map(function (value) {
					return value.cache;
				})
			};

			prototype._updateChart = function (data) {
				var self = this;

				if (self.options.mode === MODE_INTERMITTENT) {
					data.length = 0;
				}

				self.chart.setData(data);

				self.element.setAttribute(
					"data-value",
					JSON.stringify(data)
				);
			};

			prototype._setOneValue = function (value) {
				var self = this;

				self._addData(value),
				self._updateChart(self._prepareChartData());

				return false;
			}

			prototype._setValue = function (value) {
				var dataset = Array.isArray(value) ? value : [value],
					result = true,
					self = this;

				dataset.forEach(function (val) {
					if (!self._setOneValue(val) && result) {
						result = false;
					}
				});

				return result;
			};

			prototype._getValue = function () {
				return this.data;
			};

			prototype._createDivElement = function (
					parentElement, className) {
				var newElement = document.createElement("div");

				newElement.classList.add(className);

				parentElement.appendChild(newElement);
			};

			prototype._refresh = function () {
				var self = this;

				self.guide = {
					color: {
						brewer: self.options.color
					},
					x: {
						label: {
							text: self.options.xlabel
						}
					},
					y: {
						label: {
							text: self.options.ylabel
						}
					}
				};
				self._newChart(self.element);

			}

			ns.widget.core.Graph = Graph;

			ns.engine.defineWidget(
				"Graph",
				".ui-graph", [],
				Graph,
				"core"
			);
			}(window, window.document, ns));
/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Popup
 * Popup component supports 2 pop-ups: the position-to-window pop-up (like a system pop-up), and the context pop-up.
 *
 * @since 2.0
 * @author Hyunkook Cho <hk0713.cho@samsung.com>
 * @class ns.widget.core.Popup
 * @component-selector .ui-popup, [data-role]="popup"
 * @extends ns.widget.core.BaseWidget
 */
(function () {
	"use strict";
				/**
			 * Alias for {@link ns.widget.BaseWidget}
			 * @property {Function} BaseWidget
			 * @member ns.widget.core.Popup
			 * @private
			 */
			var BaseWidget = ns.widget.BaseWidget,
				/**
				 * Alias for class ns.engine
				 * @property {ns.engine} engine
				 * @member ns.widget.core.Popup
				 * @private
				 */
				engine = ns.engine,
				/**
				 * Alias for class ns.util.object
				 * @property {Object} objectUtils
				 * @member ns.widget.core.Popup
				 * @private
				 */
				objectUtils = ns.util.object,
				/**
				 * Alias for class ns.util.deferred
				 * @property {Object} UtilDeferred
				 * @member ns.widget.core.Popup
				 * @private
				 */
				UtilDeferred = ns.util.deferred,
				/**
				 * Alias for class ns.util.selectors
				 * @property {Object} utilSelector
				 * @member ns.widget.core.Popup
				 * @private
				 */
				utilSelector = ns.util.selectors,
				/**
				 * Alias for class ns.event
				 * @property {Object} eventUtils
				 * @member ns.widget.core.Popup
				 * @private
				 */
				eventUtils = ns.event,
				/**
				 * Alias for Router, loose requirement
				 * @property {ns.router.Router} Router
				 * @member ns.widget.core.Popup
				 * @private
				 */
				Router = ns.router && ns.router.Router,

				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				/**
				 * Alias for class ns.widget.core.Page
				 * @property {ns.router.Router} Router
				 * @member ns.widget.core.Popup
				 * @private
				 */
				Page = ns.widget.core.Page,

				POPUP_SELECTOR = "[data-role='popup'], .ui-popup",

				Popup = function () {
					var self = this,
						ui = {};

					BaseKeyboardSupport.call(self);

					self.selectors = selectors;
					self.options = objectUtils.merge({}, Popup.defaults);
					self.storedOptions = null;
					/**
					 * Popup state flag
					 * @property {0|1|2|3} [state=null]
					 * @member ns.widget.core.Popup
					 * @private
					 */
					self.state = states.CLOSED;

					ui.overlay = null;
					ui.header = null;
					ui.footer = null;
					ui.content = null;
					ui.container = null;
					ui.wrapper = null;
					self._ui = ui;

					// event callbacks
					self._callbacks = {};
				},
				/**
				 * Object with default options
				 * @property {Object} defaults
				 * @property {string} [options.transition="none"] Sets the default transition for the popup.
				 * @property {string} [options.positionTo="window"] Sets the element relative to which the popup will be centered.
				 * @property {boolean} [options.dismissible=true] Sets whether to close popup when a popup is open to support the back button.
				 * @property {boolean} [options.overlay=true] Sets whether to show overlay when a popup is open.
				 * @property {boolean|string} [options.header=false] Sets content of header.
				 * @property {boolean|string} [options.footer=false] Sets content of footer.
				 * @property {string} [options.content=null] Sets content of popup.
				 * @property {string} [options.overlayClass=""] Sets the custom class for the popup background, which covers the entire window.
				 * @property {string} [options.closeLinkSelector="a[data-rel='back']"] Sets selector for close buttons in popup.
				 * @property {boolean} [options.history=true] Sets whether to alter the url when a popup is open to support the back button.
				 * @member ns.widget.core.Popup
				 * @static
				 */
				defaults = {
					transition: "none",
					dismissible: true,
					overlay: true,
					header: false,
					footer: false,
					content: null,
					overlayClass: "",
					closeLinkSelector: "[data-rel='back']",
					history: null,
					closeAfter: null
				},
				states = {
					DURING_OPENING: 0,
					OPENED: 1,
					DURING_CLOSING: 2,
					CLOSED: 3
				},
				CLASSES_PREFIX = "ui-popup",
				/**
				 * Dictionary for popup related css class names
				 * @property {Object} classes
				 * @member ns.widget.core.Popup
				 * @static
				 */
				/**
				 * Toast style of popup with graphic
				 * @style ui-popup-toast-graphic
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
				classes = {
				/**
				 * Style for normal popup widget
				 * @style ui-popup
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					popup: CLASSES_PREFIX,
				/**
				 * Set style for active popup widget
				 * @style ui-popup-active
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					active: CLASSES_PREFIX + "-active",
				/**
				 * Set style for overlay popup widget
				 * @style ui-popup-overlay
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					overlay: CLASSES_PREFIX + "-overlay",
				/**
				 * Set header for popup widget
				 * @style ui-popup-header
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					header: CLASSES_PREFIX + "-header",
				/**
				 * Set footer for popup widget
				 * @style ui-popup-footer
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					footer: CLASSES_PREFIX + "-footer",
				/**
				 * Set content for popup widget
				 * @style ui-popup-content
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					content: CLASSES_PREFIX + "-content",
				/**
				 * Style for wrapper of popup widget
				 * @style ui-popup-wrapper
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					wrapper: CLASSES_PREFIX + "-wrapper",
				/**
				 * Toast style of popup
				 * @style ui-popup-toast
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					toast: CLASSES_PREFIX + "-toast",
				/**
				 * Small toast style of popup
				 * @style ui-popup-toast-small
				 * @member ns.widget.core.Popup
				 * @wearable
				 */
					toastSmall: CLASSES_PREFIX + "-toast-small",
					build: "ui-build",
					overlayShown: CLASSES_PREFIX + "-overlay-shown"
				},
				/**
				 * Dictionary for popup related selectors
				 * @property {Object} selectors
				 * @member ns.widget.core.Popup
				 * @static
				 */
				selectors = {
					header: "." + classes.header,
					content: "." + classes.content,
					footer: "." + classes.footer
				},
				EVENTS_PREFIX = "popup",
				/**
				 * Dictionary for popup related events
				 * @property {Object} events
				 * @member ns.widget.core.Popup
				 * @static
				 */
				events = {
					/**
					 * Triggered when the popup has been created in the DOM (via ajax or other) but before all widgets have had an opportunity to enhance the contained markup.
					 * @event popupshow
					 * @member ns.widget.core.Popup
					 */
					show: EVENTS_PREFIX + "show",
					/**
					 * Triggered on the popup after the transition animation has completed.
					 * @event popuphide
					 * @member ns.widget.core.Popup
					 */
					hide: EVENTS_PREFIX + "hide",
					/**
					 * Triggered on the popup we are transitioning to, before the actual transition animation is kicked off.
					 * @event popupbeforeshow
					 * @member ns.widget.core.Popup
					 */
					/* eslint-disable camelcase */
					// we can't change this in this moment because this is part of API
					before_show: EVENTS_PREFIX + "beforeshow",
					/**
					 * Triggered on the popup we are transitioning to, before the actual transition animation is kicked off, animation has started.
					 * @event popuptransitionstart
					 * @member ns.widget.core.Popup
					 */
					transition_start: EVENTS_PREFIX + "transitionstart",
					/**
					 * Triggered on the popup we are transitioning away from, before the actual transition animation is kicked off.
					 * @event popupbeforehide
					 * @member ns.widget.core.Popup
					 */
					before_hide: EVENTS_PREFIX + "beforehide"
					/* eslint-enable camelcase */
				},

				prototype = new BaseWidget();

			Popup.classes = classes;
			Popup.events = events;
			Popup.defaults = defaults;
			Popup.selector = POPUP_SELECTOR;

			/**
			 * Build the content of popup
			 * @method _buildContent
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._buildContent = function (element) {
				var self = this,
					ui = self._ui,
					selectors = self.selectors,
					options = self.options,
					content = ui.content || element.querySelector(selectors.content),
					footer = ui.footer || element.querySelector(selectors.footer),
					elementChildren = [].slice.call(element.childNodes),
					elementChildrenLength = elementChildren.length,
					i,
					node;

				if (!content) {
					content = document.createElement("div");
					content.className = classes.content;
					for (i = 0; i < elementChildrenLength; ++i) {
						node = elementChildren[i];
						if (node !== ui.footer && node !== ui.header) {
							content.appendChild(node);
						}
					}
					if (typeof options.content === "string") {
						content.innerHTML = options.content;
					}
					element.insertBefore(content, footer);
				}
				content.classList.add(classes.content);
				ui.content = content;
			};

			/**
			 * Build the header of popup
			 * @method _buildHeader
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._buildHeader = function (element) {
				var self = this,
					ui = self._ui,
					options = self.options,
					selectors = self.selectors,
					content = ui.content || element.querySelector(selectors.content),
					header = ui.header || element.querySelector(selectors.header);

				if (!header && options.header !== false) {
					header = document.createElement("div");
					header.className = classes.header;
					if (typeof options.header !== "boolean") {
						header.innerHTML = options.header;
					}
					element.insertBefore(header, content);
				}
				if (header) {
					header.classList.add(classes.header);
				}
				ui.header = header;
			};

			/**
			 * Set the header of popup.
			 * This function is called by function "option" when the option "header" is set.
			 * @method _setHeader
			 * @param {HTMLElement} element
			 * @param {boolean|string} value
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._setHeader = function (element, value) {
				var self = this,
					ui = self._ui,
					header = ui.header;

				if (header) {
					header.parentNode.removeChild(header);
					ui.header = null;
				}
				self.options.header = value;
				self._buildHeader(ui.container);
			};

			/**
			 * Build the footer of popup
			 * @method _buildFooter
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._buildFooter = function (element) {
				var self = this,
					ui = self._ui,
					options = self.options,
					footer = ui.footer || element.querySelector(self.selectors.footer);

				if (!footer && options.footer !== false) {
					footer = document.createElement("div");
					footer.className = classes.footer;
					if (typeof options.footer !== "boolean") {
						footer.innerHTML = options.footer;
					}
					element.appendChild(footer);
				}
				if (footer) {
					footer.classList.add(classes.footer);
				}
				ui.footer = footer;
			};

			/**
			 * Set the footer of popup.
			 * This function is called by function "option" when the option "footer" is set.
			 * @method _setFooter
			 * @param {HTMLElement} element
			 * @param {boolean|string} value
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._setFooter = function (element, value) {
				var self = this,
					ui = self._ui,
					footer = ui.footer;

				if (footer) {
					footer.parentNode.removeChild(footer);
					ui.footer = null;
				}
				self.options.footer = value;
				self._buildFooter(ui.container);
			};

			/**
			 * Build structure of Popup widget
			 * @method _build
			 * @param {HTMLElement} element of popup
			 * @return {HTMLElement}
			 * @protected
			 * @member ns.widget.Popup
			 */
			prototype._build = function (element) {
				var self = this,
					ui = self._ui,
					wrapper,
					child = element.firstChild,
					elementClassList = element.classList;

				// set class for element
				elementClassList.add(classes.popup);

				if (elementClassList.contains(classes.toastSmall)) {
					elementClassList.add(classes.toast);
				}

				// create wrapper
				wrapper = document.createElement("div");
				wrapper.classList.add(classes.wrapper);
				ui.wrapper = wrapper;
				ui.container = wrapper;
				// move all children to wrapper
				while (child) {
					wrapper.appendChild(child);
					child = element.firstChild;
				}
				// add wrapper and arrow to popup element
				element.appendChild(wrapper);

				// build header, footer and content
				self._buildHeader(ui.container);
				self._buildFooter(ui.container);
				self._buildContent(ui.container);

				// set overlay
				self._setOverlay(element, self.options.overlay);

				return element;
			};

			/**
			 * Set overlay
			 * @method _setOverlay
			 * @param {HTMLElement} element
			 * @param {boolean} enable
			 * @protected
			 * @member ns.widget.Popup
			 */
			prototype._setOverlay = function (element, enable) {
				var self = this,
					overlayClass = self.options.overlayClass,
					ui = self._ui,
					overlay = ui.overlay;

				// if this popup is not connected with slider,
				// we create overlay, which is invisible when
				// the value of option overlay is false
				/// @TODO: get class from widget
				if (!element.classList.contains("ui-slider-popup") && !element.classList.contains(classes.toast)) {
					// create overlay
					if (!overlay) {
						overlay = document.createElement("div");

						if (element.parentNode) {
							element.parentNode.insertBefore(overlay, element);
						} else {
							ns.warn("Popup is creating on element outside DOM");
						}

						ui.overlay = overlay;
					}
					overlay.className = classes.overlay + (overlayClass ? " " + overlayClass : "");
					if (enable) {
						overlay.style.opacity = "";
					} else {
						// if option is set on "false", the overlay is not visible
						overlay.style.opacity = 0;
					}
				}
			};

			/**
			 * Returns the state of the popup
			 * @method _isActive
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._isActive = function () {
				var state = this.state;

				return state === states.DURING_OPENING || state === states.OPENED;
			};

			/**
			 * Returns true if popup is already opened and visible
			 * @method _isActive
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._isOpened = function () {
				return this.state === states.OPENED;
			};

			/**
			 * Init widget
			 * @method _init
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._init = function (element) {
				var self = this,
					selectors = self.selectors,
					ui = self._ui,
					options = self.options,
					elementClassList = self.element.classList;

				ui.header = ui.header || element.querySelector(selectors.header);
				ui.footer = ui.footer || element.querySelector(selectors.footer);
				ui.content = ui.content || element.querySelector(selectors.content);
				ui.wrapper = ui.wrapper || element.querySelector("." + classes.wrapper);
				ui.container = ui.wrapper || element;

				ui.page = utilSelector.getClosestByClass(element, Page.classes.uiPage) || window;
				ui.pageContent = (typeof ui.page.querySelector === "function") ?
					ui.page.querySelector("." + Page.classes.uiContent) : null;

				if (elementClassList.contains(classes.toast)) {
					options.closeAfter = options.closeAfter || 2000;
				}
				// if option history is not set in constructor or in HTML
				if (options.history === null) {
					// for toast we set false for other true
					options.history = !elementClassList.contains(classes.toast);
				}
			};

			/**
			 * Set the state of the popup
			 * @method _setActive
			 * @param {boolean} active
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._setActive = function (active) {
				var self = this,
					activeClass = classes.active,
					elementClassList = self.element.classList,
					route = Router && Router.getInstance().getRoute("popup"),
					options;

				// NOTE: popup's options object is stored in window.history at the router module,
				// and this window.history can't store DOM element object.
				options = objectUtils.merge({}, self.options, {positionTo: null, link: null});

				// set state of popup and add proper class
				if (active) {
					// set global variable
					if (route) {
						route.setActive(self, options);
					}
					// add proper class
					elementClassList.add(activeClass);
					// set state of popup 	358
					self.state = states.OPENED;
				} else {
					// no popup is opened, so set global variable on "null"
					if (route) {
						route.setActive(null, options);
					}
					// remove proper class
					elementClassList.remove(activeClass);
					// set state of popup
					self.state = states.CLOSED;
				}
			};

			/**
			 * Bind events
			 * @method _bindEvents
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._bindEvents = function () {
				var self = this;

				eventUtils.on(self._ui.page, "pagebeforehide", self, false);
				eventUtils.on(window, "resize", self, false);
				eventUtils.on(document, "vclick", self, false);
			};


			/**
			 * Unbind events
			 * @method _bindEvents
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._unbindEvents = function () {
				var self = this;

				eventUtils.off(self._ui.page, "pagebeforehide", self, false);
				eventUtils.off(window, "resize", self, false);
				eventUtils.off(document, "vclick", self, false);
			};

			/**
			 * Layouting popup structure
			 * @method layout
			 * @member ns.widget.core.Popup
			 */
			prototype._layout = function () {
			};

			/**
			 * Open the popup
			 * @method open
			 * @param {Object=} [options]
			 * @param {string=} [options.transition] options.transition
			 * @member ns.widget.core.Popup
			 */
			prototype.open = function (options) {
				var self = this,
					newOptions,
					onClose = self.close.bind(self);


				if (!self._isActive()) {
					/*
					 * Some passed options on open need to be kept until popup closing.
					 * For example, transition parameter should be kept for closing animation.
					 * On the other hand, fromHashChange or x, y parameter should be removed.
					 * We store options and restore them on popup closing.
					 */
					self._storeOpenOptions(options);

					newOptions = objectUtils.merge(self.options, options);
					if (!newOptions.dismissible) {
						ns.router.Router.getInstance().lock();
					}


					if (newOptions.closeAfter > 0) {
						if (self.element.classList.contains(classes.toast)) {
							newOptions.transition = "fade";
						}
						self._show(newOptions);

						self._closeTimeout = window.setTimeout(onClose, newOptions.closeAfter);
					} else {
						self._show(newOptions);
					}
				}
			};


			/**
			 * Close the popup
			 * @method close
			 * @param {Object=} [options]
			 * @param {string=} [options.transition]
			 * @member ns.widget.core.Popup
			 */
			prototype.close = function (options) {
				var self = this,
					newOptions = objectUtils.merge(self.options, options);

				if (self._isActive()) {
					clearTimeout(self._closeTimeout);
					if (!newOptions.dismissible) {
						ns.router.Router.getInstance().unlock();
					}
					self._hide(newOptions);
				}
			};

			/**
			 * Store Open options.
			 * @method _storeOpenOptions
			 * @param {Object} options
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._storeOpenOptions = function (options) {
				var self = this,
					oldOptions = self.options,
					storedOptions = {},
					key;

				for (key in options) {
					if (options.hasOwnProperty(key)) {
						storedOptions[key] = oldOptions[key];
					}
				}

				self.storedOptions = storedOptions;
			};

			/**
			 * Restore Open options and remove some unnecessary ones.
			 * @method _storeOpenOptions
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._restoreOpenOptions = function () {
				var self = this,
					options = self.options,
					propertiesToRemove = ["x", "y", "fromHashChange"];

				// we restore opening values of all options
				options = objectUtils.merge(options, self.storedOptions);
				// and remove all values which should not be stored
				objectUtils.removeProperties(options, propertiesToRemove);
			};

			/**
			 * Show popup.
			 * @method _show
			 * @param {Object} options
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._show = function (options) {
				var self = this,
					transitionOptions = objectUtils.merge({}, options),
					overlay = self._ui.overlay,
					pageContent = self._ui.pageContent;

				// set layout
				self._layout(self.element);

				// change state of popup
				self.state = states.DURING_OPENING;
				// set transition
				transitionOptions.ext = " in ";

				self.trigger(events.before_show);
				// show overlay
				if (overlay) {
					overlay.classList.toggle(classes.overlayShown, true);
				}

				// disable page pointer events
				if (pageContent) {
					pageContent.classList.toggle(Page.classes.uiContentUnderPopup, true);
				}

				// start opening animation
				self._transition(transitionOptions, self._onShow.bind(self));

				// animation has started
				self.trigger(events.transition_start);
			};

			/**
			 * Show popup
			 * @method _onShow
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._onShow = function () {
				var self = this;

				self._setActive(true);
				if (self.isKeyboardSupport) {
					self.disableFocusableElements(this._ui.page);
					self.enableDisabledFocusableElements(this.element);
					ns.widget.core.BaseKeyboardSupport.focusElement(this.element);
				}
				self.trigger(events.show);
			};

			/**
			 * Hide popup
			 * @method _hide
			 * @param {Object} options
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._hide = function (options) {
				var self = this,
					isOpened = self._isOpened(),
					callbacks = self._callbacks,
					pageContent = self._ui.pageContent;

				// change state of popup
				self.state = states.DURING_CLOSING;

				self.trigger(events.before_hide);

				// enable page pointer events
				if (pageContent) {
					pageContent.classList.toggle(Page.classes.uiContentUnderPopup, false);
				}

				if (isOpened) {
					// popup is opened, so we start closing animation
					options.ext = " out ";
					self._transition(options, self._onHide.bind(self));
				} else {
					// popup is active, but not opened yet (DURING_OPENING), so
					// we stop opening animation
					if (callbacks.transitionDeferred) {
						callbacks.transitionDeferred.reject();
					}
					if (callbacks.animationEnd) {
						callbacks.animationEnd();
					}
					// and set popup as inactive
					self._onHide();
				}
			};

			/**
			 * Hide popup
			 * @method _onHide
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._onHide = function () {
				var self = this,
					overlay = self._ui.overlay;

				self._setActive(false);

				if (self.isKeyboardSupport) {
					self.enableDisabledFocusableElements(this._ui.page);
				}

				if (overlay) {
					overlay.classList.toggle(classes.overlayShown, false);
				}
				self._restoreOpenOptions();
				self.trigger(events.hide);
			};

			/**
			 * Handle events
			 * @method handleEvent
			 * @param {Event} event
			 * @member ns.widget.core.Popup
			 */
			prototype.handleEvent = function (event) {
				var self = this,
					router = ns.router.Router.getInstance();

				switch (event.type) {
					case "pagebeforehide":
						// we need close active popup if exists
						router.close(null, {transition: "none", rel: "popup"});
						break;
					case "resize":
						self._onResize(event);
						break;
					case "vclick":
						if (event.target === self._ui.overlay) {
							self._onClickOverlay(event);
						}
						break;
				}
			};

			/**
			 * Refresh structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._refresh = function () {
				var self = this;

				self._setOverlay(self.element, self.options.overlay);
			};

			/**
			 * Callback function fires after clicking on overlay.
			 * @method _onClickOverlay
			 * @param {Event} event
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._onClickOverlay = function (event) {
				var options = this.options;

				event.preventDefault();
				event.stopPropagation();

				if (options.dismissible) {
					ns.router.Router.getInstance().close(null, {rel: "popup"});
				}
			};

			/**
			 * Callback function fires on resizing
			 * @method _onResize
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._onResize = function () {
				if (this._isOpened()) {
					this._refresh();
				}
			};

			function clearAnimation(self, transitionClass, deferred) {
				var element = self.element,
					elementClassList = element.classList,
					overlay = self._ui.overlay,
					animationEndCallback = self._callbacks.animationEnd;

				// remove callbacks on animation events
				element.removeEventListener("animationend", animationEndCallback, false);
				element.removeEventListener("webkitAnimationEnd", animationEndCallback, false);
				element.removeEventListener("mozAnimationEnd", animationEndCallback, false);
				element.removeEventListener("oAnimationEnd", animationEndCallback, false);
				element.removeEventListener("msAnimationEnd", animationEndCallback, false);

				// clear classes
				transitionClass.split(" ").forEach(function (currentClass) {
					currentClass = currentClass.trim();
					if (currentClass.length > 0) {
						elementClassList.remove(currentClass);
						if (overlay) {
							overlay.classList.remove(currentClass);
						}
					}
				});
				if (deferred.state() === "pending") {
					// we resolve only pending (not rejected) deferred
					deferred.resolve();
				}
			}

			function setTransitionDeferred(self, resolve) {
				var deferred = new UtilDeferred();

				deferred.then(function () {
					if (deferred === self._callbacks.transitionDeferred) {
						resolve();
					}
				});

				self._callbacks.transitionDeferred = deferred;
				return deferred;
			}

			/**
			 * Animate popup opening/closing
			 * @method _transition
			 * @protected
			 * @param {Object} [options]
			 * @param {string=} [options.transition]
			 * @param {string=} [options.ext]
			 * @param {?Function} [resolve]
			 * @member ns.widget.core.Popup
			 */
			prototype._transition = function (options, resolve) {
				var self = this,
					transition = options.transition || self.options.transition || "none",
					transitionClass = transition + options.ext,
					element = self.element,
					elementClassList = element.classList,
					overlayClassList,
					deferred,
					animationEndCallback;

				if (self._ui.overlay) {
					overlayClassList = self._ui.overlay.classList;
				}

				deferred = setTransitionDeferred(self, resolve);

				if (transition !== "none") {
					// set animationEnd callback
					animationEndCallback = clearAnimation.bind(null, self, transitionClass, deferred);
					self._callbacks.animationEnd = animationEndCallback;

					// add animation callbacks
					element.addEventListener("animationend", animationEndCallback, false);
					element.addEventListener("webkitAnimationEnd", animationEndCallback, false);
					element.addEventListener("mozAnimationEnd", animationEndCallback, false);
					element.addEventListener("oAnimationEnd", animationEndCallback, false);
					element.addEventListener("msAnimationEnd", animationEndCallback, false);
					// add transition classes
					transitionClass.split(" ").forEach(function (currentClass) {
						currentClass = currentClass.trim();
						if (currentClass.length > 0) {
							elementClassList.add(currentClass);

							if (overlayClassList) {
								overlayClassList.add(currentClass);
							}

						}
					});
				} else {
					if (!ns.getConfig("noAsync", false)) {
						window.setTimeout(deferred.resolve, 0);
					} else {
						deferred.resolve();
					}
				}
				return deferred;
			};

			/**
			 * Destroy popup
			 * @method _destroy
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._destroy = function () {
				var self = this,
					element = self.element,
					ui = self._ui,
					wrapper = ui.wrapper,
					child;

				if (wrapper) {
					// restore all children from wrapper
					child = wrapper.firstChild;
					while (child) {
						element.appendChild(child);
						child = wrapper.firstChild;
					}

					if (wrapper.parentNode) {
						wrapper.parentNode.removeChild(wrapper);
					}
				}

				self._unbindEvents(element);
				self._setOverlay(element, false);

				ui.wrapper = null;
			};

			Popup.prototype = prototype;

			ns.widget.core.Popup = Popup;

			engine.defineWidget(
				"Popup",
				POPUP_SELECTOR,
				[
					"open",
					"close",
					"reposition"
				],
				Popup,
				"core"
			);
			}());

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */

/**
 * # Popup Widget
 * Shows a pop-up window.
 *
 * The popup widget shows in the middle of the screen a list of items in a pop-up window.
 * It automatically optimizes the pop-up window size within the screen. The following table
 * describes the supported popup classes.
 *
 * ## Default selectors
 * All elements with class *ui-popup* will be become popup widgets.
 *
 * The pop-up window can contain a header, content, and footer area like the page element.
 *
 * To open a pop-up window from a link, use the data-rel attribute in HTML markup as in the
 * following code:
 *
 *      @example
 *      <a href="#popup" class="ui-btn" data-rel="popup">Open popup when clicking this element.</a>
 *
 * The following table shows examples of various types of popups.
 *
 * The popup contains header, content and footer area
 *
 * ###HTML Examples
 *
 * #### Basic popup with header, content, footer
 *
 *        @example
 *        <div class="ui-page">
 *            <div class="ui-popup">
 *                <div class="ui-popup-header">Power saving mode</div>
 *                <div class="ui-popup-content">
 *                    Turning on Power
 *                    saving mode will
 *                    limit the maximum
 *                    per
 *                </div>
 *                <div class="ui-popup-footer">
 *                    <button id="cancel" class="ui-btn">Cancel</button>
 *                </div>
 *            </div>
 *        </div>
 *
 * #### Popup with 2 buttons in the footer
 *
 *      @example
 *         <div id="2btnPopup" class="ui-popup">
 *             <div class="ui-popup-header">Delete</div>
 *             <div class="ui-popup-content">
 *                 Delete the image?
 *             </div>
 *             <div class="ui-popup-footer ui-grid-col-2">
 *                 <button id="2btnPopup-cancel" class="ui-btn">Cancel</button>
 *                 <button id="2btnPopup-ok" class="ui-btn">OK</button>
 *             </div>
 *         </div>
 *
 * #### Popup with checkbox/radio
 *
 * If you want make popup with list checkbox(or radio) just include checkbox (radio) to popup and
 * add class *ui-popup-checkbox-label* to popup element.
 *
 *        @example
 *         <div id="listBoxPopup" class="ui-popup">
 *             <div class="ui-popup-header">When?</div>
 *             <div class="ui-popup-content" style="height:243px; overflow-y:scroll">
 *                 <ul class="ui-listview">
 *                     <li>
 *                         <label for="check-1" class="ui-popup-checkbox-label">Yesterday</label>
 *                         <input type="checkbox" name="checkSet" id="check-1" />
 *                     </li>
 *                     <li>
 *                         <label for="check-2" class="ui-popup-checkbox-label">Today</label>
 *                         <input type="checkbox" name="checkSet" id="check-2" />
 *                     </li>
 *                     <li>
 *                         <label for="check-3" class="ui-popup-checkbox-label">Tomorrow</label>
 *                         <input type="checkbox" name="checkSet" id="check-3" />
 *                     </li>
 *                 </ul>
 *                 <ul class="ui-listview">
 *                     <li>
 *                         <label for="radio-1" class="ui-popup-radio-label">Mandatory</label>
 *                         <input type="radio" name="radioSet" id="radio-1" />
 *                     </li>
 *                     <li>
 *                         <label for="radio-2" class="ui-popup-radio-label">Optional</label>
 *                         <input type="radio" name="radioSet" id="radio-2" />
 *                     </li>
 *                 </ul>
 *             </div>
 *             <div class="ui-popup-footer">
 *                 <button id="listBoxPopup-close" class="ui-btn">Close</button>
 *             </div>
 *         </div>
 *     </div>
 *
 * #### Popup with no header and footer
 *
 *      @example
 *         <div id="listNoTitleNoBtnPopup" class="ui-popup">
 *             <div class="ui-popup-content" style="height:294px; overflow-y:scroll">
 *                 <ul class="ui-listview">
 *                     <li><a href="">Ringtones 1</a></li>
 *                     <li><a href="">Ringtones 2</a></li>
 *                     <li><a href="">Ringtones 3</a></li>
 *                 </ul>
 *             </div>
 *         </div>
 *
 * #### Toast popup
 *
 *      @example
 *         <div id="PopupToast" class="ui-popup ui-popup-toast">
 *             <div class="ui-popup-content">Saving contacts to sim on Samsung</div>
 *         </div>
 *
 * ### Create Option popup
 *
 * Popup inherits value of option positionTo from property data-position-to set in link.
 *
 *        @example
 *        <!--definition of link, which opens popup and sets its position-->
 *        <a href="#popupOptionText" data-rel="popup"  data-position-to="origin">Text</a>
 *        <!--definition of popup, which inherits property position from link-->
 *        <div id="popupOptionText" class="ui-popup">
 *            <div class="ui-popup-content">
 *                <ul class="ui-listview">
 *                <li><a href="#">Option 1</a></li>
 *                <li><a href="#">Option 2</a></li>
 *                <li><a href="#">Option 3</a></li>
 *                <li><a href="#">Option 4</a></li>
 *                </ul>
 *            </div>
 *        </div>
 *
 * ### Opening and closing popup
 *
 * To open popup from "a" link using html markup, use the following code:
 *
 *        @example
 *      <div class="ui-page">
 *          <header class="ui-header">
 *              <h2 class="ui-title">Call menu</h2>
 *          </header>
 *          <div class="ui-content">
 *              <a href="#popup" class="ui-btn" data-rel="popup" >Open Popup</a>
 *          </div>
 *
 *          <div id="popup" class="ui-popup">
 *               <div class="ui-popup-header">Power saving mode</div>
 *                   <div class="ui-popup-content">
 *                       Turning on Power
 *                       saving mode will
 *                       limit the maximum
 *                       per
 *                   </div>
 *               <div class="ui-popup-footer">
 *               <button id="cancel" class="ui-btn">Cancel</button>
 *           </div>
 *       </div>
 *
 *  To open the popup widget from JavaScript use method *tau.openPopup(to)*
 *
 *          @example
 *          tau.openPopup("popup")
 *
 *  To close the popup widget from JavaScript use method *tau.openPopup(to)*
 *
 *          @example
 *          tau.closePopup("popup")
 *
 * To find the currently active popup, use the ui-popup-active class.
 *
 * To bind the popup to a button, use the following code:
 *
 *      @example
 *         <!--HTML code-->
 *         <div id="1btnPopup" class="ui-popup">
 *             <div class="ui-popup-header">Power saving mode</div>
 *             <div class="ui-popup-content">
 *             </div>
 *             <div class="ui-popup-footer">
 *                 <button id="1btnPopup-cancel" class="ui-btn">Cancel</button>
 *             </div>
 *         </div>
 *         <script>
 *             // Popup opens with button click
 *             var button = document.getElementById("button");
 *             button.addEventListener("click", function() {
 *                 tau.openPopup("#1btnPopup");
 *             });
 *
 *             // Popup closes with Cancel button click
 *             document.getElementById("1btnPopup-cancel").addEventListener("click", function() {
 *                 tau.closePopup();
 *             });
 *         </script>
 *
 * ## Manual constructor
 * For manual creation of popup widget you can use constructor of widget from **tau** namespace:
 *
 *        @example
 *        var popupElement = document.getElementById("popup"),
 *            popup = tau.widget.popup(buttonElement);
 *
 * Constructor has one require parameter **element** which are base **HTMLElement** to create
 * widget. We recommend get this element by method *document.getElementById*.
 *
 * ## Options for Popup Widget
 *
 * Options for widget can be defined as _data-..._ attributes or give as parameter in constructor.
 *
 * You can change option for widget using method **option**.
 *
 * ## Methods
 *
 * To call method on widget you can use tau API:
 *
 *        @example
 *        var popupElement = document.getElementById("popup"),
 *            popup = tau.widget.popup(buttonElement);
 *
 *        popup.methodName(methodArgument1, methodArgument2, ...);
 *
 * ## Transitions
 *
 * By default, the framework doesn't apply transition. To set a custom transition effect, add the
 * data-transition attribute to the link.
 *
 *        @example
 *        <a href="index.html" data-rel="popup" data-transition="slideup">I will slide up</a>
 *
 * Global configuration:
 *
 *        @example
 *        gear.ui.defaults.popupTransition = "slideup";
 *
 * ### Transitions list
 *
 * - **none** Default value, no transition.
 * - **slideup** Makes the content of the pop-up slide up.
 *
 * ## Handling Popup Events
 *
 * To use popup events, use the following code:
 *
 *      @example
 *         <!--Popup html code-->
 *         <div id="popup" class="ui-popup">
 *             <div class="ui-popup-header"></div>
 *             <div class="ui-popup-content"></div>
 *         </div>
 *         </div>
 *         <script>
 *             // Use popup events
 *             var popup = document.getElementById("popup");
 *             popup.addEventListener("popupbeforecreate", function() {
 *                 // Implement code for popupbeforecreate event
 *             });
 *         </script>
 *
 * Full list of available events is in [events list section](#events-list).
 *
 * @author Hyunkook Cho <hk0713.cho@samsung.com>
 * @class ns.widget.core.ContextPopup
 * @extends ns.widget.core.Popup
 * @component-selector [data-role="popup"], .ui-popup
 */
(function (window, document, ns) {
	"use strict";
	
			var Popup = ns.widget.core.Popup,

				PopupPrototype = Popup.prototype,

				engine = ns.engine,

				objectUtils = ns.util.object,

				domUtils = ns.util.DOM,

				/**
				 * Object with default options
				 * @property {Object} defaults
				 * @property {string} [options.transition="none"] Sets the default transition for the popup.
				 * @property {string} [options.positionTo="window"] Sets the element relative to which the
				 * popup will be centered.
				 * @property {boolean} [options.dismissible=true] Sets whether to close popup when a popup
				 * is open to support the back button.
				 * @property {boolean} [options.overlay=true] Sets whether to show overlay when a popup is
				 * open.
				 * @property {string} [overlayClass=""] Sets the custom class for the popup background,
				 * which covers the entire window.
				 * @property {boolean} [options.history=true] Sets whether to alter the url when a popup
				 * is open to support the back button.
				 * @property {string} [options.arrow="l,t,r,b"] Sets directions of popup's arrow by
				 * priority ("l" for left, "t" for top,
				 * "r" for right, and "b" for bottom). The first one has the highest priority, the last one
				 * - the lowest. If you set arrow="t",
				 * then arrow will be placed at the top of popup container and the whole popup will be
				 * placed under clicked element.
				 * @property {string} [options.positionTo="window"] Sets the element relative to which
				 * the popup will be centered.
				 * @property {number} [options.distance=0] Sets the extra distance in px from clicked
				 * element.
				 * @property {HTMLElement|string} [options.link=null] Set the element or its id, under
				 * which popup should be placed.
				 * It only works with option positionTo="origin".
				 * @member ns.widget.core.ContextPopup
				 * @static
				 * @private
				 */
				defaults = {
					arrow: "l,b,r,t",
					positionTo: "window",
					positionOriginCenter: false,
					distance: 0,
					link: null
				},

				ContextPopup = function () {
					var self = this,
						ui;

					Popup.call(self);

					// set options
					self.options = objectUtils.merge(self.options, defaults);

					// set ui
					ui = self._ui || {};
					ui.arrow = null;
					self._ui = ui;
				},

				/**
				 * @property {Object} classes Dictionary for popup related css class names
				 * @member ns.widget.core.Popup
				 * @static
				 */
				CLASSES_PREFIX = "ui-popup",
				classes = objectUtils.merge({}, Popup.classes, {
					context: "ui-ctxpopup",
					contextOverlay: "ui-ctxpopup-overlay",
					arrow: "ui-arrow",
					arrowDir: CLASSES_PREFIX + "-arrow-"
				}),

				/**
				 * @property {Object} events Dictionary for popup related events
				 * @member ns.widget.core.Popup
				 * @static
				 */
				/* eslint-disable camelcase */
				// we can't change this in this moment because this is part of API
				events = objectUtils.merge({}, Popup.events, {
					before_position: "beforeposition"
				}),
				/* eslint-enable camelcase */

				positionTypes = {
					WINDOW: "window",
					ORIGIN: "origin",
					ABSOLUTE: "absolute"
				},

				prototype = new Popup();

			ContextPopup.defaults = objectUtils.merge({}, Popup.defaults, defaults);
			ContextPopup.classes = classes;
			ContextPopup.events = events;
			ContextPopup.positionTypes = positionTypes;

			/**
			 * Build structure of Popup widget
			 * @method _build
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @protected
			 * @member ns.widget.core.Popup
			 */
			prototype._build = function (element) {
				var self = this,
					ui = self._ui,
					arrow;

				// build elements of popup
				PopupPrototype._build.call(self, element);

				// set class for element
				element.classList.add(classes.popup);

				// create arrow
				arrow = document.createElement("div");
				arrow.appendChild(document.createElement("span"));
				arrow.classList.add(classes.arrow);
				ui.arrow = arrow;

				// add arrow to popup element
				element.appendChild(arrow);

				return element;
			};

			/**
			 * Init widget
			 * @method _init
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._init = function (element) {
				var self = this,
					ui = self._ui;

				PopupPrototype._init.call(this, element);

				ui.arrow = ui.arrow || element.querySelector("." + classes.arrow);
			};

			/**
			 * Layouting popup structure
			 * @method layout
			 * @member ns.widget.core.ContextPopup
			 * @param {HTMLElement} element
			 */
			prototype._layout = function (element) {
				var self = this;

				this._reposition();
				PopupPrototype._layout.call(self, element);
			};

			/**
			 * Set position and size of popup.
			 * @method _reposition
			 * @param {Object} options
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._reposition = function (options) {
				var self = this,
					element = self.element,
					ui = self._ui,
					elementClassList = element.classList;

				options = objectUtils.merge({}, self.options, options);

				self.trigger(events.before_position, null, false);

				elementClassList.add(classes.build);

				// set height of content
				self._setContentHeight();

				// set class for contextpopup
				if ((options.positionTo === "origin") && ui.overlay) {
					ui.overlay.classList.add(classes.contextOverlay);
				}

				// set position of popup
				self._placementCoords(options);

				elementClassList.remove(classes.build);

			};

			/**
			 * Find the best position of context popup.
			 * @method findBestPosition
			 * @param {ns.widget.core.ContextPopup} self
			 * @param {HTMLElement} clickedElement
			 * @private
			 * @member ns.widget.core.ContextPopup
			 */
			function findBestPosition(self, clickedElement) {
				var options = self.options,
					arrowsPriority = options.arrow.split(","),
					element = self.element,
					windowWidth = window.innerWidth,
					windowHeight = window.innerHeight,
					popupWidth = domUtils.getElementWidth(element, "outer"),
					popupHeight = domUtils.getElementHeight(element, "outer"),
					// offset coordinates of clicked element
					clickElementRect = clickedElement.getBoundingClientRect(),
					clickElementOffsetX = clickElementRect.left,
					clickElementOffsetY = clickElementRect.top,
					// width of visible part of clicked element
					clickElementOffsetWidth = Math.min(clickElementRect.width,
						windowWidth - clickElementOffsetX),
					// height of visible part of clicked element
					clickElementOffsetHeight = Math.min(clickElementRect.height,
						windowHeight - clickElementOffsetY),
					// params for all types of popup
					// "l" - popup with arrow on the left side, "r" - right, "b" - bottom, "t" - top
					// dir - this letter is added as a suffix of class to popup's element
					// fixedPositionField - specifies which coordinate is changed for this type of popup
					// fixedPositionFactor - factor, which specifies if size should be added or subtracted
					// size - available size, which is needed for this type of popup (width or height)
					// max - maximum size of available place
					params = {
						"l": {
							dir: "l", fixedPositionField: "x", fixedPositionFactor: 1,
							size: popupWidth, max: clickElementOffsetX
						},
						"r": {
							dir: "r", fixedPositionField: "x", fixedPositionFactor: -1,
							size: popupWidth, max: windowWidth - clickElementOffsetX - clickElementOffsetWidth
						},
						"b": {
							dir: "b", fixedPositionField: "y", fixedPositionFactor: -1,
							size: popupHeight, max: clickElementOffsetY
						},
						"t": {
							dir: "t", fixedPositionField: "y", fixedPositionFactor: 1,
							size: popupHeight, max: windowHeight - clickElementOffsetY - clickElementOffsetHeight
						}
					},
					bestDirection,
					direction,
					bestOffsetInfo;

				// set value of bestDirection on the first possible type or top
				bestDirection = params[arrowsPriority[0]] || params.t;

				arrowsPriority.forEach(function (key) {
					var param = params[key],
						paramMax = param.max;

					if (!direction) {
						if (param.size < paramMax) {
							direction = param;
						} else if (paramMax > bestDirection.max) {
							bestDirection = param;
						}
					}
				});

				if (!direction) {
					direction = bestDirection;
					if (direction.fixedPositionField === "x") {
						popupWidth = direction.max;
					} else {
						popupHeight = direction.max;
					}
				}

				// info about the best position without taking into account type of popup
				bestOffsetInfo = {
					x: clickElementOffsetX + clickElementOffsetWidth / 2 - popupWidth / 2,
					y: clickElementOffsetY + clickElementOffsetHeight / 2 - popupHeight / 2,
					w: popupWidth,
					h: popupHeight,
					dir: direction.dir
				};

				// check type of popup and correct value for "fixedPositionField" coordinate
				bestOffsetInfo[direction.fixedPositionField] +=
					(direction.fixedPositionField === "x" ?
						(popupWidth + clickElementOffsetWidth) * direction.fixedPositionFactor :
						(popupHeight + clickElementOffsetHeight) * direction.fixedPositionFactor) / 2 +
					options.distance * direction.fixedPositionFactor;

				// fix min/max position
				bestOffsetInfo.x = bestOffsetInfo.x < 0 ? 0 : bestOffsetInfo.x + bestOffsetInfo.w > windowWidth ? windowWidth - bestOffsetInfo.w : bestOffsetInfo.x;
				bestOffsetInfo.y = bestOffsetInfo.y < 0 ? 0 : bestOffsetInfo.y + bestOffsetInfo.h > windowHeight ? windowHeight - bestOffsetInfo.h : bestOffsetInfo.y;

				return bestOffsetInfo;
			}

			/**
			 * Find the best position of arrow.
			 * @method adjustedPositionAndPlacementArrow
			 * @param {ns.widget.core.ContextPopup} self
			 * @param {Object} bestRectangle
			 * @param {number} x
			 * @param {number} y
			 * @private
			 * @member ns.widget.core.ContextPopup
			 */
			function adjustedPositionAndPlacementArrow(self, bestRectangle, x, y) {
				var ui = self._ui,
					wrapper = ui.wrapper,
					arrow = ui.arrow,
					popupElement = self.element,
					arrowStyle = arrow.style,
					windowWidth = window.innerWidth,
					windowHeight = window.innerHeight,
					wrapperRect = wrapper.getBoundingClientRect(),
					arrowHalfWidth = arrow.offsetWidth / 2,
					popupProperties = {
						"padding-top": 0,
						"padding-bottom": 0,
						"padding-left": 0,
						"padding-right": 0,
						"border-top-width": 0,
						"border-left-width": 0,
						"box-sizing": null
					},
					wrapperProperties = {
						"margin-top": 0,
						"margin-bottom": 0,
						"margin-left": 0,
						"margin-right": 0,
						"padding-top": 0,
						"padding-bottom": 0,
						"padding-left": 0,
						"padding-right": 0
					},
					margins,
					params = {
						"t": {pos: x, min: "left", max: "right", posField: "x", valField: "w", styleField: "left"},
						"b": {pos: x, min: "left", max: "right", posField: "x", valField: "w", styleField: "left"},
						"l": {pos: y, min: "top", max: "bottom", posField: "y", valField: "h", styleField: "top"},
						"r": {pos: y, min: "top", max: "bottom", posField: "y", valField: "h", styleField: "top"}
					},
					param = params[bestRectangle.dir],
					surplus,
					addPadding;

				domUtils.extractCSSProperties(popupElement, popupProperties);
				domUtils.extractCSSProperties(wrapper, wrapperProperties);
				addPadding = popupProperties["box-sizing"] === "border-box";
				margins = {
					"t": popupProperties["padding-top"] + wrapperProperties["margin-top"] + wrapperProperties["padding-top"],
					"b": popupProperties["padding-bottom"] + wrapperProperties["margin-bottom"] + wrapperProperties["padding-bottom"],
					"l": popupProperties["padding-left"] + wrapperProperties["margin-left"] + wrapperProperties["padding-left"],
					"r": popupProperties["padding-right"] + wrapperProperties["margin-right"] + wrapperProperties["padding-right"]
				};

				// value of coordinates of proper edge of wrapper
				wrapperRect = {
					// x-coordinate of left edge
					left: margins.l + bestRectangle.x,
					// x-coordinate of right edge
					right: margins.l + wrapperRect.width + bestRectangle.x,
					// y-coordinate of top edge
					top: margins.t + bestRectangle.y,
					// y-coordinate of bottom edge
					bottom: wrapperRect.height + margins.t + bestRectangle.y
				};

				if (wrapperRect[param.min] > param.pos - arrowHalfWidth) {
					surplus = bestRectangle[param.posField];
					if (surplus > 0) {
						bestRectangle[param.posField] = Math.max(param.pos - arrowHalfWidth, 0);
						param.pos = bestRectangle[param.posField] + arrowHalfWidth;
					} else {
						param.pos = wrapperRect[param.min] + arrowHalfWidth;
					}
				} else if (wrapperRect[param.max] < param.pos + arrowHalfWidth) {
					surplus = (param.valField === "w" ? windowWidth : windowHeight) -
						(bestRectangle[param.posField] + bestRectangle[param.valField]);
					if (surplus > 0) {
						bestRectangle[param.posField] += Math.min(surplus, (param.pos + arrowHalfWidth) - wrapperRect[param.max]);
						param.pos = bestRectangle[param.posField] + bestRectangle[param.valField] - arrowHalfWidth;
					} else {
						param.pos = wrapperRect[param.max] - arrowHalfWidth;
					}
				}

				arrowStyle[param.styleField] = (param.pos - arrowHalfWidth - bestRectangle[param.posField] - (addPadding ? popupProperties["border-" + param.styleField + "-width"] : 0)) + "px";

				return bestRectangle;
			}

			/**
			 * Set top, left and margin for popup's container.
			 * @method _placementCoordsWindow
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._placementCoordsWindow = function (element) {
				var elementStyle = element.style,
					elementWidth = element.offsetWidth;

				elementStyle.bottom = "0px";
				elementStyle.left = "50%";
				elementStyle.marginLeft = -(elementWidth / 2) + "px";
			};

			/**
			 * Set top, left and margin for popup's container.
			 * @method _placementCoordsAbsolute
			 * @param {HTMLElement} element
			 * @param {number} x
			 * @param {number} y
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._placementCoordsAbsolute = function (element, x, y) {
				var elementStyle = element.style,
					elementWidth = element.offsetWidth,
					elementHeight = element.offsetHeight;

				elementStyle.top = y + "px";
				elementStyle.left = x + "px";
				elementStyle.marginTop = -(elementHeight / 2) + "px";
				elementStyle.marginLeft = -(elementWidth / 2) + "px";
			};

			/**
			 * Find clicked element.
			 * @method _findClickedElement
			 * @param {number} x
			 * @param {number} y
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._findClickedElement = function (x, y) {
				return document.elementFromPoint(x, y);
			};

			/**
			 * Emulate position of event for clicked element.
			 * @method emulatePositionOfClick
			 * @param {string} bestDirection direction of arrow
			 * @param {HTMLElement} clickedElement
			 * @private
			 * @member ns.widget.core.ContextPopup
			 */
			function emulatePositionOfClick(bestDirection, clickedElement) {
				var clickedElementRect = clickedElement.getBoundingClientRect(),
					position = {};

				switch (bestDirection) {
					case "l":
						// the arrow will be on the left edge of container, so x-coordinate
						// should have value equals to the position of right edge of clicked element
						position.x = clickedElementRect.right;
						// y-coordinate should have value equals to the position of top edge of clicked
						// element plus half of its height
						position.y = clickedElementRect.top + clickedElementRect.height / 2;
						break;
					case "r":
						// the arrow will be on the right edge of container
						position.x = clickedElementRect.left;
						position.y = clickedElementRect.top + clickedElementRect.height / 2;
						break;
					case "t":
						// the arrow will be on the top edge of container
						position.x = clickedElementRect.left + clickedElementRect.width / 2;
						position.y = clickedElementRect.bottom;
						break;
					case "b":
						// the arrow will be on the bottom edge of container
						position.x = clickedElementRect.left + clickedElementRect.width / 2;
						position.y = clickedElementRect.top;
						break;
				}
				return position;
			}

			prototype._placementCoordsOrigin = function (clickedElement, options) {
				var self = this,
					element = self.element,
					elementStyle = element.style,
					elementClassList = element.classList,
					x = options.x,
					y = options.y,
					bestRectangle,
					emulatedPosition,
					arrowType,
					elementHeight;

				elementClassList.add(classes.context);

				elementHeight = element.offsetHeight;
				bestRectangle = findBestPosition(self, clickedElement);

				arrowType = bestRectangle.dir;
				elementClassList.add(classes.arrowDir + arrowType);
				self._ui.arrow.setAttribute("type", arrowType);

				if ((typeof x !== "number" && typeof y !== "number") || self.options.positionOriginCenter) {
					// if we found element, which was clicked, but the coordinates of event
					// was not available, we have to count these coordinates to the center of proper edge of element.
					emulatedPosition = emulatePositionOfClick(arrowType, clickedElement);
					x = emulatedPosition.x;
					y = emulatedPosition.y;
				}
				bestRectangle = adjustedPositionAndPlacementArrow(self, bestRectangle, x, y);

				if (elementHeight > bestRectangle.h) {
					self._setContentHeight(bestRectangle.h);
				}

				elementStyle.left = bestRectangle.x + "px";
				elementStyle.top = bestRectangle.y + "px";
			};

			prototype._placementCoordsElement = function (clickedElement) {
				var self = this,
					element = self.element,
					elementStyle = element.style,
					bestRectangle,
					elementHeight;

				element.classList.add(classes.context);

				elementHeight = element.offsetHeight;
				bestRectangle = findBestPosition(self, clickedElement);

				if (elementHeight > bestRectangle.h) {
					self._setContentHeight(bestRectangle.h);
				}

				elementStyle.left = bestRectangle.x + "px";
				elementStyle.top = bestRectangle.y + "px";
			};

			/**
			 * Find and set the best position for popup.
			 * @method _placementCoords
			 * @param {Object} options
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._placementCoords = function (options) {
				var self = this,
					positionTo = options.positionTo,
					x = options.x,
					y = options.y,
					element = self.element,
					clickedElement,
					link;

				switch (positionTo) {
					case positionTypes.ORIGIN:
						// if we know x-coord and y-coord, we open the popup with arrow
						link = options.link;
						if (link) {
							if (typeof link === "string") {
								clickedElement = document.getElementById(link);
							} else if (typeof link === "object") {
								clickedElement = link;
							}
						} else if (typeof x === "number" && typeof y === "number") {
							clickedElement = self._findClickedElement(x, y);
						}
						if (clickedElement) {
							self._placementCoordsOrigin(clickedElement, options);
							return;
						}
						break;
					case positionTypes.WINDOW:
						self._placementCoordsWindow(element);
						return;
					case positionTypes.ABSOLUTE:
						if (typeof x === "number" && typeof y === "number") {
							self._placementCoordsAbsolute(element, x, y);
							return;
						}
						break;
					default:
						// there is possible, that element or its id was given
						if (typeof positionTo === "string") {
							try {
								clickedElement = document.querySelector(options.positionTo);
							} catch (e) {
							}
						} else if (typeof positionTo === "object") {
							clickedElement = positionTo;
						}
						if (clickedElement) {
							self._placementCoordsElement(clickedElement, options);
							return;
						}
						break;
				}

				// if there was problem with setting position of popup, we set its position to window
				self._placementCoordsWindow(element);
			};

			/**
			 * Set height for popup's container.
			 * @method _setContentHeight
			 * @param {number} maxHeight
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._setContentHeight = function (maxHeight) {
				var self = this,
					element = self.element,
					content = self._ui.content,
					contentStyle,
					contentHeight,
					elementOffsetHeight;

				if (content) {
					contentStyle = content.style;

					if (contentStyle.height || contentStyle.minHeight) {
						contentStyle.height = "";
						contentStyle.minHeight = "";
					}

					maxHeight = maxHeight || window.innerHeight;

					contentHeight = content.offsetHeight;
					elementOffsetHeight = element.offsetHeight;

					if (elementOffsetHeight > maxHeight) {
						contentHeight -= (elementOffsetHeight - maxHeight);
						contentStyle.height = contentHeight + "px";
						contentStyle.minHeight = contentHeight + "px";
					}
				}
			};

			/**
			 * Hide popup.
			 * @method _onHide
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._onHide = function () {
				var self = this,
					ui = self._ui,
					element = self.element,
					elementClassList = element.classList,
					arrow = ui.arrow;

				elementClassList.remove(classes.context);
				["l", "r", "b", "t"].forEach(function (key) {
					elementClassList.remove(classes.arrowDir + key);
				});

				// we remove styles for element, which are changed
				// styles for container, header and footer are left unchanged
				if (element) {
					element.removeAttribute("style");
				}
				if (arrow) {
					arrow.removeAttribute("style");
				}

				PopupPrototype._onHide.call(self);
			};

			/**
			 * Destroy popup.
			 * @method _destroy
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._destroy = function () {
				var self = this,
					ui = self._ui,
					arrow = ui.arrow;

				PopupPrototype._destroy.call(self);

				if (arrow && arrow.parentNode) {
					arrow.parentNode.removeChild(arrow);
				}

				ui.arrow = null;
			};

			/**
			 * Set new position for popup.
			 * @method reposition
			 * @param {Object} options
			 * @param {number} options.x
			 * @param {number} options.y
			 * @param {string} options.positionTo
			 * @member ns.widget.core.ContextPopup
			 */
			prototype.reposition = function (options) {
				if (this._isActive()) {
					this._reposition(options);
				}
			};

			/**
			 * Refresh structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.core.ContextPopup
			 */
			prototype._refresh = function () {
				if (this._isActive()) {
					PopupPrototype._refresh.call(this);
					this.reposition(this.options);
				}
			};

			ContextPopup.prototype = prototype;
			ns.widget.core.ContextPopup = ContextPopup;

			engine.defineWidget(
				"Popup",
				"[data-role='popup'], .ui-popup",
				[
					"open",
					"close",
					"reposition"
				],
				ContextPopup,
				"core",
				true
			);

			// @remove
			// THIS IS ONLY FOR COMPATIBILITY
			ns.widget.popup = ns.widget.Popup;

			}(window, window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * # Listview Widget
 * Shows a list view.
 *
 * The list widget is used to display, for example, navigation data, results, and data entries. The following table describes the supported list classes.
 *
 * ## Default selectors
 *
 * Default selector for listview widget is class *ui-listview*.
 *
 * To add a list widget to the application, use the following code:
 *
 * ### List with basic items
 *
 * You can add a basic list widget as follows:
 *
 *      @example template
 *         <ul class="ui-listview">
 *             <li><span>List Item</span></li>
 *         </ul>
 *
 * ### List with link items
 *
 * You can add a list widget with a link and press effect that allows the user to click each list item as follows:
 *
 *      @example tau-listview-with-link
 *         <ul class="ui-listview">
 *             <li>
 *                 <a href="#">List Item</a>
 *             </li>
 *         </ul>
 *
 * ## JavaScript API
 *
 * Listview widget hasn't JavaScript API.
 *
 * @class ns.widget.core.Listview
 * @component-selector .ui-listview
 * @components-constraint 'listitem'
 * @component-type container-component
 * @extends ns.widget.BaseWidget
 */
/**
 * Listview with gradient background
 * @style ui-colored-list
 * @member ns.widget.core.Listview
 * @mobile
 */
/**
 * Enable snap list style
 * @style ui-snap-listview
 * @member ns.widget.core.Listview
 * @wearable
 */
/**
 *
 * @style ui-snap-listview
 * @member ns.widget.core.Listview
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				engine = ns.engine,
				Listview = function () {
				},
				classes = {
					LISTVIEW: "ui-listview",
					DETAILS: "ui-details"
				},
				prototype = new BaseWidget();

			Listview.classes = classes;

			/**
			 * build Listview
			 * @method _build
			 * @private
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @member ns.widget.core.Listview
			 */
			prototype._build = function (element) {
				element.classList.add(classes.LISTVIEW);
				return element;
			};

			Listview.prototype = prototype;
			ns.widget.core.Listview = Listview;

			engine.defineWidget(
				"Listview",
				"[data-role='listview'], .ui-listview",
				[],
				Listview,
				"core"
			);
			}(window.document, ns));

/**
 * # List Item
 *
 * You can add a basic list item as follows:
 *
 *      @example template
 *         <li><span>List Item</span></li>
 *
 *
 * @class ns.widget.core.ListItem
 * @component-selector .ui-listview li
 * @components-constraint 'text', 'image', 'checkbox', 'button', 'radio', 'toggleswitch', 'processing'
 * @component-type container-component
 * @extends ns.widget.BaseWidget
 */
/**
 *
 * @style ui-li-anchor
 * @member ns.widget.core.ListItem
 */
/**
 * Subtext for item
 * @style li-text-sub
 * @selector  > *
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Subtext for item
 * @style ui-li-sub-text
 * @selector  > *
 * @member ns.widget.core.ListItem
 * @wearable
 */
/**
 * Item with button on the right
 * @style li-has-right-btn
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Item with circular button on the right
 * @style li-has-right-circle-btn
 * @selector
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Item with thumbnail on the left
 * @style li-has-thumb
 * @selector
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Thumbnail inside item
 * @style li-thumb
 * @selector .li-has-thumb > *
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Item with checkbox
 * @style li-has-checkbox
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Item with radio button
 * @style li-has-radio
 * @selector
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Item with progressbar
 * @style li-has-progress
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Item with multiline
 * @style li-has-multiline
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Second subtext for multiline item positioned under the first one
 * @style ui-text-sub2
 * @selector .li-has-multiline > *
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Subtext for multiline item positioned on the right
 * @style ui-text-sub3
 * @selector .li-has-multiline > *
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 * Item with 2 lines
 * @style li-has-2line
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Item with 3 lines
 * @style li-has-3-lines
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 *
 * @style li-icon-sub
 * @selector  .li-text-sub > *
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 *
 * @style li-icon-sub
 * @selector .li-text-sub3 > *
 * @member ns.widget.core.ListItem
 * @mobile
 */
/**
 *
 * @style ui-li-static
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Expandable item
 * @style ui-expandable
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * Divider item
 * @style ui-group-index
 * @mobile
 * @member ns.widget.core.ListItem
 */
/**
 * List divider
 * @style ui-listview-divider
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Marquee item
 * @style ui-marquee
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Marquee item with blurry effect
 * @style ui-marquee-gradient
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Item with action icon
 * @style ui-li-has-action-icon
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Text for action item
 * @style ui-action-text
 * @selector .ui-li-has-action-icon > *
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Setting icon for action item
 * @style ui-action-setting
 * @selector .ui-li-has-action-icon > *
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Delete icon for action item
 * @style ui-action-delete
 * @selector .ui-li-has-action-icon > *
 * @wearable
 * @member ns.widget.core.ListItem
 */
/**
 * Adding icon for action item
 * @style ui-action-add
 * @selector .ui-li-has-action-icon > *
 * @wearable
 * @member ns.widget.core.ListItem
 */
;
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* global define, ns */
/**
 * #Button
 * Shows a control that can be used to generate an action event.
 *
 * The button component shows on the screen a control that you can use to generate an action event
 * when it is pressed and released. The component is coded with standard HTML anchor and input
 * elements.
 *
 * The following table describes the supported button classes.
 *
 * ## Default selectors
 * The button widget shows a control on the screen that you can use to generate an action event
 * when it is pressed and released.
 * This widget is coded with standard HTML anchor and input elements.
 *
 * Default selector for buttons is class *ui-btn*
 *
 * ### HTML Examples
 *
 * #### Standard button
 * To add a button widget to the application, use the following code:
 *
 *      @example
 *      <button type="button" class="ui-btn">Button</button>
 *      <a href="#" class="ui-btn">Button</a>
 *      <input type="button" class="ui-btn" value="Button" />
 *
 * #### Inline button
 *
 *      @example
 *      <input type="button" class="ui-btn ui-inline" value="Button" />
 *
 * #### Multiline text button
 *
 *      @example
 *      <a href="#" class="ui-btn ui-multiline ui-inline">A Button<br />Icon</a>
 *
 * ## Options
 *
 * ### Icons
 * Buttons can contains icons
 *
 * Creates an icon button in the header area is permitted but in content or footer area creating
 * icon are not supported.
 *
 * To use menu icon in header add class *ui-more* to the button element:
 *
 *      @example
 *      <button class="ui-btn ui-more ui-icon-overflow">More Options</button>
 *
 * Samsung Wearable Web UI Framework supports 3 icon css styles:
 *
 *  - ui-icon-detail
 *  - ui-icon-overflow
 *  - ui-icon-selectall
 *
 * ### Disabled
 *
 * If you want to make disabled button, add attribute *disabled* in button tag:
 *
 *      @example
 *      <button class="ui-btn" disabled="disabled">Button disabled</button>
 *
 * ### Inline
 *
 * If you want to make inline button, add class *ui-inline* to button element:
 *
 *      @example
 *      <button class="ui-btn ui-inline">Inline button</button>
 *
 * ### Multiline
 *
 * If you want to make multiline text button, add *ui-multiline* class
 *
 *      @example
 *      <button class="ui-btn ui-multiline">Multiline button</button>
 *
 * ### Color theme
 *
 * To optimize color support for the Samsung Wearable, the following styles below are supported:
 *
 * <table>
 *  <tr>
 *      <th>Class</th>
 *      <th>Default</th>
 *      <th>Press</th>
 *      <th>Disable</th>
 *  </tr>
 *  <tr>
 *      <td>ui-color-red</td>
 *      <td>#ce2302</td>
 *      <td>#dd654e</td>
 *      <td>#3d0a0a</td>
 *  </tr>
 *  <tr>
 *      <td>ui-color-orange</td>
 *      <td>#ed8600</td>
 *      <td>#f0aa56</td>
 *      <td>#462805</td>
 *  </tr>
 *  <tr>
 *      <td>ui-color-green</td>
 *      <td>#64a323</td>
 *      <td>#92be5e</td>
 *      <td>#1e3108</td>
 *  </tr>
 * </table>
 *
 * ### Button Group
 *
 * You can group buttons in columns or rows. The following table lists the supported button column
 * and row classes.
 *
 * <table>
 *  <tr>
 *      <th>Class</th>
 *      <th>Description</th>
 *  </tr>
 *  <tr>
 *      <td>ui-grid-col-1</td>
 *      <td>Defines the button column width as 100% of the screen.</td>
 *  </tr>
 *  <tr>
 *      <td>ui-grid-col-2</td>
 *      <td>Defines the button column width as 50% of the screen.</td>
 *  </tr>
 *  <tr>
 *      <td>ui-grid-col-3</td>
 *      <td>Defines the button column width as 33% of the screen.</td>
 *  </tr>
 *  <tr>
 *      <td>ui-grid-row</td>
 *      <td>Arranges the buttons in a row.</td>
 *  </tr>
 * </table>
 *
 * To implement the button groups, use the following code:
 *
 * #### For columns:
 *
 *      @example
 *      <div class="ui-grid-col-3" style="height:76px">
 *          <button type="button" class="ui-btn">Button Circle</button>
 *          <a href="#" class="ui-btn ui-color-red" >A Button Circle</a>
 *          <input type="button" class="ui-btn ui-color-orange" value="Value" />
 *      </div>
 *
 * #### For rows:
 *
 *      @example
 *      <div class="ui-grid-row">
 *          <button type="button" class="ui-btn">Button Circle</button>
 *          <a href="#" class="ui-btn ui-color-red" >A Button Circle</a>
 *          <input type="button" class="ui-btn ui-color-orange" value="Value" />
 *      </div>
 *
 * @since 2.0
 * @class ns.widget.core.Button
 * @component-selector button, [data-role="button"], .ui-btn, input[type="button"]
 * @component-type standalone-component
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
				var BaseWidget = ns.widget.BaseWidget,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				engine = ns.engine,
				/**
				 * Create instance of widget
				 * @constructor
				 * @member ns.widget.core.Button
				 */
				utilDOM = ns.util.DOM,
				classes = {
					/**
					 * Standard button
					 * @style ui-btn
					 * @member ns.widget.core.Button
					 */
					BTN: "ui-btn",
					/**
					 * Disabled button
					 * @style ui-state-disabled
					 * @member ns.widget.core.Button
					 */
					DISABLED: "ui-state-disabled",
					/**
					 * Make inline button
					 * @style ui-inline
					 * @member ns.widget.core.Button
					 */
					INLINE: "ui-inline",
					/**
					 * Creates an icon button
					 * @style ui-btn-icon
					 * @member ns.widget.core.Button
					 */
					BTN_ICON: "ui-btn-icon",
					ICON_PREFIX: "ui-icon-",
					/**
					 * Creates a circle icon button
					 * @style ui-btn-circle
					 * @member ns.widget.core.Button
					 */
					BTN_CIRCLE: "ui-btn-circle",
					/**
					 * Creates a button without background
					 * @style ui-btn-nobg
					 * @member ns.widget.core.Button
					 */
					BTN_NOBG: "ui-btn-nobg",
					BTN_ICON_ONLY: "ui-btn-icon-only",
					BTN_TEXT: "ui-btn-text",
					/**
					 * Creates a button widget with light text
					 * @style ui-btn-text-light
					 * @member ns.widget.core.Button
					 */
					BTN_TEXT_LIGHT: "ui-btn-text-light",
					/**
					 * Creates a button widget with dark text
					 * @style ui-btn-text-dark
					 * @member ns.widget.core.Button
					 */
					BTN_TEXT_DARK: "ui-btn-text-dark",
					FOCUS: "ui-btn-focus",
					/**
					 * Change background color of button to red
					 * @style ui-color-red
					 * @preview <span style="background-color: red;">&nbsp;</span>
					 * @member ns.widget.core.Button
					 */
					/**
					 * Button for header
					 * @style ui-more
					 * @member ns.widget.core.Button
					 */
					/**
					 * Button more for header
					 * @style ui-icon-overflow
					 * @member ns.widget.core.Button
					 */
					/**
					 * Button details for header
					 * @style ui-icon-detail
					 * @member ns.widget.core.Button
					 */
					/**
					 * Button select all for header
					 * @style ui-icon-selectall
					 * @member ns.widget.core.Button
					 */
					/**
					 * Icon only style
					 * @style ui-btn-icon-only
					 * @member ns.widget.core.Button
					 */
					BTN_ICON_POSITION_PREFIX: "ui-btn-icon-",
					/**
					 * Creates a button widget with position in middle
					 * @style ui-btn-text-middle
					 * @member ns.widget.core.Button
					 */
					BTN_ICON_MIDDLE: "ui-btn-icon-middle"
				},
				MIN_SIZE = 32,
				MAX_SIZE = 230,
				defaultOptions = {
					// common options
					inline: true,
					icon: null,
					disabled: false,
					// mobile options
					style: null,
					iconpos: "left",
					size: null,
					middle: false,
					value: null,
					enabledIcon: false
				},
				Button = function () {
					var self = this;

					BaseKeyboardSupport.call(self);
					self.options = {};
					self._classesPrefix = classes.BTN + "-";
				},
				buttonStyle = {
					CIRCLE: "circle",
					TEXTLIGHT: "light",
					TEXTDARK: "dark",
					NOBG: "nobg",
					ICON_MIDDLE: "icon-middle"
				},

				prototype = new BaseWidget();

			Button.classes = classes;
			Button.prototype = prototype;

			/**
			 * Configure button
			 * @method _configure
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._configure = function () {
				/**
				 * Object with default options
				 * @property {Object} options
				 * @property {boolean} [options.inline=false] If is set true then button has inline style
				 * @property {?string} [options.icon=null] Set icon class name for button
				 * @property {boolean} [options.disabled=false] Disable button if is set to true
				 * @property {"left"|"right"|"button"|"top"} [options.iconpos="left"] Set icon position
				 * @member ns.widget.core.Button
				 * @static
				 */
				/**
				 * "circle" Make circle button
				 * "nobg" Make button without background
				 * @property {null|"circle"|"nobg"} [options.style=null] Set style of button
				 * @member ns.widget.core.Button
				 * @static
				 */
				this.options = ns.util.object.copy(defaultOptions);
			};

			/**
			 * Reads class based on name conversion option value
			 *
			 * @method _readWidgetSpecyficOptionFromElementClassname
			 * @param {HTMLElement} element Main element of widget
			 * @param {string} name Name of option which should be used
			 * @return {boolean} If option value was successfully read
			 * @member ns.widget.BaseWidget
			 * @protected
			 */
			prototype._readWidgetSpecyficOptionFromElementClassname = function (element, name) {
				var options = this.options,
					classList = element.classList;

				switch (name) {
					case "enabledIcon" :
						if (classList.contains(classes.BTN_ICON)) {
							options.enabledIcon = true;
							return true;
						}
						break;
				}
				return false;
			};

			/**
			 * Set style option
			 * @method _setStyle
			 * @param {HTMLElement} element
			 * @param {string} style
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setStyle = function (element, style) {
				var options = this.options,
					buttonClassList = element.classList,
					change = false;

				style = style || options.style;

				buttonClassList.remove(classes.BTN_CIRCLE);
				buttonClassList.remove(classes.BTN_NOBG);
				buttonClassList.remove(classes.BTN_TEXT_LIGHT);
				buttonClassList.remove(classes.BTN_TEXT_DARK);

				switch (style) {
					case buttonStyle.CIRCLE:
						buttonClassList.add(classes.BTN_CIRCLE);
						change = true;
						break;
					case buttonStyle.NOBG:
						buttonClassList.add(classes.BTN_NOBG);
						change = true;
						break;
					case buttonStyle.TEXTLIGHT:
						buttonClassList.add(classes.BTN_TEXT_LIGHT);
						change = true;
						break;
					case buttonStyle.TEXTDARK:
						buttonClassList.add(classes.BTN_TEXT_DARK);
						change = true;
						break;
					default:
				}

				if (change) {
					options.style = style;

					this._saveOption("style", style);
				}
			};

			/**
			 * Set inline option
			 * @method _setInline
			 * @param {HTMLElement} element
			 * @param {boolean} inline
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setInline = function (element, inline) {
				var options = this.options;

				if (inline === undefined) {
					inline = element.getAttribute("data-inline");
					inline = (inline === "false") ? false : !!inline;
				}

				element.classList.toggle(classes.INLINE, inline);
				options.inline = inline;

				this._saveOption("inline", inline);
			};

			/**
			 * Set icon option
			 * @method _setIcon
			 * @param {HTMLElement} element
			 * @param {string} icon
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setIcon = function (element, icon) {
				var self = this,
					classList = element.classList,
					options = self.options,
					styles = {},
					urlIcon,
					iconCSSRule = self._iconCSSRule;

				element.className = element.className
					.replace(RegExp("(\\" + classes.ICON_PREFIX + "([a-z-]*))", "g"), "");

				icon = icon || options.icon;
				options.icon = icon;

				if (icon) { // icon setting enables icon style
					options.enabledIcon = true;
				}

				self._saveOption("icon", icon);

				if (options.enabledIcon) {
					classList.add(classes.BTN_ICON);
					if (icon) {
						if (icon.indexOf(".") === -1) {
							classList.add(classes.ICON_PREFIX + icon);
							self._setTitleForIcon(element);
							if (iconCSSRule) {
								utilDOM.removeCSSRule(iconCSSRule);
							}
						} else {
							// if icon is file path
							urlIcon = "url(\"" + icon + "\")";
							styles["-webkit-mask-image"] = urlIcon;
							styles["mask-image"] = urlIcon;
							self._iconCSSRule = utilDOM.setStylesForPseudoClass("#" + element.id, "after", styles);
						}
					} // else - icon can be defined from app css styles

					// remove button text class if text content is empty
					if (!element.textContent.trim()) {
						classList.remove(classes.BTN_TEXT);
					}
				} else {
					classList.remove(classes.BTN_ICON);
					if (iconCSSRule) {
						utilDOM.removeCSSRule(iconCSSRule);
					}
				}
			};

			/**
			 * Set iconpos option
			 * @method _setIconpos
			 * @param {HTMLElement} element
			 * @param {string} iconpos
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setIconpos = function (element, iconpos) {
				var options = this.options,
					style = options.style,
					innerTextLength = element.textContent.trim().length || (element.value ? element.value.length : 0);

				element.classList.remove(classes.BTN_ICON_POSITION_PREFIX + options.iconpos);
				element.classList.remove(classes.BTN_ICON_ONLY);

				iconpos = iconpos || options.iconpos;

				if (options.icon && style !== buttonStyle.CIRCLE && style !== buttonStyle.NOBG) {
					if (innerTextLength > 0) {
						element.classList.add(classes.BTN_ICON_POSITION_PREFIX + iconpos);
					} else {
						element.classList.add(classes.BTN_ICON_ONLY);
					}
					options.iconpos = iconpos;

					this._saveOption("iconpos", iconpos);
				}
			};

			/**
			 * Set title for button without showing text
			 * @method _setTitleForIcon
			 * @param {HTMLElement|HTMLInputElement|HTMLButtonElement} element
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setTitleForIcon = function (element) {
				var options = this.options,
					buttonText = element.textContent;

				// Add title to element if button not has text.
				if (options.iconpos === "notext" && !element.getAttribute("title")) {
					element.setAttribute("title", buttonText);
					ns.warn("iconpos='notext' is deprecated.");
				}
			};

			prototype._focus = function () {
				var elementClassList;

				if (ns.getConfig("keyboardSupport", false)) {
					elementClassList = this.element.classList;

					elementClassList.add(classes.FOCUS);
					this.element.focus();
				}
			};

			prototype._blur = function () {
				var elementClassList;

				if (ns.getConfig("keyboardSupport", false)) {
					elementClassList = this.element.classList;

					elementClassList.remove(classes.FOCUS);
					this.element.blur();
				}
			};

			/**
			 * Sets button to disabled if element.disabled or element.disabled property is true,
			 * or class is set to ui-state-disabled
			 * @method _setDisabled
			 * @param {HTMLElement} element
			 * @param {boolean} state
			 * @protected
			 */
			prototype._setDisabled = function (element, state) {
				var self = this,
					options = self.options,
					buttonClassList = element.classList;

				if (state === true || options.disabled === true || element.disabled ||
					buttonClassList.contains(classes.DISABLED)) {
					options.disabled = true;
					self._disable(element);
				} else {
					options.disabled = false;
				}

				self._saveOption("disabled", options.disabled);
			};
			/**
			 * Build Button
			 * @method _build
			 * @protected
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @member ns.widget.core.Button
			 */
			prototype._build = function (element) {
				var self = this,
					buttonClassList = element.classList;

				if (!buttonClassList.contains(classes.BTN)) {
					buttonClassList.add(classes.BTN);
				}

				self._setStyle(element);
				self._setInline(element);
				self._setIconpos(element);
				self._setIcon(element);
				self._setSize(element);
				self._setDisabled(element);
				self._setTextButton(element);

				if (!element.hasAttribute("tabindex")) {
					element.setAttribute("tabindex", 0);
				}

				return element;
			};

			/**
			 * Refresh structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._refresh = function () {
				var self = this,
					element = this.element;

				self.options = self._getCreateOptions(element);
				self._build(element);

				return null;
			};

			/**
			 * Get value of button
			 * @method _getValue
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._getValue = function () {
				return this.element.textContent;
			};

			/**
			 * Set size of button
			 * @method _setSize
			 * @param {HTMLElement} element
			 * @param {string|number} value
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setSize = function (element, value) {
				var style = element.style,
					options = this.options,
					size = value || options.size;

				if (size) {
					size = parseInt(size, 10);

					if (size < MIN_SIZE) {
						size = MIN_SIZE;
					}
					if (size > MAX_SIZE) {
						size = MAX_SIZE;
					}
					style.height = size + "px";
					style.width = size + "px";

					// @to do: why size has the same value for width and height
					options.size = size;
				}

			};

			/**
			 * Set text of the button
			 * @method _setTextButton
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setTextButton = function (element) {
				if (element.textContent.trim()) {
					element.classList.add(classes.BTN_TEXT);
				} else {
					element.classList.remove(classes.BTN_TEXT);
				}
			};

			/**
			 * Set value of button
			 * @method _setValue
			 * @param {string} value
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._setValue = function (value) {
				this.element.textContent = value;
			};

			/**
			 * Enable button
			 * @method _enable
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._enable = function (element) {
				var self = this,
					options = self.options;

				if (element) {
					if (element.tagName.toLowerCase() === "button") {
						element.disabled = false;
					}
					if (!this.isCustomElement) {
						element.removeAttribute("disabled");
					}
					element.classList.remove(classes.DISABLED);
					options.disabled = false;

					self._saveOption("disabled", false);
				}
			};

			prototype._bindEvents = function (element) {
				var self = this;

				self._focusCallback = self._focus.bind(self);
				self._blurCallback = self._blur.bind(self);

				element.addEventListener("focus", self._focusCallback);
				element.addEventListener("blur", self._blurCallback);
			};

			prototype._unbindEvents = function (element) {
				var self = this;

				element.removeEventListener("focus", self._focusCallback);
				element.removeEventListener("blur", self._blurCallback);
			};

			/**
			 * Disable button
			 * @method _disable
			 * @param {HTMLElement} element
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._disable = function (element) {
				var options = this.options;

				if (element) {
					if (element.tagName.toLowerCase() === "button") {
						element.disabled = true;
					}
					if (!this.isCustomElement) {
						element.setAttribute("disabled", "disabled");
					}
					element.classList.add(classes.DISABLED);
					options.disabled = true;

					this._saveOption("disabled", true);
				}
			};

			/**
			 * Store widget option value in element as data attribute
			 * @method _saveOption
			 * @param {string} name
			 * @param {*} value
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._saveOption = function (name, value) {
				var self = this,
					element = self.element,
					defaultValue = defaultOptions[name];

				if (element) {
					if (defaultValue !== value) {
						element.dataset[name] = value;
					} else {
						delete element.dataset[name];
					}
				}
			}

			/**
			 * Returns default option value for given name
			 * @method _getDefaultOption
			 * @param {string} optionName
			 * @return {*} default widget option value
			 * @protected
			 * @member ns.widget.core.Button
			 */
			prototype._getDefaultOption = function (optionName) {
				return defaultOptions[optionName];
			}

			ns.widget.core.Button = Button;

			Button.defaultOptions = defaultOptions;

			engine.defineWidget(
				"Button",
				"button, [data-role='button'], .ui-btn, input[type='button']",
				[],
				Button,
				"core"
			);

			engine.defineWidget(
				"inputButton",
				"",
				[],
				Button,
				"core",
				false,
				false,
				HTMLInputElement
			);

			engine.defineWidget(
				"formButton",
				"",
				[],
				Button,
				"core",
				false,
				false,
				HTMLButtonElement
			);

			BaseKeyboardSupport.registerActiveSelector("[data-role='button'], button, [type='button'], [type='submit'], [type='reset'], .ui-button, .ui-btn");

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * #Mobile UI Components
 *
 * The Web UI Framework (called as **TAU**; Tizen Advanced UI framework) provides rich Tizen components that are optimized for the Tizen Web browser.
 *
 * ##UI components list
 *
 * The following table displays the components provided by the Tizen mobile Web UI Framework.
 *
 * @class ns.widget.mobile
 * @seeMore https://developer.tizen.org/dev-guide/2.2.1/org.tizen.web.uiwidget.apireference/html/web_ui_framework.htm "Web UI Framework Reference"
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 */
(function (window, ns) {
	"use strict";
				ns.widget.mobile = ns.widget.mobile || {};
			}(window, ns));

/*global window, ns, define */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true, plusplus: true */
/**
 * #Popup
 * Widget handles creating and managing popup windows.
 *
 * ##Default selectors
 * In default all elements with _data-role=popup_ or CSS class _.ui-popup_ are changed to Tizen WebUI popups.
 *
 * ##HTML Examples
 *
 * ###Create simple popup from div
 *
 *		@example
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *		<!-- link related with popup-->
 *		<a href="#popup">Click to open popup</a>
 *
 * ###Create simple popup positioned to window
 *
 * Popup inherits value of option _positionTo_ from property _data-position-to_ set in link.
 *
 *		@example
 *		<!--definition of link, which opens popup and sets its position-->
 *		<a href="#center_info" data-position-to="window">Click to open popup</a>
 *		<!--definition of popup, which inherits property position from link-->
 *		<div id="center_info" data-role="popup" class="center_info">
 *			<div class="ui-popup-text">
 *				<p>Pop-up dialog box, a child window that blocks user interaction to the parent windows</p>
 *			</div>
 *		</div>
 *
 * ###Create popup with title and button
 *
 *		@example
 *		<a href="#center_title_1btn">Click to open popup</a>
 *		<!--definition of popup with a title and button-->
 *		<div id="center_title_1btn" data-role="popup" class="center_title_1btn">
 *			<div class="ui-popup-title">
 *				<h1>Popup title</h1>
 *			</div>
 *			<div class="ui-popup-text">
 *				Pop-up dialog box, a child window that blocks user interaction to the parent windows
 *			</div>
 *			<div class="ui-popup-button-bg">
 *				<a data-role="button" data-rel="back" data-inline="true">Button</a>
 *			</div>
 *		</div>
 *
 * ###Create popup with menu
 *
 * A menu can be created by placing listview inside a popup.
 *
 *		@example
 *		<a href="#center_liststyle_1btn">Click to open popup</a>
 *		<div id="center_liststyle_1btn" data-role="popup" class="center_liststyle_1btn">
 *			<div class="ui-popup-title">
 *				<h1>Popup title</h1>
 *			</div>
 *			<div class="ui-popup-scroller-bg" data-scroll="y">
 *				<ul data-role="listview" data-icon="1line-textonly">
 *					<li><a href="#">List item 1</a></li>
 *					<li><a href="#">List item 2</a></li>
 *				</ul>
 *			</div>
 *			<div class="ui-popup-button-bg">
 *				<a data-role="button" data-rel="back" data-inline="true">Cancel</a>
 *			</div>
 *		</div>
 *
 * ###Create popup with nested menu
 *
 * A nested menu can be created by placing collapsible-set widget with listview elements.
 *
 *		@example
 *		<a href="#popupNested">Click to open popup</a>
 *		<div id="popupNested" data-role="popup">
 *			<div data-role="collapsible-set" data-collapsed-icon="arrow-r" data-expanded-icon="arrow-d">
 *				<div data-role="collapsible">
 *					<h2>First menu</h2>
 *					<ul data-role="listview">
 *						<li><a href="#" >Item 1</a></li>
 *						<li><a href="#" >Item 2</a></li>
 *					</ul>
 *				</div>
 *				<div data-role="collapsible">
 *					<h2>Second menu</h2>
 *					<ul data-role="listview">
 *						<li><a href="#" >Item 1</a></li>
 *						<li><a href="#" >Item 2</a></li>
 *					</ul>
 *				</div>
 *			</div>
 *		</div>
 *
 * ###Create popup with form
 *
 * A form can be created by placing inputs elements inside popup.
 *
 *		@example
 *		<a href="#textbox_popup">Click to open popup</a>
 *		<div id="textbox_popup" data-role="popup" class="center_title_2btn">
 *			<div class="ui-popup-title">
 *				<h1>PopupTest<h1>
 *			</div>
 *			<div class="ui-popup-text">
 *				<input type="text" size="20" />
 *				<input type="text" size="20" />
 *			</div>
 *			<div class="ui-popup-button-bg">
 *				<a data-role="button" id="btn_textbox_popup_cancel" data-inline="true">Cancel</a>
 *				<a data-role="button" data-rel="back" data-inline="true">OK</a>
 *			</div>
 *		</div>
 *
 * ##Manual constructor
 * For manual creation of popup widget you can use constructor of widget:
 *
 *		@example
 *		<div id="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			var popupElement = document.getElementById("popup"),
 *				popup = tau.widget.Popup(popupElement);
 *			popup.open();
 *		</script>
 *
 * If jQuery library is loaded, its method can be used:
 *
 *		@example
 *		<div id="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			var popup = $("#popup").popup();
 *			popup.popup("open");
 *		</script>
 *
 * ##Context popup with arrow
 *
 * If property _id_ is set in link and option _positionTo="origin"_ in popup, the context popup will be opened after clicking.
 *
 *		@example
 *		<!-- definition of link, which opens popup with id popup in context style with arrow -->
 *		<a href="#popup" id="linkId" data-position-to="origin" data-role="button" data-inline="true">Click to open context popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic context popup, no options set.</p>
 *		</div>
 *
 * Be award that option _positionTo_ has value "origin" in popup by default. However, the property _positionTo_ is inherited from related link and this inherited value has higher priority during opening process and overwrites the previous value. So, if we do not change it in popup and do not set value of _data-position-to_ other than "origin" in link, popup connected with link will be always opened in context style.
 *
 * To be sure that popup will be opened in context style with arrow, we can set properties _data-position-to="origin"_ as well as _id_ in the related with popup link as in the example above.
 *
 * Moreover, the same result can be achieve by setting only _id_ and not setting _positionTo_ in link because popup has value "origin" for option _positionTo_ by default.
 *
 *		@example
 *		<!-- in link id is set -->
 *		<a href="#popup" id="linkId" data-role="button" data-inline="true">Click to open context popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *
 * After building, the value of option _positionTo_ can be changed by using method _option_.
 *
 *		@example
 *		<a href="#popup" id="linkId" data-role="button" data-inline="true">Click to open context popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// changing value of option positionTo by method option
 *			var popupWidget = tau.widget.Popup(document.getElementById("popup"));
 *			popupWidget.option("positionTo", "origin");
 *		</script>
 *
 * If jQuery is loaded:
 *
 *		@example
 *		<a href="#popup" id="linkId" data-role="button" data-inline="true">Click to open context popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// changing value of option positionTo by method option
 *			$("#popup").popup("option", "positionTo", "origin");
 *		</script>
 *
 *
 * Context popup can be created also manually for elements different than link by pushing options such as _positionTo_ and _link to method _open_.
 *
 *		@example
 *		<!-- element with no properties - popup will be opened next to it in context style manually -->
 *		<div id="linkId">Click to open context popup</div>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// set opening popup on click event
 *			document.getElementById("linkId").addEventListener("click", function () {
 *				// open context popup
 *				var popupWidget = tau.widget.Popup(document.getElementById("popup"));
 *				// opening with options
 *				popupWidget.open({link: "linkId", positionTo: "origin"});
 *			});
 *		</script>
 *
 * If jQuery is loaded:
 *
 *		@example
 *		<!-- element with no properties - popup will be opened next to it in context style manually -->
 *		<div id="linkId">Click to open context popup</div>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// set opening popup on click event
 *			$("#linkId").on("click", function () {
 *				// opening with options
 *				$("#popup").popup("open", {link: "linkId", positionTo: "origin"});
 *			});
 *		</script>
 *
 * These options can be also set globally and then method _open_ can be called without options. However, this solution can be used only for TAU API.
 *
 *		@example
 *		<!-- element with no properties - popup will be opened next to it in context style manually -->
 *		<div id="linkId">Link for popup</div>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// set options
 *			var popupWidget = tau.widget.Popup(document.getElementById("popup"));
 *			popupWidget.option({positionTo: "origin", link: "linkId"}); // here we set positionTo and id of link, which sets placement of popup
 *
 *			// set opening popup on click event
 *			document.getElementById("linkId").addEventListener("click", function () {
 *				//if options are set, we can call method open without options
 *				popupWidget.open();
 *			});
 *		</script>
 *
 * For jQuery API, id of link has to be always added as a option:
 *
 *		@example
 *		<!-- element with no properties - popup will be opened next to it in context style manually -->
 *		<div id="linkId">Link for popup</div>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// set option positionTo
 *			$("#popup").popup("option", "positionTo", "origin");
 *
 *			// set opening popup on click event
 *			$("#linkId").on("click", function () {
 *				// for jQuery API, link has to be added as a option
 *				$("#popup").popup("open", {link: "linkId"});
 *			});
 *		</script>
 *
 *
 * ##Special classes
 *
 * There are some special CSS classes, which changes the style of popup:
 *
 *  - _center_info_ - basic pop-up message<br>
 *  - _center_title_ - pop-up message with a title<br>
 *  - _center_basic_1btn_ - pop-up message with 1 button<br>
 *  - _center_basic_2btn_ - pop-up message with 2 horizontal buttons<br>
 *  - _center_title_1btn_ - pop-up message with a title and 1 button<br>
 *  - _center_title_2btn_ - pop-up message with a title and 2 horizontal buttons<br>
 *  - _center_title_3btn_ - pop-up message with a title and 3 horizontal buttons<br>
 *  - _center_button_vertical_ - pop-up message with vertical buttons<br>
 *  - _center_checkbox_ - pop-up message with a check box<br>
 *  - _center_liststyle_1btn_ - pop-up message with a list and 1 button<br>
 *  - _center_liststyle_2btn_ - pop-up message with a list and 2 horizontal buttons<br>
 *  - _center_liststyle_3btn_ - pop-up message with a list and 3 horizontal buttons<br>
 *
 * ##Methods
 *
 * To call method on widget you can use one of existing API:
 *
 * First API is from tau namespace:
 *
 *		@example
 *		var popupElement = document.getElementById("popup"),
 *			popup = tau.widget.Popup(popupElement);
 *
 *		popup.methodName(methodArgument1, methodArgument2, ...);
 *
 * Second API is jQuery Mobile API and for call _methodName_ you can use:
 *
 *		@example
 *		$(".selector").popup("methodName", methodArgument1, methodArgument2, ...);
 *
 * ##Opening popup
 * There are two ways to open popup.
 *
 * ###Opening by clicking on link
 *
 * If link has _id_ of popup set as value of property _href_, then this popup will be opened after clicking on it.
 *
 *		@example
 *		<!--definition of link, which opens popup with id popup-->
 *		<a href="#popup">Click to open popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 * Be award that context popup with arrow will be opened if link has _id_ property set and _data-position-to="origin"_  as in this example:
 *
 *		@example
 *		<!--definition of link, which opens context popup with id popup-->
 *		<a href="#popup" id="linkId" data-position-to="origin" data-role="button" data-inline="true">Click to open context popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 * To open window popup, property _data-position-to="window"_ must be set in link or popup.
 *
 *		@example
 *		<!--definition of link, which opens window popup with id popup-->
 *		<a href="#popup" id="linkId" data-position-to="window">Click to open popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 * ###Opening manually
 *
 * To open popup with _id_ "popup", tau namespace can be used:
 *
 *		@example
 *		<div id="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			var popupElement = document.getElementById("popup"),
 *				popup = tau.widget.Popup(popupElement);
 *			popup.open();
 *		</script>
 *
 * If jQuery library is loaded, this method can be used:
 *
 *		@example
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			var popup = $("#popup").popup();
 *			popup.popup("open");
 *		</script>
 *
 *
 * ## Closing popup
 *
 * ###Closing by clicking on button inside
 *
 * If link inside popup has property _data-rel="back"_, then popup will be closed after clicking on it as in this example:
 *
 *		@example
 *		<a href="#center_title_1btn" data-position-to="window">Click to open popup</a>
 *		<!--definition of popup with a title and button-->
 *		<div id="center_title_1btn" data-role="popup" class="center_title_1btn">
 *			<div class="ui-popup-title">
 *				<h1>Popup title</h1>
 *			</div>
 *			<div class="ui-popup-text">
 *				Pop-up dialog box, a child window that blocks user interaction to the parent windows
 *			</div>
 *			<div class="ui-popup-button-bg">
 *				<a data-role="button" data-rel="back" data-inline="true">Button</a>
 *			</div>
 *		</div>
 *
 *
 * The selector, which causes closing on click, can be changed by setting option _closeLinkSelector_ in popup.
 *
 * ###Closing manually
 *
 * To close popup with _id_ "popup", tau namespace can be used:
 *
 *		@example
 *		<a href="#popup" data-position-to="window">Click to open popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			var popupElement = document.getElementById("popup"),
 *				popup = tau.widget.Popup(popupElement);
 *			// close popup after opening
 *			popupElement.addEventListener("popupafteropen", function () {
 *				popup.close();
 *			});
 *		</script>
 *
 * If jQuery library is loaded, this method can be used:
 *
 *		@example
 *		<a href="#popup" data-position-to="window">Click to open popup</a>
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			$("#popup").on("popupafteropen", function () {
 *				$("#popup").popup("close");
 *			});
 *		</script>
 *
 * ## Handling Popup Events
 *
 * To use popup events, use the following code:
 *
 *		@example
 *		<!-- Popup html code -->
 *		<div id="popup" data-role="popup">
 *			<p>This is a completely basic popup, no options set.</p>
 *		</div>
 *
 *		<script>
 *			// Use popup events
 *			var popup = document.getElementById("popup");
 *			popup.addEventListener("popupafteropen", function() {
 *				// Implement code for popupafteropen event
 *			});
 *		</script>
 *
 * Full list of available events is in [events list section](#events-list).

 * @since 2.0
 * @class ns.widget.mobile.Popup
 * @component-selector .ui-popup, [data-role]="popup"
 * @extends ns.widget.core.Popup
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Michał Szepielak <m.szepielak@samsung.com>
 */

/**
 * Triggered when process of opening popup is completed.
 * The "popupafteropen" event is triggered when the popup has completely appeared on the screen and all associated animations have completed.
 * @event popupafteropen
 * @member ns.widget.mobile.Popup
 */
/**
 * Triggered when process of opening popup is completed.
 * The "popupshow" event is triggered when the popup has completely appeared on
 * the screen and all associated animations have completed. This event is
 * triggered in the same time as event "popupafteropen".
 * @event popupshow
 * @member ns.widget.mobile.Popup
 */
/**
 * Triggered before a popup computes the coordinates where it will appear.
 * The "beforeposition" event is triggered before the popup starts the opening animations and calculates the coordinates where it will appear on the screen. Handling this event gives an opportunity to modify the content of the popup before it appears on the screen.
 * @event beforeposition
 * @member ns.widget.mobile.Popup
 */

/**
 * Triggered when the process of closing popup is completed.
 * The "popupafterclose" event is triggered when the popup has completely disappeared from the screen and all associated animations have completed.
 * @event popupafterclose
 * @member ns.widget.mobile.Popup
 */
/**
 * Triggered when the process of closing popup is completed.
 * The "popuphide" event is triggered when the popup has completely disappeared
 * from the screen and all associated animations have completed. This event is
 * triggered at the same time as event "popupafterclose".
 * @event popuphide
 * @member ns.widget.mobile.Popup
 */
(function (window, document, ns) {
	"use strict";
				var CorePopup = ns.widget.core.ContextPopup,
				CorePopupPrototype = CorePopup.prototype,

				Listview = ns.widget.core.Listview,

				engine = ns.engine,

				doms = ns.util.DOM,

				POPUP_SELECTOR = "[data-role='popup'], .ui-popup",

				objectUtils = ns.util.object,

				utilSelector = ns.util.selectors,

				Popup = function () {
					var self = this;

					CorePopup.call(this);
					// set options
					self.options = objectUtils.merge(self.options, Popup.defaults);
					self._positionCallback = null;
				};

			Popup.classes = CorePopup.classes;

			/**
			* @property {Object} options Object with default options
			* @property {string} [options.transition="none"] Sets the default transition for the popup.
			* @property {string} [options.positionTo="origin"] Sets the element relative to which the popup will be centered.
			* @property {Array} [options.directionPriority=["bottom", "top", "right", "left"]] Sets directions of popup's placement by priority.
			* First one has the highest priority, last the lowest. It is *deprecated* option.
			* @property {string} [options.closeLinkSelector="a[data-rel="back"]"] Sets selector for buttons in popup
			* @property {boolean} [options.history=false] Sets whether to alter the url when a popup is open to support the back button.
			* @member ns.widget.mobile.Popup
			*/
			Popup.defaults = objectUtils.merge({}, CorePopup.defaults, {
				closeLinkSelector: "a[data-rel='back']",
				transition: "pop",
				directionPriority: ["bottom", "top", "right", "left"], /* deprecated */
				arrow: "b,t,r,l",
				positionTo: "origin"
			});

			Popup.events = objectUtils.merge({}, CorePopup.events, {
				AFTER_OPEN: "popupafteropen",
				AFTER_CLOSE: "popupafterclose"
			});

			Popup.selector = POPUP_SELECTOR;

			Popup.prototype = new CorePopup();

			/**
			* Build structure of popup widget
			* @method _build
			* @param {HTMLElement} element
			* @return {HTMLElement}
			* @protected
			* @member ns.widget.mobile.Popup
			*/
			Popup.prototype._build = function (element) {
				var page = utilSelector.getClosestByClass(element, "ui-page") || document.body,
					elementClassList = element.classList,
					self = this,
					i,
					popupContentClassList,
					DOMTokenListPrototype = DOMTokenList.prototype,
					classListToSwap;

				if (element.parentNode !== page) {
					page.appendChild(element);
				}
				element = CorePopupPrototype._build.call(self, element);
				popupContentClassList = self._ui.content.classList;

				//This is for backwards compatibility when
				//.ui-popup-activity class was in div with class
				//.ui-popup-content, now .ui-popup-activity class
				// should be placed in most outer Popup div that has class .ui-popup
				if (popupContentClassList.contains("ui-popup-activity")) {

					classListToSwap = [];

					for (i = 0; i < popupContentClassList.length; i++) {
						if (popupContentClassList[i].indexOf("ui-popup-activity") !== -1) {
							classListToSwap.push(popupContentClassList[i]);
						}
					}

					DOMTokenListPrototype.remove.apply(popupContentClassList, classListToSwap);
					for (i = 0; i < classListToSwap.length; i++) {
						elementClassList.add(classListToSwap[i]);
					}
				}
				return element;
			};

			Popup.prototype._setDirectionPriority = function (element, value) {
				if (value) {
					this.options.arrow = value.map(function (arrow) {
						return arrow.charAt(0).toLowerCase();
					}).join(",");
				}
			};

			/**
			 * Refresh structure
			 * @method _refresh
			 * @protected
			 * @member ns.widget.mobile.Popup
			 */
			Popup.prototype._refresh = function () {
				var self = this;

				if (this._isActive()) {
					if (typeof self._positionCallback === "function") {
						self._positionCallback();
					}
					CorePopupPrototype._refresh.call(this);
				}
			};

			/**
			 * set height of content
			 * @method _setContentHeight
			 * @protected
			 * @member ns.widget.mobile.Popup
			 * */
			Popup.prototype._setContentHeight = function () {
				var computedMaxHeight = window.innerHeight - doms.getCSSProperty(this.element, "margin-top", 0, "float");

				CorePopupPrototype._setContentHeight.call(this, computedMaxHeight);
			};

			/**
			 * Find clicked element.
			 * @method _findClickedElement
			 * @param {number} x
			 * @param {number} y
			 * @protected
			 * @member ns.widget.mobile.Popup
			 */
			Popup.prototype._findClickedElement = function (x, y) {
				var element = CorePopupPrototype._findClickedElement.call(this, x, y),
					button = utilSelector.getClosestBySelector(element, engine.getWidgetDefinition("Button").selector);

				return button || element;
			};

			/**
			 * Show popup
			 * @method _show
			 * @protected
			 * @member ns.widget.mobile.Popup
			 */
			Popup.prototype._show = function () {
				var self = this,
					listviewElement,
					listview;

				// Disabled colored list for contextual popups
				if (self.options.positionTo !== "window") {
					listviewElement = self.element.querySelector("." + Listview.classes.LISTVIEW);
					if (listviewElement) {
						listview = engine.getBinding(listviewElement);
						if (listview) {
							listview.option("coloredBackground", false);
						}
					}
				}

				CorePopupPrototype._show.call(self);
			};

			/**
			 * Show popup
			 * @method _onShow
			 * @protected
			 * @member ns.widget.mobile.Popup
			 */
			Popup.prototype._onShow = function () {
				CorePopupPrototype._onShow.call(this);
				this.trigger(Popup.events.AFTER_OPEN);
			};

			/**
			 * Hide popup
			 * @method _onHide
			 * @protected
			 * @member ns.widget.mobile.Popup
			 */
			Popup.prototype._onHide = function () {
				CorePopupPrototype._onHide.call(this);
				this.trigger(Popup.events.AFTER_CLOSE);
			};

			/**
			 * Set callback, which is called on "resize" event. This callback should return desired position of popup after resizing.
			 *
			 * This function should be used instead of "setPositionCB".
			 *
			 *      @example
			 *      <div id="popup" data-role="popup">
			 *          <p>This is a completely basic popup, no options set.</p>
			 *      </div>
			 *
			 *      <script>
			 *          var popupWidget = tau.widget.Popup(document.getElementById("popup"));
			 *
			 *          popupWidget.setPositionCallback(function() {
			 *                return {x: 10, y: 20};
			 *         });
			 *      </script>
			 *
			 * If jQuery is loaded:
			 *
			 *      @example
			 *      <div id="popup" data-role="popup">
			 *          <p>This is a completely basic popup, no options set.</p>
			 *      </div>
			 *
			 *      <script>
			 *          $("#popup").popup("setPositionCallback", function() {
			 *                return {x: 10, y: 20};
			 *          });
			 *      </script>
			 *
			 * @method setPositionCallback
			 * @param {Function} callback Function called on resizing. It should return desired position of popup as object with "x" and "y" properties.
			 * @member ns.widget.mobile.Popup
			 * @since 2.3
			 */
			Popup.prototype.setPositionCallback = function (callback) {
				this._positionCallback = callback;
			};

			ns.widget.mobile.Popup = Popup;
			engine.defineWidget(
				"Popup",
				POPUP_SELECTOR,
				[
					"open",
					"close",
					"reposition",
					"setPositionCallback",
					"setPositionCB"
				],
				Popup,
				"mobile",
				true
			);
			}(window, window.document, ns));

/*global window, define, ns*/
/*jslint nomen: true */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * # ScrollView Widget
 * Widgets allows for creating scrollable panes, lists, etc.
 *
 * ## Default selectors
 * All elements with _data-role=content attribute or _.ui-scrollview
 * css class will be changed to ScrollView widgets, unless they specify
 * _data-scroll=none attribute.
 *
 * ### HTML Examples
 *
 * #### Data attribute
 *
 *		@example
 *		<div data-role="page">
 *			<div data-role="content"><!-- this will become scrollview //-->
 *				content data
 *			</div>
 *		</div>
 *
 * #### CSS Class
 *
 *		@example
 *		<div data-role="page">
 *			<div class="ui-content"><!-- this will become scrollview //-->
 *				content data
 *			</div>
 *		</div>
 *
 * ## Manual constructor
 *
 * To create the widget manually you can use 2 different APIs, the TAU
 * API or jQuery API.
 *
 * ### Create scrollview by TAU API
 *
 *		@example
 *		<div data-role="page" id="myPage">
 *			<div data-role="content">
 *				page content
 *			</div>
 *		</div>
 *		<script>
 *			var page = tau.widget.Page(document.getElementById("myPage")),
 *				scrollview = tau.widget.Scrollview(page.ui.content);
 *		</script>
 *
 * ### Create scrollview using jQuery API
 *
 *		@example
 *		<div data-role="page" id="myPage">
 *			<div data-role="content">
 *				page content
 *			</div>
 *		</div>
 *		<script>
 *			$("#myPage > div[data-role='content']").scrollview();
 *		</script>
 *
 * ## Options for Scrollview widget
 *
 * Options can be set using data-* attributes or by passing them to
 * the constructor.
 *
 * There is also a method **option** for changing them after widget
 * creation.
 *
 * jQuery mobile format is also supported.
 *
 * ## Scroll
 *
 * This options specifies of a content element should become Scrollview
 * widget.
 *
 * You can change this by all available methods for changing options.
 *
 * ### By data-scroll attribute
 *
 *		@example
 *		<div data-role="page">
 *			<div data-role="content" data-scroll="none">
 *				content
 *			</div>
 *		</div>
 *
 * ### By config passed to constructor
 *
 *		@example
 *		<div class="myPageClass" data-role="page">
 *			<div data-role="content">
 *				content
 *			</div>
 *		</div>
 *		<script>
 *			var contentElement = document.querySelector(".myPageClass > div[data-role=content]");
 *			tau.widget.Scrollview(contentElement, {
 *				"scroll": false
 *			});
 *		</script>
 *
 * ### By using jQuery API
 *
 *		@example
 *		<div class="myPageClass" data-role="page">
 *			<div data-role="content">
 *				content
 *			</div>
 *		</div>
 *		<script>
 *			$(".myPageClass > div[data-role='content']").scrollview({
 *				"scroll": false
 *			});
 *		</script>
 *
 * ## ScrollJumps
 *
 * Scroll jumps are small buttons which allow the user to quickly
 * scroll to top or left
 *
 * You can change this by all available methods for changing options.
 *
 * ### By data-scroll-jump
 *
 *		@example
 *		<div data-role="page">
 *			<div data-role="content" data-scroll-jump="true">
 *				content
 *			</div>
 *		</div>
 *
 * ### By config passed to constructor
 *
 *		@example
 *		<div class="myPageClass" data-role="page">
 *			<div data-role="content">
 *				content
 *			</div>
 *		</div>
 *		<script>
 *			var contentElement = document.querySelector(".myPageClass > div[data-role=content]");
 *			tau.widget.Scrollview(contentElement, {
 *				"scrollJump": true
 *			});
 *		</script>
 *
 * ### By using jQuery API
 *
 *		@example
 *		<div class="myPageClass" data-role="page">
 *			<div data-role="content">
 *				content
 *			</div>
 *		</div>
 *		<script>
 *			$(".myPageClass > div[data-role='content']").scrollview({
 *				"scrollJump": true
 *			});
 *		</script>
 *
 * ## Methods
 *
 * Page methods can be called trough 2 APIs: TAU API and jQuery API
 * (jQuery mobile-like API)
 *
 * @class ns.widget.mobile.Scrollview
 * @extends ns.widget.core.Scrollview
 *
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @author Maciej Urbanski <m.urbanski@samsung.com>
 * @author Grzegorz Osimowicz <g.osimowicz@samsung.com>
 * @author Jadwiga Sosnowska <j.sosnowska@samsung.com>
 * @author Maciej Moczulski <m.moczulski@samsung.com>
 * @author Hyunkook Cho <hk0713.cho@samsung.com>
 * @author Junhyeon Lee <juneh.lee@samsung.com>
 */
/**
 * Triggered when scrolling operation starts
 * @event scrollstart
 * @member ns.widget.mobile.Scrollview
 */
/**
 * Triggered when scroll is being updated
 * @event scrollupdate
 * @member ns.widget.mobile.Scrollview
 */
/**
 * Triggered when scrolling stops
 * @event scrollstop
 * @member ns.widget.mobile.Scrollview
 */
(function (window, document, ns) {
	"use strict";
				var Scrollview = ns.widget.core.Scrollview;

			ns.widget.mobile.Scrollview = Scrollview;
			ns.engine.defineWidget(
				"Scrollview",
				".ui-content:not([data-scroll='none']):not([data-handler='true']):not(.ui-scrollview-clip)" +
						":not(.ui-scrolllistview):not(.ui-scrollhandler)" +
						", [data-scroll]:not([data-scroll='none']):not([data-handler='true']):not(.ui-scrollhandler)" +
						", .ui-scrollview:not([data-scroll='none']):not([data-handler='true']):not(.ui-scrollhandler)",
				[
					"scrollTo",
					"ensureElementIsVisible",
					"centerToElement",
					"getScrollPosition",
					"skipDragging",
					"translateTo"
				],
				Scrollview,
				"tizen",
				true
			);
			}(window, window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true */
/**
 * #BaseWidgetMobile
 * Extension of class BaseWidget for mobile profile.
 * This class has compatibility properties and methods with jQuery Mobile Widget.
 * @class ns.widget.mobile.BaseWidgetMobile
 * @extends ns.widget.BaseWidget
 */
(function (document, ns) {
	"use strict";
	
			var BaseWidgetMobile = function () {
					this.options = {};
				},
				BaseWidget = ns.widget.BaseWidget,
				basePrototype = BaseWidget.prototype,
				parentConfigure = basePrototype.configure,
				parentDisable = basePrototype.disable,
				parentEnable = basePrototype.enable,
				prototype = new BaseWidget(),
				slice = [].slice;

			BaseWidgetMobile.classes = BaseWidget.classes;

			/**
			 * Configures widget object from definition.
			 * @method configure
			 * @param {Object} definition
			 * @param {string} definition.name Name of widget
			 * @param {string} definition.selector Selector of widget
			 * @param {string} definition.binding Path to file with widget (without extension)
			 * @param {HTMLElement} element
			 * @param {Object} options Configure options
			 * @member ns.widget.mobile.BaseWidgetMobile
			 * @return {HTMLElement}
			 * @instance
			 */
			prototype.configure = function (definition, element, options) {
				var self = this,
					definitionName,
					widgetName;

				element = parentConfigure.call(self, definition, element, options);
				if (definition) {
					definitionName = definition.name;
					widgetName = definitionName && definitionName.toLowerCase();
					/**
					 * @property {string} widgetName Widget base class
					 * @member ns.widget.mobile.BaseWidgetMobile
					 * @instance
					 */
					self.widgetName = widgetName;
					/**
					* @property {string} widgetBaseClass Widget base class
					* @member ns.widget.mobile.BaseWidgetMobile
					* @instance
					*/
					self.widgetBaseClass = self.namespace + "-" + widgetName;
					/**
					* @property {number} uuid Number id of widget instance
					* @member ns.widget.mobile.BaseWidgetMobile
					* @instance
					*/
					self.uuid = ns.getNumberUniqueId();

					/**
					 * @property {string} eventNamespace Namespace of widget events (suffix for events)
					 * @member ns.widget.mobile.BaseWidgetMobile
					 * @instance
					 */
					self.eventNamespace = "." + widgetName + (self.uuid || "");

					/**
					 * @property {string} [defaultElement='<div>'] Default element for the widget
					 * @member ns.widget.mobile.BaseWidgetMobile
					 * @instance
					 */
					self.defaultElement = "<div>";
				}

				return element;
			};

			/**
			* Disables widget.
			* @method disable
			* @member ns.widget.mobile.BaseWidgetMobile
			* @instance
			*/
			prototype.disable = function () {
				var self = this,
					element = self.element,
					elementClasses = element.classList,
					args = slice.call(arguments);

				parentDisable.apply(self, args);
				elementClasses.add(self.widgetFullName + "-disabled");
			};

			/**
			* Enables widget.
			* @method enable
			* @member ns.widget.mobile.BaseWidgetMobile
			* @instance
			*/
			prototype.enable = function () {
				var self = this,
					element = self.element,
					elementClasses = element.classList,
					args = slice.call(arguments);

				parentEnable.apply(self, args);
				elementClasses.remove(self.widgetFullName + "-disabled");
			};

			/**
			* Throws exception.
			* @method raise
			* @param {?string} msg Message of throw
			* @member ns.widget.mobile.BaseWidgetMobile
			* @instance
			*/
			prototype.raise = function (msg) {
				throw "Widget [" + this.widgetName + "]: " + msg;
			};

			/**
			* Returns element of widget.
			* @method widget
			* @member ns.widget.mobile.BaseWidgetMobile
			* @return {HTMLElement}
			* @instance
			*/
			prototype.widget = function () {
				return this.element;
			};

			BaseWidgetMobile.prototype = prototype;

			// definition
			ns.widget.mobile.BaseWidgetMobile = BaseWidgetMobile;

			}(window.document, ns));

/*global window, define, ns */
/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*jslint nomen: true */
/**
 * #Expandable
 * Expandable component allows you to expand or collapse content when tapped.
 *
 * ## Default selectors
 * All elements with _data-role="expandable"_ or class _.ui-expandable_ are
 * changed to expandable component.
 *
 * ###HTML Examples
 *
 * ####Create expandable div using data-role
 *
 *		@example
 *		<div id="expandable" data-role="expandable">
 *			<h1>Expandable head</h1>
 *			<div>Content</div>
 *		</div>
 *
 * ####Create Expandable list using data-role
 *
 *		@example
 *		<ul data-role="listview">
 *			<li data-role="expandable">
 *				<h2>Expandable head</h2>
 *				<-- sub list -->
 *				<ul data-role="listview">
 *					<li>sub list item1</li>
 *					<li>sub list item2</li>
 *				</ul>
 *			</li>
 *		</ul>
 *
 * ####Create using class selector
 *
 *		@example
 *		<div id="expandable" class="ui-expandable">
 *			<h1>Expandable head</h1>
 *			<div>Content</div>
 *		</div>
 *
 * ## Manual constructor
 * For manual creation of Expandable component you can use constructor of component
 * from **tau** namespace:
 *
 *		@example
 *		<script>
 *			var expandableElement = document.getElementById("expandable"),
 *				expandable = tau.widget.Expandable(expandableElement,
 *					{collapsed: false});
 *		</script>
 *
 * Constructor has one require parameter **element** which are base
 * **HTMLElement** to create widget. We recommend get this element by method
 * *document.getElementById*. Second parameter is **options** and it is
 * a object with options for widget.
 *
 * ##Options for Collapsible Widget
 *
 * You can change option for widget using method **option**.
 *
 * ##Methods
 *
 * To call method on widget you can use one of existing API:
 *
 *		@example
 *		var expandableElement = document.getElementById("expandable"),
 *			expandable = tau.widget.Expandable(expandableElement);
 *
 *		expandable.methodName(methodArgument1, methodArgument2, ...);
 *
 * @since 2.4
 * @class ns.widget.mobile.Expandable
 * @component-selector .ui-expandable [data-role]="expandable"
 * @author Piotr Karny <p.karny@samsung.com>
 * @author Marcin Jakuszko <m.jakuszko@samsung.com>
 * @author Hyeoncheol Choi <hc7.choi@samsung.com>
 * @author Heeju Joo <heeju.joo@samsung.com>
 */
(function (document, ns) {
	"use strict";
				/**
				 * @property {Object} BaseWidget alias variable
				 * @private
				 * @static
				 */
			var BaseWidget = ns.widget.mobile.BaseWidgetMobile,
				/**
				 * @property {Object} engine alias variable
				 * @private
				 * @static
				 */
				engine = ns.engine,
				/**
				 * @property {Object} selectors alias variable
				 * @private
				 * @static
				 */
				selectors = ns.util.selectors,
				/**
				 * @property {Object} eventUtil alias variable
				 * @private
				 * @static
				 */
				eventUtil = ns.event,
				/**
				 * @property {Object} domUtils alias variable
				 * @private
				 * @static
				 */
				domUtils = ns.util.DOM,

				/**
				 * @property {Object} expandableSelectors selectors used in this widget
				 * @private
				 * @static
				 */
				expandableSelectors = {
					HEADING: "h1,h2,h3,h4,h5,h6,legend,li"
				},

				Expandable = function () {
					/**
					 * Expandable widget options.
					 * @property {boolean} [options.collapsed=true] Determines if content should be collapsed on load
					 * @property {string} [options.heading="h1,h2,h3,h4,h5,h6,legend,li"] Within the Expandable container, the first immediate child element
					 * that matches this selector will be used as the header for the Expandable.
					 */
					this.options = {
						collapsed: true,
						heading: expandableSelectors.HEADING
					};

					this._eventHandlers = {};
					this._ui = {
						expandableHeadingElement: null,
						expandableHeadingContent: null
					};

				},
				/**
				 * Dictionary object containing commonly used widget classes
				 * @property {Object} classes
				 * @readonly
				 * @static
				 * @member ns.widget.mobile.Expandable
				 */
				classes = {
					/**
					 * Standard expandable widget
					 * @style ui-expandable
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandable: "ui-expandable",
					/**
					 * Set content to expandable widget
					 * @style ui-expandable-content
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableContent: "ui-expandable-content",
					/**
					 * Set collapsed content to expandable widget
					 * @style ui-expandable-content-collapsed
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableContentCollapsed: "ui-expandable-content-collapsed",
					/**
					 * Set expandable widget as collapsed
					 * @style ui-expandable-collapsed
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableCollapsed: "ui-expandable-collapsed",
					/**
					 * Set heading to expandable widget
					 * @style ui-expandable-heading
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableHeading: "ui-expandable-heading",
					/**
					 * Set collapsed heading to expandable widget
					 * @style ui-expandable-heading-collapsed
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableHeadingCollapsed: "ui-expandable-heading-collapsed",
					/**
					 * Set toggle to expandable widget heading
					 * @style ui-expandable-heading-toggle
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableHeadingToggle: "ui-expandable-heading-toggle",
					/**
					 * Set active to expandable widget heading
					 * @style ui-expandable-heading-active
					 * @member ns.widget.mobile.Expandable
					 */
					uiExpandableHeadingActive: "ui-expandable-heading-active"
				};


			Expandable.prototype = new BaseWidget();
			Expandable.classes = classes;
			Expandable.selectors = expandableSelectors;

			/**
			 * Handler function for expanding/collapsing widget
			 * @method toggleExpandableHandler
			 * @param {ns.widget.mobile.Expandable} self
			 * @param {HTMLElement} element
			 * @param {Event} event
			 * @private
			 */
			function toggleExpandableHandler(self, element, event) {
				var	ui = self._ui,
					elementClassList = element.classList,
					heading = ui.expandableHeadingElement,
					headingClassList = heading.classList,
					content = ui.expandableContentElement,
					contentClassList = content.classList,
					isCollapse = event.type === "collapse";

				if (event.defaultPrevented) {
					return;
				}

				event.preventDefault();

				//Toggle functions switched to if/else statement due to toggle bug on Tizen
				if (isCollapse) {
					elementClassList.add(classes.uiExpandableCollapsed);
					headingClassList.add(classes.uiExpandableHeadingCollapsed);
					contentClassList.add(classes.uiExpandableContentCollapsed);
				} else {
					elementClassList.remove(classes.uiExpandableCollapsed);
					headingClassList.remove(classes.uiExpandableHeadingCollapsed);
					contentClassList.remove(classes.uiExpandableContentCollapsed);
				}

				content.setAttribute("aria-hidden", isCollapse);
				eventUtil.trigger(element, isCollapse ? "collapsed" : "expanded");
			}

			function setHeadingActiveClassHandler(self, setClass) {
				var headingClassList = self._ui.expandableHeadingElement.classList;

				if (setClass) {
					headingClassList.add(classes.uiExpandableHeadingActive);
				} else {
					headingClassList.remove(classes.uiExpandableHeadingActive);
				}
			}

			function toggleEventTypeHandler(self, event) {
				var element = self.element,
					heading = self._ui.expandableHeadingElement,
					eventType = heading.classList.contains(classes.uiExpandableHeadingCollapsed) ? "expand" : "collapse";

				eventUtil.trigger(element, eventType);

				event.preventDefault();
				eventUtil.stopPropagation(event);
			}

			/**
			 * Build widget structure
			 * @method _build
			 * @protected
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @member ns.widget.mobile.Expandable
			 */
			Expandable.prototype._build = function (element) {
				var self = this,
					options = self.options,
					ui = self._ui,
					elementClassList = element.classList,
					expandableHeading,
					expandableContent,
					alternativeHeading;

				if ((element.parentNode && element.parentNode.tagName.toLowerCase() === "ul") && (element.tagName.toLowerCase() === "div")) {
					ns.warn("Don't make the Expandable list using <div>. It violates standard of HTML rule. Instead of, please use <li>.");
				}
				elementClassList.add(classes.uiExpandable);

				// First child matching selector is Expandable header
				expandableHeading = selectors.getChildrenBySelector(element, options.heading)[0];
				if (!expandableHeading) {
										expandableHeading = document.createElement("h1");
					element.appendChild(expandableHeading);
				}

				if (expandableHeading.tagName.toLowerCase() === "legend") {
					alternativeHeading = document.createElement("div");
					alternativeHeading.setAttribute("role", "heading");
					alternativeHeading.innerHTML = expandableHeading.innerHTML;
					element.replaceChild(alternativeHeading, expandableHeading);
					expandableHeading = alternativeHeading;
				}
				expandableHeading.classList.add(classes.uiExpandableHeading);

				// Wrap all widget content
				domUtils.wrapInHTML(element.childNodes, "<div class='" + classes.uiExpandableContent + "'></div>");

				// Move header out
				element.insertBefore(expandableHeading, element.firstChild);

				domUtils.wrapInHTML(expandableHeading.childNodes, "<a class='" + classes.uiExpandableHeadingToggle + "' tabindex='0'></a>");

				expandableContent = expandableHeading.nextElementSibling;

				ui.expandableHeadingElement = expandableHeading;
				ui.expandableContentElement = expandableContent;

				return element;
			};

			/**
			 * Init widget structure
			 * @method _init
			 * @protected
			 * @param {HTMLElement} element
			 * @return {HTMLElement}
			 * @member ns.widget.mobile.Expandable
			 */
			Expandable.prototype._init = function (element) {
				var self = this,
					ui = self._ui;

				ui.expandableHeadingElement = ui.expandableHeadingElement || selectors.getChildrenByClass(element, classes.uiExpandableHeading)[0];
				ui.expandableContentElement = ui.expandableContentElement || selectors.getChildrenByClass(element, classes.uiExpandableContent)[0];

				if (self.options.collapsed) {
					element.classList.add(classes.uiExpandableCollapsed);
					ui.expandableHeadingElement.classList.add(classes.uiExpandableHeadingCollapsed);
					ui.expandableContentElement.classList.add(classes.uiExpandableContentCollapsed);
				}

				return element;
			};

			/**
			 * Bind widget events
			 * @method _bindEvents
			 * @protected
			 * @param {HTMLElement} element
			 * @member ns.widget.mobile.Expandable
			 */
			Expandable.prototype._bindEvents = function (element) {
				var self = this,
					eventHandlers = self._eventHandlers,
					heading = self._ui.expandableHeadingElement;

				// Declare handlers with and assign them to local variables
				eventHandlers.toggleExpandable = toggleExpandableHandler.bind(null, self, element);
				eventHandlers.removeActiveClass = setHeadingActiveClassHandler.bind(null, self, false);
				eventHandlers.addActiveClass = setHeadingActiveClassHandler.bind(null, self, true);
				eventHandlers.toggleEventType = toggleEventTypeHandler.bind(null, self);

				eventUtil.on(element, "expand collapse", eventHandlers.toggleExpandable, false);

				eventUtil.on(heading, "vmousedown", eventHandlers.addActiveClass, false);
				eventUtil.on(heading, "vmousemove vmousecancel vmouseup", eventHandlers.removeActiveClass, false);
				eventUtil.on(heading, "vclick", eventHandlers.toggleEventType, false);
			};

			/**
			 * This method refreshes Expandable.
			 *
			 *		@example
			 *		<div id="Expandable" data-role="expandable">
			 *			<h6>Expandable head</h6>
			 *			<div>Content</div>
			 *		</div>
			 *
			 *		<script>
			 *			var ExpandableWidget = tau.widget.Expandable(document.getElementById("Expandable"));
			 *			ExpandableWidget.refresh();
			 *		</script>
			 *
			 * @method refresh
			 * @chainable
			 * @member ns.widget.mobile.Expandable
			 */

			/**
			* Refresh structure
			* @method _refresh
			* @protected
			* @member ns.widget.mobile.Expandable
			*/
			Expandable.prototype._refresh = function () {
				return;
			};

			/**
			 * Removes the Expandable functionality completely.
			 *
			 *		@example
			 *		<div id="Expandable" data-role="expandable">
			 *			<h6>Expandable head</h6>
			 *			<div>Content</div>
			 *		</div>
			 *
			 *		<script>
			 *			var ExpandableWidget = tau.widget.Expandable(document.getElementById("Expandable"));
			 *			ExpandableWidget.destroy();
			 *		</script>
			 *
			 * @method destroy
			 * @member ns.widget.mobile.Expandable
			 */

			/**
			 * Destroy widget
			 * @method _destroy
			 * @protected
			 * @member ns.widget.mobile.Expandable
			 */
			Expandable.prototype._destroy = function () {
				var self = this,
					element = self.element,
					heading = self._ui.expandableHeadingElement,
					eventHandlers = self._eventHandlers,
					parentNode = element.parentNode;

				eventUtil.off(element, "expand collapse", eventHandlers.toggleExpandable, false);

				eventUtil.off(heading, "vmousedown", eventHandlers.addActiveClass, false);
				eventUtil.off(heading, "vmousemove vmousecancel vmouseup", eventHandlers.removeActiveClass, false);
				eventUtil.off(heading, "vclick", eventHandlers.toggleEventType, false);

				self._ui = null;
				self._eventHandlers = null;

				eventUtil.trigger(document, "destroyed", {
					widget: "Expandable",
					parent: parentNode
				});
			};

			// definition
			ns.widget.mobile.Expandable = Expandable;
			engine.defineWidget(
				"Expandable",
				"[data-role='expandable'], .ui-expandable",
				[],
				Expandable,
				"mobile"
			);
			}(window.document, ns));

/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*global window, define, ns */
/**
 * # List View
 * List view component is used to display, for example, navigation data,
 * results, and data entries, in a list format.
 *
 * ## Default selectors
 * All elements which have a data-role [data-role="listview"] or class .ui-listview
 * will become Listview widgets. It is recommended to use UL, LI tags for list creation
 *
 * ###HTML examples
 *
 * ####Create a page widget using the data-role attribute
 *
 *      @example
 *      <ul data-role="listview">
 *          <li>
 *              ...some item
 *          </li>
 *      </ul>
 *
 * #### Create a listview widget using css classes
 *
 *      @example
 *      <ul class="ui-listview">
 *          <li>
 *            ...some item
 *          </li>
 *      </ul>
 *
 * ### Manual constructor
 *
 * These examples show how to create a Listview widget by hand using
 * JavaScript code
 *
 * #### Created using TAU api
 *
 *      @example
 *      <ul class="ui-listview ui-colored-list" id="list">
 *          <li class="ui-li-flex">
 *               <span class="ui-li-area ui-li-area-a">
 *                   <span class="ui-li-text">
 *                        <span>1 text...</span>
 *                   </span>
 *               </span>
 *           </li>
 *      </ul>
 *
 *      <script type="text/javascript">
 *          var listview = tau.widget.Listview(document.getElementById("list"));
 *      </script>
 *
 * #### Create reorder list with TAU api
 *
 *      @example
 *      <a class="ui-btn" id="dragButton">DRAG</a>
 *      <ul class="ui-listview ui-colored-list" id="reorder">
 *          <li class="ui-li-flex">
 *              <span>1 text...</span>
 *          </li>
 *          <li class="ui-li-flex">
 *              <span>2 text...</span>
 *          </li>
 *      </ul>
 *
 *      <script type="text/javascript">
 *        var listview = tau.widget.Listview(document.getElementById("reorder"));
 *        var dragButton = document.getElementById("dragButton");
 *
 *        tau.event.on(dragButton, "click", function(){
 *            listview.toggleDragMode();
 *        });
 *      </script>
 *
 * ## Options for Listview widget
 *
 * Options can be set by using data-* attributes or by passing them
 * to the constructor.
 *
 * There is also a method **option** for changing them after widget
 * creation.
 *
 * @class ns.widget.mobile.Listview
 * @component-selector .ui-listview, [data-role]="listview"
 * @extends ns.widget.core.Listview
 * @author Krzysztof Antoszek <k.antoszek@samsung.com>
 * @since 2.0
 */
(function (window, document, ns) {
	"use strict";
				var Page = ns.widget.core.Page,
				Popup = ns.widget.mobile.Popup,
				Scrollview = ns.widget.mobile.Scrollview,
				CoreListview = ns.widget.core.Listview,
				CoreListviewProto = CoreListview.prototype,
				BaseKeyboardSupport = ns.widget.core.BaseKeyboardSupport,
				utils = ns.util,
				objectUtils = utils.object,
				selectorUtils = utils.selectors,
				eventUtils = ns.event,
				now = Date.now,
				colorDefinitionRegex = new RegExp("[^0-9\-\.:,]+", "gi"),
				min = Math.min,
				max = Math.max,
				round = Math.round,
				ceil = Math.ceil,
				slice = [].slice,
				utilsEvents = ns.event,
				isNumber = utils.isNumber,
				colorTmp = [0, 0, 0, 0],
				MAX_IDLE_TIME = 3 * 1000, //3s
				direction = {
					PREV: -1,
					HOLD: 0,
					NEXT: 1
				},
				Listview = function () {
					var self = this,
						/**
						 * @property {Object} options
						 * @property {boolean} options.coloredBackground=true enables/disables colored background
						 */
						options = {
							coloredBackground: true,
							colorRestOfTheScreenBellow: true,
							colorRestOfTheScreenAbove: true,
							firstColorStep: 0,
							lastColorStep: 0
						};

					CoreListview.call(self);
					BaseKeyboardSupport.call(self);

					// merge options from prototype
					self.options = (!self.options) ?
						options :
						objectUtils.fastMerge(self.options, options);

					// async function (requestAnimationFrame)
					self._async = utils.requestAnimationFrame;
					// rendering context
					self._context = null;
					// canvas elements style
					self._canvasStyle = null;
					// detected parent scrollable element
					self._scrollableContainer = null;
					// detected parent page element
					self._pageContainer = null;
					// detected parent popup element
					self._popupContainer = null;
					// drawCallback
					self._drawCallback = null;
					// scrollCallback
					self._scrollCallback = null;
					// _backgroundRenderCallback
					self._backgroundRenderCallback = null;
					// flag for async timers
					self._running = false;
					// flag for drawing
					self._redraw = false;
					// starting default color for gradient background
					self._colorBase = [250, 250, 250, 1];
					// color modifier for each background gradient step
					self._colorStep = [0, 0, 0, -0.04];
					// _lastChange
					self._lastChange = 0;
					// arrays of neighbor colored listview related to parent
					self._siblingListsBellow = [];
					self._siblingListsAbove = [];

					initializeGlobalsForDrag(self);
				},
				WIDGET_SELECTOR = "[data-role='listview'], .ui-listview",
				/**
				 * @property {Object} classes
				 * @property {string} classes.BACKGROUND_LAYER
				 * @property {string} classes.GRADIENT_BACKGROUND_DISABLED
				 * @member ns.widget.mobile.Listview
				 * @static
				 * @readonly
				 */
				classes = {
					/**
					 * Set background for listview widget
					 * @style ui-listview-background
					 * @member ns.widget.mobile.Listview
					 */
					"BACKGROUND_LAYER": "ui-listview-background",
					/**
					 * Set background as disable for listview widget
					 * @style ui-listview-background-disabled
					 * @member ns.widget.mobile.Listview
					 */
					"GRADIENT_BACKGROUND_DISABLED": "ui-listview-background-disabled",
					/**
					 * Set index for group in listview widget
					 * @style ui-group-index
					 * @member ns.widget.mobile.Listview
					 */
					"GROUP_INDEX": "ui-group-index",
					/**
					 * Set listview to show in popup widget
					 * @style ui-popup-listview
					 * @member ns.widget.mobile.Listview
					 */
					"POPUP_LISTVIEW": "ui-popup-listview",
					/**
					 * Set drag as active for listview widget
					 * @style ui-drag-active
					 * @member ns.widget.mobile.Listview
					 */
					"DRAG_ACTIVE": "ui-drag-active",
					/**
					 * Set expandable widget. Expandable component allows you to expand or collapse content when tapped.
					 * @style ui-expandable
					 * @member ns.widget.mobile.Listview
					 */
					"EXPANDABLE": "ui-expandable",
					/**
					 * Set element as listview item
					 * @style ui-listview-item
					 * @member ns.widget.mobile.Listview
					 */
					"ITEM": "ui-listview-item",
					/**
					 * Set element as active listview item
					 * @style ui-listview-item-active
					 * @member ns.widget.mobile.Listview
					 */
					"ITEM_ACTIVE": "ui-listview-item-active",
					/**
					 * Set helper for listview widget
					 * @style ui-listview-helper
					 * @member ns.widget.mobile.Listview
					 */
					"HELPER": "ui-listview-helper",
					/**
					 * Create holder element to help reordering
					 * @style ui-listview-holder
					 * @member ns.widget.mobile.Listview
					 */
					"HOLDER": "ui-listview-holder",
					"SNAPSHOT": "snapshot",
					/**
					 * Create handler for listview widget
					 * @style ui-listview-handler
					 * @member ns.widget.mobile.Listview
					 */
					"HANDLER": "ui-listview-handler",
					"DRAG_MODE": "dragMode",
					"ACTIVATE_HANDLERS": "activateHandlers",
					"CANCEL_ANIMATION": "cancelAnimation",
					"DEACTIVATE_HANDLERS": "deactivateHandlers",
					"FOCUS": "ui-listview-focus",
					"ITEMFOCUS": "ui-listview-item-focus"
				},

				/**
				 * @property {Object} events
				 * @property {string} events.BACKGROUND_RENDER
				 * @member ns.widget.mobile.Listview
				 * @static
				 * @readonly
				 */
				events = {
					"BACKGROUND_RENDER": "event-listview-background-render"
				},
				engine = ns.engine,
				prototype = new CoreListview();

			/**
			 * Set globals for drag functionality, constructor helper
			 * @method initializeGlobalsForDrag
			 * @param {Object} self
			 * @member ns.widget.mobile.Listview
			 * @private
			 */
			function initializeGlobalsForDrag(self) {
				self._topOffset = window.innerHeight;
				self._previousVisibleElement = null;
				self._canvasWidth = 0;
				self._canvasHeight = 0;

				self._dragMode = false;
				self.originalListPosition = 0;
				self.indexDraggingElement = 0;

				self._ui = {
					helper: {},
					holder: {}
				};

				self._snapshotItems = [];
				self._liElements = [];
				self.topValue = 0;
				self.isScrolling = null;
				self._reorderElements = [];
			}

			/**
			 * Modifies input color array (rgba) by a specified
			 * modifier color array (rgba)
			 * @method modifyColor
			 * @param {Array} color input array of color values (rgba)
			 * @param {Array} modifier array of color values (rgba)
			 * @member ns.widget.mobile.Listview
			 * @return {number} Return opacity of color
			 * @private
			 */
			function modifyColor(color, modifier) {
				color[0] += modifier[0];
				color[1] += modifier[1];
				color[2] += modifier[2];
				color[3] += modifier[3];

				color[0] = min(max(0, color[0]), 255);
				color[1] = min(max(0, color[1]), 255);
				color[2] = min(max(0, color[2]), 255);
				color[3] = min(max(0, color[3]), 1);

				return color[3];
			}

			/**
			 * Copies values from one color array (rgba) to other
			 * @method copyColor
			 * @param {Array} inc color array (rgba)
			 * @param {Array} out color array (rgba)
			 * @member ns.widget.mobile.Listview
			 * @private
			 */
			function copyColor(inc, out) {
				out[0] = inc[0];
				out[1] = inc[1];
				out[2] = inc[2];
				out[3] = inc[3];
			}

			/**
			 * Returns number from specified value (mixed) or
			 * 0 if no param is not a number
			 * @method toNumber
			 * @param {mixed} val
			 * @return {number}
			 * @member ns.widget.mobile.Listview
			 * @private
			 */
			function toNumber(val) {
				var res = parseFloat(val);

				// fast NaN check
				if (res === res) {
					return res;
				}

				return 0;
			}

			Listview.classes = objectUtils.fastMerge(classes, CoreListview.classes);
			Listview.events = events;

			prototype._setFirstColorStep = function (element, value) {
				value = parseInt(value, 10);
				this.options.firstColorStep = value;

				return true;
			}

			/**
			 * Enables / disables colored background
			 * @method _setColoredBackground
			 * @param {HTMLElement} element Main element of widget
			 * @param {boolean} value option value
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._setColoredBackground = function (element, value) {
				element.classList.toggle(classes.GRADIENT_BACKGROUND_DISABLED, !value);
				this.options.coloredBackground = value;
			};

			prototype._addCanvas = function (element) {
				var canvas = document.createElement("canvas"),
					context = canvas.getContext("2d");

				canvas.classList.add(classes.BACKGROUND_LAYER);
				element.insertBefore(canvas, element.firstElementChild);
				this._context = context;

				return canvas;
			}

			/**
			 * Builds widget
			 * @method _build
			 * @param {HTMLElement} element Main element of widget
			 * @member ns.widget.mobile.Listview
			 * @return {HTMLElement}
			 * @protected
			 */
			prototype._build = function (element) {
				var self = this,
					newElement = CoreListviewProto._build.call(self, element),
					isChildListview = element &&
						selectorUtils.getClosestByClass(element.parentElement, "ui-listview");

				self._isChildListview = isChildListview;

				if (!isChildListview) {
					self._addCanvas(newElement);
				}

				return newElement;
			};

			prototype._getCanvas = function () {
				var self = this,
					canvas;

				// If reference to canvas has been changed.
				// Developer can remove canvas from list, eg. by element.innerHTML = "<li>item</li>"
				if (self._context) {
					canvas = self._context.canvas;
				}
				if (!canvas || !canvas.parentElement) {
					canvas = self.element.querySelector("." + classes.BACKGROUND_LAYER);
					if (!canvas) {
						canvas = self._addCanvas(self.element);
					}
					self._context = canvas.getContext("2d");
				}

				return canvas;
			}

			/**
			 * Init colors used to draw colored bars
			 * @method _prepareColors
			 * @member ns.widget.mobile.Listview
			 * @protected
			 * */
			prototype._prepareColors = function () {
				var self = this,
					canvas = self._getCanvas(),
					computedAfter,
					colorCSSDefinition,
					baseColor,
					modifierColor,
					colors;

				if (canvas) {
					computedAfter = window.getComputedStyle(canvas, ":before");
					colorCSSDefinition = computedAfter.getPropertyValue("content");

					if (colorCSSDefinition.length > 0) {
						colorCSSDefinition = colorCSSDefinition.replace(colorDefinitionRegex, "");
						colors = colorCSSDefinition.split("::");
						if (colors.length === 2) {
							baseColor = colors[0].split(",").filter(isNumber).map(toNumber);
							modifierColor = colors[1].split(",").filter(isNumber).map(toNumber);
							if (baseColor.length > 0) {
								copyColor(baseColor, self._colorBase);
							}
							if (modifierColor.length > 0) {
								copyColor(modifierColor, self._colorStep);
							}
						}
					}
				}
			};

			/**
			 * Refresh background canvas
			 * @method _refreshBackgroundCanvas
			 * @param {HTMLElement} container
			 * @param {HTMLElement} element
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._refreshBackgroundCanvas = function (container, element) {
				var self = this,
					canvas = self._getCanvas(),
					canvasStyle,
					rect,
					// canvasHeight of canvas element
					canvasHeight,
					// canvasWidth of canvas element
					canvasWidth;

				if (canvas) {
					canvasStyle = canvas.style;
					rect = element.getBoundingClientRect();
					canvasHeight = 0;
					canvasWidth = rect.width;

					// calculate canvasHeight of canvas
					if (container) {
						canvasHeight = container.getBoundingClientRect().height;
					}

					canvasHeight = Math.max(rect.height, canvasHeight) + self._topOffset;

					// limit canvas for better performance
					canvasHeight = Math.min(canvasHeight, 4 * window.innerHeight);
					self._canvasHeight = canvasHeight;
					self._canvasWidth = canvasWidth;

					// init canvas
					canvas.setAttribute("width", canvasWidth);
					canvas.setAttribute("height", canvasHeight);
					canvasStyle.width = canvasWidth + "px";
					canvasStyle.height = canvasHeight + "px";
				}
			};

			/**
			 * Find and store all possible containers which may contains the listview
			 * @method _findContainers
			 * @param {HTMLElement} element widget element
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._findContainers = function (element) {
				var self = this;

				self._pageContainer = selectorUtils.getClosestByClass(element, Page.classes.uiPage);
				self._popupContainer = selectorUtils.getClosestByClass(element, Popup.classes.popup);
				self._scrollableContainer = selectorUtils.getClosestByClass(element, Scrollview.classes.clip) ||
					selectorUtils.getClosestByTag(element, "section");
			};

			/**
			 * Method checks if listview contains in popup then add specific class
			 * @method _checkClosestPopup
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._checkClosestPopup = function () {
				var self = this,
					popupContainer = self._popupContainer,
					popupContent;

				if (popupContainer) {
					popupContainer.classList.add(classes.POPUP_LISTVIEW);
					popupContent = popupContainer.querySelector("." + Popup.classes.content);
					if (popupContent) {
						self._scrollableContainer = popupContent;
					}
				}
			};

			/**
			 * Refreshes colored list in widget background,
			 * @method _refreshColoredBackground
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._refreshColoredBackground = function () {
				var self = this,
					element = self.element,
					canvas;

				// if listview contains in popup then add specific class
				self._checkClosestPopup();

				self._redraw = true;
				self._lastChange = Date.now();
				self._previousVisibleElement = null;

				self._prepareColors();
				self._refreshBackgroundCanvas(self._scrollableContainer, element);

				canvas = self._getCanvas();
				if (canvas) {
					if (element.firstElementChild &&
						element.firstElementChild.tagName.toLowerCase() !== "canvas") {
						element.insertBefore(canvas, element.firstElementChild);
					} else if (!(element.firstElementChild instanceof HTMLElement)) {
						element.appendChild(canvas);
					}
					if (typeof self._frameCallback === "function") {
						self._frameCallback();
					}
				}
			};

			/**
			 * Refreshes widget, critical to call after changes (ex. in background color)
			 * @method _refresh
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._refresh = function () {
				var self = this,
					element = self.element,
					popupContainer = selectorUtils.getClosestByClass(element, Popup.classes.popup);

				self._findContainers(element);

				if (self.options.coloredBackground) {
					self._refreshColoredBackground();
				} else if (popupContainer) {
					// if listview contains in popup then remove specific class
					popupContainer.classList.remove(classes.POPUP_LISTVIEW);
					self._popupContainer = popupContainer;
				}
			};

			/**
			 * Initializes widget and async timers
			 * @method _init
			 * @param {HTMLElement} element
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._init = function (element) {
				var self = this,
					context = self._context,
					canvas,
					foundSelf = false,
					siblingLists,
					childrenLists;

				self.options.firstColorStep = parseInt(self.options.firstColorStep, 10);

				if (!self._isChildListview) {
					if (!context) {
						canvas = element.querySelector("." + classes.BACKGROUND_LAYER);
						if (canvas) {
							context = canvas.getContext("2d");
						}
					} else {
						canvas = context.canvas;
					}

					if (context) {
						self._canvasStyle = canvas.style;
						self._frameCallback = self._handleFrame.bind(self);

						self.refresh();
					}
				}

				// check other sibling colored lists
				siblingLists = [].slice.call(self.element.parentElement.querySelectorAll(WIDGET_SELECTOR));
				childrenLists = [].slice.call(self.element.querySelectorAll(WIDGET_SELECTOR));
				// remove itself listview from list and above listview elements
				self._siblingListsBellow = siblingLists.filter(function (listviewElement) {
					// filter children
					if (childrenLists.indexOf(listviewElement) > -1) {
						return false;
					}
					if (foundSelf) {
						return true;
					}
					foundSelf = listviewElement === self.element;

					return false;
				});
				foundSelf = false;
				self._siblingListsAbove = siblingLists.filter(function (listviewElement) {
					// filter children
					if (childrenLists.indexOf(listviewElement) > -1) {
						return false;
					}
					if (foundSelf || listviewElement === self.element) {
						foundSelf = true;
						return false;
					}
					return true;
				});

				if (self._siblingListsBellow.length > 0) {
					// disable coloring the test of space below current listview
					self.options.colorRestOfTheScreenBellow = false;
				}
				if (self._siblingListsAbove.length > 0) {
					self.options.colorRestOfTheScreenAbove = false;
				}

			};

			/**
			 * Handles scroll event data
			 * @method _handleScroll
			 * @member ns.widget.mobile.Listview
			 * @protected
			 */
			prototype._handleScroll = function () {
				var self = this;

				self._lastChange = now();

				if (!self._running) {
					self._running = true;
					self._async(self._frameCallback);
				}
			};

			/**
			 * Handles touch start event
			 * Used to disable scroll event listener on reorder
			 * @method _handleTouchStart
			 * @member ns.widget.mobile.Listview
			 * @param {Event} event Event
			 * @protected
			 */
			prototype._handleTouchStart = function (event) {
				var self = this,
					scrollableContainer = self._scrollableContainer;

				if (self._dragMode && event.srcElement.classList.contains(classes.HANDLER)) {
					eventUtils.off(scrollableContainer, "scroll", self._reorderCallback);
				}
			};

			/**
			 * Handles touch end event
			 * Used to re-enable scroll event listener when reorder ends
			 * @method _handleTouchEnd
			 * @member ns.widget.mobile.Listview
			 * @param {Event} event Event
			 * @protected
			 */
			prototype._handleTouchEnd = function (event) {
				var self = this,
					scrollableContainer = self._scrollableContainer;

				if (self._dragMode && event.srcElement.classList.contains(classes.HANDLER)) {
					eventUtils.on(scrollableContainer, "scroll", self._reorderCallback);
				}
			};

			/**
			 * Handles scroll and scroll end
			 * This method re-enables canvas on listview and removes backgrounds
			 * added on reorder
			 * It also adds timeout that is triggered on scroll end
			 * @method _handleReorderScroll
			 * @member ns.widget.mobile.Listview
			 *