/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SAMPLENATIVEIMEUIPROPERTY_H_
#define SAMPLENATIVEIMEUIPROPERTY_H_
#include "samplenativeimeuitypes.h"
#include <Elementary.h>

/* the label property */
typedef struct _IMELabelProperty {
	Eina_Bool fValid;			/* indicates whether this information is in use or not */
	char *label_text;			/* text for label */
	BYTE font_size;				/* font size of this label property */
} IMELabelProperty;

/* key property for single key */
typedef struct _IMEKeyProperty {
	Eina_Bool fvalid;			/* indicates whether this information is in use or not */
	UShort x;					/* the x coordinate of left-top of key */
	UShort y;					/* the y coordinate of left-top of key */
	UShort width;				/* the width of key */
	UShort height;				/* the height of key */
	char *image_label[IME_SHIFT_STATE_MAX][IME_BUTTON_STATE_MAX];	/* image label of key for different shift and button state */
	char *key_value[IME_SHIFT_STATE_MAX][SAMPLE_NATIVE_IME_MAX_SIZE_OF_KEY_VALUE];	/* key values for different shift state */
	IMEButtonType button_type;	/* button type for key */
	IMEKeyType key_type;		/* key type for key */
	IMEKeyType long_key_type;	/* key type for long press */
	IMEKeyRowInfo row_info;		/* row information for the key */
	IMELabelProperty main_label[IME_SHIFT_STATE_MAX];	/* the main label for key */
	IMELabelProperty sub_label[IME_SHIFT_STATE_MAX];	/* the sub label for key */
	void *key_obj;				/* the key object pointer */
} IMEKeyProperty;

/* the layout property for keyboard */
typedef struct _IMELayout {
	Eina_Bool fvalid;			/* indicates whether this information is in use or not */
	char *name;					/* the name of layout */
	IMEDisplayMode display_mode;	/* display mode, landscape or portrait */
	UShort width;				/* the width of layout */
	UShort height;				/* the height of layout */
	UShort key_width;			/* the default key width of layout */
	UShort key_height;			/* the default key height of layout */
	UShort key_spacing;			/* the space between keys */
	UShort row_spacing;			/* the space between rows */
	UShort row_number;			/* number of row in the layout */
	IMELayoutRowInfo row_infos[SAMPLE_NATIVE_IME_MAX_SIZE_OF_ROW_NUMBER];	/* row information for row */
	IMEKeyProperty button_key[SAMPLE_NATIVE_IME_MAX_SIZE_OF_ROW_NUMBER][SAMPLE_NATIVE_IME_MAX_SIZE_OF_KEYS_FOR_ONE_ROW];	/* key property for keys in layout */
} IMELayout;

/**
 * @brief the key down callback function type
 * @param key_property the key property for the pressed key
 * @param data for key down event
 *
 * return the operation success or not
 */
typedef Eina_Bool(*SAMPLE_NATIVE_IME_KEY_DOWN_CALLBACK) (IMEKeyProperty * key_property, void *data);

/**
 * @brief the key up callback function type
 * @param key_property the key property for the pressed key
 * @param data for key down event
 *
 * return the operation success or not
 */
typedef Eina_Bool(*SAMPLE_NATIVE_IME_KEY_UP_CALLBACK) (IMEKeyProperty * key_property, void *data);

/**
 * @brief the key long press callback function type
 * @param key_property the key property for the pressed key
 * @param data for key down event
 *
 * return the operation success or not
 */
typedef Eina_Bool(*SAMPLE_NATIVE_IME_KEY_LONG_PRESS_CALLBACK) (IMEKeyProperty * key_property, void *data);

/* key event callback type */
typedef struct IMEKeyEventCallBack {
	SAMPLE_NATIVE_IME_KEY_DOWN_CALLBACK key_down_cb;            /* key down callback function */
	SAMPLE_NATIVE_IME_KEY_UP_CALLBACK key_up_cb;                /* key up callback function */
	SAMPLE_NATIVE_IME_KEY_LONG_PRESS_CALLBACK key_long_press_cb;         /* key long press callback function */
	void *key_down_data;               /* data for key down callback */
	void *key_up_data;                 /* data for key up callback */
	void *key_long_press_data;         /* data for key long press callback */
} IMEKeyEventCallBack;

#endif /* SAMPLENATIVEIMEUIPROPERTY_H_ */
