#include "{{app_name}}.h"

component_class_h component_app_create_cb(void *user_data)
{
	component_class_h comp = NULL;
	const char *frame_component_id = "{{app_name}}-frame-component";
	const char *service_component_id = "{{app_name}}-service-component";

	comp = sample_frame_component_add(comp, frame_component_id, user_data);
	comp = sample_service_component_add(comp, service_component_id, user_data);

	return comp;
}

void component_app_terminate_cb(void *user_data)
{
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	component_based_app_lifecycle_callback_s callback = {
		.create = component_app_create_cb,
		.terminate = component_app_terminate_cb
	};

	ret = component_based_app_main(argc, argv, &callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
