/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SAMPLENATIVEIMECONFIG_H_
#define SAMPLENATIVEIMECONFIG_H_

#include "samplenativeimeuiproperty.h"
#include "samplenativeimelayout.h"

/* for key property */
#define SAMPLE_NATIVE_IME_KEY_LABEL_NUM   2
#define SAMPLE_NATIVE_IME_DEFAULT_VAL     0

/* define the layout name */
#define SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME             "English"
#define SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME             "Symbol1"
#define SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME             "Symbol2"
#define SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME              "Option"

/* the relationship between layout name and type */
typedef struct _private_layout_name_to_value {
	char *name;
	IMEKeyboardLayoutType layout_type;
} private_layout_name_to_value;

static private_layout_name_to_value g_keyboard_layout_name_to_value[IME_KEYBOARD_LAYOUT_MAX] = {
	{SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, IME_KEYBOARD_LAYOUT_ENGLISH},
	{SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, IME_KEYBOARD_LAYOUT_SYM1},
	{SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME, IME_KEYBOARD_LAYOUT_SYM2},
	{SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, IME_KEYBOARD_LAYOUT_OPTION}
};

/*****************************************************************************************************
 * private_key_label_type, private_layout_type are used to configure the layout and key for keyboard.
 * they are used to initialize IMELayout, IMEKeyProperty, IMELabelProperty
 ****************************************************************************************************/
typedef struct _private_key_label_type {
	char *main_key[IME_SHIFT_STATE_MAX];	/* main label for key */
	char *main_key_value[IME_SHIFT_STATE_MAX];	/* main value for key */
	char *sub_key;				/* sub label for key */
	UShort width;				/* width for key */
	UShort height;				/* height for key */
	IMEButtonType button_type;	/* button type for key */
	IMEKeyType key_type;		/* key type for key */
	IMEKeyType long_key_type;	/* key type for long press */
	BYTE main_font_size[IME_SHIFT_STATE_MAX];	/* main font size */
	BYTE sub_font_size[IME_SHIFT_STATE_MAX];	/* sub font size */
} private_key_label_type;

typedef struct _private_layout_type {
	char *name;					/* the name for layout */
	IMEDisplayMode display_mode;	/* display mode for layout */
	UShort width;				/* width for layout */
	UShort height;				/* height for layout */
	UShort key_width;			/* default key width for layout */
	UShort key_height;			/* default key height for layout */
	UShort key_spacing;			/* the space between keys */
	UShort row_spacing;			/* the space between rows */
	UShort row_number;			/* the number of row in layout */
	IMELayoutRowInfo row_info[SAMPLE_NATIVE_IME_MAX_SIZE_OF_ROW_NUMBER];	/* row information for row */
	private_key_label_type key_label[SAMPLE_NATIVE_IME_MAX_SIZE_OF_ROW_NUMBER][SAMPLE_NATIVE_IME_MAX_SIZE_OF_KEYS_FOR_ONE_ROW];	/* key property for keys in layout */
} private_layout_type;

/*************************************************************************************
 *  English Keyboard Portrait Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_NAME             "English"  /* the name of keyboard */

#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_WIDTH_P       65    /* key width for portrait mode  */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_HEIGHT_P      81    /* key height for portrait mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_SPACING_P     6     /* the space between two columns for portrait mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_SPACING_P     28    /* the space between tow rows for portrait mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_NUM_P         4     /* the number of rows for English keyboard for portrait mode */

/* The first row of English keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FIRST_ROW_P \
	{ {"q", "Q", "Q"}, {"q", "Q", "Q"}, "1", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"w", "W", "W"}, {"w", "W", "W"}, "2", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"e", "E", "E"}, {"e", "E", "E"}, "3", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"r", "R", "R"}, {"r", "R", "R"}, "4", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"t", "T", "T"}, {"t", "T", "T"}, "5", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"y", "Y", "Y"}, {"y", "Y", "Y"}, "6", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"u", "U", "U"}, {"u", "U", "U"}, "7", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"i", "I", "I"}, {"i", "I", "I"}, "8", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"o", "O", "O"}, {"o", "O", "O"}, "9", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"p", "P", "P"}, {"p", "P", "P"}, "0", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_SECOND_ROW_P \
	{ {"a", "A", "A"}, {"a", "A", "A"}, "-", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"s", "S", "S"}, {"s", "S", "S"}, "@", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"d", "D", "D"}, {"d", "D", "D"}, "*", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"f", "F", "F"}, {"f", "F", "F"}, "^", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"g", "G", "G"}, {"g", "G", "G"}, ":", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"h", "H", "H"}, {"h", "H", "H"}, ";", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"j", "J", "J"}, {"j", "J", "J"}, "(", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"k", "K", "K"}, {"k", "K", "K"}, ")", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"l", "L", "L"}, {"l", "L", "L"}, "~", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The third row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_THIRD_ROW_P \
	{ {"", "", ""}, {"Shift", "Shift", "Shift"}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"z", "Z", "Z"}, {"z", "Z", "Z"}, "/",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"x", "X", "X"}, {"x", "X", "X"}, "'",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"c", "C", "C"}, {"c", "C", "C"}, "\"",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"v", "V", "V"}, {"v", "V", "V"}, ".",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"b", "B", "B"}, {"b", "B", "B"}, ",",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"n", "N", "N"}, {"n", "N", "N"}, "?",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"m", "M", "M"}, {"m", "M", "M"}, "!",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "",    100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FOURTH_ROW_P \
	{ {"?123", "?123", "?123"}, {SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"English", "English", "English"}, {"Space", "Space", "Space"}, "", 349, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_LABEL_P { \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FIRST_ROW_P},  \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_SECOND_ROW_P}, \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_THIRD_ROW_P},  \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FOURTH_ROW_P}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_AUTO_CAL 0
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_INFO_P {\
	{9, 11, 10}, {36, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  English Keyboard Portrait Layout (End)
 ************************************************************************************/

/*************************************************************************************
 *  Symbol1 Keyboard Portrait Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_NAME             "Symbol1"    /* the name of keyboard */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_WIDTH_P       65          /* key width for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_HEIGHT_P      81          /* key height for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_SPACING_P     6           /* the space between two columns for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_SPACING_P     28          /* the space between two rows for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_NUM_P         4           /* the number of rows for Symbol1 keyboard for portrait mode */

/* The first row of Symbol1 keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FIRST_ROW_P \
	{ {"1", "1", "1"}, {"1", "1", "1"}, "#", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"2", "2", "2"}, {"2", "2", "2"}, "&", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"3", "3", "3"}, {"3", "3", "3"}, "%", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"4", "4", "4"}, {"4", "4", "4"}, "+", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"5", "5", "5"}, {"5", "5", "5"}, "=", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"6", "6", "6"}, {"6", "6", "6"}, "_", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"7", "7", "7"}, {"7", "7", "7"}, "\\", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"8", "8", "8"}, {"8", "8", "8"}, "|", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"9", "9", "9"}, {"9", "9", "9"}, "<", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"0", "0", "0"}, {"0", "0", "0"}, ">", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_SECOND_ROW_P \
	{ {"-", "-", "-"}, {"-", "-", "-"}, "{", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"@", "@", "@"}, {"@", "@", "@"}, "}", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"*", "*", "*"}, {"*", "*", "*"}, "[", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"^", "^", "^"}, {"^", "^", "^"}, "]", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {":", ":", ":"}, {":", ":", ":"}, "$", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {";", ";", ";"}, {";", ";", ";"}, "£", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"(", "(", "("}, {"(", "(", "("}, "¥", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {")", ")", ")"}, {")", ")", ")"}, "€", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"~", "~", "~"}, {"~", "~", "~"}, "₩", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }

/* The third row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_THIRD_ROW_P \
	{ {"1/2", "1/2", "1/2"}, {SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"/", "/", "/"}, {"/", "/", "/"}, "¢",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\'", "\'", "\'"}, {"\'", "\'", "\'"}, "`",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\"", "\"", "\""}, {"\"", "\"", "\""}, "°",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."}, "·",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {",", ",", ","}, {",", ",", ","}, "®",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"?", "?", "?"}, {"?", "?", "?"}, "©",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"!", "!", "!"}, {"!", "!", "!"}, "¿",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "",    100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FOURTH_ROW_P \
	{ {"abc", "abc", "abc"}, {SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Space", "Space", "Space"}, "", 349, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_LABEL_P { \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FIRST_ROW_P},  \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_SECOND_ROW_P}, \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_THIRD_ROW_P},  \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FOURTH_ROW_P}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_INFO_P {\
	{9, 11, 10}, {36, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  Symbol1 Keyboard Portrait Layout (End)
 ************************************************************************************/

/*************************************************************************************
 *  Symbol2 Keyboard Portrait Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_NAME             "Symbol2"    /* the name of keyboard */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_WIDTH_P       65          /* key width for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_HEIGHT_P      81          /* key height for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_SPACING_P     6           /* the space between two columns for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_SPACING_P     28          /* the space between two rows for portrait mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_NUM_P         4           /* the number of rows for Symbol1 keyboard for portrait mode */

/* The first row of Symbol2 keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FIRST_ROW_P \
	{ {"#", "#", "#"}, {"#", "#", "#"}, "1", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"&", "&", "&"}, {"&", "&", "&"}, "2", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"%", "%", "%"}, {"%", "%", "%"}, "3", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"+", "+", "+"}, {"+", "+", "+"}, "4", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"=", "=", "="}, {"=", "=", "="}, "5", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"_", "_", "_"}, {"_", "_", "_"}, "6", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\\", "\\", "\\"}, {"\\", "\\", "\\"}, "7", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"|", "|", "|"}, {"|", "|", "|"}, "8", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"<", "<", "<"}, {"<", "<", "<"}, "9", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {">", ">", ">"}, {">", ">", ">"}, "0", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_SECOND_ROW_P \
	{ {"{", "{", "{"}, {"{", "{", "{"}, "-", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"}", "}", "}"}, {"}", "}", "}"}, "@", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"[", "[", "["}, {"[", "[", "["}, "*", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"]", "]", "]"}, {"]", "]", "]"}, "^", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"$", "$", "$"}, {"$", "$", "$"}, ":", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"£", "£", "£"}, {"£", "£", "£"}, ";", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"¥", "¥", "¥"}, {"¥", "¥", "¥"}, "(", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"€", "€", "€"}, {"€", "€", "€"}, ")", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"₩", "₩", "₩"}, {"₩", "₩", "₩"}, "~", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The third row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_THIRD_ROW_P \
	{ {"2/2", "2/2", "2/2"}, {SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"¢", "¢", "¢"}, {"¢", "¢", "¢"}, "/",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"`", "`", "`"}, {"`", "`", "`"}, "\'",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"°", "°", "°"}, {"°", "°", "°"}, "\"",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"·", "·", "·"}, {"·", "·", "·"}, ".",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"®", "®", "®"}, {"®", "®", "®"}, ",",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"©", "©", "©"}, {"©", "©", "©"}, "?",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"¿", "¿", "¿"}, {"¿", "¿", "¿"}, "!",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FOURTH_ROW_P \
	{ {"abc", "abc", "abc"}, {SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME}, "", 100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Space", "Space", "Space"}, "", 349, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        65, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    100, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_LABEL_P { \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FIRST_ROW_P},  \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_SECOND_ROW_P}, \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_THIRD_ROW_P},  \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FOURTH_ROW_P}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_INFO_P {\
	{9, 11, 10}, {36, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {9, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  Symbol2 Keyboard Portrait Layout (End)
 ************************************************************************************/

/*************************************************************************************
 *  English Keyboard Landscape Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_WIDTH_L       96         /* key width for landscape mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_HEIGHT_L      65         /* key height for landscape mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_SPACING_L     16         /* the space between two columns for landscape mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_SPACING_L     14         /* the space between two rows for landscape mode */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_NUM_L         4          /* the number of rows for English keyboard for landscape mode */

/* The first row of English keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FIRST_ROW_L \
	{ {"q", "Q", "Q"}, {"q", "Q", "Q"}, "1", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"w", "W", "W"}, {"w", "W", "W"}, "2", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"e", "E", "E"}, {"e", "E", "E"}, "3", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"r", "R", "R"}, {"r", "R", "R"}, "4", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"t", "T", "T"}, {"t", "T", "T"}, "5", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"y", "Y", "Y"}, {"y", "Y", "Y"}, "6", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"u", "U", "U"}, {"u", "U", "U"}, "7", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"i", "I", "I"}, {"i", "I", "I"}, "8", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"o", "O", "O"}, {"o", "O", "O"}, "9", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"p", "P", "P"}, {"p", "P", "P"}, "0", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_SECOND_ROW_L \
	{ {"a", "A", "A"}, {"a", "A", "A"}, "-", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"s", "S", "S"}, {"s", "S", "S"}, "@", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"d", "D", "D"}, {"d", "D", "D"}, "*", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"f", "F", "F"}, {"f", "F", "F"}, "^", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"g", "G", "G"}, {"g", "G", "G"}, ":", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"h", "H", "H"}, {"h", "H", "H"}, ";", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"j", "J", "J"}, {"j", "J", "J"}, "(", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"k", "K", "K"}, {"k", "K", "K"}, ")", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"l", "L", "L"}, {"l", "L", "L"}, "~", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The third row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_THIRD_ROW_L \
	{ {"", "", ""}, {"Shift", "Shift", "Shift"}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"z", "Z", "Z"}, {"z", "Z", "Z"}, "/",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"x", "X", "X"}, {"x", "X", "X"}, "'",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"c", "C", "C"}, {"c", "C", "C"}, "\"",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"v", "V", "V"}, {"v", "V", "V"}, ".",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"b", "B", "B"}, {"b", "B", "B"}, ",",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"n", "N", "N"}, {"n", "N", "N"}, "?",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"m", "M", "M"}, {"m", "M", "M"}, "!",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "",    153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of English keyboard. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FOURTH_ROW_L \
	{ {"?123", "?123", "?123"}, {SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"English", "English", "English"}, {"Space", "Space", "Space"}, "", 544, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_LABEL_L { \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FIRST_ROW_L},  \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_SECOND_ROW_L}, \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_THIRD_ROW_L},  \
	{SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_FOURTH_ROW_L}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_INFO_L {\
	{87, 8, 10}, {144, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  English Keyboard LandScape Layout (End)
 ************************************************************************************/

/*************************************************************************************
 *  Symbol1 Keyboard LandScape Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_WIDTH_L       96         /* key width for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_HEIGHT_L      65         /* key height for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_SPACING_L     16         /* the space between two columns for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_SPACING_L     14         /* the space between two rows for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_NUM_L         4          /* the number of rows for Symbol1 keyboard for portrait mode */

/* The first row of Symbol1 keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FIRST_ROW_L \
	{ {"1", "1", "1"}, {"1", "1", "1"}, "#", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"2", "2", "2"}, {"2", "2", "2"}, "&", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"3", "3", "3"}, {"3", "3", "3"}, "%", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"4", "4", "4"}, {"4", "4", "4"}, "+", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"5", "5", "5"}, {"5", "5", "5"}, "=", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"6", "6", "6"}, {"6", "6", "6"}, "_", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"7", "7", "7"}, {"7", "7", "7"}, "\\", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"8", "8", "8"}, {"8", "8", "8"}, "|", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"9", "9", "9"}, {"9", "9", "9"}, "<", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"0", "0", "0"}, {"0", "0", "0"}, ">", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_SECOND_ROW_L \
	{ {"-", "-", "-"}, {"-", "-", "-"}, "{", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"@", "@", "@"}, {"@", "@", "@"}, "}", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"*", "*", "*"}, {"*", "*", "*"}, "[", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"^", "^", "^"}, {"^", "^", "^"}, "]", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {":", ":", ":"}, {":", ":", ":"}, "$", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {";", ";", ";"}, {";", ";", ";"}, "£", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"(", "(", "("}, {"(", "(", "("}, "¥", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {")", ")", ")"}, {")", ")", ")"}, "€", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"~", "~", "~"}, {"~", "~", "~"}, "₩", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }

/* The third row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_THIRD_ROW_L \
	{ {"1/2", "1/2", "1/2"}, {SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL2_LAYOUT_NAME}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"/", "/", "/"}, {"/", "/", "/"}, "¢",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\'", "\'", "\'"}, {"\'", "\'", "\'"}, "`",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\"", "\"", "\""}, {"\"", "\"", "\""}, "°",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."}, "·",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {",", ",", ","}, {",", ",", ","}, "®",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"?", "?", "?"}, {"?", "?", "?"}, "©",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"!", "!", "!"}, {"!", "!", "!"}, "¿",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_STRING, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "",    153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of Symbol1 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FOURTH_ROW_L \
	{ {"abc", "abc", "abc"}, {SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Space", "Space", "Space"}, "", 544, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_LABEL_L { \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FIRST_ROW_L},  \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_SECOND_ROW_L}, \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_THIRD_ROW_L},  \
	{SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_FOURTH_ROW_L}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_INFO_L {\
	{87, 8, 10}, {144, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  Symbol1 Keyboard LandScape Layout (End)
 ************************************************************************************/

/*************************************************************************************
 *  Symbol2 Keyboard LandScape Layout (Start)
 ************************************************************************************/
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_WIDTH_L       96         /* key width for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_HEIGHT_L      65         /* key height for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_SPACING_L     16         /* the space between two columns for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_SPACING_L     14         /* the space between two rows for landscape mode */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_NUM_L         4          /* the number of rows for Symbol1 keyboard for portrait mode */

/* The first row of Symbol2 keyboard. For the detail, please see private_key_label_type. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FIRST_ROW_L \
	{ {"#", "#", "#"}, {"#", "#", "#"}, "1", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} },\
	{ {"&", "&", "&"}, {"&", "&", "&"}, "2", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"%", "%", "%"}, {"%", "%", "%"}, "3", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"+", "+", "+"}, {"+", "+", "+"}, "4", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"=", "=", "="}, {"=", "=", "="}, "5", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"_", "_", "_"}, {"_", "_", "_"}, "6", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"\\", "\\", "\\"}, {"\\", "\\", "\\"}, "7", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"|", "|", "|"}, {"|", "|", "|"}, "8", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"<", "<", "<"}, {"<", "<", "<"}, "9", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {">", ">", ">"}, {">", ">", ">"}, "0", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The second row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_SECOND_ROW_L \
	{ {"{", "{", "{"}, {"{", "{", "{"}, "-", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"}", "}", "}"}, {"}", "}", "}"}, "@", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"[", "[", "["}, {"[", "[", "["}, "*", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"]", "]", "]"}, {"]", "]", "]"}, "^", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"$", "$", "$"}, {"$", "$", "$"}, ":", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"£", "£", "£"}, {"£", "£", "£"}, ";", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"¥", "¥", "¥"}, {"¥", "¥", "¥"}, "(", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"€", "€", "€"}, {"€", "€", "€"}, ")", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"₩", "₩", "₩"}, {"₩", "₩", "₩"}, "~", 0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }

/* The third row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_THIRD_ROW_L \
	{ {"2/2", "2/2", "2/2"}, {SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME, SAMPLE_NATIVE_IME_SYMBOL1_LAYOUT_NAME}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"¢", "¢", "¢"}, {"¢", "¢", "¢"}, "/",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"`", "`", "`"}, {"`", "`", "`"}, "\'",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"°", "°", "°"}, {"°", "°", "°"}, "\"",  0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"·", "·", "·"}, {"·", "·", "·"}, ".",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"®", "®", "®"}, {"®", "®", "®"}, ",",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"©", "©", "©"}, {"©", "©", "©"}, "?",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"¿", "¿", "¿"}, {"¿", "¿", "¿"}, "!",   0, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_STRING, IME_KEY_TYPE_CHAR, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Back", "Back", "Back"}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

/* The fourth row of Symbol2 keyboard. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FOURTH_ROW_L \
	{ {"abc", "abc", "abc"}, {SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME, SAMPLE_NATIVE_IME_ENGLISH_LAYOUT_NAME}, "", 153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {35, 35, 35}, {23, 23, 23} }, \
	{ {"setting", "setting", "setting"}, {SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME, SAMPLE_NATIVE_IME_OPTION_LAYOUT_NAME}, "...", 96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_MODECHANGE, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Space", "Space", "Space"}, "", 544, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {24, 24, 24}, {23, 23, 23} }, \
	{ {".", ".", "."}, {".", ".", "."},  "",        96, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CHAR, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }, \
	{ {"", "", ""}, {"Enter", "Enter", "Enter"}, "",    153, 0, IME_BUTTON_TYPE_NORMAL, IME_KEY_TYPE_CONTROL, IME_KEY_TYPE_NONE, {45, 45, 45}, {23, 23, 23} }

#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_LABEL_L { \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FIRST_ROW_L},  \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_SECOND_ROW_L}, \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_THIRD_ROW_L},  \
	{SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_FOURTH_ROW_L}  \
}

/* Define the row information. */
#define SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_INFO_L {\
	{87, 8, 10}, {144, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 9}, {87, SAMPLE_NATIVE_IME_AUTO_CAL, 5} \
}

/*************************************************************************************
 *  Symbol2 Keyboard LandScape Layout (End)
 ************************************************************************************/

/* IME_KEYBOARD_PORTRAIT_LAYOUT_ENGLISH */
#define SAMPLE_NATIVE_IME_PORTRAIT_ENGLISH_LAYOUT {\
		SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_NAME, IME_DISPLAY_MODE_PORTRAIT, SAMPLE_NATIVE_IME_IME_WIDTH_P, SAMPLE_NATIVE_IME_IME_HEIGHT_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_WIDTH_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_HEIGHT_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_SPACING_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_SPACING_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_NUM_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_INFO_P, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_LABEL_P \
	}
/* IME_KEYBOARD_PORTRAIT_LAYOUT_SYM1 */
#define SAMPLE_NATIVE_IME_PORTRAIT_SYMBOL1_LAYOUT {\
		SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_NAME, IME_DISPLAY_MODE_PORTRAIT, SAMPLE_NATIVE_IME_IME_WIDTH_P, SAMPLE_NATIVE_IME_IME_HEIGHT_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_WIDTH_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_HEIGHT_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_SPACING_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_SPACING_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_NUM_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_INFO_P, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_LABEL_P \
	}
/* IME_KEYBOARD_PORTRAIT_LAYOUT_SYM2 */
#define SAMPLE_NATIVE_IME_PORTRAIT_SYMBOL2_LAYOUT {\
		SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_NAME, IME_DISPLAY_MODE_PORTRAIT, SAMPLE_NATIVE_IME_IME_WIDTH_P, SAMPLE_NATIVE_IME_IME_HEIGHT_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_WIDTH_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_HEIGHT_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_SPACING_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_SPACING_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_NUM_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_INFO_P, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_LABEL_P \
	}

/* IME_KEYBOARD_LANDSCAPE_LAYOUT_ENGLISH */
#define SAMPLE_NATIVE_IME_LANDSCAPE_ENGLISH_LAYOUT {\
		SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_NAME, IME_DISPLAY_MODE_LANDSCAPE, SAMPLE_NATIVE_IME_IME_WIDTH_L, SAMPLE_NATIVE_IME_IME_HEIGHT_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_WIDTH_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_HEIGHT_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_SPACING_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_SPACING_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_NUM_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_ROW_INFO_L, SAMPLE_NATIVE_IME_ENGLISH_KEYBOARD_KEY_LABEL_L \
	}
/* IME_KEYBOARD_LANDSCAPE_LAYOUT_SYM1 */
#define SAMPLE_NATIVE_IME_LANDSCAPE_SYMBOL1_LAYOUT {\
		SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_NAME, IME_DISPLAY_MODE_LANDSCAPE, SAMPLE_NATIVE_IME_IME_WIDTH_L, SAMPLE_NATIVE_IME_IME_HEIGHT_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_WIDTH_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_HEIGHT_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_SPACING_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_SPACING_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_NUM_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_ROW_INFO_L, SAMPLE_NATIVE_IME_SYMBOL1_KEYBOARD_KEY_LABEL_L \
	}
/* IME_KEYBOARD_LANDSCAPE_LAYOUT_SYM2 */
#define SAMPLE_NATIVE_IME_LANDSCAPE_SYMBOL2_LAYOUT {\
		SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_NAME, IME_DISPLAY_MODE_LANDSCAPE, SAMPLE_NATIVE_IME_IME_WIDTH_L, SAMPLE_NATIVE_IME_IME_HEIGHT_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_WIDTH_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_HEIGHT_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_SPACING_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_SPACING_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_NUM_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_ROW_INFO_L, SAMPLE_NATIVE_IME_SYMBOL2_KEYBOARD_KEY_LABEL_L \
	}

/* Describe the layout for different keyboard */
static private_layout_type g_keyboard_layout_type[IME_DISPLAY_MODE_MAX][IME_KEYBOARD_LAYOUT_MAX] = {
	{
	 SAMPLE_NATIVE_IME_PORTRAIT_ENGLISH_LAYOUT,
	 SAMPLE_NATIVE_IME_PORTRAIT_SYMBOL1_LAYOUT,
	 SAMPLE_NATIVE_IME_PORTRAIT_SYMBOL2_LAYOUT},
	{
	 SAMPLE_NATIVE_IME_LANDSCAPE_ENGLISH_LAYOUT,
	 SAMPLE_NATIVE_IME_LANDSCAPE_SYMBOL1_LAYOUT,
	 SAMPLE_NATIVE_IME_LANDSCAPE_SYMBOL2_LAYOUT}
};

#endif /* SAMPLENATIVEIMECONFIG_H_ */
