/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SAMPLENATIVEIMEUITYPES_H_
#define SAMPLENATIVEIMEUITYPES_H_

typedef unsigned char BYTE;
typedef unsigned short UShort;

#ifndef NULL
#define NULL 0
#endif

#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_NAME                255   /* the max length for file name */
#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_PATH                255   /* the max length for path */
#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_LABEL_FOR_ONE       9     /* the max number of label for one key */
#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_KEY_VALUE           10    /* the max number of value for one key */
#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_ROW_NUMBER          6     /* the max row number for layout */
#define SAMPLE_NATIVE_IME_MAX_SIZE_OF_KEYS_FOR_ONE_ROW    15    /* the max number of key for one row */

#define SAMPLE_NATIVE_IME_IME_WIDTH_P                     720	/* the width of keyboard window for portrait mode */
#define SAMPLE_NATIVE_IME_IME_HEIGHT_P                    442   /* the height of keyboard window for portrait mode */
#define SAMPLE_NATIVE_IME_IME_WIDTH_L                     1280	/* the width of keyboard window for landscape mode */
#define SAMPLE_NATIVE_IME_IME_HEIGHT_L                    318   /* the height of keyboard window for landscape mode */

#define SAMPLE_NATIVE_IME_RESOLUTION_W                    720	/* the width of ui resolutions for design */
#define SAMPLE_NATIVE_IME_RESOLUTION_H                    1280  /* the height of ui resolutions for design */

/* the color type */
typedef struct _IMEColor {
	BYTE r;
	BYTE g;
	BYTE b;
	BYTE a;
} IMEColor;

/* the row information type*/
typedef struct _IMELayoutRowInfo {
	UShort x;
	UShort y;
	UShort key_number;
} IMELayoutRowInfo;

/*row information for key*/
typedef struct _IMEKeyRowInfo {
	UShort row;
	UShort col;
} IMEKeyRowInfo;

/* display mode for layout */
typedef enum _IMEDisplayMode {
	IME_DISPLAY_MODE_PORTRAIT,
	IME_DISPLAY_MODE_LANDSCAPE,
	IME_DISPLAY_MODE_MAX,
} IMEDisplayMode;

/* key type for key */
typedef enum _IMEKeyType {
	IME_KEY_TYPE_NONE,
	IME_KEY_TYPE_CHAR,
	IME_KEY_TYPE_CONTROL,
	IME_KEY_TYPE_MODECHANGE,
	IME_KEY_TYPE_STRING,
	IME_KEY_TYPE_USER,
	IME_KEY_TYPE_MAX,
} IMEKeyType;

/* button type for key */
typedef enum _IMEButtonType {
	IME_BUTTON_TYPE_NORMAL,
	IME_BUTTON_TYPE_SELFISH,
	IME_BUTTON_TYPE_UIITEM,
	IME_BUTTON_TYPE_MAX,
} IMEButtonType;

/* button state for key*/
typedef enum _IMEButtonState {
	IME_BUTTON_STATE_NORMAL,
	IME_BUTTON_STATE_PRESSED,
	IME_BUTTON_STATE_DISABLED,
	IME_BUTTON_STATE_MAX,
} IMEButtonState;

/* the shift key state*/
typedef enum _IMEShiftStates {
	IME_SHIFT_STATE_OFF,
	IME_SHIFT_STATE_ON,
	IME_SHIFT_STATE_LOCK,
	IME_SHIFT_STATE_MAX,
} IMEShiftState;

/* the layout type */
typedef enum _IMEKeyboardLayoutType {
	IME_KEYBOARD_LAYOUT_ENGLISH,
	IME_KEYBOARD_LAYOUT_SYM1,
	IME_KEYBOARD_LAYOUT_SYM2,
	IME_KEYBOARD_LAYOUT_OPTION,
	IME_KEYBOARD_LAYOUT_MAX
} IMEKeyboardLayoutType;

#endif /* SAMPLENATIVEIMEUITYPES_H_ */
