/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SAMPLENATIVEIMEFEEDBACK_H_
#define _SAMPLENATIVEIMEFEEDBACK_H_
#include <feedback.h>
#include <Elementary.h>

/**
 * @brief set sound feedback status
 *
 * @param status the sound feedback status
 *
 * @return void
 */
void sample_native_ime_set_sound_feedback_status(Eina_Bool status);

/**
 * @brief set vibration feedback status
 *
 * @param status the vibration feedback status
 *
 * @return void
 */
void sample_native_ime_set_vibration_feedback_status(Eina_Bool status);

/**
 * @brief get sound feedback status
 *
 * @param void
 *
 * return the sound feedback status
 */
Eina_Bool sample_native_ime_get_sound_feedback_status();

/**
 * @brief get vibration feedback status
 *
 * @param void
 *
 * return the vibration feedback status
 */
Eina_Bool sample_native_ime_get_vibration_feedback_status();

/**
 * @brief initialize the feedback
 *        before using, feedback should be initialized at first
 *
 * @param void
 *
 * @return feedback initialize successful or not
 */
void sample_native_ime_feedback_initialize(void);

/**
 * @brief deinitialize the feedback
 *        before exiting, feedback should be deinitialized at first
 *
 * @param void
 *
 * @return feedback deinitialize successful or not
 */
void sample_native_ime_feedback_deinitialize(void);

/**
 * @brief play feedback
 *
 * @param void
 *
 * @return void
 */
void sample_native_ime_feedback();

#endif /* _SAMPLENATIVEIMEFEEDBACK_H_ */
