/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.tpklib.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.tizen.tpklib.core.TPKPolicy;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.lib.Command;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.Platform;
import org.tizen.tpklib.lib.file.FileUtil;
import org.tizen.tpklib.model.BuildOption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TPKInstaller {
    private static int buildCommandType = 0;
    private static String arch = "";
    private static final String TIZEN_MANIFEST = "tizen-manifest.xml";
    private static final String ARM = "arm";
    private static final String ARM_32 = "arm_32";
    private static final String ARM_64 = "arm_64";
    private static final String X86 = "x86";
    private static final String AARCH64 = "aarch64";
    private static final String X86_64 = "x86_64";
    private static final String RISCV = "riscv";
    private static final String RISCV64 = "riscv64";
    private static final String RISCV_32 = "riscv_32";
    private static final String RISCV_64 = "riscv_64";
    private static boolean packWithVersionChange = false;

    public static void setBuildCommandType(int buildCommandType) {
        TPKInstaller.buildCommandType = buildCommandType;
    }

    public static void setPackWithVersionChange(boolean packWithVersionChange) {
        TPKInstaller.packWithVersionChange = packWithVersionChange;
    }

    public static void setArch(String arch) {
        TPKInstaller.arch = arch;
    }

    public boolean install(String buildDir, Map<String, String> includeMap, List<String> excludeList) throws TPKException {
        if (buildDir == null || buildDir.isEmpty()) {
            throw new TPKException("Build directory is empty");
        }
        if (includeMap == null || includeMap.isEmpty()) {
            throw new TPKException("The list for package is empty");
        }
        this.removeExcludeList(buildDir, includeMap, excludeList);
        for (String src : includeMap.keySet()) {
            String dstPath = PathUtil.addPath(buildDir, ".tpk", includeMap.get(src));
            this.install(src, dstPath);
        }
        TPKInstaller.installExceptionsDirectory(PathUtil.addPath(buildDir, ".tpk"));
        return true;
    }

    private boolean install(String src, String dst) throws TPKException {
        if (src == null || dst == null) {
            throw new TPKException(String.format("Cannot install from \"%s\" to \"%s\"", src, dst));
        }
        File srcFile = new File(src);
        File dstFile = new File(dst);
        if (!srcFile.exists()) {
            if (!dstFile.exists()) {
                if (!dstFile.mkdirs()) {
                    throw new TPKException(String.format("Cannot create directory(%s)", dst));
                }
                return true;
            }
            if (dstFile.isDirectory()) {
                return true;
            }
            throw new TPKException(String.format("File do not exist(%s)", src));
        }
        if (srcFile.isDirectory()) {
            if (!dstFile.exists() || !dstFile.isDirectory()) {
                if (!dstFile.mkdirs()) {
                    throw new TPKException(String.format("Cannot create directory(%s)", dst));
                }
                return true;
            }
            if (dstFile.isDirectory()) {
                return true;
            }
        }
        if (dstFile.exists() && !dstFile.delete()) {
            throw new TPKException(String.format("Cannot delete file(%s)", dst));
        }
        File parentFile = dstFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            try {
                throw new TPKException(String.format("Cannot create directory(%s)", parentFile.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new TPKException(e);
            }
        }
        try {
            try {
                Path srcPath = srcFile.toPath();
                if (Files.isSymbolicLink(srcPath)) {
                    Files.createSymbolicLink(dstFile.toPath(), Files.readSymbolicLink(srcPath), new FileAttribute[0]);
                } else if (!Command.cp(srcFile.getCanonicalPath(), dstFile.getCanonicalPath())) {
                    throw new TPKException(String.format("Cannot copy from (%s) to (%s)", srcFile.getCanonicalPath(), dstFile.getCanonicalPath()));
                }
            }
            catch (InterruptedException e) {
                throw new TPKException(e);
            }
            return true;
        }
        catch (IOException e) {
            throw new TPKException(e);
        }
    }

    private void removeExcludeList(String buildDir, Map<String, String> includeMap, List<String> excludeList) throws TPKException {
        if (includeMap == null || excludeList == null) {
            return;
        }
        for (String excludeFilePath : excludeList) {
            try {
                includeMap.remove(FileUtil.getCanonicalPath(excludeFilePath));
            }
            catch (IOException e) {
                throw new TPKException(e);
            }
        }
    }

    public static void install(BuildOption bOpt) throws TPKException {
        TPKInstaller.install(bOpt.getIncludeList(), bOpt.getPackageDirPath());
    }

    public static void install(Map<String, String> installMap, String targetDir) throws TPKException {
        if (FileUtil.existsPath(targetDir)) {
            try {
                FileUtil.removeFile(targetDir);
            }
            catch (IOException e) {
                throw new TPKException(e);
            }
        }
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : installMap.keySet()) {
            File keyFile = new File(key);
            if (!Files.isSymbolicLink(keyFile.toPath())) continue;
            try {
                Path parentPath = keyFile.toPath().getParent();
                Path test = Files.readSymbolicLink(keyFile.toPath());
                if (parentPath == null) continue;
                Path finalPath = parentPath.resolve(test);
                removeList.add(finalPath.toString());
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
        for (String key : removeList) {
            installMap.remove(key);
        }
        for (String key : installMap.keySet()) {
            TPKInstaller.install(key, installMap.get(key), targetDir);
        }
        TPKInstaller.installExceptionsDirectory(targetDir);
    }

    public static void install(String src, String dstRelativePath, String targetDir) throws TPKException {
        File parentFile;
        if (src == null || dstRelativePath == null) {
            throw new TPKException(String.format("Cannot install from \"%s\" to \"%s\"", src, dstRelativePath));
        }
        File srcFile = new File(src);
        File dstFile = new File(targetDir, dstRelativePath);
        if (!srcFile.exists()) {
            if (!dstFile.exists()) {
                if (!dstFile.mkdirs()) {
                    throw new TPKException(String.format("Cannot create directory(%s)", dstRelativePath));
                }
                return;
            }
            if (dstFile.isDirectory()) {
                return;
            }
            throw new TPKException(String.format("File do not exist(%s)", src));
        }
        if (srcFile.isDirectory()) {
            if (!dstFile.exists() || !dstFile.isDirectory()) {
                if (!dstFile.mkdirs()) {
                    throw new TPKException(String.format("Cannot create directory(%s)", dstRelativePath));
                }
                return;
            }
            if (dstFile.isDirectory()) {
                return;
            }
        }
        if ((parentFile = dstFile.getParentFile()) != null && !parentFile.exists() && !parentFile.mkdirs()) {
            try {
                throw new TPKException(String.format("Cannot create directory(%s)", parentFile.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new TPKException(e);
            }
        }
        if (TIZEN_MANIFEST.equals(Paths.get(src, new String[0]).getFileName().toString()) && (buildCommandType != 0 || packWithVersionChange)) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                int i;
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                Document document = docBuilder.parse(srcFile);
                Element root = document.getDocumentElement();
                if (buildCommandType == 2 || packWithVersionChange) {
                    HashMap<String, String> archVersion = new HashMap<String, String>();
                    archVersion.put(ARM, "1032");
                    archVersion.put(X86, "2032");
                    archVersion.put(AARCH64, "1064");
                    archVersion.put(X86_64, "2064");
                    archVersion.put(RISCV, "3032");
                    archVersion.put(RISCV64, "3064");
                    String version = root.getAttribute("version");
                    Object[] split = version.split("[.]");
                    int count = split.length;
                    version = count >= 3 ? TPKInstaller.join(split, ".", count - 3, count) : (count == 2 ? String.join((CharSequence)".", (CharSequence[])split) + ".0" : String.join((CharSequence)".", (CharSequence[])split) + ".0.0");
                    root.setAttribute("version", version + "." + (String)archVersion.get(arch));
                }
                Element architecture = document.createElement("architecture");
                if (ARM.equals(arch)) {
                    arch = ARM_32;
                } else if (AARCH64.equals(arch)) {
                    arch = ARM_64;
                } else if (RISCV.equals(arch)) {
                    arch = RISCV_32;
                } else if (RISCV64.equals(arch)) {
                    arch = RISCV_64;
                }
                architecture.appendChild(document.createTextNode(arch));
                NodeList refChild = root.getChildNodes();
                for (i = 0; i < refChild.getLength() && !"profile".equals(refChild.item(i).getNodeName()); ++i) {
                }
                root.insertBefore(architecture, refChild.item(i + 1));
                TPKInstaller.removeEmptyText(document.getDocumentElement());
                DOMSource source = new DOMSource(document);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                StreamResult result = new StreamResult(dstFile);
                transformer.transform(source, result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new TPKException(e);
            }
        }
        try {
            if (!TIZEN_MANIFEST.equals(Paths.get(src, new String[0]).getFileName().toString()) || buildCommandType == 0 && !packWithVersionChange) {
                Files.copy(srcFile.toPath(), dstFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                TPKInstaller.setDefaultPermission(dstFile);
            }
        }
        catch (IOException e) {
            throw new TPKException(e);
        }
    }

    private static void removeEmptyText(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (child.getNodeType() == 3) {
                if (child.getTextContent().trim().isEmpty()) {
                    node.removeChild(child);
                }
            } else {
                TPKInstaller.removeEmptyText(child);
            }
            child = sibling;
        }
    }

    private static String join(Object[] array, String separator, int startIndex, int endIndex) {
        int bufSize;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((bufSize = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static void setDefaultPermission(File dstFile) throws IOException {
        if (Platform.isLinux()) {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.GROUP_EXECUTE);
            perms.add(PosixFilePermission.OTHERS_READ);
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
            Files.setPosixFilePermissions(dstFile.toPath(), perms);
        }
    }

    private static void installExceptionsDirectory(String packagingDir) throws TPKException {
        for (String exceptionDir : TPKPolicy.getEmptyDirectoryList()) {
            String path = PathUtil.addPath(packagingDir, exceptionDir);
            try {
                FileUtil.removeFileR(path);
                FileUtil.makeDirs(path);
            }
            catch (IOException e) {
                throw new TPKException(e);
            }
        }
    }
}

