/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.IOException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import ttrace.handlers.CheckboxManager;
import ttrace.handlers.Environment;
import ttrace.handlers.ProgressBarUpdateAnotherThread;
import ttrace.handlers.State;

class TTraceWaitingState
implements State {
    private static TTraceWaitingState state;
    private static Button mainButton;
    private static Combo timeCombo;
    private static int i;

    private TTraceWaitingState(Button btn, Combo timeText) {
        mainButton = btn;
        timeCombo = timeText;
    }

    public static State getInstance() {
        return state;
    }

    public static State getInstance(Button btn, Combo timeText) {
        if (state == null) {
            state = new TTraceWaitingState(btn, timeText);
        }
        mainButton = btn;
        timeCombo = timeText;
        return state;
    }

    public static void setMainButtonEnable(boolean flag) {
        mainButton.setEnabled(flag);
    }

    public static void setMainButtonProgress(String str) {
        if (++i % 3 == 0) {
            mainButton.setText(String.valueOf(str) + ".");
        } else if (i % 3 == 1) {
            mainButton.setText(String.valueOf(str) + "..");
        } else if (i % 3 == 2) {
            mainButton.setText(String.valueOf(str) + "...");
        } else {
            mainButton.setText(String.valueOf(str) + "...");
        }
    }

    @Override
    public void doAction() {
        System.out.println("doAction::Waiting");
        Environment env = Environment.getInstance();
        env.setStrOutputFilename();
        env.setStrOutputTempFile();
        env.setComposeCmd("--from-file", env.getAsyncTrace());
        env.setStartCmd(CheckboxManager.getTags(), true);
        env.setStopCmd(CheckboxManager.getTags(), true);
        env.setPullCmd();
        System.out.println("StartCMD::::" + env.getStartCmd());
        System.out.println("StopCMD::::" + env.getStopCmd());
        TTraceWaitingState.setMainButtonEnable(false);
        try {
            ProgressBarUpdateAnotherThread.startProgress(Environment.getInstance(), timeCombo.getText());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            ProgressBarUpdateAnotherThread.stopProgress(Environment.getInstance());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ProgressBarUpdateAnotherThread.composeHtml(env);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TTraceWaitingState.setMainButtonEnable(true);
    }

    @Override
    public boolean prepareAction() {
        System.out.println("prepareAction::Waiting");
        i = 0;
        mainButton.setText("Waiting");
        return true;
    }

    @Override
    public String getState() {
        return "Waiting";
    }

    @Override
    public String getTimeState() {
        return timeCombo.getText();
    }

    @Override
    public boolean prepareAction(boolean isRefresh) {
        return false;
    }
}

