/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.widgets.Display;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import ttrace.handlers.ProcessExecStream;
import ttrace.handlers.StateManager;
import ttrace.handlers.TTraceNotConnectedState;
import ttrace.handlers.TTraceReadyState;

public class SDBconnection {
    private static SmartDevelopmentBridge sdbBridge;
    private static String strSDBpath;
    private static IDevice[] devs;
    private static IDevice dev;
    private static SDBconnection sdbInstance;
    private static IDeviceChangeListener deviceChanged;

    static {
        deviceChanged = new IDeviceChangeListener(){

            public void onDisconnected(IDevice device) {
                System.out.println("disconnected");
                this.onDisconnectedInternal(device);
            }

            public void onConnected(IDevice device) {
                System.out.println("connected");
                this.onConnectedInternal(device);
            }

            public void onChanged(IDevice device, int changeMask) {
                System.out.println("onChanged");
                System.out.println("Device changed: " + device.getSerialNumber() + " " + changeMask);
                if (1 == changeMask) {
                    this.onConnectedInternal(device);
                } else {
                    System.out.println("Device changed type: " + changeMask);
                }
            }

            private void onDisconnectedInternal(IDevice device) {
                System.out.println("onDisconnectedInternal");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StateManager.getInstance().setState(TTraceNotConnectedState.getInstance());
                        StateManager.getInstance().prepareAction();
                    }
                });
            }

            private void onConnectedInternal(IDevice device) {
                System.out.println("onConnectedInternal");
                SDBconnection.initialize();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StateManager.getInstance().setState(TTraceReadyState.getInstance());
                        StateManager.getInstance().prepareAction(true);
                    }
                });
            }
        };
    }

    private SDBconnection() {
        SDBconnection.initialize();
        System.out.println("SDBconnection::SDBconnection() -sdb PATH - " + strSDBpath);
    }

    public static SDBconnection getInstance() {
        if (sdbInstance == null) {
            sdbInstance = new SDBconnection();
        }
        return sdbInstance;
    }

    public SmartDevelopmentBridge getSDBbrigde() {
        if (!sdbBridge.isConnected()) {
            sdbBridge.restart();
        }
        return sdbBridge;
    }

    private static void initialize() {
        strSDBpath = InstallPathConfig.getSDBPath();
        sdbBridge = sdbBridge == null ? SmartDevelopmentBridge.createBridge((String)strSDBpath) : sdbInstance.getSDBbrigde();
        devs = sdbBridge.getDevices();
        dev = devs.length != 0 ? devs[0] : null;
    }

    public static String getSDBpath() {
        System.out.println("SDBconnection::getSDBpath: " + strSDBpath);
        if (strSDBpath == null) {
            strSDBpath = InstallPathConfig.getSDBPath();
        }
        return strSDBpath;
    }

    public static boolean getState_bool() {
        if (dev == null) {
            devs = sdbBridge.getDevices();
            if (devs.length == 0) {
                return false;
            }
            SDBconnection.retryConnection();
            SDBconnection.initialize();
        }
        if (!dev.getState().toString().equals("OFFLINE") && !dev.getState().toString().equals("UNKNOWN")) {
            return !dev.getState().toString().equals("NONE");
        }
        SDBconnection.retryConnection();
        SDBconnection.initialize();
        return false;
    }

    public static String getState() {
        System.out.println("SDBconnection::getState() - started");
        Process p = null;
        ByteArrayOutputStream errST = new ByteArrayOutputStream();
        ByteArrayOutputStream outST = new ByteArrayOutputStream();
        String tempList = new String();
        while (tempList.isEmpty()) {
            tempList = new String();
            try {
                p = Runtime.getRuntime().exec(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace -h");
                ProcessExecStream errStream = new ProcessExecStream(p.getErrorStream(), errST);
                ProcessExecStream inputStream = new ProcessExecStream(p.getInputStream(), outST);
                inputStream.start();
                errStream.start();
                p.waitFor();
                while (!inputStream.isComplete() && !errStream.isComplete()) {
                    System.out.println("Wait until reading stream is completed");
                }
                tempList = new String(inputStream.getOutputStream().toByteArray());
                tempList = String.valueOf(tempList) + new String(errStream.getOutputStream().toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("SDBconnection::getState(): " + tempList);
        if (tempList.contains("target not found") || tempList.contains("target offline")) {
            return "NotConnected";
        }
        if (tempList.contains("command not found")) {
            return "NotSupported";
        }
        if (tempList.contains("more than one target found")) {
            return "NotOneTarget";
        }
        if (tempList.contains("invalid option")) {
            return "Connected";
        }
        return "Unknown";
    }

    public static String getStateRefresh() {
        Process p = null;
        ByteArrayOutputStream errST = new ByteArrayOutputStream();
        ByteArrayOutputStream outST = new ByteArrayOutputStream();
        System.out.println("SDBconnection::getStateRefresh() -- started");
        String tempList = new String();
        while (tempList.isEmpty()) {
            tempList = new String();
            try {
                String cmd = String.valueOf(SDBconnection.getSDBpath()) + " shell anomy_ttrace_test";
                p = Runtime.getRuntime().exec(cmd);
                ProcessExecStream errStream = new ProcessExecStream(p.getErrorStream(), errST);
                ProcessExecStream inputStream = new ProcessExecStream(p.getInputStream(), outST);
                errStream.start();
                inputStream.start();
                p.waitFor();
                while (!inputStream.isComplete()) {
                    System.out.println("Wait until reading stream is completed");
                }
                tempList = new String(inputStream.getOutputStream().toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("SDBconnection::getStateRefresh(): " + tempList);
        if (tempList.contains("target not found") || tempList.contains("target offline")) {
            return "NotConnected";
        }
        if (tempList.contains("more than one target found")) {
            return "NotOneTarget";
        }
        if (tempList.contains("command not found")) {
            return "Connected";
        }
        return "Unknown";
    }

    public static ArrayList<String> getListCategories() {
        System.out.println("SDBconnection::getListCategories() -- started");
        Process p = null;
        String tempList = new String();
        try {
            String[] cmd = new String[]{SDBconnection.getSDBpath(), "shell", "atrace", "--list_categories"};
            p = Runtime.getRuntime().exec(cmd);
            ProcessExecStream errStream = new ProcessExecStream(p.getErrorStream(), new ByteArrayOutputStream());
            ProcessExecStream inputStream = new ProcessExecStream(p.getInputStream(), new ByteArrayOutputStream());
            errStream.start();
            inputStream.start();
            p.waitFor();
            tempList = new String(inputStream.getOutputStream().toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("SDBconnection::getListCategories(): " + tempList);
        String[] strCategory = tempList.split("\n");
        ArrayList<String> mList = new ArrayList<String>(Arrays.asList(strCategory));
        int i = 0;
        while (i < mList.size()) {
            mList.set(i, mList.get(i).trim().split("-")[0].trim());
            ++i;
        }
        System.out.println("SDBconnection::getListCategories_end");
        return mList;
    }

    public static void killServer() {
        System.out.println("SDBconnection::killServer()");
        try {
            dev.executeShellCommand("kill-server");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void startServer() {
        System.out.println("SDBconnection::startServer()");
        try {
            dev.executeShellCommand("start-server");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void retryConnection() {
        System.out.println("SDBconnection::retryConnection()");
        SDBconnection.throwCommand("kill-server");
    }

    public static void getSUpermission() {
        System.out.println("SDBconnection::getSUpermission()");
        SDBconnection.throwCommand("root on");
    }

    public static void throwCommand(String strCmd) {
        System.out.println("SDBconnection::throwCommand(): " + strCmd);
        try {
            Process p = Runtime.getRuntime().exec(String.valueOf(SDBconnection.getSDBpath()) + " " + strCmd);
            p.getErrorStream().close();
            p.getInputStream().close();
            p.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void addDeviceListener() {
        SmartDevelopmentBridge.addDeviceChangeListener((IDeviceChangeListener)deviceChanged);
        System.out.println("connSDB::addDeviceListener");
    }

    public void removeDeviceListener() {
        SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)deviceChanged);
        System.out.println("connSDB::removeDeviceListener");
    }

    public static enum ConnectionState {
        NO,
        OFFLINE,
        ONLINE;

    }
}

