/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.IOException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import ttrace.handlers.CheckboxManager;
import ttrace.handlers.Environment;
import ttrace.handlers.State;
import ttrace.handlers.StateManager;
import ttrace.handlers.ThreadBootupTracing;

class TTraceBootupState
implements State {
    private ThreadBootupTracing trace;
    private Thread thread;
    private static TTraceBootupState state;
    private static Button mainButton;
    private static Combo timeCombo;

    private TTraceBootupState(Button btn, Combo timeCombo) {
        mainButton = btn;
        TTraceBootupState.timeCombo = timeCombo;
    }

    public static State getInstance() {
        return state;
    }

    public static State getInstance(Button btn, Combo timeCombo) {
        if (state == null) {
            state = new TTraceBootupState(btn, timeCombo);
        }
        mainButton = btn;
        TTraceBootupState.timeCombo = timeCombo;
        return state;
    }

    @Override
    public void doAction() {
        System.out.println("doAction::Bootup");
        mainButton.setText("Stop");
        mainButton.setEnabled(true);
        try {
            this.trace.asyncCommand(Environment.getInstance().getStopCmd());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.trace.composeHtml(Environment.getInstance().getComposeCmd());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean prepareAction() {
        System.out.println("prepareAction::Bootup");
        Environment env = Environment.getInstance();
        env.setBootupCmd(CheckboxManager.getTags());
        env.setStopCmd(CheckboxManager.getTags(), true);
        env.setStrOutputFilename();
        env.setStrOutputTempFile();
        env.setComposeCmd("--from-file", env.getBootupTrace());
        this.trace = new ThreadBootupTracing(mainButton);
        this.thread = new Thread(this.trace);
        StateManager.setBootupThread(this.thread);
        this.thread.start();
        return true;
    }

    @Override
    public String getState() {
        return "Async";
    }

    @Override
    public String getTimeState() {
        return timeCombo.getText();
    }

    @Override
    public boolean prepareAction(boolean isRefresh) {
        return false;
    }
}

