/*
 * Decompiled with CFR 0.152.
 */
package ttrace;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfiguration;
import org.tizen.nativecommon.launch.ui.shortcut.TizenLaunchShortcut;
import org.tizen.sdblib.IDevice;

public class LaunchShortcut
extends TizenLaunchShortcut {
    private static String prevBuildConfigName = null;

    static String getPrevBuildConfigName() {
        String returnValue = prevBuildConfigName;
        prevBuildConfigName = null;
        return returnValue;
    }

    private ILaunchConfiguration createLaunchConfiguration(GomLaunchData data) {
        ILaunchConfiguration config = null;
        IProject project = data.getProject();
        IDevice device = LaunchUtils.getCurrentDeployDevice();
        try {
            String projectName = project.getName();
            String configName = data.getLaunchConfigurationName();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configName));
            TizenLaunchConfiguration tc = new TizenLaunchConfiguration(wc, device);
            tc.setDefaults();
            String programName = String.valueOf(ProjectUtil.getDefaultConfiguration((IProject)project).getName()) + File.separatorChar + ProjectUtil.getBinaryName((IProject)project);
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            wc.setMappedResources(new IResource[]{project});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
            LaunchUtils.setDeviceToLaunchConfiguration((ILaunchConfigurationWorkingCopy)wc, (IDevice)device);
            this.setStopAtMain(wc, project);
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                String buildConfigName = projDes.getActiveConfiguration().getName();
                wc.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", buildConfigName);
                config = wc.doSave();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return config;
    }

    public ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("%ttraceProfileConfigTypeID");
    }

    public void smartLaunch(final GomLaunchData data) {
        final ILaunchConfiguration configuration = this.createLaunchConfiguration(data);
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)data.getMode());
            }
        });
    }
}

