/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.web.common.ChromeLauncher;
import org.tizen.web.common.WebCommonActivator;
import ttrace.handlers.OSValidator;
import ttrace.handlers.SDBconnection;

public class Environment {
    private String strBaseCmd = new String("atrace -b 10240");
    private String strScriptPath;
    private String strCmdPath;
    private String strOutputPath;
    private String strOutputFilename;
    private String strOutputTempFile;
    private String strAsyncTrace;
    private String strBootupTrace;
    private String strBootupConf;
    private String strStartCmd;
    private String strStopCmd;
    private String strDumpCmd;
    private String strBootupCmd;
    private String strComposeCmd;
    private String strPullCmd;
    private ChromeLauncher launcher = new ChromeLauncher();
    private String strChromeOptions = new String("--no-first-run --activate-on-launch --no-default-browser-check --allow-file-access-from-files --disable-web-security --disable-translate --proxy-auto-detect --proxy-bypass-list=127.0.0.10");
    private boolean flagBootup = false;
    private static Environment envInstance;

    private Environment() {
        this.strScriptPath = new String(String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "ttrace");
        this.strCmdPath = new String(String.valueOf(InstallPathConfig.getToolsPath()) + File.separator + "ttrace" + File.separator + "ttrace.py");
        this.strOutputPath = new String(String.valueOf(this.strScriptPath) + File.separator + "trace");
        this.strOutputFilename = new String(String.valueOf(File.separator) + "trace.html");
        this.strOutputTempFile = new String(String.valueOf(File.separator) + "trace.txt");
        this.strAsyncTrace = new String(String.valueOf(File.separator) + "async.trace");
        this.strBootupTrace = new String(String.valueOf(File.separator) + "bootup.trace");
        this.strBootupConf = new String(String.valueOf(File.separator) + "ttrace.conf");
    }

    public static Environment getInstance() {
        if (envInstance == null) {
            envInstance = new Environment();
        }
        return envInstance;
    }

    public String getScriptPath() {
        return this.strScriptPath;
    }

    public String getCmdPath() {
        return this.strCmdPath;
    }

    public String getTracePath() {
        return this.strOutputPath;
    }

    public String getBaseCommand() {
        return this.strBaseCmd;
    }

    public void setStrOutputFilename() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currentTime = new Date();
        String strTime = formatter.format(currentTime);
        this.strOutputFilename = new String(String.valueOf(File.separator) + "trace" + strTime + ".html");
    }

    public void setStrOutputTempFile() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currentTime = new Date();
        String strTime = formatter.format(currentTime);
        this.strOutputTempFile = new String(String.valueOf(File.separator) + "trace" + strTime + ".text");
    }

    public void setComposeCmd(String from) {
        if (from.equals("--from-text-file")) {
            this.strComposeCmd = new String(String.valueOf(this.strCmdPath) + " --from-text-file " + this.strOutputPath + this.strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename);
        } else if (from.equals("--from-file")) {
            this.strComposeCmd = new String(String.valueOf(this.strCmdPath) + " --from-file " + this.strOutputPath + this.strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename);
        } else {
            System.out.println("Compose COMMAND:::Wrong parameter");
        }
        System.out.println("Compose COMMAND:::" + this.strComposeCmd);
    }

    public void setComposeCmd(String from, String strOutputTempFile) {
        if (from.equals("--from-text-file")) {
            this.strComposeCmd = OSValidator.isWindows() ? new String(String.valueOf(this.strCmdPath) + " --from-text-file=" + this.strOutputPath + strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename).replace('\\', '/').replace('\\', '/') : new String(String.valueOf(this.strCmdPath) + " --from-text-file=" + this.strOutputPath + strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename);
        } else if (from.equals("--from-file")) {
            this.strComposeCmd = OSValidator.isWindows() ? new String(String.valueOf(this.strCmdPath) + " --from-file-win=" + this.strOutputPath + strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename).replace('\\', '/').replace('\\', '/') : new String(String.valueOf(this.strCmdPath) + " --from-file=" + this.strOutputPath + strOutputTempFile + " -o " + this.strOutputPath + this.strOutputFilename);
        } else {
            System.out.println("Compose COMMAND:::Wrong parameter");
        }
        System.out.println("Compose COMMAND:::" + this.strComposeCmd);
    }

    public void setStartCmd(String cmd) {
        this.strStartCmd = new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_start");
    }

    public void setStopCmd(String cmd) {
        this.strStopCmd = new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_stop");
    }

    public void setDumpCmd(String cmd) {
        this.strDumpCmd = new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_dump");
    }

    public void setStartCmd(String cmd, boolean comp) {
        this.strStartCmd = comp ? (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " -z --async_start\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_start")) : (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " --async_start\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " --async_start"));
    }

    public void setStopCmd(String cmd, boolean comp) {
        this.strStopCmd = comp ? (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " -z --async_stop > /tmp/trace\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_stop")) : (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " --async_stop > /tmp/trace\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " --async_stop"));
    }

    public void setDumpCmd(String cmd, boolean comp) {
        this.strDumpCmd = comp ? (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " -z --async_dump > /tmp/trace\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " -z --async_dump")) : (OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " shell \"atrace " + cmd + " --async_dump > /tmp/trace\"").replace('\\', '/').replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " shell atrace " + cmd + " --async_dump"));
    }

    public void setPullCmd() {
        this.strPullCmd = OSValidator.isWindows() ? new String(String.valueOf(SDBconnection.getSDBpath()) + " pull /tmp/trace " + this.strOutputPath + this.strAsyncTrace).replace('\\', '/') : new String(String.valueOf(SDBconnection.getSDBpath()) + " pull /tmp/trace " + this.strOutputPath + this.strAsyncTrace);
    }

    public void setBootupCmd(String cmd) {
        this.strBootupCmd = new String("atrace " + cmd + " -z --async_start");
    }

    public void setFlagBootup(boolean flag) {
        this.flagBootup = flag;
    }

    public String getStrOutputFilename() {
        return this.strOutputFilename;
    }

    public String getStrOutputTempFile() {
        return this.strOutputTempFile;
    }

    public String getAsyncTrace() {
        return this.strAsyncTrace;
    }

    public String getBootupTrace() {
        return this.strBootupTrace;
    }

    public String getStartCmd() {
        return this.strStartCmd;
    }

    public String getStopCmd() {
        return this.strStopCmd;
    }

    public String getDumpCmd() {
        return this.strDumpCmd;
    }

    public String getComposeCmd() {
        return this.strComposeCmd;
    }

    public boolean getFlagBootup() {
        return this.flagBootup;
    }

    public String getBootupCmd() {
        return this.strBootupCmd;
    }

    public String getBootupConf() {
        return this.strBootupConf;
    }

    public String getPullCmd() {
        return this.strPullCmd;
    }

    public void launchChrome(String filename) {
        this.launcher.addOption(this.strChromeOptions);
        try {
            this.launcher.launch(String.valueOf(this.strOutputPath) + filename, ChromeLauncher.TYPE.URL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isChromeAvailable() {
        String chrome = WebCommonActivator.getChromeExceutePath();
        if (StringUtil.isEmpty((CharSequence)chrome)) {
            return false;
        }
        System.out.println("isChromeAvailable(): " + chrome);
        return true;
    }

    public String isPythonAvailable() {
        int iter = 0;
        Process p = null;
        BufferedInputStream in = null;
        BufferedInputStream err = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            p = Runtime.getRuntime().exec("python -V");
            in = new BufferedInputStream(p.getInputStream());
            while ((iter = in.read()) != -1) {
                out.write(iter);
            }
            err = new BufferedInputStream(p.getErrorStream());
            while ((iter = err.read()) != -1) {
                out.write(iter);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String tempList = new String(out.toByteArray());
        System.out.println("isPythonAvailable(): " + tempList);
        if (tempList.contains("Python 2.7.")) {
            return "TRUE";
        }
        if (tempList.startsWith("Python ")) {
            return tempList;
        }
        return "FALSE";
    }
}

