/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import ttrace.handlers.Environment;
import ttrace.handlers.OSValidator;
import ttrace.handlers.TTraceWaitingState;

public class ProgressBarUpdateAnotherThread {
    public static void startProgress(final Environment env, String textTimeWindow) throws IOException {
        final Display display = Display.getCurrent();
        final Shell shell = new Shell(display);
        final ProgressBar bar = new ProgressBar((Composite)shell, 65536);
        shell.setText("Running");
        shell.setBounds(100, 100, 280, 100);
        bar.setBounds(10, 10, 230, 32);
        shell.open();
        int maximum = bar.getMaximum();
        final int secs = Integer.parseInt(textTimeWindow);
        int remain = maximum % secs;
        bar.setSelection(remain);
        new Thread(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(env.getStartCmd());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                int i = 0;
                while (i < secs) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (i == secs % 100 - 1) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TTraceWaitingState.setMainButtonProgress("Waiting.");
                                if (!bar.isDisposed()) {
                                    bar.setSelection(100);
                                }
                                if (bar.getSelection() >= 100) {
                                    shell.dispose();
                                }
                            }
                        });
                    } else {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                TTraceWaitingState.setMainButtonProgress("Waiting.");
                                if (!bar.isDisposed()) {
                                    bar.setSelection(bar.getSelection() + 1);
                                }
                                if (bar.getSelection() >= 100) {
                                    shell.dispose();
                                }
                            }
                        });
                    }
                    ++i;
                }
            }
        }.start();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
            if (!bar.isDisposed()) continue;
            return;
        }
        display.dispose();
    }

    public static void stopProgress(Environment env) throws IOException {
        int iter = 0;
        Process p = null;
        BufferedInputStream in = null;
        FileOutputStream fos = new FileOutputStream(String.valueOf(env.getTracePath()) + env.getAsyncTrace());
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            try {
                p = Runtime.getRuntime().exec(env.getStopCmd());
                in = new BufferedInputStream(p.getInputStream());
                while ((iter = in.read()) != -1) {
                    bos.write(iter);
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                bos.close();
            }
        }
        finally {
            bos.close();
        }
    }

    public static void stopProgressByText(Environment env) throws IOException {
        boolean flag = false;
        FileWriter fos = new FileWriter(String.valueOf(env.getTracePath()) + env.getAsyncTrace());
        BufferedWriter bos = new BufferedWriter(fos);
        try {
            try {
                System.out.println(env.getStopCmd());
                Process p = Runtime.getRuntime().exec(env.getStopCmd());
                String strLine = new String();
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((strLine = in.readLine()) != null) {
                    System.out.println("strLine: " + strLine);
                    if (strLine.contains("TRACE:") && !flag) {
                        flag = true;
                        bos.write(String.valueOf(strLine) + '\n');
                        bos.flush();
                        continue;
                    }
                    if (!flag) continue;
                    bos.write(String.valueOf(strLine) + '\n');
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                bos.close();
            }
        }
        finally {
            bos.close();
        }
    }

    public static void composeHtml(Environment env) throws IOException {
        block7: {
            String strPullCmd = env.getPullCmd();
            try {
                if (OSValidator.isWindows()) {
                    System.out.println("strPullCmd: " + strPullCmd);
                    Runtime.getRuntime().exec(strPullCmd);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println("strComposeCmd: " + env.getComposeCmd().replace('\\', '/'));
                    Runtime.getRuntime().exec("python " + env.getComposeCmd().replace('\\', '/'));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                Runtime.getRuntime().exec(env.getComposeCmd());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

