/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import ttrace.handlers.Environment;
import ttrace.handlers.OSValidator;

class ThreadAsyncTracing
implements Runnable {
    private static int i = 0;
    private String asyncFilename;

    ThreadAsyncTracing() {
        i = 0;
        this.asyncFilename = new String("async.trace");
    }

    public void clearCounter() {
        i = 0;
    }

    public static void composeHtml(Environment env) throws IOException {
        block7: {
            String strPullCmd = env.getPullCmd();
            try {
                if (OSValidator.isWindows()) {
                    System.out.println("strPullCmd: " + strPullCmd);
                    Runtime.getRuntime().exec(strPullCmd);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println("strComposeCmd: " + env.getComposeCmd().replace('\\', '/'));
                    Runtime.getRuntime().exec("python " + env.getComposeCmd().replace('\\', '/'));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break block7;
                }
                Runtime.getRuntime().exec(env.getComposeCmd());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void mergeTrace() throws IOException {
        int bytes = 0;
        Environment env = Environment.getInstance();
        String strSrcFile = OSValidator.isWindows() ? new String(String.valueOf(env.getTracePath()) + "\\" + this.asyncFilename) : new String(String.valueOf(env.getTracePath()) + "/" + this.asyncFilename);
        FileOutputStream fos = new FileOutputStream(strSrcFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        int iter = 0;
        while (iter < i) {
            fis = new FileInputStream(String.valueOf(strSrcFile) + iter);
            bis = new BufferedInputStream(fis);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while ((bytes = bis.read()) != -1) {
                bos.write(bytes);
                bos.flush();
            }
            ++iter;
        }
        bis.close();
        fis.close();
        bos.close();
        fos.close();
    }

    public void mergeTraceByText() throws IOException {
        Environment env = Environment.getInstance();
        String strSrcFile = OSValidator.isWindows() ? new String(String.valueOf(env.getTracePath()) + "\\" + this.asyncFilename) : new String(String.valueOf(env.getTracePath()) + "/" + this.asyncFilename);
        File baseFile = new File(strSrcFile);
        FileWriter fileWriter = new FileWriter(baseFile);
        BufferedWriter writer = new BufferedWriter(fileWriter);
        int iter = 0;
        while (iter < i) {
            File srcFile = new File(String.valueOf(strSrcFile) + iter);
            FileReader fileReader = new FileReader(srcFile);
            BufferedReader reader = new BufferedReader(fileReader);
            while (!reader.ready()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            String strLine = null;
            while ((strLine = reader.readLine()) != null) {
                writer.append(String.valueOf(strLine) + '\n');
            }
            reader.close();
            fileReader.close();
            ++iter;
        }
        writer.close();
    }

    public void asyncStart() {
        Environment env = Environment.getInstance();
        String strCmd = new String(env.getStartCmd());
        System.out.println("asyncStart::ThreadAsyncTracing: " + strCmd);
        try {
            Runtime.getRuntime().exec(strCmd);
        }
        catch (IOException e) {
            System.out.println("asyncStart:::::EXCEPTION!!!!");
            e.printStackTrace();
        }
    }

    public void asyncCommand(String strCmd) throws IOException {
        int iter = 0;
        Environment env = Environment.getInstance();
        Process p = null;
        BufferedInputStream in = null;
        FileOutputStream fos = new FileOutputStream(String.valueOf(env.getTracePath()) + env.getAsyncTrace());
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            p = Runtime.getRuntime().exec(strCmd);
            in = new BufferedInputStream(p.getInputStream());
            while ((iter = in.read()) != -1) {
                bos.write(iter);
                bos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bos.close();
        fos.close();
        in.close();
    }

    public void asyncCommandMulti(String strCmd) throws IOException {
        int iter = 0;
        Environment env = Environment.getInstance();
        Process p = null;
        BufferedInputStream in = null;
        FileOutputStream fos = new FileOutputStream(String.valueOf(env.getTracePath()) + env.getAsyncTrace() + i++);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            p = Runtime.getRuntime().exec(strCmd);
            in = new BufferedInputStream(p.getInputStream());
            while ((iter = in.read()) != -1) {
                bos.write(iter);
                bos.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        bos.close();
        fos.close();
        in.close();
    }

    public void asyncCommandByText(String strCmd) throws IOException {
        boolean flag = false;
        Environment env = Environment.getInstance();
        FileWriter fos = new FileWriter(String.valueOf(env.getTracePath()) + env.getAsyncTrace() + i++);
        BufferedWriter bos = new BufferedWriter(fos);
        try {
            try {
                Process p = Runtime.getRuntime().exec(strCmd);
                String strLine = new String();
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((strLine = in.readLine()) != null) {
                    if (strLine.contains("TRACE:") && !flag) {
                        flag = true;
                        bos.write(String.valueOf(strLine) + '\n');
                        bos.flush();
                        continue;
                    }
                    if (!flag) continue;
                    bos.write(String.valueOf(strLine) + '\n');
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                bos.close();
            }
        }
        finally {
            bos.close();
        }
    }

    @Override
    public void run() {
        this.asyncStart();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.out.println("Catch interrupt!!!");
                break;
            }
        }
        System.out.println("AsyncThread:::Thread is died");
        try {
            this.asyncCommand(Environment.getInstance().getStopCmd());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

