/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import ttrace.handlers.SDBconnection;
import ttrace.handlers.StringHandler;

public class CheckboxManager {
    private static String[] namesFtrace = new String[]{"Sched", "Freq", "Idle", "Load", "Sync", "Disk", "MMC", "Workq"};
    private static String[] namesTtrace = new String[]{"Graphics", "Input", "View", "Web", "Window Manager", "Application Manager", "Image", "Audio", "Video", "Camera", "App"};
    private static Button[] cbFtrace = new Button[namesFtrace.length];
    private static Button[] cbTtrace = new Button[namesTtrace.length];
    private static Group groupFtrace;
    private static Group groupTtrace;

    public static void disableAllCheckboxes() {
        System.out.println("CheckboxManager::disableAllCheckboxes");
        int i = 0;
        while (i < cbFtrace.length) {
            cbFtrace[i].setTouchEnabled(false);
            cbFtrace[i].setEnabled(false);
            cbFtrace[i].setGrayed(true);
            ++i;
        }
        i = 0;
        while (i < cbTtrace.length) {
            cbTtrace[i].setTouchEnabled(false);
            cbTtrace[i].setEnabled(false);
            cbTtrace[i].setGrayed(true);
            ++i;
        }
    }

    public static void enableAllCheckboxes() {
        int i = 0;
        while (i < cbFtrace.length) {
            cbFtrace[i].setTouchEnabled(true);
            cbFtrace[i].setEnabled(true);
            cbFtrace[i].setGrayed(false);
            ++i;
        }
        i = 0;
        while (i < cbTtrace.length) {
            cbTtrace[i].setTouchEnabled(true);
            cbTtrace[i].setEnabled(true);
            cbTtrace[i].setGrayed(false);
            ++i;
        }
    }

    public static void disableCheckboxesAsList() {
        ArrayList<String> mList = SDBconnection.getListCategories();
        int i = 0;
        while (i < cbFtrace.length) {
            if (!mList.contains(cbFtrace[i].getText().toLowerCase())) {
                cbFtrace[i].setSelection(false);
                cbFtrace[i].setTouchEnabled(false);
                cbFtrace[i].setEnabled(false);
                cbFtrace[i].setGrayed(true);
            }
            ++i;
        }
        i = 0;
        while (i < cbTtrace.length) {
            String tagName = cbTtrace[i].getText().toLowerCase();
            if (tagName.equals("graphics")) {
                tagName = "gfx";
            } else if (tagName.equals("window manager")) {
                tagName = "wm";
            } else if (tagName.equals("application manager")) {
                tagName = "am";
            }
            if (!mList.contains(tagName)) {
                cbTtrace[i].setSelection(false);
                cbTtrace[i].setTouchEnabled(false);
                cbTtrace[i].setEnabled(false);
                cbTtrace[i].setGrayed(true);
            }
            ++i;
        }
    }

    public static void initCheckboxesFtrace(Group group) {
        CheckboxManager.initCheckboxes(group, cbFtrace, namesFtrace);
        groupFtrace = group;
        int i = 0;
        while (i < cbFtrace.length) {
            if (cbFtrace[i].getText().contains("Idle")) {
                cbFtrace[i].setEnabled(true);
            } else if (cbFtrace[i].getText().contains("Load")) {
                cbFtrace[i].setEnabled(true);
            } else if (cbFtrace[i].getText().contains("Sync")) {
                cbFtrace[i].setEnabled(true);
            } else if (cbFtrace[i].getText().contains("Membus")) {
                cbFtrace[i].setEnabled(false);
            } else if (cbFtrace[i].getText().contains("Disk")) {
                cbFtrace[i].setEnabled(true);
            } else if (cbFtrace[i].getText().contains("MMC")) {
                cbFtrace[i].setEnabled(true);
            } else if (cbFtrace[i].getText().contains("Workq")) {
                cbFtrace[i].setEnabled(true);
            }
            ++i;
        }
    }

    public static void initCheckboxesTtrace(Group group) {
        CheckboxManager.initCheckboxes(group, cbTtrace, namesTtrace);
        groupTtrace = group;
    }

    public static void initCheckboxes(Group group, Button[] btnArr, String[] strArr) {
        Preferences prefs = Preferences.userRoot().node("ttrace");
        int i = 0;
        while (i < strArr.length) {
            if (btnArr[i] == null || btnArr[i].isDisposed()) {
                btnArr[i] = new Button((Composite)group, 32);
            }
            btnArr[i].setText(strArr[i]);
            btnArr[i].setEnabled(true);
            btnArr[i].setSelection(prefs.getBoolean(strArr[i], false));
            StringHandler.strHandler(btnArr[i]);
            ++i;
        }
    }

    public static String getTags() {
        String strRet = null;
        strRet = CheckboxManager.getFtraceTags();
        strRet = String.valueOf(strRet) + CheckboxManager.getTtraceTags();
        if ((strRet = strRet.toLowerCase()).contains("graphics")) {
            strRet = strRet.replace("graphics", "gfx");
        }
        if (strRet.contains("window manager")) {
            strRet = strRet.replace("window manager", "wm");
        }
        if (strRet.contains("application manager")) {
            strRet = strRet.replace("application manager", "am");
        }
        if (strRet.contains("multimedia content")) {
            strRet = strRet.replace("multimedia content", "mc");
        }
        if (strRet.contains("multimedia database")) {
            strRet = strRet.replace("multimedia database", "mdb");
        }
        if (strRet.contains("screen mirroring")) {
            strRet = strRet.replace("screen mirroring", "scmirroring");
        }
        return strRet;
    }

    public static String getFtraceTags() {
        String strRet = CheckboxManager.getTextEnabledTags(cbFtrace);
        return strRet;
    }

    public static String getTtraceTags() {
        String strRet = CheckboxManager.getTextEnabledTags(cbTtrace);
        if (strRet.isEmpty()) {
            strRet = new String(" None");
        }
        return strRet;
    }

    public static String getTextEnabledTags(Button[] btnArr) {
        String strRet = new String();
        int i = 0;
        while (i < btnArr.length) {
            if (btnArr[i].getSelection()) {
                strRet = String.valueOf(strRet) + " " + btnArr[i].getText();
            }
            ++i;
        }
        return strRet;
    }

    public static boolean getOptionRealtime() {
        Preferences prefs = Preferences.userRoot().node("ttrace");
        return prefs.getBoolean("Realtime", false);
    }

    public static boolean getOptionBootup() {
        return false;
    }

    public static boolean getReset() {
        Preferences prefs = Preferences.userRoot().node("ttrace");
        return prefs.getBoolean("Reset", false);
    }

    public static void clearAllCheckboxes() {
        CheckboxManager.clearCheckboxesFtrace();
        CheckboxManager.clearCheckboxesTtrace();
    }

    public static void clearCheckboxesFtrace() {
        CheckboxManager.clearCheckboxes(groupFtrace, cbFtrace, namesFtrace);
    }

    public static void clearCheckboxesTtrace() {
        CheckboxManager.clearCheckboxes(groupTtrace, cbTtrace, namesTtrace);
    }

    public static void clearCheckboxes(Group group, Button[] btnArr, String[] strArr) {
        Preferences prefs = Preferences.userRoot().node("ttrace");
        int i = 0;
        while (i < strArr.length) {
            if (btnArr[i].getEnabled()) {
                btnArr[i].setSelection(false);
                prefs.putBoolean(strArr[i], false);
            }
            ++i;
        }
    }
}

