/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.PropertyParser;
import org.tizen.manager.core.model.Distribution;
import org.tizen.manager.core.model.PropertySection;
import org.tizen.manager.core.model.Snapshot;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;

public class RepositoryUtil {
    private static final Logger logger = Log.getLogger(RepositoryUtil.class);

    public static ArrayList<Distribution> readDistributionListFromRepository(String repoBaseURL) throws UMException {
        ArrayList<Distribution> result = new ArrayList<Distribution>();
        File tmp = null;
        try {
            tmp = File.createTempFile("dist", ".info");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_TEMP_FILE, (Throwable)e);
        }
        URL distInfoFileURL = RepositoryUtil.getDistributionInfoFileURL(repoBaseURL);
        if (distInfoFileURL == null) {
            throw new UMException(ErrorController.ErrorCode.INVALID_REPO_URL_FORMAT, repoBaseURL);
        }
        try {
            Downloader downloader = new Downloader(distInfoFileURL);
            long size = downloader.download(tmp.getAbsolutePath(), new DownloadProgressMonitor());
            if (size < 0L) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
            }
        }
        catch (UMException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_REPO_CONFIG_FILE, distInfoFileURL.toString(), e);
        }
        PropertyParser parser = new PropertyParser();
        List<PropertySection> sections = parser.readFromFile(tmp);
        if (sections == null || sections.isEmpty()) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_REPO_CONFIG_FILE, distInfoFileURL.toString());
        }
        for (PropertySection section : sections) {
            result.add(new Distribution(repoBaseURL, section.getProperties()));
        }
        return result;
    }

    private static URL getDistributionInfoFileURL(String repoBaseURL) {
        String distInfoFilePath = NetworkUtil.getURL(repoBaseURL, "distribution.info");
        try {
            return new URL(distInfoFilePath);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot connect distribution file in repository(" + distInfoFilePath + ")");
            return null;
        }
    }

    static ArrayList<Snapshot> readSnapshotListFromRepository(String repoURL) throws UMException {
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        File tmp = null;
        try {
            tmp = File.createTempFile("snapshot", ".info");
            tmp.deleteOnExit();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_CREATE_TEMP_FILE, (Throwable)e);
        }
        URL snapshotListURL = RepositoryUtil.getSnapshotListFileURL(repoURL);
        if (snapshotListURL == null) {
            throw new UMException(ErrorController.ErrorCode.INVALID_REPO_URL_FORMAT, repoURL);
        }
        try {
            Downloader downloader = new Downloader(snapshotListURL);
            long size = downloader.download(tmp.getAbsolutePath(), new DownloadProgressMonitor());
            if (size < 0L) {
                throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_FILE);
            }
        }
        catch (UMException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_DOWNLOAD_REPO_CONFIG_FILE, snapshotListURL.toString(), e);
        }
        PropertyParser parser = new PropertyParser();
        List<PropertySection> sections = parser.readFromFile(tmp);
        if (sections == null) {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_REPO_CONFIG_FILE, snapshotListURL.toString());
        }
        for (PropertySection section : sections) {
            Snapshot s = new Snapshot(section.getProperties());
            result.add(s);
        }
        return result;
    }

    private static URL getSnapshotListFileURL(String repoURL) {
        assert (repoURL != null && !repoURL.isEmpty());
        String snapshotListPath = NetworkUtil.getURL(repoURL, "snapshot.info");
        try {
            return new URL(snapshotListPath);
        }
        catch (MalformedURLException e) {
            logger.throwing(e);
            return null;
        }
    }

    public static Snapshot readLatestSnapshot(String repoURL) throws UMException {
        Snapshot latestSnapshot = null;
        ArrayList<Snapshot> snapshotList = RepositoryUtil.readSnapshotListFromRepository(repoURL);
        if (!snapshotList.isEmpty()) {
            Collections.sort(snapshotList);
            for (Snapshot snapshot : snapshotList) {
                String type = snapshot.getType();
                if (type == null || type.toLowerCase().contains("temp")) continue;
                latestSnapshot = snapshot;
                break;
            }
            if (latestSnapshot == null) {
                latestSnapshot = snapshotList.get(0);
            }
        } else {
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_LOAD_REPO_CONFIG_FILE, "No snapshot!");
        }
        return latestSnapshot;
    }
}

