/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.download;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.tizen.manager.core.Install.InstallPackageManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.download.DownloadManagerMonitor;
import org.tizen.manager.core.download.DownloadObject;
import org.tizen.manager.core.download.IDownloadPackageProgressMonitor;
import org.tizen.manager.core.download.ManagerableDownloaderCallable;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageSet;

public class DownloadManager {
    private static DownloadManager instance;
    private HashMap<String, DownloadObject> downloadObjectMap = new HashMap();
    private ExecutorService downloaderManagerThreadExecutor = Executors.newFixedThreadPool(3);
    public static ExecutorService downloaderThreadExecutor;

    private DownloadManager() {
    }

    public static synchronized DownloadManager getInstance() {
        if (instance == null) {
            instance = new DownloadManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDownloadPackage(Package pkg, PackageSet targetPkgs, String targetDir, IDownloadPackageProgressMonitor monitor, Config mConfig) {
        HashMap<String, DownloadObject> hashMap = this.downloadObjectMap;
        synchronized (hashMap) {
            monitor.setProgress("Waiting for starting to download...");
            String packageName = pkg.getPackageName().trim();
            if (this.downloadObjectMap.containsKey(packageName)) {
                DownloadObject downloadObject;
                monitor.setProgress("There already exists same downloading-progress.");
                DownloadObject downloadObject2 = downloadObject = this.downloadObjectMap.get(packageName);
                synchronized (downloadObject2) {
                    List<IDownloadPackageProgressMonitor> monitorList2;
                    List<IDownloadPackageProgressMonitor> monitorList = downloadObject.getMonitorList();
                    if (monitorList != null && !monitorList.isEmpty()) {
                        ArrayList<IDownloadPackageProgressMonitor> removeList = new ArrayList<IDownloadPackageProgressMonitor>();
                        for (IDownloadPackageProgressMonitor iDownloadPackageProgressMonitor : monitorList) {
                            if (!iDownloadPackageProgressMonitor.isCanceled()) continue;
                            removeList.add(iDownloadPackageProgressMonitor);
                        }
                        for (IDownloadPackageProgressMonitor iDownloadPackageProgressMonitor : removeList) {
                            downloadObject.removeMonitor(iDownloadPackageProgressMonitor);
                        }
                    }
                    if ((monitorList2 = downloadObject.getMonitorList()).isEmpty()) {
                        monitor.setProgress("But, the downloading progress is empty.");
                        if (InstallPackageManager.getInstance().existsPackageInInstallList(pkg)) {
                            monitor.setProgress("There already exists the install-progress of same package..");
                            monitor.setProgress("Skip downloading...");
                            monitor.done();
                        } else {
                            monitor.setProgress("Creating new downloading progress.");
                            this.downloadObjectMap.remove(packageName);
                            DownloadObject doObject = new DownloadObject(packageName);
                            doObject.addMonitor(monitor);
                            doObject.setRelatedPackages(targetPkgs);
                            this.downloadObjectMap.put(packageName, doObject);
                            DownloadManagerMonitor downloadMonitor = new DownloadManagerMonitor(doObject);
                            this.downloaderManagerThreadExecutor.submit(new ManagerableDownloaderCallable(pkg, targetDir, downloadMonitor));
                        }
                    } else if (downloadObject.isCompleted()) {
                        monitor.setProgress("But, the downloading progress is already done.");
                        monitor.done();
                    } else {
                        monitor.setProgress("Monitoring existing downloading progress...");
                        downloadObject.addMonitor(monitor);
                    }
                }
            } else if (InstallPackageManager.getInstance().existsPackageInInstallList(pkg)) {
                monitor.setProgress("There already exists the install-progress of same package..");
                monitor.setProgress("Skip downloading...");
                monitor.done();
            } else {
                monitor.setProgress("Creating new downloading progress.");
                DownloadObject doObject = new DownloadObject(packageName);
                doObject.addMonitor(monitor);
                doObject.setRelatedPackages(targetPkgs);
                this.downloadObjectMap.put(packageName, doObject);
                DownloadManagerMonitor downloadMonitor = new DownloadManagerMonitor(doObject);
                this.downloaderManagerThreadExecutor.submit(new ManagerableDownloaderCallable(pkg, targetDir, downloadMonitor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageIsInstalled(Package pkg) {
        HashMap<String, DownloadObject> hashMap = this.downloadObjectMap;
        synchronized (hashMap) {
            this.downloadObjectMap.remove(pkg.getPackageName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        HashMap<String, DownloadObject> hashMap = this.downloadObjectMap;
        synchronized (hashMap) {
            return this.downloadObjectMap.isEmpty();
        }
    }

    public void shutdown() {
        while (!this.downloaderManagerThreadExecutor.isTerminated() || !this.downloaderManagerThreadExecutor.isShutdown()) {
            this.downloaderManagerThreadExecutor.shutdownNow();
            this.downloaderManagerThreadExecutor.shutdown();
        }
        while (!downloaderThreadExecutor.isTerminated() || !downloaderThreadExecutor.isShutdown()) {
            downloaderThreadExecutor.shutdownNow();
            downloaderThreadExecutor.shutdown();
        }
    }

    static {
        downloaderThreadExecutor = Executors.newFixedThreadPool(6);
    }
}

