/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.win;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ProgramController;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.manager.win.ProcessInformation;
import org.tizen.manager.win.WindowsShellRunningProgramParser;

public class WindowsProgramController
extends ProgramController {
    private static final String VBSCRIPT_OF_CHECKING_RUNNING_PROGRAM = "/res/desktop_directory/checkRunningTaskList.vbs";
    private static final String VBSCRIPT_NAME_OF_CHECKING_RUNNING_PROGRAM = "checkRunningTaskList";
    private static final String VBSCRIPT_EXTENTION_OF_CHECKING_RUNNING_PROGRAM = ".vbs";
    private static final Logger logger = Log.getLogger(WindowsProgramController.class);

    @Override
    public List<String> getSDKProcessList() {
        File script;
        ArrayList<String> result = new ArrayList<String>();
        try {
            script = PathUtil.getTempFileFromResource(VBSCRIPT_OF_CHECKING_RUNNING_PROGRAM, VBSCRIPT_NAME_OF_CHECKING_RUNNING_PROGRAM, VBSCRIPT_EXTENTION_OF_CHECKING_RUNNING_PROGRAM);
        }
        catch (IOException e) {
            logger.error("Failed to crate temp file from resource");
            logger.error(e);
            return null;
        }
        if (script == null) {
            return result;
        }
        String command = "cscript " + script.getAbsolutePath();
        WindowsShellRunningProgramParser parser = new WindowsShellRunningProgramParser();
        try {
            ShellUtil.execute(command, null, new File(SDKInfo.getInstalledPath()), (ShellParser)parser, null);
        }
        catch (IMShellCommandFail e) {
            logger.error("Failed to get SDK pid's");
            logger.throwing(e);
            return result;
        }
        List<ProcessInformation> pInfoList = parser.getProcessInformation();
        for (ProcessInformation pInfo : pInfoList) {
            if (this.isIDE(pInfo)) {
                result.add(ProgramController.PROG_NAME_IDE);
                continue;
            }
            if (this.isEmulatorManager(pInfo)) {
                result.add(ProgramController.PROG_NAME_EMUL_MGR);
                continue;
            }
            if (this.isEmulator(pInfo)) {
                result.add(ProgramController.PROG_NAME_EMUL);
                continue;
            }
            if (this.isDynamicAnalyzer(pInfo)) {
                result.add(ProgramController.PROG_NAME_DA);
                continue;
            }
            if (this.isWebSimulator(pInfo)) {
                result.add(ProgramController.PROG_NAME_WEB_SIM);
                continue;
            }
            if (this.isManager(pInfo)) {
                result.add(ProgramController.PROG_NAME_MANAGER);
                continue;
            }
            if (!this.isUninstaller(pInfo)) continue;
            result.add(ProgramController.PROG_NAME_UNINSTALLER);
        }
        return result;
    }

    @Override
    public List<String> getPkgMgrProcessList() {
        File script;
        ArrayList<String> result = new ArrayList<String>();
        try {
            script = PathUtil.getTempFileFromResource(VBSCRIPT_OF_CHECKING_RUNNING_PROGRAM, VBSCRIPT_NAME_OF_CHECKING_RUNNING_PROGRAM, VBSCRIPT_EXTENTION_OF_CHECKING_RUNNING_PROGRAM);
        }
        catch (IOException e) {
            logger.error("Failed to crate temp file from resource");
            logger.error(e);
            return null;
        }
        if (script == null) {
            return result;
        }
        String command = "cscript " + script.getAbsolutePath();
        WindowsShellRunningProgramParser parser = new WindowsShellRunningProgramParser();
        try {
            ShellUtil.execute(command, null, new File(SDKInfo.getInstalledPath()), (ShellParser)parser, null);
        }
        catch (IMShellCommandFail e) {
            logger.error("Failed to get SDK pid's");
            logger.throwing(e);
            return result;
        }
        List<ProcessInformation> pInfoList = parser.getProcessInformation();
        for (ProcessInformation pInfo : pInfoList) {
            if (this.isManager(pInfo)) {
                result.add(ProgramController.PROG_NAME_MANAGER);
                continue;
            }
            if (this.isManagerCli(pInfo)) {
                result.add(ProgramController.PROG_NAME_MANAGER_CLI);
                continue;
            }
            if (!this.isUninstaller(pInfo)) continue;
            result.add(ProgramController.PROG_NAME_UNINSTALLER);
        }
        return result;
    }

    private boolean isEmulatorManager(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("emulator-manager.exe")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isWebSimulator(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("websimulator") || !pInfo.getCommand().contains("html")) {
            return false;
        }
        return pInfo.getCommand().contains(SDKInfo.getInstalledPath());
    }

    private boolean isEmulator(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("emulator-x86")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isIDE(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("eclipse.exe")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isDynamicAnalyzer(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("dynamic-analyzer")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isManager(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java.exe") && command.contains(ProgramController.JAR_NAME_MANAGER) && command.contains("-path ") && command.contains(SDKInfo.getInstalledPath());
    }

    private boolean isManagerCli(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java.exe") && command.contains(ProgramController.JAR_NAME_MANAGER_CLI) && command.contains("-path ") && command.contains(SDKInfo.getInstalledPath());
    }

    private boolean isUninstaller(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java.exe") && command.contains(ProgramController.JAR_NAME_UNINSTALLER) && command.contains("-path ") && command.contains(SDKInfo.getInstalledPath());
    }

    private boolean isProcessRunningInInstalledPath(ProcessInformation pInfo) {
        String excutablePath = pInfo.getExecutablePath();
        return excutablePath != null && excutablePath.startsWith(SDKInfo.getInstalledPath());
    }
}

