/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.id;

class Relation {
    Accessible accessible;
    Accessible[] targets;
    int type;

    Relation(Accessible accessible, int n) {
        this.accessible = accessible;
        this.type = n;
        this.targets = new Accessible[0];
    }

    void addTarget(Accessible accessible) {
        if (this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, accessibleArray, 0, this.targets.length);
        accessibleArray[this.targets.length] = accessible;
        this.targets = accessibleArray;
    }

    boolean containsTarget(Accessible accessible) {
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != accessible) continue;
            return true;
        }
        return false;
    }

    void removeTarget(Accessible accessible) {
        if (!this.containsTarget(accessible)) {
            return;
        }
        Accessible[] accessibleArray = new Accessible[this.targets.length - 1];
        int n = 0;
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] == accessible) continue;
            accessibleArray[n++] = this.targets[i];
        }
        this.targets = accessibleArray;
    }

    id getTitleUIElement() {
        id id2 = null;
        for (int i = 0; i < this.targets.length; ++i) {
            Accessible accessible = this.targets[i];
            id2 = accessible.accessibleHandle(accessible);
        }
        return id2;
    }

    id getServesAsTitleForUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            Accessible accessible = this.targets[i];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
        }
        return nSMutableArray;
    }

    id getLinkedUIElements() {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            Accessible accessible = this.targets[i];
            id id2 = accessible.accessibleHandle(accessible);
            nSMutableArray.addObject(id2);
        }
        return nSMutableArray;
    }
}

