/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.tizen.manager.core.InstallController;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.pkg.PackageUtil;
import org.tizen.manager.svc.sdkutils.PackageInfoJSON;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;
import org.tizen.packagemanager.exception.ui.InsideTroubleShootingDialog;
import org.tizen.packagemanager.ui.util.CircularGroupAnimationGraph;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.wizard.WizardCommonPage;
import org.tizen.uninstaller.ui.wizard.WizardPageMaster;
import org.tizen.uninstaller.ui.wizard.WizardUninstallerWindow;

public class WizardUninstallingPage
extends WizardCommonPage {
    private static final Logger logger = Log.getLogger(WizardUninstallingPage.class);
    private static final int PROGRESS_REFRESH_TIME = Config.timer;
    private static final int INFO_REFRESH_TIME = 500;
    private static final int PROGRESS_MAX_VALUE = 360;
    private static final int PROGRESS_INCREASE_COUNT = 1;
    private String uninstallingStep = "Preparing for the uninstallation...";
    private String uninstallingFile = "This process can take some time. Preparing to delete";
    InstallProgressMonitor ipm = new InstallProgressMonitor();
    private int insidePercent = 0;
    private boolean isStarted = false;
    private int dotCount = 0;
    private int exitCode = 0;
    private CircularGroupAnimationGraph imc;
    private boolean isFirstRun = true;
    private boolean isDone = false;
    private Display display;

    public WizardUninstallingPage(Composite parentComposite, WizardUIResourceHandler uiResource, int swtOption, WizardPageMaster wizardPM) throws UMException {
        super(parentComposite, swtOption, uiResource, wizardPM);
        this.display = parentComposite.getDisplay();
        this.createCenterContainer();
        this.handleInstallingEvent();
        this.handleBottomEvent();
    }

    private void createCenterContainer() {
        Composite leftContainer = new Composite(this.centerContainer, 0x20000000);
        Rectangle bounds = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INSTALL_IC_SDK);
        Rectangle strokeSize = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_INSTALL_IC_STROKE);
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.centerContainer, bounds.x, 0x1000000);
        formData.top = new FormAttachment(this.centerContainer, bounds.y, 0x1000000);
        formData.width = bounds.width;
        formData.height = bounds.height;
        leftContainer.setLayoutData(formData);
        leftContainer.setLayout(new FillLayout(256));
        this.imc = this.uiResource.handleGroupUninstallingForWizardProgress(leftContainer, 0L, bounds.width, bounds.height, bounds.width - (strokeSize.width + strokeSize.height), 21);
        this.createInfoComposites(this.centerContainer);
    }

    private void createInfoComposites(final Composite rightContainer) {
        this.centerContainer.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                Image bufferedImage = new Image((Device)rightContainer.getDisplay(), rightContainer.getBounds());
                GC gc = new GC(bufferedImage);
                gc.setAntialias(1);
                Rectangle installingBounds = WizardUninstallingPage.this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_UNINSTALLING_LOCATION);
                Rectangle centerBounds = WizardUninstallingPage.this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_CENTER);
                gc.setForeground(WizardUninstallingPage.this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
                gc.setFont(WizardUninstallingPage.this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
                String currentSize = "";
                String totalSize = "";
                if (WizardUninstallingPage.this.uninstallingStep.contains("/")) {
                    String[] split = WizardUninstallingPage.this.uninstallingStep.split("/");
                    currentSize = split[0].trim();
                    totalSize = " / " + split[1].trim();
                } else {
                    currentSize = WizardUninstallingPage.this.uninstallingStep;
                }
                int positionX = installingBounds.x;
                Point textExtent = gc.textExtent(currentSize);
                int positionY = centerBounds.height / 2 - textExtent.y;
                gc.drawText(currentSize, positionX, positionY - textExtent.y / 4, 1);
                if (totalSize.length() > 0) {
                    gc.setForeground(WizardUninstallingPage.this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
                    gc.setFont(WizardUninstallingPage.this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
                    gc.drawText(totalSize, positionX + textExtent.x, positionY - textExtent.y / 4, 1);
                }
                gc.setForeground(WizardUninstallingPage.this.uiResource.getColor(WizardUIResourceHandler.UIColor.WIZARD_COLOR_VERY_DARK_GRAY_33));
                gc.setFont(WizardUninstallingPage.this.uiResource.getFontBySize(WizardUIResourceHandler.UIFontSize.FONT_SIZE_13PX, false, 0));
                gc.drawText(WizardUninstallingPage.this.uninstallingFile, positionX, positionY + textExtent.y + textExtent.y / 4, 1);
                event.gc.drawImage(bufferedImage, 0, 0);
            }
        });
    }

    private void handleInstallingEvent() {
        this.centerContainer.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent arg0) {
                logger.trace(arg0);
                WizardUninstallingPage.this.handleInit();
            }
        });
    }

    private void handleInit() {
        if (this.isFirstRun) {
            this.isFirstRun = false;
            this.infoLabel.setText("This process can take some time. Preparing to delete");
            Thread animateThread = new Thread(){

                @Override
                public void run() {
                    while (!WizardUninstallingPage.this.isDone) {
                        try {
                            Thread.sleep(PROGRESS_REFRESH_TIME);
                            WizardUninstallingPage.this.ipm.updateProgress();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            animateThread.start();
            Thread infoMessageThread = new Thread(){

                @Override
                public void run() {
                    while (!WizardUninstallingPage.this.isDone) {
                        try {
                            Thread.sleep(500L);
                            if (!WizardUninstallingPage.this.isStarted) continue;
                            String infoText = "This process can take some time. Preparing to delete";
                            WizardUninstallingPage.this.dotCount++;
                            if (WizardUninstallingPage.this.dotCount > 3) {
                                WizardUninstallingPage.this.dotCount = 0;
                            }
                            for (int i = 0; i < WizardUninstallingPage.this.dotCount; ++i) {
                                infoText = infoText + ".";
                            }
                            WizardUninstallingPage.this.uninstallingStep = infoText;
                            WizardUninstallingPage.this.ipm.refreshUI();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            infoMessageThread.start();
            Thread removeWorker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File[] listFiles;
                        PackageManager pm = PackageManager.getInstance();
                        List<String> installedMetaNames = pm.getInstalledMetaNames();
                        ArrayList<Package> removablePackages = new ArrayList<Package>();
                        PackageSet targetMetaPkgs = new PackageSet();
                        for (String pkgName : installedMetaNames) {
                            Package pkg = pm.getPackageByName(pkgName);
                            targetMetaPkgs.add(pkg);
                        }
                        PackageSet removablePackagesOfMetaPackages = pm.getRemovablePackagesOfMetaPackages(targetMetaPkgs);
                        for (Package removablePkgs : removablePackagesOfMetaPackages) {
                            if (removablePackages.contains(removablePkgs)) continue;
                            removablePackages.add(removablePkgs);
                        }
                        WizardUninstallingPage.this.ipm.setTitleInfo("Preparing for the uninstallation...");
                        logger.trace("set current image: preparing");
                        WizardUninstallingPage.this.isStarted = true;
                        WizardUninstallingPage.this.ipm.refreshUI();
                        for (Package pkg : removablePackages) {
                            WizardUninstallingPage.this.uninstallingFile = String.format("[%s]", pkg.getPackageName());
                            WizardUninstallingPage.this.ipm.refreshUI();
                            InstallController.getInstance().executeRemoveScriptOnly(pkg);
                        }
                        WizardUninstallingPage.this.ipm.setTitleInfo("Uninstallation is in progress...");
                        logger.trace("set current image: uninstalling");
                        WizardUninstallingPage.this.ipm.refreshUI();
                        String targetDir = Config.getInstance().getTargetDir();
                        File tempFile = new File(targetDir);
                        if (targetDir != null && !targetDir.isEmpty() && tempFile.exists() && (listFiles = tempFile.listFiles()) != null) {
                            for (File file : listFiles) {
                                WizardUninstallingPage.this.uninstallingFile = String.format("Removing - [%s]", file.getName());
                                WizardUninstallingPage.this.ipm.refreshUI();
                                if (file.isDirectory()) {
                                    WizardUninstallingPage.this.uninstallingFile = String.format("Removing - [%s]", file.getName());
                                    WizardUninstallingPage.this.ipm.refreshUI();
                                    do {
                                        ShellParser sparser = new ShellParser();
                                        try {
                                            if (PlatformUtil.isWindows()) {
                                                WizardUninstallingPage.this.exitCode = ShellUtil.execute("cmd /c rmdir /s /q " + file.getAbsolutePath(), sparser);
                                            } else {
                                                WizardUninstallingPage.this.exitCode = ShellUtil.execute("rm -rf " + file.getAbsolutePath(), sparser);
                                            }
                                        }
                                        catch (IMShellCommandFail e) {
                                            WizardUninstallingPage.this.exitCode = -1;
                                        }
                                        catch (Exception e) {
                                            WizardUninstallingPage.this.exitCode = -1;
                                        }
                                        if (WizardUninstallingPage.this.exitCode == 0) {
                                            logger.trace("Deleted -> " + file.getAbsolutePath());
                                            WizardUninstallingPage.this.wizardPageMaster.removeError(file.getName());
                                            continue;
                                        }
                                        logger.error("Delete failed -> " + file.getAbsolutePath());
                                        logger.trace(sparser.getOutputMessage());
                                        WizardUninstallingPage.this.wizardPageMaster.addError(file.getName(), sparser.getOutputMessage());
                                        final String errorMsg = sparser.getOutputMessage();
                                        WizardUninstallingPage.this.display.syncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                UMException umException = new UMException(ErrorController.ErrorCode.CANNOT_DELETE_FILE, errorMsg);
                                                int open = InsideTroubleShootingDialog.open(WizardUninstallingPage.this.parent.getShell(), (Exception)umException, true);
                                                if (open == 32) {
                                                    WizardUninstallingPage.this.exitCode = 0;
                                                } else {
                                                    WizardUninstallingPage.this.exitCode = open;
                                                }
                                            }
                                        });
                                    } while (WizardUninstallingPage.this.exitCode != 0);
                                    continue;
                                }
                                PathUtil.remove(file);
                            }
                        }
                        if (PlatformUtil.isWindows()) {
                            ShellUtil.execute("cmd /c rmdir /s /q " + tempFile.getAbsolutePath(), new ShellParser());
                        } else {
                            logger.trace("Begin to remove installed SDK");
                            PathUtil.remove(tempFile.getAbsolutePath());
                        }
                        if (WizardCommonPage.uninstallContext.shouldDeleteSDKData().booleanValue()) {
                            if (WizardCommonPage.uninstallContext.shouldDeleteKeystore().booleanValue()) {
                                logger.trace("Begin to remove SDK Data with Keystore directory");
                                PathUtil.remove(SDKInfo.getSdkDataPath());
                            } else {
                                logger.trace("Begin to remove SDK data without Keystore directory");
                                PathUtil.removeExceptDirectory(SDKInfo.getSdkDataPath(), "keystore");
                            }
                        } else if (WizardCommonPage.uninstallContext.shouldDeleteKeystore().booleanValue()) {
                            logger.trace("Begin to remove only Keystore directory");
                            PathUtil.remove(SDKInfo.getSdkDataPath() + File.separator + "keystore");
                        } else {
                            logger.trace("Do not remove SDK Data and Keystore directory");
                        }
                        WizardUninstallingPage.this.isStarted = false;
                        WizardUninstallingPage.this.uninstallingStep = "";
                        WizardUninstallingPage.this.uninstallingFile = "Wait until the uninstallation is complete.";
                        WizardUninstallingPage.this.ipm.setTitleInfo("Completing uninstallation...");
                        logger.trace("set current image: completing");
                        WizardUninstallingPage.this.ipm.refreshUI();
                        PackageUtil.deletePackageFilesWhichIsNotInInstalledList();
                        InstallController.removeShortcutMenu();
                        Thread.sleep(1500L);
                        WizardUninstallingPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                WizardUninstallingPage.this.wizardPageMaster.enablePages(WizardUninstallerWindow.UNINSTALLER_PAGES.COMPLETED_PAGE);
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.throwing(e);
                        WizardUninstallingPage.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                String targetDir = Config.getInstance().getTargetDir();
                                if (targetDir != null && !targetDir.isEmpty() && new File(targetDir).exists()) {
                                    InstallController.removeSDKLegacy(false);
                                }
                                WizardUninstallingPage.this.centerContainer.redraw();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException e) {
                                    logger.throwing(e);
                                }
                                WizardUninstallingPage.this.wizardPageMaster.enablePages(WizardUninstallerWindow.UNINSTALLER_PAGES.COMPLETED_PAGE);
                            }
                        });
                    }
                    finally {
                        PackageInfoJSON.removeAllCaches();
                        WizardUninstallingPage.this.isDone = false;
                    }
                }
            };
            removeWorker.start();
        }
    }

    private void handleBottomEvent() {
        this.firstButton.setEnabled(false);
        this.firstButton.setVisible(false);
        this.secondButton.setText("Cancel");
        this.secondButton.setEnabled(false);
    }

    public boolean workEventClose() {
        return true;
    }

    public class InstallProgressMonitor {
        public void setTitleInfo(final String text) {
            WizardUninstallingPage.this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    WizardUninstallingPage.this.infoLabel.setText(text);
                }
            });
        }

        public void updateProgress() {
            if (WizardUninstallingPage.this.display.isDisposed()) {
                return;
            }
            WizardUninstallingPage.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if ((WizardUninstallingPage.this.insidePercent += 1) > 360) {
                        WizardUninstallingPage.this.insidePercent = 0;
                    }
                    try {
                        WizardUninstallingPage.this.imc.update(WizardUninstallingPage.this.insidePercent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        public void refreshUI() {
            WizardUninstallingPage.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WizardUninstallingPage.this.centerContainer.redraw();
                }
            });
        }
    }
}

