/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.Install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.Install.IInstallUninstallPackageProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageUtil;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;

public class PackageUninstaller {
    private Logger logger = Log.getLogger(PackageUninstaller.class);
    private Thread workSmoothThread = null;
    private boolean success = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninstall(Package pkg, IInstallUninstallPackageProgressMonitor monitor) throws UMException {
        this.logger.info("[" + pkg + "] uninstall start");
        int resultRemoveScript = 0;
        try {
            resultRemoveScript = this.executeRemoveScript(pkg, monitor);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            resultRemoveScript = 1;
        }
        finally {
            monitor.runScriptWorked(100);
        }
        if (resultRemoveScript == 0) {
            this.logger.info("Execute remove script success.");
        } else if (resultRemoveScript == 1) {
            this.logger.error("Execute remove script fail.");
        } else if (resultRemoveScript == 2) {
            this.logger.info("This package does not need a remove script.");
        }
        File installedFileList = new File(PackageUtil.getInstalledFileListPath(pkg));
        if (!installedFileList.exists()) {
            this.logger.info("This package does not have installed file list.");
        }
        monitor.moveFilesWorked(100);
        Long uncompressedPackageSize = pkg.getUncompressedPackageSize();
        long totalRemoveSize = 0L;
        monitor.setProgress("Removing the installed files...");
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(installedFileList));
            String line = null;
            Stack<File> dirStack = new Stack<File>();
            while ((line = reader.readLine()) != null) {
                File deleteFile = new File(PathUtil.getFromInstalledPath(line));
                int work = (int)((double)(totalRemoveSize += deleteFile.length()) * 1.0 / (double)uncompressedPackageSize.longValue() * 100.0);
                if (work >= 100) {
                    work = 100;
                }
                if (!deleteFile.getCanonicalFile().equals(deleteFile.getAbsoluteFile())) {
                    PathUtil.deleteSymbolicLink(deleteFile);
                } else if (deleteFile.isDirectory()) {
                    File[] listFiles = deleteFile.listFiles();
                    if (listFiles == null || listFiles.length <= 0) {
                        PathUtil.deleteIfExists(deleteFile);
                    } else {
                        dirStack.push(deleteFile);
                    }
                } else {
                    PathUtil.deleteIfExists(deleteFile);
                }
                monitor.removeOldWorked(work);
            }
            while (!dirStack.isEmpty()) {
                File deleteDir = (File)dirStack.pop();
                File[] listFiles = deleteDir.listFiles();
                if (listFiles != null && listFiles.length > 0) continue;
                this.logger.trace("Delete dir:" + deleteDir);
                PathUtil.deleteIfExists(deleteDir);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("File not found => " + installedFileList.getAbsolutePath());
            throw new UMException(ErrorController.ErrorCode.PACKAGE_INSTALL_LIST_FILE_NOT_FOUND, installedFileList.getAbsolutePath());
        }
        catch (IOException e) {
            this.logger.error("IO Exception => " + installedFileList.getAbsolutePath());
            throw new UMException(ErrorController.ErrorCode.FAILED_TO_READ_PACKAGE_INSTALL_LIST_FILE, installedFileList.getAbsolutePath());
        }
        catch (Throwable e) {
            this.logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.INTERNAL_ERROR, e.getCause());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                    try {
                        PathUtil.deleteIfExists(installedFileList);
                    }
                    catch (Exception e) {
                        this.logger.throwing(e);
                    }
                    catch (Throwable e) {
                        this.logger.throwing(e);
                    }
                }
                monitor.setProgress("Updating the package's state to 'Removed'...");
                PackageManager.getInstance().removeFromInstalledPackages(pkg);
                PackageManager.getInstance().saveInstalledList();
            }
            catch (IOException ioe) {
                this.logger.error("Close fileoutput fail.");
            }
        }
        monitor.removeOldWorked(100);
        return true;
    }

    private int executeRemoveScript(Package pkg, final IInstallUninstallPackageProgressMonitor monitor) throws UMException {
        this.logger.info("executeRemoveScript => " + pkg.getRemoveScript());
        String script = PathUtil.get(PackageUtil.getRemoveScriptLocalPath(pkg));
        File scriptFile = new File(script);
        if (scriptFile.exists()) {
            try {
                boolean result;
                monitor.setProgress("Executing the install-script...");
                if (this.workSmoothThread == null) {
                    this.workSmoothThread = new Thread(){

                        @Override
                        public void run() {
                            int scriptWork = 0;
                            while (scriptWork < 90 && !PackageUninstaller.this.success && !monitor.getDone()) {
                                monitor.runScriptWorked(scriptWork);
                                scriptWork += 10;
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            PackageUninstaller.this.workSmoothThread = null;
                        }
                    };
                    this.workSmoothThread.start();
                }
                monitor.setProgress("Executing the remove-script...");
                ShellParser parser = new ShellParser();
                this.success = result = ShellUtil.executeScript(scriptFile, pkg.getPackageName(), parser);
                monitor.setProgress("Script Output:\n" + parser.getOutputMessage());
                monitor.setProgress("Script ExitCode:\n" + parser.getExitCode());
                if (result) {
                    return 0;
                }
                return 1;
            }
            catch (IMShellCommandFail e) {
                this.logger.throwing(e);
                throw new UMException(ErrorController.ErrorCode.REMOVE_SCRIPT_ERROR, pkg.getPackageName());
            }
        }
        return 2;
    }
}

