/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;

public class ImageList {
    long[] pixbufs;
    int width = -1;
    int height = -1;
    Image[] images = new Image[4];

    public ImageList() {
        this.pixbufs = new long[4];
    }

    public static long convertSurface(Image image) {
        long l = image.surface;
        int n = Cairo.cairo_surface_get_type(l);
        if (n != 0) {
            long l2;
            Rectangle rectangle = image.getBounds();
            int n2 = Cairo.cairo_surface_get_content(l) == 4096 ? 1 : 0;
            if ((l = Cairo.cairo_image_surface_create(n2, rectangle.width, rectangle.height)) == 0L) {
                SWT.error(2);
            }
            if ((l2 = Cairo.cairo_create(l)) == 0L) {
                SWT.error(2);
            }
            Cairo.cairo_set_operator(l2, 1);
            Cairo.cairo_set_source_surface(l2, image.surface, 0.0, 0.0);
            Cairo.cairo_paint(l2);
            Cairo.cairo_destroy(l2);
        } else {
            Cairo.cairo_surface_reference(l);
        }
        return l;
    }

    public static long createPixbuf(Image image) {
        long l;
        if (OS.USE_CAIRO) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            long l2 = ImageList.convertSurface(image);
            int n7 = Cairo.cairo_image_surface_get_format(l2);
            boolean bl = n7 == 0;
            l = OS.gdk_pixbuf_new(0, bl, 8, n6 = Cairo.cairo_image_surface_get_width(l2), n5 = Cairo.cairo_image_surface_get_height(l2));
            if (l == 0L) {
                SWT.error(2);
            }
            int n8 = OS.gdk_pixbuf_get_rowstride(l);
            long l3 = OS.gdk_pixbuf_get_pixels(l);
            if (OS.BIG_ENDIAN) {
                n4 = 0;
                n3 = 1;
                n2 = 2;
                n = 3;
            } else {
                n4 = 3;
                n3 = 2;
                n2 = 1;
                n = 0;
            }
            byte[] byArray = new byte[n8];
            long l4 = Cairo.cairo_image_surface_get_data(l2);
            if (bl) {
                int n9 = 0;
                while (n9 < n5) {
                    OS.memmove(byArray, l4 + (long)(n9 * n8), (long)n8);
                    int n10 = 0;
                    int n11 = 0;
                    while (n10 < n6) {
                        int n12 = byArray[n11 + n4] & 0xFF;
                        int n13 = byArray[n11 + n3] & 0xFF;
                        int n14 = byArray[n11 + n2] & 0xFF;
                        int n15 = byArray[n11 + n] & 0xFF;
                        byArray[n11 + 3] = (byte)n12;
                        if (n12 != 0) {
                            byArray[n11 + 0] = (byte)((n13 * 255 + n12 / 2) / n12);
                            byArray[n11 + 1] = (byte)((n14 * 255 + n12 / 2) / n12);
                            byArray[n11 + 2] = (byte)((n15 * 255 + n12 / 2) / n12);
                        }
                        ++n10;
                        n11 += 4;
                    }
                    OS.memmove(l3 + (long)(n9 * n8), byArray, (long)n8);
                    ++n9;
                }
            } else {
                int n16 = Cairo.cairo_image_surface_get_stride(l2);
                byte[] byArray2 = new byte[n16];
                int n17 = 0;
                while (n17 < n5) {
                    OS.memmove(byArray2, l4 + (long)(n17 * n16), (long)n16);
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    while (n18 < n6) {
                        byte by = byArray2[n20 + n3];
                        byte by2 = byArray2[n20 + n2];
                        byte by3 = byArray2[n20 + n];
                        byArray[n19 + 0] = by;
                        byArray[n19 + 1] = by2;
                        byArray[n19 + 2] = by3;
                        ++n18;
                        n19 += 3;
                        n20 += 4;
                    }
                    OS.memmove(l3 + (long)(n17 * n8), byArray, (long)n8);
                    ++n17;
                }
            }
            Cairo.cairo_surface_destroy(l2);
        } else {
            boolean bl;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_drawable_get_size(image.pixmap, nArray, nArray2);
            long l5 = OS.gdk_colormap_get_system();
            boolean bl2 = bl = image.mask != 0L && OS.gdk_drawable_get_depth(image.mask) == 1;
            if (bl) {
                l = OS.gdk_pixbuf_new(0, true, 8, nArray[0], nArray2[0]);
                if (l == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(l, image.pixmap, l5, 0, 0, 0, 0, nArray[0], nArray2[0]);
                long l6 = OS.gdk_pixbuf_new(0, false, 8, nArray[0], nArray2[0]);
                if (l6 == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(l6, image.mask, 0L, 0, 0, 0, 0, nArray[0], nArray2[0]);
                int n = OS.gdk_pixbuf_get_rowstride(l);
                long l7 = OS.gdk_pixbuf_get_pixels(l);
                byte[] byArray = new byte[n];
                int n21 = OS.gdk_pixbuf_get_rowstride(l6);
                long l8 = OS.gdk_pixbuf_get_pixels(l6);
                byte[] byArray3 = new byte[n21];
                int n22 = 0;
                while (n22 < nArray2[0]) {
                    long l9 = l7 + (long)(n22 * n);
                    OS.memmove(byArray, l9, (long)n);
                    long l10 = l8 + (long)(n22 * n21);
                    OS.memmove(byArray3, l10, (long)n21);
                    int n23 = 0;
                    while (n23 < nArray[0]) {
                        if (byArray3[n23 * 3] == 0) {
                            byArray[n23 * 4 + 3] = 0;
                        }
                        ++n23;
                    }
                    OS.memmove(l9, byArray, (long)n);
                    ++n22;
                }
                OS.g_object_unref(l6);
            } else {
                ImageData imageData = image.getImageData();
                boolean bl3 = imageData.getTransparencyType() == 1;
                l = OS.gdk_pixbuf_new(0, bl3, 8, nArray[0], nArray2[0]);
                if (l == 0L) {
                    SWT.error(2);
                }
                OS.gdk_pixbuf_get_from_drawable(l, image.pixmap, l5, 0, 0, 0, 0, nArray[0], nArray2[0]);
                if (bl3) {
                    byte[] byArray = imageData.alphaData;
                    int n = OS.gdk_pixbuf_get_rowstride(l);
                    long l11 = OS.gdk_pixbuf_get_pixels(l);
                    byte[] byArray4 = new byte[n];
                    int n24 = 0;
                    while (n24 < nArray2[0]) {
                        long l12 = l11 + (long)(n24 * n);
                        OS.memmove(byArray4, l12, (long)n);
                        int n25 = 0;
                        while (n25 < nArray[0]) {
                            byArray4[n25 * 4 + 3] = byArray[n24 * nArray[0] + n25];
                            ++n25;
                        }
                        OS.memmove(l12, byArray4, (long)n);
                        ++n24;
                    }
                }
            }
        }
        return l;
    }

    public int add(Image image) {
        int n = 0;
        while (n < this.images.length) {
            if (this.images[n] != null && this.images[n].isDisposed()) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0L;
            }
            if (this.images[n] == null) break;
            ++n;
        }
        if (n == this.images.length) {
            Image[] imageArray = new Image[this.images.length + 4];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
            long[] lArray = new long[this.pixbufs.length + 4];
            System.arraycopy(this.pixbufs, 0, lArray, 0, this.pixbufs.length);
            this.pixbufs = lArray;
        }
        this.set(n, image);
        return n;
    }

    public void dispose() {
        if (this.pixbufs == null) {
            return;
        }
        int n = 0;
        while (n < this.pixbufs.length) {
            if (this.pixbufs[n] != 0L) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            ++n;
        }
        this.images = null;
        this.pixbufs = null;
    }

    public Image get(int n) {
        return this.images[n];
    }

    public long getPixbuf(int n) {
        return this.pixbufs[n];
    }

    public int indexOf(Image image) {
        if (image == null) {
            return -1;
        }
        int n = 0;
        while (n < this.images.length) {
            if (image == this.images[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(long l) {
        if (l == 0L) {
            return -1;
        }
        int n = 0;
        while (n < this.images.length) {
            if (l == this.pixbufs[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isDisposed() {
        return this.images == null;
    }

    public void put(int n, Image image) {
        int n2 = this.images.length;
        if (n < 0 || n >= n2) {
            return;
        }
        if (image != null) {
            this.set(n, image);
        } else {
            this.images[n] = null;
            if (this.pixbufs[n] != 0L) {
                OS.g_object_unref(this.pixbufs[n]);
            }
            this.pixbufs[n] = 0L;
        }
    }

    public void remove(Image image) {
        if (image == null) {
            return;
        }
        int n = 0;
        while (n < this.images.length) {
            if (image == this.images[n]) {
                OS.g_object_unref(this.pixbufs[n]);
                this.images[n] = null;
                this.pixbufs[n] = 0L;
            }
            ++n;
        }
    }

    void set(int n, Image image) {
        long l;
        long l2 = ImageList.createPixbuf(image);
        int n2 = OS.gdk_pixbuf_get_width(l2);
        int n3 = OS.gdk_pixbuf_get_height(l2);
        if (this.width == -1 || this.height == -1) {
            this.width = n2;
            this.height = n3;
        }
        if (n2 != this.width || n3 != this.height) {
            l = OS.gdk_pixbuf_scale_simple(l2, this.width, this.height, 2);
            OS.g_object_unref(l2);
            l2 = l;
        }
        if ((l = this.pixbufs[n]) != 0L) {
            if (this.images[n] == image) {
                OS.gdk_pixbuf_copy_area(l2, 0, 0, this.width, this.height, l, 0, 0);
                OS.g_object_unref(l2);
                l2 = l;
            } else {
                OS.g_object_unref(l);
            }
        }
        this.pixbufs[n] = l2;
        this.images[n] = image;
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.images.length) {
            if (this.images[n2] != null) {
                if (this.images[n2].isDisposed()) {
                    OS.g_object_unref(this.pixbufs[n2]);
                    this.images[n2] = null;
                    this.pixbufs[n2] = 0L;
                }
                if (this.images[n2] != null) {
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }
}

