/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.linux;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.IMShellCommandFail;
import org.tizen.manager.linux.LinuxShellRunningProgramParser;
import org.tizen.manager.linux.ProcessInformation;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.ProgramController;
import org.tizen.manager.util.ShellParser;
import org.tizen.manager.util.ShellUtil;

public class LinuxProgramController
extends ProgramController {
    private static final Logger logger = Log.getLogger(LinuxProgramController.class);
    HashMap<Integer, Boolean> pidToIsSDKProcessMap = new HashMap();
    HashMap<Integer, String> pidToSDKProcessNameMap = new HashMap();

    private String getSDKProcessNameFromProcessInformation(ProcessInformation pInfo) {
        int pid = Integer.parseInt(pInfo.getPid());
        Boolean isSDKProcess = this.pidToIsSDKProcessMap.get(pid);
        String processName = null;
        if (isSDKProcess == null) {
            if (this.isIDE(pInfo)) {
                processName = ProgramController.PROG_NAME_IDE;
            } else if (this.isEmulatorManager(pInfo)) {
                processName = ProgramController.PROG_NAME_EMUL_MGR;
            } else if (this.isEmulator(pInfo)) {
                processName = ProgramController.PROG_NAME_EMUL;
            } else if (this.isDynamicAnalyzer(pInfo)) {
                processName = ProgramController.PROG_NAME_DA;
            } else if (this.isWebSimulator(pInfo)) {
                processName = ProgramController.PROG_NAME_WEB_SIM;
            } else if (this.isManager(pInfo)) {
                processName = ProgramController.PROG_NAME_MANAGER;
            } else if (this.isUninstaller(pInfo)) {
                processName = ProgramController.PROG_NAME_UNINSTALLER;
            }
            isSDKProcess = processName != null;
            this.pidToIsSDKProcessMap.put(pid, isSDKProcess);
            if (isSDKProcess.booleanValue()) {
                this.pidToSDKProcessNameMap.put(pid, processName);
            }
        } else if (isSDKProcess.booleanValue()) {
            processName = this.pidToSDKProcessNameMap.get(pid);
        }
        return processName;
    }

    private String getPkgMgrProcessNameFromProcessInformation(ProcessInformation pInfo) {
        int pid = Integer.parseInt(pInfo.getPid());
        Boolean isSDKProcess = this.pidToIsSDKProcessMap.get(pid);
        String processName = null;
        if (isSDKProcess == null) {
            if (this.isManager(pInfo)) {
                processName = ProgramController.PROG_NAME_MANAGER;
            } else if (this.isManagerCli(pInfo)) {
                processName = ProgramController.PROG_NAME_MANAGER_CLI;
            } else if (this.isUninstaller(pInfo)) {
                processName = ProgramController.PROG_NAME_UNINSTALLER;
            }
            isSDKProcess = processName != null;
            this.pidToIsSDKProcessMap.put(pid, isSDKProcess);
            if (isSDKProcess.booleanValue()) {
                this.pidToSDKProcessNameMap.put(pid, processName);
            }
        } else if (isSDKProcess.booleanValue()) {
            processName = this.pidToSDKProcessNameMap.get(pid);
        }
        return processName;
    }

    private String getCommandLineOutput(int pid) {
        String pidCmd = "cat -A /proc/" + pid + "/cmdline";
        ShellParser parser = new ShellParser();
        try {
            ShellUtil.execute(pidCmd, parser);
        }
        catch (IMShellCommandFail e) {
            logger.throwing(e);
            return null;
        }
        return parser.getOutputMessage();
    }

    private String getExecutePathOutput(int pid) {
        String pidCmd = "readlink -m /proc/" + pid + "/exe";
        ShellParser parser = new ShellParser();
        try {
            ShellUtil.execute(pidCmd, parser);
        }
        catch (IMShellCommandFail e) {
            logger.throwing(e);
            return null;
        }
        return parser.getOutputMessage();
    }

    @Override
    public List<String> getSDKProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        if (SDKInfo.getInstalledPath().isEmpty()) {
            return result;
        }
        String[] command = new String[]{"/bin/sh", "-c", "ps -ax"};
        LinuxShellRunningProgramParser parser = new LinuxShellRunningProgramParser();
        try {
            ShellUtil.execute(command, (ShellParser)parser);
        }
        catch (IMShellCommandFail e1) {
            logger.trace("\tFailed to get SDK pid's");
            return result;
        }
        List<ProcessInformation> pInfoList = parser.getProcessInformation();
        for (ProcessInformation processInfo : pInfoList) {
            String processName = this.getSDKProcessNameFromProcessInformation(processInfo);
            if (processName == null) continue;
            result.add(processName);
        }
        return result;
    }

    @Override
    public List<String> getPkgMgrProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        if (SDKInfo.getInstalledPath().isEmpty()) {
            return result;
        }
        String[] command = new String[]{"/bin/sh", "-c", "ps -ax"};
        LinuxShellRunningProgramParser parser = new LinuxShellRunningProgramParser();
        try {
            ShellUtil.execute(command, (ShellParser)parser);
        }
        catch (IMShellCommandFail e1) {
            logger.trace("\tFailed to get SDK pid's");
            return result;
        }
        List<ProcessInformation> pInfoList = parser.getProcessInformation();
        for (ProcessInformation processInfo : pInfoList) {
            String processName = this.getPkgMgrProcessNameFromProcessInformation(processInfo);
            if (processName == null) continue;
            result.add(processName);
        }
        return result;
    }

    private boolean isProcessRunningInInstalledPath(ProcessInformation pInfo) {
        int pid = Integer.parseInt(pInfo.getPid());
        String output = this.getExecutePathOutput(pid);
        if (output != null && output.startsWith(SDKInfo.getInstalledPath())) {
            return true;
        }
        output = this.getCommandLineOutput(pid);
        return output != null && output.startsWith(SDKInfo.getInstalledPath());
    }

    private boolean isIDE(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("eclipse")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isEmulatorManager(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java") && command.contains("-jar " + ProgramController.JAR_NAME_EMUL_MGR) && command.contains(SDKInfo.getInstalledPath());
    }

    private boolean isEmulator(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("emulator-x86")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isDynamicAnalyzer(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("dynamic-analyzer")) {
            return false;
        }
        return this.isProcessRunningInInstalledPath(pInfo);
    }

    private boolean isWebSimulator(ProcessInformation pInfo) {
        if (!pInfo.getCommand().contains("websimulator") || !pInfo.getCommand().contains("html")) {
            return false;
        }
        return pInfo.getCommand().contains(SDKInfo.getInstalledPath());
    }

    private boolean isManager(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java") && command.contains("-jar " + ProgramController.JAR_NAME_MANAGER) && command.contains("-path " + SDKInfo.getInstalledPath());
    }

    private boolean isManagerCli(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java") && command.contains("-jar " + ProgramController.JAR_NAME_MANAGER_CLI) && command.contains("-path " + SDKInfo.getInstalledPath());
    }

    private boolean isUninstaller(ProcessInformation pInfo) {
        String command = pInfo.getCommand();
        return command != null && command.contains("java") && command.contains("-jar " + ProgramController.JAR_NAME_UNINSTALLER) && command.contains("-path " + SDKInfo.getInstalledPath());
    }
}

