/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;

public class PlatformUtil {
    public static final int LINUX_32 = 1;
    public static final int LINUX_64 = 4;
    public static final int WINDOWS_32 = 8;
    public static final int WINDOWS_64 = 16;
    public static final int MACOS_32 = 32;
    public static final int MACOS_64 = 64;
    private static final int UBUNTU_32 = 128;
    private static final int UBUNTU_64 = 256;
    private static final int GENERIC_LINUX = 389;
    private static final int GENERIC_WINDOWS = 24;
    private static final int GENERIC_MACOS = 96;
    private static final String DATA_MODEL_32 = "32";
    public static final int CURRENT_PLATFORM = PlatformUtil.getCurrentPlatform();
    public static final String CURRENT_CHARSET = PlatformUtil.getCurrentCharset();
    private static final String JRE_NAME = System.getProperty("java.runtime.name").toLowerCase();
    private static final String JVM_NAME = System.getProperty("java.vm.name").toLowerCase();
    private static final String JAVA_VERSION = System.getProperty("java.specification.version").toLowerCase();
    private static final String JAVA_SIX = "1.6";
    private static final String JAVA_EIGHT = "1.8";
    private static final String CHECK_OPENJDK = "openjdk";
    private static final Logger logger = Log.getLogger(PlatformUtil.class);

    private static int getCurrentPlatform() {
        String os = System.getProperty("os.name");
        String dataModel = System.getProperty("sun.arch.data.model");
        if (os.startsWith("Linux")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 1;
            }
            return 4;
        }
        if (os.startsWith("Windows")) {
            if (dataModel.equals(DATA_MODEL_32)) {
                return 8;
            }
            return 16;
        }
        if (os.startsWith("Mac OS")) {
            return 64;
        }
        if (dataModel.equals(DATA_MODEL_32)) {
            return 1;
        }
        return 4;
    }

    private static String getCurrentCharset() {
        return System.getProperty("sun.jnu.encoding");
    }

    public static String getPlatformInfo() {
        String info = "";
        info = info + "OS Name: " + System.getProperty("os.name") + "\n";
        info = info + "OS Version: " + System.getProperty("os.version") + "\n";
        info = info + "Data Model: " + System.getProperty("sun.arch.data.model") + "\n";
        if (CURRENT_PLATFORM == 1) {
            String filePath = "/etc/lsb-release";
            try {
                info = info + PathUtil.readAllTextFromFile(filePath, true) + "\n";
            }
            catch (UMException e) {
                logger.throwing(e);
            }
        }
        info = info + "java runtime name: " + System.getProperty("java.runtime.name") + "\n";
        info = info + "java vm name: " + System.getProperty("java.vm.name") + "\n";
        info = info + "vm version : " + System.getProperty("java.vm.version") + "\n";
        return info;
    }

    public static boolean isInstalledOpenJDK() {
        if (JRE_NAME.contains(CHECK_OPENJDK)) {
            return true;
        }
        return JVM_NAME.contains(CHECK_OPENJDK);
    }

    public static boolean isLinux() {
        return (CURRENT_PLATFORM & 0x185) > 0;
    }

    public static boolean isUbuntu() {
        return PlatformUtil.isLinux();
    }

    public static boolean isMacOS() {
        return (CURRENT_PLATFORM & 0x60) > 0;
    }

    public static boolean isWindows() {
        return (CURRENT_PLATFORM & 0x18) > 0;
    }

    public static boolean isUnderJava8() {
        try {
            double currentJava = Double.parseDouble(JAVA_VERSION);
            double target = Double.parseDouble(JAVA_EIGHT);
            return currentJava < target;
        }
        catch (Exception e) {
            logger.throwing(e);
            logger.warn("Java version format is not correct");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUbuntuVersion() {
        if (PlatformUtil.isLinux()) {
            String cmd = "cat /etc/lsb-release | grep DISTRIB_RELEASE | sed 's/\"//g' | awk -F= '{print $2}'";
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", cmd);
            Process proc = null;
            try {
                proc = pb.start();
                BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                line = read.readLine();
                if (line != null) {
                    String string = line.trim();
                    return string;
                }
                proc.waitFor();
                proc.destroy();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
            }
        } else {
            return null;
        }
        return null;
    }
}

