/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.download;

import java.util.ArrayList;
import java.util.List;
import org.tizen.manager.core.download.DownloadObject;
import org.tizen.manager.core.download.IDownloadManagerMonitor;
import org.tizen.manager.core.download.IDownloadPackageProgressMonitor;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.IDownloadProgressMonitor;

public class DownloadManagerMonitor
implements IDownloadManagerMonitor {
    private DownloadObject doObject;
    private int downloadWorked = 0;
    private int extractedWorked = 0;
    private Exception error = null;
    private boolean isCanceled = false;
    private List<IDownloadProgressMonitor> downloadProgressMonitor = new ArrayList<IDownloadProgressMonitor>();

    public DownloadManagerMonitor(DownloadObject doObject) {
        this.doObject = doObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTask() {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            List<IDownloadPackageProgressMonitor> monitorList = this.doObject.getMonitorList();
            ArrayList<IDownloadPackageProgressMonitor> cloneList = new ArrayList<IDownloadPackageProgressMonitor>();
            cloneList.addAll(monitorList);
            for (IDownloadPackageProgressMonitor idmProgressMonitor : cloneList) {
                if (!idmProgressMonitor.getDone()) {
                    idmProgressMonitor.beginTask("");
                    continue;
                }
                this.doObject.removeMonitor(idmProgressMonitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        if (!this.isCanceled) {
            DownloadObject downloadObject = this.doObject;
            synchronized (downloadObject) {
                List<IDownloadPackageProgressMonitor> monitorList = this.doObject.getMonitorList();
                ArrayList<IDownloadPackageProgressMonitor> cloneList = new ArrayList<IDownloadPackageProgressMonitor>();
                cloneList.addAll(monitorList);
                boolean allCanceled = true;
                for (IDownloadPackageProgressMonitor idmProgressMonitor : cloneList) {
                    if (!idmProgressMonitor.isCanceled()) {
                        allCanceled = false;
                        continue;
                    }
                    this.doObject.removeMonitor(idmProgressMonitor);
                    idmProgressMonitor.setError(new UMException(ErrorController.ErrorCode.CANCELED_DOWNLOADING_PACKAGE_FILE));
                    idmProgressMonitor.done();
                }
                this.isCanceled = allCanceled;
            }
        }
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean val) {
        this.isCanceled = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            this.doObject.setCompleted(true);
            ArrayList<IDownloadPackageProgressMonitor> monitorListClone = new ArrayList<IDownloadPackageProgressMonitor>();
            monitorListClone.addAll(this.doObject.getMonitorList());
            for (IDownloadPackageProgressMonitor idmProgressMonitor : monitorListClone) {
                this.doObject.removeMonitor(idmProgressMonitor);
                idmProgressMonitor.setError(this.getError());
                idmProgressMonitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDone() {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            return this.doObject.isCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadWorked(int percent) {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            List<IDownloadPackageProgressMonitor> monitorList = this.doObject.getMonitorList();
            for (IDownloadPackageProgressMonitor idmProgressMonitor : monitorList) {
                idmProgressMonitor.downloadWorked(percent);
            }
        }
        this.downloadWorked = percent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractWorked(int percent) {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            List<IDownloadPackageProgressMonitor> monitorList = this.doObject.getMonitorList();
            for (IDownloadPackageProgressMonitor idmProgressMonitor : monitorList) {
                idmProgressMonitor.extractWorked(percent);
            }
        }
        this.extractedWorked = percent;
    }

    @Override
    public int getDownloadWorked() {
        return this.downloadWorked;
    }

    @Override
    public int getExtractWorked() {
        return this.extractedWorked;
    }

    @Override
    public void setError(Exception err) {
        this.error = err;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public void addDownloadProgressMonitor(DownloadProgressMonitor dpm) {
        this.downloadProgressMonitor.add(dpm);
    }

    @Override
    public void updateDownloadWorked() {
        double percentDouble = 0.0;
        for (IDownloadProgressMonitor next : this.downloadProgressMonitor) {
            percentDouble += (double)next.getCurrentWork() * next.getRate() / 100.0;
        }
        this.downloadWorked((int)percentDouble);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProgress(String message) {
        DownloadObject downloadObject = this.doObject;
        synchronized (downloadObject) {
            List<IDownloadPackageProgressMonitor> monitorList = this.doObject.getMonitorList();
            for (IDownloadPackageProgressMonitor idmProgressMonitor : monitorList) {
                idmProgressMonitor.setProgress(message);
            }
        }
    }
}

