/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.svc.sdkutils;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ExtRepositoryManager;
import org.tizen.manager.core.RepositoryManager;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageSet;
import org.tizen.manager.svc.sdkutils.SDKPackage;
import org.tizen.manager.svc.sdkutils.SDKPackageMap;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.ProgramController;

public class PackageInfoJSON {
    private static final Logger logger = Log.getLogger(PackageInfoJSON.class);
    public static final int MAX_SAVE_CACHE_NUM = 20;
    public static final String SDK_UTILS_CACHE = "sdk-utils-cache";
    public static final String ALL_PKG_INFO_NAME = "all_packageinfo";
    public static final String PKG_INFO_NAME_TEMP = "temp_file";

    public static boolean init(String pkgMgrDirPath) {
        boolean retSuccess = false;
        if (pkgMgrDirPath != null && !pkgMgrDirPath.isEmpty()) {
            Config.executablePath = pkgMgrDirPath;
            try {
                SDKInfo.init();
                retSuccess = true;
            }
            catch (Exception e) {
                logger.error("PkgMgr init exeption: " + e.getMessage());
            }
        }
        return retSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String savePackageInfoToFile() {
        String savePath = null;
        String cacheFielName = ALL_PKG_INFO_NAME;
        PackageInfoJSON.removeOldCaches(cacheFielName);
        List<SDKPackage> pkgList = PackageInfoJSON.makeSDKPackageList();
        SDKPackageMap pkgMap = new SDKPackageMap();
        HashMap<String, SDKPackage> pkgMaps = new HashMap<String, SDKPackage>();
        for (SDKPackage sdkPkg : pkgList) {
            pkgMaps.put(sdkPkg.getName(), sdkPkg);
        }
        pkgMap.setSdkPackages(pkgMaps);
        String jsonStr = new Gson().toJson(pkgMap);
        String curTime = new SimpleDateFormat("yyyyMMdd-HHmmssSSS").format(new Date());
        String tempName = "temp_file_" + curTime;
        String dirPath = PackageInfoJSON.getDigestHashString(SDKInfo.getInstalledPath(), "MD5");
        String tempPath = PathUtil.get(Config.getManagerConfigHome(), SDK_UTILS_CACHE, dirPath, tempName);
        BufferedWriter writer = null;
        File tempFile = null;
        try {
            tempFile = new File(tempPath);
            File parentDirectory = tempFile.getParentFile();
            File grandParentDirectory = parentDirectory.getParentFile();
            if (null != grandParentDirectory && !grandParentDirectory.exists()) {
                grandParentDirectory.mkdirs();
            }
            if (null != parentDirectory && !parentDirectory.exists()) {
                parentDirectory.mkdirs();
                String sdkInfoPath = PathUtil.get(SDKInfo.getInstalledPath(), "sdk.info");
                String copySdkInfoPath = PathUtil.get(Config.getManagerConfigHome(), SDK_UTILS_CACHE, dirPath, "sdk.info");
                PathUtil.fileCopy(sdkInfoPath, copySdkInfoPath);
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempPath), "UTF-8"));
            writer.write(jsonStr);
        }
        catch (IOException e) {
            logger.error("savePackageInfoToFile IOException: " + e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.error("savePackageInfoToFile IOException: " + e.getMessage());
            }
        }
        String saveName = cacheFielName + "_" + curTime + ".json";
        savePath = PathUtil.get(Config.getManagerConfigHome(), SDK_UTILS_CACHE, dirPath, saveName);
        File saveFile = new File(savePath);
        if (tempFile.exists()) {
            if (!PathUtil.move(tempFile, saveFile)) {
                logger.error("savePackageInfoToFile rename from temp error!!");
                savePath = null;
                tempFile.delete();
            }
        } else {
            logger.error("temp file is not exist!!");
        }
        if (savePath != null) {
            logger.info("savePackageInfoToFile path is: " + savePath);
        } else {
            logger.info("savePackageInfoToFile failed!!");
        }
        return savePath;
    }

    public static String getLatesCache(String cacheName) {
        String retPath = null;
        File[] caches = PackageInfoJSON.getCacheFiles(cacheName);
        if (caches != null && caches.length > 0) {
            retPath = caches[caches.length - 1].getAbsolutePath();
        }
        if (retPath != null) {
            logger.info("getLatesCache path is: " + retPath);
        } else {
            logger.info("getLatesCache is not exist");
        }
        return retPath;
    }

    public static String getRecentPackageInfo() {
        String retSavePath = null;
        ProgramController controller = ProgramController.createProgramController();
        List<String> pkgMgrProcessList = controller.getPkgMgrProcessList();
        if (pkgMgrProcessList != null && !pkgMgrProcessList.isEmpty()) {
            retSavePath = PackageInfoJSON.getLatesCache(ALL_PKG_INFO_NAME);
        } else {
            try {
                Config.getInstance().init();
                RepositoryManager.getInstance().init();
                ExtRepositoryManager.getInstance().init(true);
                PackageManager pkgmgr = PackageManager.getInstance();
                pkgmgr.init(true);
                if (!pkgmgr.getInstalledPackages().isEmpty() && !pkgmgr.getRecentPackages().isEmpty()) {
                    retSavePath = PackageInfoJSON.getLatesCache(ALL_PKG_INFO_NAME);
                }
            }
            catch (Exception e) {
                logger.error("PkgMgr init exeption: " + e.getMessage());
            }
        }
        if (retSavePath != null) {
            logger.info("recentPckageInfo: " + retSavePath);
        }
        return retSavePath;
    }

    public static String getInstalledPackageInfo() {
        String retSavePath = null;
        ProgramController controller = ProgramController.createProgramController();
        List<String> pkgMgrProcessList = controller.getPkgMgrProcessList();
        if (pkgMgrProcessList != null && !pkgMgrProcessList.isEmpty()) {
            retSavePath = PackageInfoJSON.getLatesCache(ALL_PKG_INFO_NAME);
        } else {
            try {
                Config.getInstance().init();
                PackageManager.getInstance().init(false);
                PackageInfoJSON.savePackageInfoToFile();
                retSavePath = PackageInfoJSON.getLatesCache(ALL_PKG_INFO_NAME);
            }
            catch (Exception e) {
                logger.error("PkgMgr init exeption: " + e.getMessage());
            }
        }
        if (retSavePath != null) {
            logger.info("getOnlyInstalledPackageInfo: " + retSavePath);
        }
        return retSavePath;
    }

    private static List<SDKPackage> makeSDKPackageList() {
        ArrayList<SDKPackage> pkgList = new ArrayList<SDKPackage>();
        PackageManager pkgmgr = PackageManager.getInstance();
        PackageSet allPkgs = pkgmgr.getRecentPackages();
        if (allPkgs != null && allPkgs.size() > 0) {
            for (Package recentPkg : allPkgs) {
                SDKPackage sdkPkg = new SDKPackage();
                Package pkg = recentPkg;
                String pkgName = pkg.getPackageName();
                boolean isInstalled = pkgmgr.isInstalledPackage(pkg);
                if (isInstalled) {
                    pkg = pkgmgr.getInstalledPackageByName(pkgName);
                }
                sdkPkg.setName(pkgName);
                sdkPkg.setLabel(pkg.getLabel());
                sdkPkg.setVersion(pkg.getVersion().toString());
                sdkPkg.setOs(new ArrayList<String>(pkg.getOS()));
                sdkPkg.setBuildHostOs(pkg.getBuildHostOS());
                sdkPkg.setMaintainer(pkg.getMaintainer());
                sdkPkg.setAttribute(pkg.getAttribute());
                sdkPkg.setSha256(pkg.getSHA256());
                sdkPkg.setSize(pkg.getPackageSize().toString());
                sdkPkg.setPath(pkg.getFileName());
                sdkPkg.setInstallDependency(new ArrayList<String>(pkg.getDependentPackageNames()));
                sdkPkg.setBuildDependency(new ArrayList<String>(pkg.getBuildDependency()));
                sdkPkg.setSourceDependency(new ArrayList<String>(pkg.getSourcedDependency()));
                sdkPkg.setDescription(pkg.getDescription());
                sdkPkg.setMetaPkg(pkg.isMeta());
                sdkPkg.setExtension(pkg.isExtensionPackage());
                sdkPkg.setFormattedDescription(pkg.getFormattedDescription());
                sdkPkg.setExtName(pkg.getExtensionName());
                sdkPkg.setExtPlatform(pkg.getExtensionPlatform());
                sdkPkg.setExtProfile(pkg.getExtensionProfile());
                sdkPkg.setExtDevelopEnv(pkg.getExtensionDevEnv());
                sdkPkg.setExtPath(pkg.getExtensionPath());
                sdkPkg.setInstalled(isInstalled);
                sdkPkg.setUpdateable(PackageInfoJSON.isUpdateable(pkgmgr, pkg));
                pkgList.add(sdkPkg);
            }
        }
        return pkgList;
    }

    private static boolean isUpdateable(PackageManager pkgmgr, Package pkg) {
        boolean isUpdateable = false;
        if (pkg != null) {
            isUpdateable = pkg.isMeta() ? (pkgmgr.hasMetaPackagesInChildren(pkg) ? false : pkgmgr.isMetaUpdatable(pkg)) : pkgmgr.isUpdatable(pkg);
        } else {
            logger.info("package is NULL!!");
        }
        return isUpdateable;
    }

    private static File[] getCacheFiles(final String cacheName) {
        File confDir;
        File[] retCaches = null;
        String dirPath = PackageInfoJSON.getDigestHashString(SDKInfo.getInstalledPath(), "MD5");
        String cacheDirPath = PathUtil.get(Config.getManagerConfigHome(), SDK_UTILS_CACHE, dirPath);
        if (cacheDirPath != null && !cacheDirPath.isEmpty() && (retCaches = (confDir = new File(cacheDirPath)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().matches(cacheName + "_" + "[0-9]{8}-[0-9]{9}.json");
            }
        })) != null) {
            Arrays.sort(retCaches, new Comparator<File>(){

                @Override
                public int compare(File arg0, File arg1) {
                    return arg0.compareTo(arg1);
                }
            });
        }
        return retCaches;
    }

    private static void removeOldCaches(String cacheName) {
        File[] caches = PackageInfoJSON.getCacheFiles(cacheName);
        if (caches != null && caches.length > 0) {
            for (int i = 0; i <= caches.length - 20; ++i) {
                caches[i].delete();
            }
        }
    }

    public static void removeAllCaches() {
        String dirPath = PackageInfoJSON.getDigestHashString(SDKInfo.getInstalledPath(), "MD5");
        String rmPath = PathUtil.get(Config.getManagerConfigHome(), SDK_UTILS_CACHE, dirPath);
        File rmDirFile = new File(rmPath);
        PathUtil.remove(rmDirFile);
    }

    private static String getDigestHashString(String str, String hash) {
        String result = null;
        try {
            MessageDigest sh = MessageDigest.getInstance(hash);
            sh.update(str.getBytes());
            byte[] byteData = sh.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return result;
    }
}

