/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.ManagerConstants;
import org.tizen.manager.core.config.Config;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.exception.ErrorController;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.pkg.Package;
import org.tizen.manager.pkg.PackageManager;
import org.tizen.manager.pkg.PackageVersion;
import org.tizen.manager.util.DownloadProgressMonitor;
import org.tizen.manager.util.Downloader;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ZipLibrary;

public class SelfUpdater {
    private static final Logger logger = Log.getLogger(SelfUpdater.class);
    static final String MANAGER_PACKAGE_NAME = "package-manager";
    private static final String SELF_UPDATE_DIR_PATH = PathUtil.get(Config.getManagerConfigHome(), "self-update", Long.toString((long)SDKInfo.getInstalledPath().hashCode() & 0xFFFFFFFFL));
    private static SelfUpdater myObj = null;

    private SelfUpdater() {
    }

    public static SelfUpdater getInstance() {
        if (myObj == null) {
            return new SelfUpdater();
        }
        return myObj;
    }

    public boolean canManagerUpdate() {
        Package pkg = PackageManager.getInstance().getPackageByName(MANAGER_PACKAGE_NAME);
        if (pkg == null) {
            return false;
        }
        logger.info("Checking installer can update....");
        String version = Config.getInstance().getManagerVersion();
        logger.trace("\tCurrent Package Manager => " + version);
        if (version == null || version.isEmpty()) {
            logger.trace("\tPackage Manager version is null. cannot update itself.");
            return false;
        }
        pkg.getVersion().toString();
        logger.trace("\tUpdate version => " + pkg.getVersion().toString());
        if (PackageVersion.compareTo(new PackageVersion(version), pkg.getVersion()) < 0) {
            logger.trace("\tUpdate version is higher than current version. So, manager will be updated.");
            return true;
        }
        return false;
    }

    public void updateManager() throws UMException {
        logger.trace("\tPackage Manager will update itself");
        Package pkg = PackageManager.getInstance().getPackageByName(MANAGER_PACKAGE_NAME);
        if (pkg == null) {
            throw new UMException(ErrorController.ErrorCode.NO_MANAGER);
        }
        this.installToTemporaryDirectory(pkg);
        logger.trace("\t## Success to update the Manager, and restart now.");
        this.runNewManager(pkg);
    }

    private void installToTemporaryDirectory(Package pkg) throws UMException {
        this.cleanTempDirForSelfUpdate();
        String downloadFilePath = this.downloadToTemporaryDirectory(pkg);
        this.extractToTemporaryDirectory(downloadFilePath);
        logger.trace("\tSuccess to extract updatable Package Manager.");
    }

    private String downloadToTemporaryDirectory(Package pkg) throws UMException {
        Downloader downloader;
        long size;
        if (pkg == null) {
            logger.error("Cannot get manager package from repository.");
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_MANAGER, "Invalid arguments -pkg is null");
        }
        String packageName = pkg.getFileName();
        if (packageName == null) {
            logger.error("Cannot get manager package from repository.");
            throw new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_MANAGER, "Invalid arguments -pkg name is null");
        }
        String downloadFilePath = PathUtil.get(SELF_UPDATE_DIR_PATH, PathUtil.getFileName(packageName));
        File downloadFile = new File(downloadFilePath);
        if (downloadFile.exists() && !PathUtil.remove(downloadFilePath)) {
            logger.error("Cannot remove installmanager. => " + downloadFilePath);
        }
        if ((size = (downloader = new Downloader(pkg.getURL())).download(downloadFilePath, new DownloadProgressMonitor())) <= 0L) {
            new UMException(ErrorController.ErrorCode.CANNOT_DOWNLOAD_MANAGER, "Downloaded size is zero.");
        }
        return downloadFilePath;
    }

    private boolean cleanTempDirForSelfUpdate() {
        File[] umBinariesAfter;
        int cnt = 0;
        File managerBinary = null;
        managerBinary = PlatformUtil.isWindows() ? new File(PathUtil.get(SELF_UPDATE_DIR_PATH, "binary")) : (PlatformUtil.isLinux() || PlatformUtil.isMacOS() ? new File(SELF_UPDATE_DIR_PATH) : new File(PathUtil.get(SELF_UPDATE_DIR_PATH, "binary")));
        File[] umBinariesBefore = managerBinary.listFiles();
        if (umBinariesBefore != null) {
            for (File binary : umBinariesBefore) {
                if (!binary.getName().startsWith(ManagerConstants.MANAGER_BINARY_NAME) || PathUtil.remove(binary)) continue;
                logger.error("Cannot delete " + binary.getAbsolutePath());
            }
        }
        if ((umBinariesAfter = managerBinary.listFiles()) != null) {
            for (File rest : umBinariesAfter) {
                if (!rest.getName().startsWith(ManagerConstants.MANAGER_BINARY_NAME)) continue;
                ++cnt;
            }
        }
        if (cnt == 0) {
            logger.trace("\tSuccess to clean up temporary downloaded Package Manager. =>" + managerBinary.getAbsolutePath());
            return true;
        }
        logger.error("Fail to clean up temporary downloaded Package Manager. => " + managerBinary.getAbsolutePath());
        return false;
    }

    private void extractToTemporaryDirectory(String filePath) throws UMException {
        this.removeUMBinaryInTemp();
        ZipLibrary zipLibrary = new ZipLibrary(filePath, null);
        long size = 0L;
        try {
            size = zipLibrary.unzip(SELF_UPDATE_DIR_PATH, null);
        }
        catch (Exception e) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_UNPACK_MANAGER, "Size is zero!");
        }
        if (size <= 0L) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_UNPACK_MANAGER, "Size is zero!");
        }
    }

    private void removeUMBinaryInTemp() {
        File tempDirFile = new File(SELF_UPDATE_DIR_PATH);
        File managerDir = new File(PathUtil.get(SELF_UPDATE_DIR_PATH, "data", MANAGER_PACKAGE_NAME));
        if (managerDir.exists() && !PathUtil.remove(managerDir)) {
            logger.error("Cannot delete " + managerDir.getAbsolutePath());
        }
        if (tempDirFile.exists()) {
            File[] fileList = tempDirFile.listFiles();
            assert (fileList != null);
            for (File childFile : fileList) {
                if (!this.isUMBinary(childFile.getName()) || childFile.delete()) continue;
                logger.error("Cannot delete " + childFile.getAbsolutePath());
            }
        }
    }

    private boolean isUMBinary(String fileName) {
        return fileName.equals("PackageManagerV2.jar");
    }

    private void runNewManager(Package pkg) throws UMException {
        File tempUMJarFile = new File(PathUtil.get(SELF_UPDATE_DIR_PATH, "data", MANAGER_PACKAGE_NAME, "PackageManagerV2.jar"));
        logger.info("New Package Manager will start. => " + tempUMJarFile.getAbsolutePath());
        if (!tempUMJarFile.exists()) {
            throw new UMException(ErrorController.ErrorCode.CANNOT_EXECUTE_MANAGER, "The downloaded Package Manager does not exists.");
        }
        try {
            ArrayList<String> commands = new ArrayList<String>();
            String javaHome = System.getProperty("java.home");
            File java = null;
            java = PlatformUtil.isLinux() || PlatformUtil.isMacOS() ? new File(PathUtil.get(javaHome, "bin", "java")) : (PlatformUtil.isWindows() ? new File(PathUtil.get(javaHome, "bin", "java.exe")) : new File(PathUtil.get(javaHome, "bin", "java")));
            String forceBitOption = "-d" + System.getProperty("sun.arch.data.model");
            String jarPath = PathUtil.get(tempUMJarFile.getAbsolutePath());
            if (java != null) {
                if (java.exists()) {
                    commands.add(java.getAbsolutePath());
                } else {
                    commands.add("java");
                }
            }
            if (PlatformUtil.isMacOS()) {
                commands.add("-XstartOnFirstThread");
            }
            commands.add(forceBitOption);
            commands.add("-jar");
            commands.add(jarPath);
            if (Config.executablePath != null) {
                commands.add("-path");
                commands.add(Config.executablePath);
            }
            commands.add("-noJavaVersionCheck");
            logger.trace("\tUpdatable commands => " + commands);
            ProcessBuilder pb = new ProcessBuilder(commands);
            pb.directory(tempUMJarFile.getParentFile());
            pb.start();
        }
        catch (IOException e) {
            logger.throwing(e);
            throw new UMException(ErrorController.ErrorCode.CANNOT_EXECUTE_MANAGER, (Throwable)e);
        }
    }
}

