/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class TextUtil {
    public static String getLeftAlignedTextWithEllipsis(String origText, Control parent, int width) {
        String alignedText = origText;
        GC gc = new GC(parent);
        int textWidth = gc.textExtent((String)alignedText).x;
        int parentWidth = width;
        while (textWidth > parentWidth) {
            int len = alignedText.length();
            alignedText = alignedText.contains("...") ? alignedText.substring(0, len - 4) + "..." : alignedText.substring(0, len - 1) + "...";
            textWidth = gc.textExtent((String)alignedText).x;
        }
        gc.dispose();
        return alignedText;
    }

    public static int getLinesFromText(String origText) {
        Matcher m = Pattern.compile("(\r\n)|(\n)|(\n)").matcher(origText);
        int lines = 1;
        while (m.find()) {
            ++lines;
        }
        return lines;
    }

    public static String getMultilinesText(String origText, Control comp, int width) {
        int i;
        StringBuilder singleline = new StringBuilder();
        StringBuilder multiline = new StringBuilder();
        String returnChar = "\n";
        GC gc = new GC(comp);
        int textWidth = 0;
        int parentWidth = width;
        int tempWidth = 0;
        origText.replaceAll(returnChar, "");
        String[] splitTexts = origText.split(" ");
        for (i = 0; i < splitTexts.length - 1; ++i) {
            singleline.append(splitTexts[i]).append(" ");
            textWidth = gc.textExtent((String)singleline.toString()).x - gc.textExtent((String)" ").x;
            tempWidth = gc.textExtent((String)new StringBuilder().append((String)splitTexts[i + 1]).append((String)" ").toString()).x;
            if (textWidth + tempWidth <= parentWidth) continue;
            textWidth = 0;
            multiline.append((CharSequence)singleline).append(returnChar);
            singleline.delete(0, singleline.length());
        }
        if (i < splitTexts.length) {
            singleline.append(splitTexts[i]);
            multiline.append((CharSequence)singleline);
        }
        gc.dispose();
        return multiline.toString();
    }
}

