/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.uninstaller.ui.wizard;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.tizen.manager.exception.UMException;
import org.tizen.packagemanager.ui.util.WizardUIResourceHandler;
import org.tizen.uninstaller.ui.wizard.WizardPageMaster;

public class WizardUninstallerWindow {
    private WizardUIResourceHandler uiResource;
    private WizardPageMaster pm = null;
    private StackLayout stackLayout = new StackLayout();
    private Shell shell;
    private Display display = Display.getDefault();

    public WizardUninstallerWindow() {
        this.uiResource = WizardUIResourceHandler.getInstance();
        this.shell = new Shell(this.display, 224);
        this.shell.setImage(this.uiResource.getImage(WizardUIResourceHandler.UIIcon.ICON_UNINSTALLER));
    }

    public void run() throws Exception {
        this.createContents();
        this.shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event arg0) {
                arg0.doit = WizardUninstallerWindow.this.pm.sendCloseEvent();
            }
        });
    }

    protected void createContents() throws UMException {
        Rectangle windowSize = this.uiResource.getRect(WizardUIResourceHandler.UISize.WIZARD_SIZE_BASIC);
        Rectangle displayBounds = this.display.getBounds();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors != null && monitors.length >= 1) {
            Monitor monitor = monitors[0];
            Rectangle bounds = monitor.getBounds();
            this.shell.setBounds(bounds.width / 2 - windowSize.width / 2, bounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        } else {
            this.shell.setBounds(displayBounds.width / 2 - windowSize.width / 2, displayBounds.height / 2 - windowSize.height / 2, windowSize.width, windowSize.height);
        }
        this.shell.setSize(windowSize.width, windowSize.height);
        this.shell.setText("Uninstaller");
        FormLayout formLayout = new FormLayout();
        formLayout.marginBottom = 0;
        formLayout.marginTop = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        formLayout.spacing = 0;
        this.shell.setLayout(formLayout);
        Composite pageComposite = new Composite(this.shell, 0x20000000);
        pageComposite.setBounds(this.shell.getBounds());
        pageComposite.setSize(this.shell.getBounds().width, this.shell.getBounds().height);
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        pageComposite.setLayout(this.stackLayout);
        this.pm = new WizardPageMaster(pageComposite, this.stackLayout, this.uiResource);
        this.pm.enablePages(UNINSTALLER_PAGES.READY_PAGE);
    }

    public Shell getShell() {
        return this.shell;
    }

    public static enum UNINSTALLER_PAGES {
        READY_PAGE,
        UNINSTALLING_PAGE,
        COMPLETED_PAGE;

    }
}

