/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.manager.core.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.tizen.manager.core.config.ConfigFile;
import org.tizen.manager.core.config.ProxyConfigFile;
import org.tizen.manager.core.config.RepoHistoryFile;
import org.tizen.manager.core.config.SDKInfo;
import org.tizen.manager.core.model.ImageFileInfo;
import org.tizen.manager.exception.UMException;
import org.tizen.manager.util.Log;
import org.tizen.manager.util.NetworkUtil;
import org.tizen.manager.util.PathUtil;
import org.tizen.manager.util.PlatformUtil;
import org.tizen.manager.util.ResourceUtil;

public class Config {
    public static int timer = 30;
    private static final String MANAGER_CONFIG_DIRECTORY = ".package-manager";
    public static final String IMAGE_EXTRACT_CACHE_DIRECTORY = "image-cache";
    public static final String EXTENSION_CACHE_DIRECTORY = "extension-cache";
    public static final String INFO_DIRECTORY = ".info";
    private static final String MANAGER_VERSION_FILE = "VERSION";
    public static final String REPOSITORY_DISTRIBUTION_INFO_FILE = "distribution.info";
    public static final String REPOSITORY_SNAPSHOT_INFO_FILE = "snapshot.info";
    public static final String EXTENSION_INFO_XML_FILE = "extension_info.xml";
    public static final String ALTERNATIVE_INFO_XML_FILE = "alternative_info.xml";
    private static final String REPOSITORY_DEFAULT_TYPE = "develop";
    private static final String TEMP_DOWNLOAD_DIRECTORY = ".downloads";
    private static final String MANAGER_DEFAULT_REPO_CONFIG_FILE_NAME = "repository.info";
    private static final String PROXY_CONFIGURATION_FILE_NAME = "proxy.conf";
    private static final String INSTALL_MANAGER_IMAGE_DOWNLOAD_DIRECTORY_NAME = "image";
    public static final String PACKAGE_LIST_FILE_LINUX_32 = "pkg_list_ubuntu-32";
    public static final String PACKAGE_LIST_FILE_LINUX_64 = "pkg_list_ubuntu-64";
    public static final String PACKAGE_LIST_FILE_WINDOWS_32 = "pkg_list_windows-32";
    public static final String PACKAGE_LIST_FILE_WINDOWS_64 = "pkg_list_windows-64";
    public static final String PACKAGE_LIST_FILE_MACOS_64 = "pkg_list_macos-64";
    public static final String INSTALLED_PACKAGE_LIST_FILE_NAME = "installedpackage.list";
    public static final String TEMP_DIRECTORY = "temp";
    public static final String DATA_DIRECTORY = "data";
    private String localRepository = "";
    public static ConfDialog fromWhere = ConfDialog.NORMAL;
    public static final int EXITCODE_NORMAL = 0;
    public static final int EXITCODE_ERROR = 4;
    private ConfigFile installedConfigFile = null;
    private ProxyConfigFile proxyConfig = null;
    private RepoHistoryFile repoHistoryFile = null;
    private String managerVersion = null;
    private String mTargetDir = "";
    private String mSdkDataDir = "";
    private static Config config = null;
    private ServerType currentServerType = ServerType.SNAPSHOT;
    private ImageFileInfo currentImageFileInfo = null;
    public static String executablePath = null;
    private static final Logger logger = Log.getLogger(Config.class);

    private Config() {
        this.installedConfigFile = new ConfigFile(Config.getConfigFilePath());
        this.proxyConfig = new ProxyConfigFile();
        this.repoHistoryFile = new RepoHistoryFile();
    }

    public static Config getInstance() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public void init() throws UMException {
        logger.trace("\tLoad installed configuration file. => " + this.installedConfigFile.getConfigPath());
        this.installedConfigFile.load();
        logger.trace("\tSet Package Manager version.");
        this.loadManagerVerion();
        logger.trace("\tLoad proxy configuration.");
        if (Config.getProxyConfFilePath() != null) {
            this.proxyConfig.load(Config.getProxyConfFilePath());
        }
        logger.trace("\tLoad repository history and set current repository history.");
        this.repoHistoryFile.load();
        this.repoHistoryFile.addRepoHistory(this.installedConfigFile.getRepository());
        logger.trace("\tLoad SDK installed path and data path.");
        if (!SDKInfo.getInstalledPath().isEmpty()) {
            this.setTargetDir(SDKInfo.getInstalledPath());
        }
        this.setSdkDatatDir(SDKInfo.getSdkDataPath());
    }

    public static String getManagerConfigHome() {
        if (PlatformUtil.isLinux() || PlatformUtil.isMacOS()) {
            return PathUtil.getFromHome(MANAGER_CONFIG_DIRECTORY);
        }
        if (PlatformUtil.isWindows()) {
            return PathUtil.getFromAppData(MANAGER_CONFIG_DIRECTORY);
        }
        return PathUtil.getFromHome(MANAGER_CONFIG_DIRECTORY);
    }

    public void setTargetDir(String targetDir) {
        this.mTargetDir = targetDir;
    }

    public void setSdkDatatDir(String dataDir) {
        this.mSdkDataDir = dataDir;
    }

    public ConfigFile getConfigFile() {
        return this.installedConfigFile;
    }

    public ProxyConfigFile getProxyConfig() {
        return this.proxyConfig;
    }

    private String[] getSDKRepositories() {
        String repo = this.installedConfigFile.getRepository();
        String[] repos = repo.split(",");
        for (int i = 0; i < repos.length; ++i) {
            repos[i] = repos[i].trim();
        }
        return repos;
    }

    public Collection<String> getSDKRepositoryList() {
        String[] repos = this.getSDKRepositories();
        return Arrays.asList(repos);
    }

    public String getSnapshotPath() {
        return this.installedConfigFile.getSnapshotPath();
    }

    public boolean isAutoUpdate() {
        return this.installedConfigFile.isAutoUpdate();
    }

    public void setSnapshotPath(String snapshotPath) {
        this.installedConfigFile.setSnapshotPath(snapshotPath);
    }

    public String getInstalledSnapshot() {
        return this.installedConfigFile.getInstalledSnapshot();
    }

    public void setInstalledSnapshot(String snapshot) {
        this.installedConfigFile.setInstalledSnapshot(snapshot);
    }

    public String getSDKImageOrigin() {
        return this.installedConfigFile.getSDKImageOrigin();
    }

    public void setSDKImageOrigin(String imageOrigin) {
        this.installedConfigFile.setSDKImageOrigin(imageOrigin);
    }

    public String getDistributionURL() {
        if (this.currentServerType == ServerType.SNAPSHOT) {
            String[] repos = this.getSDKRepositories();
            if (repos.length <= 0) {
                return null;
            }
            for (int i = 0; i < repos.length; ++i) {
                repos[i] = this.addDistribution(repos[i]);
            }
            return repos[0];
        }
        if (this.localRepository.isEmpty()) {
            return this.getSDKImageOrigin();
        }
        return this.localRepository;
    }

    public String getReleaseNoteUrl() {
        return this.installedConfigFile.getReleaseNoteUrl();
    }

    private String addDistribution(String repository) {
        if (repository == null || repository.isEmpty()) {
            return repository;
        }
        String distribution = this.installedConfigFile.getDistribution();
        if (distribution == null || distribution.isEmpty()) {
            return NetworkUtil.getURL(repository, REPOSITORY_DEFAULT_TYPE);
        }
        return NetworkUtil.getURL(repository, distribution);
    }

    public void saveSnapshotSettings(String repository, String distribution, String snapshotPath, String originRepo, String distributionId, boolean isAutoUpdate) {
        if (this.currentServerType == ServerType.SNAPSHOT) {
            if (repository != null && !repository.isEmpty()) {
                this.installedConfigFile.setRepository(repository);
            }
            if (isAutoUpdate) {
                this.installedConfigFile.setAutoUpdate(true);
            } else {
                this.installedConfigFile.setAutoUpdate(false);
            }
            this.installedConfigFile.setSnapshotPath(snapshotPath);
            this.localRepository = "";
        } else {
            File repositoryFile = new File(repository);
            this.localRepository = repositoryFile.toURI().toString();
            this.installedConfigFile.setSnapshotPath("");
            this.installedConfigFile.setAutoUpdate(true);
            if (originRepo != null && !originRepo.isEmpty()) {
                this.installedConfigFile.setRepository(originRepo);
            }
        }
        if (distribution != null && !distribution.isEmpty()) {
            this.installedConfigFile.setDistribution(distribution);
        }
        if (distributionId == null) {
            distributionId = "";
        }
        this.installedConfigFile.setDistributionId(distributionId);
    }

    public void saveProxySettings(ProxyConfigFile.ProxyType proxyType, String proxyHost, String proxyPort) {
        if (proxyType != null) {
            this.proxyConfig.setProxyType(proxyType.toString());
        }
        if (proxyHost != null) {
            this.proxyConfig.setProxyServer(proxyHost);
        }
        if (proxyPort != null) {
            this.proxyConfig.setProxyPort(proxyPort);
        }
    }

    public String getTargetDir() {
        return this.mTargetDir;
    }

    public String getSdkDataDir() {
        return this.mSdkDataDir;
    }

    private void loadManagerVerion() {
        File versionFile = new File(PathUtil.get(PathUtil.getExecutableJarParentDir(), MANAGER_VERSION_FILE));
        this.loadManagerVerionFromFile(versionFile);
        if (this.managerVersion == null) {
            try {
                versionFile = PathUtil.getTempFileFromResource("/VERSION", "im_version", "");
                this.loadManagerVerionFromFile(versionFile);
            }
            catch (IOException e) {
                this.managerVersion = null;
            }
        }
        if (this.managerVersion == null) {
            this.managerVersion = "0.0.0";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManagerVerionFromFile(File versionFile) {
        BufferedReader bReader;
        block6: {
            if (versionFile == null || !versionFile.exists()) {
                return;
            }
            FileReader fReader = null;
            bReader = null;
            String line = "";
            try {
                fReader = new FileReader(versionFile);
                bReader = new BufferedReader(fReader);
                line = bReader.readLine();
                if (line == null) break block6;
                this.managerVersion = line;
                logger.trace("\tCurrent version file path => " + versionFile.getCanonicalPath());
                logger.trace("\tPackage Manager version : " + this.managerVersion);
            }
            catch (Throwable e) {
                try {
                    logger.error(e.getMessage());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ResourceUtil.closeObjectSilently(bReader);
                }
            }
        }
        ResourceUtil.closeObjectSilently(bReader);
    }

    public String getManagerVersion() {
        return this.managerVersion;
    }

    private static String getConfigFilePath() {
        File installedConfFile = new File(PathUtil.getFromInstalledPath(INFO_DIRECTORY, MANAGER_DEFAULT_REPO_CONFIG_FILE_NAME));
        if (installedConfFile.exists()) {
            return installedConfFile.getAbsolutePath();
        }
        logger.error("Cannot get configuration file.(repository.info) => " + installedConfFile.getAbsolutePath());
        return null;
    }

    private static String getProxyConfFilePath() {
        File proxyConfFile = new File(PathUtil.getFromInstalledPath(INFO_DIRECTORY, PROXY_CONFIGURATION_FILE_NAME));
        if (proxyConfFile.exists()) {
            return proxyConfFile.getAbsolutePath();
        }
        return null;
    }

    public void saveConfig() throws UMException {
        String confFilePath = PathUtil.getFromInstalledPath(PathUtil.get(INFO_DIRECTORY, MANAGER_DEFAULT_REPO_CONFIG_FILE_NAME));
        this.installedConfigFile.saveConfig(confFilePath);
    }

    public void saveProxyConfig() throws UMException {
        logger.trace("Save proxy configuration.");
        if (Config.getProxyConfFilePath() == null) {
            File proxyConf = new File(PathUtil.getFromInstalledPath(INFO_DIRECTORY, PROXY_CONFIGURATION_FILE_NAME));
            this.proxyConfig.saveProxyConfig(proxyConf.getAbsolutePath());
        } else {
            this.proxyConfig.saveProxyConfig(Config.getProxyConfFilePath());
        }
    }

    public static String getTempDownloadDirectory() {
        return PathUtil.getFromInstalledPath(INFO_DIRECTORY, TEMP_DOWNLOAD_DIRECTORY);
    }

    public String getDownloadPkgPath() {
        String repository = null;
        if (this.currentServerType == ServerType.LOCAL) {
            repository = INSTALL_MANAGER_IMAGE_DOWNLOAD_DIRECTORY_NAME;
        } else {
            String repo = this.getConfigFile().getRepository();
            String distribution = this.getConfigFile().getDistribution();
            repository = NetworkUtil.getURL(repo, distribution);
        }
        String encodeRepository = null;
        try {
            encodeRepository = URLEncoder.encode(repository, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.throwing(e);
            return encodeRepository;
        }
        return PathUtil.get(Config.getTempDownloadDirectory(), encodeRepository);
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public ArrayList<String> getRepoHistory() {
        return this.repoHistoryFile.getRepoHistory();
    }

    public void addRepoHistory(String changeServerUrl) {
        this.repoHistoryFile.addRepoHistory(changeServerUrl);
    }

    public void setServerType(ServerType sType) {
        this.currentServerType = sType;
    }

    public ServerType getServerType() {
        return this.currentServerType;
    }

    public void setImageFileInfo(ImageFileInfo info) {
        this.currentImageFileInfo = info;
    }

    public ImageFileInfo getImageFileInfo() {
        return this.currentImageFileInfo;
    }

    public static enum ServerType {
        SNAPSHOT("snapshot"),
        LOCAL("local");

        private String type = "";

        private ServerType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static enum ConfDialog {
        NORMAL,
        SNAPSHOT,
        LOCAL_IMAGE;

    }
}

